/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.impl.fZ;
import com.jumpmind.symmetric.console.impl.gR;
import com.jumpmind.symmetric.console.model.ConsoleEvent;
import com.jumpmind.symmetric.console.model.Monitor;
import com.jumpmind.symmetric.console.model.MonitorEvent;
import com.jumpmind.symmetric.console.service.IConsoleEventService;
import com.jumpmind.symmetric.console.ui.common.as;
import java.lang.invoke.CallSite;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;

public class gn
implements fZ,
IBuiltInExtensionPoint,
ISymmetricEngineAware {
    private ISymmetricEngine a;

    @Override
    public MonitorEvent a(Monitor monitor) {
        long[] threadIds;
        MonitorEvent event = new MonitorEvent();
        HashMap<CallSite, Integer> methodCounts = new HashMap<CallSite, Integer>();
        int blockedCount = 0;
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        for (long threadId : threadIds = threadBean.getAllThreadIds()) {
            String methodName;
            ThreadInfo info = threadBean.getThreadInfo(threadId, 1);
            if (info == null) continue;
            StackTraceElement[] elements = info.getStackTrace();
            if (elements != null && elements.length > 0 && info.getThreadState() == Thread.State.RUNNABLE && !(methodName = elements[0].getClassName() + "." + elements[0].getMethodName() + "():" + elements[0].getLineNumber()).startsWith("java") && !methodName.startsWith("sun")) {
                Integer count = (Integer)methodCounts.get(methodName);
                count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
                methodCounts.put((CallSite)((Object)methodName), count);
            }
            if (info.getThreadState() != Thread.State.BLOCKED) continue;
            ++blockedCount;
        }
        int highestCount = 1;
        String methodNameWithHighestCount = null;
        for (String methodName : methodCounts.keySet()) {
            int count = (Integer)methodCounts.get(methodName);
            if (count <= highestCount) continue;
            highestCount = count;
            methodNameWithHighestCount = methodName;
        }
        gR recommendation = null;
        if (blockedCount > highestCount || blockedCount == 1 && highestCount == 1) {
            event.setValue(blockedCount);
            String problemDescription = "There are " + blockedCount + " threads that are blocked waiting for a lock.  This may suggest a bottleneck.";
            String actionDescription = "Use the Manage -> JVM Threads screen to find blocked threads.";
            recommendation = new gR(problemDescription, actionDescription, true);
        } else if (highestCount > 1) {
            event.setValue(highestCount);
            String problemDescription = blockedCount >= highestCount - 1 ? "There are " + highestCount + " threads calling the same method " + methodNameWithHighestCount + " because there is a lock.  This may suggest a bottleneck." : "There are " + highestCount + " threads calling the same method " + methodNameWithHighestCount + ".  This may suggest a bottleneck.";
            String actionDescription = "Take a support snapshot and send it to support@jumpmind.com.";
            recommendation = new gR(problemDescription, actionDescription, true);
        } else {
            event.setValue(0L);
        }
        if (recommendation != null) {
            ArrayList<gR.a> options = new ArrayList<gR.a>();
            gR gR2 = recommendation;
            Objects.requireNonNull(gR2);
            options.add(gR2.new gR.a(1, "Take a support snapshot and restart SymmetricDS"));
            recommendation.a(options);
            event.setDetails(as.getMonitorEventGson().toJson((Object)recommendation));
        }
        return event;
    }

    @Override
    public boolean a(MonitorEvent event, gR recommendation) {
        String snapshotName = this.a.snapshot(null).toString();
        IConsoleEventService consoleEventService = (IConsoleEventService)this.a.getExtensionService().getExtensionPoint(IConsoleEventService.class);
        String userId = event.getApprovedBy();
        String nodeId = this.a.getNodeId();
        consoleEventService.addEvent(new ConsoleEvent(userId, "Take Snapshot", nodeId, nodeId, null, snapshotName));
        as.restartSymmetric(this.a, userId, "JVM Threads insight approval");
        return true;
    }

    @Override
    public String b() {
        return "jvmThreads";
    }

    @Override
    public boolean a() {
        return false;
    }

    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.a = engine;
    }
}

