/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.impl.fZ;
import com.jumpmind.symmetric.console.impl.gR;
import com.jumpmind.symmetric.console.impl.gW;
import com.jumpmind.symmetric.console.impl.gX;
import com.jumpmind.symmetric.console.impl.gY;
import com.jumpmind.symmetric.console.model.Monitor;
import com.jumpmind.symmetric.console.model.MonitorEvent;
import com.jumpmind.symmetric.console.ui.common.as;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.Strings;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class gm
implements fZ,
IBuiltInExtensionPoint,
ISymmetricEngineAware {
    protected static final long a = 86400000L;
    private Logger c = LoggerFactory.getLogger(this.getClass());
    private ISymmetricEngine d;
    protected final SimpleDateFormat b = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @Override
    public MonitorEvent a(Monitor monitor) {
        MonitorEvent event = new MonitorEvent();
        gY result = gW.a(new gX(gX.a.WRAPPER, new Date(System.currentTimeMillis() - 86400000L), null, "java.lang.OutOfMemoryError", 0L));
        if (result.b()) {
            long oomCount = result.c();
            String oomDateTime = result.e();
            event.setValue(oomCount);
            if (oomDateTime != null) {
                String problemDescription = "Out of memory error on " + oomDateTime + ".";
                if (oomCount > 1L) {
                    problemDescription = problemDescription + "  There have been " + oomCount + " out of memory errors in the last 24 hours.";
                }
                String actionDescription = "Increase maximum memory by editing the wrapper.java.maxmemory property in conf/sym_service.conf and restarting SymmetricDS.";
                gR recommendation = new gR(problemDescription, actionDescription, true);
                ArrayList<gR.a> options = new ArrayList<gR.a>();
                gR gR2 = recommendation;
                Objects.requireNonNull(gR2);
                options.add(gR2.new gR.a(1, "Increase by 0.5 GB", 512L));
                gR gR3 = recommendation;
                Objects.requireNonNull(gR3);
                options.add(gR3.new gR.a(2, "Increase by 1 GB", 1024L));
                gR gR4 = recommendation;
                Objects.requireNonNull(gR4);
                options.add(gR4.new gR.a(3, "Increase by 1.5 GB", 1532L));
                gR gR5 = recommendation;
                Objects.requireNonNull(gR5);
                options.add(gR5.new gR.a(4, "Increase by 2 GB", 2048L));
                recommendation.a(options);
                event.setDetails(as.getMonitorEventGson().toJson((Object)recommendation));
            }
        } else {
            event.setValue(0L);
        }
        return event;
    }

    @Override
    public boolean a(MonitorEvent event, gR recommendation) {
        block19: {
            File serviceConfFile;
            long increaseAmount = 512L;
            if (event.getApprovedOption() > 1) {
                increaseAmount = recommendation.a(event.getApprovedOption());
            }
            if ((serviceConfFile = new File("conf/sym_service.conf")).exists()) {
                StringBuilder fileContents = new StringBuilder(256);
                try (BufferedReader reader = new BufferedReader(new FileReader(serviceConfFile));){
                    String line = reader.readLine();
                    do {
                        if (line == null) continue;
                        if (Strings.CI.contains((CharSequence)line, (CharSequence)"wrapper.java.maxmemory=")) {
                            int currentMaxMemory = Integer.parseInt(line.substring(line.indexOf("=") + 1));
                            fileContents.append(String.format("%s%n", "wrapper.java.maxmemory=" + ((long)currentMaxMemory + increaseAmount)));
                            continue;
                        }
                        fileContents.append(String.format("%s%n", line));
                    } while ((line = reader.readLine()) != null);
                    reader.close();
                }
                catch (Exception ex2) {
                    this.c.error("Failed to read conf/sym_service.conf when approving JVM Out of Memory insight", (Throwable)ex2);
                    return false;
                }
                try (PrintWriter writer = new PrintWriter(serviceConfFile);){
                    writer.println(fileContents);
                    writer.close();
                    break block19;
                }
                catch (Exception ex3) {
                    this.c.error("Failed to write to conf/sym_service.conf when approving JVM Out of Memory insight", (Throwable)ex3);
                    return false;
                }
            }
            this.c.error("Failed to approve JVM Out of Memory insight. The conf/sym_service.conf file does not exist.");
            return false;
        }
        as.restartSymmetric(this.d, event.getApprovedBy(), "JVM Out of Memory insight approval");
        return true;
    }

    @Override
    public String b() {
        return "jvmOutOfMemory";
    }

    @Override
    public boolean a() {
        return false;
    }

    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.d = engine;
    }
}

