/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.jumpmind.symmetric.console.impl.fZ;
import com.jumpmind.symmetric.console.impl.gR;
import com.jumpmind.symmetric.console.model.Monitor;
import com.jumpmind.symmetric.console.model.MonitorEvent;
import com.jumpmind.symmetric.console.service.IMonitorService;
import com.jumpmind.symmetric.console.ui.common.as;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;
import org.jumpmind.symmetric.statistic.JobStats;

public class gj
implements fZ,
IBuiltInExtensionPoint,
ISymmetricEngineAware {
    private ISymmetricEngine a;

    @Override
    public MonitorEvent a(Monitor monitor) {
        MonitorEvent event = new MonitorEvent();
        List jobStatsList = this.a.getStatisticService().getJobStatsForNode(this.a.getNodeId());
        jobStatsList.sort((s0, s1) -> s1.getStartTime().compareTo(s0.getStartTime()));
        if (!jobStatsList.isEmpty()) {
            HashMap runtimesByJobMap = new HashMap();
            HashMap<String, ArrayList<Long>> ratesByJobMap = new HashMap<String, ArrayList<Long>>();
            for (JobStats stats : jobStatsList) {
                String jobName = stats.getJobName();
                ArrayList<Long> runtimeList = (ArrayList<Long>)runtimesByJobMap.get(jobName);
                if (runtimeList == null) {
                    runtimeList = new ArrayList<Long>();
                }
                long runtime = stats.getEndTime().getTime() - stats.getStartTime().getTime();
                runtimeList.add(runtime);
                runtimesByJobMap.put(jobName, runtimeList);
                ArrayList<Long> rateList = (ArrayList<Long>)ratesByJobMap.get(jobName);
                if (rateList == null) {
                    rateList = new ArrayList<Long>();
                }
                rateList.add(runtime >= 60000L ? stats.getProcessedCount() / (runtime / 60000L) : -1L);
                ratesByJobMap.put(jobName, rateList);
            }
            IMonitorService monitorService = (IMonitorService)this.a.getExtensionService().getExtensionPoint(IMonitorService.class);
            Date now = new Date();
            List unresolvedJobDetailsList = null;
            Gson gson = as.getMonitorEventGson();
            for (MonitorEvent existingEvent : monitorService.getMonitorEventsByMonitorId(monitor.getMonitorId())) {
                Date notBefore = existingEvent.getNotBefore();
                if (existingEvent.isResolved() || notBefore != null && notBefore.after(now) || !existingEvent.getNodeId().equals(this.a.getNodeId())) continue;
                gR recommendation = (gR)gson.fromJson(existingEvent.getDetails(), gR.class);
                List list = (List)recommendation.c("jobDetailsList");
                Type jobDetailsListType = new TypeToken<List<a>>(){}.getType();
                unresolvedJobDetailsList = (List)gson.fromJson(gson.toJson((Object)list, jobDetailsListType), jobDetailsListType);
                break;
            }
            long largestPeakRuntimePercentIncrease = 0L;
            ArrayList<a> jobDetailsList = new ArrayList<a>();
            for (Map.Entry entry : runtimesByJobMap.entrySet()) {
                String jobName = (String)entry.getKey();
                List runtimeList = (List)entry.getValue();
                int runtimeCount = runtimeList.size();
                if (runtimeCount < 100 && (runtimeCount < 10 || jobName.equals("Routing") || jobName.equals("Push") || jobName.equals("Pull"))) continue;
                long latestRuntime = (Long)runtimeList.get(0);
                if (unresolvedJobDetailsList != null) {
                    a detailsToAdd = null;
                    for (a details : unresolvedJobDetailsList) {
                        if (!details.a().equals(jobName)) continue;
                        long peakRuntime = details.b();
                        long peakRuntimePercentIncrease = (latestRuntime - peakRuntime) * 100L / peakRuntime;
                        if (peakRuntimePercentIncrease <= monitor.getThreshold()) break;
                        detailsToAdd = details;
                        detailsToAdd.a(peakRuntimePercentIncrease);
                        Long averageRuntime = details.c();
                        detailsToAdd.b((latestRuntime - averageRuntime) * 100L / averageRuntime);
                        Long averageRate = details.d();
                        if (averageRate > 0L) {
                            List rateList = (List)ratesByJobMap.get(jobName);
                            detailsToAdd.c(((Long)rateList.get(0) - averageRate) * 100L / averageRate);
                        }
                        jobDetailsList.add(detailsToAdd);
                        if (peakRuntimePercentIncrease <= largestPeakRuntimePercentIncrease) break;
                        largestPeakRuntimePercentIncrease = peakRuntimePercentIncrease;
                        break;
                    }
                    if (detailsToAdd != null) continue;
                }
                long peakRuntime = 0L;
                long averageRuntime = 0L;
                for (int i2 = 1; i2 < runtimeCount; ++i2) {
                    long runtime = (Long)runtimeList.get(i2);
                    if (runtime > peakRuntime) {
                        peakRuntime = runtime;
                    }
                    averageRuntime += runtime;
                }
                if (peakRuntime == 0L) continue;
                long peakRuntimePercentIncrease = (latestRuntime - peakRuntime) * 100L / peakRuntime;
                if (peakRuntimePercentIncrease > monitor.getThreshold()) {
                    long averageRuntimePercentIncrease = (latestRuntime - (averageRuntime /= (long)(runtimeList.size() - 1))) * 100L / averageRuntime;
                    List rateList = (List)ratesByJobMap.get(jobName);
                    int validRateCount = 0;
                    long averageRate = 0L;
                    for (int i3 = 1; i3 < rateList.size(); ++i3) {
                        long rate = (Long)rateList.get(i3);
                        if (rate < 0L) continue;
                        averageRate += rate;
                        ++validRateCount;
                    }
                    Long averageRatePercentIncrease = null;
                    if (validRateCount > 0 && averageRate / (long)validRateCount > 0L) {
                        averageRatePercentIncrease = ((Long)rateList.get(0) - (averageRate /= (long)validRateCount)) * 100L / averageRate;
                    }
                    jobDetailsList.add(new a(jobName, peakRuntime, averageRuntime, averageRate, peakRuntimePercentIncrease, averageRuntimePercentIncrease, averageRatePercentIncrease));
                }
                if (peakRuntimePercentIncrease <= largestPeakRuntimePercentIncrease) continue;
                largestPeakRuntimePercentIncrease = peakRuntimePercentIncrease;
            }
            event.setValue(largestPeakRuntimePercentIncrease);
            Object problemDescription = "";
            for (a details : jobDetailsList) {
                problemDescription = (String)problemDescription + "The " + details.a() + " job took " + details.e() + "% longer than the previous peak runtime and " + details.f() + "% longer than the average runtime.";
                Long averageRatePercentIncrease = details.g();
                if (averageRatePercentIncrease == null) {
                    problemDescription = (String)problemDescription + "\n";
                    continue;
                }
                if (averageRatePercentIncrease > 0L) {
                    problemDescription = (String)problemDescription + " Its processing rate is " + averageRatePercentIncrease + "% slower than average.\n";
                    continue;
                }
                if (averageRatePercentIncrease < 0L) {
                    problemDescription = (String)problemDescription + " Its processing rate is " + Math.abs(averageRatePercentIncrease) + "% faster than average.\n";
                    continue;
                }
                problemDescription = (String)problemDescription + " Its processing rate is the same as the average.\n";
            }
            if (problemDescription != null) {
                gR gR2 = new gR(((String)problemDescription).trim(), null, false);
                gR2.a("jobDetailsList", jobDetailsList);
                event.setDetails(as.getMonitorEventGson().toJson((Object)gR2));
            }
        }
        return event;
    }

    @Override
    public boolean a(MonitorEvent event, gR recommendation) {
        return true;
    }

    @Override
    public String b() {
        return "jobTrending";
    }

    @Override
    public boolean a() {
        return true;
    }

    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.a = engine;
    }

    class a {
        private String b;
        private Long c;
        private Long d;
        private Long e;
        private Long f;
        private Long g;
        private Long h;

        public a(String jobName, Long peakRuntime, Long averageRuntime, Long averageRate, Long peakRuntimePercentIncrease, Long averageRuntimePercentIncrease, Long averageRatePercentIncrease) {
            this.b = jobName;
            this.c = peakRuntime;
            this.d = averageRuntime;
            this.e = averageRate;
            this.f = peakRuntimePercentIncrease;
            this.g = averageRuntimePercentIncrease;
            this.h = averageRatePercentIncrease;
        }

        public String a() {
            return this.b;
        }

        public Long b() {
            return this.c;
        }

        public Long c() {
            return this.d;
        }

        public Long d() {
            return this.e;
        }

        public Long e() {
            return this.f;
        }

        public void a(Long peakRuntimePercentIncrease) {
            this.f = peakRuntimePercentIncrease;
        }

        public Long f() {
            return this.g;
        }

        public void b(Long averageRuntimePercentIncrease) {
            this.g = averageRuntimePercentIncrease;
        }

        public Long g() {
            return this.h;
        }

        public void c(Long averageRatePercentIncrease) {
            this.h = averageRatePercentIncrease;
        }
    }
}

