/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.impl.fZ;
import com.jumpmind.symmetric.console.impl.gR;
import com.jumpmind.symmetric.console.model.ConsoleEvent;
import com.jumpmind.symmetric.console.model.Monitor;
import com.jumpmind.symmetric.console.model.MonitorEvent;
import com.jumpmind.symmetric.console.service.IConsoleEventService;
import com.jumpmind.symmetric.console.service.IMonitorService;
import com.jumpmind.symmetric.console.ui.common.as;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.Strings;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.util.LogSummaryAppenderUtils;
import org.jumpmind.util.LogSummary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class gg
implements fZ,
IBuiltInExtensionPoint,
ISymmetricEngineAware {
    private ISymmetricEngine a;
    private Logger b = LoggerFactory.getLogger(this.getClass());

    @Override
    public MonitorEvent a(Monitor monitor) {
        MonitorEvent event = new MonitorEvent();
        Date notBefore = ((IMonitorService)this.a.getExtensionService().getExtensionPoint(IMonitorService.class)).getLastApprovalTime(monitor.getMonitorId(), this.b());
        IConfigurationService configService = this.a.getConfigurationService();
        List logSummaryList = LogSummaryAppenderUtils.getLogSummaryErrors((String)this.a.getEngineName());
        HashMap<String, String> channelIdMap = new HashMap<String, String>();
        for (LogSummary logSummary : logSummaryList) {
            String channelId;
            Channel channel;
            String message = logSummary.getMessage();
            if (!notBefore.before(new Date(logSummary.getMostRecentTime())) || message == null || !message.startsWith("Failed to extract batch") || !Strings.CI.contains((CharSequence)message, (CharSequence)"Connection reset") && !Strings.CI.contains((CharSequence)logSummary.getStackTrace(), (CharSequence)"Connection reset")) continue;
            int startIndex = message.indexOf("on channel '") + 12;
            int endIndex = message.indexOf("'", startIndex);
            if (startIndex <= 11 || endIndex <= startIndex || (channel = configService.getChannel(channelId = message.substring(startIndex, endIndex))) == null || channel.getMaxBatchToSend() <= 1) continue;
            channelIdMap.put(channelId, String.valueOf(channel.getMaxBatchToSend() / 2));
        }
        int channelIdCount = channelIdMap.size();
        event.setValue(channelIdCount);
        if (channelIdCount > 0) {
            String optionDescription;
            String problemDescription;
            if (channelIdCount == 1) {
                String channelId = (String)channelIdMap.keySet().iterator().next();
                problemDescription = "A connection reset error occurred on the '" + channelId + "' channel.";
                optionDescription = "Reduce the max batch to send by 50% for the '" + channelId + "' channel";
            } else {
                problemDescription = "A connection reset error occurred on the following channels: " + String.valueOf(channelIdMap.keySet()) + ".";
                optionDescription = "Reduce the max batch to send by 50% for the following channels: " + String.valueOf(channelIdMap.keySet());
            }
            String actionDescription = "Reduce the max batch to send by 50%.";
            gR recommendation = new gR(problemDescription, actionDescription, true);
            ArrayList<gR.a> options = new ArrayList<gR.a>();
            gR gR2 = recommendation;
            Objects.requireNonNull(gR2);
            options.add(gR2.new gR.a(1, optionDescription));
            recommendation.a(options);
            recommendation.a("channelIdMap", channelIdMap);
            event.setDetails(as.getMonitorEventGson().toJson((Object)recommendation));
        }
        return event;
    }

    @Override
    public boolean a(MonitorEvent event, gR recommendation) {
        Map channelIdMap = (Map)recommendation.c("channelIdMap");
        if (channelIdMap != null) {
            IConfigurationService configService = this.a.getConfigurationService();
            for (String channelId : channelIdMap.keySet()) {
                Channel channel = configService.getChannel(channelId);
                if (channel == null) continue;
                channel.setMaxBatchToSend(Integer.valueOf((String)channelIdMap.get(channelId)).intValue());
                configService.saveChannel(channel, true);
            }
            IConsoleEventService consoleEventService = (IConsoleEventService)this.a.getExtensionService().getExtensionPoint(IConsoleEventService.class);
            String nodeId = this.a.getNodeId();
            consoleEventService.addEvent(new ConsoleEvent(event.getApprovedBy(), "Channel Modified", nodeId, nodeId, null, channelIdMap.keySet().toString()));
            return true;
        }
        this.b.error("Failed to approve Connection Reset insight because channel ID map was null.");
        return false;
    }

    @Override
    public String b() {
        return "connectionReset";
    }

    @Override
    public boolean a() {
        return false;
    }

    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.a = engine;
    }
}

