/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.impl.fX;
import com.jumpmind.symmetric.console.impl.hh;
import com.jumpmind.symmetric.console.model.Monitor;
import com.jumpmind.symmetric.console.model.MonitorEvent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SystemUtils;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class gC
extends fX
implements IBuiltInExtensionPoint {
    protected final Logger d = LoggerFactory.getLogger((String)new hh(new long[]{-8805100097329059219L, 460257445400826471L, 6752041828116098195L}).toString());
    protected OperatingSystemMXBean e = ManagementFactory.getOperatingSystemMXBean();
    protected RuntimeMXBean f = ManagementFactory.getRuntimeMXBean();
    protected List<StackTraceElement> g = new ArrayList<StackTraceElement>();
    protected boolean h = true;

    public gC() {
        this.g.add(new StackTraceElement("java.lang.Object", "wait", null, 0));
        this.g.add(new StackTraceElement("sun.misc.Unsafe", "park", null, 0));
        this.g.add(new StackTraceElement("sun.nio.ch.EPollArrayWrapper", "epollWait", null, 0));
        this.g.add(new StackTraceElement("java.lang.Thread", "sleep", null, 0));
        this.g.add(new StackTraceElement("sun.management.ThreadImpl", "getThreadInfo1", null, 0));
        this.g.add(new StackTraceElement("sun.nio.ch.ServerSocketChannelImpl", "accept", null, 0));
        this.g.add(new StackTraceElement("sun.nio.ch.ServerSocketChannelImpl", "accept0", null, 0));
    }

    @Override
    public String b() {
        return "cpu";
    }

    @Override
    public MonitorEvent a(Monitor monitor) {
        MonitorEvent event = new MonitorEvent();
        int cpuUsage = this.c();
        this.d.debug("CPU usage is {}", (Object)cpuUsage);
        event.setValue(cpuUsage);
        event.setDetails(this.a((long)cpuUsage, 0L, 0L));
        return event;
    }

    public int c() {
        int availableProcessors = this.e.getAvailableProcessors();
        this.d.debug("Found {} available processors", (Object)availableProcessors);
        if (this.h) {
            String line = null;
            long pid = ProcessHandle.current().pid();
            try {
                String[] fields;
                if (SystemUtils.IS_OS_WINDOWS) {
                    line = this.a(3, "C:\\Windows\\System32\\WindowsPowerShell\\v1.0\\powershell.exe", "-Command", "Get-WmiObject -Query \\\"Select * from Win32_PerfFormattedData_PerfProc_Process where IDProcess = " + pid + "\\\" | Select-Object -Property PercentProcessorTime");
                    if (line != null) {
                        return Math.min(Integer.parseInt(line.replace(" ", "")), 100);
                    }
                } else if (SystemUtils.IS_OS_MAC) {
                    String[] fields2;
                    line = this.a(25, "top", "-l2", "-pid", String.valueOf(pid));
                    if (line != null && (fields2 = line.trim().split("\\s+")).length > 2) {
                        return Math.min(Math.round(Float.parseFloat(fields2[2]) / (float)availableProcessors), 100);
                    }
                } else if (SystemUtils.IS_OS_LINUX && (line = this.a(7, "top", "-bn1", "-p", String.valueOf(pid))) != null && (fields = line.trim().split("\\s+")).length > 9) {
                    return Math.min(Math.round(Float.parseFloat(fields[8]) / (float)availableProcessors), 100);
                }
                this.h = false;
            }
            catch (NoClassDefFoundError e2) {
                this.h = false;
            }
            catch (RuntimeException e3) {
                this.d.info("Cannot parse native command line output because \"{}: {}\".  Output was: \"{}\"", new Object[]{e3.getClass().getName(), e3.getMessage(), line});
                this.h = false;
            }
            if (!this.h) {
                this.d.info("Switching to CPU time based on JMX");
            }
        }
        long prevUpTime = this.f.getUptime();
        long prevProcessCpuTime = this.d();
        try {
            Thread.sleep(500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        long upTime = this.f.getUptime();
        long processCpuTime = this.d();
        long elapsedCpu = processCpuTime - prevProcessCpuTime;
        long elapsedTime = upTime - prevUpTime;
        return Math.min((int)((float)elapsedCpu / ((float)elapsedTime * 1000.0f * (float)availableProcessors)), 100);
    }

    protected long d() {
        long cpuTime = 0L;
        try {
            Method method = this.e.getClass().getMethod("getProcessCpuTime", new Class[0]);
            method.setAccessible(true);
            cpuTime = (Long)method.invoke((Object)this.e, new Object[0]);
        }
        catch (Exception ignore) {
            this.d.debug("Caught exception", (Throwable)ignore);
        }
        return cpuTime;
    }

    protected String a(int lineNumber, String ... args) {
        String ret = null;
        ArrayList<String> cmd = new ArrayList<String>();
        for (String arg : args) {
            cmd.add(arg);
        }
        this.d.debug("Running command: {}", cmd);
        ProcessBuilder pb = new ProcessBuilder(cmd);
        pb.redirectErrorStream(true);
        Process process = null;
        try {
            process = pb.start();
            process.waitFor();
        }
        catch (Exception e2) {
            this.d.info("Cannot execute native command line {}: {}", cmd, (Object)e2.getMessage());
        }
        if (process != null) {
            ArrayList<String> cmdOutput = new ArrayList<String>();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line = null;
                while ((line = reader.readLine()) != null) {
                    cmdOutput.add(line);
                }
            }
            catch (Exception e3) {
                this.d.info("Cannot parse native command line {}: {}", cmd, (Object)e3.getMessage());
            }
            if (cmdOutput != null && cmdOutput.size() > lineNumber) {
                ret = (String)cmdOutput.get(lineNumber);
            }
        }
        return ret;
    }

    protected String a(long value, long threshold, long period) {
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        StringBuilder text = new StringBuilder("CPU usage is at ");
        text.append(value).append("%").append(System.lineSeparator()).append(System.lineSeparator());
        Map<ThreadInfo, Float> cpuUsageByThreadMap = this.e();
        Iterator<Map.Entry<ThreadInfo, Float>> iterator = cpuUsageByThreadMap.entrySet().iterator();
        for (int i2 = 0; i2 < cpuUsageByThreadMap.size() && i2 < 3; ++i2) {
            Map.Entry<ThreadInfo, Float> cpuUsageByThreadEntry = iterator.next();
            ThreadInfo entryInfo = cpuUsageByThreadEntry.getKey();
            ThreadInfo info = threadBean.getThreadInfo(entryInfo.getThreadId(), 30);
            if (info == null) continue;
            DecimalFormat percentFormat = new DecimalFormat();
            percentFormat.setMaximumFractionDigits(2);
            text.append("Top #").append(i2 + 1).append(" CPU thread ").append(entryInfo.getThreadName()).append(" (ID ").append(entryInfo.getThreadId()).append(") is using ").append(percentFormat.format(cpuUsageByThreadEntry.getValue())).append("%").append(System.lineSeparator());
            text.append(this.a(info)).append(System.lineSeparator()).append(System.lineSeparator());
        }
        return text.toString();
    }

    protected Map<ThreadInfo, Float> e() {
        ThreadInfo[] threadInfos;
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        HashMap<Long, Long> initialCpuTimeByThreadMap = new HashMap<Long, Long>();
        long initialUptime = this.f.getUptime();
        for (ThreadInfo threadInfo : threadInfos = threadBean.dumpAllThreads(false, false)) {
            StackTraceElement[] trace = threadInfo.getStackTrace();
            boolean ignore = false;
            if (trace != null && trace.length > 0) {
                for (StackTraceElement element : this.g) {
                    if (!trace[0].getClassName().equals(element.getClassName()) || !trace[0].getMethodName().equals(element.getMethodName())) continue;
                    ignore = true;
                    break;
                }
            }
            if (ignore) continue;
            initialCpuTimeByThreadMap.put(threadInfo.getThreadId(), threadBean.getThreadCpuTime(threadInfo.getThreadId()));
        }
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        long uptime = this.f.getUptime();
        HashMap<Long, Long> currentCpuTimeByThreadMap = new HashMap<Long, Long>();
        for (ThreadInfo info : threadInfos = threadBean.dumpAllThreads(false, false)) {
            currentCpuTimeByThreadMap.put(info.getThreadId(), threadBean.getThreadCpuTime(info.getThreadId()));
        }
        int n2 = this.e.getAvailableProcessors();
        long elapsedTime = uptime - initialUptime;
        HashMap<ThreadInfo, Float> cpuUsageByThreadMap = new HashMap<ThreadInfo, Float>();
        for (ThreadInfo info : threadInfos) {
            Long initialCpuTime = (Long)initialCpuTimeByThreadMap.get(info.getThreadId());
            if (initialCpuTime == null) continue;
            long elapsedCpuTime = (Long)currentCpuTimeByThreadMap.get(info.getThreadId()) - initialCpuTime;
            float cpuUsage = (float)elapsedCpuTime / ((float)elapsedTime * 10000.0f * (float)n2);
            cpuUsageByThreadMap.put(info, Float.valueOf(cpuUsage));
        }
        return cpuUsageByThreadMap.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (val0, val1) -> val0, LinkedHashMap::new));
    }

    @Override
    public boolean a() {
        return false;
    }
}

