/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.alter.AddColumnChange;
import org.jumpmind.db.alter.ColumnAutoIncrementChange;
import org.jumpmind.db.alter.ColumnDataTypeChange;
import org.jumpmind.db.alter.ColumnDefaultValueChange;
import org.jumpmind.db.alter.ColumnRequiredChange;
import org.jumpmind.db.alter.ColumnSizeChange;
import org.jumpmind.db.alter.RemoveColumnChange;
import org.jumpmind.db.alter.TableChange;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.AbstractDdlBuilder;

public class fi
extends AbstractDdlBuilder {
    protected static final String a = "TRG";
    protected static final String b = "SEQ";

    public fi(String databaseName) {
        super(databaseName);
        this.databaseInfo.setMaxIdentifierLength(32);
        this.databaseInfo.setDelimiterToken("\"");
        this.databaseInfo.addNativeTypeMapping(2003, "BLOB", -4);
        this.databaseInfo.addNativeTypeMapping(-7, "BIT");
        this.databaseInfo.addNativeTypeMapping(2004, "BLOB", -4);
        this.databaseInfo.addNativeTypeMapping(2005, "LVARCHAR", -1);
        this.databaseInfo.addNativeTypeMapping(3, "NUMBER", 2);
        this.databaseInfo.addNativeTypeMapping(2001, "BLOB", -4);
        this.databaseInfo.addNativeTypeMapping(8, "DOUBLE PRECISION", 8);
        this.databaseInfo.addNativeTypeMapping(6, "FLOAT", 8);
        this.databaseInfo.addNativeTypeMapping(2000, "BLOB", -4);
        this.databaseInfo.addNativeTypeMapping(-4, "LVARBINARY", -4);
        this.databaseInfo.addNativeTypeMapping(-1, "LVARCHAR", -1);
        this.databaseInfo.addNativeTypeMapping(0, "BLOB", -4);
        this.databaseInfo.addNativeTypeMapping(1111, "BLOB", -4);
        this.databaseInfo.addNativeTypeMapping(2006, "BLOB", -4);
        this.databaseInfo.addNativeTypeMapping(2002, "BLOB", -4);
        this.databaseInfo.addNativeTypeMapping(-101, "TIMESTAMP WITH TIME ZONE");
        this.databaseInfo.addNativeTypeMapping(-102, "TIMESTAMP WITH TIME ZONE", -101);
        this.databaseInfo.addNativeTypeMapping("BOOLEAN", "BIT", "BIT");
        this.databaseInfo.addNativeTypeMapping("DATALINK", "BLOB", "LONGVARBINARY");
        this.databaseInfo.addNativeTypeMapping(-9, "VARCHAR", 12);
        this.databaseInfo.addNativeTypeMapping(-16, "LVARCHAR", -1);
        this.databaseInfo.addNativeTypeMapping(-15, "CHAR", 1);
        this.databaseInfo.setDefaultSize(1, 1);
        this.databaseInfo.setDefaultSize(12, 1);
        this.databaseInfo.setDefaultSize(-2, 1);
        this.databaseInfo.setDefaultSize(-3, 1);
        this.databaseInfo.setHasNullDefault(-1, false);
        this.databaseInfo.setHasNullDefault(-4, false);
        this.databaseInfo.setHasNullDefault(2005, false);
        this.databaseInfo.setHasNullDefault(2004, false);
        this.databaseInfo.setTriggersContainJava(true);
        this.databaseInfo.setDefaultValuesForLongTypesSupported(false);
        this.databaseInfo.setNonBlankCharColumnSpacePadded(true);
        this.databaseInfo.setBlankCharColumnSpacePadded(true);
        this.databaseInfo.setCharColumnSpaceTrimmed(true);
        this.databaseInfo.setEmptyStringNulled(false);
        this.databaseInfo.setRequiresAutoCommitForDdl(true);
        this.databaseInfo.setBinaryQuoteStart("x '");
        this.databaseInfo.setBinaryQuoteEnd("'");
    }

    protected String getFullyQualifiedTableNameShorten(Table table) {
        Object result = "";
        if (StringUtils.isNotBlank((CharSequence)table.getSchema())) {
            result = (String)result + this.getDelimitedIdentifier(table.getSchema()).concat(this.databaseInfo.getSchemaSeparator());
        }
        result = (String)result + this.getDelimitedIdentifier(this.getTableName(table.getName()));
        return result;
    }

    protected void createTable(Table table, StringBuilder ddl, boolean temporary, boolean recreate) {
        int idx;
        Column[] columns = table.getAutoIncrementColumns();
        if (!temporary && !recreate) {
            for (idx = 0; idx < columns.length; ++idx) {
                this.a(table, columns[idx], ddl);
            }
        }
        super.createTable(table, ddl, temporary, recreate);
        if (!temporary) {
            for (idx = 0; idx < columns.length; ++idx) {
                this.a(table, columns[idx], idx + 1, ddl);
            }
        }
    }

    protected void dropTable(Table table, StringBuilder ddl, boolean temporary, boolean recreate) {
        if (!temporary && !recreate) {
            Column[] columns = table.getAutoIncrementColumns();
            for (int idx = 0; idx < columns.length; ++idx) {
                this.c(table, columns[idx], ddl);
                this.b(table, columns[idx], ddl);
            }
        }
        super.dropTable(table, ddl, temporary, recreate);
    }

    public String getSqlType(Column column) {
        Object sqlType = super.getSqlType(column);
        if ("LVARCHAR".equals(sqlType) || "LVARBINARY".equals(sqlType)) {
            sqlType = (String)sqlType + "(1073741823)";
        } else if ("timestamp_timezone(32)".equals(sqlType)) {
            sqlType = "timestamp with time zone";
        }
        return sqlType;
    }

    protected void a(Table table, Column column, StringBuilder ddl) {
        ddl.append("CREATE SEQUENCE PUB.");
        this.printIdentifier(this.getConstraintName(b, table, column.getName(), null), ddl);
        this.printEndOfStatement(ddl);
    }

    protected void a(Table table, Column column, int index, StringBuilder ddl) {
        String triggerName = this.getConstraintName(a, table, column.getName(), null);
        String sequenceName = this.getConstraintName(b, table, column.getName(), null);
        String type = column.getMappedType();
        boolean isBigInt = type.equals("BIGINT");
        ddl.append("CREATE TRIGGER ");
        this.printlnIdentifier(triggerName, ddl);
        ddl.append("BEFORE INSERT ON ");
        ddl.append(this.getFullyQualifiedTableNameShorten(table));
        this.println(" REFERENCING NEWROW FOR EACH ROW", ddl);
        this.println("IMPORT", ddl);
        this.println("import java.sql.*;;", ddl);
        this.println("BEGIN", ddl);
        if (isBigInt) {
            this.println("Long id = (Long) NEWROW.getValue(" + index + ", BIGINT);;", ddl);
        } else {
            this.println("int id = (int) NEWROW.getValue(" + index + ", " + type + ");;", ddl);
        }
        this.println("if (id == -1) {", ddl);
        this.println("SQLCursor cursor = new SQLCursor(\"SELECT PUB." + sequenceName + ".NEXTVAL FROM SYSPROGRESS.SYSCALCTABLE\");;", ddl);
        this.println("cursor.open();;", ddl);
        this.println("cursor.fetch();;", ddl);
        this.println("Long newId = (Long) cursor.getValue(1, BIGINT);;", ddl);
        this.println("cursor.close();;", ddl);
        if (isBigInt) {
            this.println("NEWROW.setValue(" + index + ", newId);;", ddl);
        } else {
            this.println("NEWROW.setValue(" + index + ", newId.intValue());;", ddl);
        }
        this.println("}", ddl);
        ddl.append("END");
        this.printEndOfStatement(ddl);
    }

    protected void b(Table table, Column column, StringBuilder ddl) {
        ddl.append("DROP SEQUENCE PUB.");
        this.printIdentifier(this.getConstraintName(b, table, column.getName(), null), ddl);
        this.printEndOfStatement(ddl);
    }

    protected void c(Table table, Column column, StringBuilder ddl) {
        ddl.append("DROP TRIGGER ");
        this.printIdentifier(this.getConstraintName(a, table, column.getName(), null), ddl);
        this.printEndOfStatement(ddl);
    }

    protected void writeColumnAutoIncrementStmt(Table table, Column column, StringBuilder ddl) {
    }

    protected void writeColumnDefaultValue(Table table, Column column, StringBuilder ddl) {
        if (ArrayUtils.contains((Object[])table.getAutoIncrementColumns(), (Object)column)) {
            ddl.append("-1");
        } else {
            this.printDefaultValue(this.getNativeDefaultValue(column), column, ddl);
        }
    }

    protected boolean shouldUseQuotes(String defaultValue, Column column) {
        String defaultValueStr;
        for (defaultValueStr = this.mapDefaultValue(defaultValue, column); defaultValueStr != null && defaultValueStr.startsWith("(") && defaultValueStr.endsWith(")"); defaultValueStr = defaultValueStr.substring(1, defaultValueStr.length() - 1)) {
        }
        return super.shouldUseQuotes(defaultValue, column) && !defaultValueStr.trim().toUpperCase().startsWith("SYSTIME");
    }

    protected void processTableStructureChanges(Database currentModel, Database desiredModel, Table sourceTable, Table targetTable, List<TableChange> changes, StringBuilder ddl) {
        Iterator<TableChange> changeIt = changes.iterator();
        while (changeIt.hasNext()) {
            TableChange change = changeIt.next();
            if (change instanceof ColumnSizeChange) {
                if (!this.a(currentModel, desiredModel, (ColumnSizeChange)change, ddl)) continue;
                changeIt.remove();
                continue;
            }
            if (change instanceof ColumnDefaultValueChange) {
                this.a(currentModel, desiredModel, (ColumnDefaultValueChange)change, ddl);
                changeIt.remove();
                continue;
            }
            if (change instanceof ColumnAutoIncrementChange) {
                if (!this.a(currentModel, desiredModel, (ColumnAutoIncrementChange)change, ddl)) continue;
                changeIt.remove();
                continue;
            }
            if (change instanceof ColumnRequiredChange) {
                this.a(currentModel, desiredModel, (ColumnRequiredChange)change, ddl);
                changeIt.remove();
                continue;
            }
            if (change instanceof AddColumnChange) {
                this.a(currentModel, desiredModel, (AddColumnChange)change, ddl);
                changeIt.remove();
                continue;
            }
            if (!(change instanceof RemoveColumnChange)) continue;
            this.a(currentModel, desiredModel, (RemoveColumnChange)change, ddl);
            changeIt.remove();
        }
        super.processTableStructureChanges(currentModel, desiredModel, sourceTable, targetTable, changes, ddl);
    }

    protected boolean a(Database currentModel, Database desiredModel, ColumnSizeChange change, StringBuilder ddl) {
        Column column = change.getChangedColumn();
        int type = column.getMappedTypeCode();
        if (type == 1 || type == 12 || type == -1 || type == -2 || type == -3 || type == -4) {
            this.writeTableAlterStmt(change.getChangedTable(), ddl);
            ddl.append(" ALTER COLUMN ");
            this.printIdentifier(this.getColumnName(column), ddl);
            ddl.append(" SET PRO_SQL_WIDTH ");
            ddl.append(change.getNewSize());
            this.printEndOfStatement(ddl);
            return true;
        }
        return false;
    }

    protected void a(Database currentModel, Database desiredModel, ColumnDefaultValueChange change, StringBuilder ddl) {
        this.writeTableAlterStmt(change.getChangedTable(), ddl);
        ddl.append(" ALTER COLUMN ");
        Column column = change.getChangedColumn();
        column.setDefaultValue(change.getNewDefaultValue());
        this.printIdentifier(this.getColumnName(column), ddl);
        ddl.append(" SET DEFAULT ");
        this.writeColumnDefaultValue(change.getChangedTable(), column, ddl);
        this.printEndOfStatement(ddl);
    }

    protected boolean a(Database currentModel, Database desiredModel, ColumnAutoIncrementChange change, StringBuilder ddl) {
        boolean autoIncrement = !change.getColumn().isAutoIncrement();
        Table table = change.getChangedTable();
        Column column = change.getColumn();
        if (!autoIncrement) {
            this.c(table, column, ddl);
            this.b(table, column, ddl);
        } else {
            this.a(table, column, ddl);
            this.a(table, column, table.getColumnIndex(column) + 1, ddl);
        }
        return true;
    }

    protected void a(Database currentModel, Database desiredModel, ColumnRequiredChange change, StringBuilder ddl) {
        boolean required = !change.getChangedColumn().isRequired();
        this.writeTableAlterStmt(change.getChangedTable(), ddl);
        ddl.append(" ALTER COLUMN ");
        Column column = change.getChangedColumn();
        this.printIdentifier(this.getColumnName(column), ddl);
        if (required) {
            ddl.append(" SET NOT NULL");
        } else {
            ddl.append(" SET NULL");
        }
        this.printEndOfStatement(ddl);
    }

    protected boolean writeAlterColumnDataTypeToBigInt(ColumnDataTypeChange change, StringBuilder ddl) {
        this.writeTableAlterStmt(change.getChangedTable(), ddl);
        ddl.append(" ALTER COLUMN ");
        Column column = change.getChangedColumn();
        this.printIdentifier(this.getColumnName(column), ddl);
        ddl.append(" SET PRO_DATA_TYPE BIGINT");
        this.printEndOfStatement(ddl);
        return true;
    }

    protected void a(Database currentModel, Database desiredModel, AddColumnChange change, StringBuilder ddl) {
        ddl.append("ALTER TABLE ");
        ddl.append(this.getFullyQualifiedTableNameShorten(change.getChangedTable()));
        this.printIndent(ddl);
        ddl.append("ADD ");
        this.writeColumn(change.getChangedTable(), change.getNewColumn(), ddl);
        this.printEndOfStatement(ddl);
        if (change.getNewColumn().isAutoIncrement()) {
            this.a(change.getChangedTable(), change.getNewColumn(), ddl);
            this.a(change.getChangedTable(), change.getNewColumn(), change.getChangedTable().getColumnIndex(change.getNextColumn()) + 1, ddl);
        }
        change.apply(currentModel, this.delimitedIdentifierModeOn);
    }

    protected void a(Database currentModel, Database desiredModel, RemoveColumnChange change, StringBuilder ddl) {
        if (change.getColumn().isAutoIncrement()) {
            this.c(change.getChangedTable(), change.getColumn(), ddl);
            this.b(change.getChangedTable(), change.getColumn(), ddl);
        }
        ddl.append("ALTER TABLE ");
        ddl.append(this.getFullyQualifiedTableNameShorten(change.getChangedTable()));
        this.printIndent(ddl);
        ddl.append("DROP COLUMN ");
        this.printIdentifier(this.getColumnName(change.getColumn()), ddl);
        this.printEndOfStatement(ddl);
        change.apply(currentModel, this.delimitedIdentifierModeOn);
    }
}

