/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ListObjectsV2Request;
import com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.jumpmind.symmetric.console.impl.fQ;
import com.jumpmind.symmetric.console.impl.hh;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.security.ISecurityService;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;
import org.jumpmind.symmetric.file.DirectorySnapshot;
import org.jumpmind.symmetric.file.IFileSourceTracker;
import org.jumpmind.symmetric.model.FileSnapshot;
import org.jumpmind.symmetric.model.FileTriggerRouter;
import org.jumpmind.symmetric.model.ProcessInfo;
import org.jumpmind.symmetric.service.IParameterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class fR
implements IBuiltInExtensionPoint,
ISymmetricEngineAware,
IFileSourceTracker {
    protected final Logger a = LoggerFactory.getLogger((String)new hh(new long[]{-4866845549131977832L, 4567185722261300334L, -8078390729781362287L, 5366039680453012069L, 8562077812063453632L, 2596561224770536367L, 7999322825931268602L}).toString());
    protected ISymmetricEngine b;
    protected IParameterService c;
    protected ISecurityService d;
    protected long e;
    protected String f = "/";

    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.b = engine;
        this.c = engine.getParameterService();
        this.d = engine.getSecurityService();
    }

    public boolean handlesDir(String baseDir) {
        return baseDir.startsWith("s3://");
    }

    public boolean checkSourceDir(String baseDir) {
        this.e = System.currentTimeMillis();
        return true;
    }

    protected String a(FileTriggerRouter fileTriggerRouter) {
        String bucketName = fileTriggerRouter.getFileTrigger().getBaseDir().replace("s3://", "");
        if (bucketName.contains(this.f)) {
            bucketName = bucketName.substring(0, bucketName.indexOf(this.f));
        }
        return bucketName;
    }

    protected AmazonS3 a() {
        try {
            String token = this.c.getString("file.sync.s3.account.key");
            if (token != null && token.startsWith("enc:")) {
                token = this.d.decrypt(token.substring("enc:".length()));
            }
            String awsAccessKey = token;
            token = this.c.getString("file.sync.s3.secret.key");
            if (token != null && token.startsWith("enc:")) {
                token = this.d.decrypt(token.substring("enc:".length()));
            }
            String awsSecretKey = token;
            String region = this.c.getString("file.sync.s3.region");
            BasicAWSCredentials awsCreds = new BasicAWSCredentials(awsAccessKey, awsSecretKey);
            AmazonS3 s3client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)awsCreds))).withRegion(region)).build();
            return s3client;
        }
        catch (Exception e2) {
            this.a.error("Error getting Amazon S3 Client: " + String.valueOf(e2));
            return null;
        }
    }

    public DirectorySnapshot trackChanges(FileTriggerRouter fileTriggerRouter, DirectorySnapshot lastSnapshot, ProcessInfo processInfo, boolean useCrc) {
        DirectorySnapshot currentSnapshot = new DirectorySnapshot(fileTriggerRouter);
        AmazonS3 client = this.a();
        ListObjectsV2Request request = new ListObjectsV2Request();
        String bucket = this.a(fileTriggerRouter);
        request.setBucketName(bucket);
        request.setDelimiter(this.f);
        String dir = fileTriggerRouter.getFileTrigger().getBaseDir().replace("s3://", "");
        dir = dir.replace(bucket, "");
        if (dir.length() > 0) {
            dir = dir.substring(1);
        }
        request.setPrefix(dir);
        ListObjectsV2Result res2 = client.listObjectsV2(request);
        this.a(client, res2, dir, fileTriggerRouter, currentSnapshot, System.currentTimeMillis(), bucket);
        lastSnapshot = this.b.getFileSyncService().getDirectorySnapshot(fileTriggerRouter);
        DirectorySnapshot changes = lastSnapshot.diff(currentSnapshot);
        long runTime = (System.currentTimeMillis() - this.e) / 1000L;
        if (changes.size() > 0) {
            this.a.info("Tracked {} files in {} seconds. Found {} files changed.", new Object[]{lastSnapshot.size(), runTime, changes.size()});
        }
        return changes;
    }

    private void a(AmazonS3 client, ListObjectsV2Result result, String prefix, FileTriggerRouter fileTriggerRouter, DirectorySnapshot currentSnapshot, long ts, String bucket) {
        long tss = ts;
        IOFileFilter fileFilter = fileTriggerRouter.getFileTrigger().createIOFileFilter();
        for (S3ObjectSummary summary : result.getObjectSummaries()) {
            S3Object s3Object = client.getObject(new GetObjectRequest(bucket, summary.getKey()));
            fQ s3File = new fQ(s3Object.getKey(), s3Object, true);
            if (fileFilter.accept((File)s3File)) {
                this.a.debug("Found file {}", (Object)s3File.toString());
                FileSnapshot fileSnapshot = new FileSnapshot(fileTriggerRouter, (File)s3File, FileSnapshot.LastEventType.CREATE, false);
                currentSnapshot.add((Object)fileSnapshot);
                continue;
            }
            if (!this.a.isDebugEnabled()) continue;
            this.a.debug("Not accepting file {}", (Object)s3File.toString());
        }
        if (fileTriggerRouter.getFileTrigger().isRecurse()) {
            for (String nextPrefix : result.getCommonPrefixes()) {
                ListObjectsV2Request request = new ListObjectsV2Request();
                request.setPrefix(nextPrefix);
                request.setDelimiter(this.f);
                request.setBucketName(bucket);
                ListObjectsV2Result nextResult = client.listObjectsV2(request);
                this.a(client, nextResult, nextPrefix, fileTriggerRouter, currentSnapshot, tss, bucket);
            }
        }
        if (System.currentTimeMillis() - ts > 60000L) {
            this.a.info("File tracker has been processing for {} seconds.  The following stats have been gathered: {}", new Object[]{(System.currentTimeMillis() - this.e) / 1000L, "{ fileCount=" + currentSnapshot.size() + " }"});
            ts = System.currentTimeMillis();
        }
    }

    public boolean handlesFile(File file) {
        return file instanceof fQ;
    }

    public File createSourceFile(FileSnapshot snapshot) {
        FileTriggerRouter fileTriggerRouter = this.b.getFileSyncService().getFileTriggerRouter(snapshot.getTriggerId(), snapshot.getRouterId(), false);
        AmazonS3 client = this.a();
        fQ s3file = null;
        S3Object object = null;
        String bucket = this.a(fileTriggerRouter);
        if (!snapshot.getLastEventType().equals((Object)FileSnapshot.LastEventType.DELETE)) {
            object = client.getObject(bucket, snapshot.getFileName());
        }
        s3file = !snapshot.getFileName().endsWith(this.f) ? new fQ(snapshot.getFileName(), object, true) : new fQ(snapshot.getFileName(), object, false);
        return s3file;
    }

    public InputStream getInputStream(File file) throws IOException {
        fQ s3File = (fQ)file;
        String objectName = s3File.getName();
        AmazonS3 client = this.a();
        S3Object S3Object2 = client.getObject(s3File.b(), objectName);
        return S3Object2.getObjectContent();
    }
}

