/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobContainerClientBuilder;
import com.azure.storage.blob.models.BlobItem;
import com.azure.storage.blob.models.ListBlobsOptions;
import com.jumpmind.symmetric.console.impl.fI;
import com.jumpmind.symmetric.console.impl.hh;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.security.ISecurityService;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;
import org.jumpmind.symmetric.file.DirectorySnapshot;
import org.jumpmind.symmetric.file.IFileSourceTracker;
import org.jumpmind.symmetric.model.FileSnapshot;
import org.jumpmind.symmetric.model.FileTriggerRouter;
import org.jumpmind.symmetric.model.ProcessInfo;
import org.jumpmind.symmetric.service.IParameterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class fJ
implements IBuiltInExtensionPoint,
ISymmetricEngineAware,
IFileSourceTracker {
    protected final Logger a = LoggerFactory.getLogger((String)new hh(new long[]{-4866845549131977832L, 4567185722261300334L, -8078390729781362287L, 5366039680453012069L, 8562077812063453632L, 2596561224770536367L, 7999322825931268602L}).toString());
    protected ISymmetricEngine b;
    protected IParameterService c;
    protected ISecurityService d;
    protected long e;

    public boolean handlesDir(String baseDir) {
        return baseDir.startsWith("azure://");
    }

    public boolean checkSourceDir(String baseDir) {
        this.e = System.currentTimeMillis();
        return true;
    }

    protected BlobContainerClient a(String container) {
        String azureAccountName = this.c.getString("file.sync.azure.account.name");
        String token = this.c.getString("file.sync.azure.sas.token");
        if (token != null && token.startsWith("enc:")) {
            token = this.d.decrypt(token.substring("enc:".length()));
        }
        String azureSASToken = token;
        BlobContainerClient blobContainerClient = new BlobContainerClientBuilder().endpoint("https://" + azureAccountName + ".blob.core.windows.net").sasToken(azureSASToken).containerName(container).buildClient();
        return blobContainerClient;
    }

    public DirectorySnapshot trackChanges(FileTriggerRouter fileTriggerRouter, DirectorySnapshot lastSnapshot, ProcessInfo processInfo, boolean useCrc) {
        DirectorySnapshot currentSnapshot = new DirectorySnapshot(fileTriggerRouter);
        BlobContainerClient blobContainerClient = this.a(fileTriggerRouter.getFileTrigger().getBaseDir().replace("azure://", ""));
        ListBlobsOptions options = new ListBlobsOptions().setPrefix("");
        for (BlobItem blobItem : blobContainerClient.listBlobsByHierarchy("/", options, null)) {
            this.a(blobContainerClient, blobItem.getName(), fileTriggerRouter, currentSnapshot, System.currentTimeMillis());
        }
        lastSnapshot = this.b.getFileSyncService().getDirectorySnapshot(fileTriggerRouter);
        DirectorySnapshot changes = lastSnapshot.diff(currentSnapshot);
        long runTime = (System.currentTimeMillis() - this.e) / 1000L;
        if (changes.size() > 0) {
            this.a.info("Tracked {} files in {} seconds.  Found {} files changed.", new Object[]{lastSnapshot.size(), runTime, changes.size()});
        }
        return changes;
    }

    protected void a(BlobContainerClient blobContainerClient, String prefix, FileTriggerRouter fileTriggerRouter, DirectorySnapshot currentSnapshot, long ts) {
        String delimiter = "/";
        ListBlobsOptions options = new ListBlobsOptions().setPrefix(prefix);
        IOFileFilter fileFilter = fileTriggerRouter.getFileTrigger().createIOFileFilter();
        long tss = ts;
        blobContainerClient.listBlobsByHierarchy(delimiter, options, null).forEach(blob -> {
            BlobClient blobClient = blobContainerClient.getBlobClient(blob.getName());
            if (blob.isPrefix().booleanValue()) {
                fI azureFile = new fI(blob.getName(), blobClient, false);
                FileSnapshot fileSnapshot = new FileSnapshot(fileTriggerRouter, (File)azureFile, FileSnapshot.LastEventType.CREATE, false);
                currentSnapshot.add((Object)fileSnapshot);
                if (fileTriggerRouter.getFileTrigger().isRecurse()) {
                    if (this.a.isDebugEnabled()) {
                        this.a.debug("Recursing directory {}", (Object)azureFile.toString());
                    }
                    this.a(blobContainerClient, blob.getName(), fileTriggerRouter, currentSnapshot, tss);
                } else if (this.a.isDebugEnabled()) {
                    this.a.debug("Not recursing directory {}", (Object)azureFile.toString());
                }
            } else {
                fI azureFile = new fI(blob.getName(), blobClient, true);
                if (fileFilter.accept((File)azureFile)) {
                    this.a.debug("Found file {}", (Object)azureFile.toString());
                    FileSnapshot fileSnapshot = new FileSnapshot(fileTriggerRouter, (File)azureFile, FileSnapshot.LastEventType.CREATE, false);
                    currentSnapshot.add((Object)fileSnapshot);
                } else if (this.a.isDebugEnabled()) {
                    this.a.debug("Not accepting file {}", (Object)azureFile.toString());
                }
            }
        });
        if (System.currentTimeMillis() - ts > 60000L) {
            this.a.info("File tracker has been processing for {} seconds.  The following stats have been gathered: {}", new Object[]{(System.currentTimeMillis() - this.e) / 1000L, "{ fileCount=" + currentSnapshot.size() + " }"});
            ts = System.currentTimeMillis();
        }
    }

    public boolean handlesFile(File file) {
        return file instanceof fI;
    }

    public File createSourceFile(FileSnapshot snapshot) {
        fI azureFile;
        FileTriggerRouter fileTriggerRouter = this.b.getFileSyncService().getFileTriggerRouter(snapshot.getTriggerId(), snapshot.getRouterId(), false);
        BlobContainerClient blobContainerClient = this.a(fileTriggerRouter.getFileTrigger().getBaseDir().replace("azure://", ""));
        String blobName = snapshot.getFileName();
        Object dir = snapshot.getRelativeDir();
        dir = (String)dir + "/";
        if (!snapshot.getFileName().endsWith("/")) {
            BlobClient blobClient = blobContainerClient.getBlobClient((String)dir + blobName);
            azureFile = new fI((String)dir + blobName, blobClient, true);
        } else {
            BlobClient blobClient = blobContainerClient.getBlobClient((String)dir + blobName);
            azureFile = new fI((String)dir + blobName, blobClient, false);
        }
        return azureFile;
    }

    public InputStream getInputStream(File file) throws IOException {
        fI azureFile = (fI)file;
        String container = azureFile.b();
        BlobContainerClient blobContainerClient = this.a(container);
        String dir = container + "/";
        String blobName = file.getPath().replace(dir, "");
        BlobClient blobClient = blobContainerClient.getBlobClient(blobName);
        if (blobClient.exists().booleanValue()) {
            return blobClient.openInputStream();
        }
        throw new IOException("Blob not found.");
    }

    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.b = engine;
        this.c = engine.getParameterService();
        this.d = engine.getSecurityService();
    }
}

