/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.impl.hh;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.ext.IReloadQueueThreadAssigner;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.model.ExtractRequest;
import org.jumpmind.symmetric.model.NodeCommunication;
import org.jumpmind.symmetric.model.TableReloadRequest;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.IDataService;
import org.jumpmind.symmetric.service.IOutgoingBatchService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.impl.ISqlMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class fG
implements IBuiltInExtensionPoint,
IReloadQueueThreadAssigner,
ISymmetricEngineAware {
    protected static final String a = "auto";
    protected final Logger b = LoggerFactory.getLogger((String)new hh(new long[]{1278760054575187713L, 708597516668529269L, -6828260145649147778L, 716491715332151442L, -332565345809892134L, 4386048267040986492L, -1896426193850702384L, -1994859665260498025L}).toString());
    protected ISymmetricEngine c;
    protected IParameterService d;
    protected IConfigurationService e;
    protected IOutgoingBatchService f;
    protected IDataService g;
    protected ISqlMap h;

    public Collection<ExtractRequest> assignThreadsToExtractRequests(List<ExtractRequest> extractRequests, Channel reloadChannel) {
        int maxExtractThreadCount = this.d.getInt("initial.load.extract.thread.per.server.count");
        int maxSyncThreadCount = this.d.getInt("initial.load.queue.sync.thread.count");
        int extractThreadCount = this.a(extractRequests, 1, maxExtractThreadCount, ExtractRequest.ExtractStatus.NE);
        int syncThreadCount = this.a(extractRequests, 1, maxSyncThreadCount, ExtractRequest.ExtractStatus.OK);
        Map<Long, TableReloadRequest> loads = this.a(extractRequests);
        HashSet<ExtractRequest> requestsToUpdate = new HashSet<ExtractRequest>();
        requestsToUpdate.addAll(this.a(extractRequests, reloadChannel, extractThreadCount, loads, ExtractRequest.ExtractStatus.NE));
        requestsToUpdate.addAll(this.a(extractRequests, reloadChannel, syncThreadCount, loads, ExtractRequest.ExtractStatus.OK));
        return requestsToUpdate;
    }

    protected int a(List<ExtractRequest> extractRequests, int minThreadCount, int maxThreadCount, ExtractRequest.ExtractStatus status) {
        HashSet<Object> workload = new HashSet<Object>();
        HashSet<String> workloadNodes = new HashSet<String>();
        for (ExtractRequest request : extractRequests) {
            if (request.getStatus() != status) continue;
            workload.add(request.getNodeId() + "+" + request.getLoadId());
            workloadNodes.add(request.getNodeId());
        }
        if (status == ExtractRequest.ExtractStatus.OK) {
            if (this.d.is("sync.use.ready.queues")) {
                Map readyQueuesCache = this.f.getReadyQueues(false);
                for (String nodeId : readyQueuesCache.keySet()) {
                    if (workloadNodes.contains(nodeId)) continue;
                    workload.add(nodeId);
                }
            } else {
                return 1;
            }
        }
        return Integer.max(workload.size() == 0 ? 0 : maxThreadCount / workload.size(), minThreadCount);
    }

    protected Collection<ExtractRequest> a(List<ExtractRequest> extractRequests, Channel reloadChannel, int totalThreadCount, Map<Long, TableReloadRequest> loads, ExtractRequest.ExtractStatus status) {
        List<ExtractRequest> requestsForExtract;
        ArrayList<ExtractRequest> requestsToUpdate = new ArrayList<ExtractRequest>();
        boolean isMaxWorkload = false;
        int maxRows = reloadChannel.getMaxBatchToSend() * reloadChannel.getMaxBatchSize();
        List<ExtractRequest> requests = this.a(extractRequests, status, true);
        Map<String, List<Long>> workloadByNode = null;
        if (!requests.isEmpty() || status == ExtractRequest.ExtractStatus.OK && !extractRequests.isEmpty()) {
            workloadByNode = this.a(requests, reloadChannel.getMaxBatchSize(), totalThreadCount, loads);
        }
        if (!requests.isEmpty()) {
            this.b.info("Found {} extract requests to assign threads for {} with {} threads", new Object[]{requests.size(), status == ExtractRequest.ExtractStatus.NE ? "extracting" : "loading", totalThreadCount});
            isMaxWorkload = this.a(requests, requestsToUpdate, maxRows, workloadByNode, status);
        }
        if (status == ExtractRequest.ExtractStatus.OK && !isMaxWorkload && !(requestsForExtract = this.a(extractRequests, ExtractRequest.ExtractStatus.NE, false)).isEmpty()) {
            this.b.info("Found {} extract requests partial to assign threads for loading with {} threads", (Object)requestsForExtract.size(), (Object)totalThreadCount);
            this.a(workloadByNode, requestsForExtract, totalThreadCount, loads);
            this.a(requestsForExtract, requestsToUpdate, maxRows, workloadByNode, status);
        }
        return requestsToUpdate;
    }

    protected List<ExtractRequest> a(List<ExtractRequest> requests, ExtractRequest.ExtractStatus status, boolean keepUnassigned) {
        ArrayList<ExtractRequest> filteredRequests = new ArrayList<ExtractRequest>();
        for (ExtractRequest request : requests) {
            if (request.getStatus() != status || !keepUnassigned && request.getThreadId() == null) continue;
            filteredRequests.add(request);
        }
        return filteredRequests;
    }

    protected boolean a(List<ExtractRequest> requests, List<ExtractRequest> requestsToUpdate, int maxRows, Map<String, List<Long>> workloadByNode, ExtractRequest.ExtractStatus status) {
        HashMap<String, Boolean> maxWorkloadByNode = new HashMap<String, Boolean>();
        this.a(workloadByNode);
        for (ExtractRequest request : requests) {
            Integer threadId = request.getThreadId(status);
            if (threadId != null) continue;
            List<Long> workloads = workloadByNode.get(request.getNodeId());
            threadId = this.a(workloads, maxRows);
            if (threadId != null) {
                request.setThreadId(threadId, status);
                workloads.set(threadId, workloads.get(threadId) + request.getRows());
                requestsToUpdate.add(request);
                maxWorkloadByNode.put(request.getNodeId(), false);
                this.b.info("Assigning load ID {} extract request {} table {} to {} thread {}", new Object[]{request.getLoadId(), request.getRequestId(), request.getTableName(), status == ExtractRequest.ExtractStatus.NE ? "extract" : "load", threadId});
                this.a(workloadByNode);
                continue;
            }
            maxWorkloadByNode.put(request.getNodeId(), true);
        }
        boolean isMaxWorkload = true;
        Iterator iterator = maxWorkloadByNode.values().iterator();
        while (iterator.hasNext()) {
            boolean nodeMaxWorkload = (Boolean)iterator.next();
            isMaxWorkload &= nodeMaxWorkload;
        }
        return isMaxWorkload;
    }

    protected Integer a(List<Long> workloads, int maxRows) {
        Integer threadId = null;
        long smallestRowCount = Long.MAX_VALUE;
        for (int i2 = 0; i2 < workloads.size(); ++i2) {
            long rowCount = workloads.get(i2);
            if (rowCount >= smallestRowCount || rowCount >= (long)maxRows) continue;
            threadId = i2;
            smallestRowCount = rowCount;
        }
        return threadId;
    }

    protected void a(Map<String, List<Long>> workload) {
        if (this.b.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (Map.Entry<String, List<Long>> entry : workload.entrySet()) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append("Node ").append(entry.getKey()).append(" ").append(entry.getValue());
                first = false;
            }
            this.b.debug("Workload: {}", (Object)sb);
        }
    }

    protected Map<Long, TableReloadRequest> a(List<ExtractRequest> extractRequests) {
        HashMap<Long, TableReloadRequest> loads = new HashMap<Long, TableReloadRequest>();
        if (this.d.is("initial.load.defer.create.constraints")) {
            for (ExtractRequest request : extractRequests) {
                TableReloadRequest load = (TableReloadRequest)loads.get(request.getLoadId());
                if (load != null) continue;
                load = this.g.getTableReloadRequest(request.getLoadId());
                loads.put(load.getLoadId(), load);
            }
        }
        return loads;
    }

    protected Map<String, List<Long>> a(List<ExtractRequest> requests, int maxBatchSize, int totalThreadCount, Map<Long, TableReloadRequest> loads) {
        HashMap<String, List<Long>> workloadByNode = new HashMap<String, List<Long>>();
        this.a(workloadByNode, requests, totalThreadCount, loads);
        for (ExtractRequest request : requests) {
            List workloads = (List)workloadByNode.get(request.getNodeId());
            Integer threadId = request.getThreadId();
            if (threadId == null || threadId >= workloads.size()) continue;
            workloads.set(threadId, (Long)workloads.get(threadId) + Long.max(request.getRows(), maxBatchSize / 4));
        }
        return workloadByNode;
    }

    protected void a(Map<String, List<Long>> workloadByNode, List<ExtractRequest> requests, int totalThreadCount, Map<Long, TableReloadRequest> loads) {
        String initialLoadUseAllThreads = this.d.getString("initial.load.queue.use.all.threads", a);
        boolean deferConstraints = this.d.is("initial.load.defer.create.constraints");
        for (ExtractRequest request : requests) {
            TableReloadRequest load;
            List<Long> workloads = workloadByNode.get(request.getNodeId());
            if (workloads != null) continue;
            workloads = new ArrayList<Long>();
            int threadCount = 1;
            if (initialLoadUseAllThreads.equals(Boolean.TRUE.toString())) {
                threadCount = totalThreadCount;
            } else if (initialLoadUseAllThreads.equals(a) && (load = loads.get(request.getLoadId())) != null && load.isCreateTable() && deferConstraints) {
                threadCount = totalThreadCount;
            }
            for (int i2 = 0; i2 < threadCount; ++i2) {
                workloads.add(0L);
            }
            workloadByNode.put(request.getNodeId(), workloads);
        }
    }

    public void addDynamicQueues(Collection<String> queues, NodeCommunication.CommunicationType communicationType) {
        int reloadThreadCount = this.a(communicationType);
        if (queues.contains("reload")) {
            for (int i2 = 0; i2 < reloadThreadCount; ++i2) {
                queues.add("reload!" + i2);
            }
        }
    }

    protected int a(NodeCommunication.CommunicationType communicationType) {
        int reloadThreadCount = 1;
        if (communicationType == NodeCommunication.CommunicationType.EXTRACT) {
            reloadThreadCount = this.d.getInt("initial.load.extract.thread.per.server.count");
        } else if (communicationType == NodeCommunication.CommunicationType.PULL || communicationType == NodeCommunication.CommunicationType.PUSH) {
            reloadThreadCount = this.d.getInt("initial.load.queue.sync.thread.count");
        }
        return reloadThreadCount > 0 ? reloadThreadCount : 1;
    }

    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.c = engine;
        this.d = engine.getParameterService();
        this.e = engine.getConfigurationService();
        this.f = engine.getOutgoingBatchService();
        this.g = engine.getDataService();
    }
}

