/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.impl.j;
import com.jumpmind.symmetric.console.impl.l;
import com.jumpmind.symmetric.console.model.CompareRequest;
import com.jumpmind.symmetric.console.model.CompareTableStatus;
import com.jumpmind.symmetric.console.service.ICompareService;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.commons.codec.digest.PureJavaCrc32;
import org.apache.commons.codec.digest.XXHash32;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Reference;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.exception.IoException;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.SymmetricException;
import org.jumpmind.symmetric.io.data.transform.ColumnPolicy;
import org.jumpmind.symmetric.io.data.transform.TransformColumn;
import org.jumpmind.symmetric.io.stage.IStagedResource;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeGroupLink;
import org.jumpmind.symmetric.model.NodeGroupLinkAction;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.service.impl.AbstractOfflineDetectorService;
import org.jumpmind.symmetric.service.impl.TransformService;
import org.jumpmind.util.FormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class e
extends AbstractOfflineDetectorService {
    protected final Logger log = LoggerFactory.getLogger(e.class);
    protected ISymmetricEngine engine;
    protected ICompareService compareService;

    protected IStagedResource findResource(CompareTableStatus status, String name) {
        return this.engine.getStagingManager().find(new Object[]{"compare", status.getSourceNodeId(), this.getFileName(name, status)});
    }

    protected IStagedResource createResource(CompareTableStatus status, String name) {
        return this.engine.getStagingManager().create(new Object[]{"compare", status.getSourceNodeId(), this.getFileName(name, status)});
    }

    protected String getFileName(String name, CompareTableStatus status) {
        return String.format("%d-%d-%s", status.getCompareId(), status.getStepNumber(), name);
    }

    protected String getResourceName(CompareTableStatus status) {
        String name = null;
        if ("T".equals(status.getLevel())) {
            name = "table";
        } else if ("C".equals(status.getLevel())) {
            name = "chunk";
        } else if ("R".equals(status.getLevel())) {
            name = status.getChunkDiffCount() > 0L ? "row-filtered" : "row";
        } else if ("F".equals(status.getLevel())) {
            name = "repair";
        } else {
            throw new SymmetricException("Invalid compare level of " + status.getLevel(), new Object[0]);
        }
        return name;
    }

    protected void cleanUp(CompareTableStatus status) {
        for (String name : new String[]{"table", "chunk", "row", "row-unsorted", "row-filtered"}) {
            IStagedResource resource = this.findResource(status, name);
            if (resource != null && resource.exists()) {
                resource.delete();
            }
            if ((resource = this.findResource(status, name + "-remote")) == null || !resource.exists()) continue;
            resource.delete();
        }
    }

    protected String buildKey(Object ... keys) {
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < keys.length; ++i2) {
            sb.append(keys[i2]);
            if (i2 + 1 >= keys.length) continue;
            sb.append("|");
        }
        return sb.toString();
    }

    protected boolean isSource(CompareTableStatus status) {
        return this.isNode(status.getSourceNodeId());
    }

    protected boolean isTarget(CompareTableStatus status) {
        return this.isNode(status.getTargetNodeId());
    }

    protected boolean isNode(String nodeId) {
        String myNodeId = this.engine.getNodeId();
        if (myNodeId != null) {
            return myNodeId.equals(nodeId);
        }
        return false;
    }

    protected boolean isInitiator(CompareRequest request) {
        String myNodeId = this.engine.getNodeId();
        if (myNodeId != null) {
            Node sourceNode = this.findNode(request.getSourceNodeId(), request);
            Node targetNode = this.findNode(request.getTargetNodeId(), request);
            NodeGroupLinkAction sourceAction = null;
            NodeGroupLinkAction targetAction = null;
            List links = this.engine.getConfigurationService().getNodeGroupLinks(false);
            for (NodeGroupLink link : links) {
                if (link.getSourceNodeGroupId().equals(sourceNode.getNodeGroupId()) && link.getTargetNodeGroupId().equals(targetNode.getNodeGroupId())) {
                    sourceAction = link.getDataEventAction();
                }
                if (!link.getSourceNodeGroupId().equals(targetNode.getNodeGroupId()) || !link.getTargetNodeGroupId().equals(sourceNode.getNodeGroupId())) continue;
                targetAction = link.getDataEventAction();
            }
            if (sourceAction == NodeGroupLinkAction.P && targetAction == NodeGroupLinkAction.W) {
                return myNodeId.equals(request.getSourceNodeId());
            }
            if (sourceAction == NodeGroupLinkAction.W && targetAction == NodeGroupLinkAction.P || sourceAction == NodeGroupLinkAction.P && targetAction == NodeGroupLinkAction.P || sourceAction == NodeGroupLinkAction.W && targetAction == NodeGroupLinkAction.W) {
                return myNodeId.equals(request.getTargetNodeId());
            }
            String message = "Missing a group link between source node " + request.getSourceNodeId() + " (" + (sourceAction == null ? "missing" : "found") + ") to target node " + request.getTargetNodeId() + " (" + (targetAction == null ? "missing" : "found") + ") for compare request created at " + String.valueOf(request.getCreateTime());
            throw new l(message, true);
        }
        return false;
    }

    protected Table getTable(CompareTableStatus status, boolean isSource) {
        Node sourceNode = this.findNode(status.getCompareRequest().getSourceNodeId(), status.getCompareRequest());
        Node targetNode = this.findNode(status.getCompareRequest().getTargetNodeId(), status.getCompareRequest());
        IDatabasePlatform platform = this.engine.getTargetDialect().getTargetPlatform();
        Table table = null;
        table = isSource ? platform.getTableFromCache(status.getSourceCatalogName(), status.getSourceSchemaName(), status.getSourceTableName(), true) : platform.getTableFromCache(status.getTargetCatalogName(), status.getTargetSchemaName(), status.getTargetTableName(), true);
        if (table != null) {
            try {
                table = (Table)table.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        if (table == null) {
            throw new l("Missing table " + Table.getFullyQualifiedTableName((String)status.getSourceCatalogName(), (String)status.getSourceSchemaName(), (String)status.getSourceTableName()));
        }
        this.filterIncludeExcludeColumns(table, status.getCompareRequest().getTriggerId(), status.getCompareRequest().isExcludeSurrogate());
        this.treatDatetimeAsVarchar(table);
        if (table.getPrimaryKeyColumnCount() == 0) {
            table = platform.makeAllColumnsPrimaryKeys(table);
        }
        Map<String, String> renamedColumns = this.filterTransforms(table, sourceNode.getNodeGroupId(), targetNode.getNodeGroupId(), status, isSource);
        this.orderColumnNames(table, renamedColumns);
        return table;
    }

    protected void filterIncludeExcludeColumns(Table table, String triggerId, boolean excludeSurrogate) {
        Column[] triggers;
        Trigger trigger = null;
        if (!"ALL".equals(triggerId)) {
            trigger = this.engine.getTriggerRouterService().getTriggerById(triggerId, true);
        } else {
            triggers = this.engine.getTriggerRouterService().getTriggersForCurrentNode(false);
            Collection matchingTriggers = this.engine.getTriggerRouterService().findMatchingTriggers((List)triggers, table.getCatalog(), table.getSchema(), table.getName());
            if (matchingTriggers != null && matchingTriggers.size() > 0) {
                trigger = (Trigger)matchingTriggers.iterator().next();
            }
        }
        if (trigger != null) {
            int n2;
            if (excludeSurrogate) {
                if (StringUtils.isNotBlank((CharSequence)trigger.getSyncKeyNames()) || table.getUniqueIndices().length != 0) {
                    for (Column column : table.getColumns()) {
                        if (!column.isPrimaryKey()) continue;
                        table.removeColumn(column);
                    }
                }
                triggers = table.getForeignKeys();
                int n3 = triggers.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    Column fk2 = triggers[n2];
                    for (Reference ref : fk2.getReferences()) {
                        if (ref.getLocalColumn() != null) {
                            table.removeColumn(ref.getLocalColumn());
                            continue;
                        }
                        for (Column column : table.getColumns()) {
                            if (!column.getName().equalsIgnoreCase(ref.getLocalColumnName())) continue;
                            table.removeColumn(column);
                        }
                    }
                }
            }
            if (StringUtils.isNotBlank((CharSequence)trigger.getExcludedColumnNames()) || StringUtils.isNotBlank((CharSequence)trigger.getIncludedColumnNames())) {
                Column[] columns = trigger.filterExcludedAndIncludedColumns(table.getColumns());
                table.removeAllColumns();
                Column[] columnArray = columns;
                n2 = columnArray.length;
                for (int fk2 = 0; fk2 < n2; ++fk2) {
                    Column column = columnArray[fk2];
                    table.addColumn(column);
                }
            }
            for (Column column : trigger.getSyncKeysColumnsForTable(table)) {
                column.setPrimaryKey(true);
            }
        } else {
            this.log.info("No trigger config found for table {}", (Object)table.getFullyQualifiedTableName());
        }
    }

    protected void treatDatetimeAsVarchar(Table table) {
        if (this.engine.getParameterService().is("db.treat.date.time.as.varchar.enabled")) {
            Column[] columns;
            for (Column column : columns = table.getColumns()) {
                int typeCode;
                if (column == null || (typeCode = column.getMappedTypeCode()) != 91 && typeCode != 92 && typeCode != 93) continue;
                column.setMappedTypeCode(12);
            }
        }
    }

    protected Map<String, String> filterTransforms(Table table, String sourceNodeGroupId, String targetNodeGroupId, CompareTableStatus status, boolean isSource) {
        List transforms = this.engine.getTransformService().findTransformsFor(sourceNodeGroupId, targetNodeGroupId, table.getName());
        Map<String, String> renamedColumns = this.filterTransforms(transforms, table, isSource, true);
        transforms = this.engine.getTransformService().findTransformsFor(targetNodeGroupId, sourceNodeGroupId, status.getTargetTableName());
        this.filterTransforms(transforms, table, !isSource, false);
        return renamedColumns;
    }

    protected Map<String, String> filterTransforms(List<TransformService.TransformTableNodeGroupLink> transforms, Table table, boolean isSource, boolean shouldRenameColumns) {
        HashMap<String, String> renamedColumns = new HashMap<String, String>();
        if (transforms != null && transforms.size() > 0) {
            TransformService.TransformTableNodeGroupLink transform = transforms.get(0);
            for (Column column : table.getColumns()) {
                List transformColumns;
                List list = transformColumns = isSource ? transform.getTransformColumnFor(column.getName()) : transform.getTransformColumnTo(column.getName());
                if (transformColumns.isEmpty()) {
                    if (transform.getColumnPolicy() != ColumnPolicy.SPECIFIED) continue;
                    table.removeColumn(column);
                    this.log.info("Excluding column {} from table {} because unspecified transform", (Object)column.getName(), (Object)table.getName());
                    continue;
                }
                if (isSource) continue;
                TransformColumn transformColumn = (TransformColumn)transformColumns.get(0);
                if (StringUtils.isBlank((CharSequence)transformColumn.getSourceColumnName())) {
                    table.removeColumn(column);
                    this.log.info("Excluding column {} from table {} because no source column", (Object)column.getName(), (Object)table.getName());
                    continue;
                }
                if (!shouldRenameColumns || transformColumn.getSourceColumnName().equalsIgnoreCase(transformColumn.getTargetColumnName())) continue;
                renamedColumns.put(transformColumn.getTargetColumnName().toUpperCase(), transformColumn.getSourceColumnName().toUpperCase());
                this.log.info("Renaming column {} to {} on table {} because of transform", new Object[]{transformColumn.getTargetColumnName(), transformColumn.getSourceColumnName().toUpperCase(), table.getName()});
            }
        }
        return renamedColumns;
    }

    protected void orderColumnNames(Table table, final Map<String, String> renamedColumns) {
        String[] orderedColumnNames = table.getColumnNames();
        Arrays.sort(orderedColumnNames, new Comparator<String>(){

            public int a(String o1, String o2) {
                return e.this.getColumnName(renamedColumns, o1.toUpperCase()).compareTo(e.this.getColumnName(renamedColumns, o2.toUpperCase()));
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((String)object, (String)object2);
            }
        });
        table.orderColumns(orderedColumnNames);
    }

    protected String getColumnName(Map<String, String> renamedColumns, String columnName) {
        String newName = renamedColumns.get(columnName);
        if (newName != null) {
            columnName = newName;
        }
        return columnName;
    }

    protected String getInitialLoadSelect(CompareTableStatus status, boolean isSource, Table table) {
        String whereSql = "1=1";
        TriggerRouter triggerRouter = null;
        if (isSource && !"ALL".equals(status.getCompareRequest().getTriggerId())) {
            triggerRouter = this.engine.getTriggerRouterService().findTriggerRouterById(status.getCompareRequest().getTriggerId(), status.getCompareRequest().getRouterId(), false);
        } else {
            List triggers = this.engine.getTriggerRouterService().getTriggersForCurrentNode(false);
            Collection matchingTriggers = this.engine.getTriggerRouterService().findMatchingTriggers(triggers, table.getCatalog(), table.getSchema(), table.getName());
            if (matchingTriggers.size() > 0) {
                Map triggerRoutersById = this.engine.getTriggerRouterService().getTriggerRoutersForCurrentNode(false);
                List triggerRouters = (List)triggerRoutersById.get(((Trigger)matchingTriggers.iterator().next()).getTriggerId());
                String targetNodeGroup = this.findNode(isSource ? status.getTargetNodeId() : status.getSourceNodeId(), status.getCompareRequest()).getNodeGroupId();
                for (TriggerRouter tr : triggerRouters) {
                    if (!tr.getRouter().getNodeGroupLink().getTargetNodeGroupId().equals(targetNodeGroup)) continue;
                    triggerRouter = tr;
                    break;
                }
            }
        }
        if (triggerRouter != null) {
            if (StringUtils.isNotBlank((CharSequence)triggerRouter.getInitialLoadSelect())) {
                whereSql = triggerRouter.getInitialLoadSelect();
                if (whereSql.toLowerCase().trim().startsWith("where")) {
                    whereSql = whereSql.trim().substring(5);
                }
            } else if (!"default".equals(triggerRouter.getRouter().getRouterType())) {
                throw new l("Ignoring compare request " + status.getNodeCompareIdStep() + " for table " + table.getFullyQualifiedTableName() + " because non-default router is missing initial load select that is required for optimal comparison.");
            }
        } else {
            this.log.info("No trigger router found for table {}", (Object)table.getFullyQualifiedTableName());
        }
        Node node = this.findNode(isSource ? status.getTargetNodeId() : status.getSourceNodeId(), status.getCompareRequest());
        whereSql = FormatUtils.replace((String)"groupId", (String)node.getNodeGroupId(), (String)whereSql);
        whereSql = FormatUtils.replace((String)"externalId", (String)node.getExternalId(), (String)whereSql);
        whereSql = FormatUtils.replace((String)"nodeId", (String)node.getNodeId(), (String)whereSql);
        return whereSql;
    }

    protected Node findNode(String nodeId, CompareRequest request) {
        Node node = this.engine.getNodeService().findNode(nodeId);
        if (node == null) {
            String message = "Node " + nodeId + " not found for compare request with source node " + request.getSourceNodeId() + ", target node " + request.getTargetNodeId() + ", " + (request.getCompareId() > 0L ? "compare ID " + request.getCompareId() : "created on " + String.valueOf(request.getCreateTime()));
            throw new l(message, true);
        }
        return node;
    }

    protected void setStatusIfNotSet(CompareTableStatus tableStatus, String status) {
        if (!status.equals(tableStatus.getStatus()) && (this.isSource(tableStatus) && !tableStatus.getLevel().equals("F") || this.isTarget(tableStatus) && tableStatus.getLevel().equals("F"))) {
            tableStatus.setErrorFlag(false);
            tableStatus.setErrorMessage(null);
            tableStatus.setStatus(status);
            if (this.isSource(tableStatus)) {
                this.compareService.updateCompareTableStatus(tableStatus);
            }
        }
    }

    protected void updateChecksum(Checksum checksum, String value) {
        byte[] bytes = j.b;
        if (value != null) {
            bytes = value.getBytes(Charset.defaultCharset());
        }
        checksum.update(bytes, 0, bytes.length);
    }

    protected Checksum getChecksumAlgo(CompareRequest request) {
        Object checksum = null;
        String name = request.getChecksumAlgorithm();
        if ("PureJavaCrc32".equalsIgnoreCase(name)) {
            checksum = new PureJavaCrc32();
        } else if ("Adler32".equalsIgnoreCase(name)) {
            checksum = new Adler32();
        } else if ("XXHash32".equalsIgnoreCase(name)) {
            checksum = new XXHash32();
        } else if ("CRC32".equalsIgnoreCase(name)) {
            checksum = new CRC32();
        } else {
            this.log.warn("Unrecognized checksum algorithm '{}'.  Using CRC32 instead.", (Object)name);
            checksum = new CRC32();
        }
        return checksum;
    }

    protected long getChunkSize(long rowCount) {
        long chunkSize = 0L;
        if (rowCount > 200000000L) {
            chunkSize = rowCount / 200L;
        } else {
            long numChunks;
            float percent = (float)rowCount / 2.0E8f;
            if (rowCount > 100000L && percent < 0.03f) {
                percent = 0.03f;
            }
            if ((numChunks = (long)(200.0f * percent)) == 0L) {
                numChunks = 1L;
            }
            chunkSize = Long.max(10000L, rowCount / numChunks);
        }
        return chunkSize;
    }

    protected void checkInterrupted() {
        if (Thread.currentThread().isInterrupted()) {
            throw new IoException("This thread was interrupted", new Object[0]);
        }
    }
}

