/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.impl.ha;
import com.jumpmind.symmetric.console.model.ConsoleEvent;
import com.jumpmind.symmetric.console.ui.common.I;
import com.vaadin.flow.server.Command;
import java.io.IOException;
import java.net.MalformedURLException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.security.ISecurityService;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.Version;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.util.SymmetricUtils;
import org.jumpmind.util.AppUtils;
import org.jumpmind.util.FormatUtils;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class du {
    private final Logger a = LoggerFactory.getLogger(this.getClass());
    private I b;
    private List<byte[]> c = new ArrayList<byte[]>();
    private int d;
    private String e;
    private String f;
    private String g;
    private String h;
    private boolean i;
    private boolean j;
    private Command k;
    private KeyStore.Entry l;
    private boolean m;
    private List<Node> n;
    private List<Node> o;
    private int p;
    private int q;

    public du(I controller, byte[] certData, String fileType, String url, boolean isPrivate, boolean generateSelfSigned, Command callback) {
        this.b = controller;
        if (certData != null) {
            this.c.add(certData);
        } else {
            this.m = !generateSelfSigned;
        }
        this.e = fileType;
        this.h = url;
        this.i = isPrivate;
        this.j = generateSelfSigned;
        this.k = callback;
    }

    public KeyStore.Entry a() throws Exception {
        if (this.h != null) {
            List<byte[]> certDataFromUrl = this.a(this.h);
            this.h = null;
            if (!certDataFromUrl.isEmpty()) {
                this.c.addAll(certDataFromUrl);
            } else {
                return null;
            }
        }
        ISymmetricEngine engine = this.b.getSymmetricEngine();
        ISecurityService securityService = engine.getSecurityService();
        if (this.j) {
            this.l = securityService.createDefaultSslCert(AppUtils.getHostName());
            String nodeId = engine.getNodeId();
            this.b.getConsoleEventService().addEvent(new ConsoleEvent(this.b.getConsoleUser().getUserId(), "Generate Certificate", nodeId, nodeId, null, null));
        } else {
            this.l = this.i ? securityService.createSslCert(this.c.get(this.d), this.e, this.f, this.g) : securityService.createTrustedCert(this.c.get(this.d), this.e, this.f, this.g);
        }
        return this.l;
    }

    public List<byte[]> a(String urlString) {
        try {
            Certificate[] certs = SymmetricUtils.getCertificates((String)urlString);
            if (certs != null) {
                ArrayList<byte[]> certDataFromUrl = new ArrayList<byte[]>();
                int couldNotInstallCount = 0;
                for (Certificate cert : certs) {
                    if (cert instanceof X509Certificate) {
                        try {
                            certDataFromUrl.add(FormatUtils.convertToPem((X509Certificate)((X509Certificate)cert)).getBytes());
                        }
                        catch (CertificateEncodingException e2) {
                            ++couldNotInstallCount;
                        }
                        continue;
                    }
                    ++couldNotInstallCount;
                }
                if (couldNotInstallCount > 0) {
                    this.a.warn("Couldn't install {} certificate(s) from the URL into the trusted keystore", (Object)couldNotInstallCount);
                }
                if (!certDataFromUrl.isEmpty()) {
                    return certDataFromUrl;
                }
                if (couldNotInstallCount > 0) {
                    CommonUiUtils.notify((String)this.b.getMessage("Couldn't install any of the certificates from the URL into the trusted keystore", new Object[0]));
                } else {
                    CommonUiUtils.notify((String)this.b.getMessage("Couldn't retrieve the certificate chain from the URL", new Object[0]));
                }
            }
        }
        catch (MalformedURLException e3) {
            CommonUiUtils.notify((String)this.b.getMessage("Invalid URL", new Object[0]));
        }
        catch (IOException e4) {
            CommonUiUtils.notify((String)this.b.getMessage("Failed to connect to URL", new Object[0]));
        }
        catch (KeyManagementException | NoSuchAlgorithmException e5) {
            CommonUiUtils.notify((String)this.b.getMessage("Failed to initialize SSL context", new Object[0]));
        }
        return null;
    }

    public boolean b() {
        return this.h == null && !this.j && this.c.isEmpty();
    }

    public boolean c() {
        INodeService nodeService = this.b.getSymmetricEngine().getNodeService();
        if (this.j || !nodeService.isRegistrationServer()) {
            return false;
        }
        if (this.o == null) {
            this.o = new ArrayList<Node>();
            Node currentNode = nodeService.findIdentity();
            this.n = nodeService.findAllNodes();
            for (Node node : this.n) {
                int tiersAway = ha.a(currentNode, node, this::a);
                if (tiersAway == 1 || tiersAway == 2) {
                    if (!Version.isOlderThanVersion((String)node.getSymmetricVersion(), (String)"3.12.2")) {
                        this.o.add(node);
                        continue;
                    }
                    ++this.p;
                    continue;
                }
                if (tiersAway <= 2) continue;
                ++this.q;
            }
        }
        return !this.o.isEmpty();
    }

    public Object a(Object node) {
        String nodeId = ((Node)node).getNodeId();
        String parentNodeId = ((Node)node).getCreatedAtNodeId();
        if (StringUtils.isNotBlank((CharSequence)parentNodeId) && !parentNodeId.equals(nodeId)) {
            for (Node otherNode : this.n) {
                if (!parentNodeId.equals(otherNode.getNodeId())) continue;
                return otherNode;
            }
        }
        return null;
    }

    public void a(List<byte[]> certData) {
        this.c.addAll(certData);
    }

    public List<byte[]> d() {
        return this.c;
    }

    public void b(String fileType) {
        this.e = fileType;
    }

    public void c(String alias) {
        this.f = alias;
    }

    public void d(String password) {
        this.g = password;
    }

    public boolean e() {
        return this.i;
    }

    public void f() {
        if (this.k != null) {
            this.k.execute();
        }
    }

    public boolean g() {
        return this.m;
    }

    public List<Node> h() {
        return this.o;
    }

    public int i() {
        return this.p;
    }

    public int j() {
        return this.q;
    }

    public boolean k() {
        return ++this.d < this.c.size();
    }
}

