/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.model.ConsoleEvent;
import com.jumpmind.symmetric.console.ui.common.H;
import com.jumpmind.symmetric.console.ui.common.I;
import com.jumpmind.symmetric.console.ui.common.J;
import com.jumpmind.symmetric.console.ui.common.K;
import com.jumpmind.symmetric.console.ui.common.N;
import com.jumpmind.symmetric.console.ui.common.ai;
import com.jumpmind.symmetric.console.ui.common.ap;
import com.jumpmind.symmetric.console.ui.common.as;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.confirmdialog.ConfirmDialog;
import com.vaadin.flow.component.contextmenu.ContextMenu;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.page.Page;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.selection.SelectionListener;
import com.vaadin.flow.data.value.ValueChangeMode;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.ValueProvider;
import de.f0rce.ace.AceEditor;
import de.f0rce.ace.enums.AceMode;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.IDdlReader;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.symmetric.service.ITriggerRouterService;
import org.jumpmind.vaadin.ui.common.ColumnVisibilityToggler;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;
import org.jumpmind.vaadin.ui.common.Label;
import org.jumpmind.vaadin.ui.common.ResizableDialog;
import org.jumpmind.vaadin.ui.common.TabbedApplicationPanel;

public class di
extends ap
implements H,
J {
    private static final long a = 1L;
    private Grid<TriggerHistory> b;
    private Map<String, Trigger> c = new HashMap<String, Trigger>();
    private Checkbox d;
    private TextField e;
    private String f;
    private Button g;
    private Button h;
    private Button i;
    private Span j;
    private boolean k;

    public di(I controller) {
        super(controller, null, "Below is a list of tables that are expected to be set up for capture on this node.  If the table capture is missing or could not be set up there will be an indication.  ");
    }

    @Override
    public void init() {
        if (this.b == null) {
            HorizontalLayout layout = new HorizontalLayout();
            layout.setSpacing(true);
            this.content.add(new Component[]{layout});
            Button refreshButton = as.createIconButton(K.REFRESH);
            refreshButton.addClickListener((ComponentEventListener & Serializable)event -> this.a(true));
            layout.add(new Component[]{refreshButton});
            Button reconfigureAllButton = new Button(this.controller.getMessage("Reconfigure All", new Object[0]));
            reconfigureAllButton.addClickListener((ComponentEventListener & Serializable)event -> new a(null).open());
            if (this.controller.getConsoleUser().hasPrivilegeWrite("Rebuild all Triggers")) {
                reconfigureAllButton.setEnabled(true);
                reconfigureAllButton.getElement().removeAttribute("title");
            } else {
                reconfigureAllButton.setEnabled(false);
                reconfigureAllButton.getElement().setAttribute("title", String.format("Your role '%s' does not have the privileges needed for this action.", this.controller.getConsoleUser().getRole()));
            }
            if (this.controller.getConsoleUser().hasPrivilegeRead("Rebuild Triggers")) {
                layout.add(new Component[]{reconfigureAllButton});
            }
            Span separator = new Span();
            separator.setClassName("vrule");
            separator.setWidth(null);
            layout.add(new Component[]{separator});
            this.g = new Button(this.controller.getMessage("Reconfigure", new Object[0]));
            this.g.addClickListener((ComponentEventListener & Serializable)event -> new a(this.b.getSelectedItems()).open());
            this.g.setEnabled(false);
            if (this.controller.getConsoleUser().hasPrivilegeRead("Rebuild Triggers")) {
                layout.add(new Component[]{this.g});
            }
            this.h = new Button(this.controller.getMessage("Inactivate", new Object[0]));
            this.h.addClickListener((ComponentEventListener & Serializable)event -> this.a());
            this.h.setEnabled(false);
            if (this.controller.getConsoleUser().hasPrivilegeRead("Drop Triggers")) {
                layout.add(new Component[]{this.h});
            }
            this.i = new Button(this.controller.getMessage("View Text", new Object[0]));
            this.i.addClickListener((ComponentEventListener & Serializable)event -> new b((TriggerHistory)this.b.getSelectedItems().iterator().next()).open());
            this.i.setEnabled(false);
            layout.add(new Component[]{this.i});
            this.d = new Checkbox(this.controller.getMessage("Show sym_ tables", new Object[0]));
            this.d.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.a(true));
            this.e = new TextField();
            this.e.setWidth("200px");
            this.e.setPrefixComponent((Component)new Icon(VaadinIcon.SEARCH));
            this.e.setPlaceholder("Filter Table Capture");
            this.e.setValueChangeMode(ValueChangeMode.LAZY);
            this.e.setValueChangeTimeout(200);
            this.e.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.a(true));
            layout.addAndExpand(new Component[]{new Span()});
            layout.add(new Component[]{this.d});
            layout.setVerticalComponentAlignment(FlexComponent.Alignment.END, new Component[]{this.d});
            layout.add(new Component[]{this.e});
            layout.setVerticalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{this.e});
            ColumnVisibilityToggler columnVisibilityToggler = new ColumnVisibilityToggler();
            layout.add(new Component[]{columnVisibilityToggler});
            layout.setVerticalComponentAlignment(FlexComponent.Alignment.END, new Component[]{columnVisibilityToggler});
            this.b = new Grid();
            this.b.setSizeFull();
            this.b.setPartNameGenerator((SerializableFunction & Serializable)item -> {
                if (item.getErrorMessage() != null || item.getCreateTime() == null) {
                    return "v-grid-row-marked";
                }
                return null;
            });
            this.b.setSelectionMode(Grid.SelectionMode.MULTI);
            this.b.addSelectionListener((SelectionListener & Serializable)event -> {
                if (this.g != null && this.h != null && this.i != null) {
                    if (!this.b.getSelectedItems().isEmpty()) {
                        if (this.controller.getConsoleUser().hasPrivilegeWrite("Rebuild Triggers")) {
                            this.g.setEnabled(true);
                            this.g.getElement().removeAttribute("title");
                        } else {
                            this.g.setEnabled(false);
                            this.g.getElement().setAttribute("title", String.format("Your role '%s' does not have the privileges needed for this action.", this.controller.getConsoleUser().getRole()));
                        }
                        if (this.controller.getConsoleUser().hasPrivilegeWrite("Drop Triggers")) {
                            this.h.setEnabled(true);
                            this.g.getElement().removeAttribute("title");
                        } else {
                            this.h.setEnabled(false);
                            this.h.getElement().setAttribute("title", String.format("Your role '%s' does not have the privileges needed for this action.", this.controller.getConsoleUser().getRole()));
                        }
                        this.i.setEnabled(!this.k);
                    } else {
                        this.g.setEnabled(false);
                        this.h.setEnabled(false);
                        this.i.setEnabled(false);
                    }
                }
            });
            this.b.addItemClickListener((ComponentEventListener & Serializable)event -> {
                if (event.getColumn() != null) {
                    this.b.deselectAll();
                    this.b.select((Object)((TriggerHistory)event.getItem()));
                }
            });
            columnVisibilityToggler.addColumn(this.b.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)trigger -> {
                if (trigger.getErrorMessage() != null) {
                    Icon icon = new Icon(VaadinIcon.WARNING);
                    icon.setClassName("mouse_pointer");
                    icon.setTooltipText(trigger.getErrorMessage());
                    ContextMenu menu = new ContextMenu((Component)icon);
                    menu.setOpenOnClick(true);
                    Label label = new Label(trigger.getErrorMessage());
                    label.setWidth("400px");
                    menu.addComponent(new Component[]{label});
                    return icon;
                }
                Icon icon = new Icon(VaadinIcon.CHECK);
                icon.setColor("green");
                return icon;
            })).setKey("").setHeader("").setWidth("56px").setFlexGrow(0), "");
            columnVisibilityToggler.addColumn(this.b.addColumn((ValueProvider & Serializable)trigger -> trigger.getTriggerHistoryId()).setHeader(this.controller.getMessage("Hist Id", new Object[0])), this.controller.getMessage("Hist Id", new Object[0]));
            columnVisibilityToggler.addColumn(this.b.addColumn((ValueProvider & Serializable)trigger -> trigger.getTriggerId()).setHeader(this.controller.getMessage("Capture Id", new Object[0])), this.controller.getMessage("Capture Id", new Object[0]));
            columnVisibilityToggler.addColumn(this.b.addColumn((ValueProvider & Serializable)trigger -> trigger.getSourceCatalogName()).setKey("catalog").setHeader(this.controller.getMessage("Source Catalog", new Object[0])), this.controller.getMessage("Source Catalog", new Object[0]));
            this.b.getColumnByKey("catalog").setVisible(false);
            columnVisibilityToggler.addColumn(this.b.addColumn((ValueProvider & Serializable)trigger -> trigger.getSourceSchemaName()).setKey("schema").setHeader(this.controller.getMessage("Source Schema", new Object[0])), this.controller.getMessage("Source Schema", new Object[0]));
            this.b.getColumnByKey("schema").setVisible(false);
            columnVisibilityToggler.addColumn(this.b.addColumn((ValueProvider & Serializable)trigger -> trigger.getSourceTableName()).setHeader(this.controller.getMessage("Source Table", new Object[0])), this.controller.getMessage("Source Table", new Object[0]));
            columnVisibilityToggler.addColumn(this.b.addColumn((ValueProvider & Serializable)triggerHist -> {
                Trigger trigger;
                if (this.k && triggerHist.getTriggerHistoryId() > 0 && triggerHist.getErrorMessage() == null && (trigger = this.c.get(triggerHist.getTriggerId())) != null && trigger.isSyncOnInsert()) {
                    return this.controller.getMessage("Active", new Object[0]);
                }
                return triggerHist.getNameForInsertTrigger();
            }).setHeader(this.controller.getMessage("Insert Capture", new Object[0])), this.controller.getMessage("Insert Capture", new Object[0]));
            columnVisibilityToggler.addColumn(this.b.addColumn((ValueProvider & Serializable)triggerHist -> {
                Trigger trigger;
                if (this.k && triggerHist.getTriggerHistoryId() > 0 && triggerHist.getErrorMessage() == null && (trigger = this.c.get(triggerHist.getTriggerId())) != null && trigger.isSyncOnUpdate()) {
                    return this.controller.getMessage("Active", new Object[0]);
                }
                return triggerHist.getNameForUpdateTrigger();
            }).setHeader(this.controller.getMessage("Update Capture", new Object[0])), this.controller.getMessage("Update Capture", new Object[0]));
            columnVisibilityToggler.addColumn(this.b.addColumn((ValueProvider & Serializable)triggerHist -> {
                Trigger trigger;
                if (this.k && triggerHist.getTriggerHistoryId() > 0 && triggerHist.getErrorMessage() == null && (trigger = this.c.get(triggerHist.getTriggerId())) != null && trigger.isSyncOnDelete()) {
                    return this.controller.getMessage("Active", new Object[0]);
                }
                return triggerHist.getNameForDeleteTrigger();
            }).setHeader(this.controller.getMessage("Delete Capture", new Object[0])), this.controller.getMessage("Delete Capture", new Object[0]));
            columnVisibilityToggler.addColumn(this.b.addColumn((ValueProvider & Serializable)trigger -> trigger.getColumnNames()).setHeader(this.controller.getMessage("Column Names", new Object[0])), this.controller.getMessage("Column Names", new Object[0]));
            columnVisibilityToggler.addColumn(this.b.addColumn((ValueProvider & Serializable)trigger -> trigger.getLastTriggerBuildReason() != null ? trigger.getLastTriggerBuildReason().name() : null).setKey("lastRebuildReason").setHeader(this.controller.getMessage("Last Rebuild Reason", new Object[0])), this.controller.getMessage("Last Rebuild Reason", new Object[0]));
            this.b.getColumnByKey("lastRebuildReason").setVisible(false);
            columnVisibilityToggler.addColumn(this.b.addColumn((ValueProvider & Serializable)trigger -> trigger.getErrorMessage()).setKey("errorMessage").setHeader(this.controller.getMessage("Error Message", new Object[0])), this.controller.getMessage("Error Message", new Object[0]));
            this.b.getColumnByKey("errorMessage").setVisible(false);
            columnVisibilityToggler.addColumn(this.b.addColumn((ValueProvider & Serializable)trigger -> as.formatDate(this.controller, trigger.getCreateTime(), true)).setHeader(this.controller.getMessage("Created", new Object[0])).setComparator((ValueProvider & Serializable)trigger -> trigger.getCreateTime()), this.controller.getMessage("Created", new Object[0]));
            for (Grid.Column column : this.b.getColumns()) {
                column.setResizable(true);
                String key = column.getKey();
                if (key != null && key.equals("")) continue;
                column.setSortable(true);
            }
            this.content.addAndExpand(new Component[]{this.b});
            HorizontalLayout hlayout = new HorizontalLayout();
            this.content.add(new Component[]{hlayout});
            Button selectAllLink = as.createLinkButton(this.controller.getMessage("Select All", new Object[0]));
            hlayout.add(new Component[]{selectAllLink});
            selectAllLink.addClickListener((ComponentEventListener & Serializable)event -> {
                for (TriggerHistory trigger : this.b.getDataProvider().fetch(new Query()).collect(Collectors.toList())) {
                    this.b.select((Object)trigger);
                }
            });
            Button selectNoneLink = as.createLinkButton(this.controller.getMessage("Select None", new Object[0]));
            hlayout.add(new Component[]{selectNoneLink});
            selectNoneLink.addClickListener((ComponentEventListener & Serializable)event -> this.b.deselectAll());
            hlayout.addAndExpand(new Component[]{new Span()});
            hlayout.setWidth("99%");
            this.j = new Span();
            this.j.setSizeUndefined();
            hlayout.add(new Component[]{this.j});
        }
    }

    @Override
    public String getTitleKey() {
        return "Table Capture";
    }

    @Override
    public void onRefresh(Object ... params) {
        String nodeId = this.controller.getSymmetricEngine().getNodeService().findIdentityNodeId();
        if (nodeId != null && !nodeId.equals(this.f)) {
            this.k = this.controller.getSymmetricEngine().getParameterService().is("start.log.miner.job");
            this.a(false);
        }
    }

    protected void a(boolean maintainSelection) {
        ISymmetricEngine engine = this.controller.getSymmetricEngine();
        ITriggerRouterService triggerRouterService = engine.getTriggerRouterService();
        this.f = this.controller.getSymmetricEngine().getNodeService().findIdentityNodeId();
        List triggers = triggerRouterService.getTriggersForCurrentNode(false);
        List activeHistories = triggerRouterService.getActiveTriggerHistories();
        Map lastErrorHistories = triggerRouterService.getLastErrorTriggerHistories();
        ArrayList<TriggerHistory> histories = new ArrayList<TriggerHistory>(triggers.size());
        this.c.clear();
        long ts = System.currentTimeMillis();
        int missingHistoryId = 0;
        for (Object trigger : triggers) {
            String triggerId = trigger.getTriggerId();
            List<TriggerHistory> triggerHistories = this.a(triggerId, activeHistories);
            TriggerHistory errorTriggerHistory = (TriggerHistory)lastErrorHistories.get(triggerId);
            boolean hasError = false;
            if (errorTriggerHistory != null) {
                hasError = true;
                for (TriggerHistory triggerHistory : triggerHistories) {
                    hasError &= errorTriggerHistory.getCreateTime() == null || errorTriggerHistory.getCreateTime().after(triggerHistory.getCreateTime());
                }
            }
            if (hasError) {
                histories.add(errorTriggerHistory);
            } else if (triggerHistories.size() > 0) {
                histories.addAll(triggerHistories);
            } else {
                TriggerHistory triggerHistory = new TriggerHistory((Trigger)trigger);
                triggerHistory.setTriggerHistoryId(missingHistoryId--);
                triggerHistory.setErrorMessage(this.controller.getMessage("Missing Table Capture", new Object[0]));
                histories.add(triggerHistory);
            }
            this.c.put(triggerId, (Trigger)trigger);
        }
        this.log.info("It took " + (System.currentTimeMillis() - ts) + "ms to select " + triggers.size() + " trigger histories");
        Collections.sort(histories, new Comparator<TriggerHistory>(){

            public int a(TriggerHistory o1, TriggerHistory o2) {
                if (o1.getErrorMessage() == null && o2.getErrorMessage() != null) {
                    return 1;
                }
                if (o2.getErrorMessage() == null && o1.getErrorMessage() != null) {
                    return -1;
                }
                if (o2.getCreateTime() == null && o1.getCreateTime() != null) {
                    return 1;
                }
                if (o2.getCreateTime() != null && o1.getCreateTime() == null) {
                    return -1;
                }
                if (o2.getCreateTime() == null && o1.getCreateTime() == null) {
                    return 0;
                }
                return o1.getCreateTime().compareTo(o2.getCreateTime()) * -1;
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((TriggerHistory)object, (TriggerHistory)object2);
            }
        });
        ArrayList<TriggerHistory> filteredHistories = new ArrayList<TriggerHistory>();
        for (TriggerHistory triggerHistory : histories) {
            boolean shouldAdd = false;
            if (!((Boolean)this.d.getValue()).booleanValue()) {
                if (!triggerHistory.getSourceTableName().toLowerCase().startsWith(this.controller.getSymmetricEngine().getParameterService().getTablePrefix().toLowerCase() + "_")) {
                    shouldAdd = !this.e.getValue().equals("") ? this.a(this.e.getValue(), triggerHistory) : true;
                }
            } else {
                shouldAdd = !this.e.getValue().equals("") ? this.a(this.e.getValue(), triggerHistory) : true;
            }
            if (!shouldAdd) continue;
            filteredHistories.add(triggerHistory);
        }
        Set selectedItems = this.b.getSelectedItems();
        this.b.setItems(filteredHistories);
        if (maintainSelection) {
            for (TriggerHistory item : selectedItems) {
                if (!filteredHistories.contains(item)) continue;
                this.b.select((Object)item);
            }
        }
        this.j.setText(this.controller.getMessage("Rows Returned", new Object[0]) + ": " + this.b.getDataProvider().fetch(new Query()).count());
    }

    protected boolean a(String filterText, TriggerHistory triggerHistory) {
        return !CommonUiUtils.isFilteredOut((String)String.valueOf(triggerHistory.getTriggerHistoryId()), (String)filterText) || !CommonUiUtils.isFilteredOut((String)triggerHistory.getTriggerId(), (String)filterText) || !CommonUiUtils.isFilteredOut((String)triggerHistory.getSourceCatalogName(), (String)filterText) || !CommonUiUtils.isFilteredOut((String)triggerHistory.getSourceSchemaName(), (String)filterText) || !CommonUiUtils.isFilteredOut((String)triggerHistory.getSourceTableName(), (String)filterText) || !CommonUiUtils.isFilteredOut((String)triggerHistory.getNameForInsertTrigger(), (String)filterText) || !CommonUiUtils.isFilteredOut((String)triggerHistory.getNameForUpdateTrigger(), (String)filterText) || !CommonUiUtils.isFilteredOut((String)triggerHistory.getNameForDeleteTrigger(), (String)filterText) || !CommonUiUtils.isFilteredOut((String)triggerHistory.getColumnNames(), (String)filterText) || !CommonUiUtils.isFilteredOut((String)as.formatDate(this.controller, triggerHistory.getCreateTime(), true), (String)filterText);
    }

    protected void a() {
        Set triggerHists = this.b.getSelectedItems();
        String message = this.controller.getMessage("Do you want to inactivate capture for %s table(s)?", triggerHists.size());
        new ConfirmDialog(this.controller.getMessage("Confirm", new Object[0]), message, this.controller.getMessage("Ok", new Object[0]), (ComponentEventListener & Serializable)e2 -> {
            ISymmetricEngine engine = this.controller.getSymmetricEngine();
            StringBuilder triggerIds = new StringBuilder();
            for (TriggerHistory triggerHist : triggerHists) {
                engine.getTriggerRouterService().dropTriggers(triggerHist);
                if (triggerIds.length() > 0) {
                    triggerIds.append(",");
                }
                triggerIds.append(triggerHist.getTriggerId());
            }
            Node identity = this.controller.getSymmetricEngine().getNodeService().findIdentity();
            this.controller.getConsoleEventService().addEvent(new ConsoleEvent(this.controller.getConsoleUser().getUserId(), "Inactivate capture for table", identity.getNodeId(), identity.getNodeId(), null, triggerIds.toString()));
            this.a(false);
        }, this.controller.getMessage("Cancel", new Object[0]), (ComponentEventListener & Serializable)e2 -> {}).open();
    }

    protected List<TriggerHistory> a(String triggerId, List<TriggerHistory> histories) {
        ArrayList<TriggerHistory> matching = new ArrayList<TriggerHistory>();
        for (TriggerHistory triggerHistory : histories) {
            if (!triggerHistory.getTriggerId().equals(triggerId)) continue;
            matching.add(triggerHistory);
        }
        return matching;
    }

    @Override
    public boolean onExit(Runnable exitClosure) {
        return true;
    }

    @Override
    public String getDocAnchor() {
        return "/doc/html/user-guide.html#_installed_triggers";
    }

    private static /* synthetic */ Object a(SerializedLambda lambda) {
        switch (lambda.getImplMethodName()) {
            case "lambda$init$ba6e7b7d$2": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/TableCapturePanel") || !lambda.getImplMethodSignature().equals("(Lorg/jumpmind/symmetric/model/TriggerHistory;)Ljava/lang/Object;")) break;
                return (ValueProvider & Serializable)trigger -> trigger.getTriggerId();
            }
            case "lambda$init$ba6e7b7d$1": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/TableCapturePanel") || !lambda.getImplMethodSignature().equals("(Lorg/jumpmind/symmetric/model/TriggerHistory;)Ljava/lang/Object;")) break;
                return (ValueProvider & Serializable)trigger -> trigger.getTriggerHistoryId();
            }
            case "lambda$init$ba6e7b7d$4": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/TableCapturePanel") || !lambda.getImplMethodSignature().equals("(Lorg/jumpmind/symmetric/model/TriggerHistory;)Ljava/lang/Object;")) break;
                return (ValueProvider & Serializable)trigger -> trigger.getSourceSchemaName();
            }
            case "lambda$init$ba6e7b7d$3": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/TableCapturePanel") || !lambda.getImplMethodSignature().equals("(Lorg/jumpmind/symmetric/model/TriggerHistory;)Ljava/lang/Object;")) break;
                return (ValueProvider & Serializable)trigger -> trigger.getSourceCatalogName();
            }
            case "lambda$inactivate$2c9bafba$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/TableCapturePanel") || !lambda.getImplMethodSignature().equals("(Ljava/util/Set;Lcom/vaadin/flow/component/confirmdialog/ConfirmDialog$ConfirmEvent;)V")) break;
                return arg_0 -> ((di)lambda.getCapturedArg(0)).a((Set)lambda.getCapturedArg(1), arg_0);
            }
            case "lambda$init$ba6e7b7d$6": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/TableCapturePanel") || !lambda.getImplMethodSignature().equals("(Lorg/jumpmind/symmetric/model/TriggerHistory;)Ljava/lang/Object;")) break;
                return (ValueProvider & Serializable)triggerHist -> {
                    Trigger trigger;
                    if (this.k && triggerHist.getTriggerHistoryId() > 0 && triggerHist.getErrorMessage() == null && (trigger = this.c.get(triggerHist.getTriggerId())) != null && trigger.isSyncOnInsert()) {
                        return this.controller.getMessage("Active", new Object[0]);
                    }
                    return triggerHist.getNameForInsertTrigger();
                };
            }
            case "lambda$init$ba6e7b7d$5": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/TableCapturePanel") || !lambda.getImplMethodSignature().equals("(Lorg/jumpmind/symmetric/model/TriggerHistory;)Ljava/lang/Object;")) break;
                return (ValueProvider & Serializable)trigger -> trigger.getSourceTableName();
            }
            case "lambda$init$3fed5817$2": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/SerializableFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/TableCapturePanel") || !lambda.getImplMethodSignature().equals("(Lorg/jumpmind/symmetric/model/TriggerHistory;)Lcom/vaadin/flow/component/icon/Icon;")) break;
                return (SerializableFunction & Serializable)trigger -> {
                    if (trigger.getErrorMessage() != null) {
                        Icon icon = new Icon(VaadinIcon.WARNING);
                        icon.setClassName("mouse_pointer");
                        icon.setTooltipText(trigger.getErrorMessage());
                        ContextMenu menu = new ContextMenu((Component)icon);
                        menu.setOpenOnClick(true);
                        Label label = new Label(trigger.getErrorMessage());
                        label.setWidth("400px");
                        menu.addComponent(new Component[]{label});
                        return icon;
                    }
                    Icon icon = new Icon(VaadinIcon.CHECK);
                    icon.setColor("green");
                    return icon;
                };
            }
            case "lambda$init$ba6e7b7d$8": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/TableCapturePanel") || !lambda.getImplMethodSignature().equals("(Lorg/jumpmind/symmetric/model/TriggerHistory;)Ljava/lang/Object;")) break;
                return (ValueProvider & Serializable)triggerHist -> {
                    Trigger trigger;
                    if (this.k && triggerHist.getTriggerHistoryId() > 0 && triggerHist.getErrorMessage() == null && (trigger = this.c.get(triggerHist.getTriggerId())) != null && trigger.isSyncOnDelete()) {
                        return this.controller.getMessage("Active", new Object[0]);
                    }
                    return triggerHist.getNameForDeleteTrigger();
                };
            }
            case "lambda$init$ba6e7b7d$7": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/TableCapturePanel") || !lambda.getImplMethodSignature().equals("(Lorg/jumpmind/symmetric/model/TriggerHistory;)Ljava/lang/Object;")) break;
                return (ValueProvider & Serializable)triggerHist -> {
                    Trigger trigger;
                    if (this.k && triggerHist.getTriggerHistoryId() > 0 && triggerHist.getErrorMessage() == null && (trigger = this.c.get(triggerHist.getTriggerId())) != null && trigger.isSyncOnUpdate()) {
                        return this.controller.getMessage("Active", new Object[0]);
                    }
                    return triggerHist.getNameForUpdateTrigger();
                };
            }
            case "lambda$init$ba6e7b7d$9": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/TableCapturePanel") || !lambda.getImplMethodSignature().equals("(Lorg/jumpmind/symmetric/model/TriggerHistory;)Ljava/lang/Object;")) break;
                return (ValueProvider & Serializable)trigger -> trigger.getColumnNames();
            }
            case "lambda$init$bfb64eaf$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/data/selection/SelectionListener") || !lambda.getFunctionalInterfaceMethodName().equals("selectionChange") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/data/selection/SelectionEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/TableCapturePanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/data/selection/SelectionEvent;)V")) break;
                return (SelectionListener & Serializable)event -> {
                    if (this.g != null && this.h != null && this.i != null) {
                        if (!this.b.getSelectedItems().isEmpty()) {
                            if (this.controller.getConsoleUser().hasPrivilegeWrite("Rebuild Triggers")) {
                                this.g.setEnabled(true);
                                this.g.getElement().removeAttribute("title");
                            } else {
                                this.g.setEnabled(false);
                                this.g.getElement().setAttribute("title", String.format("Your role '%s' does not have the privileges needed for this action.", this.controller.getConsoleUser().getRole()));
                            }
                            if (this.controller.getConsoleUser().hasPrivilegeWrite("Drop Triggers")) {
                                this.h.setEnabled(true);
                                this.g.getElement().removeAttribute("title");
                            } else {
                                this.h.setEnabled(false);
                                this.h.getElement().setAttribute("title", String.format("Your role '%s' does not have the privileges needed for this action.", this.controller.getConsoleUser().getRole()));
                            }
                            this.i.setEnabled(!this.k);
                        } else {
                            this.g.setEnabled(false);
                            this.h.setEnabled(false);
                            this.i.setEnabled(false);
                        }
                    }
                };
            }
            case "lambda$init$9b1b5227$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/TableCapturePanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                return (ComponentEventListener & Serializable)event -> this.a(true);
            }
            case "lambda$init$9b1b5227$2": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/TableCapturePanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                return (ComponentEventListener & Serializable)event -> new a(null).open();
            }
            case "lambda$init$9b1b5227$3": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/TableCapturePanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                return (ComponentEventListener & Serializable)event -> new a(this.b.getSelectedItems()).open();
            }
            case "lambda$init$9b1b5227$4": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/TableCapturePanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                return (ComponentEventListener & Serializable)event -> this.a();
            }
            case "lambda$init$9b1b5227$5": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/TableCapturePanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                return (ComponentEventListener & Serializable)event -> new b((TriggerHistory)this.b.getSelectedItems().iterator().next()).open();
            }
            case "lambda$init$9b1b5227$6": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/TableCapturePanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/grid/ItemClickEvent;)V")) break;
                return (ComponentEventListener & Serializable)event -> {
                    if (event.getColumn() != null) {
                        this.b.deselectAll();
                        this.b.select((Object)((TriggerHistory)event.getItem()));
                    }
                };
            }
            case "lambda$init$9b1b5227$7": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/TableCapturePanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                return (ComponentEventListener & Serializable)event -> {
                    for (TriggerHistory trigger : this.b.getDataProvider().fetch(new Query()).collect(Collectors.toList())) {
                        this.b.select((Object)trigger);
                    }
                };
            }
            case "lambda$init$9b1b5227$8": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/TableCapturePanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                return (ComponentEventListener & Serializable)event -> this.b.deselectAll();
            }
            case "lambda$init$3fed5817$1": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/SerializableFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/TableCapturePanel") || !lambda.getImplMethodSignature().equals("(Lorg/jumpmind/symmetric/model/TriggerHistory;)Ljava/lang/String;")) break;
                return (SerializableFunction & Serializable)item -> {
                    if (item.getErrorMessage() != null || item.getCreateTime() == null) {
                        return "v-grid-row-marked";
                    }
                    return null;
                };
            }
            case "lambda$inactivate$9b1b5227$1": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/TableCapturePanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/confirmdialog/ConfirmDialog$CancelEvent;)V")) break;
                return (ComponentEventListener & Serializable)e2 -> {};
            }
            case "lambda$init$ba6e7b7d$13": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/TableCapturePanel") || !lambda.getImplMethodSignature().equals("(Lorg/jumpmind/symmetric/model/TriggerHistory;)Ljava/util/Date;")) break;
                return (ValueProvider & Serializable)trigger -> trigger.getCreateTime();
            }
            case "lambda$init$ba6e7b7d$12": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/TableCapturePanel") || !lambda.getImplMethodSignature().equals("(Lorg/jumpmind/symmetric/model/TriggerHistory;)Ljava/lang/Object;")) break;
                return (ValueProvider & Serializable)trigger -> as.formatDate(this.controller, trigger.getCreateTime(), true);
            }
            case "lambda$init$ba6e7b7d$11": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/TableCapturePanel") || !lambda.getImplMethodSignature().equals("(Lorg/jumpmind/symmetric/model/TriggerHistory;)Ljava/lang/Object;")) break;
                return (ValueProvider & Serializable)trigger -> trigger.getErrorMessage();
            }
            case "lambda$init$ba6e7b7d$10": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/TableCapturePanel") || !lambda.getImplMethodSignature().equals("(Lorg/jumpmind/symmetric/model/TriggerHistory;)Ljava/lang/Object;")) break;
                return (ValueProvider & Serializable)trigger -> trigger.getLastTriggerBuildReason() != null ? trigger.getLastTriggerBuildReason().name() : null;
            }
            case "lambda$init$3fab9f70$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/HasValue$ValueChangeListener") || !lambda.getFunctionalInterfaceMethodName().equals("valueChanged") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/HasValue$ValueChangeEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/TableCapturePanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/AbstractField$ComponentValueChangeEvent;)V")) break;
                return (HasValue.ValueChangeListener & Serializable)event -> this.a(true);
            }
            case "lambda$init$3fab9f70$2": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/HasValue$ValueChangeListener") || !lambda.getFunctionalInterfaceMethodName().equals("valueChanged") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/HasValue$ValueChangeEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/TableCapturePanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/AbstractField$ComponentValueChangeEvent;)V")) break;
                return (HasValue.ValueChangeListener & Serializable)event -> this.a(true);
            }
        }
        throw new IllegalArgumentException("Invalid lambda deserialization");
    }

    class b
    extends ResizableDialog {
        private static final long b = 1L;
        private IDdlReader c;
        private Table d;
        private TabbedApplicationPanel e;

        public b(TriggerHistory triggerHistory) {
            super(di.this.controller.getMessage("View Text of '%s' Trigger", triggerHistory.getTriggerId()));
            this.c = di.this.controller.getSymmetricEngine().getDatabasePlatform().getDdlReader();
            if (triggerHistory.getErrorMessage() == null) {
                this.d = this.c.readTable(triggerHistory.getSourceCatalogName(), triggerHistory.getSourceSchemaName(), triggerHistory.getSourceTableName());
                if (this.d == null) {
                    this.d = di.this.controller.getSymmetricEngine().getDatabasePlatform().getTableFromCache(triggerHistory.getSourceTableName(), false);
                }
            }
            this.setCloseOnEsc(true);
            this.setCloseOnOutsideClick(true);
            this.setModal(true);
            this.setResizable(true);
            this.e = new TabbedApplicationPanel();
            this.e.setHeight("100px");
            this.e.setWidthFull();
            if (this.d != null) {
                this.a(triggerHistory.getNameForInsertTrigger(), "Insert");
                this.a(triggerHistory.getNameForUpdateTrigger(), "Update");
                this.a(triggerHistory.getNameForDeleteTrigger(), "Delete");
            }
            VerticalLayout layout = new VerticalLayout();
            layout.getStyle().set("padding", "0");
            if (this.e.getTabCount() > 0) {
                layout.add(new Component[]{this.e});
                layout.expand(new Component[]{this.e});
                UI.getCurrent().getPage().retrieveExtendedClientDetails((Page.ExtendedClientDetailsReceiver & Serializable)details -> {
                    this.setHeight(details.getWindowInnerHeight() - 300 + "px");
                    this.setWidth(details.getWindowInnerWidth() - 600 + "px");
                });
            } else {
                this.innerContent.getStyle().set("margin", "0");
                Span message = null;
                message = triggerHistory.getErrorMessage() != null ? new Span(triggerHistory.getErrorMessage()) : new Span(di.this.controller.getMessage("There are no insert, update, or delete triggers associated with the id '%s'.", triggerHistory.getTriggerId()));
                message.setWidth("360px");
                message.getStyle().set("margin", "0");
                layout.add(new Component[]{message});
                layout.expand(new Component[]{message});
                layout.setHorizontalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{message});
                this.setHeight("250px");
                this.setWidth("400px");
            }
            layout.setSizeFull();
            this.add((Component)layout);
            this.buildButtonFooter(new Component[]{this.buildCloseButton()});
        }

        private void a(String triggerName, String triggerType) {
            org.jumpmind.db.model.Trigger trigger;
            if (triggerName != null && (trigger = this.c.getTriggerFor(this.d, triggerName)) != null) {
                AceEditor editor = as.createAceEditor();
                editor.setMode(AceMode.sql);
                editor.setReadOnly(true);
                editor.setValue(trigger.getSource());
                this.e.add((Component)editor, triggerType, new Icon(VaadinIcon.CROSSHAIRS));
            }
        }

        private static /* synthetic */ Object a(SerializedLambda lambda) {
            switch (lambda.getImplMethodName()) {
                case "lambda$new$5fb05918$1": {
                    if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/page/Page$ExtendedClientDetailsReceiver") || !lambda.getFunctionalInterfaceMethodName().equals("receiveDetails") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/page/ExtendedClientDetails;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/TableCapturePanel$TriggerTextDialog") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/page/ExtendedClientDetails;)V")) break;
                    return (Page.ExtendedClientDetailsReceiver & Serializable)details -> {
                        this.setHeight(details.getWindowInnerHeight() - 300 + "px");
                        this.setWidth(details.getWindowInnerWidth() - 600 + "px");
                    };
                }
            }
            throw new IllegalArgumentException("Invalid lambda deserialization");
        }
    }

    class a
    extends ConfirmDialog {
        private static final long e = 1L;
        Checkbox a;
        TextField b = new TextField();
        Set<TriggerHistory> c;

        public a(Set<TriggerHistory> triggerHists) {
            this.setHeader(di.this.message("Confirm Reconfigure Table Capture", new Object[0]));
            this.c = triggerHists;
            VerticalLayout layout = new VerticalLayout();
            layout.setMargin(false);
            layout.setSpacing(true);
            Span instructions = new Span();
            if (triggerHists != null) {
                instructions.setText(di.this.message("Do you want to reconfigure the selected %s table(s) for capture?", new Object[]{triggerHists.size()}));
            } else {
                instructions.setText(di.this.message("Do you want to reconfigure all tables for capture?", new Object[0]));
            }
            this.a = new Checkbox("Force reconfigure even if no changes are detected");
            layout.add(new Component[]{instructions, this.a});
            if (triggerHists == null && di.this.controller.getSymmetricEngine().getCacheManager().isUsingTargetExternalId(false)) {
                this.b.setLabel("Target External ID");
                layout.add(new Component[]{this.b});
            }
            this.setText((Component)layout);
            this.setConfirmButton(di.this.message("Reconfigure", new Object[0]), (ComponentEventListener & Serializable)e2 -> this.a());
            this.setCancelButton(di.this.message("Cancel", new Object[0]), (ComponentEventListener & Serializable)e2 -> {});
        }

        protected void a() {
            N<Object> dialog = new N<Object>("Preparing Replication...", new ai(di.this.controller, di.this.b.getUI().orElse(null), this.c, this.b.getValue(), (Boolean)this.a.getValue(), this.c != null && (long)this.c.size() == di.this.b.getDataProvider().fetch(new Query()).count()){

                @Override
                public void doUI(Object data) {
                    super.doUI(data);
                    di.this.a(false);
                }
            }, di.this.controller);
            dialog.show();
        }

        private static /* synthetic */ Object a(SerializedLambda lambda) {
            switch (lambda.getImplMethodName()) {
                case "lambda$new$65aa63c7$2": {
                    if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/TableCapturePanel$ConfirmReconfigureDialog") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/confirmdialog/ConfirmDialog$CancelEvent;)V")) break;
                    return (ComponentEventListener & Serializable)e2 -> {};
                }
                case "lambda$new$65aa63c7$1": {
                    if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/TableCapturePanel$ConfirmReconfigureDialog") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/confirmdialog/ConfirmDialog$ConfirmEvent;)V")) break;
                    return (ComponentEventListener & Serializable)e2 -> this.a();
                }
            }
            throw new IllegalArgumentException("Invalid lambda deserialization");
        }
    }
}

