/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.impl.df;
import com.jumpmind.symmetric.console.impl.dl;
import com.jumpmind.symmetric.console.model.ConsoleEvent;
import com.jumpmind.symmetric.console.model.ConsoleUser;
import com.jumpmind.symmetric.console.ui.common.H;
import com.jumpmind.symmetric.console.ui.common.I;
import com.jumpmind.symmetric.console.ui.common.J;
import com.jumpmind.symmetric.console.ui.common.K;
import com.jumpmind.symmetric.console.ui.common.M;
import com.jumpmind.symmetric.console.ui.common.an;
import com.jumpmind.symmetric.console.ui.common.ap;
import com.jumpmind.symmetric.console.ui.common.as;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.confirmdialog.ConfirmDialog;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Anchor;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.component.treegrid.TreeGrid;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalDataProvider;
import com.vaadin.flow.data.provider.hierarchy.TreeData;
import com.vaadin.flow.data.provider.hierarchy.TreeDataProvider;
import com.vaadin.flow.data.selection.SelectionListener;
import com.vaadin.flow.data.value.ValueChangeMode;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.server.streams.DownloadHandler;
import com.vaadin.flow.server.streams.DownloadResponse;
import com.vaadin.flow.server.streams.InputStreamDownloadCallback;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.io.stage.IStagedResource;
import org.jumpmind.symmetric.io.stage.IStagingManager;
import org.jumpmind.symmetric.io.stage.StagingManager;
import org.jumpmind.symmetric.job.IJob;
import org.jumpmind.symmetric.job.IJobManager;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;

public class de
extends ap
implements H,
J {
    private static final long l = 1L;
    HorizontalLayout a;
    HorizontalLayout b;
    TreeGrid<dl> c;
    TreeData<dl> d = new TreeData();
    Set<dl> e;
    Set<dl> f;
    Button g;
    Button h;
    Button i;
    String j = "";
    Anchor k;

    public de(I controller) {
        super(controller, null, "The staging area is where data is extracted to (outgoing) and where data is transported to (incoming) when stream.to.file.enabled is enabled.  stream.to.file.threshold.bytes controls the size the payload must be before it will be flushed to the file system.");
    }

    @Override
    public void init() {
        if (this.c == null) {
            boolean rightButtonGroupVisible;
            String directory = this.controller.getSymmetricEngine().getParameterService().getString("staging.dir");
            if (StringUtils.isEmpty((CharSequence)directory)) {
                directory = System.getProperty("java.io.tmpdir");
            }
            Span directorySpan = new Span(this.controller.getMessage("Staging directory: %s", directory));
            this.content.add(new Component[]{directorySpan});
            this.a = new HorizontalLayout();
            Span jobSpan = new Span(this.controller.getMessage("The Stage Management job has not run.", new Object[0]));
            this.a.add(new Component[]{jobSpan});
            this.a.setVerticalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{jobSpan});
            ConsoleUser user = this.controller.getConsoleUser();
            if (user.hasPrivilegeWrite("Run Jobs")) {
                Button runButton = new Button(this.controller.getMessage("Run Now", new Object[0]));
                runButton.addClickListener((ComponentEventListener & Serializable)event -> {
                    String jobName = "Stage Management";
                    IJobManager jobManager = this.controller.getSymmetricEngine().getJobManager();
                    IJob job = jobManager.getJob(jobName);
                    if (!job.isRunning()) {
                        new M<Boolean>(String.format("Running %s...", jobName), new b(jobName), this.controller.getBackgroundRefresherService()).show();
                        String nodeId = this.controller.getSymmetricEngine().getNodeId();
                        this.controller.getConsoleEventService().addEvent(new ConsoleEvent(this.controller.getConsoleUser().getUserId(), "Run Job Now", nodeId, nodeId, null, jobName));
                    } else {
                        this.notification("Cannot invoke the job.  It is already running.", new Object[0]);
                    }
                });
                this.a.add(new Component[]{runButton});
            }
            this.a.setVisible(false);
            this.content.add(new Component[]{this.a});
            this.b = new HorizontalLayout();
            this.b.setSpacing(true);
            Button refreshButton = as.createIconButton(K.REFRESH);
            refreshButton.addClickListener((ComponentEventListener & Serializable)event -> this.onRefresh(new Object[0]));
            this.b.add(new Component[]{refreshButton});
            String role = user.getRole();
            if (user.hasPrivilegeRead("Clear Staging")) {
                Button clearStagingButton = new Button("Clear Staging");
                clearStagingButton.addClickListener((ComponentEventListener & Serializable)event -> new ConfirmDialog(this.controller.getMessage("Confirm", new Object[0]), "All staged resources that are not currently being written to will be removed.  Are you sure you want to do this?", this.controller.getMessage("Ok", new Object[0]), (ComponentEventListener & Serializable)e2 -> {
                    IStagingManager stagingManager = this.controller.getSymmetricEngine().getStagingManager();
                    long count = stagingManager.clean(0L);
                    String nodeId = this.controller.getSymmetricEngine().getNodeId();
                    this.controller.getConsoleEventService().addEvent(new ConsoleEvent(this.controller.getConsoleUser().getUserId(), "Clear staging", nodeId, nodeId, null, this.controller.getMessage("Size of space cleared: %s", as.formatFileSize(count))));
                    this.onRefresh(new Object[0]);
                    this.notification("Size of space cleared: %s", as.formatFileSize(count));
                }, this.controller.getMessage("Cancel", new Object[0]), (ComponentEventListener & Serializable)e2 -> {}).open());
                this.b.add(new Component[]{clearStagingButton});
                if (!user.hasPrivilegeWrite("Clear Staging")) {
                    clearStagingButton.setEnabled(false);
                    clearStagingButton.getElement().setAttribute("title", this.controller.getMessage("Your role '%s' does not have the privileges needed for this action.", role));
                }
            }
            if (user.hasPrivilegeRead("Test Staging")) {
                Button testStagingButton = new Button("Test Staging");
                testStagingButton.addClickListener((ComponentEventListener & Serializable)event -> new df(this.controller).open());
                this.b.add(new Component[]{testStagingButton});
                if (!user.hasPrivilegeWrite("Test Staging")) {
                    testStagingButton.setEnabled(false);
                    testStagingButton.getElement().setAttribute("title", this.controller.getMessage("Your role '%s' does not have the privileges needed for this action.", role));
                }
            }
            boolean downloadButtonVisible = user.hasPrivilegeRead("Download Staging Files");
            boolean editButtonVisible = user.hasPrivilegeRead("Edit Staging Files");
            boolean removeButtonVisible = user.hasPrivilegeRead("Remove Staging Files");
            boolean bl2 = rightButtonGroupVisible = downloadButtonVisible || editButtonVisible || removeButtonVisible;
            if (rightButtonGroupVisible) {
                Span separator = new Span();
                separator.setClassName("vrule");
                separator.setWidth(null);
                separator.setHeight("100%");
                this.b.add(new Component[]{separator});
            }
            this.g = new Button("Download");
            this.g.setVisible(downloadButtonVisible);
            this.g.setEnabled(false);
            boolean downloadButtonEnabled = user.hasPrivilegeWrite("Download Staging Files");
            if (!downloadButtonEnabled) {
                this.g.getElement().setAttribute("title", this.controller.getMessage("Your role '%s' does not have the privileges needed for this action.", role));
            }
            this.g.addClickListener((ComponentEventListener & Serializable)event -> {
                String nodeId = this.controller.getSymmetricEngine().getNodeId();
                this.controller.getConsoleEventService().addEvent(new ConsoleEvent(this.controller.getConsoleUser().getUserId(), "Download staging file", nodeId, nodeId, null, ((dl)this.c.getSelectedItems().iterator().next()).a()));
            });
            this.k = new Anchor();
            this.k.add(new Component[]{this.g});
            this.b.add(new Component[]{this.k});
            this.h = new Button("Edit");
            this.h.setVisible(editButtonVisible);
            this.h.setEnabled(false);
            boolean editButtonEnabled = user.hasPrivilegeWrite("Edit Staging Files");
            if (!editButtonEnabled) {
                this.h.getElement().setAttribute("title", this.controller.getMessage("Your role '%s' does not have the privileges needed for this action.", role));
            }
            this.h.addClickListener((ComponentEventListener & Serializable)event -> {
                IStagedResource resource = this.a((dl)this.c.getSelectedItems().iterator().next());
                if (resource.getSize() <= this.controller.getSymmetricEngine().getParameterService().getLong("staging.screen.edit.max.bytes")) {
                    new a(this.controller, resource).open();
                } else {
                    CommonUiUtils.notify((String)this.controller.getMessage("The selected file is too large to be edited via the web console.", new Object[0]));
                }
            });
            this.b.add(new Component[]{this.h});
            this.i = new Button("Remove");
            this.i.setVisible(removeButtonVisible);
            this.i.setEnabled(false);
            boolean removeButtonEnabled = user.hasPrivilegeWrite("Remove Staging Files");
            if (!removeButtonEnabled) {
                this.i.getElement().setAttribute("title", this.controller.getMessage("Your role '%s' does not have the privileges needed for this action.", role));
            }
            this.i.addClickListener((ComponentEventListener & Serializable)event -> new ConfirmDialog(this.controller.getMessage("Confirm", new Object[0]), "Are you sure you want to remove the selected file?", this.controller.getMessage("Ok", new Object[0]), (ComponentEventListener & Serializable)e2 -> {
                StagingManager stagingManager = (StagingManager)this.controller.getSymmetricEngine().getStagingManager();
                String filePath = ((dl)this.c.getSelectedItems().iterator().next()).a();
                IStagedResource resource = stagingManager.find(filePath);
                stagingManager.removeResourcePath(filePath);
                resource.delete();
                String nodeId = this.controller.getSymmetricEngine().getNodeId();
                this.controller.getConsoleEventService().addEvent(new ConsoleEvent(this.controller.getConsoleUser().getUserId(), "Remove staging file", nodeId, nodeId, null, filePath));
                this.onRefresh(new Object[0]);
            }, this.controller.getMessage("Cancel", new Object[0]), (ComponentEventListener & Serializable)e2 -> {}).open());
            this.b.add(new Component[]{this.i});
            this.b.addAndExpand(new Component[]{new Span()});
            TextField filterField = new TextField();
            filterField.setPrefixComponent((Component)new Icon(VaadinIcon.SEARCH));
            filterField.setPlaceholder("Filter Files");
            filterField.setValueChangeMode(ValueChangeMode.LAZY);
            filterField.setValueChangeTimeout(200);
            this.b.add(new Component[]{filterField});
            this.content.add(new Component[]{this.b});
            this.c = new TreeGrid();
            this.c.addComponentHierarchyColumn((ValueProvider & Serializable)node -> {
                HorizontalLayout cell = new HorizontalLayout();
                Image icon = node.b().equals("resource") ? as.createImage(this.controller.getContextPath(), "/icons/text.png") : as.createImage(this.controller.getContextPath(), "/icons/folder.png");
                cell.add(new Component[]{icon});
                String name = node.a();
                if (name.lastIndexOf("/") != -1) {
                    name = name.substring(name.lastIndexOf("/") + 1);
                }
                cell.add(new Component[]{new Span(name)});
                return cell;
            }).setHeader("");
            this.c.addColumn((ValueProvider & Serializable)node -> {
                IStagedResource resource = this.a((dl)node);
                if (resource != null) {
                    return resource.isFileResource() ? "File" : "Memory";
                }
                return "";
            }).setHeader("Type");
            this.c.addColumn((ValueProvider & Serializable)node -> {
                IStagedResource resource = this.a((dl)node);
                if (resource != null) {
                    return resource.getState().name();
                }
                return "";
            }).setHeader("Status");
            this.c.addColumn((ValueProvider & Serializable)node -> {
                IStagedResource resource = this.a((dl)node);
                if (resource != null) {
                    return resource.getSize();
                }
                return "";
            }).setHeader("Byte Count");
            this.c.addColumn((ValueProvider & Serializable)node -> {
                IStagedResource resource = this.a((dl)node);
                if (resource != null) {
                    return as.formatDate(this.controller, new Date(resource.getLastUpdateTime()), true);
                }
                return "";
            }).setHeader("Last Update Time");
            for (Grid.Column column : this.c.getColumns()) {
                column.setResizable(true);
            }
            this.c.setSizeFull();
            if (rightButtonGroupVisible) {
                this.c.addSelectionListener((SelectionListener & Serializable)event -> {
                    if (!this.c.getSelectedItems().isEmpty() && !((dl)this.c.getSelectedItems().iterator().next()).c()) {
                        if (downloadButtonEnabled) {
                            this.b();
                            this.g.setEnabled(true);
                        }
                        this.h.setEnabled(editButtonEnabled);
                        this.i.setEnabled(removeButtonEnabled);
                    } else {
                        this.g.setEnabled(false);
                        this.h.setEnabled(false);
                        this.i.setEnabled(false);
                    }
                });
            } else {
                this.c.setSelectionMode(Grid.SelectionMode.NONE);
            }
            this.f = new LinkedHashSet<dl>();
            this.c.addExpandListener((ComponentEventListener & Serializable)event -> {
                dl node = (dl)event.getItems().iterator().next();
                this.f.add(node);
                dl firstChild = (dl)this.d.getChildren((Object)node).get(0);
                if (node.c() && firstChild.b().equals("placeholder")) {
                    this.d.removeItem((Object)firstChild);
                    for (dl child : node.d()) {
                        if (!this.e.contains(child)) continue;
                        this.d.addItem((Object)node, (Object)child);
                        if (!child.c()) continue;
                        this.d.addItem((Object)child, (Object)new dl(child.a(), "placeholder"));
                    }
                    this.a();
                }
            });
            this.c.addCollapseListener((ComponentEventListener & Serializable)event -> {
                dl node = (dl)event.getItems().iterator().next();
                this.f.remove(node);
                for (dl child : new ArrayList(this.d.getChildren((Object)node))) {
                    if (this.f.contains(child)) {
                        this.c.collapse((Object[])new dl[]{child});
                    }
                    this.d.removeItem((Object)child);
                }
                this.d.addItem((Object)node, (Object)new dl(node.a(), "placeholder"));
                if (event.isFromClient()) {
                    this.a();
                }
            });
            this.content.addAndExpand(new Component[]{this.c});
            filterField.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                this.j = (String)event.getValue();
                this.onRefresh(new Object[0]);
            });
        }
    }

    protected IStagedResource a(dl treeNode) {
        if (treeNode.b().equals("resource")) {
            ISymmetricEngine engine = this.controller.getSymmetricEngine();
            IStagingManager stagingManager = engine.getStagingManager();
            return stagingManager.find(treeNode.a());
        }
        return null;
    }

    @Override
    public String getTitleKey() {
        return "Staging Area";
    }

    @Override
    public void onRefresh(Object ... params) {
        ISymmetricEngine engine = this.controller.getSymmetricEngine();
        IStagingManager stagingManager = engine.getStagingManager();
        Set paths = stagingManager.getResourceReferences();
        List<dl> nodes = this.a(paths);
        this.d.clear();
        this.f.clear();
        this.e = new HashSet<dl>();
        this.a(nodes);
        this.a();
        this.a.setVisible(this.controller.getSymmetricEngine().getJobManager().getJob("Stage Management").getLastExecutionTimeInMs() <= 0L);
    }

    protected void a() {
        Set selectedItems = this.c.getSelectedItems();
        this.c.setDataProvider((HierarchicalDataProvider)new TreeDataProvider(this.d));
        if (!selectedItems.isEmpty()) {
            this.c.select((Object)((dl)selectedItems.iterator().next()));
        }
        if (!this.f.isEmpty()) {
            this.c.expand(this.f);
        }
    }

    protected boolean b(dl node) {
        if (!CommonUiUtils.isFilteredOut((String)node.a(), (String)this.j)) {
            this.e.add(node);
            this.e.addAll(this.c(node));
            return true;
        }
        boolean childMeetsCriteria = false;
        for (dl child : new HashSet<dl>(node.d())) {
            if (this.b(child)) {
                this.e.add(child);
                childMeetsCriteria = true;
                continue;
            }
            this.f.remove(child);
        }
        return childMeetsCriteria;
    }

    public Set<dl> c(dl parent) {
        HashSet<dl> children = new HashSet<dl>();
        for (dl child : parent.d()) {
            children.add(child);
            children.addAll(this.c(child));
        }
        return children;
    }

    protected void a(List<dl> nodes) {
        Collections.sort(nodes, new Comparator<dl>(){

            public int a(dl o1, dl o2) {
                return o1.a().compareTo(o2.a());
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((dl)object, (dl)object2);
            }
        });
        for (dl treeNode : nodes) {
            if (this.b(treeNode)) {
                this.d.addItem(null, (Object)treeNode);
                if (!treeNode.c()) continue;
                this.d.addItem((Object)treeNode, (Object)new dl(treeNode.a(), "placeholder"));
                continue;
            }
            this.f.remove(treeNode);
        }
    }

    protected List<dl> a(Collection<String> paths) {
        ArrayList<dl> nodes = new ArrayList<dl>();
        for (String path : paths) {
            String[] pathTokens = path.split("/");
            List<dl> children = nodes;
            StringBuilder fullPath = new StringBuilder();
            int depth = 1;
            for (String pathToken : pathTokens) {
                if (!StringUtils.isNotBlank((CharSequence)pathToken)) continue;
                fullPath.append(pathToken).append("/");
                dl pathNode = this.a(children, fullPath.toString().substring(0, fullPath.length() - 1), pathToken, pathTokens.length == depth++);
                children = pathNode.d();
            }
        }
        return nodes;
    }

    protected dl a(List<dl> nodes, String fullPath, String pathPart, boolean resource) {
        for (dl treeNode : nodes) {
            if (!treeNode.f().get("pathToken").equals(pathPart)) continue;
            return treeNode;
        }
        dl node = new dl(fullPath, resource ? "resource" : "path");
        node.f().put((Object)"pathToken", (Object)pathPart);
        nodes.add(node);
        return node;
    }

    protected void b() {
        if (this.k != null) {
            this.k.remove(new Component[0]);
            this.b.remove(new Component[]{this.k});
        }
        this.k = new Anchor(this.c(), null);
        this.k.getElement().setAttribute("download", true);
        this.b.addComponentAtIndex(this.b.indexOf((Component)this.h), (Component)this.k);
        this.k.add(new Component[]{this.g});
    }

    private DownloadHandler c() {
        dl node = (dl)this.c.getSelectedItems().iterator().next();
        String nodeName = node.a();
        if (nodeName.lastIndexOf("/") != -1) {
            nodeName = nodeName.substring(nodeName.lastIndexOf("/") + 1);
        }
        String fileName = nodeName + ".csv";
        return DownloadHandler.fromInputStream((InputStreamDownloadCallback & Serializable)event -> {
            IStagedResource resource = this.controller.getSymmetricEngine().getStagingManager().find(node.a());
            if (resource.exists()) {
                try {
                    InputStream inputStream = IOUtils.toInputStream((String)IOUtils.toString((Reader)resource.getReader()), (Charset)Charset.defaultCharset());
                    return new DownloadResponse(inputStream, fileName, null, -1L);
                }
                catch (IOException e2) {
                    this.log.error(String.format("An error was encountered while downloading csv data. ", new Object[0]), (Throwable)e2);
                    throw e2;
                }
            }
            CommonUiUtils.notifyError((String)"File not found");
            return null;
        });
    }

    @Override
    public boolean onExit(Runnable exitClosure) {
        return true;
    }

    @Override
    public String getDocAnchor() {
        return "/doc/html/user-guide.html#_staging_area";
    }

    private static /* synthetic */ Object a(SerializedLambda lambda) {
        switch (lambda.getImplMethodName()) {
            case "lambda$init$9b1b5227$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/StagingAreaPanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                return (ComponentEventListener & Serializable)event -> {
                    String jobName = "Stage Management";
                    IJobManager jobManager = this.controller.getSymmetricEngine().getJobManager();
                    IJob job = jobManager.getJob(jobName);
                    if (!job.isRunning()) {
                        new M<Boolean>(String.format("Running %s...", jobName), new b(jobName), this.controller.getBackgroundRefresherService()).show();
                        String nodeId = this.controller.getSymmetricEngine().getNodeId();
                        this.controller.getConsoleEventService().addEvent(new ConsoleEvent(this.controller.getConsoleUser().getUserId(), "Run Job Now", nodeId, nodeId, null, jobName));
                    } else {
                        this.notification("Cannot invoke the job.  It is already running.", new Object[0]);
                    }
                };
            }
            case "lambda$init$9b1b5227$2": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/StagingAreaPanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                return (ComponentEventListener & Serializable)event -> this.onRefresh(new Object[0]);
            }
            case "lambda$init$9b1b5227$3": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/StagingAreaPanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/confirmdialog/ConfirmDialog$ConfirmEvent;)V")) break;
                return (ComponentEventListener & Serializable)e2 -> {
                    IStagingManager stagingManager = this.controller.getSymmetricEngine().getStagingManager();
                    long count = stagingManager.clean(0L);
                    String nodeId = this.controller.getSymmetricEngine().getNodeId();
                    this.controller.getConsoleEventService().addEvent(new ConsoleEvent(this.controller.getConsoleUser().getUserId(), "Clear staging", nodeId, nodeId, null, this.controller.getMessage("Size of space cleared: %s", as.formatFileSize(count))));
                    this.onRefresh(new Object[0]);
                    this.notification("Size of space cleared: %s", as.formatFileSize(count));
                };
            }
            case "lambda$init$ba6e7b7d$2": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/StagingAreaPanel") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/ui/screen/manage/TreeNode;)Ljava/lang/Object;")) break;
                return (ValueProvider & Serializable)node -> {
                    IStagedResource resource = this.a((dl)node);
                    if (resource != null) {
                        return resource.isFileResource() ? "File" : "Memory";
                    }
                    return "";
                };
            }
            case "lambda$init$9b1b5227$4": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/StagingAreaPanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/confirmdialog/ConfirmDialog$CancelEvent;)V")) break;
                return (ComponentEventListener & Serializable)e2 -> {};
            }
            case "lambda$init$ba6e7b7d$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/StagingAreaPanel") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/ui/screen/manage/TreeNode;)Lcom/vaadin/flow/component/orderedlayout/HorizontalLayout;")) break;
                return (ValueProvider & Serializable)node -> {
                    HorizontalLayout cell = new HorizontalLayout();
                    Image icon = node.b().equals("resource") ? as.createImage(this.controller.getContextPath(), "/icons/text.png") : as.createImage(this.controller.getContextPath(), "/icons/folder.png");
                    cell.add(new Component[]{icon});
                    String name = node.a();
                    if (name.lastIndexOf("/") != -1) {
                        name = name.substring(name.lastIndexOf("/") + 1);
                    }
                    cell.add(new Component[]{new Span(name)});
                    return cell;
                };
            }
            case "lambda$init$9b1b5227$5": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/StagingAreaPanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                return (ComponentEventListener & Serializable)event -> new ConfirmDialog(this.controller.getMessage("Confirm", new Object[0]), "All staged resources that are not currently being written to will be removed.  Are you sure you want to do this?", this.controller.getMessage("Ok", new Object[0]), (ComponentEventListener & Serializable)e2 -> {
                    IStagingManager stagingManager = this.controller.getSymmetricEngine().getStagingManager();
                    long count = stagingManager.clean(0L);
                    String nodeId = this.controller.getSymmetricEngine().getNodeId();
                    this.controller.getConsoleEventService().addEvent(new ConsoleEvent(this.controller.getConsoleUser().getUserId(), "Clear staging", nodeId, nodeId, null, this.controller.getMessage("Size of space cleared: %s", as.formatFileSize(count))));
                    this.onRefresh(new Object[0]);
                    this.notification("Size of space cleared: %s", as.formatFileSize(count));
                }, this.controller.getMessage("Cancel", new Object[0]), (ComponentEventListener & Serializable)e2 -> {}).open();
            }
            case "lambda$init$ba6e7b7d$4": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/StagingAreaPanel") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/ui/screen/manage/TreeNode;)Ljava/lang/Object;")) break;
                return (ValueProvider & Serializable)node -> {
                    IStagedResource resource = this.a((dl)node);
                    if (resource != null) {
                        return resource.getSize();
                    }
                    return "";
                };
            }
            case "lambda$init$9b1b5227$6": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/StagingAreaPanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                return (ComponentEventListener & Serializable)event -> new df(this.controller).open();
            }
            case "lambda$init$ba6e7b7d$3": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/StagingAreaPanel") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/ui/screen/manage/TreeNode;)Ljava/lang/Object;")) break;
                return (ValueProvider & Serializable)node -> {
                    IStagedResource resource = this.a((dl)node);
                    if (resource != null) {
                        return resource.getState().name();
                    }
                    return "";
                };
            }
            case "lambda$init$9b1b5227$7": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/StagingAreaPanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                return (ComponentEventListener & Serializable)event -> {
                    String nodeId = this.controller.getSymmetricEngine().getNodeId();
                    this.controller.getConsoleEventService().addEvent(new ConsoleEvent(this.controller.getConsoleUser().getUserId(), "Download staging file", nodeId, nodeId, null, ((dl)this.c.getSelectedItems().iterator().next()).a()));
                };
            }
            case "lambda$init$9b1b5227$8": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/StagingAreaPanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                return (ComponentEventListener & Serializable)event -> {
                    IStagedResource resource = this.a((dl)this.c.getSelectedItems().iterator().next());
                    if (resource.getSize() <= this.controller.getSymmetricEngine().getParameterService().getLong("staging.screen.edit.max.bytes")) {
                        new a(this.controller, resource).open();
                    } else {
                        CommonUiUtils.notify((String)this.controller.getMessage("The selected file is too large to be edited via the web console.", new Object[0]));
                    }
                };
            }
            case "lambda$init$ba6e7b7d$5": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/StagingAreaPanel") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/ui/screen/manage/TreeNode;)Ljava/lang/Object;")) break;
                return (ValueProvider & Serializable)node -> {
                    IStagedResource resource = this.a((dl)node);
                    if (resource != null) {
                        return as.formatDate(this.controller, new Date(resource.getLastUpdateTime()), true);
                    }
                    return "";
                };
            }
            case "lambda$init$9b1b5227$9": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/StagingAreaPanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/confirmdialog/ConfirmDialog$ConfirmEvent;)V")) break;
                return (ComponentEventListener & Serializable)e2 -> {
                    StagingManager stagingManager = (StagingManager)this.controller.getSymmetricEngine().getStagingManager();
                    String filePath = ((dl)this.c.getSelectedItems().iterator().next()).a();
                    IStagedResource resource = stagingManager.find(filePath);
                    stagingManager.removeResourcePath(filePath);
                    resource.delete();
                    String nodeId = this.controller.getSymmetricEngine().getNodeId();
                    this.controller.getConsoleEventService().addEvent(new ConsoleEvent(this.controller.getConsoleUser().getUserId(), "Remove staging file", nodeId, nodeId, null, filePath));
                    this.onRefresh(new Object[0]);
                };
            }
            case "lambda$createDownloadHandler$e6107f3d$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/server/streams/InputStreamDownloadCallback") || !lambda.getFunctionalInterfaceMethodName().equals("complete") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/server/streams/DownloadEvent;)Lcom/vaadin/flow/server/streams/DownloadResponse;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/StagingAreaPanel") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/ui/screen/manage/TreeNode;Ljava/lang/String;Lcom/vaadin/flow/server/streams/DownloadEvent;)Lcom/vaadin/flow/server/streams/DownloadResponse;")) break;
                return arg_0 -> ((de)lambda.getCapturedArg(0)).a((dl)lambda.getCapturedArg(1), (String)lambda.getCapturedArg(2), arg_0);
            }
            case "lambda$init$9b1b5227$12": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/StagingAreaPanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/treegrid/ExpandEvent;)V")) break;
                return (ComponentEventListener & Serializable)event -> {
                    dl node = (dl)event.getItems().iterator().next();
                    this.f.add(node);
                    dl firstChild = (dl)this.d.getChildren((Object)node).get(0);
                    if (node.c() && firstChild.b().equals("placeholder")) {
                        this.d.removeItem((Object)firstChild);
                        for (dl child : node.d()) {
                            if (!this.e.contains(child)) continue;
                            this.d.addItem((Object)node, (Object)child);
                            if (!child.c()) continue;
                            this.d.addItem((Object)child, (Object)new dl(child.a(), "placeholder"));
                        }
                        this.a();
                    }
                };
            }
            case "lambda$init$9b1b5227$13": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/StagingAreaPanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/treegrid/CollapseEvent;)V")) break;
                return (ComponentEventListener & Serializable)event -> {
                    dl node = (dl)event.getItems().iterator().next();
                    this.f.remove(node);
                    for (dl child : new ArrayList(this.d.getChildren((Object)node))) {
                        if (this.f.contains(child)) {
                            this.c.collapse((Object[])new dl[]{child});
                        }
                        this.d.removeItem((Object)child);
                    }
                    this.d.addItem((Object)node, (Object)new dl(node.a(), "placeholder"));
                    if (event.isFromClient()) {
                        this.a();
                    }
                };
            }
            case "lambda$init$9b1b5227$10": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/StagingAreaPanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/confirmdialog/ConfirmDialog$CancelEvent;)V")) break;
                return (ComponentEventListener & Serializable)e2 -> {};
            }
            case "lambda$init$9b1b5227$11": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/StagingAreaPanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                return (ComponentEventListener & Serializable)event -> new ConfirmDialog(this.controller.getMessage("Confirm", new Object[0]), "Are you sure you want to remove the selected file?", this.controller.getMessage("Ok", new Object[0]), (ComponentEventListener & Serializable)e2 -> {
                    StagingManager stagingManager = (StagingManager)this.controller.getSymmetricEngine().getStagingManager();
                    String filePath = ((dl)this.c.getSelectedItems().iterator().next()).a();
                    IStagedResource resource = stagingManager.find(filePath);
                    stagingManager.removeResourcePath(filePath);
                    resource.delete();
                    String nodeId = this.controller.getSymmetricEngine().getNodeId();
                    this.controller.getConsoleEventService().addEvent(new ConsoleEvent(this.controller.getConsoleUser().getUserId(), "Remove staging file", nodeId, nodeId, null, filePath));
                    this.onRefresh(new Object[0]);
                }, this.controller.getMessage("Cancel", new Object[0]), (ComponentEventListener & Serializable)e2 -> {}).open();
            }
            case "lambda$init$ee102d8e$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/data/selection/SelectionListener") || !lambda.getFunctionalInterfaceMethodName().equals("selectionChange") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/data/selection/SelectionEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/StagingAreaPanel") || !lambda.getImplMethodSignature().equals("(ZZZLcom/vaadin/flow/data/selection/SelectionEvent;)V")) break;
                return arg_0 -> ((de)lambda.getCapturedArg(0)).a((Boolean)lambda.getCapturedArg(1), (Boolean)lambda.getCapturedArg(2), (Boolean)lambda.getCapturedArg(3), arg_0);
            }
            case "lambda$init$3fab9f70$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/HasValue$ValueChangeListener") || !lambda.getFunctionalInterfaceMethodName().equals("valueChanged") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/HasValue$ValueChangeEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/StagingAreaPanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/AbstractField$ComponentValueChangeEvent;)V")) break;
                return (HasValue.ValueChangeListener & Serializable)event -> {
                    this.j = (String)event.getValue();
                    this.onRefresh(new Object[0]);
                };
            }
        }
        throw new IllegalArgumentException("Invalid lambda deserialization");
    }

    class a
    extends an {
        private static final long d = 1L;
        IStagedResource a;
        TextArea b;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public a(I controller, IStagedResource resource) {
            block9: {
                super(controller, "Edit " + resource.getFile().getName(), null, false, (Object[])null);
                this.a = resource;
                this.setCloseOnEsc(true);
                this.setCloseOnOutsideClick(true);
                this.setResizable(true);
                this.setHeight("630px");
                this.setWidth("800px");
                try {
                    if (resource instanceof com.jumpmind.symmetric.stage.b) {
                        BufferedReader reader = null;
                        try {
                            reader = ((com.jumpmind.symmetric.stage.b)resource).getReader();
                            this.b.setValue(reader.lines().collect(Collectors.joining(System.lineSeparator())));
                            break block9;
                        }
                        catch (Exception ex2) {
                            this.b.setValue(new String(Files.readAllBytes(Paths.get(resource.getFile().getCanonicalPath(), new String[0]))));
                            break block9;
                        }
                        finally {
                            if (reader != null) {
                                resource.close();
                            }
                        }
                    }
                    this.b.setValue(new String(Files.readAllBytes(Paths.get(resource.getFile().getCanonicalPath(), new String[0]))));
                }
                catch (Exception ex3) {
                    String errorText = "Failed to read " + resource.getFile().getName();
                    de.this.log.warn(errorText, (Throwable)ex3);
                    CommonUiUtils.notifyError((String)errorText);
                }
            }
            this.applyButton.setText(controller.getMessage("Save", new Object[0]));
        }

        @Override
        protected void addComponentsToLayout(VerticalLayout layout) {
            this.b = new TextArea();
            this.b.setWidthFull();
            this.b.setHeight("66px");
            layout.add(new Component[]{this.b});
            layout.expand(new Component[]{this.b});
        }

        @Override
        protected boolean apply() {
            try {
                IParameterService parameterService = this.controller.getSymmetricEngine().getParameterService();
                if (this.a instanceof com.jumpmind.symmetric.stage.b && (parameterService.is("stream.to.file.encrypt.enabled", false) || parameterService.is("stream.to.file.compression.enabled", false))) {
                    writer = ((com.jumpmind.symmetric.stage.b)this.a).getWriter(this.controller.getSymmetricEngine().getParameterService().getLong("stream.to.file.threshold.bytes"));
                    writer.write(this.b.getValue());
                    this.a.close();
                } else {
                    writer = new FileWriter(this.a.getFile());
                    writer.write(this.b.getValue());
                    ((OutputStreamWriter)writer).close();
                    this.a.refreshLastUpdateTime();
                }
                String nodeId = this.controller.getSymmetricEngine().getNodeId();
                this.controller.getConsoleEventService().addEvent(new ConsoleEvent(this.controller.getConsoleUser().getUserId(), "Edit staging file", nodeId, nodeId, null, ((dl)de.this.c.getSelectedItems().iterator().next()).a()));
                this.applied = true;
                return true;
            }
            catch (IOException ex2) {
                String errorText = "Failed to write to " + this.a.getFile().getName();
                de.this.log.warn(errorText, (Throwable)ex2);
                CommonUiUtils.notifyError((String)errorText);
                return false;
            }
        }
    }

    class b
    implements M.a<Boolean> {
        String a;

        public b(String jobName) {
            this.a = jobName;
        }

        public Boolean a() {
            IJobManager jobManager = de.this.controller.getSymmetricEngine().getJobManager();
            IJob job = jobManager.getJob(this.a);
            if (!job.isRunning()) {
                de.this.log.info("Invoking the '{}' job manually", (Object)this.a);
                job.invoke(true);
                return true;
            }
            return false;
        }

        public void a(Boolean data) {
            if (!data.booleanValue()) {
                de.this.notification("Cannot invoke the job.  It is already running.", new Object[0]);
            }
            de.this.onRefresh(new Object[0]);
        }

        @Override
        public /* synthetic */ void doUI(Object object) {
            this.a((Boolean)object);
        }

        @Override
        public /* synthetic */ Object doWork() {
            return this.a();
        }
    }
}

