/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.impl.ct;
import com.jumpmind.symmetric.console.impl.cu;
import com.jumpmind.symmetric.console.model.ConsoleEvent;
import com.jumpmind.symmetric.console.model.ConsoleUser;
import com.jumpmind.symmetric.console.ui.common.I;
import com.jumpmind.symmetric.console.ui.common.M;
import com.jumpmind.symmetric.console.ui.common.aq;
import com.jumpmind.symmetric.console.ui.common.as;
import com.jumpmind.symmetric.console.ui.common.j;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.confirmdialog.ConfirmDialog;
import com.vaadin.flow.component.contextmenu.MenuItem;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Anchor;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.HttpStatusCode;
import com.vaadin.flow.server.streams.DownloadHandler;
import com.vaadin.flow.server.streams.DownloadResponse;
import com.vaadin.flow.server.streams.InputStreamDownloadCallback;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullWriter;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.DmlStatement;
import org.jumpmind.db.sql.ISqlTemplate;
import org.jumpmind.db.sql.Row;
import org.jumpmind.symmetric.AbstractSymmetricEngine;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.Version;
import org.jumpmind.symmetric.io.data.Batch;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.CsvUtils;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.reader.ProtocolDataReader;
import org.jumpmind.symmetric.io.stage.IStagedResource;
import org.jumpmind.symmetric.io.stage.IStagingManager;
import org.jumpmind.symmetric.io.stage.StagingFileLock;
import org.jumpmind.symmetric.model.AbstractBatch;
import org.jumpmind.symmetric.model.Data;
import org.jumpmind.symmetric.model.IncomingBatch;
import org.jumpmind.symmetric.model.IncomingError;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.OutgoingBatch;
import org.jumpmind.symmetric.model.ProcessInfo;
import org.jumpmind.symmetric.model.ProcessType;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.symmetric.service.IDataExtractorService;
import org.jumpmind.symmetric.service.IDataLoaderService;
import org.jumpmind.symmetric.service.IDataService;
import org.jumpmind.symmetric.service.IOutgoingBatchService;
import org.jumpmind.util.CollectionUtils;
import org.jumpmind.vaadin.ui.common.ColumnVisibilityToggler;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;
import org.jumpmind.vaadin.ui.common.Label;
import org.jumpmind.vaadin.ui.common.TabSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vaadin.addons.chartjs.ChartJs;
import org.vaadin.addons.chartjs.config.BarChartConfig;
import org.vaadin.addons.chartjs.config.ChartConfig;
import org.vaadin.addons.chartjs.config.DonutChartConfig;
import org.vaadin.addons.chartjs.data.BarDataset;
import org.vaadin.addons.chartjs.data.Dataset;
import org.vaadin.addons.chartjs.data.PieDataset;
import org.vaadin.addons.chartjs.options.Tooltips;
import org.vaadin.addons.chartjs.options.types.BarChartOptions;
import org.vaadin.addons.chartjs.options.types.PieChartOptions;

public class cs<T extends AbstractBatch>
extends aq
implements ComponentEventListener<ClickEvent<MenuItem>> {
    private static final long b = 1L;
    final Logger a = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private AbstractBatch c;
    private TabSheet d;
    private Button e;
    private Button f;
    private Anchor g = null;
    private cu h;
    private Table i = null;
    private List<TextField> j;
    private boolean k;
    private static String l = "Summary";

    public cs(I controller, AbstractBatch batch) {
        this(controller, batch, false);
    }

    public cs(I controller, AbstractBatch batch, boolean showErrorResolutionMenuBar) {
        super(controller, cs.a(batch));
        this.c = batch;
        this.setWidth("80%");
        this.setHeight("95%");
        this.setResizable(true);
        this.setCloseOnEsc(true);
        this.setCloseOnOutsideClick(false);
        VerticalLayout mainLayout = new VerticalLayout();
        mainLayout.setWidthFull();
        mainLayout.getStyle().set("margin", "0");
        mainLayout.getStyle().set("padding", "0 16px");
        this.addAndExpand(new Component[]{mainLayout});
        this.d = new TabSheet();
        this.d.setSizeFull();
        VerticalLayout summaryLayout = new VerticalLayout();
        ComponentUtil.setData((Component)summaryLayout, (String)"data", (Object)1);
        summaryLayout.setSpacing(true);
        summaryLayout.setMargin(false);
        VerticalLayout resolveLayout = new VerticalLayout();
        ComponentUtil.setData((Component)resolveLayout, (String)"data", (Object)4);
        resolveLayout.setSpacing(true);
        resolveLayout.setMargin(false);
        VerticalLayout capturedLayout = new VerticalLayout();
        capturedLayout.setMargin(false);
        ComponentUtil.setData((Component)capturedLayout, (String)"data", (Object)2);
        capturedLayout.setSizeFull();
        VerticalLayout receivedLayout = new VerticalLayout();
        receivedLayout.setMargin(false);
        ComponentUtil.setData((Component)receivedLayout, (String)"data", (Object)2);
        receivedLayout.setSizeFull();
        VerticalLayout sentLayout = new VerticalLayout();
        sentLayout.setMargin(false);
        ComponentUtil.setData((Component)sentLayout, (String)"data", (Object)3);
        sentLayout.setSizeFull();
        this.d.add((Component)summaryLayout, "Summary");
        if (batch.isErrorFlag()) {
            if (batch instanceof IncomingBatch) {
                ISymmetricEngine engine = controller.getSymmetricEngine();
                IDataLoaderService dataLoaderService = engine.getDataLoaderService();
                IncomingError error = dataLoaderService.getCurrentIncomingError(batch.getBatchId(), batch.getNodeId());
                if (error != null && (batch.getSqlCode() > 0 || StringUtils.isNotBlank((CharSequence)batch.getSqlState()))) {
                    this.d.add((Component)resolveLayout, "Resolve Data");
                }
            } else {
                this.d.add((Component)resolveLayout, "Resolve Data");
            }
        }
        ConsoleUser user = controller.getConsoleUser();
        if (batch instanceof OutgoingBatch) {
            if (user.hasPrivilegeRead("View Captured Data")) {
                this.d.add((Component)capturedLayout, "Captured Data");
            }
            if (user.hasPrivilegeRead("View Sent Data")) {
                this.d.add((Component)sentLayout, "Sent Data");
            }
        } else if (user.hasPrivilegeRead("View Received Data")) {
            this.d.add((Component)receivedLayout, "Received Data");
        }
        this.d.addSelectedTabChangeListener((ComponentEventListener & Serializable)event -> {
            TabSheet.EnhancedTab selectedTab = this.d.getSelectedTab();
            l = selectedTab.getName();
            VerticalLayout layout = (VerticalLayout)selectedTab.getComponent();
            layout.setSizeFull();
            Object data = ComponentUtil.getData((Component)layout, (String)"data");
            if (data.equals(1)) {
                if (!this.k) {
                    this.a(layout);
                }
            } else if (data.equals(2) && batch instanceof OutgoingBatch) {
                this.b(layout);
            } else if (data.equals(2) && batch instanceof IncomingBatch) {
                this.c(layout);
            } else if (data.equals(3)) {
                this.d(layout);
            } else if (data.equals(4)) {
                this.a(layout, showErrorResolutionMenuBar);
            }
            this.l();
        });
        mainLayout.add(new Component[]{this.d});
        mainLayout.expand(new Component[]{this.d});
        this.e = new Button(controller.getMessage("Refresh", new Object[0]), (ComponentEventListener & Serializable)event -> this.e());
        this.e.getStyle().set("margin-right", "auto");
        this.f = new Button("Download CSV");
        this.f.setId("csvButton");
        this.f.addClickListener((ComponentEventListener & Serializable)event -> {
            String currentNodeId = controller.getSymmetricEngine().getNodeId();
            controller.getConsoleEventService().addEvent(new ConsoleEvent(controller.getConsoleUser().getUserId(), "Download batch", currentNodeId, currentNodeId, null, batch.getNodeBatchId()));
        });
        this.g = new Anchor(this.n(), null);
        this.g.getElement().setAttribute("download", true);
        this.g.add(new Component[]{this.f});
        Button closeButton = as.createPrimaryButton(controller.getMessage("Close", new Object[0]), (ComponentEventListener<ClickEvent<Button>>)(ComponentEventListener & Serializable)event -> this.close());
        if (batch.isLoadFlag() && this.f() == null) {
            this.f.setEnabled(false);
            this.getFooter().add(new Component[]{this.f});
        } else if (batch instanceof OutgoingBatch && !user.hasPrivilegeRead("Download Outgoing Batch CSV") || batch instanceof IncomingBatch && !user.hasPrivilegeRead("Download Incoming Batch CSV")) {
            this.f.setEnabled(false);
            this.f.getElement().setAttribute("title", String.format("Your role '%s' does not have the privileges needed for this action.", user.getRole()));
            this.getFooter().add(new Component[]{this.f});
        } else {
            this.getFooter().add(new Component[]{this.g});
        }
        this.getFooter().add(new Component[]{this.e, closeButton});
        UI.getCurrent().addShortcutListener((Command & Serializable)() -> this.close(), Key.ESCAPE, new KeyModifier[0]);
        this.l();
        if (l.equals("Summary") || this.d.getTab(l) == null) {
            this.a(summaryLayout);
        }
        this.d.setSelectedTab(l);
    }

    private static HorizontalLayout a(AbstractBatch batch) {
        String nodeId = batch.getNodeId();
        if (nodeId.equals("-1")) {
            nodeId = "Unrouted";
        }
        HorizontalLayout header = new HorizontalLayout();
        header.add(new Component[]{new Label("<b>Batch:</b>")});
        String batchIdString = String.valueOf(batch.getBatchId()).replace(",", "");
        Span batchId = new Span(batchIdString);
        header.add(new Component[]{batchId});
        header.add(new Component[]{new Span()});
        Label nodeLabel = new Label();
        if (batch instanceof OutgoingBatch) {
            nodeLabel.setText("<b>Target Node:</b>");
        } else {
            nodeLabel.setText("<b>Source Node:</b>");
        }
        header.add(new Component[]{nodeLabel});
        header.add(new Component[]{new Span(nodeId)});
        header.add(new Component[]{new Span()});
        header.add(new Component[]{new Label("<b>Channel:</b>")});
        header.add(new Component[]{new Span(batch.getChannelId())});
        header.add(new Component[]{new Span()});
        header.add(new Component[]{new Label("<b>Type:</b>")});
        header.add(new Component[]{new Span(batch.isLoadFlag() ? "Load" : "Changes")});
        header.setSpacing(true);
        header.getStyle().set("margin", "0 16px");
        return header;
    }

    public void a() {
        if (this.c.isErrorFlag() && this.c instanceof IncomingBatch) {
            this.d.setSelectedTab(2);
        } else {
            this.d.setSelectedTab(1);
        }
    }

    public void b() {
        if (this.c.isErrorFlag() && this.c instanceof IncomingBatch) {
            this.d.setSelectedTab(3);
        } else {
            this.d.setSelectedTab(2);
        }
    }

    public void a(int tab) {
        this.d.setSelectedTab(tab);
    }

    protected void a(VerticalLayout layout) {
        if (layout.getComponentCount() > 0) {
            return;
        }
        this.h(layout);
        if (this.c.isErrorFlag()) {
            this.i(layout);
            if (this.c instanceof OutgoingBatch && this.c.getFailedDataId() > 0L) {
                ct dataLayout = new ct(this.controller, null);
                Data data = this.controller.getSymmetricEngine().getDataService().findData(this.c.getFailedDataId());
                dataLayout.a(data);
                layout.add(new Component[]{dataLayout});
            }
        }
        HorizontalLayout chartLayout = new HorizontalLayout();
        chartLayout.setSizeFull();
        chartLayout.setSpacing(true);
        layout.add(new Component[]{chartLayout});
        PieDataset eventDataset = new PieDataset();
        DonutChartConfig config = new DonutChartConfig();
        config.data().labels(new String[]{"Insert", "Update", "Delete", "Reload", "Other"}).addDataset((Dataset)eventDataset).and();
        ((PieChartOptions)((PieChartOptions)((PieChartOptions)((PieChartOptions)((Tooltips)((PieChartOptions)((PieChartOptions)config.options().legend().display(true).and()).rotation(Math.PI * 2).circumference(Math.PI * 2).responsive(true)).tooltips().callbacks().label("data.datasets[0].data[tooltipItem.index] + ' rows'").and()).and()).title().display(false).text("Rows").and()).animation().animateScale(true).animateRotate(false).and()).cutoutPercentage(80.0).maintainAspectRatio(false)).done();
        String[] colors = new String[]{"#b8d6e5", "#c3e0a9", "#efe9c1", "#efd4ba", "#e7c3bc"};
        eventDataset.backgroundColor(colors);
        long totalRows = this.c.getDataRowCount() + this.c.getReloadRowCount() + this.c.getOtherRowCount();
        eventDataset.addData(Double.valueOf(this.c.getDataInsertRowCount()));
        eventDataset.addData(Double.valueOf(this.c.getDataUpdateRowCount()));
        eventDataset.addData(Double.valueOf(this.c.getDataDeleteRowCount()));
        eventDataset.addData(Double.valueOf(this.c.getReloadRowCount()));
        eventDataset.addData(Double.valueOf(this.c.getOtherRowCount()));
        ChartJs eventChart = new ChartJs((ChartConfig)config);
        eventChart.setWidth("50%");
        chartLayout.setHeight("200px");
        chartLayout.add(new Component[]{eventChart});
        chartLayout.setFlexGrow((double)0.4f, new HasElement[]{eventChart});
        long totalTime = this.c.getLoadMillis() + this.c.getFilterMillis() + this.c.getNetworkMillis() + this.c.getExtractMillis() + this.c.getRouterMillis();
        BarChartConfig timeConfig = new BarChartConfig();
        BarDataset timeData = new BarDataset();
        ((BarDataset)((BarDataset)((BarDataset)((BarDataset)((BarDataset)timeData.addData(Integer.valueOf((int)this.c.getRouterMillis()))).addData(Integer.valueOf((int)this.c.getExtractMillis()))).addData(Integer.valueOf((int)this.c.getNetworkMillis()))).addData(Integer.valueOf((int)this.c.getFilterMillis()))).addData(Integer.valueOf((int)this.c.getLoadMillis()))).backgroundColor(new String[]{"red", "blue", "green", "yellow", "orange", "purple"});
        ((BarChartOptions)((BarChartOptions)((Tooltips)((BarChartOptions)((BarChartConfig)timeConfig.data().labels(new String[]{"Routing", "Extract", "Network", "Filter", "Load"}).addDataset((Dataset)timeData).and()).options().legend().display(false).and()).tooltips().callbacks().label("tooltipItem.yLabel + ' ms'").and()).and()).maintainAspectRatio(false)).done();
        ChartJs timeChart = new ChartJs((ChartConfig)timeConfig);
        timeChart.setWidth("50%");
        timeChart.setHeight("100%");
        chartLayout.add(new Component[]{timeChart});
        chartLayout.setFlexGrow((double)0.6f, new HasElement[]{timeChart});
        HorizontalLayout chartLabelLayout = new HorizontalLayout();
        chartLabelLayout.setWidthFull();
        chartLabelLayout.setSpacing(true);
        layout.add(new Component[]{chartLabelLayout});
        Span totalRowsSpan = new Span("Total Data = " + this.c(totalRows));
        totalRowsSpan.setWidth("50%");
        chartLabelLayout.add(new Component[]{totalRowsSpan});
        chartLabelLayout.setVerticalComponentAlignment(FlexComponent.Alignment.START, new Component[]{totalRowsSpan});
        chartLabelLayout.setFlexGrow(4.0, new HasElement[]{totalRowsSpan});
        Span totalTimeSpan = new Span("Total Time = " + this.b(totalTime));
        totalTimeSpan.setWidth("30%");
        chartLabelLayout.add(new Component[]{totalTimeSpan});
        chartLabelLayout.setFlexGrow(6.0, new HasElement[]{totalTimeSpan});
        chartLabelLayout.setVerticalComponentAlignment(FlexComponent.Alignment.START, new Component[]{totalTimeSpan});
        this.k = true;
    }

    protected void a(VerticalLayout layout, boolean showErrorResolutionMenuBar) {
        block3: {
            block4: {
                block2: {
                    if (layout.getComponentCount() > 0) {
                        return;
                    }
                    this.h(layout);
                    this.i(layout);
                    if (!(this.c instanceof IncomingBatch)) break block2;
                    String title = "CONFLICT".equals(this.c.getSqlState()) ? "Conflict Resolution" : "Error Row Resolution";
                    ISymmetricEngine engine = this.controller.getSymmetricEngine();
                    IDataLoaderService dataLoaderService = engine.getDataLoaderService();
                    IncomingError error = dataLoaderService.getCurrentIncomingError(this.c.getBatchId(), this.c.getNodeId());
                    this.a(layout, error, (IncomingBatch)this.c, title);
                    break block3;
                }
                if (!this.c.isLoadFlag()) break block4;
                Data data = this.k();
                if (data == null && !showErrorResolutionMenuBar) break block3;
                this.a(layout, data, showErrorResolutionMenuBar);
                break block3;
            }
            List batchData = this.controller.getSymmetricEngine().getDataService().listData(this.c.getBatchId(), this.c.getNodeId(), 0L, this.c.getChannelId(), 50000);
            for (Data data : batchData) {
                if (data.getDataId() != this.c.getFailedDataId()) continue;
                this.a(layout, data, false);
                break;
            }
        }
    }

    protected void b(VerticalLayout layout) {
        if (layout.getComponentCount() > 0) {
            return;
        }
        ISymmetricEngine engine = this.controller.getSymmetricEngine();
        IDataService dataService = engine.getDataService();
        List dataIds = dataService.listData(this.c.getBatchId(), this.c.getNodeId(), 0L, this.c.getChannelId(), 50000);
        j batchDataGrid = new j(this.controller, this.c, dataIds);
        layout.add(new Component[]{batchDataGrid});
        layout.getStyle().set("padding-bottom", "0");
    }

    protected void c(VerticalLayout layout) {
        if (layout.getComponentCount() > 0) {
            return;
        }
        List<Data> dataIds = this.j();
        if (dataIds.size() > 0) {
            layout.add(new Component[]{new j(this.controller, this.c, dataIds)});
            layout.getStyle().set("padding-bottom", "0");
        } else {
            this.e(layout);
        }
    }

    protected void d(VerticalLayout layout) {
        if (layout.getComponentCount() > 0) {
            return;
        }
        if (this.f() == null) {
            this.e(layout);
        } else {
            List<Data> dataIds = this.h();
            if (dataIds == null) {
                this.f(layout);
                return;
            }
            if (!dataIds.isEmpty()) {
                layout.add(new Component[]{new j(this.controller, this.c, dataIds)});
                layout.getStyle().set("padding-bottom", "0");
            } else {
                this.g(layout);
            }
        }
    }

    protected void e(VerticalLayout layout) {
        layout.add(new Component[]{as.createSubHeader(this.controller, "No Staging File")});
        Label label = new Label(this.controller.getMessage("This batch is no longer available on disk in staging, which can happen for any of the following reasons:\n<ul><li>The staged file became too old and was removed to conserve space</li><li>The batch was part of an initial load, which is cleaned up immediately after loading</li><li>The staged file was intentionally removed</li></ul>", new Object[0]));
        label.setWidthFull();
        layout.addAndExpand(new Component[]{label});
        this.f.setVisible(false);
    }

    protected void f(VerticalLayout layout) {
        layout.add(new Component[]{as.createSubHeader(this.controller, "Failed to Parse Batch")});
        Label label = new Label(this.controller.getMessage("An error was encountered while parsing this batch, which could mean that the batch is corrupt in staging. See the log for the full stacktrace.", new Object[0]));
        label.setWidthFull();
        layout.addAndExpand(new Component[]{label});
    }

    protected void g(VerticalLayout layout) {
        layout.add(new Component[]{as.createSubHeader(this.controller, "Batch Was Ignored")});
        Label label = new Label(this.controller.getMessage("This batch was ignored and has no sent data to show.", new Object[0]));
        label.setWidthFull();
        layout.addAndExpand(new Component[]{label});
    }

    protected void a(VerticalLayout layout, Data data, boolean showErrorResolutionMenuBar) {
        if (data != null) {
            ct dataLayout = new ct(this.controller, this.controller.getMessage("Error Row Resolution", new Object[0]));
            layout.add(new Component[]{dataLayout});
            dataLayout.a(data);
            HorizontalLayout buttonLayout = new HorizontalLayout();
            buttonLayout.setSpacing(true);
            layout.add(new Component[]{buttonLayout});
            Checkbox ignoreRowCheckbox = new Checkbox("Resolve by ignoring this row");
            if (this.c.isCommonFlag()) {
                ignoreRowCheckbox.setEnabled(false);
                ignoreRowCheckbox.getElement().setAttribute("title", this.controller.getMessage("Cannot ignore a row belonging to a common batch", new Object[0]));
            }
            buttonLayout.add(new Component[]{ignoreRowCheckbox});
            Span spacer = new Span();
            buttonLayout.addAndExpand(new Component[]{spacer});
            Button saveButton = as.createPrimaryButton(this.controller.getMessage("Save", new Object[0]), (ComponentEventListener<ClickEvent<Button>>)(ComponentEventListener & Serializable)event -> {
                if (((Boolean)ignoreRowCheckbox.getValue()).booleanValue()) {
                    this.c();
                }
                this.close();
                new cs<T>(this.controller, this.c).open();
            });
            saveButton.setEnabled(false);
            ignoreRowCheckbox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> saveButton.setEnabled(((Boolean)event.getValue()).booleanValue()));
            buttonLayout.add(new Component[]{saveButton});
            buttonLayout.setVerticalComponentAlignment(FlexComponent.Alignment.END, new Component[]{saveButton});
            if (showErrorResolutionMenuBar) {
                this.a(layout, "More Error Resolution Options");
            }
        } else if (showErrorResolutionMenuBar) {
            this.a(layout, "Error Resolution Options");
        }
    }

    protected void a(VerticalLayout layout, String messageKey) {
        boolean showSendSchema = true;
        if (!this.c.isLoadFlag()) {
            Node targetNode;
            showSendSchema = this.c.getFailedDataId() > 0L ? (targetNode = this.controller.getSymmetricEngine().getNodeService().findNode(this.c.getNodeId(), true)) != null && !Version.isOlderThanVersion((String)targetNode.getSymmetricVersion(), (String)"3.16.5") : false;
        }
        layout.add(new Component[]{new cu(this.controller, this, this.controller.getMessage(messageKey, new Object[0]), true, false, showSendSchema, false)});
    }

    public void c() {
        boolean isLoad = this.c.isLoadFlag();
        OutgoingBatch outgoingBatch = (OutgoingBatch)this.c;
        try {
            String rowNumber = isLoad ? String.valueOf(outgoingBatch.getFailedLineNumber()) : String.valueOf(outgoingBatch.getFailedDataId());
            outgoingBatch.setStatus(AbstractBatch.Status.LD);
            outgoingBatch.setErrorFlag(false);
            this.controller.getSymmetricEngine().getOutgoingBatchService().updateOutgoingBatch(outgoingBatch);
            this.controller.getSymmetricEngine().getOutgoingBatchService().updateOutgoingError(outgoingBatch.getBatchId(), outgoingBatch.getNodeId());
            String userId = this.controller.getConsoleUser().getUserId();
            Node identity = this.controller.getSymmetricEngine().getNodeService().findIdentity();
            this.controller.getConsoleEventService().addEvent(new ConsoleEvent(userId, "Ignore row in outgoing batch", identity.getNodeId(), identity.getNodeId(), outgoingBatch.getNodeId(), outgoingBatch.getBatchId() + ":" + rowNumber));
        }
        catch (Exception e2) {
            this.a.error(e2.getMessage(), (Throwable)e2);
            this.message("Failed to mark selected row as ignored.  Please check the log file for more details.");
        }
    }

    public void d() {
        boolean isLoad = this.c.isLoadFlag();
        IDataLoaderService dataLoaderService = this.controller.getSymmetricEngine().getDataLoaderService();
        IncomingBatch incomingBatch = (IncomingBatch)this.c;
        try {
            String rowNumber = isLoad ? String.valueOf(incomingBatch.getFailedLineNumber()) : String.valueOf(incomingBatch.getFailedDataId());
            IncomingError error = dataLoaderService.getCurrentIncomingError(incomingBatch.getBatchId(), incomingBatch.getNodeId());
            if (error != null) {
                error.setResolveIgnore(true);
            }
            incomingBatch.setStatus(AbstractBatch.Status.LD);
            incomingBatch.setErrorFlag(false);
            this.controller.getSymmetricEngine().getIncomingBatchService().updateIncomingBatch(incomingBatch);
            if (error != null) {
                this.controller.getSymmetricEngine().getDataLoaderService().updateIncomingError(error);
            }
            String userId = this.controller.getConsoleUser().getUserId();
            Node identity = this.controller.getSymmetricEngine().getNodeService().findIdentity();
            this.controller.getConsoleEventService().addEvent(new ConsoleEvent(userId, "Ignore row in incoming batch", identity.getNodeId(), identity.getNodeId(), incomingBatch.getNodeId(), incomingBatch.getBatchId() + ":" + rowNumber));
        }
        catch (Exception e2) {
            this.a.error(e2.getMessage(), (Throwable)e2);
            this.message("Failed to mark selected row as ignored.  Please check the log file for more details.");
        }
    }

    protected void a(VerticalLayout layout, IncomingError error, IncomingBatch batch, String title) {
        layout.add(new Component[]{as.createSubHeader(this.controller, title)});
        String[] columnNames = error.getParsedColumnNames();
        ColumnVisibilityToggler columnVisibilityToggler = new ColumnVisibilityToggler();
        layout.add(new Component[]{columnVisibilityToggler});
        layout.setHorizontalComponentAlignment(FlexComponent.Alignment.END, new Component[]{columnVisibilityToggler});
        Grid dataGrid = new Grid();
        dataGrid.setWidthFull();
        dataGrid.setColumnReorderingAllowed(true);
        columnVisibilityToggler.addColumn(dataGrid.addComponentColumn((ValueProvider & Serializable)list -> {
            Span span = new Span((String)list.get(0));
            span.setHeight("26px");
            return span;
        }).setHeader("Row Type"), "Row Type");
        this.j = new ArrayList<TextField>();
        for (int i2 = 0; i2 < columnNames.length; ++i2) {
            Integer columnIndex = i2 + 1;
            columnVisibilityToggler.addColumn(dataGrid.addComponentColumn((ValueProvider & Serializable)list -> {
                if (((String)list.get(0)).equals("RESOLVE")) {
                    String value;
                    String string = value = columnIndex < list.size() ? (String)list.get(columnIndex) : "";
                    if (value == null) {
                        value = "$(null)";
                    }
                    TextField field = new TextField();
                    if (value != null) {
                        field.setValue(value);
                    }
                    this.j.add(field);
                    return field;
                }
                int colIndex = columnIndex;
                if (colIndex >= list.size() || colIndex < 0) {
                    return new Span("");
                }
                return new Span((String)list.get(columnIndex));
            }).setHeader(columnNames[i2]), columnNames[i2]);
        }
        ArrayList<List<Object>> dataList = new ArrayList<List<Object>>();
        if (error.getParsedOldData() != null) {
            ArrayList<String> oldDataList = new ArrayList<String>();
            Collections.addAll(oldDataList, error.getParsedOldData());
            oldDataList.add(0, "OLD");
            dataList.add(oldDataList);
        }
        if (error.getParsedRowData() != null) {
            ArrayList<String> newDataList = new ArrayList<String>();
            Collections.addAll(newDataList, error.getParsedRowData());
            newDataList.add(0, "NEW");
            dataList.add(newDataList);
        }
        IDatabasePlatform platform = this.controller.getSymmetricEngine().getSymmetricDialect().getPlatform();
        String[] keyNames = error.getParsedPrimaryKeyColumnNames();
        Table targetTable = platform.getTableFromCache(error.getTargetCatalogName(), error.getTargetSchemaName(), error.getTargetTableName(), false);
        targetTable = targetTable.copyAndFilterColumns(columnNames, keyNames, true, false);
        String[] data = error.getParsedOldData();
        if (data == null) {
            data = error.getParsedRowData();
        }
        Column[] columns = targetTable.getColumns();
        Object[] objectValues = platform.getObjectValues(error.getBinaryEncoding(), data, columns);
        Map columnDataMap = CollectionUtils.toMap((String[])columnNames, (Object[])objectValues);
        Column[] pkColumns = targetTable.getPrimaryKeyColumns();
        Object[] args = new Object[pkColumns.length];
        for (int i3 = 0; i3 < pkColumns.length; ++i3) {
            args[i3] = columnDataMap.get(pkColumns[i3].getName());
        }
        DmlStatement sqlStatement = platform.createDmlStatement(DmlStatement.DmlType.SELECT, targetTable, null);
        ISqlTemplate sqlTemplate = platform.getSqlTemplate();
        Row row = sqlTemplate.queryForRow(sqlStatement.getSql(), args);
        if (row != null) {
            ArrayList<String> existingDataList = new ArrayList<String>();
            Collections.addAll(existingDataList, platform.getStringValues(error.getBinaryEncoding(), columns, row, false, false));
            existingDataList.add(0, "EXISTING");
            dataList.add(existingDataList);
        }
        Object[] resolveData = new String[]{"RESOLVE"};
        resolveData = error.getParsedResolveData() != null ? (String[])ArrayUtils.addAll((Object[])resolveData, (Object[])error.getParsedResolveData()) : (String[])ArrayUtils.addAll((Object[])resolveData, (Object[])error.getParsedRowData());
        List<Object> resolveDataList = Arrays.asList(resolveData);
        dataList.add(resolveDataList);
        dataGrid.setItems(dataList);
        dataGrid.setHeight(dataList.size() * 34 + 56 + "px");
        layout.add(new Component[]{dataGrid});
        HorizontalLayout buttonLayout = new HorizontalLayout();
        buttonLayout.setSpacing(true);
        layout.add(new Component[]{buttonLayout});
        Checkbox ignoreRowCheckbox = new Checkbox("Resolve by ignoring this row");
        ignoreRowCheckbox.setValue((Object)error.isResolveIgnore());
        buttonLayout.add(new Component[]{ignoreRowCheckbox});
        buttonLayout.addAndExpand(new Component[]{new Span()});
        Button applyButton = as.createPrimaryButton(this.controller.getMessage("Apply", new Object[0]), (ComponentEventListener<ClickEvent<Button>>)(ComponentEventListener & Serializable)event -> {
            if (!((Boolean)ignoreRowCheckbox.getValue()).booleanValue()) {
                String[] resolveDataArray = new String[this.j.size()];
                for (int i2 = 0; i2 < this.j.size(); ++i2) {
                    String value = this.j.get(i2).getValue();
                    if (value != null && Strings.CS.equals(value, "$(null)")) {
                        value = null;
                    }
                    resolveDataArray[i2] = value;
                }
                error.setParsedResolveData(resolveDataArray);
                batch.setStatus(AbstractBatch.Status.LD);
                batch.setErrorFlag(false);
                this.controller.getSymmetricEngine().getIncomingBatchService().updateIncomingBatch(batch);
                this.controller.getSymmetricEngine().getDataLoaderService().updateIncomingError(error);
            } else {
                this.d();
            }
            this.close();
            new cs<T>(this.controller, (AbstractBatch)batch).open();
        });
        buttonLayout.add(new Component[]{applyButton});
        buttonLayout.setVerticalComponentAlignment(FlexComponent.Alignment.END, new Component[]{applyButton});
    }

    protected void h(VerticalLayout layout) {
        HorizontalLayout headerLayout = new HorizontalLayout();
        headerLayout.setMargin(true);
        headerLayout.setWidthFull();
        headerLayout.setSpacing(true);
        layout.add(new Component[]{headerLayout});
        VerticalLayout verticalLayout = new VerticalLayout();
        Label statusLabel = new Label("<b>Status:</b>");
        statusLabel.setWidth("70px");
        verticalLayout.add(new Component[]{new HorizontalLayout(new Component[]{statusLabel, new Span(this.c.getStatus().name())})});
        Label countLabel = new Label("<b>Count:</b>");
        countLabel.setWidth("70px");
        verticalLayout.add(new Component[]{new HorizontalLayout(new Component[]{countLabel, new Span(this.c(this.c.getDataRowCount()))})});
        Label sizeLabel = new Label("<b>Size:</b>");
        sizeLabel.setWidth("70px");
        verticalLayout.add(new Component[]{new HorizontalLayout(new Component[]{sizeLabel, new Span(this.a(this.c.getByteCount()))})});
        headerLayout.add(new Component[]{verticalLayout});
        headerLayout.setFlexGrow((double)0.43f, new HasElement[]{verticalLayout});
        VerticalLayout verticalLayout2 = new VerticalLayout();
        Label createdLabel = new Label("<b>Created:</b>");
        createdLabel.setWidth("70px");
        Label createTimeLabel = new Label(this.a(this.c.getCreateTime()) + " <i>(" + this.b(System.currentTimeMillis() - this.c.getCreateTime().getTime()) + " ago)</i>");
        verticalLayout2.add(new Component[]{new HorizontalLayout(new Component[]{createdLabel, createTimeLabel})});
        Label updatedLabel = new Label("<b>Updated:</b>");
        updatedLabel.setWidth("70px");
        Label lastUpdatedTimeLabel = new Label(this.a(this.c.getLastUpdatedTime()) + " <i>(" + this.b(System.currentTimeMillis() - this.c.getLastUpdatedTime().getTime()) + " ago)</i>");
        verticalLayout2.add(new Component[]{new HorizontalLayout(new Component[]{updatedLabel, lastUpdatedTimeLabel})});
        Label tablesLabel = new Label("<b>Tables:</b>");
        tablesLabel.setWidth("70px");
        verticalLayout2.add(new Component[]{new HorizontalLayout(new Component[]{tablesLabel, new Span(this.c.getSummary())})});
        headerLayout.add(new Component[]{verticalLayout2});
        headerLayout.setFlexGrow((double)0.57f, new HasElement[]{verticalLayout2});
    }

    protected void i(VerticalLayout layout) {
        HorizontalLayout sqlHeader = new HorizontalLayout();
        Label sqlCodeLabel = new Label("<b>SQL Code:</b>");
        sqlHeader.add(new Component[]{sqlCodeLabel});
        sqlHeader.add(new Component[]{new Span(String.valueOf(this.c.getSqlCode()))});
        sqlHeader.add(new Component[]{new Span()});
        Label sqlStateLabel = new Label("<b>SQL State:</b>");
        sqlHeader.add(new Component[]{sqlStateLabel});
        sqlHeader.add(new Component[]{new Span(StringUtils.isBlank((CharSequence)this.c.getSqlState()) ? "<none>" : this.c.getSqlState())});
        sqlHeader.setSpacing(true);
        layout.add(new Component[]{sqlHeader});
        HorizontalLayout sqlMessage = new HorizontalLayout();
        Label errorLabel = new Label("<b>Error Message:</b>");
        errorLabel.setClassName("marked");
        errorLabel.setWidth("100px");
        sqlMessage.add(new Component[]{errorLabel});
        Span errorMessage = new Span(StringUtils.isBlank((CharSequence)this.c.getSqlMessage()) ? "<none>" : this.c.getSqlMessage());
        errorMessage.setClassName("marked");
        sqlMessage.addAndExpand(new Component[]{errorMessage});
        sqlMessage.setSpacing(true);
        layout.add(new Component[]{sqlMessage});
    }

    private DownloadHandler n() {
        return DownloadHandler.fromInputStream((InputStreamDownloadCallback & Serializable)event -> {
            InputStream in;
            if (this.c instanceof OutgoingBatch) {
                final PipedOutputStream out = new PipedOutputStream();
                in = new PipedInputStream(out);
                Thread thread = new Thread("gui-batch-window"){

                    @Override
                    public void run() {
                        try (PrintWriter writer = new PrintWriter(out);){
                            cs.this.controller.getSymmetricEngine().getDataExtractorService().extractOnlyOutgoingBatch(cs.this.c.getNodeId(), cs.this.c.getBatchId(), (Writer)writer);
                        }
                    }
                };
                thread.start();
            } else {
                ISymmetricEngine sourceEngine;
                IStagedResource resource = null;
                ISymmetricEngine engine = this.controller.getSymmetricEngine();
                boolean useSourceStaging = engine.getConfigurationService().isUseSourceStagingEnabled(this.c.getNodeId());
                ISymmetricEngine iSymmetricEngine = sourceEngine = useSourceStaging ? AbstractSymmetricEngine.findEngineByNodeId((String)this.c.getNodeId()) : null;
                if (useSourceStaging && sourceEngine != null) {
                    Batch outgoingBatch = new Batch(Batch.BatchType.EXTRACT, this.c.getBatchId(), this.c.getChannelId(), null, this.c.getNodeId(), engine.getNodeId(), this.c.isCommonFlag());
                    resource = sourceEngine.getStagingManager().find(new Object[]{"outgoing", outgoingBatch.getStagedLocation(), this.c.getBatchId()});
                } else {
                    String filePath = "incoming/" + this.c.getNodeId() + "/" + StringUtils.leftPad((String)String.valueOf(this.c.getBatchId()), (int)10, (char)'0');
                    resource = engine.getStagingManager().find(filePath);
                }
                if (resource.exists()) {
                    try {
                        in = IOUtils.toInputStream((String)IOUtils.toString((Reader)resource.getReader()), (Charset)Charset.defaultCharset());
                    }
                    catch (IOException e2) {
                        this.a.error(String.format("An error was encountered while downloading csv data. ", new Object[0]), (Throwable)e2);
                        throw e2;
                    }
                } else {
                    as.securelyAccessUI(event.getUI(), (Command & Serializable)() -> CommonUiUtils.notifyError((String)"File not found"));
                    return DownloadResponse.error((HttpStatusCode)HttpStatusCode.NOT_FOUND);
                }
            }
            return new DownloadResponse(in, StringUtils.leftPad((String)Long.toString(this.c.getBatchId()), (int)10, (String)"0") + ".csv", null, -1L);
        });
    }

    protected void e() {
        String nodeId;
        ISymmetricEngine engine = this.controller.getSymmetricEngine();
        IOutgoingBatchService outgoingBatchService = engine.getOutgoingBatchService();
        IDataExtractorService dataExtractorService = engine.getDataExtractorService();
        long batchId = this.c.getBatchId();
        OutgoingBatch batch = outgoingBatchService.findOutgoingBatch(batchId, nodeId = this.c.getNodeId());
        if (batch != null) {
            IStagedResource resource = engine.getStagingManager().find(new Object[]{"outgoing", batch.getStagedLocation(), batch.getBatchId()});
            if (resource != null) {
                resource.delete();
            }
            if (batch instanceof OutgoingBatch) {
                dataExtractorService.extractOnlyOutgoingBatch(nodeId, batchId, (Writer)NullWriter.INSTANCE);
            }
        }
        this.close();
        cs<T> window = new cs<T>(this.controller, (AbstractBatch)batch);
        window.open();
        window.b();
    }

    protected IStagedResource f() {
        IStagedResource resource;
        ISymmetricEngine engine = this.controller.getSymmetricEngine();
        IOutgoingBatchService outgoingBatchService = this.controller.getSymmetricEngine().getOutgoingBatchService();
        OutgoingBatch batch = outgoingBatchService.findOutgoingBatch(this.c.getBatchId(), this.c.getNodeId());
        if (batch != null && (resource = engine.getStagingManager().find(new Object[]{"outgoing", batch.getStagedLocation(), batch.getBatchId()})) != null) {
            return resource;
        }
        return null;
    }

    protected ProtocolDataReader g() {
        IStagedResource resource = this.f();
        if (resource != null && resource.exists()) {
            resource.closeReaders();
            return new ProtocolDataReader(Batch.BatchType.EXTRACT, this.c.getNodeId(), resource);
        }
        return null;
    }

    protected List<Data> h() {
        ProtocolDataReader reader = this.g();
        return this.a(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Data> a(ProtocolDataReader reader) {
        ArrayList<Data> data = new ArrayList<Data>();
        int count = 1;
        try {
            if (reader != null) {
                reader.open(new DataContext());
                Batch objBatch = reader.nextBatch();
                Object obj = reader.readNext();
                while (obj != null) {
                    if (obj instanceof Table) {
                        this.i = (Table)obj;
                    } else if (obj instanceof CsvData) {
                        CsvData objData = (CsvData)obj;
                        Data d2 = new Data();
                        d2.putAttribute("channelId", (Object)objBatch.getChannelId());
                        d2.setDataEventType(objData.getDataEventType());
                        d2.putParsedData("rowData", objData.getParsedData("rowData"));
                        d2.putParsedData("pkData", objData.getParsedData("pkData"));
                        d2.putParsedData("oldData", objData.getParsedData("oldData"));
                        TriggerHistory hist = new TriggerHistory(this.i.getName(), StringUtils.join((Object[])this.i.getPrimaryKeyColumnNames(), (char)','), StringUtils.join((Object[])this.i.getColumnNames(), (char)','));
                        d2.setTriggerHistory(hist);
                        d2.setTableName(this.i.getName());
                        d2.setChannelId(objBatch.getChannelId());
                        d2.setDataId((long)count);
                        d2.setCreateTime((Date)objData.getAttribute("createTime"));
                        ++count;
                        data.add(d2);
                    }
                    obj = reader.readNext();
                }
            }
        }
        catch (Exception e2) {
            data = null;
            this.a.error(String.format("An error was encountered while parsing data id %d in batch %s:", count, this.c.getNodeBatchId()), (Throwable)e2);
            CommonUiUtils.notify((String)this.controller.getMessage("Failed to Parse Batch", new Object[0]), (String)this.controller.getMessage("An error was encountered while parsing data ID %d in this batch. See the log for the full stacktrace.", count));
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return data;
    }

    protected ProtocolDataReader i() {
        ISymmetricEngine sourceEngine;
        ISymmetricEngine engine = this.controller.getSymmetricEngine();
        IStagedResource resource = null;
        boolean useSourceStaging = engine.getConfigurationService().isUseSourceStagingEnabled(this.c.getNodeId());
        ISymmetricEngine iSymmetricEngine = sourceEngine = useSourceStaging ? AbstractSymmetricEngine.findEngineByNodeId((String)this.c.getNodeId()) : null;
        if (sourceEngine != null) {
            Batch outgoingBatch = new Batch(Batch.BatchType.EXTRACT, this.c.getBatchId(), this.c.getChannelId(), null, this.c.getNodeId(), engine.getNodeId(), this.c.isCommonFlag());
            resource = sourceEngine.getStagingManager().find(new Object[]{"outgoing", outgoingBatch.getStagedLocation(), this.c.getBatchId()});
        } else {
            resource = engine.getStagingManager().find(new Object[]{"incoming", this.c.getNodeId(), this.c.getBatchId()});
        }
        if (resource != null) {
            return new ProtocolDataReader(Batch.BatchType.LOAD, this.c.getNodeId(), resource);
        }
        return null;
    }

    protected List<Data> j() {
        ProtocolDataReader reader = this.i();
        return this.a(reader);
    }

    protected Data k() {
        String paddedBatchId = StringUtils.leftPad((String)String.valueOf(this.c.getBatchId()), (int)10, (char)'0');
        String filePath = "outgoing/" + this.c.getNodeId() + "/" + paddedBatchId;
        IStagedResource resource = this.controller.getSymmetricEngine().getStagingManager().find(filePath);
        if (resource == null) {
            return null;
        }
        StagingFileLock lock = this.controller.getSymmetricEngine().getDataExtractorService().acquireStagingFileLock((OutgoingBatch)this.c);
        BufferedReader reader = resource.getReader();
        String[] rowDataInError = null;
        List lines = reader.lines().collect(Collectors.toList());
        int rowCount = 0;
        for (int i2 = 0; i2 < lines.size(); ++i2) {
            String line = (String)lines.get(i2);
            if (line.startsWith("insert") || line.startsWith("update") || line.startsWith("delete")) {
                ++rowCount;
            }
            if ((long)rowCount != this.c.getFailedLineNumber()) continue;
            rowDataInError = CsvUtils.tokenizeCsvData((String)line.substring(7));
            break;
        }
        lock.releaseLock();
        for (Data data : this.h()) {
            if (!Arrays.equals(data.toParsedRowData(), rowDataInError)) continue;
            return data;
        }
        return null;
    }

    protected void l() {
        VerticalLayout layout = (VerticalLayout)this.d.getSelectedTab().getComponent();
        if (this.c instanceof OutgoingBatch && ComponentUtil.getData((Component)layout, (String)"data").equals(3)) {
            if (!this.c.isLoadFlag()) {
                this.e.setEnabled(true);
            }
            this.e.setVisible(true);
            this.g.getStyle().remove("margin-right");
        } else {
            this.e.setEnabled(false);
            this.e.setVisible(false);
            this.g.getStyle().set("margin-right", "auto");
        }
    }

    protected String a(long bytes) {
        int unit;
        boolean si = true;
        int n2 = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    protected String b(long millis) {
        Object duration = null;
        if (millis < 1000L) {
            duration = millis + " ms";
        } else if (millis < 5000L) {
            DecimalFormat df2 = new DecimalFormat("0.00");
            duration = df2.format((float)millis / 1000.0f) + " sec";
        } else if (millis < 10000L) {
            DecimalFormat df3 = new DecimalFormat("0.0");
            duration = df3.format((float)millis / 1000.0f) + " sec";
        } else {
            duration = millis < 60000L ? DurationFormatUtils.formatDuration((long)millis, (String)"s' sec'") : (millis < 3600000L ? DurationFormatUtils.formatDuration((long)millis, (String)"m' min 's' sec'") : (millis < 86400000L ? DurationFormatUtils.formatDuration((long)millis, (String)"H' hrs 'm' min'") : (millis < 2592000000L ? DurationFormatUtils.formatDuration((long)millis, (String)"d' days 'H' hrs'") : DurationFormatUtils.formatDuration((long)millis, (String)"M' months 'd' days'"))));
        }
        duration = Strings.CS.replaceOnce((String)duration, " 0 sec", "");
        duration = Strings.CS.replaceOnce((String)duration, " 0 min", "");
        duration = Strings.CS.replaceOnce((String)duration, " 0 hrs", "");
        duration = Strings.CS.replaceOnce((String)duration, " 0 days", "");
        duration = Strings.CS.replaceOnce((String)duration, " 0 months", "");
        duration = Strings.CS.replaceOnce((String)duration, " 1 hrs", " 1 hr");
        duration = Strings.CS.replaceOnce((String)duration, " 1 days", " 1 day");
        duration = Strings.CS.replaceOnce((String)duration, " 1 months", " 1 month");
        return ((String)duration).trim();
    }

    protected String c(long rows) {
        if (rows == 1L) {
            return "1 row";
        }
        DecimalFormat df2 = new DecimalFormat("###,###,###,###,###");
        return df2.format(rows) + " rows";
    }

    protected String a(long rows, long millis) {
        if (rows == 0L || millis == 0L) {
            return "0 rows/s";
        }
        double rowsPerSec = (float)rows / ((float)millis / 1000.0f);
        DecimalFormat df2 = null;
        df2 = rowsPerSec < 10.0 ? new DecimalFormat("0.0") : new DecimalFormat("###,###,###,###");
        return df2.format(rowsPerSec) + " rows/s";
    }

    protected String a(Date date) {
        return as.formatDate(this.controller, date);
    }

    public void a(ClickEvent<MenuItem> event) {
        String action = ((MenuItem)event.getSource()).getText();
        if (action.equals("Ignore Batch")) {
            this.m();
        } else if (action.equals("Clear Error")) {
            this.c.setErrorFlag(false);
            this.controller.getSymmetricEngine().getOutgoingBatchService().updateOutgoingBatch((OutgoingBatch)this.c);
            this.close();
        } else if (action.equals("Clear Staging")) {
            IStagingManager stagingManager = this.controller.getSymmetricEngine().getStagingManager();
            int clearedCount = 0;
            IStagedResource resource = stagingManager.find(new Object[]{"outgoing", this.c.getStagedLocation(), this.c.getBatchId()});
            if (resource != null) {
                clearedCount += resource.delete() ? 1 : 0;
            }
            this.c.setSentCount(0L);
            this.c.setExtractCount(0L);
            this.controller.getSymmetricEngine().getOutgoingBatchService().updateOutgoingBatch((OutgoingBatch)this.c);
            String userId = this.controller.getConsoleUser().getUserId();
            Node identity = this.controller.getSymmetricEngine().getNodeService().findIdentity();
            this.controller.getConsoleEventService().addEvent(new ConsoleEvent(userId, "Clear staging for batch", identity.getNodeId(), null, null, "clear count=" + clearedCount));
            CommonUiUtils.notify((String)(clearedCount > 0 ? "Staging was cleared for the batch." : "Unable to clear staging.  The batch may currently be processing."));
        } else if (action.equals("Clear Table Cache")) {
            this.controller.getSymmetricEngine().getDatabasePlatform().resetCachedTableModel();
            CommonUiUtils.notify((String)"Table metadata cache was cleared.");
        } else if (action.equals("Send Table Schema")) {
            this.h.a(Collections.singleton((OutgoingBatch)this.c));
        }
    }

    protected void m() {
        String message = this.controller.getMessage("Warning: Data will be lost.\nIgnoring a batch means the data it contains will be ignored\nand the batch will be removed on the next purge.\nThis will cause future issues with synchronization.\nAre you sure?", new Object[0]);
        new ConfirmDialog(this.controller.getMessage("Confirm", new Object[0]), message, this.controller.getMessage("Ok", new Object[0]), (ComponentEventListener & Serializable)e2 -> new M<Boolean>("Ignoring batch...", new M.a<Boolean>(){

            public Boolean a() {
                IOutgoingBatchService batchService = cs.this.controller.getSymmetricEngine().getOutgoingBatchService();
                String sourceNodeId = "";
                boolean error = false;
                try {
                    cs.this.c = batchService.findOutgoingBatch(cs.this.c.getBatchId(), cs.this.c.getNodeId());
                    if (cs.this.c != null && cs.this.c.getStatus() != AbstractBatch.Status.OK) {
                        cs.this.a.info("Ignoring outgoing batch " + cs.this.c.getBatchId());
                        cs.this.c.setStatus(AbstractBatch.Status.IG);
                        cs.this.c.setErrorFlag(false);
                        batchService.updateOutgoingBatch((OutgoingBatch)cs.this.c);
                        List infos = cs.this.controller.getSymmetricEngine().getStatisticManager().getProcessInfos();
                        for (ProcessInfo info : infos) {
                            if (info.getCurrentBatchId() != cs.this.c.getBatchId() || !info.getTargetNodeId().equals(cs.this.c.getNodeId()) || info.getProcessType().equals((Object)ProcessType.INITIAL_LOAD_EXTRACT_JOB)) continue;
                            cs.this.a.info("Sending interrupt to " + info.getKey().toString());
                            info.getThread().interrupt();
                        }
                        cs.this.controller.getRemoteStatusService().sendMessage(cs.this.c.getNodeId(), "batchstop " + cs.this.c.getBatchId());
                        sourceNodeId = cs.this.c.getNodeId();
                    }
                }
                catch (Exception e2) {
                    cs.this.a.error(e2.getMessage(), (Throwable)e2);
                    error = true;
                }
                String userId = cs.this.controller.getConsoleUser().getUserId();
                Node identity = cs.this.controller.getSymmetricEngine().getNodeService().findIdentity();
                cs.this.controller.getConsoleEventService().addEvent(new ConsoleEvent(userId, "Ignore outgoing batch", identity.getNodeId(), identity.getNodeId(), sourceNodeId, String.valueOf(cs.this.c.getBatchId())));
                return error;
            }

            public void a(Boolean error) {
                cs.this.close();
                if (error.booleanValue()) {
                    CommonUiUtils.notify((String)"Failed to mark batch as ignored.  Please check the log file for more details.");
                }
            }

            @Override
            public /* synthetic */ void doUI(Object object) {
                this.a((Boolean)object);
            }

            @Override
            public /* synthetic */ Object doWork() {
                return this.a();
            }
        }, this.controller.getBackgroundRefresherService()).show(), this.controller.getMessage("Cancel", new Object[0]), (ComponentEventListener & Serializable)e2 -> {}).open();
    }

    public /* synthetic */ void onComponentEvent(ComponentEvent componentEvent) {
        this.a((ClickEvent<MenuItem>)((ClickEvent)componentEvent));
    }

    private static /* synthetic */ Object a(SerializedLambda lambda) {
        switch (lambda.getImplMethodName()) {
            case "lambda$showOutgoingBatchInErrorResolution$823c0d79$1": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/HasValue$ValueChangeListener") || !lambda.getFunctionalInterfaceMethodName().equals("valueChanged") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/HasValue$ValueChangeEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/BatchWindow") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/button/Button;Lcom/vaadin/flow/component/AbstractField$ComponentValueChangeEvent;)V")) break;
                return arg_0 -> cs.a((Button)lambda.getCapturedArg(0), arg_0);
            }
            case "lambda$new$1adac058$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/BatchWindow") || !lambda.getImplMethodSignature().equals("(Lorg/jumpmind/symmetric/model/AbstractBatch;ZLcom/vaadin/flow/component/tabs/Tabs$SelectedChangeEvent;)V")) break;
                return arg_0 -> ((cs)((Object)lambda.getCapturedArg(0))).a((AbstractBatch)lambda.getCapturedArg(1), (Boolean)lambda.getCapturedArg(2), arg_0);
            }
            case "lambda$ignoreBatch$9b1b5227$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/BatchWindow") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/confirmdialog/ConfirmDialog$ConfirmEvent;)V")) break;
                return (ComponentEventListener & Serializable)e2 -> new M<Boolean>("Ignoring batch...", new /* invalid duplicate definition of identical inner class */, this.controller.getBackgroundRefresherService()).show();
            }
            case "lambda$ignoreBatch$9b1b5227$2": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/BatchWindow") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/confirmdialog/ConfirmDialog$CancelEvent;)V")) break;
                return (ComponentEventListener & Serializable)e2 -> {};
            }
            case "lambda$new$179f8a1b$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/BatchWindow") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                return (ComponentEventListener & Serializable)event -> this.close();
            }
            case "lambda$showOutgoingBatchInErrorResolution$2c9f9a3a$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/BatchWindow") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/checkbox/Checkbox;Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                return arg_0 -> ((cs)((Object)lambda.getCapturedArg(0))).a((Checkbox)lambda.getCapturedArg(1), arg_0);
            }
            case "lambda$new$a2d5a771$1": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/BatchWindow") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/ui/common/IUIController;Lorg/jumpmind/symmetric/model/AbstractBatch;Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                return arg_0 -> cs.a((I)lambda.getCapturedArg(0), (AbstractBatch)lambda.getCapturedArg(1), arg_0);
            }
            case "lambda$showIncomingBatchInErrorResolution$55e56af0$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/BatchWindow") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/checkbox/Checkbox;Lorg/jumpmind/symmetric/model/IncomingError;Lorg/jumpmind/symmetric/model/IncomingBatch;Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                return arg_0 -> ((cs)((Object)lambda.getCapturedArg(0))).a((Checkbox)lambda.getCapturedArg(1), (IncomingError)lambda.getCapturedArg(2), (IncomingBatch)lambda.getCapturedArg(3), arg_0);
            }
            case "lambda$createDownloadHandler$b5bf057$1": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/server/Command") || !lambda.getFunctionalInterfaceMethodName().equals("execute") || !lambda.getFunctionalInterfaceMethodSignature().equals("()V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/BatchWindow") || !lambda.getImplMethodSignature().equals("()V")) break;
                return (Command & Serializable)() -> CommonUiUtils.notifyError((String)"File not found");
            }
            case "lambda$createDownloadHandler$68eb4c46$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/server/streams/InputStreamDownloadCallback") || !lambda.getFunctionalInterfaceMethodName().equals("complete") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/server/streams/DownloadEvent;)Lcom/vaadin/flow/server/streams/DownloadResponse;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/BatchWindow") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/server/streams/DownloadEvent;)Lcom/vaadin/flow/server/streams/DownloadResponse;")) break;
                return (InputStreamDownloadCallback & Serializable)event -> {
                    InputStream in;
                    if (this.c instanceof OutgoingBatch) {
                        final PipedOutputStream out = new PipedOutputStream();
                        in = new PipedInputStream(out);
                        Thread thread = new /* invalid duplicate definition of identical inner class */;
                        thread.start();
                    } else {
                        ISymmetricEngine sourceEngine;
                        IStagedResource resource = null;
                        ISymmetricEngine engine = this.controller.getSymmetricEngine();
                        boolean useSourceStaging = engine.getConfigurationService().isUseSourceStagingEnabled(this.c.getNodeId());
                        ISymmetricEngine iSymmetricEngine = sourceEngine = useSourceStaging ? AbstractSymmetricEngine.findEngineByNodeId((String)this.c.getNodeId()) : null;
                        if (useSourceStaging && sourceEngine != null) {
                            Batch outgoingBatch = new Batch(Batch.BatchType.EXTRACT, this.c.getBatchId(), this.c.getChannelId(), null, this.c.getNodeId(), engine.getNodeId(), this.c.isCommonFlag());
                            resource = sourceEngine.getStagingManager().find(new Object[]{"outgoing", outgoingBatch.getStagedLocation(), this.c.getBatchId()});
                        } else {
                            String filePath = "incoming/" + this.c.getNodeId() + "/" + StringUtils.leftPad((String)String.valueOf(this.c.getBatchId()), (int)10, (char)'0');
                            resource = engine.getStagingManager().find(filePath);
                        }
                        if (resource.exists()) {
                            try {
                                in = IOUtils.toInputStream((String)IOUtils.toString((Reader)resource.getReader()), (Charset)Charset.defaultCharset());
                            }
                            catch (IOException e2) {
                                this.a.error(String.format("An error was encountered while downloading csv data. ", new Object[0]), (Throwable)e2);
                                throw e2;
                            }
                        } else {
                            as.securelyAccessUI(event.getUI(), (Command & Serializable)() -> CommonUiUtils.notifyError((String)"File not found"));
                            return DownloadResponse.error((HttpStatusCode)HttpStatusCode.NOT_FOUND);
                        }
                    }
                    return new DownloadResponse(in, StringUtils.leftPad((String)Long.toString(this.c.getBatchId()), (int)10, (String)"0") + ".csv", null, -1L);
                };
            }
            case "lambda$new$6650664a$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/server/Command") || !lambda.getFunctionalInterfaceMethodName().equals("execute") || !lambda.getFunctionalInterfaceMethodSignature().equals("()V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/BatchWindow") || !lambda.getImplMethodSignature().equals("()V")) break;
                return (Command & Serializable)() -> this.close();
            }
            case "lambda$new$f2cfd3e8$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/BatchWindow") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                return (ComponentEventListener & Serializable)event -> this.e();
            }
            case "lambda$showIncomingBatchInErrorResolution$85397d65$1": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/BatchWindow") || !lambda.getImplMethodSignature().equals("(Ljava/util/List;)Lcom/vaadin/flow/component/html/Span;")) break;
                return (ValueProvider & Serializable)list -> {
                    Span span = new Span((String)list.get(0));
                    span.setHeight("26px");
                    return span;
                };
            }
            case "lambda$showIncomingBatchInErrorResolution$4016bf38$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/BatchWindow") || !lambda.getImplMethodSignature().equals("(Ljava/lang/Integer;Ljava/util/List;)Lcom/vaadin/flow/component/Component;")) break;
                return arg_0 -> ((cs)((Object)lambda.getCapturedArg(0))).a((Integer)lambda.getCapturedArg(1), arg_0);
            }
        }
        throw new IllegalArgumentException("Invalid lambda deserialization");
    }
}

