/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.ui.common.I;
import com.jumpmind.symmetric.console.ui.common.as;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridVariant;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.Scroller;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.ValueProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.invoke.SerializedLambda;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.PortUnreachableException;
import java.net.ProtocolException;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Strings;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeGroupLink;
import org.jumpmind.symmetric.model.NodeGroupLinkAction;
import org.jumpmind.symmetric.service.impl.BandwidthService;
import org.jumpmind.symmetric.transport.IIncomingTransport;
import org.jumpmind.symmetric.util.SymmetricUtils;
import org.jumpmind.util.CustomizableThreadFactory;
import org.jumpmind.vaadin.ui.common.Label;
import org.jumpmind.vaadin.ui.common.ResizableDialog;
import org.slf4j.MDC;

public class cK
extends ResizableDialog {
    private static final long a = 1L;
    private Scroller b;
    private ISymmetricEngine c;
    private Node d;
    private Node e;
    private static final String f = "^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$";
    private static final String g = "^(([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]*[a-zA-Z0-9])\\.)*([A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\\-]*[A-Za-z0-9])$";
    private IIncomingTransport h;
    private String i;
    private Exception j;
    private CustomizableThreadFactory k;
    private ExecutorService l;
    private List<BandwidthService.BandwidthResults> m = new ArrayList<BandwidthService.BandwidthResults>();
    private List<BandwidthService.BandwidthResults> n = new ArrayList<BandwidthService.BandwidthResults>();
    private Integer o;
    private I p;
    private boolean q;
    private boolean r;

    public cK(I controller, String history, String remoteNodeId) {
        super(controller.getMessage("Node %s to Node %s Connection Test", controller.getSymmetricEngine().getNodeService().findIdentity().getNodeId(), remoteNodeId));
        this.p = controller;
        this.c = controller.getSymmetricEngine();
        this.d = this.c.getNodeService().getCachedIdentity();
        this.e = this.c.getNodeService().findNode(remoteNodeId, false);
        this.setWidth("1024px");
        this.setHeight("700px");
        this.b = new Scroller();
        this.b.setSizeFull();
        Scroller treePanel = new Scroller();
        treePanel.setHeight("250px");
        this.g();
        Button refreshNow = new Button("Run Diagnostic");
        refreshNow.addClickListener((ComponentEventListener & Serializable)event -> this.e());
        if (!this.c()) {
            refreshNow.setEnabled(false);
            VerticalLayout messageLayout = new VerticalLayout();
            messageLayout.setPadding(false);
            Span message = new Span(controller.getMessage("The current node is unable to initiate communication with the remote node.", new Object[0]));
            message.addClassName("v-label-marked");
            messageLayout.add(new Component[]{message});
            this.add((Component)messageLayout);
        }
        this.add((Component)this.b, 1);
        this.buildButtonFooter(new Component[]{refreshNow, this.buildCloseButton()});
    }

    protected Button buildCloseButton() {
        Button closeButton = new Button("Close");
        closeButton.getElement().setAttribute("theme", "primary");
        closeButton.addClickListener((ComponentEventListener & Serializable)event -> {
            if (this.onClose()) {
                if (this.l != null) {
                    this.l.shutdownNow();
                }
                this.close();
            }
        });
        closeButton.focus();
        return closeButton;
    }

    private void b() {
        MDC.put((String)"engineName", (String)this.c.getParameterService().getEngineName());
        UI ui = this.b.getUI().orElse(null);
        if (ui != null) {
            ui.getSession().lock();
            VerticalLayout loadDiagLayout = new VerticalLayout();
            this.b.setContent((Component)loadDiagLayout);
            loadDiagLayout.add(new Component[]{as.getSpinnerIcon("24px", "inherit")});
            loadDiagLayout.add(new Component[]{this.d()});
            loadDiagLayout.add(new Component[]{this.a(false)});
            loadDiagLayout.setSpacing(true);
            loadDiagLayout.setMargin(false);
            ui.getSession().unlock();
            ui.getSession().lock();
            VerticalLayout diagLayout = new VerticalLayout();
            this.b.setContent((Component)diagLayout);
            List groupLinks = this.c.getConfigurationService().getNodeGroupLinks(false);
            this.q = false;
            this.r = false;
            for (NodeGroupLink link : groupLinks) {
                if (link.getSourceNodeGroupId().equals(this.d.getNodeGroupId()) && link.getTargetNodeGroupId().equals(this.e.getNodeGroupId()) && link.getDataEventAction() == NodeGroupLinkAction.P) {
                    this.r = true;
                }
                if (!link.getTargetNodeGroupId().equals(this.d.getNodeGroupId()) || !link.getSourceNodeGroupId().equals(this.e.getNodeGroupId()) || link.getDataEventAction() != NodeGroupLinkAction.W) continue;
                this.q = true;
            }
            this.f();
            diagLayout.add(new Component[]{this.d()});
            diagLayout.add(new Component[]{this.a(true)});
            diagLayout.add(new Component[]{this.h()});
            diagLayout.setSpacing(true);
            diagLayout.setMargin(false);
            ui.getSession().unlock();
        }
    }

    private boolean c() {
        NodeGroupLink localToRemote = this.c.getConfigurationService().getNodeGroupLinkFor(this.d.getNodeGroupId(), this.e.getNodeGroupId(), false);
        NodeGroupLink remoteToLocal = this.c.getConfigurationService().getNodeGroupLinkFor(this.e.getNodeGroupId(), this.d.getNodeGroupId(), false);
        return localToRemote != null && localToRemote.getDataEventAction().equals((Object)NodeGroupLinkAction.P) || remoteToLocal != null && remoteToLocal.getDataEventAction().equals((Object)NodeGroupLinkAction.W);
    }

    private HorizontalLayout d() {
        Span urlSpan = new Span(this.p.getMessage("URL:", new Object[0]));
        urlSpan.setClassName("bold");
        return new HorizontalLayout(new Component[]{urlSpan, new Span(this.e.getSyncUrl())});
    }

    private void e() {
        if (this.k == null) {
            this.k = new CustomizableThreadFactory(String.format("%s-diagnostic", this.c.getEngineName().toLowerCase()));
        }
        this.l = Executors.newFixedThreadPool(1, (ThreadFactory)this.k);
        this.l.submit(this::b);
        this.l.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void f() {
        this.i = "";
        this.h = null;
        this.j = null;
        this.o = 0;
        InputStream stream = null;
        try {
            if (this.r || this.q) {
                long start = System.currentTimeMillis();
                this.h = this.c.getTransportManager().getPingTransport(this.e, this.d, this.e.getSyncUrl());
                stream = this.h.openStream();
                this.i = IOUtils.toString((InputStream)stream, (Charset)Charset.defaultCharset());
                long stop = System.currentTimeMillis();
                this.o = (int)(stop - start);
            }
        }
        catch (Exception e2) {
            this.j = e2;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void g() {
        VerticalLayout diagLayout = new VerticalLayout();
        diagLayout.add(new Component[]{this.d()});
        diagLayout.add(new Component[]{this.a(false)});
        diagLayout.setSpacing(true);
        diagLayout.setMargin(false);
        this.b.setContent((Component)diagLayout);
    }

    private VerticalLayout h() {
        VerticalLayout layout = new VerticalLayout();
        layout.setWidth("100%");
        layout.setPadding(false);
        VerticalLayout stLayout = new VerticalLayout();
        stLayout.setSpacing(true);
        stLayout.setPadding(false);
        if (this.j != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            this.j.printStackTrace(pw);
            Label stLabel = new Label(sw.toString());
            stLabel.setWidth("512px");
            stLayout.add(new Component[]{stLabel});
        }
        VerticalLayout heLayout = new VerticalLayout();
        heLayout.setSpacing(true);
        heLayout.setPadding(false);
        if (this.h != null && !this.h.getHeaders().isEmpty()) {
            Map headers = this.h.getHeaders();
            Set keySet = headers.keySet();
            StringBuilder builder = new StringBuilder();
            builder.append("**HEADERS**\n");
            for (String key : keySet) {
                builder.append(key + ": " + (String)headers.get(key) + "\n");
            }
            heLayout.add(new Component[]{new Label(builder.toString())});
        } else if (this.r || this.q) {
            heLayout.add(new Component[]{new Span("No Headers Returned")});
        }
        layout.add(new Component[]{heLayout});
        layout.add(new Component[]{stLayout});
        return layout;
    }

    private Grid<Object> a(boolean generateResults) {
        if (generateResults) {
            this.a();
        }
        Grid grid = new Grid();
        grid.setWidthFull();
        grid.setHeight("391px");
        grid.addClassNames(new String[]{"errors-table", "compact-header"});
        grid.addThemeVariants(new GridVariant[]{GridVariant.LUMO_WRAP_CELL_CONTENT, GridVariant.LUMO_COLUMN_BORDERS});
        grid.setSelectionMode(Grid.SelectionMode.NONE);
        grid.addComponentColumn((ValueProvider & Serializable)item -> {
            if (item instanceof a) {
                a id = (a)((Object)((Object)item));
                switch (id) {
                    case URL_VALID: {
                        return new Span(this.p.getMessage("URL Valid:", new Object[0]));
                    }
                    case HOST_VALID: {
                        return new Span(this.p.getMessage("Host Valid:", new Object[0]));
                    }
                    case CERT_TRUSTED: {
                        return new Span(this.p.getMessage("Certificate Trusted:", new Object[0]));
                    }
                    case PING: {
                        return new Span(this.p.getMessage("Connect to Ping URL:", new Object[0]));
                    }
                }
            } else if (generateResults && item instanceof BandwidthService.BandwidthResults) {
                BandwidthService.BandwidthResults bw2 = (BandwidthService.BandwidthResults)item;
                String size = " (" + NumberFormat.getInstance().format(bw2.getPayloadSize()) + ")";
                if (this.m.contains(bw2)) {
                    return new Span(this.p.getMessage("Download", new Object[0]) + size);
                }
                if (this.n.contains(bw2)) {
                    return new Span(this.p.getMessage("Upload", new Object[0]) + size);
                }
            }
            return new Span();
        }).setHeader(this.p.getMessage("Test", new Object[0])).setPartNameGenerator((SerializableFunction & Serializable)item -> "align-center");
        String urlDiagnosis = this.j();
        String hostDiagnosis = this.k();
        String pingDiagnosis = this.i();
        String certDiagnosis = this.l();
        grid.addComponentColumn((ValueProvider & Serializable)item -> {
            if (generateResults) {
                if (item instanceof a) {
                    a id = (a)((Object)((Object)item));
                    switch (id) {
                        case URL_VALID: {
                            return this.a(urlDiagnosis);
                        }
                        case HOST_VALID: {
                            return this.a(hostDiagnosis);
                        }
                        case CERT_TRUSTED: {
                            return this.a(certDiagnosis);
                        }
                        case PING: {
                            return this.a(pingDiagnosis);
                        }
                    }
                } else if (item instanceof BandwidthService.BandwidthResults) {
                    BandwidthService.BandwidthResults bw2 = (BandwidthService.BandwidthResults)item;
                    Span status = new Span();
                    if (bw2.isFailure()) {
                        status.setText("Failed");
                        status.getStyle().setColor("var(--lumo-error-text-color)");
                    } else {
                        status.setText("Passed");
                        status.getStyle().setColor("var(--lumo-success-text-color)");
                    }
                    return status;
                }
            }
            return new Span();
        }).setHeader(this.p.getMessage("Result", new Object[0])).setPartNameGenerator((SerializableFunction & Serializable)item -> "align-center");
        grid.addComponentColumn((ValueProvider & Serializable)item -> {
            if (generateResults) {
                if (item instanceof a) {
                    a id = (a)((Object)((Object)item));
                    switch (id) {
                        case URL_VALID: {
                            return this.b(urlDiagnosis);
                        }
                        case HOST_VALID: {
                            return this.b(hostDiagnosis);
                        }
                        case CERT_TRUSTED: {
                            return this.b(certDiagnosis);
                        }
                        case PING: {
                            if (pingDiagnosis != null) {
                                return this.b(pingDiagnosis);
                            }
                            return new Span(this.p.getMessage("%s ms", this.o.toString()));
                        }
                    }
                } else if (item instanceof BandwidthService.BandwidthResults) {
                    BandwidthService.BandwidthResults bw2 = (BandwidthService.BandwidthResults)item;
                    if (bw2.isFailure()) {
                        return new Span(this.p.getMessage("%s", bw2.getFailureMessage()));
                    }
                    NumberFormat numberFormat = NumberFormat.getInstance();
                    numberFormat.setMinimumFractionDigits(0);
                    numberFormat.setMaximumFractionDigits(0);
                    return new Span(this.p.getMessage("%s Kbps", numberFormat.format(bw2.getKbps())));
                }
            }
            return new Span();
        }).setHeader(this.p.getMessage("Details", new Object[0])).setPartNameGenerator((SerializableFunction & Serializable)item -> "align-center");
        for (Grid.Column column : grid.getColumns()) {
            column.setResizable(true);
        }
        ArrayList<a> itemList = new ArrayList<a>(Arrays.asList(com.jumpmind.symmetric.console.impl.cK$a.values()));
        itemList.addAll(this.m);
        itemList.addAll(this.n);
        grid.setItems(itemList);
        return grid;
    }

    protected void a() {
        this.m.clear();
        this.n.clear();
        if (this.q) {
            this.m.addAll(this.c.getBandwidthService().diagnoseDownloadBandwidth(this.d, this.e));
        }
        if (this.r) {
            this.n.addAll(this.c.getBandwidthService().diagnoseUploadBandwidth(this.d, this.e));
        }
    }

    private String i() {
        if (this.j != null) {
            if (this.j instanceof UnknownHostException) {
                return "The host specified could not be found. Are you sure you typed it correctly?";
            }
            if (this.j instanceof ClosedChannelException) {
                return "The channel is/has closed before the ping could be completed. Ensure you do not close necessary channels and all operations are available.";
            }
            if (this.j instanceof InterruptedIOException) {
                return "The ping was interrupted. Please do not close or terminate andy relevant processes while the ping is running.";
            }
            if (this.j instanceof NoRouteToHostException) {
                return "Could not reach the Sync URL. This is typically due to a firewall or a downed internet router.";
            }
            if (this.j instanceof PortUnreachableException) {
                return "Port could not be reached. Please ensure the port is typed correctly if applicable and port-forwarded";
            }
            if (this.j instanceof ConnectException) {
                if (this.j.getMessage().contains("Connection timed out")) {
                    return "Connection has timed out. Please ensure the Sync URL is correct and you are connected to the network.";
                }
                if (this.j.getMessage().contains("Connection refused")) {
                    return "Connection has been refused. Ensure the Sync URL port is not blocked and both nodes are running and connected to the network.";
                }
                return "Could not connect to Sync URL. Ensure the Sync URL hostname and port are correct.";
            }
            if (this.j instanceof ProtocolException) {
                return "There was a problem with your protocol. Are you sure it is correct in your sync URL?";
            }
            if (this.j instanceof SocketException) {
                if (this.j.getMessage().contains("Unexpected end of file from server")) {
                    return "The connection closed unexpectedly. Please ensure the port is forwarded in your router and no external services are configured to interrupt or block the port or host.";
                }
                return "There was a problem with the socket. See the details below for more information.";
            }
            if (this.j instanceof IOException) {
                return "Received an unexpected IOException. See the details below for more information.";
            }
        }
        if (!this.r && !this.q) {
            return "N/A";
        }
        if (this.i != null && this.i.equals("pong") || !this.r && !this.q) {
            return null;
        }
        if (this.i != null && !this.i.isEmpty()) {
            return this.p.getMessage("The code \"%s\" was received instead of pong", this.i);
        }
        return "No response received on ping. There is probably another network issue causing this, or you're not trying to connect to a Symmetric Node.";
    }

    private String j() {
        try {
            URL uRL = new URL(this.e.getSyncUrl());
        }
        catch (MalformedURLException e2) {
            return "Malformed URL. Ensure your Sync URL is entered correctly.";
        }
        return null;
    }

    private String k() {
        try {
            URL url = new URL(this.e.getSyncUrl());
            if (!url.getHost().matches(g) && !url.getHost().matches(f)) {
                return this.p.getMessage("Malformed Hostname (\"%s\"). Please ensure your hostname is spelled correctly.", url.getHost());
            }
        }
        catch (MalformedURLException e2) {
            return "Malformed URL. Ensure your Sync URL is entered correctly.";
        }
        return null;
    }

    private String l() {
        try {
            Certificate[] remoteCerts = SymmetricUtils.getCertificates((String)this.e.getSyncUrl());
            if (remoteCerts == null) {
                return this.p.getMessage("N/A", new Object[0]);
            }
            KeyStore trustStore = this.c.getSecurityService().getTrustStore();
            block5: for (Certificate cert : remoteCerts) {
                X509Certificate x509Cert;
                X500Principal subjectPrincipal;
                if (!(cert instanceof X509Certificate) || (subjectPrincipal = (x509Cert = (X509Certificate)cert).getSubjectX500Principal()).equals(x509Cert.getIssuerX500Principal()) && Strings.CI.contains((CharSequence)subjectPrincipal.getName(), (CharSequence)"O=JumpMind")) continue;
                Enumeration<String> aliases = trustStore.aliases();
                while (aliases.hasMoreElements()) {
                    X509Certificate trustedCert;
                    Certificate certificate;
                    String alias = aliases.nextElement();
                    if (!trustStore.isCertificateEntry(alias) && !trustStore.isKeyEntry(alias) || !((certificate = trustStore.getCertificate(alias)) instanceof X509Certificate) || !subjectPrincipal.equals((trustedCert = (X509Certificate)certificate).getSubjectX500Principal())) continue;
                    continue block5;
                }
                return this.p.getMessage("Untrusted Certificate. Go to the Manage Security screen's Authorities tab and import the remote node's certificate chain into the current node's trusted keystore using the Import File or Import URL button.", new Object[0]);
            }
            return null;
        }
        catch (MalformedURLException e2) {
            return this.p.getMessage("Malformed URL. Ensure your Sync URL is entered correctly.", new Object[0]);
        }
        catch (IOException e3) {
            return this.p.getMessage("Failed to connect", new Object[0]);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e4) {
            return this.p.getMessage("Failed to initialize SSL", new Object[0]);
        }
        catch (KeyStoreException e5) {
            return this.p.getMessage("Failed to access trusted keystore", new Object[0]);
        }
    }

    private Span a(String diagnosis) {
        if (diagnosis != null) {
            if (diagnosis.equals("N/A")) {
                return new Span(diagnosis);
            }
            Span status = new Span("Failed");
            status.getStyle().setColor("var(--lumo-error-text-color)");
            return status;
        }
        Span status = new Span("Passed");
        status.getStyle().setColor("var(--lumo-success-text-color)");
        return status;
    }

    private Span b(String diagnosis) {
        if (diagnosis != null && !diagnosis.equals("N/A")) {
            return new Span(diagnosis);
        }
        return new Span();
    }

    private static /* synthetic */ Object a(SerializedLambda lambda) {
        switch (lambda.getImplMethodName()) {
            case "lambda$buildCloseButton$5526762e$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/NodeConnectionDiagnosticScreen") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                return (ComponentEventListener & Serializable)event -> {
                    if (this.onClose()) {
                        if (this.l != null) {
                            this.l.shutdownNow();
                        }
                        this.close();
                    }
                };
            }
            case "lambda$buildDiagnosticGrid$9ef38779$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/NodeConnectionDiagnosticScreen") || !lambda.getImplMethodSignature().equals("(ZLjava/lang/Object;)Lcom/vaadin/flow/component/html/Span;")) break;
                return arg_0 -> ((cK)((Object)lambda.getCapturedArg(0))).a((Boolean)lambda.getCapturedArg(1), arg_0);
            }
            case "lambda$buildDiagnosticGrid$f0fd4efa$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/NodeConnectionDiagnosticScreen") || !lambda.getImplMethodSignature().equals("(ZLjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;)Lcom/vaadin/flow/component/html/Span;")) break;
                return arg_0 -> ((cK)((Object)lambda.getCapturedArg(0))).b((Boolean)lambda.getCapturedArg(1), (String)lambda.getCapturedArg(2), (String)lambda.getCapturedArg(3), (String)lambda.getCapturedArg(4), (String)lambda.getCapturedArg(5), arg_0);
            }
            case "lambda$new$3e70c8b$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/NodeConnectionDiagnosticScreen") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                return (ComponentEventListener & Serializable)event -> this.e();
            }
            case "lambda$buildDiagnosticGrid$f0fd4efa$2": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/NodeConnectionDiagnosticScreen") || !lambda.getImplMethodSignature().equals("(ZLjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;)Lcom/vaadin/flow/component/html/Span;")) break;
                return arg_0 -> ((cK)((Object)lambda.getCapturedArg(0))).a((Boolean)lambda.getCapturedArg(1), (String)lambda.getCapturedArg(2), (String)lambda.getCapturedArg(3), (String)lambda.getCapturedArg(4), (String)lambda.getCapturedArg(5), arg_0);
            }
            case "lambda$buildDiagnosticGrid$61a98d8c$1": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/SerializableFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/NodeConnectionDiagnosticScreen") || !lambda.getImplMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/String;")) break;
                return (SerializableFunction & Serializable)item -> "align-center";
            }
            case "lambda$buildDiagnosticGrid$61a98d8c$2": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/SerializableFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/NodeConnectionDiagnosticScreen") || !lambda.getImplMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/String;")) break;
                return (SerializableFunction & Serializable)item -> "align-center";
            }
            case "lambda$buildDiagnosticGrid$61a98d8c$3": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/SerializableFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/NodeConnectionDiagnosticScreen") || !lambda.getImplMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/String;")) break;
                return (SerializableFunction & Serializable)item -> "align-center";
            }
        }
        throw new IllegalArgumentException("Invalid lambda deserialization");
    }

    private static enum a {
        URL_VALID,
        HOST_VALID,
        CERT_TRUSTED,
        PING;

    }
}

