/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.google.gson.reflect.TypeToken;
import com.jumpmind.symmetric.console.impl.aL;
import com.jumpmind.symmetric.console.impl.fY;
import com.jumpmind.symmetric.console.impl.ga;
import com.jumpmind.symmetric.console.model.ConsoleEvent;
import com.jumpmind.symmetric.console.model.Monitor;
import com.jumpmind.symmetric.console.model.MonitorEvent;
import com.jumpmind.symmetric.console.ui.common.E;
import com.jumpmind.symmetric.console.ui.common.H;
import com.jumpmind.symmetric.console.ui.common.I;
import com.jumpmind.symmetric.console.ui.common.J;
import com.jumpmind.symmetric.console.ui.common.K;
import com.jumpmind.symmetric.console.ui.common.ap;
import com.jumpmind.symmetric.console.ui.common.as;
import com.jumpmind.symmetric.console.ui.common.au;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.select.Select;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.selection.SelectionListener;
import com.vaadin.flow.data.value.ValueChangeMode;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Transaction;
import org.jumpmind.util.LogSummary;
import org.jumpmind.vaadin.ui.common.ColumnVisibilityToggler;
import org.jumpmind.vaadin.ui.common.ReadOnlyTextAreaDialog;

public class cI
extends ap
implements E,
H,
J {
    private static final long h = 1L;
    protected au a;
    protected Select<String> b;
    protected Select<Integer> c;
    protected Select<Integer> d;
    protected String e;
    protected Grid<MonitorEvent> f;
    protected Span g;

    public cI(I controller) {
        super(controller, null, "Monitoring detects the event of a value exceeding a threshold. You can specify the number of returned monitors below.");
    }

    @Override
    public void init() {
        if (this.f == null) {
            this.setSpacing(true);
            HorizontalLayout buttonLayout = new HorizontalLayout();
            buttonLayout.setSpacing(true);
            Button refreshButton = as.createIconButton(K.REFRESH);
            refreshButton.addClickListener((ComponentEventListener & Serializable)event -> this.a());
            buttonLayout.add(new Component[]{refreshButton});
            buttonLayout.setVerticalComponentAlignment(FlexComponent.Alignment.END, new Component[]{refreshButton});
            this.a = new au();
            this.a.setPlaceholder(this.controller.getMessage("Monitors", new Object[0]));
            this.a.addValidator((SerializablePredicate<String>)(SerializablePredicate & Serializable)value -> {
                if (StringUtils.isEmpty((CharSequence)(value = StringUtils.trim((String)value))) || value.equalsIgnoreCase(this.controller.getMessage("All", new Object[0]))) {
                    return true;
                }
                try {
                    Integer.parseInt(value);
                }
                catch (NumberFormatException ex2) {
                    return false;
                }
                return true;
            }, this.controller.getMessage("Value must be an integer", new Object[0]));
            this.a.setWidth("5em");
            this.a.setValue("100");
            this.a.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.a());
            buttonLayout.add(new Component[]{this.a});
            buttonLayout.setVerticalComponentAlignment(FlexComponent.Alignment.END, new Component[]{this.a});
            ArrayList<String> types = new ArrayList<String>();
            for (ga monitorCheck : this.controller.getSymmetricEngine().getExtensionService().getExtensionPointList(ga.class)) {
                types.add(monitorCheck.b());
            }
            Collections.sort(types);
            types.add(0, "<Any>");
            this.b = new Select();
            this.b.setItems(types);
            this.b.setLabel(this.controller.getMessage("Type", new Object[0]));
            this.b.setEmptySelectionAllowed(false);
            this.b.setValue((Object)"<Any>");
            this.b.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.a());
            buttonLayout.add(new Component[]{this.b});
            buttonLayout.setVerticalComponentAlignment(FlexComponent.Alignment.END, new Component[]{this.b});
            ArrayList<Integer> severityLevels = new ArrayList<Integer>();
            Map<Integer, String> severityLevelNames = Monitor.getSeverityLevelNames();
            severityLevels.add(0);
            for (Integer severityLevel : severityLevelNames.keySet()) {
                severityLevels.add(severityLevel);
            }
            this.c = new Select();
            this.c.setItems(severityLevels);
            this.c.setLabel(this.controller.getMessage("Severity", new Object[0]));
            this.c.setEmptySelectionAllowed(false);
            this.c.setWidth("8em");
            this.c.setValue((Object)0);
            this.c.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.a());
            this.c.setItemLabelGenerator((ItemLabelGenerator & Serializable)item -> {
                if (item == 0) {
                    return "<Any>";
                }
                for (Integer severityLevel : severityLevelNames.keySet()) {
                    if (item != severityLevel) continue;
                    return (String)severityLevelNames.get(severityLevel);
                }
                return item.toString();
            });
            buttonLayout.add(new Component[]{this.c});
            buttonLayout.setVerticalComponentAlignment(FlexComponent.Alignment.END, new Component[]{this.c});
            ArrayList<Integer> statuses = new ArrayList<Integer>();
            statuses.add(-1);
            statuses.add(0);
            statuses.add(1);
            this.d = new Select();
            this.d.setItems(statuses);
            this.d.setLabel(this.controller.getMessage("Status", new Object[0]));
            this.d.setEmptySelectionAllowed(false);
            this.d.setWidth("9em");
            this.d.setValue((Object)0);
            this.d.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.a());
            this.d.setItemLabelGenerator((ItemLabelGenerator & Serializable)item -> {
                switch (item) {
                    case -1: {
                        return "<Any>";
                    }
                    case 0: {
                        return "Unresolved";
                    }
                    case 1: {
                        return "Resolved";
                    }
                }
                return item.toString();
            });
            buttonLayout.add(new Component[]{this.d});
            buttonLayout.setVerticalComponentAlignment(FlexComponent.Alignment.END, new Component[]{this.d});
            TextField nodeIdField = new TextField(this.controller.getMessage("Node Id", new Object[0]));
            nodeIdField.setPrefixComponent((Component)new Icon(VaadinIcon.FILTER));
            nodeIdField.setValueChangeMode(ValueChangeMode.LAZY);
            nodeIdField.setValueChangeTimeout(200);
            nodeIdField.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                this.e = nodeIdField.getValue();
                this.a();
            });
            buttonLayout.add(new Component[]{nodeIdField});
            buttonLayout.setVerticalComponentAlignment(FlexComponent.Alignment.END, new Component[]{nodeIdField});
            Span separator = new Span();
            separator.setClassName("vrule");
            separator.setWidth(null);
            separator.setHeight("60%");
            buttonLayout.add(new Component[]{separator});
            buttonLayout.setVerticalComponentAlignment(FlexComponent.Alignment.END, new Component[]{separator});
            Button removeButton = new Button(this.message("Resolve", new Object[0]));
            removeButton.setEnabled(false);
            removeButton.addClickListener((ComponentEventListener & Serializable)event -> {
                Object ids = "";
                for (MonitorEvent monitorEvent : this.f.getSelectedItems()) {
                    if (monitorEvent.isResolved()) continue;
                    MonitorEvent newEvent = new MonitorEvent();
                    newEvent.setMonitorId(monitorEvent.getMonitorId());
                    newEvent.setNodeId(monitorEvent.getNodeId());
                    newEvent.setEventTime(monitorEvent.getEventTime());
                    newEvent.setLastUpdateTime(new Date());
                    this.controller.getMonitorService().updateMonitorEventAsResolved(newEvent);
                    if (((String)ids).equals("")) {
                        ids = monitorEvent.getMonitorId();
                        continue;
                    }
                    ids = (String)ids + ", " + monitorEvent.getMonitorId();
                }
                if (!((String)ids).equals("")) {
                    String nodeId = this.controller.getSymmetricEngine().getNodeId();
                    this.controller.getConsoleEventService().addEvent(new ConsoleEvent(this.controller.getConsoleUser().getUserId(), "Resolve Monitor Event", nodeId, nodeId, null, (String)ids));
                }
                this.a();
            });
            if (!this.controller.getConsoleUser().hasPrivilegeWrite("Manage Monitors Screen")) {
                removeButton.getElement().setAttribute("title", String.format("Your role '%s' does not have the privileges needed for this action.", this.controller.getConsoleUser().getRole()));
            }
            buttonLayout.add(new Component[]{removeButton});
            buttonLayout.setVerticalComponentAlignment(FlexComponent.Alignment.END, new Component[]{removeButton});
            buttonLayout.addAndExpand(new Component[]{new Span()});
            ColumnVisibilityToggler columnVisibilityToggler = new ColumnVisibilityToggler();
            buttonLayout.add(new Component[]{columnVisibilityToggler});
            buttonLayout.setVerticalComponentAlignment(FlexComponent.Alignment.END, new Component[]{columnVisibilityToggler});
            this.content.add(new Component[]{buttonLayout});
            this.f = new Grid();
            this.f.setSizeFull();
            this.f.setSelectionMode(Grid.SelectionMode.MULTI);
            this.f.setColumnReorderingAllowed(true);
            columnVisibilityToggler.addColumn(this.f.addColumn((ValueProvider & Serializable)event -> event.getMonitorId()).setHeader("Monitor ID"), "Monitor ID");
            columnVisibilityToggler.addColumn(this.f.addColumn((ValueProvider & Serializable)event -> event.getNodeId()).setHeader("Node ID"), "Node ID");
            columnVisibilityToggler.addColumn(this.f.addColumn((ValueProvider & Serializable)event -> as.formatDate(this.controller, event.getEventTime(), true)).setHeader("Event Time").setComparator((ValueProvider & Serializable)event -> event.getEventTime()), "Event Time");
            columnVisibilityToggler.addColumn(this.f.addColumn((ValueProvider & Serializable)event -> event.getType()).setHeader("Type"), "Type");
            columnVisibilityToggler.addColumn(this.f.addColumn((ValueProvider & Serializable)event -> event.getValue()).setHeader("Value"), "Value");
            columnVisibilityToggler.addColumn(this.f.addColumn((ValueProvider & Serializable)event -> event.getCount()).setHeader("Count"), "Count");
            columnVisibilityToggler.addColumn(this.f.addColumn((ValueProvider & Serializable)event -> event.getThreshold()).setHeader("Threshold"), "Threshold");
            columnVisibilityToggler.addColumn(this.f.addColumn((ValueProvider & Serializable)event -> {
                String name = Monitor.getSeverityLevelNames().get(event.getSeverityLevel());
                if (name == null) {
                    name = String.valueOf(event.getSeverityLevel());
                }
                return name;
            }).setHeader("Severity Level"), "Severity Level");
            columnVisibilityToggler.addColumn(this.f.addColumn((ValueProvider & Serializable)event -> event.getHostName()).setHeader("Hostname"), "Hostname").setVisible(false);
            columnVisibilityToggler.addColumn(this.f.addColumn((ValueProvider & Serializable)event -> event.isNotified()).setHeader("Notified"), "Notified").setVisible(false);
            columnVisibilityToggler.addColumn(this.f.addColumn((ValueProvider & Serializable)event -> event.isResolved()).setHeader("Resolved"), "Resolved");
            columnVisibilityToggler.addColumn(this.f.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)event -> {
                String details = event.getDetails();
                if (details != null && !details.equals("")) {
                    Button detailsButton = new Button("Details");
                    detailsButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_SMALL});
                    detailsButton.addClickListener((ComponentEventListener & Serializable)clickEvent -> {
                        switch (event.getType()) {
                            case "block": {
                                Type transactionCollectionType = new TypeToken<Collection<Transaction>>(){}.getType();
                                String[] blockColumnOrder = new String[]{"id", "username", "remoteIp", "remoteHost", "status", "reads", "writes", "blockingId", "startTime", "text"};
                                aL<Transaction> blockDialog = new aL<Transaction>(this.controller, details, Transaction.class, transactionCollectionType, blockColumnOrder);
                                blockDialog.open();
                                break;
                            }
                            case "log": {
                                Type logSummaryCollectionType = new TypeToken<Collection<LogSummary>>(){}.getType();
                                String[] logColumnOrder = new String[]{"level", "mostRecentThreadName", "firstOccurranceTime", "mostRecentTime", "count", "message"};
                                aL<LogSummary> logDialog = new aL<LogSummary>(this.controller, details, LogSummary.class, logSummaryCollectionType, logColumnOrder);
                                logDialog.open();
                                break;
                            }
                            case "batchError": {
                                aL<fY> batchErrorDialog = new aL<fY>(this.controller, details, fY.class, null, null);
                                batchErrorDialog.open();
                                break;
                            }
                            case "offlineNodes": {
                                Type stringCollectionType = new TypeToken<Collection<String>>(){}.getType();
                                String[] offlineNodesColumnOrder = new String[]{};
                                aL<String> offlineNodesDialog = new aL<String>(this.controller, details, String.class, stringCollectionType, offlineNodesColumnOrder);
                                offlineNodesDialog.open();
                                break;
                            }
                            default: {
                                ReadOnlyTextAreaDialog.show((String)"Details", (String)details, (boolean)false);
                            }
                        }
                    });
                    return detailsButton;
                }
                return new Span("");
            })).setHeader("Details").setKey("details"), "Details");
            columnVisibilityToggler.addColumn(this.f.addColumn((ValueProvider & Serializable)event -> as.formatDate(this.controller, event.getLastUpdateTime(), true)).setHeader("Last Update Time").setComparator((ValueProvider & Serializable)event -> event.getLastUpdateTime()), "Last Update Time");
            for (Grid.Column column : this.f.getColumns()) {
                ((Grid.Column)column.setResizable(true)).setSortable(column.getKey() == null || !column.getKey().equals("details"));
            }
            this.f.addItemClickListener((ComponentEventListener & Serializable)event -> {
                if (event.getColumn() != null) {
                    this.f.deselectAll();
                    this.f.select((Object)((MonitorEvent)event.getItem()));
                }
            });
            this.f.addSelectionListener((SelectionListener & Serializable)event -> {
                boolean unresolvedEventSelected = false;
                for (MonitorEvent monitorEvent : this.f.getSelectedItems()) {
                    if (monitorEvent.isResolved()) continue;
                    unresolvedEventSelected = true;
                    break;
                }
                removeButton.setEnabled(this.controller.getConsoleUser().hasPrivilegeWrite("Manage Monitors Screen") && unresolvedEventSelected);
            });
            this.content.add(new Component[]{this.f});
            this.content.setFlexGrow(0.75, new HasElement[]{this.f});
            HorizontalLayout hlayout = new HorizontalLayout();
            this.content.add(new Component[]{hlayout});
            Button selectAllLink = as.createLinkButton(this.controller.getMessage("Select All", new Object[0]));
            hlayout.add(new Component[]{selectAllLink});
            selectAllLink.addClickListener((ComponentEventListener & Serializable)event -> {
                for (MonitorEvent monitorEvent : this.f.getDataProvider().fetch(new Query()).collect(Collectors.toList())) {
                    this.f.select((Object)monitorEvent);
                }
            });
            Button selectNoneLink = as.createLinkButton(this.controller.getMessage("Select None", new Object[0]));
            hlayout.add(new Component[]{selectNoneLink});
            selectNoneLink.addClickListener((ComponentEventListener & Serializable)event -> this.f.deselectAll());
            hlayout.addAndExpand(new Component[]{new Span()});
            hlayout.setWidth("99%");
            this.g = new Span(this.controller.getMessage("Rows Returned", new Object[0]) + ": 0");
            this.g.setSizeUndefined();
            hlayout.add(new Component[]{this.g});
        }
    }

    @Override
    public String getTitleKey() {
        return "Monitor Events";
    }

    @Override
    public void onRefresh(Object ... params) {
        this.a();
    }

    protected void a() {
        if (this.f != null) {
            String bufferSizeString = this.a.getValue().trim();
            int limit = !StringUtils.isEmpty((CharSequence)bufferSizeString) && StringUtils.isNumeric((CharSequence)bufferSizeString) ? Integer.parseInt(bufferSizeString) : -1;
            String type = ((String)this.b.getValue()).equals("<Any>") ? null : (String)this.b.getValue();
            int severityLevel = (Integer)this.c.getValue();
            String nodeId = StringUtils.isBlank((CharSequence)this.e) ? null : this.e;
            int status = (Integer)this.d.getValue();
            Boolean isResolved = status == -1 ? null : Boolean.valueOf(status == 1);
            List<MonitorEvent> events = this.controller.getMonitorService().getMonitorEventsFiltered(limit, type, severityLevel, nodeId, isResolved);
            ArrayList<MonitorEvent> filteredEvents = new ArrayList<MonitorEvent>();
            for (MonitorEvent event : events) {
                if (event.isInsight() || severityLevel != 0 && severityLevel != event.getSeverityLevel()) continue;
                filteredEvents.add(event);
            }
            Set selectedItems = this.f.getSelectedItems();
            this.f.setItems(filteredEvents);
            for (MonitorEvent item : selectedItems) {
                this.f.select((Object)item);
            }
            this.g.setText(this.controller.getMessage("Rows Returned", new Object[0]) + ": " + (events != null ? events.size() : 0));
        }
    }

    @Override
    public boolean onExit(Runnable exitClosure) {
        return true;
    }

    @Override
    public String getDocAnchor() {
        return "/doc/html/user-guide.html#_monitors_2";
    }

    private static /* synthetic */ Object a(SerializedLambda lambda) {
        switch (lambda.getImplMethodName()) {
            case "lambda$init$ba6e7b7d$2": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/MonitorPanel") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/model/MonitorEvent;)Ljava/lang/Object;")) break;
                return (ValueProvider & Serializable)event -> event.getNodeId();
            }
            case "lambda$init$ba6e7b7d$1": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/MonitorPanel") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/model/MonitorEvent;)Ljava/lang/Object;")) break;
                return (ValueProvider & Serializable)event -> event.getMonitorId();
            }
            case "lambda$init$3fab9f70$3": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/HasValue$ValueChangeListener") || !lambda.getFunctionalInterfaceMethodName().equals("valueChanged") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/HasValue$ValueChangeEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/MonitorPanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/AbstractField$ComponentValueChangeEvent;)V")) break;
                return (HasValue.ValueChangeListener & Serializable)event -> this.a();
            }
            case "lambda$init$ba6e7b7d$4": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/MonitorPanel") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/model/MonitorEvent;)Ljava/util/Date;")) break;
                return (ValueProvider & Serializable)event -> event.getEventTime();
            }
            case "lambda$init$3fab9f70$4": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/HasValue$ValueChangeListener") || !lambda.getFunctionalInterfaceMethodName().equals("valueChanged") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/HasValue$ValueChangeEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/MonitorPanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/AbstractField$ComponentValueChangeEvent;)V")) break;
                return (HasValue.ValueChangeListener & Serializable)event -> this.a();
            }
            case "lambda$init$ba6e7b7d$3": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/MonitorPanel") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/model/MonitorEvent;)Ljava/lang/Object;")) break;
                return (ValueProvider & Serializable)event -> as.formatDate(this.controller, event.getEventTime(), true);
            }
            case "lambda$init$ba6e7b7d$6": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/MonitorPanel") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/model/MonitorEvent;)Ljava/lang/Object;")) break;
                return (ValueProvider & Serializable)event -> event.getValue();
            }
            case "lambda$init$ba6e7b7d$5": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/MonitorPanel") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/model/MonitorEvent;)Ljava/lang/Object;")) break;
                return (ValueProvider & Serializable)event -> event.getType();
            }
            case "lambda$init$27e39569$1": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ItemLabelGenerator") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/String;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/MonitorPanel") || !lambda.getImplMethodSignature().equals("(Ljava/util/Map;Ljava/lang/Integer;)Ljava/lang/String;")) break;
                return arg_0 -> cI.a((Map)lambda.getCapturedArg(0), arg_0);
            }
            case "lambda$init$ba6e7b7d$8": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/MonitorPanel") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/model/MonitorEvent;)Ljava/lang/Object;")) break;
                return (ValueProvider & Serializable)event -> event.getThreshold();
            }
            case "lambda$init$ba6e7b7d$7": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/MonitorPanel") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/model/MonitorEvent;)Ljava/lang/Object;")) break;
                return (ValueProvider & Serializable)event -> event.getCount();
            }
            case "lambda$init$ba6e7b7d$9": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/MonitorPanel") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/model/MonitorEvent;)Ljava/lang/Object;")) break;
                return (ValueProvider & Serializable)event -> {
                    String name = Monitor.getSeverityLevelNames().get(event.getSeverityLevel());
                    if (name == null) {
                        name = String.valueOf(event.getSeverityLevel());
                    }
                    return name;
                };
            }
            case "lambda$init$9b1b5227$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/MonitorPanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                return (ComponentEventListener & Serializable)event -> this.a();
            }
            case "lambda$init$9b1b5227$2": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/MonitorPanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                return (ComponentEventListener & Serializable)event -> {
                    Object ids = "";
                    for (MonitorEvent monitorEvent : this.f.getSelectedItems()) {
                        if (monitorEvent.isResolved()) continue;
                        MonitorEvent newEvent = new MonitorEvent();
                        newEvent.setMonitorId(monitorEvent.getMonitorId());
                        newEvent.setNodeId(monitorEvent.getNodeId());
                        newEvent.setEventTime(monitorEvent.getEventTime());
                        newEvent.setLastUpdateTime(new Date());
                        this.controller.getMonitorService().updateMonitorEventAsResolved(newEvent);
                        if (((String)ids).equals("")) {
                            ids = monitorEvent.getMonitorId();
                            continue;
                        }
                        ids = (String)ids + ", " + monitorEvent.getMonitorId();
                    }
                    if (!((String)ids).equals("")) {
                        String nodeId = this.controller.getSymmetricEngine().getNodeId();
                        this.controller.getConsoleEventService().addEvent(new ConsoleEvent(this.controller.getConsoleUser().getUserId(), "Resolve Monitor Event", nodeId, nodeId, null, (String)ids));
                    }
                    this.a();
                };
            }
            case "lambda$init$9b1b5227$3": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/MonitorPanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/grid/ItemClickEvent;)V")) break;
                return (ComponentEventListener & Serializable)event -> {
                    if (event.getColumn() != null) {
                        this.f.deselectAll();
                        this.f.select((Object)((MonitorEvent)event.getItem()));
                    }
                };
            }
            case "lambda$init$9b1b5227$4": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/MonitorPanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                return (ComponentEventListener & Serializable)event -> {
                    for (MonitorEvent monitorEvent : this.f.getDataProvider().fetch(new Query()).collect(Collectors.toList())) {
                        this.f.select((Object)monitorEvent);
                    }
                };
            }
            case "lambda$init$9b1b5227$5": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/MonitorPanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                return (ComponentEventListener & Serializable)event -> this.f.deselectAll();
            }
            case "lambda$init$23ef4b97$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/MonitorPanel") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/model/MonitorEvent;Ljava/lang/String;Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                return arg_0 -> ((cI)lambda.getCapturedArg(0)).a((MonitorEvent)lambda.getCapturedArg(1), (String)lambda.getCapturedArg(2), arg_0);
            }
            case "lambda$init$af4ea6c4$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/data/selection/SelectionListener") || !lambda.getFunctionalInterfaceMethodName().equals("selectionChange") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/data/selection/SelectionEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/MonitorPanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/button/Button;Lcom/vaadin/flow/data/selection/SelectionEvent;)V")) break;
                return arg_0 -> ((cI)lambda.getCapturedArg(0)).a((Button)lambda.getCapturedArg(1), arg_0);
            }
            case "lambda$init$3fed5817$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/SerializableFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/MonitorPanel") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/model/MonitorEvent;)Lcom/vaadin/flow/component/Component;")) break;
                return (SerializableFunction & Serializable)event -> {
                    String details = event.getDetails();
                    if (details != null && !details.equals("")) {
                        Button detailsButton = new Button("Details");
                        detailsButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_SMALL});
                        detailsButton.addClickListener((ComponentEventListener & Serializable)clickEvent -> {
                            switch (event.getType()) {
                                case "block": {
                                    Type transactionCollectionType = new /* invalid duplicate definition of identical inner class */.getType();
                                    String[] blockColumnOrder = new String[]{"id", "username", "remoteIp", "remoteHost", "status", "reads", "writes", "blockingId", "startTime", "text"};
                                    aL<Transaction> blockDialog = new aL<Transaction>(this.controller, details, Transaction.class, transactionCollectionType, blockColumnOrder);
                                    blockDialog.open();
                                    break;
                                }
                                case "log": {
                                    Type logSummaryCollectionType = new /* invalid duplicate definition of identical inner class */.getType();
                                    String[] logColumnOrder = new String[]{"level", "mostRecentThreadName", "firstOccurranceTime", "mostRecentTime", "count", "message"};
                                    aL<LogSummary> logDialog = new aL<LogSummary>(this.controller, details, LogSummary.class, logSummaryCollectionType, logColumnOrder);
                                    logDialog.open();
                                    break;
                                }
                                case "batchError": {
                                    aL<fY> batchErrorDialog = new aL<fY>(this.controller, details, fY.class, null, null);
                                    batchErrorDialog.open();
                                    break;
                                }
                                case "offlineNodes": {
                                    Type stringCollectionType = new /* invalid duplicate definition of identical inner class */.getType();
                                    String[] offlineNodesColumnOrder = new String[]{};
                                    aL<String> offlineNodesDialog = new aL<String>(this.controller, details, String.class, stringCollectionType, offlineNodesColumnOrder);
                                    offlineNodesDialog.open();
                                    break;
                                }
                                default: {
                                    ReadOnlyTextAreaDialog.show((String)"Details", (String)details, (boolean)false);
                                }
                            }
                        });
                        return detailsButton;
                    }
                    return new Span("");
                };
            }
            case "lambda$init$6aa565a$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/SerializablePredicate") || !lambda.getFunctionalInterfaceMethodName().equals("test") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Z") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/MonitorPanel") || !lambda.getImplMethodSignature().equals("(Ljava/lang/String;)Z")) break;
                return (SerializablePredicate & Serializable)value -> {
                    if (StringUtils.isEmpty((CharSequence)(value = StringUtils.trim((String)value))) || value.equalsIgnoreCase(this.controller.getMessage("All", new Object[0]))) {
                        return true;
                    }
                    try {
                        Integer.parseInt(value);
                    }
                    catch (NumberFormatException ex2) {
                        return false;
                    }
                    return true;
                };
            }
            case "lambda$init$e74a5586$1": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ItemLabelGenerator") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/String;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/MonitorPanel") || !lambda.getImplMethodSignature().equals("(Ljava/lang/Integer;)Ljava/lang/String;")) break;
                return (ItemLabelGenerator & Serializable)item -> {
                    switch (item) {
                        case -1: {
                            return "<Any>";
                        }
                        case 0: {
                            return "Unresolved";
                        }
                        case 1: {
                            return "Resolved";
                        }
                    }
                    return item.toString();
                };
            }
            case "lambda$init$f7fa61e$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/HasValue$ValueChangeListener") || !lambda.getFunctionalInterfaceMethodName().equals("valueChanged") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/HasValue$ValueChangeEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/MonitorPanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/textfield/TextField;Lcom/vaadin/flow/component/AbstractField$ComponentValueChangeEvent;)V")) break;
                return arg_0 -> ((cI)lambda.getCapturedArg(0)).a((TextField)lambda.getCapturedArg(1), arg_0);
            }
            case "lambda$init$ba6e7b7d$14": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/MonitorPanel") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/model/MonitorEvent;)Ljava/util/Date;")) break;
                return (ValueProvider & Serializable)event -> event.getLastUpdateTime();
            }
            case "lambda$init$ba6e7b7d$13": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/MonitorPanel") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/model/MonitorEvent;)Ljava/lang/Object;")) break;
                return (ValueProvider & Serializable)event -> as.formatDate(this.controller, event.getLastUpdateTime(), true);
            }
            case "lambda$init$ba6e7b7d$12": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/MonitorPanel") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/model/MonitorEvent;)Ljava/lang/Object;")) break;
                return (ValueProvider & Serializable)event -> event.isResolved();
            }
            case "lambda$init$ba6e7b7d$11": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/MonitorPanel") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/model/MonitorEvent;)Ljava/lang/Object;")) break;
                return (ValueProvider & Serializable)event -> event.isNotified();
            }
            case "lambda$init$ba6e7b7d$10": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/MonitorPanel") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/model/MonitorEvent;)Ljava/lang/Object;")) break;
                return (ValueProvider & Serializable)event -> event.getHostName();
            }
            case "lambda$init$3fab9f70$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/HasValue$ValueChangeListener") || !lambda.getFunctionalInterfaceMethodName().equals("valueChanged") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/HasValue$ValueChangeEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/MonitorPanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/AbstractField$ComponentValueChangeEvent;)V")) break;
                return (HasValue.ValueChangeListener & Serializable)event -> this.a();
            }
            case "lambda$init$3fab9f70$2": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/HasValue$ValueChangeListener") || !lambda.getFunctionalInterfaceMethodName().equals("valueChanged") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/HasValue$ValueChangeEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/MonitorPanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/AbstractField$ComponentValueChangeEvent;)V")) break;
                return (HasValue.ValueChangeListener & Serializable)event -> this.a();
            }
        }
        throw new IllegalArgumentException("Invalid lambda deserialization");
    }
}

