/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.model.ConsoleEvent;
import com.jumpmind.symmetric.console.ui.common.H;
import com.jumpmind.symmetric.console.ui.common.I;
import com.jumpmind.symmetric.console.ui.common.J;
import com.jumpmind.symmetric.console.ui.common.K;
import com.jumpmind.symmetric.console.ui.common.M;
import com.jumpmind.symmetric.console.ui.common.N;
import com.jumpmind.symmetric.console.ui.common.ap;
import com.jumpmind.symmetric.console.ui.common.as;
import com.jumpmind.symmetric.console.ui.graph.ChannelStatsGraph;
import com.jumpmind.symmetric.console.ui.graph.HostStatsGraph;
import com.jumpmind.symmetric.console.ui.graph.JobStatsGraph;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.H4;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.select.Select;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.selection.SelectionListener;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.ArrayUtils;
import org.jumpmind.symmetric.job.IJob;
import org.jumpmind.symmetric.job.IJobManager;
import org.jumpmind.symmetric.model.JobDefinition;
import org.jumpmind.symmetric.model.Lock;
import org.jumpmind.symmetric.service.IClusterService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.statistic.JobStats;
import org.jumpmind.symmetric.statistic.JobStatsByPeriodMap;
import org.jumpmind.vaadin.ui.common.ColumnVisibilityToggler;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;
import org.jumpmind.vaadin.ui.common.Label;
import org.jumpmind.vaadin.ui.common.ReadOnlyTextAreaDialog;
import org.jumpmind.vaadin.ui.common.ResizableDialog;

public class cD
extends ap
implements H,
J {
    private static final String b = "Stopped";
    private static final String c = "Running";
    private static final String d = "Paused";
    private static final String e = "Started";
    private static final long f = 1L;
    private Grid<IJob> g;
    private Span h;
    protected Span a;

    public cD(I controller) {
        super(controller, null, "These are background processes that perform various functions on a periodic schedule for this node.");
    }

    @Override
    public void init() {
        if (this.g == null) {
            this.a = new Span();
            this.content.add(new Component[]{this.a});
            HorizontalLayout buttonLayout = new HorizontalLayout();
            buttonLayout.setSpacing(true);
            Button refreshNow = as.createIconButton(K.REFRESH);
            refreshNow.addClickListener((ComponentEventListener & Serializable)event -> this.onRefresh(new Object[0]));
            buttonLayout.add(new Component[]{refreshNow});
            this.content.add(new Component[]{buttonLayout});
            Span separator = new Span();
            separator.setClassName("vrule");
            separator.setWidth(null);
            separator.setHeight("100%");
            buttonLayout.add(new Component[]{separator});
            this.g = new Grid();
            Button startButton = new Button(this.controller.getMessage("Start", new Object[0]));
            startButton.addClickListener((ComponentEventListener & Serializable)event -> {
                IClusterService clusterService = this.controller.getSymmetricEngine().getClusterService();
                IJob job = (IJob)this.g.getSelectedItems().iterator().next();
                clusterService.clearInfiniteLock(job.getName());
                job.start();
                String nodeId = this.controller.getSymmetricEngine().getNodeId();
                this.controller.getConsoleEventService().addEvent(new ConsoleEvent(this.controller.getConsoleUser().getUserId(), "Start Job", nodeId, nodeId, null, job.getName()));
                this.onRefresh(new Object[0]);
            });
            startButton.setEnabled(false);
            if (this.controller.getConsoleUser().hasPrivilegeRead("Start/Stop Jobs")) {
                buttonLayout.add(new Component[]{startButton});
            }
            Button stopButton = new Button(this.controller.getMessage("Stop", new Object[0]));
            stopButton.addClickListener((ComponentEventListener & Serializable)event -> {
                IClusterService clusterService = this.controller.getSymmetricEngine().getClusterService();
                IJob job = (IJob)this.g.getSelectedItems().iterator().next();
                Lock lock = (Lock)clusterService.findLocks().get(job.getName());
                if (lock != null && lock.isLockedByOther(clusterService.getServerId())) {
                    CommonUiUtils.notify((String)this.controller.getMessage("WARNING", new Object[0]), (String)this.controller.getMessage("Note that the job is running on %s.  It will run to completion and then the job will not start again until it is reenabled.", lock.getLockingServerId()));
                }
                job.stop();
                String nodeId = this.controller.getSymmetricEngine().getNodeId();
                this.controller.getConsoleEventService().addEvent(new ConsoleEvent(this.controller.getConsoleUser().getUserId(), "Stop Job", nodeId, nodeId, null, job.getName()));
                this.onRefresh(new Object[0]);
            });
            stopButton.setEnabled(false);
            if (this.controller.getConsoleUser().hasPrivilegeRead("Start/Stop Jobs")) {
                buttonLayout.add(new Component[]{stopButton});
            }
            Button runButton = new Button(this.controller.getMessage("Run Now", new Object[0]));
            runButton.addClickListener((ComponentEventListener & Serializable)event -> {
                String jobName = ((IJob)this.g.getSelectedItems().iterator().next()).getName();
                IJobManager jobManager = this.controller.getSymmetricEngine().getJobManager();
                IJob job = jobManager.getJob(jobName);
                if (!job.isRunning()) {
                    IClusterService clusterService = this.controller.getSymmetricEngine().getClusterService();
                    if (!clusterService.isLocked(jobName)) {
                        new N<Boolean>(String.format("Running %s...", jobName), new b(jobName), this.controller).show();
                        String nodeId = this.controller.getSymmetricEngine().getNodeId();
                        this.controller.getConsoleEventService().addEvent(new ConsoleEvent(this.controller.getConsoleUser().getUserId(), "Run Job Now", nodeId, nodeId, null, jobName));
                    } else {
                        Lock lock = (Lock)clusterService.findLocks().get(jobName);
                        if (lock != null) {
                            this.notification(this.controller.getMessage("The job was locked by the cluster service. The locking server id was: %s. The lock time was: %s", lock.getLockingServerId(), new SimpleDateFormat("yyyy-MM-dd hh:mm:ss aaa").format(lock.getLockTime())), new Object[0]);
                        } else {
                            this.notification(this.controller.getMessage("The job was locked by the cluster service but lock details were not found. Perhaps the lock was released in the meantime.", new Object[0]), new Object[0]);
                        }
                    }
                } else {
                    this.notification("Cannot invoke the job.  It is already running.", new Object[0]);
                }
            });
            runButton.setEnabled(false);
            if (this.controller.getConsoleUser().hasPrivilegeRead("Run Jobs")) {
                buttonLayout.add(new Component[]{runButton});
            }
            buttonLayout.addAndExpand(new Component[]{new Span()});
            ColumnVisibilityToggler columnVisibilityToggler = new ColumnVisibilityToggler();
            buttonLayout.add(new Component[]{columnVisibilityToggler});
            this.g.addSelectionListener((SelectionListener & Serializable)event -> {
                if (!this.g.getSelectedItems().isEmpty()) {
                    IJob job = (IJob)this.g.getSelectedItems().iterator().next();
                    if (job.isStarted()) {
                        if (this.controller.getConsoleUser().hasPrivilegeWrite("Start/Stop Jobs")) {
                            startButton.setEnabled(false);
                            stopButton.setEnabled(true);
                            stopButton.getElement().removeAttribute("title");
                            startButton.getElement().removeAttribute("title");
                        } else {
                            startButton.setEnabled(false);
                            stopButton.setEnabled(false);
                            stopButton.getElement().setAttribute("title", String.format("Your role '%s' does not have the privileges needed for this action.", this.controller.getConsoleUser().getRole()));
                            startButton.getElement().setAttribute("title", String.format("Your role '%s' does not have the privileges needed for this action.", this.controller.getConsoleUser().getRole()));
                        }
                    } else if (this.controller.getConsoleUser().hasPrivilegeWrite("Start/Stop Jobs")) {
                        startButton.setEnabled(true);
                        stopButton.setEnabled(false);
                        stopButton.getElement().removeAttribute("title");
                        startButton.getElement().removeAttribute("title");
                    } else {
                        startButton.setEnabled(false);
                        stopButton.setEnabled(false);
                        stopButton.getElement().setAttribute("title", String.format("Your role '%s' does not have the privileges needed for this action.", this.controller.getConsoleUser().getRole()));
                        startButton.getElement().setAttribute("title", String.format("Your role '%s' does not have the privileges needed for this action.", this.controller.getConsoleUser().getRole()));
                    }
                    if (job.isRunning()) {
                        runButton.setEnabled(false);
                    } else if (this.controller.getConsoleUser().hasPrivilegeWrite("Run Jobs")) {
                        runButton.setEnabled(true);
                        runButton.getElement().removeAttribute("title");
                    } else {
                        runButton.setEnabled(false);
                        runButton.getElement().setAttribute("title", String.format("Your role '%s' does not have the privileges needed for this action.", this.controller.getConsoleUser().getRole()));
                    }
                } else {
                    startButton.setEnabled(false);
                    stopButton.setEnabled(false);
                    runButton.setEnabled(false);
                }
            });
            this.g.addItemClickListener((ComponentEventListener & Serializable)event -> {
                if (event != null && event.getItem() != null && event.getColumn() != null && "history".equals(event.getColumn().getKey()) && this.a((IJob)event.getItem())) {
                    new a((IJob)event.getItem()).open();
                }
            });
            Map locks = this.controller.getSymmetricEngine().getClusterService().findLocks();
            columnVisibilityToggler.addColumn(this.g.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)job -> {
                Label jobNameLabel = new Label(job.getName());
                VaadinIcon icon = job.getJobDefinition().getJobType() == JobDefinition.JobType.BUILT_IN ? VaadinIcon.COG : VaadinIcon.FILE_TEXT;
                jobNameLabel.setLeftIcon(icon);
                return jobNameLabel;
            })).setHeader(this.controller.getMessage("Job Name", new Object[0])).setComparator((ValueProvider & Serializable)job -> job.getName()).setSortable(true).setFlexGrow(2), this.controller.getMessage("Job Name", new Object[0]));
            columnVisibilityToggler.addColumn(this.g.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)job -> {
                if (this.a((IJob)job)) {
                    Icon icon = new Icon(VaadinIcon.BAR_CHART);
                    icon.setColor("#1676F3");
                    icon.setClassName("mouse_pointer");
                    return icon;
                }
                return new Span();
            })).setKey("history").setHeader(this.controller.getMessage("History", new Object[0])).setPartNameGenerator((SerializableFunction & Serializable)cell -> "align-center").setWidth("40px"), this.controller.getMessage("History", new Object[0]));
            columnVisibilityToggler.addColumn(this.g.addColumn((ValueProvider & Serializable)job -> job.getJobDefinition().getDescription()).setHeader(this.controller.getMessage("Description", new Object[0])), this.controller.getMessage("Description", new Object[0])).setFlexGrow(3);
            columnVisibilityToggler.addColumn(this.g.addColumn((ValueProvider & Serializable)job -> job.getSchedule()).setHeader(this.controller.getMessage("Schedule", new Object[0])), this.controller.getMessage("Schedule", new Object[0]));
            columnVisibilityToggler.addColumn(this.g.addColumn((ValueProvider & Serializable)job -> {
                Lock lock = (Lock)locks.get(job.getName());
                return this.controller.getMessage(this.c((IJob)job, lock), new Object[0]);
            }).setHeader(this.controller.getMessage("Status", new Object[0])).setSortable(true), this.controller.getMessage("Status", new Object[0]));
            columnVisibilityToggler.addColumn(this.g.addColumn((ValueProvider & Serializable)job -> {
                Lock lock = (Lock)locks.get(job.getName());
                return lock != null ? lock.getLockingServerId() : "";
            }).setHeader(this.controller.getMessage("Server Id", new Object[0])), this.controller.getMessage("Server Id", new Object[0])).setVisible(false);
            columnVisibilityToggler.addColumn(this.g.addColumn((ValueProvider & Serializable)job -> this.controller.getSymmetricEngine().getClusterService().getServerId()).setHeader(this.controller.getMessage("Last Server Id", new Object[0])), this.controller.getMessage("Last Server Id", new Object[0])).setVisible(false);
            columnVisibilityToggler.addColumn(this.g.addColumn((ValueProvider & Serializable)job -> {
                Long lastRun;
                Lock lock = (Lock)locks.get(job.getName());
                Long l2 = lastRun = this.a((IJob)job, lock) != null ? Long.valueOf(job.getLastExecutionTimeInMs()) : null;
                if (lastRun != null) {
                    return CommonUiUtils.formatDuration((long)lastRun);
                }
                return null;
            }).setHeader(this.controller.getMessage("Last Run", new Object[0])).setWidth("80px"), this.controller.getMessage("Last Run", new Object[0]));
            columnVisibilityToggler.addColumn(this.g.addColumn((ValueProvider & Serializable)job -> {
                Long avgRun;
                Lock lock = (Lock)locks.get(job.getName());
                Long l2 = avgRun = this.a((IJob)job, lock) != null ? Long.valueOf(job.getAverageExecutionTimeInMs()) : null;
                if (avgRun != null) {
                    return CommonUiUtils.formatDuration((long)avgRun);
                }
                return null;
            }).setHeader(this.controller.getMessage("Avg. Run", new Object[0])).setWidth("80px"), this.controller.getMessage("Avg. Run", new Object[0]));
            columnVisibilityToggler.addColumn(this.g.addColumn((ValueProvider & Serializable)job -> {
                Lock lock = (Lock)locks.get(job.getName());
                return this.a((IJob)job, lock);
            }).setComparator((ValueProvider & Serializable)job -> job.getLastFinishTime()).setHeader(this.controller.getMessage("Last Finish Time", new Object[0])), this.controller.getMessage("Last Finish Time", new Object[0]));
            columnVisibilityToggler.addColumn(this.g.addColumn((ValueProvider & Serializable)job -> {
                Lock lock = (Lock)locks.get(job.getName());
                return this.b((IJob)job, lock);
            }).setComparator((ValueProvider & Serializable)job -> job.getNextExecutionTime()).setHeader(this.controller.getMessage("Next Run Time", new Object[0])), this.controller.getMessage("Next Run Time", new Object[0]));
            for (Grid.Column column : this.g.getColumns()) {
                column.setResizable(true);
            }
            this.g.setColumnReorderingAllowed(true);
            this.g.setSizeFull();
            this.g.setItems((Collection)this.controller.getSymmetricEngine().getJobManager().getJobs());
            this.content.addAndExpand(new Component[]{this.g});
            HorizontalLayout hlayout = new HorizontalLayout();
            this.content.add(new Component[]{hlayout});
            Button selectNoneLink = as.createLinkButton(this.controller.getMessage("Select None", new Object[0]));
            hlayout.add(new Component[]{selectNoneLink});
            selectNoneLink.addClickListener((ComponentEventListener & Serializable)event -> this.g.deselectAll());
            hlayout.addAndExpand(new Component[]{new Span()});
            hlayout.setWidth("99%");
            this.h = new Span();
            this.h.setSizeUndefined();
            hlayout.add(new Component[]{this.h});
        }
    }

    @Override
    public String getTitleKey() {
        return "Manage Jobs";
    }

    @Override
    public void onRefresh(Object ... params) {
        IClusterService clusterService = this.controller.getSymmetricEngine().getClusterService();
        INodeService nodeService = this.controller.getSymmetricEngine().getNodeService();
        if (clusterService.isClusteringEnabled()) {
            this.a.setText(this.controller.getMessage("Clustering is enabled and there are %d instances in the cluster.", nodeService.findNodeHosts(nodeService.findIdentityNodeId()).size()));
        } else {
            this.a.setText(this.controller.getMessage("Clustering is not enabled.", new Object[0]));
        }
        Set selectedItems = this.g.getSelectedItems();
        this.g.setItems((Collection)this.controller.getSymmetricEngine().getJobManager().getJobs());
        if (!selectedItems.isEmpty()) {
            this.g.select((Object)((IJob)selectedItems.iterator().next()));
        }
        this.h.setText(this.controller.getMessage("Rows Returned", new Object[0]) + ": " + this.g.getDataProvider().size(new Query()));
    }

    protected boolean a(IJob job) {
        String jobName = job.getName();
        return jobName.equals("Routing") || jobName.equals("Push") || jobName.equals("Pull") || jobName.equals("Purge Outgoing") || jobName.equals("Purge Incoming") || jobName.equals("SyncTriggers") || jobName.equals("Watchdog") || jobName.equals("Initial Load Queue") || jobName.equals("File Sync Pull") || jobName.equals("File Sync Push");
    }

    protected String a(IJob job, Lock lock) {
        if (lock != null && lock.getLastLockTime() != null) {
            return as.formatDate(this.controller, lock.getLastLockTime(), true);
        }
        return job.getLastFinishTime() == null ? null : as.formatDate(this.controller, job.getLastFinishTime(), true);
    }

    protected String b(IJob job, Lock lock) {
        Date nextExecutionTime;
        if (job.isStarted() && (nextExecutionTime = job.getNextExecutionTime()) != null) {
            return as.formatDate(this.controller, nextExecutionTime, true);
        }
        return null;
    }

    protected String c(IJob job, Lock lock) {
        String status;
        String string = job.isRunning() ? c : (job.isPaused() ? d : (status = job.isStarted() ? e : b));
        if (lock != null) {
            if (lock.isStopped()) {
                status = b;
            } else if (lock.getLockTime() != null) {
                status = c;
            }
        }
        return status;
    }

    @Override
    public boolean onExit(Runnable exitClosure) {
        return true;
    }

    @Override
    public String getDocAnchor() {
        return "/doc/html/user-guide.html#_jobs";
    }

    private static /* synthetic */ Object a(SerializedLambda lambda) {
        switch (lambda.getImplMethodName()) {
            case "lambda$init$9b1b5227$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/JobManagePanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                return (ComponentEventListener & Serializable)event -> this.onRefresh(new Object[0]);
            }
            case "lambda$init$9b1b5227$2": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/JobManagePanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                return (ComponentEventListener & Serializable)event -> {
                    IClusterService clusterService = this.controller.getSymmetricEngine().getClusterService();
                    IJob job = (IJob)this.g.getSelectedItems().iterator().next();
                    clusterService.clearInfiniteLock(job.getName());
                    job.start();
                    String nodeId = this.controller.getSymmetricEngine().getNodeId();
                    this.controller.getConsoleEventService().addEvent(new ConsoleEvent(this.controller.getConsoleUser().getUserId(), "Start Job", nodeId, nodeId, null, job.getName()));
                    this.onRefresh(new Object[0]);
                };
            }
            case "lambda$init$48eeb0a6$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/JobManagePanel") || !lambda.getImplMethodSignature().equals("(Ljava/util/Map;Lorg/jumpmind/symmetric/job/IJob;)Ljava/lang/Object;")) break;
                return arg_0 -> ((cD)lambda.getCapturedArg(0)).f((Map)lambda.getCapturedArg(1), arg_0);
            }
            case "lambda$init$9b1b5227$3": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/JobManagePanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                return (ComponentEventListener & Serializable)event -> {
                    IClusterService clusterService = this.controller.getSymmetricEngine().getClusterService();
                    IJob job = (IJob)this.g.getSelectedItems().iterator().next();
                    Lock lock = (Lock)clusterService.findLocks().get(job.getName());
                    if (lock != null && lock.isLockedByOther(clusterService.getServerId())) {
                        CommonUiUtils.notify((String)this.controller.getMessage("WARNING", new Object[0]), (String)this.controller.getMessage("Note that the job is running on %s.  It will run to completion and then the job will not start again until it is reenabled.", lock.getLockingServerId()));
                    }
                    job.stop();
                    String nodeId = this.controller.getSymmetricEngine().getNodeId();
                    this.controller.getConsoleEventService().addEvent(new ConsoleEvent(this.controller.getConsoleUser().getUserId(), "Stop Job", nodeId, nodeId, null, job.getName()));
                    this.onRefresh(new Object[0]);
                };
            }
            case "lambda$init$ba6e7b7d$2": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/JobManagePanel") || !lambda.getImplMethodSignature().equals("(Lorg/jumpmind/symmetric/job/IJob;)Ljava/lang/Object;")) break;
                return (ValueProvider & Serializable)job -> job.getJobDefinition().getDescription();
            }
            case "lambda$init$9b1b5227$4": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/JobManagePanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                return (ComponentEventListener & Serializable)event -> {
                    String jobName = ((IJob)this.g.getSelectedItems().iterator().next()).getName();
                    IJobManager jobManager = this.controller.getSymmetricEngine().getJobManager();
                    IJob job = jobManager.getJob(jobName);
                    if (!job.isRunning()) {
                        IClusterService clusterService = this.controller.getSymmetricEngine().getClusterService();
                        if (!clusterService.isLocked(jobName)) {
                            new N<Boolean>(String.format("Running %s...", jobName), new b(jobName), this.controller).show();
                            String nodeId = this.controller.getSymmetricEngine().getNodeId();
                            this.controller.getConsoleEventService().addEvent(new ConsoleEvent(this.controller.getConsoleUser().getUserId(), "Run Job Now", nodeId, nodeId, null, jobName));
                        } else {
                            Lock lock = (Lock)clusterService.findLocks().get(jobName);
                            if (lock != null) {
                                this.notification(this.controller.getMessage("The job was locked by the cluster service. The locking server id was: %s. The lock time was: %s", lock.getLockingServerId(), new SimpleDateFormat("yyyy-MM-dd hh:mm:ss aaa").format(lock.getLockTime())), new Object[0]);
                            } else {
                                this.notification(this.controller.getMessage("The job was locked by the cluster service but lock details were not found. Perhaps the lock was released in the meantime.", new Object[0]), new Object[0]);
                            }
                        }
                    } else {
                        this.notification("Cannot invoke the job.  It is already running.", new Object[0]);
                    }
                };
            }
            case "lambda$init$ba6e7b7d$1": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/JobManagePanel") || !lambda.getImplMethodSignature().equals("(Lorg/jumpmind/symmetric/job/IJob;)Ljava/lang/String;")) break;
                return (ValueProvider & Serializable)job -> job.getName();
            }
            case "lambda$init$9b1b5227$5": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/JobManagePanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/grid/ItemClickEvent;)V")) break;
                return (ComponentEventListener & Serializable)event -> {
                    if (event != null && event.getItem() != null && event.getColumn() != null && "history".equals(event.getColumn().getKey()) && this.a((IJob)event.getItem())) {
                        new a((IJob)event.getItem()).open();
                    }
                };
            }
            case "lambda$init$ba6e7b7d$4": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/JobManagePanel") || !lambda.getImplMethodSignature().equals("(Lorg/jumpmind/symmetric/job/IJob;)Ljava/lang/Object;")) break;
                return (ValueProvider & Serializable)job -> this.controller.getSymmetricEngine().getClusterService().getServerId();
            }
            case "lambda$init$48eeb0a6$4": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/JobManagePanel") || !lambda.getImplMethodSignature().equals("(Ljava/util/Map;Lorg/jumpmind/symmetric/job/IJob;)Ljava/lang/Object;")) break;
                return arg_0 -> ((cD)lambda.getCapturedArg(0)).c((Map)lambda.getCapturedArg(1), arg_0);
            }
            case "lambda$init$ba6e7b7d$3": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/JobManagePanel") || !lambda.getImplMethodSignature().equals("(Lorg/jumpmind/symmetric/job/IJob;)Ljava/lang/Object;")) break;
                return (ValueProvider & Serializable)job -> job.getSchedule();
            }
            case "lambda$init$48eeb0a6$5": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/JobManagePanel") || !lambda.getImplMethodSignature().equals("(Ljava/util/Map;Lorg/jumpmind/symmetric/job/IJob;)Ljava/lang/Object;")) break;
                return arg_0 -> ((cD)lambda.getCapturedArg(0)).b((Map)lambda.getCapturedArg(1), arg_0);
            }
            case "lambda$init$9b1b5227$6": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/JobManagePanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                return (ComponentEventListener & Serializable)event -> this.g.deselectAll();
            }
            case "lambda$init$48eeb0a6$2": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/JobManagePanel") || !lambda.getImplMethodSignature().equals("(Ljava/util/Map;Lorg/jumpmind/symmetric/job/IJob;)Ljava/lang/Object;")) break;
                return arg_0 -> cD.e((Map)lambda.getCapturedArg(0), arg_0);
            }
            case "lambda$init$ba6e7b7d$6": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/JobManagePanel") || !lambda.getImplMethodSignature().equals("(Lorg/jumpmind/symmetric/job/IJob;)Ljava/util/Date;")) break;
                return (ValueProvider & Serializable)job -> job.getNextExecutionTime();
            }
            case "lambda$init$48eeb0a6$3": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/JobManagePanel") || !lambda.getImplMethodSignature().equals("(Ljava/util/Map;Lorg/jumpmind/symmetric/job/IJob;)Ljava/lang/Object;")) break;
                return arg_0 -> ((cD)lambda.getCapturedArg(0)).d((Map)lambda.getCapturedArg(1), arg_0);
            }
            case "lambda$init$ba6e7b7d$5": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/JobManagePanel") || !lambda.getImplMethodSignature().equals("(Lorg/jumpmind/symmetric/job/IJob;)Ljava/util/Date;")) break;
                return (ValueProvider & Serializable)job -> job.getLastFinishTime();
            }
            case "lambda$init$3fed5817$1": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/SerializableFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/JobManagePanel") || !lambda.getImplMethodSignature().equals("(Lorg/jumpmind/symmetric/job/IJob;)Lcom/vaadin/flow/component/html/Span;")) break;
                return (SerializableFunction & Serializable)job -> {
                    Label jobNameLabel = new Label(job.getName());
                    VaadinIcon icon = job.getJobDefinition().getJobType() == JobDefinition.JobType.BUILT_IN ? VaadinIcon.COG : VaadinIcon.FILE_TEXT;
                    jobNameLabel.setLeftIcon(icon);
                    return jobNameLabel;
                };
            }
            case "lambda$init$3740441d$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/data/selection/SelectionListener") || !lambda.getFunctionalInterfaceMethodName().equals("selectionChange") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/data/selection/SelectionEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/JobManagePanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/button/Button;Lcom/vaadin/flow/component/button/Button;Lcom/vaadin/flow/component/button/Button;Lcom/vaadin/flow/data/selection/SelectionEvent;)V")) break;
                return arg_0 -> ((cD)lambda.getCapturedArg(0)).a((Button)lambda.getCapturedArg(1), (Button)lambda.getCapturedArg(2), (Button)lambda.getCapturedArg(3), arg_0);
            }
            case "lambda$init$3fed5817$3": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/SerializableFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/JobManagePanel") || !lambda.getImplMethodSignature().equals("(Lorg/jumpmind/symmetric/job/IJob;)Ljava/lang/String;")) break;
                return (SerializableFunction & Serializable)cell -> "align-center";
            }
            case "lambda$init$3fed5817$2": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/SerializableFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/JobManagePanel") || !lambda.getImplMethodSignature().equals("(Lorg/jumpmind/symmetric/job/IJob;)Lcom/vaadin/flow/component/Component;")) break;
                return (SerializableFunction & Serializable)job -> {
                    if (this.a((IJob)job)) {
                        Icon icon = new Icon(VaadinIcon.BAR_CHART);
                        icon.setColor("#1676F3");
                        icon.setClassName("mouse_pointer");
                        return icon;
                    }
                    return new Span();
                };
            }
            case "lambda$init$48eeb0a6$6": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/JobManagePanel") || !lambda.getImplMethodSignature().equals("(Ljava/util/Map;Lorg/jumpmind/symmetric/job/IJob;)Ljava/lang/Object;")) break;
                return arg_0 -> ((cD)lambda.getCapturedArg(0)).a((Map)lambda.getCapturedArg(1), arg_0);
            }
        }
        throw new IllegalArgumentException("Invalid lambda deserialization");
    }

    class a
    extends ResizableDialog {
        private static final long b = 1L;
        private String c;
        private Select<String> d;
        private Grid<JobStats> e;
        private List<JobStats> f;
        private H4 g;
        private Select<String> h;
        private Div i;
        private ChannelStatsGraph j;
        private JobStatsGraph k;
        private HostStatsGraph l;

        public a(IJob job) {
            super(cD.this.controller.getMessage("History for %s Job", job.getName()), true, true);
            this.c = job.getName();
            this.setWidth("90%");
            this.setHeight("90%");
            this.innerContent.getStyle().set("margin-top", "0");
            VerticalLayout layout = new VerticalLayout();
            layout.getStyle().set("padding", "0");
            H4 jobRunsHeader = new H4(cD.this.controller.getMessage("Job Runs", new Object[0]));
            jobRunsHeader.getStyle().set("margin-bottom", "0");
            ArrayList<String> periodList = new ArrayList<String>();
            periodList.add(cD.this.controller.getMessage("last 24 hours", new Object[0]));
            periodList.add(cD.this.controller.getMessage("last 7 days", new Object[0]));
            periodList.add(cD.this.controller.getMessage("last 30 days", new Object[0]));
            this.d = new Select();
            this.d.setItems(periodList);
            this.d.setValue((Object)cD.this.controller.getMessage("last 7 days", new Object[0]));
            this.d.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.a());
            HorizontalLayout jobRunsLayout = new HorizontalLayout(new Component[]{jobRunsHeader, this.d});
            jobRunsLayout.setDefaultVerticalComponentAlignment(FlexComponent.Alignment.CENTER);
            this.e = new Grid();
            this.e.setSelectionMode(Grid.SelectionMode.NONE);
            this.e.setHeight("200px");
            this.e.getElement().getStyle().set("min-height", "200px");
            this.e.addColumn((ValueProvider & Serializable)stats -> stats.getNodeId()).setHeader(cD.this.controller.getMessage("Node Id", new Object[0]));
            if (this.c.equals("Initial Load Queue") || this.c.equals("Initial Load Extract")) {
                this.e.addColumn((ValueProvider & Serializable)stats -> stats.getTargetNodeId()).setHeader(cD.this.controller.getMessage("Target Node ID", new Object[0]));
                this.e.addColumn((ValueProvider & Serializable)stats -> stats.getTargetNodeCount()).setHeader(cD.this.controller.getMessage("Target Node Count", new Object[0]));
            }
            if (cD.this.controller.getSymmetricEngine().getClusterService().isClusteringEnabled()) {
                this.e.addColumn((ValueProvider & Serializable)stats -> stats.getHostName()).setHeader(cD.this.controller.getMessage("Host Name", new Object[0]));
            }
            this.e.addColumn((ValueProvider & Serializable)stats -> as.formatDate(cD.this.controller, stats.getStartTime(), true)).setHeader(cD.this.controller.getMessage("Start Time", new Object[0]));
            this.e.addColumn((ValueProvider & Serializable)stats -> as.formatDate(cD.this.controller, stats.getEndTime(), true)).setHeader(cD.this.controller.getMessage("End Time", new Object[0]));
            this.e.addColumn((ValueProvider & Serializable)stats -> as.formatDuration(stats.getEndTime().getTime() - stats.getStartTime().getTime())).setHeader(cD.this.controller.getMessage("Duration", new Object[0]));
            this.e.addColumn((ValueProvider & Serializable)stats -> stats.getProcessedCount()).setHeader(cD.this.controller.getMessage("Processed Count", new Object[0]));
            this.e.addColumn((ValueProvider & Serializable)stats -> stats.isErrorFlag() ? "1" : "0").setHeader(cD.this.controller.getMessage("Error Flag", new Object[0]));
            this.e.addComponentColumn((ValueProvider & Serializable)stats -> {
                String message = stats.getErrorMessage();
                if (message != null) {
                    Button showButton = new Button(cD.this.controller.getMessage("Show", new Object[0]), (ComponentEventListener & Serializable)event -> {
                        ReadOnlyTextAreaDialog dialog = new ReadOnlyTextAreaDialog(cD.this.controller.getMessage("Error Message", new Object[0]), message, false, open -> this.enableEscapeShortcut(open == false));
                        dialog.setWidth("80%");
                        dialog.setHeight("80%");
                        dialog.open();
                    });
                    showButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_SMALL});
                    return showButton;
                }
                return new Span();
            }).setHeader(cD.this.controller.getMessage("Error Message", new Object[0]));
            for (Grid.Column column : this.e.getColumns()) {
                ((Grid.Column)column.setResizable(true)).setAutoWidth(true);
            }
            this.g = new H4();
            if (this.c.equals("Routing") || this.c.equals("Purge Outgoing") || this.c.equals("Purge Incoming") || this.c.equals("SyncTriggers")) {
                this.g.setText(cD.this.controller.getMessage("History is unavailable for the %s job during the selected time.", this.c));
            } else {
                this.g.setText(cD.this.controller.getMessage("The %s job does not record history for individual runs.", this.c));
            }
            this.g.setVisible(false);
            H4 jobStatsHeader = new H4(cD.this.controller.getMessage("Job Statistics", new Object[0]));
            jobStatsHeader.getStyle().set("margin-bottom", "0");
            ArrayList<String> dataTypeList = new ArrayList<String>();
            dataTypeList.add(cD.this.controller.getMessage("Processed Count", new Object[0]));
            switch (this.c) {
                case "Routing": {
                    dataTypeList.add(0, cD.this.controller.getMessage("Routed Rows", new Object[0]));
                    dataTypeList.add(1, cD.this.controller.getMessage("Unrouted Rows", new Object[0]));
                    dataTypeList.add(2, cD.this.controller.getMessage("Data Event Rows Inserted", new Object[0]));
                    break;
                }
                case "Push": {
                    dataTypeList.add(0, cD.this.controller.getMessage("Sent Rows", new Object[0]));
                    dataTypeList.add(1, cD.this.controller.getMessage("Sent Bytes ", new Object[0]));
                    dataTypeList.add(2, cD.this.controller.getMessage("Sent Errors", new Object[0]));
                    dataTypeList.add(3, cD.this.controller.getMessage("Total Nodes Push Time", new Object[0]));
                    dataTypeList.add(4, cD.this.controller.getMessage("Nodes Pushed", new Object[0]));
                    break;
                }
                case "Pull": {
                    dataTypeList.add(0, cD.this.controller.getMessage("Loaded Rows", new Object[0]));
                    dataTypeList.add(1, cD.this.controller.getMessage("Loaded Bytes ", new Object[0]));
                    dataTypeList.add(2, cD.this.controller.getMessage("Loaded Errors", new Object[0]));
                    dataTypeList.add(3, cD.this.controller.getMessage("Total Nodes Pull Time", new Object[0]));
                    dataTypeList.add(4, cD.this.controller.getMessage("Nodes Pulled", new Object[0]));
                    break;
                }
                case "Purge Outgoing": {
                    dataTypeList.add(0, cD.this.controller.getMessage("Outgoing Batch Rows Purged", new Object[0]));
                    break;
                }
                case "Purge Incoming": {
                    dataTypeList.add(0, cD.this.controller.getMessage("Incoming Batch Rows Purged", new Object[0]));
                    break;
                }
                case "SyncTriggers": {
                    dataTypeList.add(0, cD.this.controller.getMessage("Table Capture Created", new Object[0]));
                    dataTypeList.add(1, cD.this.controller.getMessage("Table Capture Rebuilt", new Object[0]));
                    dataTypeList.add(2, cD.this.controller.getMessage("Table Capture Removed", new Object[0]));
                    break;
                }
                case "Watchdog": {
                    dataTypeList.add(0, cD.this.controller.getMessage("Nodes Disabled", new Object[0]));
                    break;
                }
                case "Stage Management": {
                    dataTypeList.add(0, cD.this.controller.getMessage("Purged Data Rows", new Object[0]));
                    dataTypeList.add(1, cD.this.controller.getMessage("Purged Data Event Rows", new Object[0]));
                    break;
                }
                case "Initial Load Queue": {
                    dataTypeList.add(0, cD.this.controller.getMessage("Nodes Loaded", new Object[0]));
                    break;
                }
                case "File Sync Pull": {
                    dataTypeList.add(0, cD.this.controller.getMessage("Loaded Rows", new Object[0]));
                    dataTypeList.add(1, cD.this.controller.getMessage("Loaded Bytes ", new Object[0]));
                    dataTypeList.add(2, cD.this.controller.getMessage("Loaded Errors", new Object[0]));
                    break;
                }
                case "File Sync Push": {
                    dataTypeList.add(0, cD.this.controller.getMessage("Sent Rows", new Object[0]));
                    dataTypeList.add(1, cD.this.controller.getMessage("Sent Bytes ", new Object[0]));
                    dataTypeList.add(2, cD.this.controller.getMessage("Sent Errors", new Object[0]));
                }
            }
            if (dataTypeList.size() > 1) {
                this.h = new Select();
                this.h.setWidth("18em");
                this.h.setItems(dataTypeList);
                this.h.setValue((Object)((String)dataTypeList.get(0)));
                this.h.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.b());
            }
            this.i = new Div();
            this.i.setSizeFull();
            layout.add(new Component[]{jobRunsLayout, this.e, this.g});
            layout.setHorizontalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{this.g});
            if (this.h != null) {
                HorizontalLayout jobStatsLayout = new HorizontalLayout(new Component[]{jobStatsHeader, this.h});
                jobStatsLayout.setDefaultVerticalComponentAlignment(FlexComponent.Alignment.CENTER);
                layout.add(new Component[]{jobStatsLayout});
            } else {
                layout.add(new Component[]{jobStatsHeader});
            }
            layout.add(new Component[]{this.i});
            layout.setSizeFull();
            this.a();
            this.add((Component)layout);
        }

        private void a() {
            List allStatsList = cD.this.controller.getSymmetricEngine().getStatisticService().getJobStatsForPeriod(this.c(), new Date(), cD.this.controller.getSymmetricEngine().getNodeId());
            this.f = new ArrayList<JobStats>();
            for (JobStats stats : allStatsList) {
                if (!stats.getJobName().equals(this.c)) continue;
                this.f.add(stats);
            }
            this.e.setItems(this.f);
            this.e.setVisible(!this.f.isEmpty());
            this.g.setVisible(this.f.isEmpty());
            this.b();
        }

        private void b() {
            this.i.removeAll();
            int periodInMinutes = 1440;
            if (((String)this.d.getValue()).equals(cD.this.controller.getMessage("last 7 days", new Object[0]))) {
                periodInMinutes = 10080;
            } else if (((String)this.d.getValue()).equals(cD.this.controller.getMessage("last 30 days", new Object[0]))) {
                periodInMinutes = 43200;
            }
            String dataType = this.h != null ? (String)this.h.getValue() : cD.this.controller.getMessage("Processed Count", new Object[0]);
            int interval = periodInMinutes / 120 * 5;
            if (ArrayUtils.contains((Object[])ChannelStatsGraph.getDataTypes(), (Object)dataType)) {
                if (this.j == null) {
                    this.j = new ChannelStatsGraph(cD.this.controller);
                    this.j.setSizeFull();
                    this.j.setFileSyncOnly(this.c.equals("File Sync Pull") || this.c.equals("File Sync Push"));
                }
                this.j.setDataTypeToDisplay(dataType);
                this.j.setPeriodsInMinutes(periodInMinutes);
                TreeMap channelStatsForPeriod = cD.this.controller.getSymmetricEngine().getStatisticService().getChannelStatsForPeriod(this.c(), new Date(), cD.this.controller.getSymmetricEngine().getNodeId(), interval > 0 ? interval : 5);
                this.j.refresh(channelStatsForPeriod, true);
                this.i.add(new Component[]{this.j});
            } else if (dataType.equals(cD.this.controller.getMessage("Processed Count", new Object[0]))) {
                if (this.k == null) {
                    this.k = new JobStatsGraph(cD.this.controller, this.c);
                }
                this.k.setPeriodsInMinutes(periodInMinutes);
                this.k.refresh(new JobStatsByPeriodMap(this.c(), new Date(), this.f, interval > 0 ? interval : 5));
                this.i.add(new Component[]{this.k});
            } else {
                if (this.l == null) {
                    this.l = new HostStatsGraph(cD.this.controller);
                }
                this.l.setDataTypeToDisplay(dataType);
                this.l.setPeriodsInMinutes(periodInMinutes);
                TreeMap jobStatsForPeriod = cD.this.controller.getSymmetricEngine().getStatisticService().getHostStatsForPeriod(this.c(), new Date(), cD.this.controller.getSymmetricEngine().getNodeId(), interval > 0 ? interval : 5);
                this.l.refresh(jobStatsForPeriod);
                this.i.add(new Component[]{this.l});
            }
        }

        private Date c() {
            Calendar calendar = Calendar.getInstance();
            if (((String)this.d.getValue()).equals(cD.this.controller.getMessage("last 24 hours", new Object[0]))) {
                calendar.add(6, -1);
            } else if (((String)this.d.getValue()).equals(cD.this.controller.getMessage("last 7 days", new Object[0]))) {
                calendar.add(6, -7);
            } else if (((String)this.d.getValue()).equals(cD.this.controller.getMessage("last 30 days", new Object[0]))) {
                calendar.add(6, -30);
            }
            return calendar.getTime();
        }

        private static /* synthetic */ Object a(SerializedLambda lambda) {
            switch (lambda.getImplMethodName()) {
                case "lambda$new$329004d2$1": {
                    if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/JobManagePanel$JobHistoryDialog") || !lambda.getImplMethodSignature().equals("(Lorg/jumpmind/symmetric/statistic/JobStats;)Ljava/lang/Object;")) break;
                    return (ValueProvider & Serializable)stats -> stats.getNodeId();
                }
                case "lambda$new$329004d2$2": {
                    if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/JobManagePanel$JobHistoryDialog") || !lambda.getImplMethodSignature().equals("(Lorg/jumpmind/symmetric/statistic/JobStats;)Ljava/lang/Object;")) break;
                    return (ValueProvider & Serializable)stats -> stats.getTargetNodeId();
                }
                case "lambda$new$329004d2$7": {
                    if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/JobManagePanel$JobHistoryDialog") || !lambda.getImplMethodSignature().equals("(Lorg/jumpmind/symmetric/statistic/JobStats;)Ljava/lang/Object;")) break;
                    return (ValueProvider & Serializable)stats -> as.formatDuration(stats.getEndTime().getTime() - stats.getStartTime().getTime());
                }
                case "lambda$new$329004d2$8": {
                    if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/JobManagePanel$JobHistoryDialog") || !lambda.getImplMethodSignature().equals("(Lorg/jumpmind/symmetric/statistic/JobStats;)Ljava/lang/Object;")) break;
                    return (ValueProvider & Serializable)stats -> stats.getProcessedCount();
                }
                case "lambda$new$329004d2$9": {
                    if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/JobManagePanel$JobHistoryDialog") || !lambda.getImplMethodSignature().equals("(Lorg/jumpmind/symmetric/statistic/JobStats;)Ljava/lang/Object;")) break;
                    return (ValueProvider & Serializable)stats -> stats.isErrorFlag() ? "1" : "0";
                }
                case "lambda$new$329004d2$3": {
                    if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/JobManagePanel$JobHistoryDialog") || !lambda.getImplMethodSignature().equals("(Lorg/jumpmind/symmetric/statistic/JobStats;)Ljava/lang/Object;")) break;
                    return (ValueProvider & Serializable)stats -> stats.getTargetNodeCount();
                }
                case "lambda$new$329004d2$4": {
                    if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/JobManagePanel$JobHistoryDialog") || !lambda.getImplMethodSignature().equals("(Lorg/jumpmind/symmetric/statistic/JobStats;)Ljava/lang/Object;")) break;
                    return (ValueProvider & Serializable)stats -> stats.getHostName();
                }
                case "lambda$new$329004d2$5": {
                    if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/JobManagePanel$JobHistoryDialog") || !lambda.getImplMethodSignature().equals("(Lorg/jumpmind/symmetric/statistic/JobStats;)Ljava/lang/Object;")) break;
                    return (ValueProvider & Serializable)stats -> as.formatDate(cD.this.controller, stats.getStartTime(), true);
                }
                case "lambda$new$329004d2$6": {
                    if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/JobManagePanel$JobHistoryDialog") || !lambda.getImplMethodSignature().equals("(Lorg/jumpmind/symmetric/statistic/JobStats;)Ljava/lang/Object;")) break;
                    return (ValueProvider & Serializable)stats -> as.formatDate(cD.this.controller, stats.getEndTime(), true);
                }
                case "lambda$new$5ae44b49$1": {
                    if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/JobManagePanel$JobHistoryDialog") || !lambda.getImplMethodSignature().equals("(Ljava/lang/String;Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                    return arg_0 -> ((a)((Object)lambda.getCapturedArg(0))).a((String)lambda.getCapturedArg(1), arg_0);
                }
                case "lambda$new$601dec5$1": {
                    if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/HasValue$ValueChangeListener") || !lambda.getFunctionalInterfaceMethodName().equals("valueChanged") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/HasValue$ValueChangeEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/JobManagePanel$JobHistoryDialog") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/AbstractField$ComponentValueChangeEvent;)V")) break;
                    return (HasValue.ValueChangeListener & Serializable)event -> this.a();
                }
                case "lambda$new$329004d2$10": {
                    if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/JobManagePanel$JobHistoryDialog") || !lambda.getImplMethodSignature().equals("(Lorg/jumpmind/symmetric/statistic/JobStats;)Lcom/vaadin/flow/component/Component;")) break;
                    return (ValueProvider & Serializable)stats -> {
                        String message = stats.getErrorMessage();
                        if (message != null) {
                            Button showButton = new Button(cD.this.controller.getMessage("Show", new Object[0]), (ComponentEventListener & Serializable)event -> {
                                ReadOnlyTextAreaDialog dialog = new ReadOnlyTextAreaDialog(cD.this.controller.getMessage("Error Message", new Object[0]), message, false, open -> this.enableEscapeShortcut(open == false));
                                dialog.setWidth("80%");
                                dialog.setHeight("80%");
                                dialog.open();
                            });
                            showButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_SMALL});
                            return showButton;
                        }
                        return new Span();
                    };
                }
                case "lambda$new$601dec5$2": {
                    if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/HasValue$ValueChangeListener") || !lambda.getFunctionalInterfaceMethodName().equals("valueChanged") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/HasValue$ValueChangeEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/JobManagePanel$JobHistoryDialog") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/AbstractField$ComponentValueChangeEvent;)V")) break;
                    return (HasValue.ValueChangeListener & Serializable)event -> this.b();
                }
            }
            throw new IllegalArgumentException("Invalid lambda deserialization");
        }
    }

    class b
    implements M.a<Boolean> {
        String a;

        public b(String jobName) {
            this.a = jobName;
        }

        public Boolean a() {
            IJobManager jobManager = cD.this.controller.getSymmetricEngine().getJobManager();
            IJob job = jobManager.getJob(this.a);
            if (!job.isRunning()) {
                cD.this.log.info("Invoking the '{}' job manually", (Object)this.a);
                job.invoke(true);
                return true;
            }
            return false;
        }

        public void a(Boolean data) {
            if (!data.booleanValue()) {
                cD.this.notification("Cannot invoke the job.  It is already running.", new Object[0]);
            }
            cD.this.onRefresh(new Object[0]);
        }

        @Override
        public /* synthetic */ void doUI(Object object) {
            this.a((Boolean)object);
        }

        @Override
        public /* synthetic */ Object doWork() {
            return this.a();
        }
    }
}

