/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.impl.R;
import com.jumpmind.symmetric.console.impl.ag;
import com.jumpmind.symmetric.console.impl.ga;
import com.jumpmind.symmetric.console.model.Monitor;
import com.jumpmind.symmetric.console.model.Notification;
import com.jumpmind.symmetric.console.service.IMonitorService;
import com.jumpmind.symmetric.console.ui.common.H;
import com.jumpmind.symmetric.console.ui.common.I;
import com.jumpmind.symmetric.console.ui.common.as;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.ShortcutRegistration;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.confirmdialog.ConfirmDialog;
import com.vaadin.flow.component.contextmenu.MenuItem;
import com.vaadin.flow.component.contextmenu.SubMenu;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.menubar.MenuBar;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.page.Page;
import com.vaadin.flow.component.tabs.TabsVariant;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.server.Command;
import de.f0rce.ace.AceEditor;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.jumpmind.symmetric.model.IModelObject;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;
import org.jumpmind.vaadin.ui.common.TabSheet;

public class bq
extends com.jumpmind.symmetric.console.ui.common.b<Notification>
implements H {
    private static final long c = 1L;
    private Button d;
    protected Button a;
    protected ShortcutRegistration b;

    public bq(I controller) {
        super("Notifications send the user a message when a monitor finds a problem, such as logging an error or sending an email.", controller);
    }

    @Override
    protected R<Notification> createForm(boolean newItemFlag, boolean deleteFlag) {
        return new ag(this.controller, this.grid.getSelectedItems(), newItemFlag, deleteFlag);
    }

    @Override
    public String getTitleKey() {
        return "Notifications";
    }

    @Override
    public String getEditTitle() {
        return "Edit '%s' Notification";
    }

    @Override
    public String getNewTitle() {
        return "New Notification";
    }

    protected String a(Notification item) {
        return item.getNotificationId();
    }

    @Override
    protected void itemSelected() {
        if (this.d != null) {
            if (this.grid.getSelectedItems().size() == 1) {
                Notification notification = (Notification)this.grid.getSelectedItems().iterator().next();
                this.d.setEnabled(notification.getType().equals("log") || notification.getType().equals("email"));
            } else {
                this.d.setEnabled(false);
            }
        }
    }

    @Override
    protected void noItemsSelected() {
        if (this.d != null) {
            this.d.setEnabled(false);
        }
    }

    @Override
    protected void addButtonsMiddle(FlexLayout buttonLayout) {
        this.d = new Button(this.controller.getMessage("Edit Template", new Object[0]));
        this.d.getStyle().set("margin", "4px");
        this.d.addClickListener((ComponentEventListener & Serializable)event -> {
            if (!this.grid.getSelectedItems().isEmpty()) {
                new a((Notification)this.grid.getSelectedItems().iterator().next()).open();
            }
        });
        this.d.setEnabled(false);
        buttonLayout.add(new Component[]{this.d});
    }

    @Override
    protected void initGrid() {
        this.grid = new Grid(Notification.class);
    }

    @Override
    protected void fillGrid(Grid<Notification> grid) {
        String searchValue;
        IMonitorService notificationService = this.controller.getMonitorService();
        if (this.itemList != null) {
            this.itemList.clear();
        }
        if (!StringUtils.isBlank((CharSequence)(searchValue = this.searchField.getValue()))) {
            List<Notification> allNotifications = notificationService.getNotifications();
            for (Notification notification : allNotifications) {
                if (CommonUiUtils.isFilteredOut((String)notification.getNotificationId(), (String)searchValue)) continue;
                this.itemList.add(notification);
            }
        } else {
            this.itemList = notificationService.getNotifications();
        }
        this.updateItems(this.itemList);
    }

    @Override
    protected void configureGridColumns() {
        super.configureGridColumns();
        this.columnVisibilityToggler.addColumn((Grid.Column)this.grid.addColumn((ValueProvider & Serializable)notification -> {
            List<Monitor> monitors = this.controller.getMonitorService().getMonitors();
            List<String> filteredMonitorIds = notification.getExpression().getMonitorIds();
            int count = 0;
            for (Monitor monitor : monitors) {
                String notificationTarget = notification.getTargetNode();
                String monitorTarget = monitor.getTargetNode();
                if (!monitor.isEnabled() || monitor.isInsight() || notification.getSeverityLevel() > monitor.getSeverityLevel() || !filteredMonitorIds.isEmpty() && !filteredMonitorIds.contains(monitor.getMonitorId()) || !notificationTarget.equals("ALL") && !monitorTarget.equals("ALL") && !notificationTarget.equals(monitorTarget) && (!notificationTarget.endsWith(" only") || !notification.getNodeGroupId().equals(monitorTarget)) && (!monitorTarget.endsWith(" only") || !monitor.getNodeGroupId().equals(notificationTarget))) continue;
                ++count;
            }
            return count;
        }).setHeader(this.controller.getMessage("Monitors", new Object[0])).setKey("monitors").setResizable(true), this.controller.getMessage("Monitors", new Object[0]));
        this.grid.setColumnOrder(Arrays.asList(this.grid.getColumnByKey("notificationId"), this.grid.getColumnByKey("targetNode"), this.grid.getColumnByKey("type"), this.grid.getColumnByKey("severityLevelName"), this.grid.getColumnByKey("monitors"), this.grid.getColumnByKey("enabled"), this.grid.getColumnByKey("lastUpdateTime"), this.grid.getColumnByKey("lastUpdateBy"), this.grid.getColumnByKey("createTime")));
    }

    @Override
    protected String getKeyColumn() {
        return "notificationId";
    }

    @Override
    protected String[] getFilterColumns() {
        String[] columns = new String[]{"notificationId"};
        return columns;
    }

    @Override
    protected Map<String, String> getVisibleGridColumns() {
        LinkedHashMap<String, String> columns = new LinkedHashMap<String, String>();
        columns.put("notificationId", this.controller.getMessage("Notification Id", new Object[0]));
        columns.put("targetNode", this.controller.getMessage("Target Nodes", new Object[0]));
        columns.put("type", this.controller.getMessage("Notification Type", new Object[0]));
        columns.put("severityLevelName", this.controller.getMessage("Severity Level", new Object[0]));
        columns.put("enabled", this.controller.getMessage("Enabled", new Object[0]));
        columns.put("lastUpdateTime", this.controller.getMessage("Last Updated", new Object[0]));
        columns.put("lastUpdateBy", this.controller.getMessage("Last Updated By", new Object[0]));
        columns.put("createTime", this.controller.getMessage("Created", new Object[0]));
        return columns;
    }

    @Override
    protected boolean isDeleteEnabled(StringBuilder tooltip) {
        if (!this.grid.getSelectedItems().isEmpty()) {
            if (this.controller.getConsoleUser().hasPrivilegeWrite("Notifications Screen")) {
                return true;
            }
            tooltip.append(String.format("Your role '%s' does not have the privileges needed for this action.", this.controller.getConsoleUser().getRole()));
            return false;
        }
        tooltip.append(String.format("Your role '%s' does not have the privileges needed for this action.", this.controller.getConsoleUser().getRole()));
        return false;
    }

    @Override
    protected boolean isNewEnabled(StringBuilder tooltip) {
        if (this.controller.getConsoleUser().hasPrivilegeWrite("Notifications Screen")) {
            return true;
        }
        String consoleRoleId = "unknown";
        if (this.controller.getConsoleUser().getRole() != null) {
            consoleRoleId = this.controller.getConsoleUser().getRole();
        }
        tooltip.append(String.format("Your role '%s' does not have the privileges needed for this action.", consoleRoleId));
        return false;
    }

    @Override
    protected boolean isEditEnabled(StringBuilder tooltip) {
        if (this.controller.getConsoleUser().hasPrivilegeWrite("Notifications Screen")) {
            return true;
        }
        String consoleRoleId = "unknown";
        if (this.controller.getConsoleUser().getRole() != null) {
            consoleRoleId = this.controller.getConsoleUser().getRole();
        }
        tooltip.append(String.format("Your role '%s' does not have the privileges needed for this action.", consoleRoleId));
        return false;
    }

    @Override
    protected boolean gridCanBeModified() {
        boolean canModify = false;
        canModify = this.controller.getConsoleUser().hasPrivilegeRead("Notifications Screen");
        return canModify;
    }

    @Override
    protected boolean canSaveAsCopy() {
        return true;
    }

    @Override
    protected void hideColumns() {
        this.grid.getColumnByKey("lastUpdateTime").setVisible(false);
        this.grid.getColumnByKey("lastUpdateBy").setVisible(false);
        this.grid.getColumnByKey("createTime").setVisible(false);
    }

    @Override
    public String getDocAnchor() {
        return "/doc/html/user-guide.html#_notifications";
    }

    @Override
    protected /* synthetic */ String getId(IModelObject iModelObject) {
        return this.a((Notification)iModelObject);
    }

    private static /* synthetic */ Object a(SerializedLambda lambda) {
        switch (lambda.getImplMethodName()) {
            case "lambda$addButtonsMiddle$d01c01f6$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/NotificationEditPanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                return (ComponentEventListener & Serializable)event -> {
                    if (!this.grid.getSelectedItems().isEmpty()) {
                        new a((Notification)this.grid.getSelectedItems().iterator().next()).open();
                    }
                };
            }
            case "lambda$configureGridColumns$ba6e7b7d$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/NotificationEditPanel") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/model/Notification;)Ljava/lang/Object;")) break;
                return (ValueProvider & Serializable)notification -> {
                    List<Monitor> monitors = this.controller.getMonitorService().getMonitors();
                    List<String> filteredMonitorIds = notification.getExpression().getMonitorIds();
                    int count = 0;
                    for (Monitor monitor : monitors) {
                        String notificationTarget = notification.getTargetNode();
                        String monitorTarget = monitor.getTargetNode();
                        if (!monitor.isEnabled() || monitor.isInsight() || notification.getSeverityLevel() > monitor.getSeverityLevel() || !filteredMonitorIds.isEmpty() && !filteredMonitorIds.contains(monitor.getMonitorId()) || !notificationTarget.equals("ALL") && !monitorTarget.equals("ALL") && !notificationTarget.equals(monitorTarget) && (!notificationTarget.endsWith(" only") || !notification.getNodeGroupId().equals(monitorTarget)) && (!monitorTarget.endsWith(" only") || !monitor.getNodeGroupId().equals(notificationTarget))) continue;
                        ++count;
                    }
                    return count;
                };
            }
        }
        throw new IllegalArgumentException("Invalid lambda deserialization");
    }

    class a
    extends Dialog {
        private static final long b = 1L;
        private c c;
        private VerticalLayout d;
        private String e;

        public a(Notification notification) {
            this.c = new c(notification);
            this.e = notification.getExpressionString();
            this.setModal(true);
            this.setResizable(true);
            this.setCloseOnOutsideClick(false);
            UI.getCurrent().getPage().retrieveExtendedClientDetails((Page.ExtendedClientDetailsReceiver & Serializable)details -> {
                this.setWidth(details.getBodyClientWidth() - 200 + "px");
                this.setHeight(details.getBodyClientHeight() - 100 + "px");
            });
            UI.getCurrent().addShortcutListener((Command & Serializable)() -> {
                if (!"100%".equals(this.getWidth())) {
                    this.setWidth("100%");
                    this.setHeight("100%");
                } else {
                    UI.getCurrent().getPage().retrieveExtendedClientDetails((Page.ExtendedClientDetailsReceiver & Serializable)details -> {
                        this.setWidth(details.getBodyClientWidth() - 200 + "px");
                        this.setHeight(details.getBodyClientHeight() - 100 + "px");
                    });
                }
            }, Key.KEY_M, new KeyModifier[]{KeyModifier.CONTROL});
            VerticalLayout content = new VerticalLayout();
            content.setSizeFull();
            content.setPadding(false);
            this.add(new Component[]{content});
            this.setHeaderTitle(bq.this.controller.getMessage("Template for '%s'", notification.getNotificationId()));
            this.d = new VerticalLayout();
            this.d.setSpacing(true);
            this.d.setWidthFull();
            this.d.setClassName("dialog-content");
            content.addAndExpand(new Component[]{this.d});
            this.c.setHeight("250px");
            this.d.add(new Component[]{this.c});
            this.d.expand(new Component[]{this.c});
            Button saveButton = as.createPrimaryButton(bq.this.controller.getMessage("Save", new Object[0]), false);
            saveButton.addClickListener((ComponentEventListener & Serializable)event -> {
                if (this.a()) {
                    bq.this.addEvent("Notification Modified", notification.getNotificationId());
                    bq.this.onRefresh(new Object[0]);
                    this.a(true);
                }
            });
            saveButton.setEnabled(bq.this.gridCanBeModified());
            bq.this.a = new Button(bq.this.controller.getMessage("Cancel", new Object[0]));
            bq.this.b = bq.this.a.addClickShortcut(Key.ESCAPE, new KeyModifier[0]);
            bq.this.a.addClickListener((ComponentEventListener & Serializable)event -> this.a(false));
            this.getFooter().add(new Component[]{bq.this.a, saveButton});
        }

        protected boolean a() {
            try {
                this.c.a();
                bq.this.controller.getMonitorService().saveNotification(this.c.k);
                return true;
            }
            catch (Exception ex2) {
                bq.this.log.error(ex2.getMessage(), (Throwable)ex2);
                CommonUiUtils.notify((String)bq.this.message("Failed to save.  Please check settings and try again."));
                return false;
            }
        }

        public void close() {
            this.a(false);
        }

        public void a(boolean force) {
            this.c.a();
            String expression = this.c.k.getExpressionString();
            if (force || Strings.CS.equals(this.e, expression)) {
                super.close();
            } else {
                new ConfirmDialog(bq.this.controller.getMessage("Close Editor?", new Object[0]), bq.this.controller.getMessage("Changes will be lost.  Are you sure you want to close the template editor?", new Object[0]), bq.this.controller.getMessage("Yes", new Object[0]), (ComponentEventListener & Serializable)e2 -> this.a(true), bq.this.controller.getMessage("No", new Object[0]), (ComponentEventListener & Serializable)e2 -> {}).open();
            }
        }

        private static /* synthetic */ Object a(SerializedLambda lambda) {
            switch (lambda.getImplMethodName()) {
                case "lambda$new$72035aea$1": {
                    if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/NotificationEditPanel$EditTemplateDialog") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/model/Notification;Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                    return arg_0 -> ((a)((Object)lambda.getCapturedArg(0))).a((Notification)lambda.getCapturedArg(1), arg_0);
                }
                case "lambda$close$44ddc631$2": {
                    if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/NotificationEditPanel$EditTemplateDialog") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/confirmdialog/ConfirmDialog$CancelEvent;)V")) break;
                    return (ComponentEventListener & Serializable)e2 -> {};
                }
                case "lambda$new$8031c65c$1": {
                    if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/page/Page$ExtendedClientDetailsReceiver") || !lambda.getFunctionalInterfaceMethodName().equals("receiveDetails") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/page/ExtendedClientDetails;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/NotificationEditPanel$EditTemplateDialog") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/page/ExtendedClientDetails;)V")) break;
                    return (Page.ExtendedClientDetailsReceiver & Serializable)details -> {
                        this.setWidth(details.getBodyClientWidth() - 200 + "px");
                        this.setHeight(details.getBodyClientHeight() - 100 + "px");
                    };
                }
                case "lambda$new$de7ceb3c$1": {
                    if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/NotificationEditPanel$EditTemplateDialog") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                    return (ComponentEventListener & Serializable)event -> this.a(false);
                }
                case "lambda$close$44ddc631$1": {
                    if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/NotificationEditPanel$EditTemplateDialog") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/confirmdialog/ConfirmDialog$ConfirmEvent;)V")) break;
                    return (ComponentEventListener & Serializable)e2 -> this.a(true);
                }
                case "lambda$new$e00e6a9e$1": {
                    if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/server/Command") || !lambda.getFunctionalInterfaceMethodName().equals("execute") || !lambda.getFunctionalInterfaceMethodSignature().equals("()V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/NotificationEditPanel$EditTemplateDialog") || !lambda.getImplMethodSignature().equals("()V")) break;
                    return (Command & Serializable)() -> {
                        if (!"100%".equals(this.getWidth())) {
                            this.setWidth("100%");
                            this.setHeight("100%");
                        } else {
                            UI.getCurrent().getPage().retrieveExtendedClientDetails((Page.ExtendedClientDetailsReceiver & Serializable)details -> {
                                this.setWidth(details.getBodyClientWidth() - 200 + "px");
                                this.setHeight(details.getBodyClientHeight() - 100 + "px");
                            });
                        }
                    };
                }
                case "lambda$new$8031c65c$2": {
                    if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/page/Page$ExtendedClientDetailsReceiver") || !lambda.getFunctionalInterfaceMethodName().equals("receiveDetails") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/page/ExtendedClientDetails;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/NotificationEditPanel$EditTemplateDialog") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/page/ExtendedClientDetails;)V")) break;
                    return (Page.ExtendedClientDetailsReceiver & Serializable)details -> {
                        this.setWidth(details.getBodyClientWidth() - 200 + "px");
                        this.setHeight(details.getBodyClientHeight() - 100 + "px");
                    };
                }
            }
            throw new IllegalArgumentException("Invalid lambda deserialization");
        }
    }

    class b
    extends Div {
        private static final long b = 1L;
        private AceEditor c;
        private int d = 0;

        public b() {
            this.setSizeFull();
            this.c = as.createAceEditor();
            this.c.addSelectionChangeListener((ComponentEventListener & Serializable)event -> {
                this.d = event.getSelection().getStartIndex();
            });
            this.c.setSizeFull();
            this.add(new Component[]{this.c});
        }

        public void a(String text) {
            this.c.setValue(text);
        }

        public String a() {
            return this.c.getValue();
        }

        public int b() {
            return this.d;
        }

        public AceEditor c() {
            return this.c;
        }

        private static /* synthetic */ Object a(SerializedLambda lambda) {
            switch (lambda.getImplMethodName()) {
                case "lambda$new$9b1b5227$1": {
                    if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/NotificationEditPanel$Editor") || !lambda.getImplMethodSignature().equals("(Lde/f0rce/ace/events/AceSelectionChanged;)V")) break;
                    return (ComponentEventListener & Serializable)event -> {
                        this.d = event.getSelection().getStartIndex();
                    };
                }
            }
            throw new IllegalArgumentException("Invalid lambda deserialization");
        }
    }

    class c
    extends VerticalLayout {
        private static final long n = 1L;
        protected TabSheet a = new TabSheet();
        protected b b;
        protected b c;
        protected b d;
        protected b e;
        protected b f;
        protected b g;
        protected b h;
        protected List<b> i;
        protected Map<String, b> j = new HashMap<String, b>();
        protected Notification k;
        protected HorizontalLayout l;

        public c(Notification notification) {
            this.setSpacing(true);
            this.setSizeFull();
            this.getStyle().set("margin", "0");
            this.k = notification;
            this.l = new HorizontalLayout();
            this.a.addThemeVariants(new TabsVariant[]{TabsVariant.LUMO_SMALL});
            this.a.setSizeFull();
            this.a.addSelectedTabChangeListener((ComponentEventListener & Serializable)e2 -> {
                TabSheet.EnhancedTab selectedTab = this.a.getSelectedTab();
                this.b = (b)selectedTab.getComponent();
                MenuBar builtInVariableMenu = new MenuBar();
                MenuItem builtInVariables = builtInVariableMenu.addItem(bq.this.controller.getMessage("Built-in Variables", new Object[0]));
                builtInVariables.add(new Component[]{as.getDropdownIcon()});
                ComponentEventListener & Serializable addVariable = (ComponentEventListener & Serializable)event -> this.b.c.addTextAtCurrentPosition(((MenuItem)event.getSource()).getText());
                SubMenu builtInVariablesSubMenu = (SubMenu)builtInVariables.getSubMenu();
                builtInVariablesSubMenu.addItem("$(engineName)", (ComponentEventListener)addVariable);
                builtInVariablesSubMenu.addItem("$(eventCount)", (ComponentEventListener)addVariable);
                if (!e2.isFromClient() || ((Object)((Object)this.b)).equals((Object)this.c) || ((Object)((Object)this.b)).equals((Object)this.d) || ((Object)((Object)this.b)).equals((Object)this.e)) {
                    builtInVariablesSubMenu.addItem("$(eventNodeCount)", (ComponentEventListener)addVariable);
                    builtInVariablesSubMenu.addItem("$(eventNodeIds)", (ComponentEventListener)addVariable);
                    builtInVariablesSubMenu.addItem("$(eventTypes)", (ComponentEventListener)addVariable);
                } else {
                    builtInVariablesSubMenu.addItem("$(eventDetails)", (ComponentEventListener)addVariable);
                    builtInVariablesSubMenu.addItem("$(eventHostName)", (ComponentEventListener)addVariable);
                    builtInVariablesSubMenu.addItem("$(eventIsNotified)", (ComponentEventListener)addVariable);
                    builtInVariablesSubMenu.addItem("$(eventIsResolved)", (ComponentEventListener)addVariable);
                    builtInVariablesSubMenu.addItem("$(eventLastUpdateTime)", (ComponentEventListener)addVariable);
                    builtInVariablesSubMenu.addItem("$(eventMonitorId)", (ComponentEventListener)addVariable);
                    builtInVariablesSubMenu.addItem("$(eventNodeExternalId)", (ComponentEventListener)addVariable);
                    builtInVariablesSubMenu.addItem("$(eventNodeGroupId)", (ComponentEventListener)addVariable);
                    builtInVariablesSubMenu.addItem("$(eventNodeId)", (ComponentEventListener)addVariable);
                    builtInVariablesSubMenu.addItem("$(eventSeverityLevel)", (ComponentEventListener)addVariable);
                    builtInVariablesSubMenu.addItem("$(eventThreshold)", (ComponentEventListener)addVariable);
                    builtInVariablesSubMenu.addItem("$(eventTime)", (ComponentEventListener)addVariable);
                    builtInVariablesSubMenu.addItem("$(eventType)", (ComponentEventListener)addVariable);
                    builtInVariablesSubMenu.addItem("$(eventValue)", (ComponentEventListener)addVariable);
                }
                builtInVariablesSubMenu.addItem("$(serverName)", (ComponentEventListener)addVariable);
                this.l.removeAll();
                this.l.add(new Component[]{builtInVariableMenu});
            });
            this.add(new Component[]{this.l});
            Notification.Expression expression = notification.getExpression();
            if (expression instanceof Notification.LogExpression) {
                Notification.LogExpression logExpression = (Notification.LogExpression)expression;
                this.f = this.a(bq.this.controller.getMessage("Unresolved", new Object[0]), logExpression.getUnresolved());
                this.g = this.a(bq.this.controller.getMessage("Resolved", new Object[0]), logExpression.getResolved());
            } else if (expression instanceof Notification.EmailExpression) {
                Notification.EmailExpression emailExpression = (Notification.EmailExpression)expression;
                this.c = this.a(bq.this.controller.getMessage("Subject", new Object[0]), emailExpression.getSubject());
                this.d = this.a(bq.this.controller.getMessage("Body Before", new Object[0]), emailExpression.getBodyBefore());
                this.e = this.a(bq.this.controller.getMessage("Body After", new Object[0]), emailExpression.getBodyAfter());
                this.f = this.a(bq.this.controller.getMessage("Unresolved", new Object[0]), emailExpression.getUnresolved());
                this.g = this.a(bq.this.controller.getMessage("Resolved", new Object[0]), emailExpression.getResolved());
                Map<String, String> templateMap = emailExpression.getTemplateMap();
                String defaultValue = templateMap.get("default");
                this.h = this.a(bq.this.controller.getMessage("Default", new Object[0]), defaultValue != null ? defaultValue : "");
                for (ga monitorType : bq.this.controller.getSymmetricEngine().getExtensionService().getExtensionPointList(ga.class)) {
                    String monitorName = monitorType.b();
                    String templateValue = templateMap.get(monitorName);
                    if (templateValue != null) {
                        this.j.put(monitorName, this.a(as.formatMonitorType(monitorName), templateValue));
                        continue;
                    }
                    this.j.put(monitorName, this.a(as.formatMonitorType(monitorName), ""));
                }
            }
            this.a.setSelectedTab((Component)this.c);
            this.addAndExpand(new Component[]{this.a});
        }

        protected b a(String caption, String value) {
            b editor = new b();
            editor.a(value);
            this.a.add((Component)editor, caption);
            return editor;
        }

        protected void a() {
            Notification.Expression expression = this.k.getExpression();
            if (expression instanceof Notification.LogExpression) {
                Notification.LogExpression logExpression = (Notification.LogExpression)expression;
                logExpression.setUnresolved(this.f.a());
                logExpression.setResolved(this.g.a());
            } else if (expression instanceof Notification.EmailExpression) {
                Notification.EmailExpression emailExpression = (Notification.EmailExpression)expression;
                emailExpression.setSubject(this.c.a());
                emailExpression.setBodyBefore(this.d.a());
                emailExpression.setBodyAfter(this.e.a());
                emailExpression.setUnresolved(this.f.a());
                emailExpression.setResolved(this.g.a());
                HashMap<String, String> templateMap = new HashMap<String, String>();
                templateMap.put("default", this.h.a());
                for (String name : this.j.keySet()) {
                    templateMap.put(name, this.j.get(name).a());
                }
                emailExpression.setTemplates(templateMap);
            }
            this.k.setExpression(expression);
        }

        private static /* synthetic */ Object a(SerializedLambda lambda) {
            switch (lambda.getImplMethodName()) {
                case "lambda$new$25073adc$1": {
                    if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/NotificationEditPanel$TemplatePanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                    return (ComponentEventListener & Serializable)event -> this.b.c.addTextAtCurrentPosition(((MenuItem)event.getSource()).getText());
                }
                case "lambda$new$de7ceb3c$1": {
                    if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/NotificationEditPanel$TemplatePanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/tabs/Tabs$SelectedChangeEvent;)V")) break;
                    return (ComponentEventListener & Serializable)e2 -> {
                        TabSheet.EnhancedTab selectedTab = this.a.getSelectedTab();
                        this.b = (b)selectedTab.getComponent();
                        MenuBar builtInVariableMenu = new MenuBar();
                        MenuItem builtInVariables = builtInVariableMenu.addItem(bq.this.controller.getMessage("Built-in Variables", new Object[0]));
                        builtInVariables.add(new Component[]{as.getDropdownIcon()});
                        ComponentEventListener & Serializable addVariable = (ComponentEventListener & Serializable)event -> this.b.c.addTextAtCurrentPosition(((MenuItem)event.getSource()).getText());
                        SubMenu builtInVariablesSubMenu = (SubMenu)builtInVariables.getSubMenu();
                        builtInVariablesSubMenu.addItem("$(engineName)", (ComponentEventListener)addVariable);
                        builtInVariablesSubMenu.addItem("$(eventCount)", (ComponentEventListener)addVariable);
                        if (!e2.isFromClient() || ((Object)((Object)this.b)).equals((Object)this.c) || ((Object)((Object)this.b)).equals((Object)this.d) || ((Object)((Object)this.b)).equals((Object)this.e)) {
                            builtInVariablesSubMenu.addItem("$(eventNodeCount)", (ComponentEventListener)addVariable);
                            builtInVariablesSubMenu.addItem("$(eventNodeIds)", (ComponentEventListener)addVariable);
                            builtInVariablesSubMenu.addItem("$(eventTypes)", (ComponentEventListener)addVariable);
                        } else {
                            builtInVariablesSubMenu.addItem("$(eventDetails)", (ComponentEventListener)addVariable);
                            builtInVariablesSubMenu.addItem("$(eventHostName)", (ComponentEventListener)addVariable);
                            builtInVariablesSubMenu.addItem("$(eventIsNotified)", (ComponentEventListener)addVariable);
                            builtInVariablesSubMenu.addItem("$(eventIsResolved)", (ComponentEventListener)addVariable);
                            builtInVariablesSubMenu.addItem("$(eventLastUpdateTime)", (ComponentEventListener)addVariable);
                            builtInVariablesSubMenu.addItem("$(eventMonitorId)", (ComponentEventListener)addVariable);
                            builtInVariablesSubMenu.addItem("$(eventNodeExternalId)", (ComponentEventListener)addVariable);
                            builtInVariablesSubMenu.addItem("$(eventNodeGroupId)", (ComponentEventListener)addVariable);
                            builtInVariablesSubMenu.addItem("$(eventNodeId)", (ComponentEventListener)addVariable);
                            builtInVariablesSubMenu.addItem("$(eventSeverityLevel)", (ComponentEventListener)addVariable);
                            builtInVariablesSubMenu.addItem("$(eventThreshold)", (ComponentEventListener)addVariable);
                            builtInVariablesSubMenu.addItem("$(eventTime)", (ComponentEventListener)addVariable);
                            builtInVariablesSubMenu.addItem("$(eventType)", (ComponentEventListener)addVariable);
                            builtInVariablesSubMenu.addItem("$(eventValue)", (ComponentEventListener)addVariable);
                        }
                        builtInVariablesSubMenu.addItem("$(serverName)", (ComponentEventListener)addVariable);
                        this.l.removeAll();
                        this.l.add(new Component[]{builtInVariableMenu});
                    };
                }
            }
            throw new IllegalArgumentException("Invalid lambda deserialization");
        }
    }
}

