/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.impl.R;
import com.jumpmind.symmetric.console.impl.af;
import com.jumpmind.symmetric.console.model.ConsoleEvent;
import com.jumpmind.symmetric.console.model.Monitor;
import com.jumpmind.symmetric.console.model.Notification;
import com.jumpmind.symmetric.console.service.IMonitorService;
import com.jumpmind.symmetric.console.ui.common.H;
import com.jumpmind.symmetric.console.ui.common.I;
import com.jumpmind.symmetric.console.ui.common.Slider;
import com.jumpmind.symmetric.console.ui.common.b;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.job.IJob;
import org.jumpmind.symmetric.model.IModelObject;
import org.jumpmind.symmetric.model.JobDefinition;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;

public class bo
extends b<Monitor>
implements H {
    private static final long b = 1L;
    protected List<Notification> a;

    public bo(I controller) {
        super("Monitors watch the system for problems and record an event when a configured threshold is exceeded.", controller);
    }

    @Override
    protected R<Monitor> createForm(boolean newItemFlag, boolean deleteFlag) {
        return new af(this.controller, this.grid.getSelectedItems(), newItemFlag, deleteFlag);
    }

    @Override
    public String getTitleKey() {
        return "Monitors";
    }

    @Override
    public String getEditTitle() {
        return "Edit '%s' Monitor";
    }

    @Override
    public String getNewTitle() {
        return "New Monitor";
    }

    protected String a(Monitor item) {
        return item.getMonitorId();
    }

    @Override
    protected void addButtonsMiddle(FlexLayout buttonLayout) {
        buttonLayout.setAlignItems(FlexComponent.Alignment.CENTER);
        buttonLayout.add(new Component[]{this.buildSeperater()});
        Span intervalSpan = new Span("Monitor Job Interval");
        buttonLayout.add(new Component[]{intervalSpan});
        IJob monitorJob = this.controller.getSymmetricEngine().getJobManager().getJob("Monitor");
        String schedule = monitorJob.getSchedule();
        double interval = 30000.0;
        try {
            interval = Double.parseDouble(schedule);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Slider monitorJobInterval = new Slider((int)Math.min(5.0, interval / 1000.0), (int)Math.max(300.0, interval / 1000.0));
        monitorJobInterval.setPin(true);
        monitorJobInterval.setValue((int)interval / 1000);
        monitorJobInterval.setId("monitorJobInterval");
        Span intervalValue = new Span(((Integer)monitorJobInterval.getValue()).toString().replace(".0", "") + " seconds");
        Button applyButton = new Button(this.controller.getMessage("Apply", new Object[0]));
        applyButton.getStyle().set("margin", "4px 4px 4px 8px");
        monitorJobInterval.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            intervalValue.setText(((Integer)event.getValue()).toString().replace(".0", "") + " seconds");
            applyButton.setEnabled(true);
        });
        buttonLayout.add(new Component[]{monitorJobInterval});
        buttonLayout.add(new Component[]{intervalValue});
        applyButton.setEnabled(false);
        applyButton.addClickListener((ComponentEventListener & Serializable)event -> {
            JobDefinition definition = monitorJob.getJobDefinition();
            definition.setSchedule(String.valueOf((Integer)monitorJobInterval.getValue() * 1000).replace(".0", ""));
            IParameterService parameterService = this.controller.getSymmetricEngine().getParameterService();
            parameterService.saveParameter("ALL", "ALL", definition.getStartParameter(), (Object)definition.isAutomaticStartup(), this.controller.getConsoleUser().getUserId());
            parameterService.saveParameter("ALL", "ALL", definition.getPeriodicParameter(), (Object)definition.getSchedule(), this.controller.getConsoleUser().getUserId());
            parameterService.deleteParameter("ALL", "ALL", definition.getCronParameter());
            String nodeId = this.controller.getSymmetricEngine().getNodeId();
            this.controller.getConsoleEventService().addEvent(new ConsoleEvent(this.controller.getConsoleUser().getUserId(), "Job Modified", nodeId, nodeId, null, definition.getJobName()));
            applyButton.setEnabled(false);
        });
        buttonLayout.add(new Component[]{applyButton});
    }

    @Override
    protected void initGrid() {
        this.grid = new Grid(Monitor.class);
    }

    @Override
    protected void fillGrid(Grid<Monitor> grid) {
        IMonitorService monitorService = this.controller.getMonitorService();
        if (this.itemList != null) {
            this.itemList.clear();
        } else {
            this.itemList = new ArrayList();
        }
        String searchValue = this.searchField.getValue();
        if (!StringUtils.isBlank((CharSequence)searchValue)) {
            List<Monitor> allMonitors = monitorService.getMonitors();
            for (Monitor monitor : allMonitors) {
                if (CommonUiUtils.isFilteredOut((String)monitor.getMonitorId(), (String)searchValue)) continue;
                this.itemList.add(monitor);
            }
        } else {
            this.itemList = monitorService.getMonitors();
        }
        this.updateItems(this.itemList);
    }

    @Override
    protected void configureGridColumns() {
        super.configureGridColumns();
        this.a = new ArrayList<Notification>();
        this.columnVisibilityToggler.addColumn((Grid.Column)this.grid.addColumn((ValueProvider & Serializable)monitor -> {
            if (monitor.isInsight()) {
                return 0;
            }
            int count = 0;
            for (Notification notification : this.a) {
                List<String> filteredMonitorIds = notification.getExpression().getMonitorIds();
                String notificationTarget = notification.getTargetNode();
                String monitorTarget = monitor.getTargetNode();
                if (!notification.isEnabled() || notification.getSeverityLevel() > monitor.getSeverityLevel() || !filteredMonitorIds.isEmpty() && !filteredMonitorIds.contains(monitor.getMonitorId()) || !notificationTarget.equals("ALL") && !monitorTarget.equals("ALL") && !notificationTarget.equals(monitorTarget) && (!notificationTarget.endsWith(" only") || !notification.getNodeGroupId().equals(monitorTarget)) && (!monitorTarget.endsWith(" only") || !monitor.getNodeGroupId().equals(notificationTarget))) continue;
                ++count;
            }
            return count;
        }).setHeader(this.controller.getMessage("Notifications", new Object[0])).setKey("notifications").setResizable(true), this.controller.getMessage("Notifications", new Object[0]));
        this.grid.setColumnOrder(Arrays.asList(this.grid.getColumnByKey("monitorId"), this.grid.getColumnByKey("targetNode"), this.grid.getColumnByKey("type"), this.grid.getColumnByKey("threshold"), this.grid.getColumnByKey("runPeriod"), this.grid.getColumnByKey("runCount"), this.grid.getColumnByKey("severityLevelName"), this.grid.getColumnByKey("notifications"), this.grid.getColumnByKey("displayOrder"), this.grid.getColumnByKey("insight"), this.grid.getColumnByKey("pinned"), this.grid.getColumnByKey("enabled"), this.grid.getColumnByKey("lastUpdateTime"), this.grid.getColumnByKey("lastUpdateBy"), this.grid.getColumnByKey("createTime")));
    }

    @Override
    protected String getKeyColumn() {
        return "monitorId";
    }

    @Override
    protected String[] getFilterColumns() {
        String[] columns = new String[]{"monitorId"};
        return columns;
    }

    @Override
    protected Map<String, String> getVisibleGridColumns() {
        LinkedHashMap<String, String> columns = new LinkedHashMap<String, String>();
        columns.put("monitorId", this.controller.getMessage("Monitor Id", new Object[0]));
        columns.put("targetNode", this.controller.getMessage("Target Nodes", new Object[0]));
        columns.put("type", this.controller.getMessage("Monitor Type", new Object[0]));
        columns.put("threshold", this.controller.getMessage("Threshold", new Object[0]));
        columns.put("runPeriod", this.controller.getMessage("Run Period (seconds)", new Object[0]));
        columns.put("runCount", this.controller.getMessage("Run Count", new Object[0]));
        columns.put("severityLevelName", this.controller.getMessage("Severity Level", new Object[0]));
        columns.put("enabled", this.controller.getMessage("Enabled", new Object[0]));
        columns.put("displayOrder", this.controller.getMessage("Display Order", new Object[0]));
        columns.put("insight", this.controller.getMessage("Is Insight", new Object[0]));
        columns.put("pinned", this.controller.getMessage("Is Pinned", new Object[0]));
        columns.put("lastUpdateTime", this.controller.getMessage("Last Updated", new Object[0]));
        columns.put("lastUpdateBy", this.controller.getMessage("Last Updated By", new Object[0]));
        columns.put("createTime", this.controller.getMessage("Created", new Object[0]));
        return columns;
    }

    @Override
    public void onRefresh(Object ... params) {
        if (params != null && params.length > 0) {
            this.searchField.setValue(params[0].toString());
        }
        this.a = this.controller.getMonitorService().getNotifications();
        this.refreshUI();
    }

    @Override
    protected boolean isDeleteEnabled(StringBuilder tooltip) {
        if (!this.grid.getSelectedItems().isEmpty()) {
            if (this.controller.getConsoleUser().hasPrivilegeWrite("Configure Monitors Screen")) {
                return true;
            }
            tooltip.append(String.format("Your role '%s' does not have the privileges needed for this action.", this.controller.getConsoleUser().getRole()));
            return false;
        }
        tooltip.append(String.format("Your role '%s' does not have the privileges needed for this action.", this.controller.getConsoleUser().getRole()));
        return false;
    }

    @Override
    protected boolean isNewEnabled(StringBuilder tooltip) {
        if (this.controller.getConsoleUser().hasPrivilegeWrite("Configure Monitors Screen")) {
            return true;
        }
        String consoleRoleId = "unknown";
        if (this.controller.getConsoleUser().getRole() != null) {
            consoleRoleId = this.controller.getConsoleUser().getRole();
        }
        tooltip.append(String.format("Your role '%s' does not have the privileges needed for this action.", consoleRoleId));
        return false;
    }

    @Override
    protected boolean isEditEnabled(StringBuilder tooltip) {
        if (this.controller.getConsoleUser().hasPrivilegeWrite("Configure Monitors Screen")) {
            return true;
        }
        String consoleRoleId = "unknown";
        if (this.controller.getConsoleUser().getRole() != null) {
            consoleRoleId = this.controller.getConsoleUser().getRole();
        }
        tooltip.append(String.format("Your role '%s' does not have the privileges needed for this action.", consoleRoleId));
        return false;
    }

    @Override
    protected boolean gridCanBeModified() {
        boolean canModify = false;
        canModify = this.controller.getConsoleUser().hasPrivilegeRead("Configure Monitors Screen");
        return canModify;
    }

    @Override
    protected boolean canSaveAsCopy() {
        return true;
    }

    @Override
    protected void hideColumns() {
        this.grid.getColumnByKey("displayOrder").setVisible(false);
        this.grid.getColumnByKey("insight").setVisible(false);
        this.grid.getColumnByKey("pinned").setVisible(false);
        this.grid.getColumnByKey("lastUpdateTime").setVisible(false);
        this.grid.getColumnByKey("lastUpdateBy").setVisible(false);
        this.grid.getColumnByKey("createTime").setVisible(false);
    }

    @Override
    public String getDocAnchor() {
        return "/doc/html/user-guide.html#_monitors";
    }

    @Override
    protected /* synthetic */ String getId(IModelObject iModelObject) {
        return this.a((Monitor)iModelObject);
    }

    private static /* synthetic */ Object a(SerializedLambda lambda) {
        switch (lambda.getImplMethodName()) {
            case "lambda$addButtonsMiddle$dfba9a27$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/MonitorEditPanel") || !lambda.getImplMethodSignature().equals("(Lorg/jumpmind/symmetric/job/IJob;Lcom/jumpmind/symmetric/console/ui/common/Slider;Lcom/vaadin/flow/component/button/Button;Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                return arg_0 -> ((bo)lambda.getCapturedArg(0)).a((IJob)lambda.getCapturedArg(1), (Slider)((Object)lambda.getCapturedArg(2)), (Button)lambda.getCapturedArg(3), arg_0);
            }
            case "lambda$addButtonsMiddle$8d85c130$1": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/HasValue$ValueChangeListener") || !lambda.getFunctionalInterfaceMethodName().equals("valueChanged") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/HasValue$ValueChangeEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/MonitorEditPanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/html/Span;Lcom/vaadin/flow/component/button/Button;Lcom/vaadin/flow/component/AbstractField$ComponentValueChangeEvent;)V")) break;
                return arg_0 -> bo.a((Span)lambda.getCapturedArg(0), (Button)lambda.getCapturedArg(1), arg_0);
            }
            case "lambda$configureGridColumns$ba6e7b7d$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/MonitorEditPanel") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/model/Monitor;)Ljava/lang/Object;")) break;
                return (ValueProvider & Serializable)monitor -> {
                    if (monitor.isInsight()) {
                        return 0;
                    }
                    int count = 0;
                    for (Notification notification : this.a) {
                        List<String> filteredMonitorIds = notification.getExpression().getMonitorIds();
                        String notificationTarget = notification.getTargetNode();
                        String monitorTarget = monitor.getTargetNode();
                        if (!notification.isEnabled() || notification.getSeverityLevel() > monitor.getSeverityLevel() || !filteredMonitorIds.isEmpty() && !filteredMonitorIds.contains(monitor.getMonitorId()) || !notificationTarget.equals("ALL") && !monitorTarget.equals("ALL") && !notificationTarget.equals(monitorTarget) && (!notificationTarget.endsWith(" only") || !notification.getNodeGroupId().equals(monitorTarget)) && (!monitorTarget.endsWith(" only") || !monitor.getNodeGroupId().equals(notificationTarget))) continue;
                        ++count;
                    }
                    return count;
                };
            }
        }
        throw new IllegalArgumentException("Invalid lambda deserialization");
    }
}

