/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.impl.R;
import com.jumpmind.symmetric.console.impl.aa;
import com.jumpmind.symmetric.console.ui.common.H;
import com.jumpmind.symmetric.console.ui.common.I;
import com.jumpmind.symmetric.console.ui.common.b;
import com.vaadin.flow.component.grid.Grid;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.model.IModelObject;
import org.jumpmind.symmetric.model.NodeGroupLink;
import org.jumpmind.symmetric.model.Router;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.ITransformService;
import org.jumpmind.symmetric.service.ITriggerRouterService;
import org.jumpmind.symmetric.service.impl.TransformService;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;

public class be
extends b<NodeGroupLink>
implements H {
    private static final long a = 1L;

    public be(I controller) {
        super("A group link defines which groups will be the source of data capture and which groups the captured data will be targeted for.  The link defines the way data will be moved from the source to the target.", controller);
    }

    @Override
    protected R<NodeGroupLink> createForm(boolean newItemFlag, boolean deleteFlag) {
        return new aa(this.controller, this.grid.getSelectedItems(), newItemFlag, deleteFlag);
    }

    @Override
    public String getTitleKey() {
        return "Group Links";
    }

    @Override
    public String getEditTitle() {
        return "Edit '%s' Group Link";
    }

    @Override
    public String getNewTitle() {
        return "New Group Link";
    }

    protected String a(NodeGroupLink item) {
        return item.getSourceNodeGroupId() + " > " + item.getTargetNodeGroupId();
    }

    @Override
    protected void initGrid() {
        this.grid = new Grid(NodeGroupLink.class);
    }

    @Override
    protected void fillGrid(Grid<NodeGroupLink> grid) {
        String searchValue;
        IConfigurationService configService = this.controller.getSymmetricEngine().getConfigurationService();
        if (this.itemList != null) {
            this.itemList.clear();
        }
        if (!StringUtils.isBlank((CharSequence)(searchValue = this.searchField.getValue()))) {
            List allLinks = configService.getNodeGroupLinks(true);
            for (NodeGroupLink link : allLinks) {
                if (CommonUiUtils.isFilteredOut((String)link.getSourceNodeGroupId(), (String)searchValue) && CommonUiUtils.isFilteredOut((String)link.getTargetNodeGroupId(), (String)searchValue)) continue;
                this.itemList.add(link);
            }
        } else {
            this.itemList = configService.getNodeGroupLinks(true);
        }
        this.updateItems(this.itemList);
    }

    @Override
    protected boolean isDeleteEnabled(StringBuilder tooltip) {
        ITriggerRouterService triggerRouterService = this.controller.getSymmetricEngine().getTriggerRouterService();
        ITransformService transformService = this.controller.getSymmetricEngine().getTransformService();
        if (!this.grid.getSelectedItems().isEmpty()) {
            for (NodeGroupLink link : this.grid.getSelectedItems()) {
                List routers = triggerRouterService.getRoutersByGroupLink(link);
                if (!this.controller.getConsoleUser().hasPrivilegeWrite("Groups/Group Links Screen")) {
                    tooltip.append(String.format("Your role '%s' does not have the privileges needed for this action.", this.controller.getConsoleUser().getRole()));
                    return false;
                }
                if (routers.size() != 0) {
                    tooltip.append(String.format("The group link (%s, %s) is being referenced by the router '%s'.", link.getSourceNodeGroupId(), link.getTargetNodeGroupId(), ((Router)routers.get(0)).getRouterId()));
                    return false;
                }
                List transforms = transformService.findTransformsFor(link, null);
                if (transforms == null || transforms.size() == 0) continue;
                for (TransformService.TransformTableNodeGroupLink transform : transforms) {
                    if (transform.getTransformId() == null) continue;
                    tooltip.append(String.format("The group link (%s, %s) is being referenced by the transform '%s'.", link.getSourceNodeGroupId(), link.getTargetNodeGroupId(), transform.getTransformId()));
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean isNewEnabled(StringBuilder tooltip) {
        if (this.controller.getConsoleUser().hasPrivilegeWrite("Groups/Group Links Screen")) {
            return true;
        }
        String consoleRoleId = "unknown";
        if (this.controller.getConsoleUser().getRole() != null) {
            consoleRoleId = this.controller.getConsoleUser().getRole();
        }
        tooltip.append(String.format("Your role '%s' does not have the privileges needed for this action.", consoleRoleId));
        return false;
    }

    @Override
    protected boolean isEditEnabled(StringBuilder tooltip) {
        if (this.controller.getConsoleUser().hasPrivilegeWrite("Groups/Group Links Screen")) {
            return true;
        }
        String consoleRoleId = "unknown";
        if (this.controller.getConsoleUser().getRole() != null) {
            consoleRoleId = this.controller.getConsoleUser().getRole();
        }
        tooltip.append(String.format("Your role '%s' does not have the privileges needed for this action.", consoleRoleId));
        return false;
    }

    @Override
    protected boolean gridCanBeModified() {
        return this.controller.getConsoleUser().hasPrivilegeRead("Groups/Group Links Screen");
    }

    @Override
    protected String getKeyColumn() {
        return "sourceNodeGroupId";
    }

    @Override
    protected String[] getFilterColumns() {
        String[] columns = new String[]{"sourceNodeGroupId", "targetNodeGroupId"};
        return columns;
    }

    @Override
    protected Map<String, String> getVisibleGridColumns() {
        LinkedHashMap<String, String> columns = new LinkedHashMap<String, String>();
        columns.put("sourceNodeGroupId", this.controller.getMessage("Source Group Id", new Object[0]));
        columns.put("dataEventAction", this.controller.getMessage("Link", new Object[0]));
        columns.put("targetNodeGroupId", this.controller.getMessage("Target Group Id", new Object[0]));
        columns.put("syncConfigEnabled", this.controller.getMessage("Sync Configuration", new Object[0]));
        columns.put("syncSqlEnabled", this.controller.getMessage("Sync SQL/DDL", new Object[0]));
        columns.put("lastUpdateTime", this.controller.getMessage("Last Updated", new Object[0]));
        columns.put("lastUpdateBy", this.controller.getMessage("Last Updated By", new Object[0]));
        columns.put("createTime", this.controller.getMessage("Created", new Object[0]));
        return columns;
    }

    @Override
    protected void hideColumns() {
        this.grid.getColumnByKey("lastUpdateTime").setVisible(false);
        this.grid.getColumnByKey("lastUpdateBy").setVisible(false);
        this.grid.getColumnByKey("createTime").setVisible(false);
    }

    @Override
    public String getDocAnchor() {
        return "/doc/html/user-guide.html#_group_links";
    }

    @Override
    protected /* synthetic */ String getId(IModelObject iModelObject) {
        return this.a((NodeGroupLink)iModelObject);
    }
}

