/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.jumpmind.symmetric.console.model.ConsoleEvent;
import com.jumpmind.symmetric.console.model.Violation;
import com.jumpmind.symmetric.console.ui.common.H;
import com.jumpmind.symmetric.console.ui.common.I;
import com.jumpmind.symmetric.console.ui.common.J;
import com.jumpmind.symmetric.statistic.IThroughputStatisticManager;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.select.Select;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeGroup;
import org.jumpmind.symmetric.model.NodeGroupLink;
import org.jumpmind.symmetric.model.Router;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.service.IContextService;
import org.jumpmind.symmetric.web.SymmetricEngineHolder;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class bE
extends VerticalLayout
implements H,
J {
    private static final long h = 1L;
    final Logger a = LoggerFactory.getLogger(this.getClass());
    I b;
    Select<String> c;
    Select<TriggerRouter> d;
    Select<NodeGroup> e;
    List<NodeGroupLink> f;
    Button g;

    public bE(I controller, List<Violation> violations) {
        this.b = controller;
        VerticalLayout wrapper = new VerticalLayout();
        wrapper.setSpacing(true);
        wrapper.setWidth("50%");
        wrapper.setHeight(null);
        this.add(new Component[]{wrapper});
        this.setHorizontalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{wrapper});
        for (Violation violation : violations) {
            wrapper.add(new Component[]{this.a(violation)});
        }
    }

    @Override
    public void init() {
    }

    private VerticalLayout a(Violation violation) {
        VerticalLayout wrapper = new VerticalLayout();
        wrapper.setSpacing(true);
        wrapper.addClassName("violation-display");
        HorizontalLayout layout = new HorizontalLayout();
        layout.add(new Component[]{new Icon(VaadinIcon.WARNING)});
        Span violationType = new Span(violation.getType() + " Violation");
        violationType.addClassName("violation-type");
        layout.add(new Component[]{violationType});
        wrapper.add(new Component[]{layout});
        Span violationMessage = new Span(violation.getMessage());
        violationMessage.setWidthFull();
        violationMessage.addClassName("violation-message");
        wrapper.add(new Component[]{violationMessage});
        if (violation.getType().equals("Nodes")) {
            Map engines = this.b.getSymmetricEngineHolder().getEngines();
            List engineNames = engines.keySet().stream().collect(Collectors.toList());
            Collections.sort(engineNames, String.CASE_INSENSITIVE_ORDER);
            this.c = new Select();
            this.c.setItems(engineNames);
            this.c.setWidth("16em");
            this.c.setEmptySelectionAllowed(false);
            Button nodeUninstallButton = new Button("Uninstall");
            nodeUninstallButton.addClickListener((ComponentEventListener & Serializable)event -> {
                Node node = this.b.getSymmetricEngine((String)this.c.getValue()).getNodeService().getCachedIdentity();
                this.b.getSymmetricEngine().getNodeService().findAllNodes();
                try {
                    SymmetricEngineHolder engineHolder = this.b.getSymmetricEngineHolder();
                    for (ISymmetricEngine engine : this.b.getSymmetricEngines()) {
                        Node identity = engine.getNodeService().getCachedIdentity();
                        if ((identity != null || !StringUtils.isBlank((CharSequence)node.getNodeId())) && !identity.equals((Object)node)) continue;
                        engineHolder.uninstallEngine(engine);
                        this.b.logout();
                        break;
                    }
                }
                catch (Exception ex2) {
                    this.a.error("", (Throwable)ex2);
                    CommonUiUtils.notify((String)"Error", (String)"Failed to uninstall.  Please check the log file for details.");
                }
            });
            HorizontalLayout action = new HorizontalLayout();
            action.setSpacing(true);
            Span directions = new Span("Please uninstall nodes from the list below in order to become compliant with the license again.");
            directions.setWidthFull();
            directions.addClassName("violation-direction");
            wrapper.add(new Component[]{directions});
            action.add(new Component[]{this.c});
            action.add(new Component[]{nodeUninstallButton});
            wrapper.add(new Component[]{action});
            wrapper.setHorizontalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{action});
        } else if (violation.getType().equals("Tables")) {
            List triggerRouters = this.b.getSymmetricEngine().getTriggerRouterService().getTriggerRouters(true);
            this.d = new Select();
            this.d.setItems((Collection)triggerRouters);
            this.d.setWidth("16em");
            this.d.setEmptySelectionAllowed(false);
            Button tableRemoveButton = new Button("Delete");
            tableRemoveButton.addClickListener((ComponentEventListener & Serializable)event -> {
                try {
                    this.b.getSymmetricEngine().getTriggerRouterService().deleteTriggerRouter((TriggerRouter)this.d.getValue());
                    this.b.logout();
                }
                catch (Exception ex2) {
                    this.a.error("", (Throwable)ex2);
                    CommonUiUtils.notify((String)"Error", (String)"Failed to remove table from replication.  Please check the log file for details.");
                }
            });
            HorizontalLayout action = new HorizontalLayout();
            action.setSpacing(true);
            Span directions = new Span("Please remove some tables from replication in order to become compliant with the license.");
            directions.setWidthFull();
            directions.addClassName("violation-direction");
            wrapper.add(new Component[]{directions});
            action.add(new Component[]{this.d});
            action.add(new Component[]{tableRemoveButton});
            wrapper.add(new Component[]{action});
            wrapper.setHorizontalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{action});
        } else if (violation.getType().equals("Rows")) {
            Span directions = new Span(this.b.getMessage("You are allowed to reset the row replication statistics three times per year.", new Object[0]));
            directions.setWidthFull();
            directions.addClassName("violation-direction");
            wrapper.add(new Component[]{directions});
            this.g = new Button(this.b.getMessage("Reset Statistics", new Object[0]));
            wrapper.add(new Component[]{this.g});
            wrapper.setHorizontalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{this.g});
            IContextService contextService = this.b.getSymmetricEngine().getContextService();
            String statResetJson = contextService.getString("stat.reset");
            if (statResetJson != null) {
                List<LocalDate> statResetDates = this.a(statResetJson);
                ArrayList<LocalDate> updatedStatResetDates = new ArrayList<LocalDate>();
                LocalDate oneYearAgo = LocalDate.now();
                oneYearAgo = oneYearAgo.minusYears(1L);
                for (LocalDate date : statResetDates) {
                    if (!date.isAfter(oneYearAgo) && !date.isEqual(oneYearAgo)) continue;
                    updatedStatResetDates.add(date);
                }
                contextService.save("stat.reset", this.a(updatedStatResetDates));
                if (updatedStatResetDates.size() >= 3) {
                    this.g.setEnabled(false);
                    this.g.getElement().setAttribute("title", this.b.getMessage("You have already reset the statistics three times in the past year.", new Object[0]));
                } else {
                    this.a();
                }
            } else {
                this.a();
            }
        } else if (violation.getType().equals("Groups")) {
            List nodeGroups = this.b.getSymmetricEngine().getConfigurationService().getNodeGroups();
            this.f = this.b.getSymmetricEngine().getConfigurationService().getNodeGroupLinks(false);
            this.e = new Select();
            this.e.setItems((Collection)nodeGroups);
            Button groupRemoveButton = new Button("Delete");
            groupRemoveButton.addClickListener((ComponentEventListener & Serializable)event -> {
                try {
                    NodeGroup deleteGroup = (NodeGroup)this.e.getValue();
                    ArrayList deleteRouters = new ArrayList();
                    String groupId = deleteGroup.getNodeGroupId();
                    ArrayList<NodeGroupLink> deleteLinks = new ArrayList<NodeGroupLink>();
                    for (NodeGroupLink link : this.f) {
                        if (!link.getSourceNodeGroupId().equals(groupId) && !link.getTargetNodeGroupId().equals(groupId)) continue;
                        deleteLinks.add(link);
                        deleteRouters.addAll(this.b.getSymmetricEngine().getTriggerRouterService().getRoutersByGroupLink(link));
                    }
                    for (Router router : deleteRouters) {
                        this.b.getSymmetricEngine().getTriggerRouterService().deleteRouter(router);
                    }
                    for (NodeGroupLink link : deleteLinks) {
                        this.b.getSymmetricEngine().getConfigurationService().deleteNodeGroupLink(link);
                    }
                    this.b.getSymmetricEngine().getConfigurationService().deleteNodeGroup(groupId);
                    this.b.logout();
                }
                catch (Exception ex2) {
                    this.a.error("", (Throwable)ex2);
                    CommonUiUtils.notify((String)"Error", (String)"Failed to remove group link.  Please check the log file for details.");
                }
            });
            HorizontalLayout action = new HorizontalLayout();
            Span directions = new Span("Please remove some groups to continue. This will also delete the associated group links and routers");
            directions.setWidthFull();
            directions.addClassName("violation-direction");
            wrapper.add(new Component[]{directions});
            action.setSpacing(true);
            action.add(new Component[]{this.e});
            action.add(new Component[]{groupRemoveButton});
            wrapper.add(new Component[]{action});
            wrapper.setHorizontalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{action});
        }
        return wrapper;
    }

    private void a() {
        this.g.addClickListener((ComponentEventListener & Serializable)event -> {
            ((IThroughputStatisticManager)this.b.getSymmetricEngine().getStatisticManager()).deleteStats(DateUtils.addDays((Date)new Date(), (int)-1), new Date(), this.b.getSymmetricEngine().getNodeId());
            IContextService contextService = this.b.getSymmetricEngine().getContextService();
            String statResetJson = contextService.getString("stat.reset");
            List<LocalDate> statResetDates = statResetJson != null ? this.a(statResetJson) : new ArrayList<LocalDate>();
            statResetDates.add(LocalDate.now());
            contextService.save("stat.reset", this.a(statResetDates));
            String nodeId = this.b.getSymmetricEngine().getNodeId();
            this.b.getConsoleEventService().addEvent(new ConsoleEvent(this.b.getConsoleUser().getUserId(), "Reset Row Statistics", nodeId, nodeId, null, null));
            this.a.info("The row replication statistics have been reset");
            this.b.logout();
        });
    }

    private String a(List<LocalDate> listLocalDate) {
        Gson gson = new GsonBuilder().registerTypeAdapter(LocalDate.class, (Object)new a().nullSafe()).create();
        return gson.toJson(listLocalDate);
    }

    private List<LocalDate> a(String jsonString) {
        Gson gson = new GsonBuilder().registerTypeAdapter(LocalDate.class, (Object)new a().nullSafe()).create();
        Type listOfDatesType = new TypeToken<List<LocalDate>>(){}.getType();
        return (List)gson.fromJson(jsonString, listOfDatesType);
    }

    @Override
    public void onRefresh(Object ... params) {
    }

    @Override
    public boolean onExit(Runnable exitClosure) {
        return false;
    }

    @Override
    public void applicationClosing() {
    }

    @Override
    public String getDocAnchor() {
        return null;
    }

    @Override
    public String getTitleKey() {
        return "License Violation";
    }

    private static /* synthetic */ Object a(SerializedLambda lambda) {
        switch (lambda.getImplMethodName()) {
            case "lambda$addViolation$3f2690a4$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/ViolationEditPanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                return (ComponentEventListener & Serializable)event -> {
                    Node node = this.b.getSymmetricEngine((String)this.c.getValue()).getNodeService().getCachedIdentity();
                    this.b.getSymmetricEngine().getNodeService().findAllNodes();
                    try {
                        SymmetricEngineHolder engineHolder = this.b.getSymmetricEngineHolder();
                        for (ISymmetricEngine engine : this.b.getSymmetricEngines()) {
                            Node identity = engine.getNodeService().getCachedIdentity();
                            if ((identity != null || !StringUtils.isBlank((CharSequence)node.getNodeId())) && !identity.equals((Object)node)) continue;
                            engineHolder.uninstallEngine(engine);
                            this.b.logout();
                            break;
                        }
                    }
                    catch (Exception ex2) {
                        this.a.error("", (Throwable)ex2);
                        CommonUiUtils.notify((String)"Error", (String)"Failed to uninstall.  Please check the log file for details.");
                    }
                };
            }
            case "lambda$addViolation$3f2690a4$2": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/ViolationEditPanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                return (ComponentEventListener & Serializable)event -> {
                    try {
                        this.b.getSymmetricEngine().getTriggerRouterService().deleteTriggerRouter((TriggerRouter)this.d.getValue());
                        this.b.logout();
                    }
                    catch (Exception ex2) {
                        this.a.error("", (Throwable)ex2);
                        CommonUiUtils.notify((String)"Error", (String)"Failed to remove table from replication.  Please check the log file for details.");
                    }
                };
            }
            case "lambda$addViolation$3f2690a4$3": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/ViolationEditPanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                return (ComponentEventListener & Serializable)event -> {
                    try {
                        NodeGroup deleteGroup = (NodeGroup)this.e.getValue();
                        ArrayList deleteRouters = new ArrayList();
                        String groupId = deleteGroup.getNodeGroupId();
                        ArrayList<NodeGroupLink> deleteLinks = new ArrayList<NodeGroupLink>();
                        for (NodeGroupLink link : this.f) {
                            if (!link.getSourceNodeGroupId().equals(groupId) && !link.getTargetNodeGroupId().equals(groupId)) continue;
                            deleteLinks.add(link);
                            deleteRouters.addAll(this.b.getSymmetricEngine().getTriggerRouterService().getRoutersByGroupLink(link));
                        }
                        for (Router router : deleteRouters) {
                            this.b.getSymmetricEngine().getTriggerRouterService().deleteRouter(router);
                        }
                        for (NodeGroupLink link : deleteLinks) {
                            this.b.getSymmetricEngine().getConfigurationService().deleteNodeGroupLink(link);
                        }
                        this.b.getSymmetricEngine().getConfigurationService().deleteNodeGroup(groupId);
                        this.b.logout();
                    }
                    catch (Exception ex2) {
                        this.a.error("", (Throwable)ex2);
                        CommonUiUtils.notify((String)"Error", (String)"Failed to remove group link.  Please check the log file for details.");
                    }
                };
            }
            case "lambda$setupResetButton$9b1b5227$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/ViolationEditPanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                return (ComponentEventListener & Serializable)event -> {
                    ((IThroughputStatisticManager)this.b.getSymmetricEngine().getStatisticManager()).deleteStats(DateUtils.addDays((Date)new Date(), (int)-1), new Date(), this.b.getSymmetricEngine().getNodeId());
                    IContextService contextService = this.b.getSymmetricEngine().getContextService();
                    String statResetJson = contextService.getString("stat.reset");
                    List<LocalDate> statResetDates = statResetJson != null ? this.a(statResetJson) : new ArrayList<LocalDate>();
                    statResetDates.add(LocalDate.now());
                    contextService.save("stat.reset", this.a(statResetDates));
                    String nodeId = this.b.getSymmetricEngine().getNodeId();
                    this.b.getConsoleEventService().addEvent(new ConsoleEvent(this.b.getConsoleUser().getUserId(), "Reset Row Statistics", nodeId, nodeId, null, null));
                    this.a.info("The row replication statistics have been reset");
                    this.b.logout();
                };
            }
        }
        throw new IllegalArgumentException("Invalid lambda deserialization");
    }

    private final class a
    extends TypeAdapter<LocalDate> {
        private a() {
        }

        public void a(JsonWriter jsonWriter, LocalDate localDate) throws IOException {
            jsonWriter.beginObject().name("year").value((long)localDate.getYear()).name("month").value((long)localDate.getMonthValue()).name("day").value((long)localDate.getDayOfMonth()).endObject();
        }

        public LocalDate a(JsonReader jsonReader) throws IOException {
            jsonReader.beginObject();
            jsonReader.nextName();
            int year = jsonReader.nextInt();
            jsonReader.nextName();
            int month = jsonReader.nextInt();
            jsonReader.nextName();
            int day = jsonReader.nextInt();
            jsonReader.endObject();
            return LocalDate.of(year, month, day);
        }

        public /* synthetic */ Object read(JsonReader jsonReader) throws IOException {
            return this.a(jsonReader);
        }

        public /* synthetic */ void write(JsonWriter jsonWriter, Object object) throws IOException {
            this.a(jsonWriter, (LocalDate)object);
        }
    }
}

