/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.impl.R;
import com.jumpmind.symmetric.console.model.TableGroup;
import com.jumpmind.symmetric.console.model.TableGroupHier;
import com.jumpmind.symmetric.console.service.ITableGroupService;
import com.jumpmind.symmetric.console.ui.common.I;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.select.Select;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.ValidationException;
import com.vaadin.flow.function.SerializablePredicate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;

public class an
extends R<TableGroupHier> {
    private static final long serialVersionUID = 1L;
    private Map<String, TableGroup> tableGroupMap;
    private Select<String> parentId;
    private Select<TableGroupHier.RelationType> relationType;
    private String originalId;
    private boolean requireRelationType;

    public an(I controller, Set<TableGroupHier> itemSet, boolean newItemFlag, boolean deleteFlag) {
        super(controller, itemSet, newItemFlag, deleteFlag);
    }

    @Override
    public void initFields() {
        if (!this.newItemFlag && !this.isBulk) {
            this.originalId = ((TableGroupHier)this.itemSet.iterator().next()).getId();
        }
        this.binder = new Binder(TableGroupHier.class);
        TextField id = new TextField();
        id.setId("id");
        this.binder.forField((HasValue)id).withValidator((SerializablePredicate & Serializable)value -> !StringUtils.isBlank((CharSequence)value) || this.isBulk, this.controller.getMessage("%s is required.", "Table Group Hierarchy Id")).bind("id");
        id.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a((HasValue<?, ?>)id, this.controller.getMessage("Table Group Hierarchy Id", new Object[0])));
        ITableGroupService tableGroupService = this.controller.getTableGroupService();
        List<TableGroup> tableGroupList = tableGroupService.getTableGroups(true);
        ArrayList<String> tableGroupIdList = new ArrayList<String>();
        this.tableGroupMap = new HashMap<String, TableGroup>();
        for (TableGroup group : tableGroupList) {
            tableGroupIdList.add(group.getId());
            this.tableGroupMap.put(group.getId(), group);
        }
        tableGroupIdList.sort(String.CASE_INSENSITIVE_ORDER);
        Select tableGroupId = new Select();
        tableGroupId.setItems(tableGroupIdList);
        tableGroupId.setId("tableGroupId");
        tableGroupId.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.tableGroupIdChanged((String)event.getValue()));
        this.binder.forField((HasValue)tableGroupId).withValidator((SerializablePredicate & Serializable)value -> value != null || this.isBulk, this.controller.getMessage("%s is required.", "Table Group Id")).bind("tableGroupId");
        tableGroupId.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a((HasValue<?, ?>)tableGroupId, this.controller.getMessage("Table Group Id", new Object[0])));
        TextField sourceCatalogName = new TextField();
        sourceCatalogName.setId("sourceCatalogName");
        this.binder.forField((HasValue)sourceCatalogName).bind("sourceCatalogName");
        this.fieldList.add(new R.a((HasValue<?, ?>)sourceCatalogName, this.controller.getMessage("Source Catalog", new Object[0])));
        TextField sourceSchemaName = new TextField();
        sourceSchemaName.setId("sourceSchemaName");
        this.binder.forField((HasValue)sourceSchemaName).bind("sourceSchemaName");
        this.fieldList.add(new R.a((HasValue<?, ?>)sourceSchemaName, this.controller.getMessage("Source Schema", new Object[0])));
        TextField sourceTableName = new TextField();
        sourceTableName.setId("sourceTableName");
        this.binder.forField((HasValue)sourceTableName).withValidator((SerializablePredicate & Serializable)value -> !value.equals(sourceTableName.getEmptyValue()) || this.isBulk, this.controller.getMessage("%s is required.", "Source Table")).bind("sourceTableName");
        sourceTableName.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a((HasValue<?, ?>)sourceTableName, this.controller.getMessage("Source Table", new Object[0])));
        this.parentId = new Select();
        this.parentId.setId("parentId");
        this.parentId.setEmptySelectionAllowed(true);
        this.binder.forField(this.parentId).bind("parentId");
        this.fieldList.add(new R.a((HasValue<?, ?>)this.parentId, this.controller.getMessage("Parent Id", new Object[0])));
        this.relationType = new Select();
        this.relationType.setItems((Object[])TableGroupHier.RelationType.values());
        this.relationType.setId("relationType");
        this.relationType.setEmptySelectionAllowed(true);
        this.binder.forField(this.relationType).withValidator((SerializablePredicate & Serializable)value -> value != null || !this.requireRelationType, this.controller.getMessage("Relation Type is required when the table group has a non-default writer type.", new Object[0])).bind("relationType");
        this.fieldList.add(new R.a((HasValue<?, ?>)this.relationType, this.controller.getMessage("Relation Type", new Object[0])));
        TextField primaryColumnNames = new TextField();
        primaryColumnNames.setId("primaryColumnNames");
        this.binder.forField((HasValue)primaryColumnNames).withValidator((SerializablePredicate & Serializable)value -> !value.equals(primaryColumnNames.getEmptyValue()) || this.isBulk, this.controller.getMessage("%s is required.", "Primary Column Names")).bind("primaryColumnNames");
        primaryColumnNames.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a((HasValue<?, ?>)primaryColumnNames, this.controller.getMessage("Primary Column Names", new Object[0])));
        TextField localColumnNames = new TextField();
        localColumnNames.setId("localColumnNames");
        this.binder.forField((HasValue)localColumnNames).bind("localColumnNames");
        this.fieldList.add(new R.a((HasValue<?, ?>)localColumnNames, this.controller.getMessage("Local Column Names", new Object[0])));
        TextField parentColumnNames = new TextField();
        parentColumnNames.setId("parentColumnNames");
        this.binder.forField((HasValue)parentColumnNames).bind("parentColumnNames");
        this.fieldList.add(new R.a((HasValue<?, ?>)parentColumnNames, this.controller.getMessage("Parent Column Names", new Object[0])));
    }

    @Override
    protected void generateNewItem() {
        this.newItem = new TableGroupHier();
    }

    @Override
    public boolean save(boolean saveAsCopy) {
        if (this.binder.validate().isOk()) {
            ITableGroupService tableGroupService = this.controller.getTableGroupService();
            if (!this.isBulk) {
                TableGroupHier hier;
                if (!this.newItemFlag) {
                    try {
                        if (saveAsCopy) {
                            if (this.newItem == null) {
                                this.generateNewItem();
                            }
                            this.binder.writeBean((Object)((TableGroupHier)this.newItem));
                        } else {
                            this.binder.writeBean((Object)((TableGroupHier)this.itemSet.iterator().next()));
                        }
                    }
                    catch (ValidationException e2) {
                        CommonUiUtils.notify((String)"Failed to write to bean");
                    }
                    hier = saveAsCopy ? (TableGroupHier)this.newItem : (TableGroupHier)this.itemSet.iterator().next();
                    hier.setLastUpdateBy(this.controller.getConsoleUser().getUserId());
                    if (saveAsCopy) {
                        tableGroupService.saveTableGroupHierAsCopy(this.originalId, hier);
                    } else if (this.originalId == null || this.originalId.equals(hier.getId())) {
                        tableGroupService.saveTableGroupHier(hier);
                    } else {
                        tableGroupService.renameTableGroupHier(this.originalId, hier);
                    }
                } else {
                    try {
                        this.binder.writeBean((Object)((TableGroupHier)this.newItem));
                    }
                    catch (ValidationException e3) {
                        CommonUiUtils.notify((String)"Failed to write to bean");
                    }
                    hier = (TableGroupHier)this.newItem;
                    hier.setLastUpdateBy(this.controller.getConsoleUser().getUserId());
                    hier.setCreateBy(this.controller.getConsoleUser().getUserId());
                    tableGroupService.saveTableGroupHier(hier);
                }
                this.addEvent(this.newItemFlag ? "Table Group Hier Created" : "Table Group Hier Modified", hier.getId());
            } else {
                for (TableGroupHier hier : this.itemSet) {
                    this.saveFieldsToTableGroupHier(hier);
                    hier.setLastUpdateBy(this.controller.getConsoleUser().getUserId());
                    tableGroupService.saveTableGroupHier(hier);
                }
                this.addEvent("Table Group Hier Modified", this.itemSet.stream().map(TableGroupHier::getId).collect(Collectors.toSet()));
            }
            if (this.formListener != null) {
                this.formListener.formSaved();
            }
            return true;
        }
        return false;
    }

    protected void saveFieldsToTableGroupHier(TableGroupHier hier) {
        for (R.a formField : this.fieldList) {
            HasValue<?, ?> field = formField.getField();
            Checkbox checkbox = formField.getCheckbox();
            if (checkbox == null || !((Boolean)checkbox.getValue()).booleanValue() || !(field instanceof Component)) continue;
            switch (((Component)field).getId().orElse("")) {
                case "tableGroupId": {
                    hier.setTableGroupId((String)field.getValue());
                    break;
                }
                case "sourceCatalogName": {
                    hier.setSourceCatalogName((String)field.getValue());
                    break;
                }
                case "sourceSchemaName": {
                    hier.setSourceSchemaName((String)field.getValue());
                    break;
                }
                case "sourceTableName": {
                    hier.setSourceTableName((String)field.getValue());
                    break;
                }
                case "parentId": {
                    hier.setParentId((String)field.getValue());
                    break;
                }
                case "relationType": {
                    hier.setRelationType((TableGroupHier.RelationType)((Object)field.getValue()));
                    break;
                }
                case "primaryColumnNames": {
                    hier.setPrimaryColumnNames((String)field.getValue());
                    break;
                }
                case "localColumnNames": {
                    hier.setLocalColumnNames((String)field.getValue());
                    break;
                }
                case "parentColumnNames": {
                    hier.setParentColumnNames((String)field.getValue());
                }
            }
        }
    }

    @Override
    public void delete() {
        for (TableGroupHier hier : this.itemSet) {
            this.controller.getTableGroupService().deleteTableGroupHier(hier.getId());
        }
        this.addEvent("Table Group Hier Deleted", this.itemSet.stream().map(TableGroupHier::getId).collect(Collectors.toSet()));
        if (this.formListener != null) {
            this.formListener.formDeleted();
        }
    }

    private void tableGroupIdChanged(String id) {
        ArrayList<String> hierIdList = new ArrayList<String>();
        if (id != null) {
            for (TableGroupHier hier : this.controller.getTableGroupService().getTableGroupHiersByTableGroupId(id, false)) {
                hierIdList.add(hier.getId());
            }
            hierIdList.sort(String.CASE_INSENSITIVE_ORDER);
        }
        if (!hierIdList.contains(this.parentId.getValue())) {
            this.parentId.clear();
        }
        this.parentId.setItems(hierIdList);
        TableGroup group = this.tableGroupMap.get(id);
        this.requireRelationType = group != null && group.getWriterType() != null && !group.getWriterType().equals((Object)TableGroup.WriterType.DEFAULT);
        this.relationType.setRequiredIndicatorVisible(this.requireRelationType);
        this.relationType.setEmptySelectionAllowed(!this.requireRelationType);
    }

    @Override
    protected List<String> getOrderedFieldIds() {
        ArrayList<String> orderedFields = new ArrayList<String>();
        orderedFields.add("id");
        orderedFields.add("tableGroupId");
        orderedFields.add("sourceCatalogName");
        orderedFields.add("sourceSchemaName");
        orderedFields.add("sourceTableName");
        orderedFields.add("parentId");
        orderedFields.add("relationType");
        orderedFields.add("primaryColumnNames");
        orderedFields.add("localColumnNames");
        orderedFields.add("parentColumnNames");
        return orderedFields;
    }

    @Override
    public String getKeyId() {
        return "id";
    }

    @Override
    public String getHelpSectionName() {
        return "_table_group_hiers";
    }
}

