/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.impl.R;
import com.jumpmind.symmetric.console.ui.common.I;
import com.jumpmind.symmetric.console.ui.common.af;
import com.jumpmind.symmetric.console.ui.common.ag;
import com.jumpmind.symmetric.console.ui.common.an;
import com.jumpmind.symmetric.console.ui.common.as;
import com.jumpmind.symmetric.console.ui.common.f;
import com.jumpmind.symmetric.console.ui.common.l;
import com.vaadin.flow.component.BlurNotifier;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.FocusNotifier;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.contextmenu.MenuItem;
import com.vaadin.flow.component.contextmenu.SubMenu;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.editor.EditorSaveListener;
import com.vaadin.flow.component.html.NativeLabel;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.menubar.MenuBar;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.page.Page;
import com.vaadin.flow.component.select.Select;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.ValidationException;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.selection.SelectionListener;
import com.vaadin.flow.function.SerializablePredicate;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.SyntaxParsingException;
import org.jumpmind.symmetric.model.ColumnMatchExpression;
import org.jumpmind.symmetric.model.DataMetaData;
import org.jumpmind.symmetric.model.NodeGroupLink;
import org.jumpmind.symmetric.model.Router;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.route.IDataRouter;
import org.jumpmind.symmetric.route.JavaDataRouter;
import org.jumpmind.symmetric.route.LookupTableDataRouter;
import org.jumpmind.symmetric.route.SimpleRouterContext;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.IRouterService;
import org.jumpmind.symmetric.service.ITriggerRouterService;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;
import org.slf4j.Logger;

public class ak
extends R<Router> {
    private static final long serialVersionUID = 1L;
    Select<String> routerType;
    Select<String> routerTargetCatalog;
    TextField targetCatalogName;
    Select<String> routerTargetSchema;
    TextField targetSchemaName;
    Select<String> routerTargetTable;
    Select<NodeGroupLink> nodeGroupLink;
    String originalId;

    public ak(I controller, Set<Router> itemSet, boolean newItemFlag, boolean deleteFlag) {
        super(controller, itemSet, newItemFlag, deleteFlag);
    }

    @Override
    public void initFields() {
        if (!this.newItemFlag && !this.isBulk) {
            this.originalId = ((Router)this.itemSet.iterator().next()).getRouterId();
        }
        this.binder = new Binder(Router.class);
        TextField routerId = new TextField();
        routerId.setId("routerId");
        routerId.setClassName("input-long");
        this.binder.forField((HasValue)routerId).withValidator((SerializablePredicate & Serializable)value -> !StringUtils.isBlank((CharSequence)value) || this.isBulk, this.controller.getMessage("%s is required.", "Router Id")).bind("routerId");
        routerId.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a((HasValue<?, ?>)routerId, this.controller.getMessage("Router Id", new Object[0])));
        IConfigurationService configService = this.controller.getSymmetricEngine().getConfigurationService();
        this.nodeGroupLink = new Select();
        this.nodeGroupLink.setItems((Collection)configService.getNodeGroupLinks(false));
        this.nodeGroupLink.setId("nodeGroupLink");
        this.formatComboBox(this.nodeGroupLink);
        this.binder.forField(this.nodeGroupLink).withValidator((SerializablePredicate & Serializable)value -> value != null || this.isBulk, this.controller.getMessage("%s is required.", "Group Link")).bind("nodeGroupLink");
        this.nodeGroupLink.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            this.loadTargetCatalogs(this.getTargetCatalogs());
            this.loadTargetSchemas(this.getTargetSchemas());
            this.loadTargetTables(this.getTargetTables());
        });
        this.nodeGroupLink.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a((HasValue<?, ?>)this.nodeGroupLink, this.controller.getMessage("Group Link", new Object[0])));
        IRouterService routerService = this.controller.getSymmetricEngine().getRouterService();
        Map routerMap = routerService.getRouters();
        ArrayList<String> routerList = new ArrayList<String>();
        for (String routerType : routerMap.keySet()) {
            if (!((IDataRouter)routerMap.get(routerType)).isConfigurable()) continue;
            routerList.add(routerType);
        }
        Collections.sort(routerList);
        this.routerType = new Select();
        this.routerType.setItems(routerList);
        this.routerType.setId("routerType");
        this.formatComboBox(this.routerType);
        this.binder.forField(this.routerType).withValidator((SerializablePredicate & Serializable)value -> value != null || this.isBulk, this.controller.getMessage("%s is required.", "Router Type")).bind("routerType");
        this.routerType.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a((HasValue<?, ?>)this.routerType, this.controller.getMessage("Router Type", new Object[0])));
        TextArea routerExpression = new TextArea();
        routerExpression.setId("routerExpression");
        routerExpression.setWidth("40em");
        routerExpression.setHeight("124px");
        d listener = new d(routerExpression, !this.newItemFlag ? ((Router)this.itemSet.iterator().next()).getRouterId() : null, !this.isBulk && !this.newItemFlag);
        routerExpression.addFocusListener(listener.getFocusListener());
        routerExpression.addBlurListener(listener.getBlurListener());
        routerExpression.setVisible(this.newItemFlag || !this.isBulk && this.typeHasExpression(((Router)this.itemSet.iterator().next()).getRouterType()));
        routerExpression.setRequiredIndicatorVisible(true);
        this.binder.forField((HasValue)routerExpression).withValidator((SerializablePredicate & Serializable)value -> !value.isEmpty() || this.isBulk || !routerExpression.isVisible(), this.controller.getMessage("%s is required.", "Router Expression")).bind("routerExpression");
        R.a routerExpressionField = new R.a((HasValue<?, ?>)routerExpression, this.controller.getMessage("Router Expression", new Object[0]));
        this.fieldList.add(routerExpressionField);
        this.routerType.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            if (this.typeHasExpression((String)event.getValue())) {
                routerExpressionField.setVisible(true);
            } else {
                routerExpression.clear();
                routerExpressionField.setVisible(false);
            }
        });
        Checkbox useSourceCatalogSchema = new Checkbox();
        useSourceCatalogSchema.setId("useSourceCatalogSchema");
        this.binder.forField((HasValue)useSourceCatalogSchema).bind("useSourceCatalogSchema");
        if (!this.isBulk) {
            useSourceCatalogSchema.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                boolean enabled = (Boolean)event.getValue();
                if (this.routerTargetCatalog != null) {
                    if (enabled) {
                        this.routerTargetCatalog.clear();
                    }
                    this.routerTargetCatalog.setEnabled(!enabled);
                }
                if (this.targetCatalogName != null) {
                    if (enabled) {
                        this.targetCatalogName.clear();
                    }
                    this.targetCatalogName.setEnabled(!enabled);
                }
                if (this.routerTargetSchema != null) {
                    if (enabled) {
                        this.routerTargetSchema.clear();
                    }
                    this.routerTargetSchema.setEnabled(!enabled);
                }
                if (this.targetSchemaName != null) {
                    if (enabled) {
                        this.targetSchemaName.clear();
                    }
                    this.targetSchemaName.setEnabled(!enabled);
                }
            });
        }
        this.fieldList.add(new R.a((HasValue<?, ?>)useSourceCatalogSchema, this.controller.getMessage("Use Source Catalog/Schema", new Object[0])));
        List<String> catalogs = this.getTargetCatalogs();
        if (this.isBulk || catalogs == null) {
            this.targetCatalogName = new TextField();
            this.targetCatalogName.setId("targetCatalogName");
            this.targetCatalogName.setClassName("input-long");
            this.binder.forField((HasValue)this.targetCatalogName).bind("targetCatalogName");
            this.fieldList.add(new R.a((HasValue<?, ?>)this.targetCatalogName, this.controller.getMessage("Target Catalog", new Object[0])));
        } else {
            this.loadTargetCatalogs(catalogs);
            this.routerTargetCatalog.setId("targetCatalogName");
            this.binder.forField(this.routerTargetCatalog).bind("targetCatalogName");
            this.fieldList.add(new R.a((HasValue<?, ?>)this.routerTargetCatalog, this.controller.getMessage("Target Catalog", new Object[0])));
        }
        List<String> schemas = this.getTargetSchemas();
        if (this.isBulk || catalogs == null && schemas == null) {
            this.targetSchemaName = new TextField();
            this.targetSchemaName.setId("targetSchemaName");
            this.targetSchemaName.setClassName("input-long");
            this.binder.forField((HasValue)this.targetSchemaName).bind("targetSchemaName");
            this.fieldList.add(new R.a((HasValue<?, ?>)this.targetSchemaName, this.controller.getMessage("Target Schema", new Object[0])));
        } else {
            this.loadTargetSchemas(schemas);
            this.routerTargetSchema.setId("targetSchemaName");
            this.binder.forField(this.routerTargetSchema).bind("targetSchemaName");
            this.fieldList.add(new R.a((HasValue<?, ?>)this.routerTargetSchema, this.controller.getMessage("Target Schema", new Object[0])));
        }
        this.advancedFieldList = new ArrayList();
        if (!this.newItemFlag && !this.itemSet.stream().anyMatch(router -> StringUtils.isBlank((CharSequence)router.getTargetTableName()))) {
            Icon warningIcon = new Icon(VaadinIcon.WARNING);
            warningIcon.setColor("orange");
            warningIcon.addClickListener((ComponentEventListener & Serializable)event -> CommonUiUtils.notify((String)this.controller.getMessage("The \"Target Table\" field is deprecated and will be removed in the future. Use a table transform to rename the table instead.", new Object[0]), opened -> this.formListener.getFormLayout().enableCancelShortcut(opened == false)));
            List<String> tables = this.getTargetTables();
            if (this.isBulk || catalogs == null && schemas == null && tables == null) {
                TextField targetTableName = new TextField();
                targetTableName.setId("targetTableName");
                targetTableName.setClassName("input-long");
                if (this.isBulk) {
                    targetTableName.getStyle().set("padding-left", "16px");
                }
                this.binder.forField((HasValue)targetTableName).bind("targetTableName");
                this.advancedFieldList.add(new R.a((HasValue<?, ?>)targetTableName, this.controller.getMessage("Target Table", new Object[0]), (Component)warningIcon));
            } else {
                this.loadTargetTables(tables);
                this.routerTargetTable.setId("targetTableName");
                this.binder.forField(this.routerTargetTable).bind("targetTableName");
                this.advancedFieldList.add(new R.a((HasValue<?, ?>)this.routerTargetTable, this.controller.getMessage("Target Table", new Object[0]), (Component)warningIcon));
            }
        }
        Checkbox syncOnUpdate = new Checkbox();
        syncOnUpdate.setId("syncOnUpdate");
        this.binder.forField((HasValue)syncOnUpdate).bind("syncOnUpdate");
        syncOnUpdate.setVisible(this.isBulk);
        this.advancedFieldList.add(new R.a((HasValue<?, ?>)syncOnUpdate, this.controller.getMessage("Sync on Update", new Object[0])));
        Checkbox syncOnInsert = new Checkbox();
        syncOnInsert.setId("syncOnInsert");
        this.binder.forField((HasValue)syncOnInsert).bind("syncOnInsert");
        syncOnInsert.setVisible(this.isBulk);
        this.advancedFieldList.add(new R.a((HasValue<?, ?>)syncOnInsert, this.controller.getMessage("Sync on Insert", new Object[0])));
        Checkbox syncOnDelete = new Checkbox();
        syncOnDelete.setId("syncOnDelete");
        this.binder.forField((HasValue)syncOnDelete).bind("syncOnDelete");
        syncOnDelete.setVisible(this.isBulk);
        this.advancedFieldList.add(new R.a((HasValue<?, ?>)syncOnDelete, this.controller.getMessage("Sync on Delete", new Object[0])));
    }

    protected boolean typeHasExpression(String type) {
        return !"audit".equals(type) && !"csv".equals(type) && !"default".equals(type) && !"tps".equals(type) && !"dbf".equals(type);
    }

    protected List<String> getTargetCatalogs() {
        try {
            if (this.controller.getSymmetricEngine().getParameterService().is("console.remote.meta.data", false)) {
                NodeGroupLink link = (NodeGroupLink)this.nodeGroupLink.getValue();
                List<String> catalogList = this.controller.getCatalogs(link.getTargetNodeGroupId());
                catalogList.removeIf(Objects::isNull);
                return catalogList;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected List<String> getTargetSchemas() {
        try {
            if (this.controller.getSymmetricEngine().getParameterService().is("console.remote.meta.data", false) && this.routerTargetCatalog != null && this.routerTargetCatalog.getValue() != null) {
                NodeGroupLink link = (NodeGroupLink)this.nodeGroupLink.getValue();
                List<String> schemaList = this.controller.getSchemas(link.getTargetNodeGroupId(), (String)this.routerTargetCatalog.getValue());
                schemaList.removeIf(Objects::isNull);
                return schemaList;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected List<String> getTargetTables() {
        try {
            if (this.controller.getSymmetricEngine().getParameterService().is("console.remote.meta.data", false) && this.routerTargetCatalog != null && this.routerTargetCatalog.getValue() != null && this.routerTargetSchema != null && this.routerTargetSchema.getValue() != null) {
                NodeGroupLink link = (NodeGroupLink)this.nodeGroupLink.getValue();
                List<String> tableList = this.controller.getTables(link.getTargetNodeGroupId(), (String)this.routerTargetCatalog.getValue(), (String)this.routerTargetSchema.getValue());
                tableList.removeIf(Objects::isNull);
                return tableList;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected void loadTargetCatalogs(List<String> catalogs) {
        if (this.routerTargetCatalog == null) {
            this.routerTargetCatalog = new Select();
        }
        if (catalogs == null) {
            catalogs = new ArrayList<String>();
        }
        catalogs.add(0, "");
        this.routerTargetCatalog.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            this.loadTargetSchemas(this.getTargetSchemas());
            this.loadTargetTables(this.getTargetTables());
        });
        this.routerTargetCatalog.setItems(catalogs);
    }

    protected void loadTargetSchemas(List<String> schemas) {
        if (this.routerTargetSchema == null) {
            this.routerTargetSchema = new Select();
        }
        if (schemas == null) {
            schemas = new ArrayList<String>();
        }
        schemas.add(0, "");
        this.routerTargetSchema.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.loadTargetTables(this.getTargetTables()));
        this.routerTargetSchema.setItems(schemas);
    }

    protected void loadTargetTables(List<String> tables) {
        if (this.routerTargetTable == null) {
            this.routerTargetTable = new Select();
        }
        if (tables == null) {
            tables = new ArrayList<String>();
        }
        tables.add(0, "");
        this.routerTargetTable.setItems(tables);
    }

    @Override
    protected void generateNewItem() {
        Router router = new Router();
        router.setRouterId("");
        router.setCreateTime(new Date());
        router.setLastUpdateTime(new Date());
        router.setLastUpdateBy(this.controller.getConsoleUser().getUserId());
        this.newItem = router;
    }

    @Override
    public boolean save(boolean saveAsCopy) {
        if (this.binder.validate().isOk()) {
            ITriggerRouterService triggerRouterService = this.controller.getSymmetricEngine().getTriggerRouterService();
            if (!this.isBulk) {
                Router router;
                if (!this.newItemFlag) {
                    try {
                        if (saveAsCopy) {
                            if (this.newItem == null) {
                                this.generateNewItem();
                            }
                            this.binder.writeBean((Object)((Router)this.newItem));
                        } else {
                            this.binder.writeBean((Object)((Router)this.itemSet.iterator().next()));
                        }
                    }
                    catch (ValidationException e2) {
                        CommonUiUtils.notify((String)"Failed to write to bean");
                    }
                    router = saveAsCopy ? (Router)this.newItem : (Router)this.itemSet.iterator().next();
                    router.setLastUpdateBy(this.controller.getConsoleUser().getUserId());
                    router.setLastUpdateTime(new Date());
                    if (saveAsCopy) {
                        triggerRouterService.saveRouterAsCopy(router);
                    } else if (this.originalId == null || this.originalId.equals(router.getRouterId())) {
                        triggerRouterService.saveRouter(router);
                    } else {
                        triggerRouterService.renameRouter(this.originalId, router);
                    }
                } else {
                    try {
                        this.binder.writeBean((Object)((Router)this.newItem));
                    }
                    catch (ValidationException e3) {
                        CommonUiUtils.notify((String)"Failed to write to bean");
                    }
                    router = (Router)this.newItem;
                    router.setLastUpdateBy(this.controller.getConsoleUser().getUserId());
                    router.setLastUpdateTime(new Date());
                    triggerRouterService.saveRouter(router);
                }
                this.addEvent(this.newItemFlag ? "Router Created" : "Router Modified", router.getRouterId());
            } else {
                for (Router router : this.itemSet) {
                    this.saveFieldsToRouter(this.fieldList, router);
                    this.saveFieldsToRouter(this.advancedFieldList, router);
                    router.setLastUpdateBy(this.controller.getConsoleUser().getUserId());
                    router.setLastUpdateTime(new Date());
                    triggerRouterService.saveRouter(router);
                }
                this.addEvent("Router Modified", this.itemSet.stream().map(Router::getRouterId).collect(Collectors.toSet()));
            }
            if (this.formListener != null) {
                this.formListener.formSaved();
            }
            return true;
        }
        return false;
    }

    private void saveFieldsToRouter(List<R.a> fields, Router router) {
        for (R.a formField : fields) {
            HasValue<?, ?> field = formField.getField();
            Checkbox checkbox = formField.getCheckbox();
            if (checkbox == null || !((Boolean)checkbox.getValue()).booleanValue() || !(field instanceof Component)) continue;
            switch (((Component)field).getId().orElse("")) {
                case "nodeGroupLink": {
                    router.setNodeGroupLink((NodeGroupLink)field.getValue());
                    break;
                }
                case "routerType": {
                    router.setRouterType((String)field.getValue());
                    break;
                }
                case "routerExpression": {
                    router.setRouterExpression((String)field.getValue());
                    break;
                }
                case "useSourceCatalogSchema": {
                    router.setUseSourceCatalogSchema(((Boolean)field.getValue()).booleanValue());
                    break;
                }
                case "targetCatalogName": {
                    router.setTargetCatalogName((String)field.getValue());
                    break;
                }
                case "targetSchemaName": {
                    router.setTargetSchemaName((String)field.getValue());
                    break;
                }
                case "targetTableName": {
                    router.setTargetTableName((String)field.getValue());
                    break;
                }
                case "syncOnUpdate": {
                    router.setSyncOnUpdate(((Boolean)field.getValue()).booleanValue());
                    break;
                }
                case "syncOnInsert": {
                    router.setSyncOnInsert(((Boolean)field.getValue()).booleanValue());
                    break;
                }
                case "syncOnDelete": {
                    router.setSyncOnDelete(((Boolean)field.getValue()).booleanValue());
                }
            }
        }
    }

    @Override
    public void delete() {
        ITriggerRouterService triggerRouterService = this.controller.getSymmetricEngine().getTriggerRouterService();
        for (Router router : this.itemSet) {
            triggerRouterService.deleteRouter(router);
        }
        this.addEvent("Router Deleted", this.itemSet.stream().map(Router::getRouterId).collect(Collectors.toSet()));
        if (this.formListener != null) {
            this.formListener.formDeleted();
        }
    }

    @Override
    protected List<String> getOrderedFieldIds() {
        ArrayList<String> orderedFields = new ArrayList<String>();
        orderedFields.add("routerId");
        orderedFields.add("nodeGroupLink");
        orderedFields.add("routerType");
        orderedFields.add("routerExpression");
        if (this.isBulk) {
            orderedFields.add("syncOnUpdate");
            orderedFields.add("syncOnInsert");
            orderedFields.add("syncOnDelete");
        } else {
            orderedFields.add("useSourceCatalogSchema");
        }
        orderedFields.add("targetCatalogName");
        orderedFields.add("targetSchemaName");
        if (this.isBulk) {
            orderedFields.add("useSourceCatalogSchema");
        }
        orderedFields.add("targetTableName");
        if (!this.isBulk) {
            orderedFields.add("syncOnUpdate");
            orderedFields.add("syncOnInsert");
            orderedFields.add("syncOnDelete");
        }
        return orderedFields;
    }

    @Override
    public String getKeyId() {
        return "routerId";
    }

    @Override
    public String getHelpSectionName() {
        return "_routers";
    }

    class d {
        ComponentEventListener<FocusNotifier.FocusEvent<TextArea>> focusListener;
        ComponentEventListener<BlurNotifier.BlurEvent<TextArea>> blurListener;
        TextArea field;
        Dialog dialog;
        boolean showing = false;
        String routerId;
        boolean showColumnNames;

        public d(TextArea field, String routerId, boolean showColumnNames) {
            this.field = field;
            this.routerId = routerId;
            this.showColumnNames = showColumnNames;
            this.focusListener = (ComponentEventListener & Serializable)event -> {
                if (!this.showing) {
                    String type = (String)ak.this.routerType.getValue();
                    if ("column".equals(type)) {
                        this.showing = true;
                        this.dialog = new a(field);
                    } else if ("bsh".equals(type)) {
                        this.showing = true;
                        this.dialog = new af("Configure Bean Shell Router Expression", "The Bean Shell router uses the Bean Shell scripting language to determine if and where data should be routed.", (HasValue<?, String>)field, ak.this.controller, routerId, showColumnNames);
                    } else if ("java".equals(type)) {
                        this.showing = true;
                        this.dialog = new b(field);
                    } else if ("lookuptable".equals(type)) {
                        this.showing = true;
                        this.dialog = new c(field);
                    } else if ("subselect".equals(type)) {
                        this.showing = true;
                        this.dialog = new ag("Configure Subselect Router Expression", "select c.node_id from sym_node c where c.node_group_id = :NODE_GROUP_ID and c.enabled = 1 and", (HasValue<?, String>)field, ak.this.controller, routerId, showColumnNames);
                    }
                    if (this.dialog != null) {
                        this.dialog.open();
                    }
                }
            };
            this.blurListener = (ComponentEventListener & Serializable)event -> {
                if (this.dialog == null || !this.dialog.isOpened()) {
                    this.showing = false;
                }
            };
        }

        public ComponentEventListener<FocusNotifier.FocusEvent<TextArea>> getFocusListener() {
            return this.focusListener;
        }

        public ComponentEventListener<BlurNotifier.BlurEvent<TextArea>> getBlurListener() {
            return this.blurListener;
        }
    }

    class c
    extends an {
        private static final long serialVersionUID = 1L;
        private TextArea textField;
        private final TextArea formField;
        private VerticalLayout builderLayout;
        private VerticalLayout textLayout;
        private Map<String, TextField> formFields;
        private Binder<a> lookupBinder;

        public c(TextArea formField) {
            super(ak.this.controller, "Configure Lookup Table Router Expression", null, false, (Object[])null);
            this.setWidth("800px");
            this.setHeight("620px");
            this.formField = formField;
            this.addOpenedChangeListener((ComponentEventListener & Serializable)event -> ak.this.formListener.getFormLayout().enableCancelShortcut(!event.isOpened()));
            this.fieldLayout.setHeight("510px");
            this.cancelButton.setVisible(true);
            String value = formField.getValue();
            if (!value.equals(formField.getEmptyValue())) {
                this.textField.setValue(value);
                if (this.validateTextField()) {
                    this.setTableExpression(value);
                } else {
                    this.builderLayout.setVisible(false);
                    this.textLayout.setVisible(true);
                }
            }
        }

        private String getTableExpression() {
            Object tableExpression = String.format("%s=%s\r\n%s=%s\r\n%s=%s\r\n%s=%s", "LOOKUP_TABLE", this.formFields.get("LOOKUP_TABLE").getValue(), "KEY_COLUMN", this.formFields.get("KEY_COLUMN").getValue(), "LOOKUP_KEY_COLUMN", this.formFields.get("LOOKUP_KEY_COLUMN").getValue(), "EXTERNAL_ID_COLUMN", this.formFields.get("EXTERNAL_ID_COLUMN").getValue());
            if (!StringUtils.isEmpty((CharSequence)this.formFields.get("ALL_NODES_VALUE").getValue())) {
                tableExpression = (String)tableExpression + String.format("\r\n%s=%s", "ALL_NODES_VALUE", this.formFields.get("ALL_NODES_VALUE").getValue());
            }
            return tableExpression;
        }

        private boolean setTableExpression(String expression) {
            try {
                String[] paramArray;
                Map expressionMap = new LookupTableDataRouter().parse(expression);
                String[] stringArray = paramArray = new String[]{"LOOKUP_TABLE", "KEY_COLUMN", "LOOKUP_KEY_COLUMN", "EXTERNAL_ID_COLUMN", "ALL_NODES_VALUE"};
                int n2 = stringArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    String value;
                    String param;
                    this.formFields.get(param).setValue((value = (String)expressionMap.get(param = stringArray[i2])) != null ? value : "null");
                }
            }
            catch (SyntaxParsingException ex2) {
                CommonUiUtils.notify((String)"Invalid Router Expression");
                return false;
            }
            return true;
        }

        @Override
        protected boolean apply() {
            String value;
            boolean valid = true;
            if (this.builderLayout.isVisible()) {
                value = this.getTableExpression();
                valid = this.validateForm();
            } else {
                value = this.textField.getValue();
                valid = this.validateTextField();
            }
            if (valid) {
                this.formField.setValue(value);
                return super.apply();
            }
            return false;
        }

        @Override
        protected void addComponentsToLayout(VerticalLayout fieldLayout) {
            Span description = new Span(this.controller.getMessage("The Lookup Table router is used to determine where data should be routed.", new Object[0]));
            description.setWidth("720px");
            fieldLayout.add(new Component[]{description});
            HorizontalLayout builderButtonLayout = new HorizontalLayout();
            builderButtonLayout.setSpacing(true);
            Button viewAsText = new Button(this.controller.getMessage("View As Text", new Object[0]));
            viewAsText.addClickListener((ComponentEventListener & Serializable)event -> {
                if (this.validateForm()) {
                    this.textField.setValue(this.getTableExpression());
                    this.textLayout.setVisible(true);
                    this.builderLayout.setVisible(false);
                }
            });
            builderButtonLayout.add(new Component[]{viewAsText});
            this.builderLayout = new VerticalLayout();
            this.builderLayout.setSpacing(true);
            this.builderLayout.add(new Component[]{builderButtonLayout});
            FormLayout formLayout = new FormLayout();
            formLayout.setResponsiveSteps(new FormLayout.ResponsiveStep[]{new FormLayout.ResponsiveStep("0", 2, FormLayout.ResponsiveStep.LabelsPosition.TOP)});
            this.lookupBinder = new Binder(a.class);
            this.formFields = new HashMap<String, TextField>();
            TextField lookupTable = new TextField();
            lookupTable.setWidthFull();
            this.lookupBinder.forField((HasValue)lookupTable).asRequired(String.format("%s is required.", "LOOKUP_TABLE")).bind("lookupTable");
            this.formFields.put("LOOKUP_TABLE", lookupTable);
            NativeLabel lookupTableLabel = new NativeLabel("LOOKUP_TABLE");
            lookupTableLabel.setClassName("required");
            formLayout.addFormItem((Component)lookupTable, (Component)lookupTableLabel);
            TextField keyColumn = new TextField();
            keyColumn.setWidthFull();
            this.lookupBinder.forField((HasValue)keyColumn).asRequired(String.format("%s is required.", "KEY_COLUMN")).bind("keyColumn");
            this.formFields.put("KEY_COLUMN", keyColumn);
            NativeLabel keyColumnLabel = new NativeLabel("KEY_COLUMN");
            keyColumnLabel.setClassName("required");
            formLayout.addFormItem((Component)keyColumn, (Component)keyColumnLabel);
            TextField lookupKeyColumn = new TextField();
            lookupKeyColumn.setWidthFull();
            this.lookupBinder.forField((HasValue)lookupKeyColumn).asRequired(String.format("%s is required.", "LOOKUP_KEY_COLUMN")).bind("lookupKeyColumn");
            this.formFields.put("LOOKUP_KEY_COLUMN", lookupKeyColumn);
            NativeLabel lookupKeyColumnLabel = new NativeLabel("LOOKUP_KEY_COLUMN");
            lookupKeyColumnLabel.setClassName("required");
            formLayout.addFormItem((Component)lookupKeyColumn, (Component)lookupKeyColumnLabel);
            TextField externalIdColumn = new TextField();
            externalIdColumn.setWidthFull();
            this.lookupBinder.forField((HasValue)externalIdColumn).asRequired(String.format("%s is required.", "EXTERNAL_ID_COLUMN")).bind("externalIdColumn");
            this.formFields.put("EXTERNAL_ID_COLUMN", externalIdColumn);
            NativeLabel externalIdColumnLabel = new NativeLabel("EXTERNAL_ID_COLUMN");
            externalIdColumnLabel.setClassName("required");
            formLayout.addFormItem((Component)externalIdColumn, (Component)externalIdColumnLabel);
            TextField allNodesValue = new TextField();
            allNodesValue.setWidthFull();
            this.lookupBinder.forField((HasValue)allNodesValue).bind("allNodesValue");
            this.formFields.put("ALL_NODES_VALUE", allNodesValue);
            formLayout.addFormItem((Component)allNodesValue, "ALL_NODES_VALUE");
            this.builderLayout.add(new Component[]{formLayout});
            this.textLayout = new VerticalLayout();
            this.textLayout.setSpacing(true);
            this.textLayout.setHeightFull();
            this.textLayout.setVisible(false);
            HorizontalLayout textButtonLayout = new HorizontalLayout();
            textButtonLayout.setSpacing(true);
            Button viewInBuilder = new Button("View In Builder");
            viewInBuilder.addClickListener((ComponentEventListener & Serializable)event -> {
                if (this.validateTextField()) {
                    this.setTableExpression(this.textField.getValue());
                    this.textLayout.setVisible(false);
                    this.builderLayout.setVisible(true);
                }
            });
            textButtonLayout.add(new Component[]{viewInBuilder});
            this.textLayout.add(new Component[]{textButtonLayout});
            this.textField = new TextArea();
            this.textField.setWidthFull();
            this.textField.setHeight("168px");
            this.textLayout.add(new Component[]{this.textField});
            fieldLayout.add(new Component[]{this.builderLayout, this.textLayout});
            fieldLayout.expand(new Component[]{this.builderLayout, this.textLayout});
        }

        boolean validateTextField() {
            try {
                new LookupTableDataRouter().parse(this.textField.getValue());
            }
            catch (SyntaxParsingException ex2) {
                this.textField.setErrorMessage("Invalid Router Expression");
                this.textField.setInvalid(true);
                CommonUiUtils.notify((String)"Invalid Router Expression");
                return false;
            }
            this.textField.setInvalid(false);
            return true;
        }

        boolean validateForm() {
            boolean ret = this.lookupBinder.validate().isOk();
            if (!ret) {
                CommonUiUtils.notify((String)"Invalid Router Expression");
            }
            return ret;
        }

        class a {
            private String lookupTable;
            private String keyColumn;
            private String lookupKeyColumn;
            private String externalIdColumn;
            private String allNodesValue;

            a() {
            }

            public String getLookupTable() {
                return this.lookupTable;
            }

            public void setLookupTable(String lookupTable) {
                this.lookupTable = lookupTable;
            }

            public String getKeyColumn() {
                return this.keyColumn;
            }

            public void setKeyColumn(String keyColumn) {
                this.keyColumn = keyColumn;
            }

            public String getLookupKeyColumn() {
                return this.lookupKeyColumn;
            }

            public void setLookupKeyColumn(String lookupKeyColumn) {
                this.lookupKeyColumn = lookupKeyColumn;
            }

            public String getExternalIdColumn() {
                return this.externalIdColumn;
            }

            public void setExternalIdColumn(String externalIdColumn) {
                this.externalIdColumn = externalIdColumn;
            }

            public String getAllNodesValue() {
                return this.allNodesValue;
            }

            public void setAllNodesValue(String allNodesValue) {
                this.allNodesValue = allNodesValue;
            }
        }
    }

    class com.jumpmind.symmetric.console.impl.ak$a
    extends an {
        private static final long serialVersionUID = 1L;
        private TextArea textField;
        private Grid<a> columnGrid;
        private List<a> columnGridItems;
        private Binder<a> columnBinder;
        private final TextArea formField;
        private String value;
        private VerticalLayout builderLayout;
        private VerticalLayout textLayout;

        public com.jumpmind.symmetric.console.impl.ak$a(TextArea formField) {
            super(ak.this.controller, "Configure Column Router Expression", null, false, (Object[])null);
            this.setWidth("900px");
            this.formField = formField;
            this.addOpenedChangeListener((ComponentEventListener & Serializable)event -> ak.this.formListener.getFormLayout().enableCancelShortcut(!event.isOpened()));
            this.cancelButton.setVisible(true);
            this.value = formField.getValue();
            if (this.value != null) {
                this.textField.setValue(this.value);
                if (this.validateTextField()) {
                    this.setTableExpression(this.value);
                    for (a item : this.columnGridItems) {
                        this.columnBinder.readBean((Object)item);
                    }
                } else {
                    this.builderLayout.setVisible(false);
                    this.textLayout.setVisible(true);
                }
            }
        }

        private String getTableExpression() {
            StringBuilder fullExp = new StringBuilder();
            int i2 = 0;
            for (a expression : this.columnGrid.getDataProvider().fetch(new Query()).collect(Collectors.toList())) {
                if (expression.getName() != null) {
                    fullExp.append(expression.getName() + " ");
                }
                if (expression.getEquality() != null) {
                    fullExp.append(expression.getEquality() + " ");
                }
                if (expression.getValue() != null) {
                    fullExp.append(expression.getValue() + " ");
                }
                if ((long)(i2 + 1) < this.columnGrid.getDataProvider().fetch(new Query()).count()) {
                    fullExp.append("\r\nOR ");
                }
                ++i2;
            }
            return fullExp.toString();
        }

        private boolean setTableExpression(String expression) {
            if (this.columnGridItems == null) {
                this.columnGridItems = new ArrayList<a>();
            } else {
                this.columnGridItems.clear();
            }
            try {
                List expressions = ColumnMatchExpression.parse((String)expression);
                for (ColumnMatchExpression exp : expressions) {
                    if (exp.getTokens().length < 2) continue;
                    a row = new a();
                    row.setName(exp.getTokens()[0]);
                    row.setEquality(exp.getOperator());
                    row.setValue(exp.getTokens()[1]);
                    this.columnGridItems.add(row);
                }
            }
            catch (SyntaxParsingException ex2) {
                CommonUiUtils.notify((String)"Invalid Router Expression");
                return false;
            }
            this.columnGrid.setItems(this.columnGridItems);
            return true;
        }

        @Override
        protected boolean apply() {
            boolean valid = true;
            if (this.builderLayout.isVisible()) {
                this.value = this.getTableExpression();
                valid = this.columnBinder.validate().isOk();
            } else {
                this.value = this.textField.getValue();
                valid = this.validateTextField();
            }
            if (valid) {
                this.formField.setValue(this.value);
                return super.apply();
            }
            return false;
        }

        @Override
        protected void addComponentsToLayout(VerticalLayout fieldLayout) {
            Span description = new Span(this.controller.getMessage("The column match router is used to limit when data is routed.  The first value in the table is the column name.  The second value can be either a token expression choosen from the drop down list, another column name preceded with a ':' character, or a constant value to compare against.", new Object[0]));
            description.setWidth("580px");
            fieldLayout.add(new Component[]{description});
            HorizontalLayout builderButtonLayout = new HorizontalLayout();
            builderButtonLayout.setSpacing(true);
            Button addButton = new Button(this.controller.getMessage("+", new Object[0]));
            Button deleteButton = new Button(this.controller.getMessage("-", new Object[0]));
            Button viewAsText = new Button(this.controller.getMessage("View As Text", new Object[0]));
            addButton.addClickListener((ComponentEventListener & Serializable)event -> {
                if (this.columnGridItems == null) {
                    this.columnGridItems = new ArrayList<a>();
                }
                this.columnGridItems.add(new a());
                this.columnGrid.setItems(this.columnGridItems);
                viewAsText.setEnabled(false);
            });
            builderButtonLayout.add(new Component[]{addButton});
            deleteButton.setEnabled(false);
            deleteButton.addClickListener((ComponentEventListener & Serializable)event -> {
                if (!this.columnGrid.getSelectedItems().isEmpty()) {
                    this.columnGridItems.remove(this.columnGrid.getSelectedItems().iterator().next());
                    this.columnGrid.setItems(this.columnGridItems);
                    this.columnGrid.getEditor().save();
                }
            });
            builderButtonLayout.add(new Component[]{deleteButton});
            viewAsText.setEnabled(false);
            viewAsText.addClickListener((ComponentEventListener & Serializable)event -> {
                this.textField.setValue(this.getTableExpression());
                this.textLayout.setVisible(true);
                this.builderLayout.setVisible(false);
            });
            builderButtonLayout.add(new Component[]{viewAsText});
            this.builderLayout = new VerticalLayout();
            this.builderLayout.add(new Component[]{builderButtonLayout});
            this.builderLayout.setSpacing(true);
            this.textLayout = new VerticalLayout();
            this.textLayout.setSpacing(true);
            this.textLayout.setHeightFull();
            this.textLayout.setVisible(false);
            HorizontalLayout textButtonLayout = new HorizontalLayout();
            textButtonLayout.setSpacing(true);
            Button viewInBuilder = new Button("View In Builder");
            viewInBuilder.addClickListener((ComponentEventListener & Serializable)event -> {
                if (this.validateTextField()) {
                    this.setTableExpression(this.textField.getValue());
                    this.textLayout.setVisible(false);
                    this.builderLayout.setVisible(true);
                }
            });
            textButtonLayout.add(new Component[]{viewInBuilder});
            this.textLayout.add(new Component[]{textButtonLayout});
            this.columnGrid = new Grid();
            this.columnGrid.setHeight("300px");
            this.columnGrid.setWidthFull();
            this.columnBinder = new Binder();
            this.columnGrid.getEditor().setBinder(this.columnBinder);
            ComboBox name = new ComboBox("", (Object[])new String[]{""});
            name.setWidthFull();
            name.addCustomValueSetListener((ComponentEventListener & Serializable)event -> {
                Set nameSet = name.getDataProvider().fetch(new Query()).collect(Collectors.toSet());
                nameSet.add(event.getDetail());
                name.setItems((ComboBox.ItemFilter & Serializable)(item, filter) -> !CommonUiUtils.isFilteredOut((String)item, (String)filter), nameSet);
                name.setValue((Object)event.getDetail());
            });
            this.columnBinder.forField((HasValue)name).asRequired(this.controller.getMessage("Column Name is required.", new Object[0])).bind(a::getName, a::setName);
            this.columnGrid.addColumn(a::getName).setEditorComponent((Component)name).setHeader("Column Name");
            ArrayList<String> equalityList = new ArrayList<String>();
            equalityList.add("=");
            equalityList.add("!=");
            equalityList.add("contains");
            equalityList.add("ends with");
            equalityList.add("has");
            equalityList.add("starts with");
            equalityList.add("not contains");
            equalityList.add("not ends with");
            equalityList.add("not has");
            equalityList.add("not starts with");
            Select equality = new Select();
            equality.setItems(equalityList);
            equality.setEmptySelectionAllowed(false);
            equality.setWidthFull();
            this.columnBinder.forField((HasValue)equality).bind(a::getEquality, a::setEquality);
            this.columnGrid.addColumn(a::getEquality).setEditorComponent((Component)equality).setHeader("").setWidth("165px").setFlexGrow(0);
            LinkedHashSet<String> valueSet = new LinkedHashSet<String>();
            valueSet.add(":NODE_ID");
            valueSet.add(":SOURCE_NODE_ID");
            valueSet.add(":EXTERNAL_ID");
            valueSet.add(":SOURCE_EXTERNAL_ID");
            valueSet.add(":NODE_GROUP_ID");
            valueSet.add(":SOURCE_NODE_GROUP_ID");
            ComboBox value = new ComboBox("");
            value.setItems((ComboBox.ItemFilter & Serializable)(item, filter) -> !CommonUiUtils.isFilteredOut((String)item, (String)filter), valueSet);
            value.setWidthFull();
            value.addCustomValueSetListener((ComponentEventListener & Serializable)event -> {
                valueSet.add(event.getDetail());
                value.setItems((ComboBox.ItemFilter & Serializable)(item, filter) -> !CommonUiUtils.isFilteredOut((String)item, (String)filter), (Collection)valueSet);
                value.setValue((Object)event.getDetail());
            });
            this.columnBinder.forField((HasValue)value).asRequired(this.controller.getMessage("Column Value is required.", new Object[0])).bind(a::getValue, a::setValue);
            this.columnGrid.addColumn(a::getValue).setEditorComponent((Component)value).setHeader("Value");
            this.columnGrid.addSelectionListener((SelectionListener & Serializable)event -> deleteButton.setEnabled(!event.getAllSelectedItems().isEmpty()));
            for (Grid.Column column : this.columnGrid.getColumns()) {
                column.setResizable(true);
            }
            CommonUiUtils.configureEditor(this.columnGrid);
            this.columnGrid.getEditor().addSaveListener((EditorSaveListener & Serializable)event -> viewAsText.setEnabled(this.columnBinder.validate().isOk()));
            this.builderLayout.add(new Component[]{this.columnGrid});
            this.textField = new TextArea();
            this.textField.setWidthFull();
            this.textField.setHeight("250px");
            this.textLayout.add(new Component[]{this.textField});
            fieldLayout.add(new Component[]{this.builderLayout});
            fieldLayout.add(new Component[]{this.textLayout});
        }

        boolean validateTextField() {
            try {
                ColumnMatchExpression.parse((String)this.textField.getValue());
            }
            catch (Exception ex2) {
                this.textField.setErrorMessage("Invalid Router Expression");
                this.textField.setInvalid(true);
                CommonUiUtils.notify((String)"Invalid Router Expression");
                return false;
            }
            this.textField.setInvalid(false);
            return true;
        }

        class a {
            private String name;
            private String equality = "=";
            private String value;

            public String getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = name;
            }

            public String getEquality() {
                return this.equality;
            }

            public void setEquality(String equality) {
                this.equality = equality;
            }

            public String getValue() {
                return this.value;
            }

            public void setValue(String value) {
                this.value = value;
            }
        }
    }

    class b
    extends an {
        private static final long serialVersionUID = 1L;
        private a editor;
        private TextArea field;
        private HorizontalLayout menuLayout;

        public b(TextArea field) {
            super(ak.this.controller, "Edit Java Router", null, false, (Object[])null);
            this.setResizable(true);
            UI.getCurrent().getPage().retrieveExtendedClientDetails((Page.ExtendedClientDetailsReceiver & Serializable)details -> {
                this.setWidth(details.getWindowInnerWidth() - 200 + "px");
                this.setHeight(details.getWindowInnerHeight() - 100 + "px");
            });
            this.editor.setSizeFull();
            this.field = field;
            this.cancelButton.setVisible(true);
            this.addOpenedChangeListener((ComponentEventListener & Serializable)event -> ak.this.formListener.getFormLayout().enableCancelShortcut(!event.isOpened()));
            String value = field.getValue();
            if (value != null && !value.isEmpty()) {
                this.editor.getEditor().setValue(value);
            } else if (value == null || value.isEmpty()) {
                this.editor.getEditor().replaceTextAtCurrentSelection("Set<String> routeToNodes = new HashSet<String>();\r\nreturn routeToNodes;");
            }
            this.editor.focus();
            this.setCloseOnOutsideClick(false);
        }

        protected HorizontalLayout generateMenuLayout() {
            this.menuLayout = new HorizontalLayout();
            MenuBar variableMenu = new MenuBar();
            MenuItem builtInVariables = variableMenu.addItem(this.controller.getMessage("Variables", new Object[0]));
            builtInVariables.add(new Component[]{as.getDropdownIcon()});
            HashMap builtInVariableMap = new HashMap();
            builtInVariableMap.put(this.controller.getMessage("context - SimpleRouterContext", new Object[0]), SimpleRouterContext.class);
            builtInVariableMap.put(this.controller.getMessage("dataMetaData - DataMetaData", new Object[0]), DataMetaData.class);
            builtInVariableMap.put(this.controller.getMessage("engine - ISymmetricEngine", new Object[0]), ISymmetricEngine.class);
            builtInVariableMap.put(this.controller.getMessage("initialLoad - boolean", new Object[0]), Boolean.TYPE);
            builtInVariableMap.put(this.controller.getMessage("initialLoadSelectUsed - boolean", new Object[0]), Boolean.TYPE);
            builtInVariableMap.put(this.controller.getMessage("log - Logger", new Object[0]), Logger.class);
            builtInVariableMap.put(this.controller.getMessage("nodes - Set<Node>", new Object[0]), Set.class);
            builtInVariableMap.put(this.controller.getMessage("triggerRouter - TriggerRouter", new Object[0]), TriggerRouter.class);
            ArrayList variables = new ArrayList(builtInVariableMap.keySet());
            Collections.sort(variables);
            for (String variable : variables) {
                ((SubMenu)builtInVariables.getSubMenu()).addItem(variable, (ComponentEventListener & Serializable)event -> {
                    String text = this.editor.getEditor().getValue();
                    MenuItem item = (MenuItem)event.getSource();
                    String var = item.getText().substring(0, item.getText().indexOf(" "));
                    if (StringUtils.isNotEmpty((CharSequence)text)) {
                        this.editor.getEditor().replaceTextAtCurrentSelection(var);
                    } else {
                        this.editor.getEditor().setValue(var);
                    }
                });
            }
            this.menuLayout.add(new Component[]{variableMenu});
            MenuBar snippetsMenu = new MenuBar();
            MenuItem snippets = snippetsMenu.addItem(this.controller.getMessage("Snippets", new Object[0]));
            snippets.add(new Component[]{as.getDropdownIcon()});
            HashMap<String, Class<String>> snippetsMap = new HashMap<String, Class<String>>();
            snippetsMap.put(this.controller.getMessage("addNodeId(nodeId, routeToNodes, nodes);", new Object[0]), String.class);
            snippetsMap.put(this.controller.getMessage("Map<String, String> map = getDataMap(dataMetaData, symmetricDialect);", new Object[0]), String.class);
            snippetsMap.put(this.controller.getMessage("Map<String, Object> map = getDataObjectMap(dataMetaData, symmetricDialect, true);", new Object[0]), String.class);
            snippetsMap.put(this.controller.getMessage("toNodeIds(nodes, routeToNodes);", new Object[0]), String.class);
            snippetsMap.put(this.controller.getMessage("toExternalIds(nodes);", new Object[0]), String.class);
            ArrayList snippetList = new ArrayList(snippetsMap.keySet());
            Collections.sort(snippetList);
            for (String snippet : snippetList) {
                ((SubMenu)snippets.getSubMenu()).addItem(snippet, (ComponentEventListener & Serializable)event -> {
                    String text = this.editor.getEditor().getValue();
                    MenuItem item = (MenuItem)event.getSource();
                    String var = item.getText();
                    if (StringUtils.isNotEmpty((CharSequence)text)) {
                        this.editor.getEditor().replaceTextAtCurrentSelection(var);
                    } else {
                        this.editor.getEditor().setValue(var);
                    }
                });
            }
            this.menuLayout.add(new Component[]{snippetsMenu});
            this.editor.getEditor().addValueChangeListener((ComponentEventListener)new l(this.editor.getEditor(), builtInVariableMap));
            return this.menuLayout;
        }

        @Override
        protected void addButtonsToLeftOfCancel() {
            Button validateButton = new Button(this.message("Validate"), (ComponentEventListener & Serializable)event -> this.editor.validate());
            this.getFooter().add(new Component[]{validateButton});
        }

        @Override
        protected boolean apply() {
            String value = this.editor.getValue();
            if (StringUtils.isNotBlank((CharSequence)value)) {
                this.field.setValue(value);
                return super.apply();
            }
            return false;
        }

        @Override
        protected void addComponentsToLayout(VerticalLayout fieldLayout) {
            this.editor = new a();
            this.editor.setWidthFull();
            this.editor.setHeight("600px");
            this.editor.setWidth("600px");
            fieldLayout.add(new Component[]{new Span(this.controller.getMessage("The specified Java code will be used to make routing decisions.", new Object[0]))});
            fieldLayout.addAndExpand(new Component[]{this.generateMenuLayout()});
            fieldLayout.addAndExpand(new Component[]{this.editor});
        }

        class a
        extends f {
            private static final long serialVersionUID = 1L;

            public a() {
                Method[] methods = JavaDataRouter.class.getMethods();
                this.setInterfaceClasses(IDataRouter.class);
                for (Method method : methods) {
                    if (!method.getName().equals("routeToNodes")) continue;
                    this.setMethod(method);
                }
            }

            @Override
            protected void compile() throws Exception {
                b.this.controller.getSymmetricEngine().getExtensionService().getCompiledClass("import org.jumpmind.symmetric.route.*;\nimport org.jumpmind.symmetric.model.*;\nimport org.jumpmind.symmetric.service.*;\nimport java.util.*;\npublic class JavaDataRouterExt extends JavaDataRouter { \n   public Set<String> routeToNodes(SimpleRouterContext context, DataMetaData dataMetaData, Set<Node> nodes,\n      boolean initialLoad, boolean initialLoadSelectUsed, TriggerRouter triggerRouter) {\n\n" + this.getValue() + "\n\n   }\n}\n");
            }

            @Override
            protected int countHeaderLines() {
                return "import org.jumpmind.symmetric.route.*;\nimport org.jumpmind.symmetric.model.*;\nimport org.jumpmind.symmetric.service.*;\nimport java.util.*;\npublic class JavaDataRouterExt extends JavaDataRouter { \n   public Set<String> routeToNodes(SimpleRouterContext context, DataMetaData dataMetaData, Set<Node> nodes,\n      boolean initialLoad, boolean initialLoadSelectUsed, TriggerRouter triggerRouter) {\n\n".split("\n").length;
            }
        }
    }
}

