/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.impl.R;
import com.jumpmind.symmetric.console.model.RestUser;
import com.jumpmind.symmetric.console.ui.common.I;
import com.jumpmind.symmetric.console.ui.common.aa;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.select.Select;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.ValidationException;
import com.vaadin.flow.function.SerializablePredicate;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.security.SecurityServiceFactory;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;

public class aj
extends R<RestUser> {
    private static final long serialVersionUID = 1L;

    public aj(I controller, Set<RestUser> itemSet, boolean newItemFlag, boolean deleteFlag) {
        super(controller, itemSet, newItemFlag, deleteFlag);
    }

    @Override
    public void initFields() {
        this.binder = new Binder(RestUser.class);
        TextField appName = new TextField();
        appName.setId("appName");
        this.binder.forField((HasValue)appName).withValidator((SerializablePredicate & Serializable)value -> !StringUtils.isBlank((CharSequence)value), this.controller.getMessage("%s is required.", "Key Name")).bind("appName");
        appName.setRequiredIndicatorVisible(true);
        this.fieldList.add(new R.a(this, (HasValue<?, ?>)appName, this.controller.getMessage("Key Name", new Object[0])));
        TextField description = new TextField();
        description.setId("description");
        this.binder.forField((HasValue)description).withValidator((SerializablePredicate & Serializable)value -> !value.equals(description.getEmptyValue()), this.controller.getMessage("%s is required.", "Key Description")).bind("description");
        description.setRequiredIndicatorVisible(true);
        this.fieldList.add(new R.a(this, (HasValue<?, ?>)description, this.controller.getMessage("Key Description", new Object[0])));
        ArrayList<String> accessLevelList = new ArrayList<String>();
        accessLevelList.add("readonly");
        accessLevelList.add("readwrite");
        Select accessLevel = new Select();
        accessLevel.setItems(accessLevelList);
        accessLevel.setId("accessLevel");
        this.formatComboBox(accessLevel);
        this.binder.forField((HasValue)accessLevel).withValidator((SerializablePredicate & Serializable)value -> value != null, this.controller.getMessage("%s is required.", "Access Level")).bind("accessLevel");
        accessLevel.setRequiredIndicatorVisible(true);
        this.fieldList.add(new R.a(this, (HasValue<?, ?>)accessLevel, this.controller.getMessage("Access Level", new Object[0])));
    }

    @Override
    protected void generateNewItem() {
        RestUser user = new RestUser();
        user.setAppName("");
        user.setDescription("");
        user.setAccessLevel("readonly");
        this.newItem = user;
    }

    @Override
    public boolean save(boolean saveAsCopy) {
        if (this.binder.validate().isOk()) {
            try {
                this.binder.writeBean((Object)((RestUser)this.newItem));
            }
            catch (ValidationException e2) {
                CommonUiUtils.notify((String)"Failed to write to bean");
            }
            String apiKey = this.saveRestKeys((RestUser)this.newItem);
            aa dialog = new aa(this.controller, "%s REST API Key", ((RestUser)this.newItem).getAppName(), String.format("The REST API key is \"%s\".  This key is hashed and cannot be retrieved again.", apiKey));
            dialog.open();
            this.addEvent("REST API Key Created", ((RestUser)this.newItem).getAppName());
            if (this.formListener != null) {
                this.formListener.formSaved();
            }
            return true;
        }
        return false;
    }

    private String saveRestKeys(RestUser restUser) {
        String apiKey = SecurityServiceFactory.create().nextSecureHexString(30);
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e2) {
            this.log.error(e2.getMessage(), (Throwable)e2);
            throw new RuntimeException(e2);
        }
        String hashedApiKey = Base64.encodeBase64String((byte[])digest.digest(apiKey.getBytes(StandardCharsets.UTF_8)));
        String appName = restUser.getAppName();
        String description = restUser.getDescription();
        restUser.setKey(apiKey);
        Properties prop = this.loadProperties();
        prop.setProperty(hashedApiKey, restUser.getAccessLevel());
        prop.setProperty(hashedApiKey + ".name", appName);
        prop.setProperty(hashedApiKey + ".description", description);
        this.saveProperties(prop);
        return apiKey;
    }

    private void saveProperties(Properties prop) {
        try {
            prop.store(new FileOutputStream(new File(System.getProperty("sym.rest.properties.file", "security/rest.properties"))), null);
        }
        catch (Exception e2) {
            this.log.error(e2.getMessage(), (Throwable)e2);
            throw new RuntimeException(e2);
        }
    }

    private Properties loadProperties() {
        Properties prop = new Properties();
        try {
            prop.load(new FileInputStream(new File(System.getProperty("sym.rest.properties.file", "security/rest.properties"))));
        }
        catch (Exception e2) {
            this.log.error(e2.getMessage(), (Throwable)e2);
            throw new RuntimeException(e2);
        }
        return prop;
    }

    @Override
    public void delete() {
        for (RestUser user : this.itemSet) {
            Properties prop = this.loadProperties();
            for (Object name : new ArrayList<Object>(prop.keySet())) {
                if (!name.toString().contains(user.getKey())) continue;
                prop.remove(name);
            }
            this.saveProperties(prop);
        }
        this.addEvent("REST API Key Deleted", this.itemSet.stream().map(RestUser::getAppName).collect(Collectors.toSet()));
        if (this.formListener != null) {
            this.formListener.formDeleted();
        }
    }

    @Override
    protected List<String> getOrderedFieldIds() {
        ArrayList<String> orderedFields = new ArrayList<String>();
        orderedFields.add("appName");
        orderedFields.add("description");
        orderedFields.add("accessLevel");
        return orderedFields;
    }

    @Override
    public String getKeyId() {
        return "appName";
    }

    @Override
    public String getHelpSectionName() {
        return "_rest_keys";
    }
}

