/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.impl.R;
import com.jumpmind.symmetric.console.model.Monitor;
import com.jumpmind.symmetric.console.model.Notification;
import com.jumpmind.symmetric.console.service.IMonitorService;
import com.jumpmind.symmetric.console.ui.common.I;
import com.jumpmind.symmetric.console.ui.common.Slider;
import com.jumpmind.symmetric.console.ui.common.V;
import com.jumpmind.symmetric.notification.a;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValidation;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.combobox.MultiSelectComboBox;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.select.Select;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.ValidationException;
import com.vaadin.flow.data.binder.ValidationResult;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.data.binder.ValueContext;
import com.vaadin.flow.data.validator.EmailValidator;
import com.vaadin.flow.function.SerializablePredicate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.model.NodeGroup;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;

public class ag
extends R<Notification> {
    private static final long serialVersionUID = 1L;
    TextArea expression;
    V emailAddress;
    Slider severityLevel;
    MultiSelectComboBox<String> filterForMonitors;
    List<Monitor> monitorList;
    List<String> filteredMonitorIdList;
    String originalId;
    private Validator<String> unaddedEmailValidator;
    private Validator<Set<String>> nonEmptyEmailListValidator;

    public ag(I controller, Set<Notification> itemSet, boolean newItemFlag, boolean deleteFlag) {
        super(controller, itemSet, newItemFlag, deleteFlag);
    }

    @Override
    public void initFields() {
        String originalExpressionString;
        if (this.isBulk) {
            this.layout.setLabelWidth("12em");
        } else if (!this.newItemFlag) {
            this.originalId = ((Notification)this.itemSet.iterator().next()).getNotificationId();
        }
        this.binder = new Binder(Notification.class);
        this.binder.setValidatorsDisabled(true);
        this.unaddedEmailValidator = Validator.from((SerializablePredicate & Serializable)value -> value.equals(this.emailAddress.getField().getEmptyValue()) || !this.emailAddress.isVisible() || this.isBulk, (String)this.controller.getMessage("Did you mean to add this Email Address?", new Object[0]));
        this.nonEmptyEmailListValidator = Validator.from((SerializablePredicate & Serializable)value -> !value.isEmpty() || !this.emailAddress.isVisible() || this.isBulk, (String)this.controller.getMessage("At least one Email Address is required.", new Object[0]));
        TextField notificationId = new TextField();
        notificationId.setId("notificationId");
        notificationId.setWidth("16em");
        this.binder.forField((HasValue)notificationId).withValidator((SerializablePredicate & Serializable)value -> !StringUtils.isBlank((CharSequence)value) || this.isBulk, this.controller.getMessage("%s is required.", "Notification Id")).bind("notificationId");
        notificationId.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a((HasValue<?, ?>)notificationId, this.controller.getMessage("Notification Id", new Object[0])));
        ArrayList<Object> targetNodeList = new ArrayList<Object>();
        targetNodeList.add(this.controller.getSymmetricEngine().getParameterService().getExternalId() + " only");
        targetNodeList.add("ALL");
        for (NodeGroup nodeGroup : this.controller.getSymmetricEngine().getConfigurationService().getNodeGroups()) {
            targetNodeList.add(nodeGroup.getNodeGroupId());
        }
        Select targetNode = new Select();
        targetNode.setItems(targetNodeList);
        if (this.itemSet.size() == 1 && !targetNodeList.contains(((Notification)this.itemSet.iterator().next()).getTargetNode())) {
            String currentTargetNode = ((Notification)this.itemSet.iterator().next()).getTargetNode();
            targetNodeList.add(currentTargetNode);
            targetNode.setItems(targetNodeList);
            targetNode.setValue((Object)currentTargetNode);
        }
        targetNode.setId("targetNode");
        this.formatComboBox(targetNode);
        this.binder.forField((HasValue)targetNode).withValidator((SerializablePredicate & Serializable)value -> value != null || this.isBulk, this.controller.getMessage("%s is required.", "Target Nodes")).bind("targetNode");
        targetNode.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a((HasValue<?, ?>)targetNode, this.controller.getMessage("Target Nodes", new Object[0])));
        ArrayList<String> typeList = new ArrayList<String>();
        for (a notificationType : this.controller.getSymmetricEngine().getExtensionService().getExtensionPointList(a.class)) {
            typeList.add(notificationType.a());
        }
        Select type = new Select();
        type.setItems(typeList);
        type.setId("type");
        this.formatComboBox(type);
        this.binder.forField((HasValue)type).withValidator((SerializablePredicate & Serializable)value -> value != null || this.isBulk, this.controller.getMessage("%s is required.", "Notification Type")).bind("type");
        type.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a((HasValue<?, ?>)type, this.controller.getMessage("Notification Type", new Object[0])));
        this.expression = new TextArea();
        this.expression.setWidth("80%");
        this.expression.setHeight("124px");
        this.expression.setId("expression");
        boolean originalIsLog = !this.isBulk && !this.newItemFlag && ((Notification)this.itemSet.iterator().next()).getType().equals("log");
        boolean originalIsEmail = !this.isBulk && !this.newItemFlag && ((Notification)this.itemSet.iterator().next()).getType().equals("email");
        this.expression.setVisible(!this.isBulk && !this.newItemFlag && !originalIsLog && !originalIsEmail);
        R.a expressionField = new R.a((HasValue<?, ?>)this.expression, this.controller.getMessage("Expression", new Object[0]));
        this.fieldList.add(expressionField);
        this.emailAddress = new V((Validator<String>)new EmailValidator("Invalid e-mail address {0}"), this.nonEmptyEmailListValidator, this.binder);
        this.emailAddress.setWidth("362px");
        this.emailAddress.setId("email");
        this.emailAddress.setVisible(originalIsEmail);
        R.a emailField = new R.a((HasValue<?, ?>)this.emailAddress, this.controller.getMessage("Email Address", new Object[0]));
        this.fieldList.add(emailField);
        this.severityLevel = new Slider(0, 3);
        this.severityLevel.setId("severityLevel");
        Span severityLevelSpan = new Span(this.controller.getMessage("<Any>", new Object[0]));
        this.fieldList.add(new R.a((HasValue<?, ?>)this.severityLevel, this.controller.getMessage("Severity Level", new Object[0]), (Component)severityLevelSpan));
        this.filterForMonitors = new MultiSelectComboBox();
        this.filterForMonitors.setWidth("32em");
        this.filterForMonitors.setId("filterForMonitors");
        this.filterForMonitors.setAutoExpand(MultiSelectComboBox.AutoExpandMode.VERTICAL);
        this.filterForMonitors.setVisible(originalIsLog || originalIsEmail);
        this.monitorList = this.controller.getMonitorService().getMonitors().stream().filter(m2 -> !m2.isInsight()).collect(Collectors.toList());
        List<String> originalFilteredMonitorIdList = null;
        if (!this.newItemFlag && !this.isBulk && StringUtils.isNotBlank((CharSequence)(originalExpressionString = ((Notification)this.itemSet.iterator().next()).getExpressionString()))) {
            Notification.Expression originalExpression = ((Notification)this.itemSet.iterator().next()).getExpression();
            if (this.expression.isVisible()) {
                this.expression.setValue(originalExpressionString);
            } else {
                Object emailExpression;
                List<String> emails;
                if (this.emailAddress.isVisible() && originalExpression instanceof Notification.EmailExpression && (emails = ((Notification.EmailExpression)(emailExpression = (Notification.EmailExpression)originalExpression)).getEmails()) != null) {
                    for (String email : emails) {
                        this.emailAddress.addString(email);
                    }
                }
                originalFilteredMonitorIdList = originalExpression.getMonitorIds();
            }
        }
        Map<Integer, String> severityLevelNames = Monitor.getSeverityLevelNames();
        this.severityLevel.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            String labelText = (String)severityLevelNames.get((Integer)event.getValue() * 100);
            severityLevelSpan.setText(labelText != null ? labelText : this.controller.getMessage("<Any>", new Object[0]));
            this.updateMonitorIds();
        });
        int originalSeverityLevel = this.newItemFlag ? 0 : ((Notification)this.itemSet.iterator().next()).getSeverityLevel() / 100;
        this.severityLevel.setValue(originalSeverityLevel);
        if (!severityLevelNames.containsKey(originalSeverityLevel)) {
            this.updateMonitorIds();
        }
        if (originalFilteredMonitorIdList != null) {
            for (String monitorId : originalFilteredMonitorIdList) {
                if (this.filteredMonitorIdList.contains(monitorId)) continue;
                this.filteredMonitorIdList.add(monitorId);
            }
            this.filteredMonitorIdList.sort(String.CASE_INSENSITIVE_ORDER);
            this.filterForMonitors.setItems(this.filteredMonitorIdList);
            this.filterForMonitors.setValue(originalFilteredMonitorIdList);
        }
        R.a filterForMonitorsField = new R.a((HasValue<?, ?>)this.filterForMonitors, this.controller.getMessage("Filter for Monitors (to Include)", new Object[0]));
        this.fieldList.add(filterForMonitorsField);
        type.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            boolean isLog = ((String)event.getValue()).equals("log");
            boolean isEmail = ((String)event.getValue()).equals("email");
            this.expression.setVisible(!isLog && !isEmail);
            expressionField.setVisible(!isLog && !isEmail);
            this.emailAddress.setVisible(isEmail);
            emailField.setVisible(isEmail);
            this.filterForMonitors.setVisible(isLog || isEmail);
            filterForMonitorsField.setVisible(isLog || isEmail);
            if (!"log".equals(event.getOldValue()) && !"email".equals(event.getOldValue())) {
                this.updateMonitorIds();
            }
        });
        Checkbox enabled = new Checkbox();
        enabled.setId("enabled");
        this.binder.forField((HasValue)enabled).bind("enabled");
        this.fieldList.add(new R.a((HasValue<?, ?>)enabled, this.controller.getMessage("Enabled", new Object[0])));
    }

    @Override
    protected void generateNewItem() {
        Notification notification = new Notification();
        notification.setExternalId("ALL");
        notification.setNodeGroupId("ALL");
        notification.setEnabled(true);
        this.newItem = notification;
    }

    protected void updateMonitorIds() {
        if (this.filterForMonitors.isVisible()) {
            this.filteredMonitorIdList = new ArrayList<String>();
            HashSet<String> selectedMonitorIdSet = new HashSet<String>(this.filterForMonitors.getValue());
            for (Monitor monitor : this.monitorList) {
                if (monitor.getSeverityLevel() >= (Integer)this.severityLevel.getValue() * 100) {
                    this.filteredMonitorIdList.add(monitor.getMonitorId());
                    continue;
                }
                selectedMonitorIdSet.remove(monitor.getMonitorId());
            }
            for (String monitorId : selectedMonitorIdSet) {
                if (this.filteredMonitorIdList.contains(monitorId)) continue;
                selectedMonitorIdSet.add(monitorId);
            }
            this.filteredMonitorIdList.sort(String.CASE_INSENSITIVE_ORDER);
            this.filterForMonitors.setItems(this.filteredMonitorIdList);
            this.filterForMonitors.setValue(selectedMonitorIdSet);
        }
    }

    protected boolean processValidationResult(ValidationResult result, HasValidation field) {
        if (result.isError()) {
            field.setErrorMessage(result.getErrorMessage());
            field.setInvalid(true);
            return false;
        }
        field.setInvalid(false);
        return true;
    }

    @Override
    public boolean save(boolean saveAsCopy) {
        boolean noUnaddedEmails = this.processValidationResult(this.unaddedEmailValidator.apply((Object)this.emailAddress.getField().getValue(), new ValueContext(this.binder, (Component)this.emailAddress.getField())), (HasValidation)this.emailAddress.getField());
        boolean nonEmptyEmailList = this.processValidationResult(this.nonEmptyEmailListValidator.apply((Object)((Set)this.emailAddress.getValue()), new ValueContext(this.binder, (Component)this.emailAddress)), (HasValidation)this.emailAddress);
        this.binder.setValidatorsDisabled(false);
        if (this.binder.validate().isOk() && noUnaddedEmails && nonEmptyEmailList) {
            this.binder.setValidatorsDisabled(true);
            if (!this.isBulk) {
                Notification notification;
                if (!this.newItemFlag) {
                    try {
                        if (saveAsCopy) {
                            if (this.newItem == null) {
                                this.generateNewItem();
                            }
                            this.binder.writeBean((Object)((Notification)this.newItem));
                        } else {
                            this.binder.writeBean((Object)((Notification)this.itemSet.iterator().next()));
                        }
                    }
                    catch (ValidationException e2) {
                        CommonUiUtils.notify((String)"Failed to write to bean");
                    }
                    notification = saveAsCopy ? (Notification)this.newItem : (Notification)this.itemSet.iterator().next();
                } else {
                    try {
                        this.binder.writeBean((Object)((Notification)this.newItem));
                    }
                    catch (ValidationException e3) {
                        CommonUiUtils.notify((String)"Failed to write to bean");
                    }
                    notification = (Notification)this.newItem;
                }
                notification.setSeverityLevel((Integer)this.severityLevel.getValue() * 100);
                if (this.expression.isVisible()) {
                    notification.setExpression(this.expression.getValue());
                } else {
                    Notification.Expression expression = notification.getExpression();
                    if (expression instanceof Notification.EmailExpression) {
                        Notification.EmailExpression emailExpression = (Notification.EmailExpression)expression;
                        if (this.emailAddress.getValue() != null) {
                            emailExpression.setEmails(new ArrayList<String>((Collection)this.emailAddress.getValue()));
                        } else {
                            emailExpression.setEmails(new ArrayList<String>());
                        }
                    }
                    expression.setMonitorIds(this.filterForMonitors.getValue());
                    notification.setExpression(expression);
                }
                this.saveNotification(saveAsCopy, notification);
                this.addEvent(this.newItemFlag ? "Notification Created" : "Notification Modified", notification.getNotificationId());
            } else {
                for (Notification notification : this.itemSet) {
                    block23: for (R.a formField : this.fieldList) {
                        HasValue<?, ?> field = formField.getField();
                        Checkbox checkbox = formField.getCheckbox();
                        if (checkbox == null || !((Boolean)checkbox.getValue()).booleanValue() || !(field instanceof Component)) continue;
                        switch (((Component)field).getId().orElse("")) {
                            case "targetNode": {
                                notification.setTargetNode((String)field.getValue());
                                break;
                            }
                            case "type": {
                                notification.setType((String)field.getValue());
                                break;
                            }
                            case "expression": {
                                if (!this.expression.isVisible()) break;
                                notification.setExpression(this.expression.getValue());
                                break;
                            }
                            case "email": {
                                Notification.Expression expression;
                                if (!this.emailAddress.isVisible() || !((expression = notification.getExpression()) instanceof Notification.EmailExpression)) continue block23;
                                Notification.EmailExpression emailExpression = (Notification.EmailExpression)expression;
                                emailExpression.setEmails(new ArrayList<String>((Collection)this.emailAddress.getValue()));
                                notification.setExpression(emailExpression);
                                break;
                            }
                            case "severityLevel": {
                                notification.setSeverityLevel((Integer)this.severityLevel.getValue() * 100);
                                break;
                            }
                            case "filterForMonitors": {
                                if (!this.filterForMonitors.isVisible()) break;
                                Notification.Expression expression = notification.getExpression();
                                expression.setMonitorIds(this.filterForMonitors.getValue());
                                notification.setExpression(expression);
                                break;
                            }
                            case "enabled": {
                                notification.setEnabled((Boolean)field.getValue());
                            }
                        }
                    }
                    this.saveNotification(saveAsCopy, notification);
                }
                this.addEvent("Notification Modified", this.itemSet.stream().map(Notification::getNotificationId).collect(Collectors.toSet()));
            }
            if (this.formListener != null) {
                this.formListener.formSaved();
            }
            return true;
        }
        this.binder.setValidatorsDisabled(true);
        return false;
    }

    public void saveNotification(boolean saveAsCopy, Notification notification) {
        if (notification.getTargetNode().endsWith(" only")) {
            notification.setExternalId(this.controller.getSymmetricEngine().getParameterService().getExternalId());
            notification.setNodeGroupId(this.controller.getSymmetricEngine().getParameterService().getNodeGroupId());
        } else {
            notification.setNodeGroupId(notification.getTargetNode());
            notification.setExternalId("ALL");
        }
        notification.setLastUpdateBy(this.controller.getConsoleUser().getUserId());
        notification.setLastUpdateTime(new Date());
        if (saveAsCopy) {
            this.controller.getMonitorService().saveNotificationAsCopy(notification);
        } else if (this.isBulk || this.newItemFlag || this.originalId == null || this.originalId.equals(notification.getNotificationId())) {
            this.controller.getMonitorService().saveNotification(notification);
        } else {
            this.controller.getMonitorService().renameNotification(this.originalId, notification);
        }
    }

    @Override
    public void delete() {
        IMonitorService monitorService = this.controller.getMonitorService();
        for (Notification notification : this.itemSet) {
            monitorService.deleteNotification(notification.getNotificationId());
        }
        this.addEvent("Notification Deleted", this.itemSet.stream().map(Notification::getNotificationId).collect(Collectors.toSet()));
        if (this.formListener != null) {
            this.formListener.formDeleted();
        }
    }

    @Override
    protected List<String> getOrderedFieldIds() {
        ArrayList<String> orderedFields = new ArrayList<String>();
        orderedFields.add("notificationId");
        orderedFields.add("targetNode");
        orderedFields.add("type");
        orderedFields.add("expression");
        orderedFields.add("email");
        orderedFields.add("severityLevel");
        orderedFields.add("filterForMonitors");
        orderedFields.add("enabled");
        return orderedFields;
    }

    @Override
    public String getKeyId() {
        return "notificationId";
    }

    @Override
    public String getHelpSectionName() {
        return "_notifications";
    }
}

