/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.impl.R;
import com.jumpmind.symmetric.console.ui.common.I;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.select.Select;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.ValidationException;
import com.vaadin.flow.function.SerializablePredicate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jumpmind.symmetric.model.NodeGroup;
import org.jumpmind.symmetric.model.NodeGroupLink;
import org.jumpmind.symmetric.model.NodeGroupLinkAction;
import org.jumpmind.symmetric.model.Router;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.ITriggerRouterService;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;

public class aa
extends R<NodeGroupLink> {
    private static final long serialVersionUID = 1L;
    private String originalSourceId;
    private String originalTargetId;

    public aa(I controller, Set<NodeGroupLink> itemSet, boolean newItemFlag, boolean deleteFlag) {
        super(controller, itemSet, newItemFlag, deleteFlag);
    }

    @Override
    public void initFields() {
        if (!this.newItemFlag && !this.isBulk) {
            this.originalSourceId = ((NodeGroupLink)this.itemSet.iterator().next()).getSourceNodeGroupId();
            this.originalTargetId = ((NodeGroupLink)this.itemSet.iterator().next()).getTargetNodeGroupId();
        }
        this.binder = new Binder(NodeGroupLink.class);
        IConfigurationService configService = this.controller.getSymmetricEngine().getConfigurationService();
        ArrayList<String> nodeGroupIds = new ArrayList<String>();
        for (NodeGroup nodeGroup : configService.getNodeGroups()) {
            nodeGroupIds.add(nodeGroup.getNodeGroupId());
        }
        Select sourceNodeGroupId = new Select();
        sourceNodeGroupId.setItems(nodeGroupIds);
        sourceNodeGroupId.setId("sourceNodeGroupId");
        this.formatComboBox(sourceNodeGroupId);
        this.binder.forField((HasValue)sourceNodeGroupId).withValidator((SerializablePredicate & Serializable)value -> value != null || this.isBulk, this.controller.getMessage("%s is required.", "Source Group Id")).bind("sourceNodeGroupId");
        sourceNodeGroupId.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a(this, (HasValue<?, ?>)sourceNodeGroupId, this.controller.getMessage("Source Group Id", new Object[0])));
        ArrayList<NodeGroupLinkAction> actionList = new ArrayList<NodeGroupLinkAction>();
        actionList.add(NodeGroupLinkAction.P);
        actionList.add(NodeGroupLinkAction.W);
        actionList.add(NodeGroupLinkAction.R);
        Select dataEventAction = new Select();
        dataEventAction.setItems(actionList);
        dataEventAction.setId("dataEventAction");
        this.formatComboBox(dataEventAction);
        this.binder.forField((HasValue)dataEventAction).withValidator((SerializablePredicate & Serializable)value -> value != null || this.isBulk, this.controller.getMessage("%s is required.", "Link")).bind("dataEventAction");
        dataEventAction.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a(this, (HasValue<?, ?>)dataEventAction, this.controller.getMessage("Link", new Object[0])));
        Select targetNodeGroupId = new Select();
        targetNodeGroupId.setItems(nodeGroupIds);
        targetNodeGroupId.setId("targetNodeGroupId");
        this.formatComboBox(targetNodeGroupId);
        this.binder.forField((HasValue)targetNodeGroupId).withValidator((SerializablePredicate & Serializable)value -> value != null || this.isBulk, this.controller.getMessage("%s is required.", "Target Group Id")).bind("targetNodeGroupId");
        targetNodeGroupId.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a(this, (HasValue<?, ?>)targetNodeGroupId, this.controller.getMessage("Target Group Id", new Object[0])));
        this.advancedFieldList = new ArrayList();
        Checkbox syncConfigEnabled = new Checkbox();
        syncConfigEnabled.setId("syncConfigEnabled");
        this.binder.forField((HasValue)syncConfigEnabled).bind("syncConfigEnabled");
        this.advancedFieldList.add(new R.a(this, (HasValue<?, ?>)syncConfigEnabled, this.controller.getMessage("Sync Configuration", new Object[0])));
        Checkbox syncSqlEnabled = new Checkbox();
        syncSqlEnabled.setId("syncSqlEnabled");
        this.binder.forField((HasValue)syncSqlEnabled).bind("syncSqlEnabled");
        this.advancedFieldList.add(new R.a(this, (HasValue<?, ?>)syncSqlEnabled, this.controller.getMessage("Sync SQL/DDL", new Object[0])));
        Checkbox reversible = new Checkbox();
        reversible.setId("reversible");
        this.binder.forField((HasValue)reversible).bind("reversible");
        this.advancedFieldList.add(new R.a(this, (HasValue<?, ?>)reversible, this.controller.getMessage("Reversible", new Object[0])));
    }

    @Override
    protected void generateNewItem() {
        NodeGroupLink groupLink = new NodeGroupLink();
        groupLink.setDataEventAction(NodeGroupLinkAction.P);
        groupLink.setSourceNodeGroupId(null);
        groupLink.setTargetNodeGroupId(null);
        this.newItem = groupLink;
    }

    @Override
    public boolean save(boolean saveAsCopy) {
        if (this.binder.validate().isOk()) {
            if (!this.isBulk) {
                NodeGroupLink link;
                if (!this.newItemFlag) {
                    try {
                        this.binder.writeBean((Object)((NodeGroupLink)this.itemSet.iterator().next()));
                    }
                    catch (ValidationException e2) {
                        CommonUiUtils.notify((String)"Failed to write to bean");
                    }
                    link = (NodeGroupLink)this.itemSet.iterator().next();
                } else {
                    try {
                        this.binder.writeBean((Object)((NodeGroupLink)this.newItem));
                    }
                    catch (ValidationException e3) {
                        CommonUiUtils.notify((String)"Failed to write to bean");
                    }
                    link = (NodeGroupLink)this.newItem;
                }
                this.saveGroupLink(link);
                this.syncTriggers();
                this.addEvent(this.newItemFlag ? "Group Link Created" : "Group Link Modified", link.toString());
            } else {
                for (NodeGroupLink link : this.itemSet) {
                    this.saveFieldsToGroupLink(this.fieldList, link);
                    this.saveFieldsToGroupLink(this.advancedFieldList, link);
                    this.saveGroupLink(link);
                }
                this.syncTriggers();
                this.addEvent("Group Link Modified", this.itemSet.stream().map(NodeGroupLink::toString).collect(Collectors.toSet()));
            }
            if (this.formListener != null) {
                this.formListener.formSaved();
            }
            return true;
        }
        return false;
    }

    private void saveFieldsToGroupLink(List<R.a> fields, NodeGroupLink link) {
        for (R.a formField : fields) {
            HasValue<?, ?> field = formField.getField();
            Checkbox checkbox = formField.getCheckbox();
            if (checkbox == null || !((Boolean)checkbox.getValue()).booleanValue() || !(field instanceof Component)) continue;
            switch (((Component)field).getId().orElse("")) {
                case "dataEventAction": {
                    link.setDataEventAction((NodeGroupLinkAction)field.getValue());
                    break;
                }
                case "syncConfigEnabled": {
                    link.setSyncConfigEnabled(((Boolean)field.getValue()).booleanValue());
                    break;
                }
                case "syncSqlEnabled": {
                    link.setSyncSqlEnabled(((Boolean)field.getValue()).booleanValue());
                    break;
                }
                case "reversible": {
                    link.setReversible(((Boolean)field.getValue()).booleanValue());
                }
            }
        }
    }

    private void saveGroupLink(NodeGroupLink link) {
        IConfigurationService configService = this.controller.getSymmetricEngine().getConfigurationService();
        ITriggerRouterService triggerRouterService = this.controller.getSymmetricEngine().getTriggerRouterService();
        link.setLastUpdateBy(this.controller.getConsoleUser().getUserId());
        if (this.isBulk || this.newItemFlag || this.originalSourceId == null || this.originalTargetId == null || this.originalSourceId.equals(link.getSourceNodeGroupId()) && this.originalTargetId.equals(link.getTargetNodeGroupId())) {
            configService.saveNodeGroupLink(link);
        } else {
            configService.renameNodeGroupLink(this.originalSourceId, this.originalTargetId, link);
        }
        if (triggerRouterService.getRoutersByGroupLink(link).size() == 0) {
            Router router = new Router();
            router.setNodeGroupLink(link);
            router.setRouterId(router.createDefaultName());
            router.setLastUpdateBy(this.controller.getConsoleUser().getUserId());
            triggerRouterService.saveRouter(router);
        }
    }

    @Override
    public void delete() {
        IConfigurationService configService = this.controller.getSymmetricEngine().getConfigurationService();
        for (NodeGroupLink link : this.itemSet) {
            configService.deleteNodeGroupLink(link);
        }
        this.syncTriggers();
        this.addEvent("Group Link Deleted", this.itemSet.stream().map(NodeGroupLink::toString).collect(Collectors.toSet()));
        if (this.formListener != null) {
            this.formListener.formDeleted();
        }
    }

    protected void syncTriggers() {
        ITriggerRouterService triggerRouterService = this.controller.getSymmetricEngine().getTriggerRouterService();
        if (!this.controller.getSymmetricEngine().getParameterService().is("auto.sync.triggers.after.config.change")) {
            triggerRouterService.syncTriggers();
        }
    }

    @Override
    protected List<String> getOrderedFieldIds() {
        ArrayList<String> orderedFields = new ArrayList<String>();
        if (!this.isBulk) {
            orderedFields.add("sourceNodeGroupId");
        }
        orderedFields.add("dataEventAction");
        if (!this.isBulk) {
            orderedFields.add("targetNodeGroupId");
        }
        orderedFields.add("syncConfigEnabled");
        orderedFields.add("syncSqlEnabled");
        orderedFields.add("reversible");
        return orderedFields;
    }

    @Override
    public String getKeyId() {
        return "sourceNodeGroupId";
    }

    @Override
    public String getHelpSectionName() {
        return "_group_links";
    }
}

