/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.impl.R;
import com.jumpmind.symmetric.console.impl.V;
import com.jumpmind.symmetric.console.impl.hb;
import com.jumpmind.symmetric.console.model.ConsoleUser;
import com.jumpmind.symmetric.console.service.IConsoleUserService;
import com.jumpmind.symmetric.console.ui.common.H;
import com.jumpmind.symmetric.console.ui.common.I;
import com.jumpmind.symmetric.console.ui.common.as;
import com.jumpmind.symmetric.console.ui.common.b;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.confirmdialog.ConfirmDialog;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.model.IModelObject;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;

public class aY
extends b<ConsoleUser>
implements H {
    private static final long d = 1L;
    protected Button a;
    protected ISymmetricEngine b;
    protected hb c;

    public aY(I controller) {
        super(aY.a(controller), controller);
    }

    private static String a(I controller) {
        IParameterService ps = controller.getSymmetricEngine().getParameterService();
        ArrayList<String> authMethods = new ArrayList<String>();
        for (ConsoleUser user : controller.getConsoleUserService().findConsoleUsers()) {
            String authMethod = user.getAuthenticationMethod();
            if (authMethods.contains(authMethod)) continue;
            authMethods.add(authMethod);
        }
        if (ps.getString("console.auth.saml.role.group.map") != null && !authMethods.contains("SAML")) {
            authMethods.add("SAML");
        }
        if (ps.getString("console.auth.oauth2.role.map") != null && !authMethods.contains("OAUTH2")) {
            authMethods.add("OAUTH2");
        }
        return String.format("<b>Current authentication methods in use are %s.</b><br/><br/>  User credentials are used to secure the SymmetricDS Pro console.", String.join((CharSequence)", ", authMethods));
    }

    @Override
    public String getTitleKey() {
        return "Users";
    }

    @Override
    public String getEditTitle() {
        return "Edit '%s' User";
    }

    @Override
    public String getNewTitle() {
        return "New User";
    }

    protected String a(ConsoleUser item) {
        return item.getUserId();
    }

    @Override
    protected R<ConsoleUser> createForm(boolean newItemFlag, boolean deleteFlag) {
        return new V(this.controller, this.grid.getSelectedItems(), newItemFlag, deleteFlag);
    }

    @Override
    protected void addButtonsMiddle(FlexLayout buttonLayout) {
        this.a = new Button(this.message("Reset 2FA"));
        this.a.getStyle().set("margin", "4px");
        if (this.grid.getSelectedItems().isEmpty()) {
            this.a.setEnabled(false);
        }
        this.a.addClickListener((ComponentEventListener & Serializable)event -> {
            if (!this.grid.getSelectedItems().isEmpty()) {
                ConsoleUser user = (ConsoleUser)this.grid.getSelectedItems().iterator().next();
                new ConfirmDialog("[" + user.getUserId() + "] " + this.controller.getMessage("Privileges", new Object[0]), "Confirm the reset of two-factor authentication for this user?", this.controller.getMessage("Confirm", new Object[0]), (ComponentEventListener & Serializable)e2 -> {
                    user.setOtpKey(null);
                    this.controller.getConsoleUserService().save(user);
                }, this.controller.getMessage("Cancel", new Object[0]), (ComponentEventListener & Serializable)e2 -> {}).open();
            }
        });
        if (this.controller.getSymmetricEngine().getParameterService().is("console.password.otp")) {
            buttonLayout.add(new Component[]{this.a});
        }
        this.noItemsSelected();
    }

    @Override
    protected void initGrid() {
        this.grid = new Grid(ConsoleUser.class);
    }

    @Override
    protected void configureGridColumns() {
        super.configureGridColumns();
        this.columnVisibilityToggler.removeColumn(this.grid.getColumnByKey("lastLoginTime"));
        this.grid.removeColumnByKey("lastLoginTime");
        this.columnVisibilityToggler.addColumn(((Grid.Column)this.grid.addColumn((ValueProvider & Serializable)user -> as.formatDate(this.controller, user.getLastLoginTime())).setKey("lastLoginTime").setHeader(this.controller.getMessage("Last Login Time", new Object[0])).setResizable(true)).setComparator((ValueProvider & Serializable)user -> user.getLastLoginTime()), this.controller.getMessage("Last Login Time", new Object[0]));
        this.grid.setColumnOrder(Arrays.asList(this.grid.getColumnByKey("userId"), this.grid.getColumnByKey("lastName"), this.grid.getColumnByKey("firstName"), this.grid.getColumnByKey("authenticationMethod"), this.grid.getColumnByKey("role"), this.grid.getColumnByKey("lastLoginTime"), this.grid.getColumnByKey("lastLoginIpAddr"), this.grid.getColumnByKey("failedLoginAttempts"), this.grid.getColumnByKey("resetRequired"), this.grid.getColumnByKey("glassBreakRequired"), this.grid.getColumnByKey("enabled"), this.grid.getColumnByKey("lastUpdateTime"), this.grid.getColumnByKey("lastUpdateBy"), this.grid.getColumnByKey("createTime")));
    }

    @Override
    protected void fillGrid(Grid<ConsoleUser> grid) {
        String searchValue;
        if (this.c == null) {
            this.c = new hb(this.controller.getConsoleUserService());
        }
        IConsoleUserService userService = this.controller.getConsoleUserService();
        if (this.itemList != null) {
            this.itemList.clear();
        }
        if (!StringUtils.isBlank((CharSequence)(searchValue = this.searchField.getValue()))) {
            List<ConsoleUser> allUsers = userService.findConsoleUsers();
            for (ConsoleUser user : allUsers) {
                if (CommonUiUtils.isFilteredOut((String)user.getUserId(), (String)searchValue)) continue;
                this.itemList.add(user);
            }
        } else {
            this.itemList = userService.findConsoleUsers();
        }
        if (this.itemList != null) {
            this.updateItems(this.itemList);
        }
    }

    @Override
    protected boolean isDeleteEnabled(StringBuilder tooltip) {
        Set selectedUsers = this.grid.getSelectedItems();
        if (!selectedUsers.isEmpty()) {
            ConsoleUser currentUser = this.controller.getConsoleUser();
            if (currentUser != null) {
                if (!currentUser.hasPrivilegeWrite("Users Screen")) {
                    tooltip.append(String.format("Your role '%s' does not have the privileges needed for this action.", currentUser.getRole()));
                    return false;
                }
                String currentUserId = currentUser.getUserId();
                if (currentUserId != null && selectedUsers.stream().anyMatch(user -> currentUserId.equals(user.getUserId()))) {
                    tooltip.append(String.format("The user '%s' cannot delete themself.", currentUserId));
                    return false;
                }
                String userRole = this.controller.getConsoleUser().getRole();
                if (userRole.equalsIgnoreCase("ADMIN")) {
                    return true;
                }
                if (this.c.d(userRole)) {
                    List<String> descendentRoleIds = this.c.e(userRole);
                    if (this.grid.getSelectedItems().stream().anyMatch(user -> !descendentRoleIds.contains(user.getRole()))) {
                        return false;
                    }
                } else if (this.grid.getSelectedItems().stream().anyMatch(user -> this.c.d(user.getRole()) || user.getRole().equals("ADMIN"))) {
                    return false;
                }
                return true;
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean isNewEnabled(StringBuilder tooltip) {
        if (this.controller.getConsoleUser().hasPrivilegeWrite("Users Screen")) {
            return true;
        }
        String consoleRoleId = "unknown";
        if (this.controller.getConsoleUser().getRole() != null) {
            consoleRoleId = this.controller.getConsoleUser().getRole();
        }
        tooltip.append(String.format("Your role '%s' does not have the privileges needed for this action.", consoleRoleId));
        return false;
    }

    @Override
    protected boolean isEditEnabled(StringBuilder tooltip) {
        if (this.controller.getConsoleUser().hasPrivilegeWrite("Users Screen")) {
            String userRole = this.controller.getConsoleUser().getRole();
            if (userRole.equalsIgnoreCase("ADMIN")) {
                return true;
            }
            if (this.c.d(userRole)) {
                List<String> descendentRoleIds = this.c.e(userRole);
                if (this.grid.getSelectedItems().stream().anyMatch(user -> !descendentRoleIds.contains(user.getRole()) && !user.getUserId().equals(this.controller.getConsoleUser().getUserId()))) {
                    return false;
                }
            } else if (this.grid.getSelectedItems().stream().anyMatch(user -> this.c.d(user.getRole()) || user.getRole().equals("ADMIN"))) {
                return false;
            }
            return true;
        }
        String consoleRoleId = "unknown";
        if (this.controller.getConsoleUser().getRole() != null) {
            consoleRoleId = this.controller.getConsoleUser().getRole();
        }
        tooltip.append(String.format("Your role '%s' does not have the privileges needed for this action.", consoleRoleId));
        return false;
    }

    @Override
    protected boolean gridCanBeModified() {
        return this.controller.getConsoleUser().hasPrivilegeRead("Users Screen");
    }

    @Override
    protected boolean canSaveAsCopy() {
        Set selectedUsers = this.grid.getSelectedItems();
        String userRole = this.controller.getConsoleUser().getRole();
        return !selectedUsers.contains(this.controller.getConsoleUser()) || userRole.equals("ADMIN") || !this.c.d(userRole);
    }

    @Override
    protected String getKeyColumn() {
        return "userId";
    }

    @Override
    protected String[] getFilterColumns() {
        String[] columns = new String[]{"lastName", "firstName"};
        return columns;
    }

    @Override
    protected Map<String, String> getVisibleGridColumns() {
        LinkedHashMap<String, String> columns = new LinkedHashMap<String, String>();
        columns.put("userId", this.controller.getMessage("User Id", new Object[0]));
        columns.put("lastName", this.controller.getMessage("Last Name", new Object[0]));
        columns.put("firstName", this.controller.getMessage("First Name", new Object[0]));
        columns.put("authenticationMethod", this.controller.getMessage("Authenticantion Method", new Object[0]));
        columns.put("role", this.controller.getMessage("Role", new Object[0]));
        columns.put("lastLoginTime", this.controller.getMessage("Last Login Time", new Object[0]));
        columns.put("lastLoginIpAddr", this.controller.getMessage("Last Login IP Address", new Object[0]));
        columns.put("failedLoginAttempts", this.controller.getMessage("Failed Login Attempts", new Object[0]));
        columns.put("resetRequired", this.controller.getMessage("Password Reset Required", new Object[0]));
        columns.put("glassBreakRequired", this.controller.getMessage("Glass Break Required", new Object[0]));
        columns.put("enabled", this.controller.getMessage("Enabled", new Object[0]));
        return columns;
    }

    @Override
    protected void hideColumns() {
        this.grid.getColumnByKey("lastUpdateTime").setVisible(false);
        this.grid.getColumnByKey("lastUpdateBy").setVisible(false);
        this.grid.getColumnByKey("createTime").setVisible(false);
    }

    @Override
    public String getDocAnchor() {
        return "/doc/html/user-guide.html#_users";
    }

    @Override
    protected /* synthetic */ String getId(IModelObject iModelObject) {
        return this.a((ConsoleUser)iModelObject);
    }

    private static /* synthetic */ Object a(SerializedLambda lambda) {
        switch (lambda.getImplMethodName()) {
            case "lambda$addButtonsMiddle$bb23947b$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/ConsoleUserEditPanel") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/model/ConsoleUser;Lcom/vaadin/flow/component/confirmdialog/ConfirmDialog$ConfirmEvent;)V")) break;
                return arg_0 -> ((aY)lambda.getCapturedArg(0)).a((ConsoleUser)lambda.getCapturedArg(1), arg_0);
            }
            case "lambda$configureGridColumns$ba6e7b7d$2": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/ConsoleUserEditPanel") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/model/ConsoleUser;)Ljava/util/Date;")) break;
                return (ValueProvider & Serializable)user -> user.getLastLoginTime();
            }
            case "lambda$addButtonsMiddle$d01c01f6$1": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/ConsoleUserEditPanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/confirmdialog/ConfirmDialog$CancelEvent;)V")) break;
                return (ComponentEventListener & Serializable)e2 -> {};
            }
            case "lambda$configureGridColumns$ba6e7b7d$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/ConsoleUserEditPanel") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/model/ConsoleUser;)Ljava/lang/Object;")) break;
                return (ValueProvider & Serializable)user -> as.formatDate(this.controller, user.getLastLoginTime());
            }
            case "lambda$addButtonsMiddle$d01c01f6$2": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/ConsoleUserEditPanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                return (ComponentEventListener & Serializable)event -> {
                    if (!this.grid.getSelectedItems().isEmpty()) {
                        ConsoleUser user = (ConsoleUser)this.grid.getSelectedItems().iterator().next();
                        new ConfirmDialog("[" + user.getUserId() + "] " + this.controller.getMessage("Privileges", new Object[0]), "Confirm the reset of two-factor authentication for this user?", this.controller.getMessage("Confirm", new Object[0]), (ComponentEventListener & Serializable)e2 -> {
                            user.setOtpKey(null);
                            this.controller.getConsoleUserService().save(user);
                        }, this.controller.getMessage("Cancel", new Object[0]), (ComponentEventListener & Serializable)e2 -> {}).open();
                    }
                };
            }
        }
        throw new IllegalArgumentException("Invalid lambda deserialization");
    }
}

