/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.impl.I;
import com.jumpmind.symmetric.console.impl.R;
import com.jumpmind.symmetric.console.impl.U;
import com.jumpmind.symmetric.console.impl.hb;
import com.jumpmind.symmetric.console.model.ConsolePrivilege;
import com.jumpmind.symmetric.console.model.ConsolePrivilegeEdit;
import com.jumpmind.symmetric.console.model.ConsoleRole;
import com.jumpmind.symmetric.console.model.ConsoleScreen;
import com.jumpmind.symmetric.console.model.ConsoleTab;
import com.jumpmind.symmetric.console.model.ConsoleUser;
import com.jumpmind.symmetric.console.service.IConsoleUserService;
import com.jumpmind.symmetric.console.ui.common.H;
import com.jumpmind.symmetric.console.ui.common.as;
import com.jumpmind.symmetric.console.ui.common.b;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.server.Command;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.model.IModelObject;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;

public class aX
extends b<ConsoleRole>
implements H {
    protected Button a;
    protected Button b;
    protected Button c;
    private static final String e = "Visible";
    private static final String f = "Hidden";
    private static final String g = "Read/Write";
    private static final long h = 1L;
    protected VerticalLayout d;

    public aX(com.jumpmind.symmetric.console.ui.common.I controller) {
        super("Role credentials are used to customize the SymmetricDS Pro user roles.", controller);
    }

    @Override
    public String getTitleKey() {
        return "Roles";
    }

    @Override
    public String getEditTitle() {
        return "Edit '%s' Role";
    }

    @Override
    public String getNewTitle() {
        return "New Role";
    }

    protected String a(ConsoleRole item) {
        return item.getRoleId();
    }

    @Override
    protected R<ConsoleRole> createForm(boolean newItemFlag, boolean deleteFlag) {
        return new U(this.controller, this.grid.getSelectedItems(), newItemFlag, deleteFlag);
    }

    @Override
    protected void itemSelected() {
        if (this.a != null) {
            if (!this.grid.getSelectedItems().isEmpty()) {
                if (this.controller.getConsoleUser().hasPrivilegeWrite("Roles Screen")) {
                    if (this.grid.getSelectedItems().size() == 1) {
                        this.a.setEnabled(true);
                    } else {
                        this.a.setEnabled(false);
                    }
                } else {
                    this.a.setEnabled(false);
                }
            }
            if (!this.a.isEnabled() && !this.controller.getConsoleUser().hasPrivilegeWrite("Roles Screen")) {
                this.a.getElement().setAttribute("title", String.format("Your role '%s' does not have the privileges needed for this action.", this.controller.getConsoleUser().getRole()));
            }
        }
    }

    @Override
    protected void noItemsSelected() {
        if (this.grid.getSelectedItems().isEmpty()) {
            if (this.a != null) {
                this.a.setEnabled(false);
            }
        } else {
            this.itemSelected();
        }
    }

    @Override
    protected void addButtonsMiddle(FlexLayout buttonLayout) {
        String buttonText = "Edit Privileges";
        if (!this.grid.getSelectedItems().isEmpty()) {
            for (ConsoleRole role : this.grid.getSelectedItems()) {
                if (role.getRoleId().equalsIgnoreCase("ADMIN") || role.getRoleId().equalsIgnoreCase("READ") || role.getRoleId().equalsIgnoreCase("WRITE")) {
                    buttonText = "View Privileges";
                    continue;
                }
                buttonText = "Edit Privileges";
            }
        }
        this.a = new Button(this.message(buttonText));
        this.a.getStyle().set("margin", "4px");
        this.a.addClickListener((ComponentEventListener & Serializable)event -> {
            if (!this.grid.getSelectedItems().isEmpty()) {
                new a((ConsoleRole)this.grid.getSelectedItems().iterator().next()).open();
            }
        });
        buttonLayout.add(new Component[]{this.a});
        this.noItemsSelected();
    }

    @Override
    protected void initGrid() {
        this.grid = new Grid(ConsoleRole.class);
    }

    @Override
    protected void fillGrid(Grid<ConsoleRole> grid) {
        String searchValue;
        IConsoleUserService consoleRoleService = this.controller.getConsoleUserService();
        if (this.itemList != null) {
            this.itemList.clear();
        }
        if (!StringUtils.isBlank((CharSequence)(searchValue = this.searchField.getValue()))) {
            List<ConsoleRole> allConsoleRoles = consoleRoleService.findConsoleRoles();
            for (ConsoleRole role : allConsoleRoles) {
                if (CommonUiUtils.isFilteredOut((String)role.getRoleId(), (String)searchValue)) continue;
                this.itemList.add(role);
            }
        } else {
            this.itemList = consoleRoleService.findConsoleRoles();
        }
        this.updateItems(this.itemList);
    }

    @Override
    protected boolean isNewEnabled(StringBuilder tooltip) {
        if (this.controller.getConsoleUser().hasPrivilegeWrite("Roles Screen")) {
            return true;
        }
        String consoleRoleId = "unknown";
        if (this.controller.getConsoleUser().getRole() != null) {
            consoleRoleId = this.controller.getConsoleUser().getRole();
        }
        tooltip.append(String.format("Your role '%s' does not have the privileges needed for this action.", consoleRoleId));
        return false;
    }

    @Override
    protected boolean isEditEnabled(StringBuilder tooltip) {
        if (!this.grid.getSelectedItems().isEmpty()) {
            if (!this.controller.getConsoleUser().hasPrivilegeWrite("Roles Screen")) {
                tooltip.append(String.format("Your role '%s' does not have the privileges needed for this action.", this.controller.getConsoleUser().getRole()));
                return false;
            }
            for (ConsoleRole role : this.grid.getSelectedItems()) {
                String roleId = role.getRoleId();
                if (!roleId.equalsIgnoreCase("ADMIN") && !roleId.equalsIgnoreCase("WRITE") && !roleId.equalsIgnoreCase("READ")) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean isDeleteEnabled(StringBuilder tooltip) {
        if (!this.grid.getSelectedItems().isEmpty()) {
            ArrayList<ConsoleUser> userList = new ArrayList<ConsoleUser>(this.controller.getConsoleUserService().findConsoleUsers());
            for (ConsoleRole role : this.grid.getSelectedItems()) {
                String roleId = role.getRoleId();
                if (!this.controller.getConsoleUser().hasPrivilegeWrite("Roles Screen")) {
                    tooltip.append(String.format("Your role '%s' does not have the privileges needed for this action.", roleId));
                    return false;
                }
                if (roleId.equalsIgnoreCase("ADMIN") || roleId.equalsIgnoreCase("READ") || roleId.equalsIgnoreCase("WRITE") || StringUtils.isBlank((CharSequence)roleId)) {
                    return false;
                }
                hb roleHierarchyUtils = new hb(this.controller.getConsoleUserService());
                if (roleHierarchyUtils.a(roleId)) {
                    return false;
                }
                for (int i2 = 0; i2 < userList.size(); ++i2) {
                    if (!((ConsoleUser)userList.get(i2)).getRole().equalsIgnoreCase(role.getRoleId())) continue;
                    tooltip.append(String.format("The role '%s' is assigned to users, and cannot be deleted.", roleId));
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean gridCanBeModified() {
        return this.controller.getConsoleUser().hasPrivilegeRead("Roles Screen");
    }

    @Override
    protected String getKeyColumn() {
        return "roleId";
    }

    @Override
    protected String[] getFilterColumns() {
        String[] columns = new String[]{"roleId"};
        return columns;
    }

    @Override
    protected Map<String, String> getVisibleGridColumns() {
        LinkedHashMap<String, String> columns = new LinkedHashMap<String, String>();
        columns.put("roleId", this.controller.getMessage("Role Id", new Object[0]));
        columns.put("roleDescription", this.controller.getMessage("Role Description", new Object[0]));
        columns.put("createTime", this.controller.getMessage("Role Privileges", new Object[0]));
        columns.put("parentRoleId", this.controller.getMessage("Parent Role Id", new Object[0]));
        return columns;
    }

    @Override
    protected void hideColumns() {
        this.grid.getColumnByKey("lastUpdateTime").setVisible(false);
        this.grid.getColumnByKey("lastUpdateBy").setVisible(false);
        this.grid.getColumnByKey("createTime").setVisible(false);
    }

    @Override
    protected boolean canSaveAsCopy() {
        return true;
    }

    @Override
    public String getDocAnchor() {
        return "/doc/html/user-guide.html#_roles";
    }

    @Override
    protected /* synthetic */ String getId(IModelObject iModelObject) {
        return this.a((ConsoleRole)iModelObject);
    }

    private static /* synthetic */ Object a(SerializedLambda lambda) {
        switch (lambda.getImplMethodName()) {
            case "lambda$addButtonsMiddle$d01c01f6$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/ConsoleRoleEditPanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                return (ComponentEventListener & Serializable)event -> {
                    if (!this.grid.getSelectedItems().isEmpty()) {
                        new a((ConsoleRole)this.grid.getSelectedItems().iterator().next()).open();
                    }
                };
            }
        }
        throw new IllegalArgumentException("Invalid lambda deserialization");
    }

    class a
    extends Dialog {
        private static final long g = 1L;
        protected Grid<ConsolePrivilegeEdit> a;
        protected ComboBox<String> b;
        protected TextField c;
        protected Button d;
        protected Span e;
        private VerticalLayout h;

        public a(ConsoleRole consoleRole) {
            this.setModal(true);
            this.setResizable(true);
            this.setWidth("1000px");
            this.setHeight("900px");
            VerticalLayout content = new VerticalLayout();
            content.setSizeFull();
            content.setPadding(false);
            this.add(new Component[]{content});
            this.setHeaderTitle("[" + consoleRole.getRoleId() + "] Privileges");
            this.h = new VerticalLayout();
            this.h.setWidthFull();
            this.h.setMargin(false);
            this.h.setClassName("dialog-content");
            content.addAndExpand(new Component[]{this.h});
            IConsoleUserService consoleRoleService = aX.this.controller.getConsoleUserService();
            UI.getCurrent().addShortcutListener((Command & Serializable)() -> {
                if (this.getWidth() != "100%") {
                    this.setWidth("100%");
                    this.setHeight("100%");
                } else {
                    this.setWidth("1000px");
                    this.setHeight("900px");
                }
            }, Key.KEY_M, new KeyModifier[]{KeyModifier.CONTROL});
            List<ConsolePrivilege> selectedRolePrivileges = consoleRoleService.findConsolePrivileges(consoleRole.getRoleId());
            ArrayList<ConsolePrivilegeEdit> privsFromDataBase = new ArrayList<ConsolePrivilegeEdit>();
            ArrayList<String> databasePrivs = new ArrayList<String>();
            for (ConsolePrivilege dbPrivilege : selectedRolePrivileges) {
                privsFromDataBase.add(new ConsolePrivilegeEdit("", "", dbPrivilege.getPrivilegeId(), "", "", dbPrivilege.isReadFlag(), dbPrivilege.isWriteFlag()));
                databasePrivs.add(dbPrivilege.getPrivilegeId());
            }
            ArrayList radioButtonList = new ArrayList();
            ArrayList<ConsoleTab> tabList = new ArrayList<ConsoleTab>(I.a());
            LinkedHashSet<ConsolePrivilegeEdit> completePrivilegesList = new LinkedHashSet<ConsolePrivilegeEdit>();
            for (ConsoleTab tab : tabList) {
                for (ConsoleScreen consoleScreen : tab.getScreens()) {
                    for (String priv2 : consoleScreen.getPrivileges()) {
                        if (databasePrivs.contains(priv2)) {
                            for (ConsolePrivilegeEdit privDataBaseCheck : privsFromDataBase) {
                                if (!priv2.equalsIgnoreCase(privDataBaseCheck.getPrivilegeId())) continue;
                                if (priv2.endsWith("Tab")) {
                                    privDataBaseCheck.setDisplayTabId(tab.getTabId());
                                    privDataBaseCheck.setDisplayScreenId("");
                                    privDataBaseCheck.setScreenId("");
                                    privDataBaseCheck.setTabId(tab.getTabId());
                                    privDataBaseCheck.setPrivilegeId("");
                                    completePrivilegesList.add(privDataBaseCheck);
                                    continue;
                                }
                                if (priv2.contains("Screen")) {
                                    privDataBaseCheck.setDisplayTabId("");
                                    privDataBaseCheck.setDisplayScreenId(consoleScreen.getScreenId());
                                    privDataBaseCheck.setScreenId(consoleScreen.getScreenId());
                                    privDataBaseCheck.setTabId(tab.getTabId());
                                    privDataBaseCheck.setPrivilegeId("");
                                    completePrivilegesList.add(privDataBaseCheck);
                                    continue;
                                }
                                privDataBaseCheck.setDisplayTabId("");
                                privDataBaseCheck.setDisplayScreenId("");
                                privDataBaseCheck.setScreenId(consoleScreen.getScreenId());
                                privDataBaseCheck.setTabId(tab.getTabId());
                                completePrivilegesList.add(privDataBaseCheck);
                            }
                            continue;
                        }
                        if (priv2.endsWith("Tab")) {
                            completePrivilegesList.add(new ConsolePrivilegeEdit(tab.getTabId(), "", "", "", tab.getTabId(), false, false));
                            continue;
                        }
                        if (priv2.contains("Screen")) {
                            completePrivilegesList.add(new ConsolePrivilegeEdit("", consoleScreen.getScreenId(), "", consoleScreen.getScreenId(), tab.getTabId(), false, false));
                            continue;
                        }
                        completePrivilegesList.add(new ConsolePrivilegeEdit("", "", priv2, consoleScreen.getScreenId(), tab.getTabId(), false, false));
                    }
                }
            }
            LinkedHashSet<String> tabFilterList = new LinkedHashSet<String>();
            ListDataProvider dataProvider = new ListDataProvider(completePrivilegesList);
            ArrayList privilegeList = new ArrayList(completePrivilegesList);
            this.b = new ComboBox("Filter by tab: ");
            this.b.setWidth("200px");
            tabFilterList.add("Tabs Only");
            tabFilterList.add("All Privileges");
            for (ConsolePrivilegeEdit privFilterList : privilegeList) {
                if (privFilterList.getTabId().equalsIgnoreCase("")) continue;
                tabFilterList.add(privFilterList.getTabId());
            }
            dataProvider.addFilter((SerializablePredicate & Serializable)priv -> !priv.getDisplayTabId().equalsIgnoreCase(""));
            this.b.setItems((ComboBox.ItemFilter & Serializable)(item, filter) -> !CommonUiUtils.isFilteredOut((String)item, (String)filter), tabFilterList);
            this.b.setValue((Object)"Tabs Only");
            this.b.setAllowCustomValue(false);
            this.b.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                dataProvider.clearFilters();
                for (String filterOption : I.bG) {
                    if (!((String)event.getValue()).toString().equalsIgnoreCase(filterOption)) continue;
                    if (filterOption.equalsIgnoreCase("Tabs Only")) {
                        dataProvider.addFilter((SerializablePredicate & Serializable)priv -> !priv.getDisplayTabId().equalsIgnoreCase(""));
                        continue;
                    }
                    dataProvider.addFilter((SerializablePredicate & Serializable)priv -> priv.getTabId().equalsIgnoreCase(filterOption));
                }
                this.a.scrollToStart();
            });
            this.h.add(new Component[]{this.b});
            this.a = new Grid(ConsolePrivilegeEdit.class);
            this.a.setItems(dataProvider);
            this.a.removeAllColumns();
            this.a.addColumn(ConsolePrivilegeEdit::getDisplayTabId).setFlexGrow(0).setWidth("120px").setHeader("Tab").setPartNameGenerator((SerializableFunction & Serializable)object -> "align-center").setKey("Tab").setSortable(false);
            this.a.addColumn((ValueProvider & Serializable)privilege -> I.a(privilege.getDisplayScreenId())).setHeader("Screen").setFlexGrow(0).setWidth("200px").setPartNameGenerator((SerializableFunction & Serializable)object -> "align-center").setKey("Screen").setSortable(false);
            this.a.addColumn((ValueProvider & Serializable)privilege -> I.a(privilege.getPrivilegeId())).setHeader("Privileges").setFlexGrow(0).setWidth("230px").setPartNameGenerator((SerializableFunction & Serializable)object -> "align-center").setKey("Privileges").setSortable(false);
            this.a.addComponentColumn((ValueProvider & Serializable)item -> this.a((ConsolePrivilegeEdit)item, (List<RadioButtonGroup<String>>)radioButtonList, (List<ConsolePrivilegeEdit>)privilegeList, consoleRole)).setKey("Selection").setHeader("Privilege Access Level").setFlexGrow(1).setSortable(false);
            this.a.setSelectionMode(Grid.SelectionMode.NONE);
            this.a.setHeight("128px");
            this.a.setWidthFull();
            for (Grid.Column column : this.a.getColumns()) {
                column.setResizable(true);
            }
            Button button = new Button(aX.this.controller.getMessage("Cancel", new Object[0]));
            button.addClickShortcut(Key.ESCAPE, new KeyModifier[0]);
            button.addClickListener((ComponentEventListener & Serializable)event -> this.close());
            Button saveButton = as.createPrimaryButton(aX.this.controller.getMessage("Save", new Object[0]));
            saveButton.addClickListener((ComponentEventListener & Serializable)event -> {
                LinkedHashSet<ConsolePrivilege> privilegeListDuplicateProtection = new LinkedHashSet<ConsolePrivilege>();
                ArrayList<ConsolePrivilege> privilegeSaveList = new ArrayList<ConsolePrivilege>();
                String roleId = consoleRole.getRoleId().toString();
                for (ConsolePrivilegeEdit privileges : privilegeList) {
                    String privName = null;
                    boolean readFlag = false;
                    boolean writeFlag = false;
                    if (!privileges.getPrivilegeId().equalsIgnoreCase("")) {
                        privName = privileges.getPrivilegeId();
                        readFlag = privileges.isReadFlag();
                        writeFlag = privileges.isWriteFlag();
                    } else if (!privileges.getDisplayScreenId().equalsIgnoreCase("")) {
                        privName = privileges.getDisplayScreenId();
                        readFlag = privileges.isReadFlag();
                        writeFlag = privileges.isWriteFlag();
                    } else {
                        privName = privileges.getDisplayTabId();
                        readFlag = privileges.isReadFlag();
                        writeFlag = privileges.isWriteFlag();
                    }
                    if (!readFlag && !writeFlag) continue;
                    privilegeListDuplicateProtection.add(new ConsolePrivilege(roleId, privName, readFlag, writeFlag));
                    if (!privileges.getPrivilegeId().equalsIgnoreCase("")) {
                        privilegeListDuplicateProtection.add(new ConsolePrivilege(roleId, privileges.getScreenId(), true, false));
                        privilegeListDuplicateProtection.add(new ConsolePrivilege(roleId, privileges.getTabId(), true, false));
                        continue;
                    }
                    if (privileges.getDisplayScreenId().equalsIgnoreCase("")) continue;
                    privilegeListDuplicateProtection.add(new ConsolePrivilege(roleId, privileges.getTabId(), true, false));
                }
                privilegeSaveList.addAll(privilegeListDuplicateProtection);
                if (this.a(privilegeSaveList, roleId)) {
                    aX.this.addEvent("Console Role Modified", consoleRole.getRoleId());
                }
                this.close();
            });
            if (consoleRole.getRoleId().toString().equalsIgnoreCase("ADMIN") || consoleRole.getRoleId().toString().equalsIgnoreCase("READ") || consoleRole.getRoleId().toString().equalsIgnoreCase("WRITE")) {
                saveButton.setEnabled(false);
            }
            this.h.add(new Component[]{this.a});
            this.h.expand(new Component[]{this.a});
            this.getFooter().add(new Component[]{button, saveButton});
        }

        private RadioButtonGroup<String> a(ConsolePrivilegeEdit consolePrivilegeEdit, List<RadioButtonGroup<String>> listRadioButton, List<ConsolePrivilegeEdit> privilegeList, ConsoleRole role) {
            String selection = aX.f;
            selection = consolePrivilegeEdit.isReadFlag() ? aX.e : (consolePrivilegeEdit.isWriteFlag() ? aX.g : aX.f);
            RadioButtonGroup radioButtonGroup = new RadioButtonGroup();
            radioButtonGroup.setItems((Object[])new String[]{aX.e, aX.g, aX.f});
            radioButtonGroup.setValue((Object)selection);
            ComponentUtil.setData((Component)radioButtonGroup, (String)"cpe", (Object)consolePrivilegeEdit);
            listRadioButton.add((RadioButtonGroup<String>)radioButtonGroup);
            int readCheck = 0;
            int writeCheck = 0;
            int hiddenCheck = 0;
            if (((String)this.b.getValue()).toString().equalsIgnoreCase("Tabs Only")) {
                for (ConsolePrivilegeEdit privInitialCheck : privilegeList) {
                    if (!privInitialCheck.getTabId().equalsIgnoreCase(consolePrivilegeEdit.getDisplayTabId())) continue;
                    if (privInitialCheck.isReadFlag()) {
                        ++readCheck;
                        continue;
                    }
                    if (privInitialCheck.isWriteFlag()) {
                        ++writeCheck;
                        continue;
                    }
                    ++hiddenCheck;
                }
                if (writeCheck >= 1 && readCheck >= 1 || writeCheck >= 1 && hiddenCheck >= 1 || readCheck >= 1 && hiddenCheck >= 1) {
                    ConsolePrivilegeEdit rbData = (ConsolePrivilegeEdit)ComponentUtil.getData((Component)radioButtonGroup, (String)"cpe");
                    if (consolePrivilegeEdit.getDisplayTabId().equalsIgnoreCase(rbData.getDisplayTabId())) {
                        radioButtonGroup.setValue(null);
                    }
                }
            } else {
                if (!consolePrivilegeEdit.getDisplayScreenId().equalsIgnoreCase("")) {
                    for (ConsolePrivilegeEdit privInitialCheck : privilegeList) {
                        if (!privInitialCheck.getScreenId().equalsIgnoreCase(consolePrivilegeEdit.getDisplayScreenId())) continue;
                        if (privInitialCheck.isReadFlag()) {
                            ++readCheck;
                            continue;
                        }
                        if (privInitialCheck.isWriteFlag()) {
                            ++writeCheck;
                            continue;
                        }
                        ++hiddenCheck;
                    }
                } else if (!consolePrivilegeEdit.getDisplayTabId().equalsIgnoreCase("")) {
                    for (ConsolePrivilegeEdit privInitialCheck : privilegeList) {
                        if (!privInitialCheck.getTabId().equalsIgnoreCase(consolePrivilegeEdit.getDisplayTabId())) continue;
                        if (privInitialCheck.isReadFlag()) {
                            ++readCheck;
                            continue;
                        }
                        if (privInitialCheck.isWriteFlag()) {
                            ++writeCheck;
                            continue;
                        }
                        ++hiddenCheck;
                    }
                }
                if (writeCheck >= 1 && readCheck >= 1 || writeCheck >= 1 && hiddenCheck >= 1 || readCheck >= 1 && hiddenCheck >= 1) {
                    ConsolePrivilegeEdit rbData = (ConsolePrivilegeEdit)ComponentUtil.getData((Component)radioButtonGroup, (String)"cpe");
                    if (consolePrivilegeEdit.getDisplayScreenId().equalsIgnoreCase(rbData.getDisplayScreenId())) {
                        radioButtonGroup.setValue(null);
                    } else if (consolePrivilegeEdit.getDisplayTabId().equalsIgnoreCase(rbData.getDisplayTabId())) {
                        radioButtonGroup.setValue(null);
                    }
                }
            }
            radioButtonGroup.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                if (event.getValue() != null) {
                    this.a(privilegeList, ((String)event.getValue()).toString(), consolePrivilegeEdit, listRadioButton);
                    if (!consolePrivilegeEdit.getDisplayScreenId().equalsIgnoreCase("") || !consolePrivilegeEdit.getPrivilegeId().equalsIgnoreCase("")) {
                        this.a(privilegeList, consolePrivilegeEdit, listRadioButton);
                    }
                }
            });
            if (role.getRoleId().toString().equalsIgnoreCase("ADMIN") || role.getRoleId().toString().equalsIgnoreCase("READ") || role.getRoleId().toString().equalsIgnoreCase("WRITE")) {
                radioButtonGroup.setEnabled(false);
            }
            return radioButtonGroup;
        }

        protected void a(List<ConsolePrivilegeEdit> privilegeList, String eventValue, ConsolePrivilegeEdit consolePrivilegeEdit, List<RadioButtonGroup<String>> listRadioButton) {
            boolean typePrivilege = false;
            boolean typeScreen = false;
            if (!consolePrivilegeEdit.getPrivilegeId().equalsIgnoreCase("")) {
                typePrivilege = true;
            } else if (!consolePrivilegeEdit.getDisplayScreenId().equalsIgnoreCase("")) {
                typeScreen = true;
            }
            for (ConsolePrivilegeEdit privCheck : privilegeList) {
                if (typePrivilege) {
                    this.a(listRadioButton, consolePrivilegeEdit, eventValue, privCheck, "privilege", consolePrivilegeEdit.getPrivilegeId().equalsIgnoreCase(privCheck.getPrivilegeId().toString()));
                    continue;
                }
                if (typeScreen) {
                    this.a(listRadioButton, consolePrivilegeEdit, eventValue, privCheck, "screen", consolePrivilegeEdit.getDisplayScreenId().equalsIgnoreCase(privCheck.getScreenId().toString()));
                    continue;
                }
                this.a(listRadioButton, consolePrivilegeEdit, eventValue, privCheck, "tab", consolePrivilegeEdit.getDisplayTabId().equalsIgnoreCase(privCheck.getTabId().toString()));
            }
        }

        protected void a(List<RadioButtonGroup<String>> listRadioButton, ConsolePrivilegeEdit consolePrivilegeEdit, String eventValue, ConsolePrivilegeEdit privCheck, String privilegeType, boolean privilegeTypeComparison) {
            boolean typePriv = false;
            boolean typeScreen = false;
            boolean radioButtonComparison = false;
            if (privilegeType.equalsIgnoreCase("privilege")) {
                typePriv = true;
            } else if (privilegeType.equalsIgnoreCase("screen")) {
                typeScreen = true;
            }
            if (privilegeTypeComparison) {
                for (RadioButtonGroup<String> radioButton : listRadioButton) {
                    ConsolePrivilegeEdit rbData = (ConsolePrivilegeEdit)ComponentUtil.getData(radioButton, (String)"cpe");
                    radioButtonComparison = typePriv ? rbData.getPrivilegeId().equalsIgnoreCase(consolePrivilegeEdit.getPrivilegeId()) : (typeScreen ? rbData.getScreenId().equalsIgnoreCase(consolePrivilegeEdit.getDisplayScreenId()) : rbData.getTabId().equalsIgnoreCase(consolePrivilegeEdit.getDisplayTabId()));
                    if (!radioButtonComparison) continue;
                    radioButton.setValue((Object)eventValue);
                }
                this.a(eventValue, privCheck);
            }
        }

        protected void a(String eventValue, ConsolePrivilegeEdit privCheck) {
            if (eventValue.equalsIgnoreCase(aX.e)) {
                privCheck.setReadFlag(true);
                privCheck.setWriteFlag(false);
            } else if (eventValue.equalsIgnoreCase(aX.g)) {
                privCheck.setReadFlag(false);
                privCheck.setWriteFlag(true);
            } else {
                privCheck.setReadFlag(false);
                privCheck.setWriteFlag(false);
            }
        }

        protected void a(List<ConsolePrivilegeEdit> privilegeList, ConsolePrivilegeEdit consolePrivilegeEdit, List<RadioButtonGroup<String>> listRadioButton) {
            int privReadCount = 0;
            int privWriteCount = 0;
            boolean typePrivilege = false;
            boolean typeScreen = false;
            ArrayList<ConsolePrivilegeEdit> containedPrivsList = new ArrayList<ConsolePrivilegeEdit>();
            if (!consolePrivilegeEdit.getDisplayScreenId().equalsIgnoreCase("")) {
                typeScreen = true;
            } else {
                typePrivilege = true;
            }
            for (ConsolePrivilegeEdit consolePrivilegeEdit2 : privilegeList) {
                if (typeScreen) {
                    if (!consolePrivilegeEdit2.getTabId().equalsIgnoreCase(consolePrivilegeEdit.getTabId()) || !consolePrivilegeEdit2.getDisplayTabId().equalsIgnoreCase("")) continue;
                    containedPrivsList.add(consolePrivilegeEdit2);
                    continue;
                }
                if (!typePrivilege || !consolePrivilegeEdit2.getScreenId().equalsIgnoreCase(consolePrivilegeEdit.getScreenId()) || !consolePrivilegeEdit2.getDisplayScreenId().equalsIgnoreCase("")) continue;
                containedPrivsList.add(consolePrivilegeEdit2);
            }
            for (ConsolePrivilegeEdit consolePrivilegeEdit3 : containedPrivsList) {
                if (consolePrivilegeEdit3.isReadFlag()) {
                    ++privReadCount;
                    continue;
                }
                if (!consolePrivilegeEdit3.isWriteFlag()) continue;
                ++privWriteCount;
            }
            for (RadioButtonGroup radioButtonGroup : listRadioButton) {
                ConsolePrivilegeEdit radioObject = (ConsolePrivilegeEdit)ComponentUtil.getData((Component)radioButtonGroup, (String)"cpe");
                if (containedPrivsList.size() == 0) {
                    if (consolePrivilegeEdit.isReadFlag()) {
                        if (!radioObject.getDisplayScreenId().equalsIgnoreCase(consolePrivilegeEdit.getScreenId())) continue;
                        radioButtonGroup.setValue((Object)aX.e);
                        continue;
                    }
                    if (consolePrivilegeEdit.isWriteFlag()) {
                        if (!radioObject.getDisplayScreenId().equalsIgnoreCase(consolePrivilegeEdit.getScreenId())) continue;
                        radioButtonGroup.setValue((Object)aX.g);
                        continue;
                    }
                    if (!radioObject.getDisplayScreenId().equalsIgnoreCase(consolePrivilegeEdit.getScreenId())) continue;
                    radioButtonGroup.setValue((Object)aX.f);
                    continue;
                }
                if (typePrivilege) {
                    this.a(privReadCount, privWriteCount, containedPrivsList.size(), radioObject, (RadioButtonGroup<String>)radioButtonGroup, consolePrivilegeEdit, privilegeList, listRadioButton, radioObject.getDisplayScreenId().equalsIgnoreCase(consolePrivilegeEdit.getScreenId()), "priv");
                    continue;
                }
                this.a(privReadCount, privWriteCount, containedPrivsList.size(), radioObject, (RadioButtonGroup<String>)radioButtonGroup, consolePrivilegeEdit, privilegeList, listRadioButton, radioObject.getDisplayTabId().equalsIgnoreCase(consolePrivilegeEdit.getTabId()), "screen");
            }
        }

        protected void a(int privReadCount, int privWriteCount, int containedPrivilegesSize, ConsolePrivilegeEdit radioObject, RadioButtonGroup<String> radioButton, ConsolePrivilegeEdit consolePrivilegeEdit, List<ConsolePrivilegeEdit> privilegeList, List<RadioButtonGroup<String>> listRadioButton, boolean displayCheck, String type) {
            boolean typePriv = false;
            if (type.equalsIgnoreCase("priv")) {
                typePriv = true;
            }
            if (privReadCount == containedPrivilegesSize) {
                if (displayCheck) {
                    radioButton.setValue((Object)aX.e);
                }
            } else if (privWriteCount == containedPrivilegesSize) {
                if (displayCheck) {
                    radioButton.setValue((Object)aX.g);
                }
            } else if (privWriteCount == 0 && privReadCount == 0) {
                if (displayCheck) {
                    radioButton.setValue((Object)aX.f);
                }
            } else if (displayCheck) {
                radioButton.setValue(null);
                if (typePriv) {
                    this.a(privilegeList, radioObject, listRadioButton);
                }
            }
        }

        protected boolean a(List<ConsolePrivilege> rolePrivs, String privilegeRoleId) {
            try {
                aX.this.controller.getConsoleUserService().save(rolePrivs, privilegeRoleId);
                return true;
            }
            catch (Exception ex2) {
                aX.this.log.error(ex2.getMessage(), (Throwable)ex2);
                CommonUiUtils.notify((String)aX.this.message("Failed to save.  Please check settings and try again."));
                return false;
            }
        }

        private static /* synthetic */ Object a(SerializedLambda lambda) {
            switch (lambda.getImplMethodName()) {
                case "lambda$new$d12a98d6$2": {
                    if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/ConsoleRoleEditPanel$EditPrivilegesWindow") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/model/ConsolePrivilegeEdit;)Ljava/lang/Object;")) break;
                    return (ValueProvider & Serializable)privilege -> I.a(privilege.getPrivilegeId());
                }
                case "lambda$new$d40000c2$1": {
                    if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/ConsoleRoleEditPanel$EditPrivilegesWindow") || !lambda.getImplMethodSignature().equals("(Ljava/util/List;Ljava/util/List;Lcom/jumpmind/symmetric/console/model/ConsoleRole;Lcom/jumpmind/symmetric/console/model/ConsolePrivilegeEdit;)Lcom/vaadin/flow/component/radiobutton/RadioButtonGroup;")) break;
                    return arg_0 -> ((a)((Object)lambda.getCapturedArg(0))).a((List)lambda.getCapturedArg(1), (List)lambda.getCapturedArg(2), (ConsoleRole)lambda.getCapturedArg(3), arg_0);
                }
                case "lambda$new$7a5cee2c$1": {
                    if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/ConsoleRoleEditPanel$EditPrivilegesWindow") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/model/ConsoleRole;Ljava/util/List;Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                    return arg_0 -> ((a)((Object)lambda.getCapturedArg(0))).a((ConsoleRole)lambda.getCapturedArg(1), (List)lambda.getCapturedArg(2), arg_0);
                }
                case "lambda$createRadioGroup$fbb7e7a5$1": {
                    if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/HasValue$ValueChangeListener") || !lambda.getFunctionalInterfaceMethodName().equals("valueChanged") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/HasValue$ValueChangeEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/ConsoleRoleEditPanel$EditPrivilegesWindow") || !lambda.getImplMethodSignature().equals("(Ljava/util/List;Lcom/jumpmind/symmetric/console/model/ConsolePrivilegeEdit;Ljava/util/List;Lcom/vaadin/flow/component/AbstractField$ComponentValueChangeEvent;)V")) break;
                    return arg_0 -> ((a)((Object)lambda.getCapturedArg(0))).a((List)lambda.getCapturedArg(1), (ConsolePrivilegeEdit)lambda.getCapturedArg(2), (List)lambda.getCapturedArg(3), arg_0);
                }
                case "lambda$new$d12a98d6$1": {
                    if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/ConsoleRoleEditPanel$EditPrivilegesWindow") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/model/ConsolePrivilegeEdit;)Ljava/lang/Object;")) break;
                    return (ValueProvider & Serializable)privilege -> I.a(privilege.getDisplayScreenId());
                }
                case "lambda$new$8b319ef3$1": {
                    if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/SerializablePredicate") || !lambda.getFunctionalInterfaceMethodName().equals("test") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Z") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/ConsoleRoleEditPanel$EditPrivilegesWindow") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/model/ConsolePrivilegeEdit;)Z")) break;
                    return (SerializablePredicate & Serializable)priv -> !priv.getDisplayTabId().equalsIgnoreCase("");
                }
                case "lambda$new$5286a8f0$1": {
                    if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/combobox/ComboBox$ItemFilter") || !lambda.getFunctionalInterfaceMethodName().equals("test") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;Ljava/lang/String;)Z") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/ConsoleRoleEditPanel$EditPrivilegesWindow") || !lambda.getImplMethodSignature().equals("(Ljava/lang/String;Ljava/lang/String;)Z")) break;
                    return (ComboBox.ItemFilter & Serializable)(item, filter) -> !CommonUiUtils.isFilteredOut((String)item, (String)filter);
                }
                case "lambda$new$6d7e185e$3": {
                    if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/SerializableFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/ConsoleRoleEditPanel$EditPrivilegesWindow") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/model/ConsolePrivilegeEdit;)Ljava/lang/String;")) break;
                    return (SerializableFunction & Serializable)object -> "align-center";
                }
                case "lambda$new$6d7e185e$2": {
                    if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/SerializableFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/ConsoleRoleEditPanel$EditPrivilegesWindow") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/model/ConsolePrivilegeEdit;)Ljava/lang/String;")) break;
                    return (SerializableFunction & Serializable)object -> "align-center";
                }
                case "lambda$new$77d5cca2$1": {
                    if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/server/Command") || !lambda.getFunctionalInterfaceMethodName().equals("execute") || !lambda.getFunctionalInterfaceMethodSignature().equals("()V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/ConsoleRoleEditPanel$EditPrivilegesWindow") || !lambda.getImplMethodSignature().equals("()V")) break;
                    return (Command & Serializable)() -> {
                        if (this.getWidth() != "100%") {
                            this.setWidth("100%");
                            this.setHeight("100%");
                        } else {
                            this.setWidth("1000px");
                            this.setHeight("900px");
                        }
                    };
                }
                case "lambda$new$f5b66bc6$1": {
                    if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/HasValue$ValueChangeListener") || !lambda.getFunctionalInterfaceMethodName().equals("valueChanged") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/HasValue$ValueChangeEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/ConsoleRoleEditPanel$EditPrivilegesWindow") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/data/provider/ListDataProvider;Lcom/vaadin/flow/component/AbstractField$ComponentValueChangeEvent;)V")) break;
                    return arg_0 -> ((a)((Object)lambda.getCapturedArg(0))).a((ListDataProvider)lambda.getCapturedArg(1), arg_0);
                }
                case "lambda$new$6d7e185e$1": {
                    if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/SerializableFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/ConsoleRoleEditPanel$EditPrivilegesWindow") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/model/ConsolePrivilegeEdit;)Ljava/lang/String;")) break;
                    return (SerializableFunction & Serializable)object -> "align-center";
                }
                case "getDisplayTabId": {
                    if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/model/ConsolePrivilegeEdit") || !lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) break;
                    return ConsolePrivilegeEdit::getDisplayTabId;
                }
                case "lambda$new$8b319ef3$2": {
                    if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/SerializablePredicate") || !lambda.getFunctionalInterfaceMethodName().equals("test") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Z") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/ConsoleRoleEditPanel$EditPrivilegesWindow") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/model/ConsolePrivilegeEdit;)Z")) break;
                    return (SerializablePredicate & Serializable)priv -> !priv.getDisplayTabId().equalsIgnoreCase("");
                }
                case "lambda$new$24aa141c$1": {
                    if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/SerializablePredicate") || !lambda.getFunctionalInterfaceMethodName().equals("test") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Z") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/ConsoleRoleEditPanel$EditPrivilegesWindow") || !lambda.getImplMethodSignature().equals("(Ljava/lang/String;Lcom/jumpmind/symmetric/console/model/ConsolePrivilegeEdit;)Z")) break;
                    return arg_0 -> a.b((String)lambda.getCapturedArg(0), arg_0);
                }
                case "lambda$new$22995440$1": {
                    if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/ConsoleRoleEditPanel$EditPrivilegesWindow") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                    return (ComponentEventListener & Serializable)event -> this.close();
                }
            }
            throw new IllegalArgumentException("Invalid lambda deserialization");
        }
    }
}

