/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.impl.R;
import com.jumpmind.symmetric.console.impl.fL;
import com.jumpmind.symmetric.console.ui.common.I;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.select.Select;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.ValidationException;
import com.vaadin.flow.function.SerializablePredicate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jumpmind.symmetric.file.IFileConflictResolver;
import org.jumpmind.symmetric.model.FileConflictStrategy;
import org.jumpmind.symmetric.model.FileTrigger;
import org.jumpmind.symmetric.model.FileTriggerRouter;
import org.jumpmind.symmetric.model.Router;
import org.jumpmind.symmetric.service.IFileSyncService;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;

public class Y
extends R<FileTriggerRouter> {
    private static final long serialVersionUID = 1L;
    private static final String CAPTURE_ID = "captureId";
    private String originalTriggerId;
    private String originalRouterId;

    public Y(I controller, Set<FileTriggerRouter> itemSet, boolean newItemFlag, boolean deleteFlag) {
        super(controller, itemSet, newItemFlag, deleteFlag);
    }

    @Override
    public void initFields() {
        if (!this.newItemFlag && !this.isBulk) {
            this.originalTriggerId = ((FileTriggerRouter)this.itemSet.iterator().next()).getTriggerId();
            this.originalRouterId = ((FileTriggerRouter)this.itemSet.iterator().next()).getRouterId();
        }
        this.binder = new Binder(FileTriggerRouter.class);
        ArrayList<String> triggerIds = new ArrayList<String>();
        for (FileTrigger trigger : this.controller.getSymmetricEngine().getFileSyncService().getFileTriggers()) {
            triggerIds.add(trigger.getTriggerId());
        }
        Select triggerId = new Select();
        triggerId.setItems(triggerIds);
        triggerId.setId(CAPTURE_ID);
        this.formatComboBox(triggerId);
        this.binder.forField((HasValue)triggerId).withValidator((SerializablePredicate & Serializable)value -> value != null || this.isBulk, this.controller.getMessage("%s is required.", "File Capture")).bind("triggerId");
        triggerId.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a(this, (HasValue<?, ?>)triggerId, this.controller.getMessage("File Capture", new Object[0])));
        ArrayList<String> routerIds = new ArrayList<String>();
        for (Router router : this.controller.getSymmetricEngine().getTriggerRouterService().getRouters()) {
            routerIds.add(router.getRouterId());
        }
        Select routerId = new Select();
        routerId.setItems(routerIds);
        routerId.setId("routerId");
        this.formatComboBox(routerId);
        this.binder.forField((HasValue)routerId).withValidator((SerializablePredicate & Serializable)value -> value != null || this.isBulk, this.controller.getMessage("%s is required.", "Routers")).bind("routerId");
        routerId.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a(this, (HasValue<?, ?>)routerId, this.controller.getMessage("Routers", new Object[0])));
        TextField targetBaseDir = new TextField();
        targetBaseDir.setId("targetBaseDir");
        targetBaseDir.setClassName("input-long");
        this.binder.forField((HasValue)targetBaseDir).withValidator((SerializablePredicate & Serializable)value -> !value.equals(targetBaseDir.getEmptyValue()) || this.isBulk, this.controller.getMessage("%s is required.", "Target Base Directory")).bind("targetBaseDir");
        targetBaseDir.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a(this, (HasValue<?, ?>)targetBaseDir, this.controller.getMessage("Target Base Directory", new Object[0])));
        ArrayList<String> conflictStrategies = new ArrayList<String>();
        for (FileConflictStrategy conflictStrategy : FileConflictStrategy.values()) {
            conflictStrategies.add(conflictStrategy.name());
        }
        for (IFileConflictResolver conflictResolver : this.controller.getSymmetricEngine().getExtensionService().getExtensionPointList(IFileConflictResolver.class)) {
            conflictStrategies.add(conflictResolver.getName());
        }
        Select conflictStrategyString = new Select();
        conflictStrategyString.setItems(conflictStrategies);
        conflictStrategyString.setId("conflictStrategyString");
        this.formatComboBox(conflictStrategyString);
        this.binder.forField((HasValue)conflictStrategyString).withValidator((SerializablePredicate & Serializable)value -> value != null || this.isBulk, this.controller.getMessage("%s is required.", "Conflict Strategy")).bind("conflictStrategyString");
        conflictStrategyString.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a(this, (HasValue<?, ?>)conflictStrategyString, this.controller.getMessage("Conflict Strategy", new Object[0])));
        Checkbox initialLoadEnabled = new Checkbox();
        initialLoadEnabled.setId("initialLoadEnabled");
        this.binder.forField((HasValue)initialLoadEnabled).bind("initialLoadEnabled");
        this.fieldList.add(new R.a(this, (HasValue<?, ?>)initialLoadEnabled, this.controller.getMessage("Initial Load Enabled", new Object[0])));
        Checkbox enabled = new Checkbox();
        enabled.setId("enabled");
        this.binder.forField((HasValue)enabled).bind("enabled");
        this.fieldList.add(new R.a(this, (HasValue<?, ?>)enabled, this.controller.getMessage("Enabled", new Object[0])));
    }

    @Override
    protected void generateNewItem() {
        FileTriggerRouter triggerRouter = new FileTriggerRouter();
        triggerRouter.setCreateTime(new Date());
        triggerRouter.setLastUpdateTime(new Date());
        triggerRouter.setLastUpdateBy(this.controller.getConsoleUser().getUserId());
        this.newItem = triggerRouter;
    }

    @Override
    public boolean save(boolean saveAsCopy) {
        if (this.binder.validate().isOk()) {
            IFileSyncService fileSyncService = this.controller.getSymmetricEngine().getFileSyncService();
            if (!this.isBulk) {
                FileTriggerRouter fileTriggerRouter;
                if (!this.newItemFlag) {
                    try {
                        this.binder.writeBean((Object)((FileTriggerRouter)this.itemSet.iterator().next()));
                    }
                    catch (ValidationException e2) {
                        CommonUiUtils.notify((String)"Failed to write to bean");
                    }
                    fileTriggerRouter = (FileTriggerRouter)this.itemSet.iterator().next();
                    fileTriggerRouter.setLastUpdateBy(this.controller.getConsoleUser().getUserId());
                    fileTriggerRouter.setLastUpdateTime(new Date());
                    if (this.originalRouterId == null || this.originalTriggerId == null || this.originalTriggerId.equals(fileTriggerRouter.getTriggerId()) && this.originalRouterId.equals(fileTriggerRouter.getRouterId())) {
                        fileSyncService.saveFileTriggerRouter(fileTriggerRouter);
                    } else {
                        fileSyncService.renameFileTriggerRouter(this.originalTriggerId, this.originalRouterId, fileTriggerRouter);
                    }
                } else {
                    try {
                        this.binder.writeBean((Object)((FileTriggerRouter)this.newItem));
                    }
                    catch (ValidationException e3) {
                        CommonUiUtils.notify((String)"Failed to write to bean");
                    }
                    fileTriggerRouter = (FileTriggerRouter)this.newItem;
                    fileTriggerRouter.setLastUpdateBy(this.controller.getConsoleUser().getUserId());
                    fileTriggerRouter.setLastUpdateTime(new Date());
                    fileSyncService.saveFileTriggerRouter(fileTriggerRouter);
                }
                this.addEvent(this.newItemFlag ? "File Routing Created" : "File Routing Modified", fileTriggerRouter.getTriggerId() + ":" + fileTriggerRouter.getRouterId());
                fL fileSyncChecker = new fL();
                fileSyncChecker.a(fileTriggerRouter.getTargetBaseDir(), this.controller);
            } else {
                for (FileTriggerRouter fileTriggerRouter : this.itemSet) {
                    for (R.a formField : this.fieldList) {
                        HasValue<?, ?> field = formField.getField();
                        Checkbox checkbox = formField.getCheckbox();
                        if (checkbox == null || !((Boolean)checkbox.getValue()).booleanValue() || !(field instanceof Component)) continue;
                        switch (((Component)field).getId().orElse("")) {
                            case "targetBaseDir": {
                                fileTriggerRouter.setTargetBaseDir((String)field.getValue());
                                break;
                            }
                            case "conflictStrategyString": {
                                fileTriggerRouter.setConflictStrategyString((String)field.getValue());
                                break;
                            }
                            case "initialLoadEnabled": {
                                fileTriggerRouter.setInitialLoadEnabled(((Boolean)field.getValue()).booleanValue());
                                break;
                            }
                            case "enabled": {
                                fileTriggerRouter.setEnabled(((Boolean)field.getValue()).booleanValue());
                            }
                        }
                    }
                    fileTriggerRouter.setLastUpdateBy(this.controller.getConsoleUser().getUserId());
                    fileTriggerRouter.setLastUpdateTime(new Date());
                    fileSyncService.saveFileTriggerRouter(fileTriggerRouter);
                }
                this.addEvent("File Routing Modified", this.itemSet.stream().map(item -> item.getTriggerId() + ":" + item.getRouterId()).collect(Collectors.toSet()));
            }
            if (this.formListener != null) {
                this.formListener.formSaved();
            }
            return true;
        }
        return false;
    }

    @Override
    public void delete() {
        IFileSyncService fileSyncService = this.controller.getSymmetricEngine().getFileSyncService();
        for (FileTriggerRouter fileTriggerRouter : this.itemSet) {
            fileSyncService.deleteFileTriggerRouter(fileTriggerRouter);
        }
        this.addEvent("File Routing Deleted", this.itemSet.stream().map(item -> item.getTriggerId() + ":" + item.getRouterId()).collect(Collectors.toSet()));
        if (this.formListener != null) {
            this.formListener.formDeleted();
        }
    }

    @Override
    protected List<String> getOrderedFieldIds() {
        ArrayList<String> orderedFields = new ArrayList<String>();
        if (!this.isBulk) {
            orderedFields.add(CAPTURE_ID);
            orderedFields.add("routerId");
        }
        orderedFields.add("targetBaseDir");
        orderedFields.add("conflictStrategyString");
        orderedFields.add("initialLoadEnabled");
        orderedFields.add("enabled");
        return orderedFields;
    }

    @Override
    public String getKeyId() {
        return CAPTURE_ID;
    }

    @Override
    public String getHelpSectionName() {
        return "_file_routing";
    }
}

