/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.impl.R;
import com.jumpmind.symmetric.console.impl.hb;
import com.jumpmind.symmetric.console.model.AppSession;
import com.jumpmind.symmetric.console.model.ConsoleUser;
import com.jumpmind.symmetric.console.model.ValidationMessageException;
import com.jumpmind.symmetric.console.model.ValidationResult;
import com.jumpmind.symmetric.console.service.IConsoleUserService;
import com.jumpmind.symmetric.console.ui.common.I;
import com.jumpmind.symmetric.console.ui.common.ac;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.customfield.CustomField;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.select.Select;
import com.vaadin.flow.component.textfield.PasswordField;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.ValidationException;
import com.vaadin.flow.dom.Style;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.WrappedSession;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;

public class V
extends R<ConsoleUser> {
    private static final long serialVersionUID = 1L;
    private String userPassword;
    private R.a authenticationMethodField;
    private PasswordField passField;
    private a progressField;
    private boolean passFieldRequired = false;
    private R.a progressFormField;
    private ac passwordProgressBar;
    private Checkbox glassBreakRequired;
    private R.a glassBreakRequiredField;
    private R.a resetRequiredField;
    private boolean authWasExternal;
    private boolean resetWasRequired;
    private boolean userWasEnabled;
    private String originalId;
    private hb roleHierarchyUtils;
    private final int DURATION_OF_NOTIFICATION = 15000;

    public V(I controller, Set<ConsoleUser> itemSet, boolean newItemFlag, boolean deleteFlag) {
        super(controller, itemSet, newItemFlag, deleteFlag);
        this.authWasExternal = itemSet.size() == 1 && !itemSet.iterator().next().getAuthenticationMethod().equals("INTERNAL");
        this.resetWasRequired = !newItemFlag && itemSet.iterator().next().isResetRequired();
        this.userWasEnabled = !newItemFlag && itemSet.iterator().next().isEnabled();
    }

    @Override
    public void initFields() {
        if (!this.newItemFlag && !this.isBulk) {
            this.originalId = ((ConsoleUser)this.itemSet.iterator().next()).getUserId();
        }
        this.binder = new Binder(ConsoleUser.class);
        ArrayList<String> authMethodList = new ArrayList<String>();
        authMethodList.add("INTERNAL");
        authMethodList.add("LDAP");
        authMethodList.add("SAML");
        Select authenticationMethod = new Select();
        authenticationMethod.setItems(authMethodList);
        authenticationMethod.setId("authenticationMethod");
        this.formatComboBox(authenticationMethod);
        this.binder.forField((HasValue)authenticationMethod).withValidator((SerializablePredicate & Serializable)value -> value != null || this.isBulk, this.controller.getMessage("%s is required.", "Authenticantion Method")).bind("authenticationMethod");
        authenticationMethod.setRequiredIndicatorVisible(!this.isBulk);
        this.authenticationMethodField = new R.a((HasValue<?, ?>)authenticationMethod, this.controller.getMessage("Authenticantion Method", new Object[0]));
        this.fieldList.add(this.authenticationMethodField);
        TextField userId = new TextField();
        userId.setId("userId");
        this.binder.forField((HasValue)userId).withValidator((SerializablePredicate & Serializable)value -> !StringUtils.isBlank((CharSequence)value) || this.isBulk, this.controller.getMessage("%s is required.", "User Id")).bind("userId");
        userId.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a((HasValue<?, ?>)userId, this.controller.getMessage("User Id", new Object[0])));
        this.passField = new PasswordField();
        this.progressField = new a(this.passField);
        this.progressField.setId("password");
        this.passFieldRequired = this.newItemFlag;
        this.passField.setRequiredIndicatorVisible(this.passFieldRequired);
        this.progressField.setRequiredIndicatorVisible(this.passFieldRequired);
        this.progressFormField = new R.a((HasValue<?, ?>)this.progressField, this.newItemFlag ? this.controller.getMessage("Password", new Object[0]) : this.controller.getMessage("New Password", new Object[0]));
        this.fieldList.add(this.progressFormField);
        this.binder.forField((HasValue)this.passField).withValidator((SerializablePredicate & Serializable)value -> this.validatePasswordAgainstUserId((String)value, userId.getValue()), this.controller.getMessage("Password value can not be the same as the user value.", new Object[0])).bind("password");
        TextField firstName = new TextField();
        firstName.setId("firstName");
        this.binder.forField((HasValue)firstName).withValidator((SerializablePredicate & Serializable)value -> !value.equals(firstName.getEmptyValue()) || this.isBulk, this.controller.getMessage("%s is required.", "First Name")).bind("firstName");
        firstName.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a((HasValue<?, ?>)firstName, this.controller.getMessage("First Name", new Object[0])));
        TextField lastName = new TextField();
        lastName.setId("lastName");
        this.binder.forField((HasValue)lastName).withValidator((SerializablePredicate & Serializable)value -> !value.equals(lastName.getEmptyValue()) || this.isBulk, this.controller.getMessage("%s is required.", "Last Name")).bind("lastName");
        lastName.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a((HasValue<?, ?>)lastName, this.controller.getMessage("Last Name", new Object[0])));
        this.roleHierarchyUtils = new hb(this.controller.getConsoleUserService());
        List<Object> roleIds = new ArrayList();
        String userRole = this.controller.getConsoleUser().getRole();
        if (userRole.equalsIgnoreCase("ADMIN")) {
            roleIds = this.roleHierarchyUtils.a();
        } else if (this.roleHierarchyUtils.d(userRole)) {
            roleIds = this.roleHierarchyUtils.e(userRole);
            if (this.originalId != null && this.originalId.equals(this.controller.getConsoleUser().getUserId())) {
                roleIds.add(userRole);
            }
        } else {
            roleIds = this.roleHierarchyUtils.b();
            roleIds.remove("ADMIN");
        }
        Collections.sort(roleIds, String.CASE_INSENSITIVE_ORDER);
        Select role = new Select();
        role.setItems(roleIds);
        role.setId("role");
        this.formatComboBox(role);
        this.binder.forField((HasValue)role).withValidator((SerializablePredicate & Serializable)value -> value != null || this.isBulk, this.controller.getMessage("%s is required.", "Role")).bind("role");
        role.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a((HasValue<?, ?>)role, this.controller.getMessage("Role", new Object[0])));
        if (!this.isBulk) {
            TextField email = new TextField();
            email.setId("email");
            this.binder.forField((HasValue)email).bind("email");
            this.fieldList.add(new R.a((HasValue<?, ?>)email, this.controller.getMessage("Email", new Object[0])));
        }
        Checkbox resetRequired = new Checkbox();
        resetRequired.setId("resetRequired");
        this.binder.forField((HasValue)resetRequired).bind("resetRequired");
        this.resetRequiredField = new R.a((HasValue<?, ?>)resetRequired, this.controller.getMessage("Password Reset Required", new Object[0]));
        this.resetRequiredField.setVisible(this.newItemFlag || this.isBulk || "INTERNAL".equals(((ConsoleUser)this.itemSet.iterator().next()).getAuthenticationMethod()));
        this.fieldList.add(this.resetRequiredField);
        this.glassBreakRequired = new Checkbox();
        this.glassBreakRequired.setId("glassBreakRequired");
        this.binder.forField((HasValue)this.glassBreakRequired).bind("glassBreakRequired");
        authenticationMethod.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            if (event.isFromClient()) {
                this.adjustFieldVisibility((String)event.getValue(), (Boolean)this.glassBreakRequired.getValue());
            }
        });
        this.glassBreakRequired.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.adjustFieldVisibility((String)authenticationMethod.getValue(), (Boolean)event.getValue()));
        this.glassBreakRequiredField = new R.a((HasValue<?, ?>)this.glassBreakRequired, this.controller.getMessage("Glass Break Required", new Object[0]));
        this.glassBreakRequiredField.setVisible(this.newItemFlag || this.isBulk || "INTERNAL".equals(((ConsoleUser)this.itemSet.iterator().next()).getAuthenticationMethod()));
        this.fieldList.add(this.glassBreakRequiredField);
        Checkbox enabled = new Checkbox();
        enabled.setId("enabled");
        this.binder.forField((HasValue)enabled).bind("enabled");
        this.fieldList.add(new R.a((HasValue<?, ?>)enabled, this.controller.getMessage("Enabled", new Object[0])));
    }

    private boolean validatePasswordAgainstUserId(String value, String userId) {
        return value == null || value.length() <= 0 || !value.equals(userId) || value == null || value.length() == 0;
    }

    private void adjustFieldVisibility(String authenticationMethod, boolean glassBreakRequired) {
        boolean isInternal = authenticationMethod.equals("INTERNAL");
        this.progressFormField.setVisible(isInternal && !glassBreakRequired);
        this.passFieldRequired = isInternal && !glassBreakRequired && (this.newItemFlag || this.authWasExternal);
        this.passField.setRequiredIndicatorVisible(this.passFieldRequired);
        this.progressField.setRequiredIndicatorVisible(this.passFieldRequired);
        this.resetRequiredField.setVisible(isInternal);
        this.glassBreakRequiredField.setVisible(isInternal);
        ArrayList<String> authMethodList = new ArrayList<String>();
        authMethodList.add("INTERNAL");
        if (!glassBreakRequired) {
            authMethodList.add("LDAP");
            authMethodList.add("SAML");
        }
        Select authenticationMethodSelect = (Select)this.authenticationMethodField.getField();
        authenticationMethodSelect.setItems(authMethodList);
        authenticationMethodSelect.setValue((Object)authenticationMethod);
    }

    @Override
    protected void generateNewItem() {
        ConsoleUser user = new ConsoleUser();
        user.setUserId("");
        user.setLastName("");
        user.setFirstName("");
        user.setEmail("");
        user.setHashedPassword("");
        user.setAuthenticationMethod("INTERNAL");
        user.setEnabled(true);
        this.newItem = user;
    }

    @Override
    public boolean save(boolean saveAsCopy) {
        if (this.binder.validate().isOk()) {
            try {
                if (!this.isBulk) {
                    ConsoleUser user;
                    boolean isInternalAuth = this.authenticationMethodField.getField().getValue().equals("INTERNAL");
                    boolean isGlassBreakRequired = (Boolean)this.glassBreakRequired.getValue();
                    if (this.userPassword == null && isInternalAuth && !isGlassBreakRequired && (this.newItemFlag || this.authWasExternal)) {
                        return false;
                    }
                    if (!this.newItemFlag) {
                        if (saveAsCopy) {
                            if (this.newItem == null) {
                                this.generateNewItem();
                            }
                            user = (ConsoleUser)this.newItem;
                        } else {
                            user = (ConsoleUser)this.itemSet.iterator().next();
                        }
                    } else {
                        user = (ConsoleUser)this.newItem;
                    }
                    try {
                        this.binder.writeBean((Object)user);
                    }
                    catch (ValidationException e2) {
                        CommonUiUtils.notify((String)"Failed to write to bean");
                    }
                    if (!this.isBulk && !this.newItemFlag && this.originalId != null && !this.originalId.equals(user.getUserId()) && this.originalId.equals(this.controller.getConsoleUser().getUserId())) {
                        CommonUiUtils.notify((String)"Cannot edit the ID of the current user");
                        return false;
                    }
                    if (isInternalAuth && !isGlassBreakRequired && this.userPassword != null) {
                        user.setPassword(this.userPassword);
                        this.updatePassword(user);
                    }
                    this.updateConsoleUser(user, saveAsCopy);
                    String id = user.getUserId();
                    this.addEvent(this.newItemFlag ? "Console User Created" : "Console User Modified", id);
                    if (!this.resetWasRequired && user.isResetRequired()) {
                        this.addEvent("Console User Reset", id);
                    }
                    if (!this.newItemFlag && this.userWasEnabled != user.isEnabled()) {
                        this.addEvent(this.userWasEnabled ? "Console User Disabled" : "Console User Enabled", id);
                    }
                } else {
                    boolean resetRequired = false;
                    boolean enabledChanged = false;
                    boolean enabled = false;
                    for (ConsoleUser user : this.itemSet) {
                        for (R.a formField : this.fieldList) {
                            HasValue<?, ?> field = formField.getField();
                            Checkbox checkbox = formField.getCheckbox();
                            if (checkbox == null || !((Boolean)checkbox.getValue()).booleanValue() || !(field instanceof Component)) continue;
                            switch (((Component)field).getId().orElse("")) {
                                case "authenticationMethod": {
                                    user.setAuthenticationMethod((String)field.getValue());
                                    break;
                                }
                                case "firstName": {
                                    user.setFirstName((String)field.getValue());
                                    break;
                                }
                                case "lastName": {
                                    user.setLastName((String)field.getValue());
                                    break;
                                }
                                case "role": {
                                    user.setRole((String)field.getValue());
                                    break;
                                }
                                case "resetRequired": {
                                    if (((Boolean)field.getValue()).booleanValue()) {
                                        resetRequired = true;
                                    }
                                    user.setResetRequired((Boolean)field.getValue());
                                    break;
                                }
                                case "glassBreakRequired": {
                                    user.setGlassBreakRequired((Boolean)field.getValue());
                                    break;
                                }
                                case "enabled": {
                                    enabledChanged = true;
                                    enabled = (Boolean)field.getValue();
                                    user.setEnabled(enabled);
                                }
                            }
                        }
                        Checkbox progressFieldCheckbox = this.progressFormField.getCheckbox();
                        if (progressFieldCheckbox != null && ((Boolean)progressFieldCheckbox.getValue()).booleanValue()) {
                            if (this.userPassword == null) {
                                return false;
                            }
                            Checkbox authenticationMethodCheckbox = this.authenticationMethodField.getCheckbox();
                            Checkbox glassBreakRequiredCheckbox = this.glassBreakRequiredField.getCheckbox();
                            boolean isAuthChecked = authenticationMethodCheckbox != null && (Boolean)authenticationMethodCheckbox.getValue() != false;
                            boolean isGlassBreakChecked = glassBreakRequiredCheckbox != null && (Boolean)glassBreakRequiredCheckbox.getValue() != false;
                            String authMethod = this.authenticationMethodField.getField().getValue().toString();
                            boolean isInternalAuth = authMethod == null || authMethod.equals("INTERNAL");
                            boolean isGlassBreakRequired = (Boolean)this.glassBreakRequired.getValue();
                            if (!(isAuthChecked && !isInternalAuth || !isAuthChecked && !user.getAuthenticationMethod().equals("INTERNAL") || isGlassBreakChecked && isGlassBreakRequired)) {
                                user.setPassword(this.userPassword);
                                this.updatePassword(user);
                            }
                        }
                        this.updateConsoleUser(user, saveAsCopy);
                    }
                    Set<String> ids = this.itemSet.stream().map(ConsoleUser::getUserId).collect(Collectors.toSet());
                    this.addEvent("Console User Modified", ids);
                    if (resetRequired) {
                        this.addEvent("Console User Reset", ids);
                    }
                    if (enabledChanged) {
                        this.addEvent(enabled ? "Console User Enabled" : "Console User Disabled", ids);
                    }
                }
                if (this.formListener != null) {
                    this.formListener.formSaved();
                }
                this.controller.enableLogout();
                return true;
            }
            catch (ValidationMessageException ex2) {
                Notification.show((String)ex2.getMessage(), (int)15000, (Notification.Position)Notification.Position.BOTTOM_END);
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void updatePassword(ConsoleUser user) {
        IConsoleUserService service = this.controller.getConsoleUserService();
        ConsoleUser oldUser = service.findConsoleUser(user.getUserId());
        if (user.getAuthenticationMethod().equals("INTERNAL")) {
            if (user.getPassword() != null && !user.getPassword().equals("") || oldUser == null) {
                ValidationResult result = service.validatePasswordComplexity(user, null, user.getPassword());
                if (!result.getStatus().equals((Object)ValidationResult.ValidationStatus.VALID)) throw new ValidationMessageException(result.getMessage(), new Object[0]);
                service.updateUserEncryption(user);
                user.setLastPasswordTime(new Date());
                user.setFailedLoginAttempts(0);
                service.updateUserHistory(user);
                if (user.getCreateTime() == null) return;
                this.addEvent("Console Password Changed", user.getUserId());
                return;
            } else {
                if ((oldUser.getAuthenticationMethod().equals("LDAP") || oldUser.getAuthenticationMethod().equals("SAML")) && (user.getPassword() == null || user.getPassword().equals(""))) {
                    throw new ValidationMessageException("Password must not be blank ", new Object[0]);
                }
                user.setHashedPassword(oldUser.getHashedPassword());
                user.setEncryptionMethod(oldUser.getEncryptionMethod());
                user.setSalt(oldUser.getSalt());
            }
            return;
        } else {
            user.setLastPasswordTime(new Date());
            if (user.getCreateTime() == null) return;
            this.addEvent("Console Password Changed", user.getUserId());
        }
    }

    protected void updateConsoleUser(ConsoleUser user, boolean saveAsCopy) {
        IConsoleUserService service = this.controller.getConsoleUserService();
        boolean changedId = !this.isBulk && !this.newItemFlag && this.originalId != null && !this.originalId.equals(user.getUserId());
        ConsoleUser existingUser = service.findConsoleUser(changedId ? this.originalId : user.getUserId());
        if (user.isEnabled()) {
            user.setFailedLoginAttempts(0);
        }
        user.setLastUpdateBy(this.controller.getConsoleUser().getUserId());
        if (user.getCreateTime() == null) {
            user.setCreateTime(new Date());
        }
        if (!this.newItemFlag && this.passField.getValue().equals(this.passField.getEmptyValue())) {
            user.setHashedPassword(existingUser.getHashedPassword());
        }
        if (saveAsCopy) {
            service.saveAsCopy(user);
        } else if (!changedId) {
            service.save(user);
        } else {
            service.rename(this.originalId, user);
        }
    }

    @Override
    public void delete() {
        IConsoleUserService service = this.controller.getConsoleUserService();
        for (ConsoleUser user : this.itemSet) {
            service.delete(user);
            for (AppSession session : com.jumpmind.symmetric.console.ui.a.a().values()) {
                if (!user.getUserId().equals(session.getUserId())) continue;
                VaadinSession vaadinSession = session.getVaadinSession();
                WrappedSession wrappedSession = vaadinSession.getSession();
                if (wrappedSession != null) {
                    wrappedSession.invalidate();
                }
                com.jumpmind.symmetric.console.ui.a.a(vaadinSession);
            }
        }
        this.addEvent("Console User Deleted", this.itemSet.stream().map(ConsoleUser::getUserId).collect(Collectors.toSet()));
        if (this.formListener != null) {
            this.formListener.formDeleted();
        }
    }

    @Override
    protected List<String> getOrderedFieldIds() {
        ArrayList<String> orderedFields = new ArrayList<String>();
        orderedFields.add("authenticationMethod");
        orderedFields.add("userId");
        orderedFields.add("password");
        orderedFields.add("firstName");
        orderedFields.add("lastName");
        orderedFields.add("role");
        orderedFields.add("email");
        orderedFields.add("resetRequired");
        orderedFields.add("glassBreakRequired");
        orderedFields.add("enabled");
        return orderedFields;
    }

    @Override
    public String getKeyId() {
        return "userId";
    }

    @Override
    public String getHelpSectionName() {
        return "_users";
    }

    protected class a
    extends CustomField<Float>
    implements HasStyle {
        private static final long serialVersionUID = 1L;
        HorizontalLayout passwordRequirementLayout = new HorizontalLayout();
        VerticalLayout passwordLayout = new VerticalLayout();
        PasswordField passField;
        Float value;

        public a(PasswordField password) {
            V.this.passwordProgressBar = new ac(V.this.controller, V.this.newItemFlag);
            this.setValue(Float.valueOf(0.0f));
            this.passField = password;
            this.passField.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                V.this.passwordProgressBar.updateProgress((String)event.getValue());
                V.this.userPassword = (String)event.getValue();
            });
            this.passwordLayout.add(new Component[]{this.passField});
            this.passwordLayout.setWidth("200px");
            this.passwordLayout.add(new Component[]{V.this.passwordProgressBar.getProgressBar()});
            Span spacer = new Span();
            this.passwordLayout.setMargin(false);
            this.passwordLayout.getStyle().set("margin-left", "0");
            this.passwordLayout.getStyle().set("padding", "0");
            this.passwordRequirementLayout.add(new Component[]{this.passwordLayout});
            this.passwordRequirementLayout.add(new Component[]{spacer});
            this.passwordRequirementLayout.add(new Component[]{V.this.passwordProgressBar.getPasswordRequirementLabels()});
            V.this.passwordProgressBar.setMargin(false);
            this.add(new Component[]{this.passwordRequirementLayout});
        }

        public Float getValue() {
            return this.value;
        }

        public Style getStyle() {
            return this.passwordRequirementLayout.getStyle();
        }

        protected Float generateModelValue() {
            return this.value;
        }

        protected void setPresentationValue(Float newPresentationValue) {
            this.value = newPresentationValue;
        }
    }
}

