/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.impl.R;
import com.jumpmind.symmetric.console.ui.common.I;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.select.Select;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.ValidationException;
import com.vaadin.flow.data.binder.ValidationResult;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.function.SerializablePredicate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.io.data.writer.Conflict;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.model.NodeChannel;
import org.jumpmind.symmetric.model.NodeGroupLink;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.IDataLoaderService;
import org.jumpmind.symmetric.service.impl.DataLoaderService;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;

public class T
extends R<DataLoaderService.ConflictNodeGroupLink> {
    private static final long serialVersionUID = 1L;
    protected TextField detectExpression;
    protected boolean requireDetectExpression = false;
    protected Select<Conflict.DetectConflict> detectType;
    protected Select<Conflict.ResolveConflict> resolveType;
    protected List<Conflict.ResolveConflict> resolveTypeList;
    protected Conflict.DetectConflict lastDetect;
    protected String originalId;

    public T(I controller, Set<DataLoaderService.ConflictNodeGroupLink> itemSet, boolean newItemFlag, boolean deleteFlag) {
        super(controller, itemSet, newItemFlag, deleteFlag);
    }

    @Override
    public void initFields() {
        if (!this.newItemFlag && !this.isBulk) {
            this.originalId = ((DataLoaderService.ConflictNodeGroupLink)this.itemSet.iterator().next()).getConflictId();
        }
        this.binder = new Binder(DataLoaderService.ConflictNodeGroupLink.class);
        TextField conflictId = new TextField();
        conflictId.setId("conflictId");
        this.binder.forField((HasValue)conflictId).withValidator((SerializablePredicate & Serializable)value -> !StringUtils.isBlank((CharSequence)value) || this.isBulk, this.controller.getMessage("%s is required.", "Conflict Id")).bind("conflictId");
        conflictId.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a((HasValue<?, ?>)conflictId, this.controller.getMessage("Conflict Id", new Object[0])));
        IConfigurationService configService = this.controller.getSymmetricEngine().getConfigurationService();
        Select nodeGroupLink = new Select();
        nodeGroupLink.setItems((Collection)configService.getNodeGroupLinks(false));
        nodeGroupLink.setId("nodeGroupLink");
        this.formatComboBox(nodeGroupLink);
        nodeGroupLink.setWidth("20em");
        this.binder.forField((HasValue)nodeGroupLink).withValidator((SerializablePredicate & Serializable)value -> value != null || this.isBulk, this.controller.getMessage("%s is required.", "Group")).bind("nodeGroupLink");
        nodeGroupLink.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a((HasValue<?, ?>)nodeGroupLink, this.controller.getMessage("Group Link", new Object[0])));
        this.detectType = new Select();
        this.detectType.setItems(Arrays.asList(Conflict.DetectConflict.values()));
        this.detectType.setId("detectType");
        this.formatComboBox(this.detectType);
        this.binder.forField(this.detectType).withValidator((SerializablePredicate & Serializable)value -> value != null || this.isBulk, this.controller.getMessage("%s is required.", "Detection Type")).withValidator((Validator & Serializable)(value, context) -> {
            for (DataLoaderService.ConflictNodeGroupLink conflict : this.itemSet) {
                if (conflict == null || conflict.getDetectType() != Conflict.DetectConflict.USE_TIMESTAMP && conflict.getDetectType() != Conflict.DetectConflict.USE_VERSION || !StringUtils.isBlank((CharSequence)conflict.getDetectExpression())) continue;
                return ValidationResult.error((String)this.controller.getMessage("Please specify the column to be used in conflict detection and resolution", new Object[0]));
            }
            return ValidationResult.ok();
        }).bind("detectType");
        this.detectType.setValue((Object)Conflict.DetectConflict.USE_CHANGED_DATA);
        this.lastDetect = Conflict.DetectConflict.USE_CHANGED_DATA;
        this.detectType.setRequiredIndicatorVisible(!this.isBulk);
        this.detectType.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            this.updateResolverOptions();
            this.lastDetect = (Conflict.DetectConflict)event.getValue();
        });
        this.fieldList.add(new R.a((HasValue<?, ?>)this.detectType, this.controller.getMessage("Detection Type", new Object[0])));
        this.detectExpression = new TextField();
        this.detectExpression.setId("detectExpression");
        this.detectExpression.setClassName("input-long");
        this.binder.forField((HasValue)this.detectExpression).withValidator((SerializablePredicate & Serializable)value -> !value.equals(this.detectExpression.getEmptyValue()) || !this.requireDetectExpression, this.controller.getMessage("Please specify the column to be used in conflict detection and resolution", new Object[0])).bind("detectExpression");
        this.fieldList.add(new R.a((HasValue<?, ?>)this.detectExpression, this.controller.getMessage("Detection Expression", new Object[0])));
        this.resolveType = new Select();
        this.resolveType.setId("resolveType");
        this.formatComboBox(this.resolveType);
        this.binder.forField(this.resolveType).withValidator((SerializablePredicate & Serializable)value -> value != null || this.isBulk, this.controller.getMessage("%s is required.", "Resolution Type")).bind("resolveType");
        this.resolveType.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a((HasValue<?, ?>)this.resolveType, this.controller.getMessage("Resolution Type", new Object[0])));
        this.updateResolverOptions();
        Select pingBack = new Select();
        pingBack.setItems(Arrays.asList(Conflict.PingBack.values()));
        pingBack.setId("pingBack");
        this.formatComboBox(pingBack);
        this.binder.forField((HasValue)pingBack).withValidator((SerializablePredicate & Serializable)value -> value != null || this.isBulk, this.controller.getMessage("%s is required.", "Ping Back")).bind("pingBack");
        pingBack.setValue((Object)Conflict.PingBack.REMAINING_ROWS);
        pingBack.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a((HasValue<?, ?>)pingBack, this.controller.getMessage("Ping Back", new Object[0])));
        this.advancedFieldList = new ArrayList();
        ArrayList<String> targetChannelIdList = new ArrayList<String>();
        String firstChannelId = null;
        boolean hideSystemChannels = this.controller.getSymmetricEngine().getParameterService().is("console.web.hide.system.info");
        for (NodeChannel nodeChannel : configService.getNodeChannels(false)) {
            Channel channel;
            String channelId = nodeChannel.getChannelId();
            if (channelId.equals("config") || channelId.equals("heartbeat") || channelId.equals("system") || hideSystemChannels && (channelId.equals("dynamic") || channelId.equals("monitor")) || (channel = nodeChannel.getChannel()).isFileSyncFlag() || channel.isReloadFlag()) continue;
            if (firstChannelId == null) {
                firstChannelId = channelId;
            }
            targetChannelIdList.add(channelId);
        }
        targetChannelIdList.sort(null);
        Select targetChannelId = new Select();
        targetChannelId.setItems(targetChannelIdList);
        targetChannelId.setId("targetChannelId");
        this.formatComboBox(targetChannelId);
        this.binder.forField((HasValue)targetChannelId).bind("targetChannelId");
        targetChannelId.setValue(firstChannelId);
        targetChannelId.setVisible(this.isBulk);
        this.advancedFieldList.add(new R.a((HasValue<?, ?>)targetChannelId, this.controller.getMessage("Channel", new Object[0])));
        TextField targetCatalogName = new TextField();
        targetCatalogName.setId("targetCatalogName");
        targetCatalogName.setClassName("input-long");
        this.binder.forField((HasValue)targetCatalogName).bind("targetCatalogName");
        targetCatalogName.setVisible(this.isBulk);
        this.advancedFieldList.add(new R.a((HasValue<?, ?>)targetCatalogName, this.controller.getMessage("Target Catalog", new Object[0])));
        TextField targetSchemaName = new TextField();
        targetSchemaName.setId("targetSchemaName");
        targetSchemaName.setClassName("input-long");
        this.binder.forField((HasValue)targetSchemaName).bind("targetSchemaName");
        targetSchemaName.setVisible(this.isBulk);
        this.advancedFieldList.add(new R.a((HasValue<?, ?>)targetSchemaName, this.controller.getMessage("Target Schema", new Object[0])));
        TextField targetTableName = new TextField();
        targetTableName.setId("targetTableName");
        targetTableName.setClassName("input-long");
        this.binder.forField((HasValue)targetTableName).bind("targetTableName");
        targetTableName.setVisible(this.isBulk);
        this.advancedFieldList.add(new R.a((HasValue<?, ?>)targetTableName, this.controller.getMessage("Target Table", new Object[0])));
    }

    @Override
    protected void generateNewItem() {
        this.newItem = new DataLoaderService.ConflictNodeGroupLink();
    }

    @Override
    public boolean save(boolean saveAsCopy) {
        if (this.binder.validate().isOk()) {
            IDataLoaderService dataLoaderService = this.controller.getSymmetricEngine().getDataLoaderService();
            if (!this.isBulk) {
                DataLoaderService.ConflictNodeGroupLink conflict;
                if (!this.newItemFlag) {
                    try {
                        if (saveAsCopy) {
                            if (this.newItem == null) {
                                this.generateNewItem();
                            }
                            this.binder.writeBean((Object)((DataLoaderService.ConflictNodeGroupLink)this.newItem));
                        } else {
                            this.binder.writeBean((Object)((DataLoaderService.ConflictNodeGroupLink)this.itemSet.iterator().next()));
                        }
                    }
                    catch (ValidationException e2) {
                        CommonUiUtils.notify((String)"Failed to write to bean");
                    }
                    conflict = saveAsCopy ? (DataLoaderService.ConflictNodeGroupLink)this.newItem : (DataLoaderService.ConflictNodeGroupLink)this.itemSet.iterator().next();
                    conflict.setLastUpdateBy(this.controller.getConsoleUser().getUserId());
                    if (saveAsCopy) {
                        dataLoaderService.saveAsCopy(conflict);
                    } else if (this.originalId == null || this.originalId.equals(conflict.getConflictId())) {
                        dataLoaderService.save(conflict);
                    } else {
                        dataLoaderService.rename(this.originalId, conflict);
                    }
                } else {
                    try {
                        this.binder.writeBean((Object)((DataLoaderService.ConflictNodeGroupLink)this.newItem));
                    }
                    catch (ValidationException e3) {
                        CommonUiUtils.notify((String)"Failed to write to bean");
                    }
                    conflict = (DataLoaderService.ConflictNodeGroupLink)this.newItem;
                    conflict.setLastUpdateBy(this.controller.getConsoleUser().getUserId());
                    dataLoaderService.save(conflict);
                }
                this.addEvent(this.newItemFlag ? "Conflict Created" : "Conflict Modified", conflict.getConflictId());
            } else {
                for (DataLoaderService.ConflictNodeGroupLink conflict : this.itemSet) {
                    this.saveFieldsToConflict(this.fieldList, conflict);
                    this.saveFieldsToConflict(this.advancedFieldList, conflict);
                    conflict.setLastUpdateBy(this.controller.getConsoleUser().getUserId());
                    dataLoaderService.save(conflict);
                }
                this.addEvent("Conflict Modified", this.itemSet.stream().map(Conflict::getConflictId).collect(Collectors.toSet()));
            }
            if (this.formListener != null) {
                this.formListener.formSaved();
            }
            return true;
        }
        return false;
    }

    private void saveFieldsToConflict(List<R.a> fields, DataLoaderService.ConflictNodeGroupLink conflict) {
        for (R.a formField : fields) {
            HasValue<?, ?> field = formField.getField();
            Checkbox checkbox = formField.getCheckbox();
            if (checkbox == null || !((Boolean)checkbox.getValue()).booleanValue() && !field.isRequiredIndicatorVisible() || !(field instanceof Component)) continue;
            switch (((Component)field).getId().orElse("")) {
                case "nodeGroupLink": {
                    conflict.setNodeGroupLink((NodeGroupLink)field.getValue());
                    break;
                }
                case "detectType": {
                    conflict.setDetectType((Conflict.DetectConflict)field.getValue());
                    break;
                }
                case "detectExpression": {
                    conflict.setDetectExpression((String)field.getValue());
                    break;
                }
                case "resolveType": {
                    conflict.setResolveType((Conflict.ResolveConflict)field.getValue());
                    break;
                }
                case "pingBack": {
                    conflict.setPingBack((Conflict.PingBack)field.getValue());
                    break;
                }
                case "targetChannelId": {
                    conflict.setTargetChannelId((String)field.getValue());
                    break;
                }
                case "targetCatalogName": {
                    conflict.setTargetCatalogName((String)field.getValue());
                    break;
                }
                case "targetSchemaName": {
                    conflict.setTargetSchemaName((String)field.getValue());
                    break;
                }
                case "targetTableName": {
                    conflict.setTargetTableName((String)field.getValue());
                }
            }
        }
    }

    @Override
    public void delete() {
        IDataLoaderService dataLoaderService = this.controller.getSymmetricEngine().getDataLoaderService();
        for (DataLoaderService.ConflictNodeGroupLink conflict : this.itemSet) {
            dataLoaderService.delete(conflict);
        }
        this.addEvent("Conflict Deleted", this.itemSet.stream().map(Conflict::getConflictId).collect(Collectors.toSet()));
        if (this.formListener != null) {
            this.formListener.formDeleted();
        }
    }

    protected void updateResolverOptions() {
        if (this.resolveType != null && this.detectType != null) {
            if (this.resolveTypeList != null) {
                this.resolveTypeList.clear();
            } else {
                this.resolveTypeList = new ArrayList<Conflict.ResolveConflict>();
            }
            this.resolveTypeList.add(Conflict.ResolveConflict.NEWER_WINS);
            if (((Conflict.DetectConflict)this.detectType.getValue()).equals((Object)Conflict.DetectConflict.USE_TIMESTAMP) || ((Conflict.DetectConflict)this.detectType.getValue()).equals((Object)Conflict.DetectConflict.USE_VERSION)) {
                this.detectExpression.setEnabled(true);
                this.detectExpression.setPlaceholder(((Conflict.DetectConflict)this.detectType.getValue()).equals((Object)Conflict.DetectConflict.USE_TIMESTAMP) ? "Timestamp Column Name" : "Version Column Name");
                if (!this.lastDetect.equals((Object)Conflict.DetectConflict.USE_TIMESTAMP) && !this.lastDetect.equals((Object)Conflict.DetectConflict.USE_VERSION)) {
                    this.detectExpression.setValue(this.detectExpression.getEmptyValue());
                }
                this.requireDetectExpression = true;
            } else {
                if (((Conflict.DetectConflict)this.detectType.getValue()).equals((Object)Conflict.DetectConflict.USE_PK_DATA)) {
                    this.detectExpression.setEnabled(false);
                    this.detectExpression.setPlaceholder(null);
                    this.detectExpression.setValue(this.detectExpression.getEmptyValue());
                } else {
                    this.detectExpression.setEnabled(true);
                    this.detectExpression.setPlaceholder("Excluded Column Names");
                }
                this.requireDetectExpression = false;
                ((Binder.Binding)this.binder.getBinding("detectExpression").get()).validate();
                if (this.lastDetect.equals((Object)Conflict.DetectConflict.USE_TIMESTAMP) || this.lastDetect.equals((Object)Conflict.DetectConflict.USE_VERSION)) {
                    this.detectExpression.setValue(this.detectExpression.getEmptyValue());
                }
                this.resolveTypeList.add(Conflict.ResolveConflict.FALLBACK);
                this.resolveTypeList.add(Conflict.ResolveConflict.IGNORE);
                this.resolveTypeList.add(Conflict.ResolveConflict.MANUAL);
            }
            this.detectExpression.setRequiredIndicatorVisible(this.requireDetectExpression);
            this.resolveType.setItems(this.resolveTypeList);
            this.resolveType.setValue((Object)Conflict.ResolveConflict.NEWER_WINS);
        }
    }

    @Override
    protected List<String> getOrderedFieldIds() {
        ArrayList<String> orderedFields = new ArrayList<String>();
        orderedFields.add("conflictId");
        orderedFields.add("nodeGroupLink");
        orderedFields.add("targetChannelId");
        orderedFields.add("targetCatalogName");
        orderedFields.add("targetSchemaName");
        orderedFields.add("targetTableName");
        orderedFields.add("detectType");
        orderedFields.add("detectExpression");
        orderedFields.add("resolveType");
        orderedFields.add("pingBack");
        return orderedFields;
    }

    @Override
    public String getKeyId() {
        return "conflictId";
    }

    @Override
    public String getHelpSectionName() {
        return "_conflicts";
    }
}

