/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.impl.ac;
import com.jumpmind.symmetric.console.model.ConsoleEvent;
import com.jumpmind.symmetric.console.ui.common.I;
import com.jumpmind.symmetric.console.ui.common.Slider;
import com.jumpmind.symmetric.console.ui.common.ap;
import com.jumpmind.symmetric.console.ui.common.w;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.html.NativeLabel;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.select.Select;
import com.vaadin.flow.data.binder.Binder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class R<T>
extends ap {
    private static final long serialVersionUID = 1L;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Set<T> itemSet;
    protected T newItem;
    protected List<a> fieldList;
    protected List<a> advancedFieldList;
    protected Binder<T> binder;
    protected ac formListener;
    protected boolean newItemFlag;
    protected boolean isBulk;
    protected FormLayout layout = new FormLayout();

    public R(I controller, Set<T> itemSet, boolean newItemFlag, boolean deleteFlag) {
        super(controller);
        this.itemSet = itemSet;
        if (!deleteFlag) {
            this.newItemFlag = newItemFlag;
            this.isBulk = !newItemFlag && itemSet.size() > 1;
            this.setPadding(false);
            this.setSpacing(false);
            this.setMargin(false);
            this.getStyle().set("margin-bottom", "0");
            this.getStyle().set("padding-bottom", "0");
            this.fieldList = new ArrayList<a>();
            this.initFields();
            List<a> fullFieldList = this.hasAdvancedOptions() ? Stream.concat(this.fieldList.stream(), this.advancedFieldList.stream()).collect(Collectors.toList()) : this.fieldList;
            List<String> orderedFieldIds = this.getOrderedFieldIds();
            this.layout.setWidthFull();
            if (!this.isBulk) {
                this.layout.setResponsiveSteps(new FormLayout.ResponsiveStep[]{new FormLayout.ResponsiveStep("0", 1, FormLayout.ResponsiveStep.LabelsPosition.TOP), new FormLayout.ResponsiveStep("624px", 2, FormLayout.ResponsiveStep.LabelsPosition.TOP), new FormLayout.ResponsiveStep("948px", 3, FormLayout.ResponsiveStep.LabelsPosition.TOP)});
                block0: for (int i2 = 0; i2 < orderedFieldIds.size(); ++i2) {
                    for (a formField : fullFieldList) {
                        HasValue<?, ?> field = formField.getField();
                        if (!(field instanceof Component) || ((Component)field).getId().orElse(null) != orderedFieldIds.get(i2)) continue;
                        Component fieldComponent = (Component)field;
                        Component extraComponent = formField.getExtraComponent();
                        if (extraComponent != null) {
                            HorizontalLayout fieldLayout = new HorizontalLayout();
                            fieldLayout.add(new Component[]{fieldComponent});
                            fieldLayout.add(new Component[]{extraComponent});
                            fieldLayout.setVerticalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{extraComponent});
                            fieldLayout.setVisible(fieldComponent.isVisible());
                            formField.setExtraComponent((Component)fieldLayout);
                            formField.setFormItem(this.layout.addFormItem((Component)fieldLayout, (Component)formField.getLabelComponent()));
                            continue block0;
                        }
                        formField.setFormItem(this.layout.addFormItem(fieldComponent, (Component)formField.getLabelComponent()));
                        continue block0;
                    }
                }
                this.setAdvancedOptionsVisible(false);
                this.add(new Component[]{this.layout});
                if (!newItemFlag) {
                    this.binder.readBean(itemSet.iterator().next());
                } else {
                    this.generateNewItem();
                    this.binder.readBean(this.newItem);
                }
            } else {
                this.layout.setResponsiveSteps(new FormLayout.ResponsiveStep[]{new FormLayout.ResponsiveStep("0", 1, FormLayout.ResponsiveStep.LabelsPosition.ASIDE)});
                this.add(new Component[]{new Span(controller.getMessage("Bulk editing allows a user to modify multiple table rows.", new Object[0]))});
                this.add(new Component[]{new Span(controller.getMessage("Only selected fields will be updated.", new Object[0]))});
                block2: for (int i3 = 0; i3 < orderedFieldIds.size(); ++i3) {
                    for (a formField : fullFieldList) {
                        Component extraComponent;
                        Component fieldComponent;
                        HasValue<?, ?> field = formField.getField();
                        if (!(field instanceof Component) || ((Component)field).getId().orElse(null) != orderedFieldIds.get(i3) || (fieldComponent = (Component)field).getId().orElse("").equals(this.getKeyId())) continue;
                        Checkbox checkbox = new Checkbox();
                        checkbox.setVisible(fieldComponent.isVisible());
                        formField.setCheckbox(checkbox);
                        HorizontalLayout label = new HorizontalLayout();
                        label.setWidth("250px");
                        label.add(new Component[]{checkbox, formField.getLabelComponent()});
                        label.setVerticalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{checkbox});
                        if (!(field instanceof Checkbox)) {
                            field.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> formField.getCheckbox().setValue((Object)true));
                        }
                        if ((extraComponent = formField.getExtraComponent()) != null) {
                            HorizontalLayout fieldLayout = new HorizontalLayout();
                            label.setVisible(fieldComponent.isVisible());
                            fieldLayout.add(new Component[]{fieldComponent});
                            fieldLayout.add(new Component[]{extraComponent});
                            fieldLayout.setVerticalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{extraComponent});
                            fieldLayout.setVisible(fieldComponent.isVisible());
                            formField.setExtraComponent((Component)fieldLayout);
                            FormLayout.FormItem formItem = this.layout.addFormItem((Component)fieldLayout, (Component)label);
                            if (!(fieldComponent instanceof Checkbox) && !(fieldComponent instanceof Slider)) {
                                formItem.getStyle().set("align-items", "start");
                            } else {
                                formItem.getStyle().set("align-items", "flex-end");
                            }
                            formField.setFormItem(formItem);
                            continue block2;
                        }
                        FormLayout.FormItem formItem = this.layout.addFormItem(fieldComponent, (Component)label);
                        if (!(fieldComponent instanceof Checkbox) && !(fieldComponent instanceof Slider)) {
                            formItem.getStyle().set("align-items", "start");
                        } else {
                            formItem.getStyle().set("align-items", "flex-end");
                        }
                        formField.setFormItem(formItem);
                        continue block2;
                    }
                }
                this.addAndExpand(new Component[]{this.layout});
            }
        }
    }

    public abstract void initFields();

    protected abstract void generateNewItem();

    public abstract boolean save(boolean var1);

    public abstract void delete();

    protected void addEvent(String eventCode, Set<String> values) {
        Object finalValue = "";
        Iterator<String> iterator = values.iterator();
        while (iterator.hasNext()) {
            finalValue = (String)finalValue + iterator.next();
            if (!iterator.hasNext()) continue;
            finalValue = (String)finalValue + ", ";
        }
        this.addEvent(eventCode, (String)finalValue);
    }

    protected void addEvent(String eventCode, String value) {
        String nodeId = this.controller.getSymmetricEngine().getNodeId();
        this.controller.getConsoleEventService().addEvent(new ConsoleEvent(this.controller.getConsoleUser().getUserId(), eventCode, nodeId, nodeId, null, value));
    }

    public boolean hasAdvancedOptions() {
        return this.advancedFieldList != null;
    }

    public void setAdvancedOptionsVisible(boolean visible) {
        if (this.hasAdvancedOptions()) {
            for (a formField : this.advancedFieldList) {
                formField.setVisible(visible);
            }
        }
    }

    protected void formatComboBox(Select<?> box) {
        box.setEmptySelectionAllowed(false);
        box.setWidth("16em");
    }

    public void setFormListener(ac formListener) {
        this.formListener = formListener;
    }

    public boolean isBulkForm() {
        return this.isBulk;
    }

    public Binder<T> getBinder() {
        return this.binder;
    }

    protected abstract List<String> getOrderedFieldIds();

    public abstract String getKeyId();

    public String getHelpSectionName() {
        return null;
    }

    protected class a {
        private HasValue<?, ?> field;
        private String label;
        private NativeLabel labelComponent;
        private Component extraComponent;
        private FormLayout.FormItem formItem;
        private Checkbox checkbox;

        public a(HasValue<?, ?> field) {
            this(field, null, null);
        }

        public a(HasValue<?, ?> field, String label) {
            this(field, label, null);
        }

        public a(HasValue<?, ?> field, String label, Component extraComponent) {
            this.field = field;
            this.label = label;
            this.extraComponent = extraComponent;
            this.checkbox = null;
            if (!(field instanceof Checkbox || field instanceof Slider || field instanceof w || extraComponent != null || R.this.isBulk)) {
                ((HasSize)field).setWidthFull();
            }
            if (R.this.isBulk && field instanceof HasStyle) {
                ((HasStyle)field).getStyle().set("margin-left", "80px");
            }
            if (!(field instanceof Checkbox)) {
                this.labelComponent = new NativeLabel(label);
            } else {
                this.labelComponent = new NativeLabel();
                ((Checkbox)field).setLabel(label);
            }
            if (!((Component)field).isVisible()) {
                this.setVisible(false);
            }
        }

        public void setVisible(boolean visible) {
            if (this.formItem != null) {
                this.formItem.setVisible(visible);
            }
            if (this.field instanceof Component) {
                ((Component)this.field).setVisible(visible);
            }
            this.labelComponent.setVisible(visible);
            if (this.extraComponent != null) {
                this.extraComponent.setVisible(visible);
            }
            if (this.checkbox != null) {
                this.checkbox.setVisible(visible);
            }
        }

        public HasValue<?, ?> getField() {
            return this.field;
        }

        public void setField(HasValue<?, ?> field) {
            this.field = field;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public NativeLabel getLabelComponent() {
            return this.labelComponent;
        }

        public void setLabelComponent(NativeLabel labelComponent) {
            this.labelComponent = labelComponent;
        }

        public Component getExtraComponent() {
            return this.extraComponent;
        }

        public void setExtraComponent(Component extraComponent) {
            this.extraComponent = extraComponent;
        }

        public FormLayout.FormItem getFormItem() {
            return this.formItem;
        }

        public void setFormItem(FormLayout.FormItem formItem) {
            this.formItem = formItem;
            if (!((Component)this.field).isVisible()) {
                formItem.setVisible(false);
            }
        }

        public Checkbox getCheckbox() {
            return this.checkbox;
        }

        public void setCheckbox(Checkbox checkbox) {
            this.checkbox = checkbox;
        }
    }
}

