/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.impl.N;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.UUID;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.ext.IHeartbeatListener;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeHost;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.util.AppUtils;

public class K
implements IBuiltInExtensionPoint,
IHeartbeatListener,
ISymmetricEngineAware {
    private ISymmetricEngine a;

    public void heartbeat(Node me) {
        N.b(this.a.getParameterService());
        if (!this.a.getParameterService().isRegistrationServer()) {
            return;
        }
        INodeService nodeService = this.a.getNodeService();
        String hostName = StringUtils.left((String)AppUtils.getHostName(), (int)60);
        String clusterInstanceId = this.a.getClusterService().getInstanceId();
        boolean isClustered = this.a.getClusterService().isClusteringEnabled();
        NodeHost nodeHost = null;
        for (NodeHost host : nodeService.findNodeHosts(me.getNodeId())) {
            if (!host.getHostName().equals(hostName) || isClustered && !clusterInstanceId.equals(host.getInstanceId())) continue;
            nodeHost = host;
            break;
        }
        if (nodeHost != null) {
            String oldMac = StringUtils.right((String)nodeHost.getInstanceId(), (int)12);
            String newMac = this.a(oldMac);
            if (oldMac == null || newMac != null && newMac.length() == 12 && !newMac.equals(oldMac)) {
                Object instanceId = nodeHost.getInstanceId();
                if (StringUtils.isBlank((CharSequence)instanceId)) {
                    instanceId = StringUtils.left((String)hostName, (int)23) + "-" + UUID.randomUUID().toString();
                }
                instanceId = ((String)instanceId).substring(0, ((String)instanceId).length() - 12) + newMac;
                nodeHost.setInstanceId((String)instanceId);
                nodeService.updateNodeHost(nodeHost);
            }
        }
    }

    public long getTimeBetweenHeartbeatsInSeconds() {
        return 1L;
    }

    private String a(String preferredMacAddress) {
        NetworkInterface ifc2;
        Enumeration<NetworkInterface> ifcs;
        String macAddress = null;
        if (preferredMacAddress != null) {
            try {
                ifcs = NetworkInterface.getNetworkInterfaces();
                while (ifcs.hasMoreElements()) {
                    String currentMacAddress;
                    ifc2 = ifcs.nextElement();
                    if (ifc2.getHardwareAddress() == null || ifc2.getHardwareAddress().length != 6 || !preferredMacAddress.equals(currentMacAddress = new String(Hex.encodeHex((byte[])ifc2.getHardwareAddress())))) continue;
                    macAddress = currentMacAddress;
                    break;
                }
            }
            catch (SocketException ifc2) {
                // empty catch block
            }
        }
        if (macAddress == null) {
            try {
                ifcs = NetworkInterface.getNetworkInterfaces();
                while (ifcs.hasMoreElements()) {
                    ifc2 = ifcs.nextElement();
                    String name = StringUtils.trimToEmpty((String)ifc2.getDisplayName()).toUpperCase();
                    if (ifc2.isLoopback() || ifc2.isVirtual() || ifc2.isPointToPoint() || ifc2.getHardwareAddress() == null || ifc2.getHardwareAddress().length != 6 || name.contains("DOCKER") || name.contains("VMWARE") || name.contains("VIRTUAL")) continue;
                    macAddress = new String(Hex.encodeHex((byte[])ifc2.getHardwareAddress()));
                    break;
                }
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
        return macAddress;
    }

    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.a = engine;
    }
}

