/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.authentication;

import com.jumpmind.symmetric.console.model.ConsoleUser;
import com.jumpmind.symmetric.console.service.IConsoleUserService;
import com.jumpmind.symmetric.console.service.impl.UserAuthenticationSAML;
import com.onelogin.saml2.Auth;
import com.onelogin.saml2.authn.SamlResponse;
import com.onelogin.saml2.exception.SettingsException;
import com.onelogin.saml2.factory.SamlMessageFactory;
import com.onelogin.saml2.http.HttpRequest;
import com.onelogin.saml2.http.HttpRequestUtils;
import com.onelogin.saml2.model.KeyStoreSettings;
import com.onelogin.saml2.servlet.jakarta.JakartaSamlHttpRequest;
import com.onelogin.saml2.servlet.jakarta.JakartaSamlHttpResponse;
import com.onelogin.saml2.settings.IdPMetadataParser;
import com.onelogin.saml2.settings.Saml2Settings;
import com.onelogin.saml2.settings.SettingsBuilder;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.jumpmind.security.ISecurityService;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.web.ServerSymmetricEngine;
import org.jumpmind.symmetric.web.ServletUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected void service(HttpServletRequest request, HttpServletResponse response) {
        ServerSymmetricEngine engine = ServletUtils.findEngine((HttpServletRequest)request, (ServletContext)this.getServletContext());
        Auth auth = this.getAuth(request, response, (ISymmetricEngine)engine);
        String endpointName = ServletUtils.getEndpointNameFromUrl((HttpServletRequest)request);
        if (auth != null && endpointName != null) {
            switch (endpointName) {
                case "sso": {
                    String baseUrl = this.getBaseUrl((ISymmetricEngine)engine);
                    this.handleSsoEndpoint(request, response, auth, baseUrl + "app/");
                    break;
                }
                case "test": {
                    this.handleSsoEndpoint(request, response, auth, "");
                    break;
                }
                case "metadata": {
                    this.handleMetadataEndpoint(request, response, auth);
                    break;
                }
                case "acs": {
                    this.handleAcsEndpoint(request, response, auth);
                }
            }
        }
    }

    private Auth getAuth(HttpServletRequest request, HttpServletResponse response, ISymmetricEngine engine) {
        if (engine == null) {
            this.log.error("Could not find engine {}", (Object)ServletUtils.getEngineNameFromUrl((HttpServletRequest)request));
            return null;
        }
        IParameterService parameterService = engine.getParameterService();
        HashMap<String, Object> samlData = new HashMap<String, Object>();
        String baseUrl = this.getBaseUrl(engine);
        samlData.put("onelogin.saml2.sp.entityid", baseUrl + "saml/" + engine.getEngineName() + "/metadata");
        final String acsUrl = baseUrl + "saml/" + engine.getEngineName() + "/acs";
        samlData.put("onelogin.saml2.sp.assertion_consumer_service.url", acsUrl);
        samlData.put("onelogin.saml2.sp.assertion_consumer_service.binding", "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        samlData.put("onelogin.saml2.sp.nameidformat", "urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
        samlData.put("onelogin.saml2.idp.single_sign_on_service.binding", "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        samlData.put("onelogin.saml2.security.authnrequest_signed", true);
        samlData.put("onelogin.saml2.security.signature_algorithm", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        samlData.put("onelogin.saml2.security.requested_authncontext", "urn:oasis:names:tc:SAML:2.0:ac:classes:Password");
        samlData.put("onelogin.saml2.security.reject_deprecated_alg", false);
        samlData.put("onelogin.saml2.security.want_xml_validation", true);
        samlData.put("onelogin.saml2.strict", true);
        ISecurityService securityService = engine.getSecurityService();
        KeyStore keyStore = securityService.getKeyStore();
        String entryAlias = "saml";
        String entryPassword = (String)StringUtils.defaultIfBlank((CharSequence)securityService.unobfuscateIfNeeded("javax.net.ssl.keyStorePassword"), (CharSequence)"changeit");
        SettingsBuilder settingsBuilder = new SettingsBuilder().fromValues(samlData, new KeyStoreSettings(keyStore, entryAlias, entryPassword));
        String idpEntityId = null;
        String propertiesFilePath = parameterService.getString("console.auth.saml.properties.file");
        if (StringUtils.isNotBlank((CharSequence)propertiesFilePath)) {
            Properties properties = new Properties();
            try {
                properties.load(new FileInputStream(new File(propertiesFilePath)));
                idpEntityId = properties.getProperty("onelogin.saml2.idp.entityid");
                settingsBuilder.fromProperties(properties);
            }
            catch (IOException e2) {
                this.log.error("Failed to read SAML properties file", (Throwable)e2);
            }
        }
        samlData.clear();
        this.setPropertyIfParameterIsSet(parameterService, samlData, "onelogin.saml2.sp.nameidformat", "console.auth.saml.sp.nameid.format");
        this.setPropertyIfParameterIsSet(parameterService, samlData, "onelogin.saml2.idp.entityid", "console.auth.saml.idp.entityid");
        this.setPropertyIfParameterIsSet(parameterService, samlData, "onelogin.saml2.idp.single_sign_on_service.url", "console.auth.saml.idp.sso.service.url");
        String idpMetadataUrl = parameterService.getString("console.auth.saml.idp.metadata.url");
        String idpCert = parameterService.getString("console.auth.saml.idp.cert");
        if (idpMetadataUrl != null) {
            idpEntityId = (String)samlData.getOrDefault("onelogin.saml2.idp.entityid", idpEntityId);
            try {
                Map idpMetadata = IdPMetadataParser.parseRemoteXML((URL)new URL(idpMetadataUrl), (String)idpEntityId);
                samlData.put("onelogin.saml2.idp.x509cert", idpMetadata.get("onelogin.saml2.idp.x509cert"));
                int i2 = 0;
                while (idpMetadata.containsKey("onelogin.saml2.idp.x509certMulti." + i2)) {
                    String key = "onelogin.saml2.idp.x509certMulti." + i2;
                    samlData.put(key, idpMetadata.get(key));
                    ++i2;
                }
            }
            catch (Exception e3) {
                this.log.error("Failed to read SAML IDP metadata from URL: " + idpMetadataUrl, (Throwable)e3);
            }
        } else if (idpCert != null) {
            try {
                samlData.put("onelogin.saml2.idp.x509cert", FileUtils.readFileToString((File)new File(idpCert), (Charset)StandardCharsets.UTF_8));
            }
            catch (IOException e4) {
                this.log.error("Failed to read SAML IDP X509 certificate", (Throwable)e4);
            }
        }
        this.setPropertyIfParameterIsSet(parameterService, samlData, "onelogin.saml2.organization.name", "console.auth.saml.organization.name");
        this.setPropertyIfParameterIsSet(parameterService, samlData, "onelogin.saml2.organization.displayname", "console.auth.saml.organization.display.name");
        this.setPropertyIfParameterIsSet(parameterService, samlData, "onelogin.saml2.organization.url", "console.auth.saml.organization.url");
        this.setPropertyIfParameterIsSet(parameterService, samlData, "onelogin.saml2.organization.lang", "console.auth.saml.organization.language");
        Saml2Settings settings = settingsBuilder.fromValues(samlData).build();
        try {
            Auth auth = new Auth(settings, JakartaSamlHttpRequest.makeHttpRequest((HttpServletRequest)request), JakartaSamlHttpResponse.makeHttpResponse((HttpServletResponse)response));
            auth.setSamlMessageFactory(new SamlMessageFactory(){

                public SamlResponse createSamlResponse(Saml2Settings settings, HttpRequest request) throws Exception {
                    return new SamlResponse(settings, acsUrl, request.getParameter("SAMLResponse"));
                }
            });
            return auth;
        }
        catch (SettingsException e5) {
            this.log.error("Failed to initialize SAML SP instance", (Throwable)e5);
            return null;
        }
    }

    private void setPropertyIfParameterIsSet(IParameterService parameterService, Map<String, Object> samlData, String property, String parameter) {
        String parameterValue = parameterService.getString(parameter);
        if (parameterValue != null) {
            samlData.put(property, parameterValue);
        }
    }

    private String getBaseUrl(ISymmetricEngine engine) {
        String baseUrl = engine.getNodeService().findIdentity().getSyncUrl();
        baseUrl = Strings.CS.removeEnd(baseUrl, (CharSequence)"/");
        String engineName = engine.getEngineName();
        Object end = "sync";
        if (Strings.CI.endsWith((CharSequence)baseUrl, (CharSequence)engineName)) {
            end = (String)end + "/" + engineName;
        }
        return Strings.CI.removeEnd(baseUrl, (CharSequence)end);
    }

    private void handleSsoEndpoint(HttpServletRequest request, HttpServletResponse response, Auth auth, String relayState) {
        request.getSession().removeAttribute("nameId");
        try {
            auth.login(relayState);
        }
        catch (SettingsException e2) {
            this.log.error("Failed to initiate SSO", (Throwable)e2);
        }
        catch (IOException e3) {
            this.log.error("Failed to initiate SSO", (Throwable)e3);
        }
    }

    private void handleMetadataEndpoint(HttpServletRequest request, HttpServletResponse response, Auth auth) {
        Saml2Settings settings = auth.getSettings();
        try {
            String metadata = settings.getSPMetadata();
            ServletOutputStream out = response.getOutputStream();
            List errors = Saml2Settings.validateMetadata((String)metadata);
            if (errors.isEmpty()) {
                out.println(metadata);
            } else {
                response.setContentType("text/html; charset=UTF-8");
                for (String error : errors) {
                    out.println("<p>" + error + "</p>");
                }
            }
            response.flushBuffer();
        }
        catch (IOException e2) {
            this.log.error("Failed to write to servlet response", (Throwable)e2);
        }
        catch (Exception e3) {
            this.log.error("Failed to retrieve SAML SP metadata", (Throwable)e3);
        }
    }

    private void handleAcsEndpoint(HttpServletRequest request, HttpServletResponse response, Auth auth) {
        try {
            List errors;
            auth.processResponse();
            ServletOutputStream out = response.getOutputStream();
            out.println("<html><head><title>SymmetricDS Pro SAML Authentication</title></head><body>\n");
            boolean isAuthenticated = auth.isAuthenticated();
            if (!isAuthenticated) {
                out.println("SAML authentication failed<br>");
            }
            if (!(errors = auth.getErrors()).isEmpty()) {
                String errorReason;
                out.println(StringUtils.join((Iterable)errors, (String)", ") + "<br>");
                if (auth.isDebugActive().booleanValue() && (errorReason = auth.getLastErrorReason()) != null && !errorReason.isEmpty()) {
                    out.println(auth.getLastErrorReason() + "<br>");
                }
            } else if (isAuthenticated) {
                IConsoleUserService consoleUserService;
                String relayState;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("SAML name ID: " + auth.getNameId());
                    this.log.debug("SAML attributes: " + String.valueOf(auth.getAttributes()));
                }
                if (StringUtils.isNotBlank((CharSequence)(relayState = request.getParameter("RelayState"))) && relayState != HttpRequestUtils.getSelfRoutedURLNoQuery((HttpRequest)JakartaSamlHttpRequest.makeHttpRequest((HttpServletRequest)request))) {
                    HttpSession session = request.getSession();
                    session.setAttribute("nameId", (Object)auth.getNameId());
                    session.setAttribute("attributeMap", (Object)auth.getAttributes());
                    response.sendRedirect(request.getParameter("RelayState"));
                    return;
                }
                out.println("SAML authentication successful<br>");
                out.println("Name ID (username): " + auth.getNameId() + "<br>");
                ServerSymmetricEngine engine = ServletUtils.findEngine((HttpServletRequest)request, (ServletContext)this.getServletContext());
                if (engine != null && (consoleUserService = (IConsoleUserService)engine.getExtensionService().getExtensionPoint(IConsoleUserService.class)) != null) {
                    ConsoleUser user = consoleUserService.findConsoleUser(auth.getNameId());
                    if (user != null) {
                        if (user.isEnabled()) {
                            if ("SAML".equals(user.getAuthenticationMethod())) {
                                out.println("The console user with this username can login using SAML authentication");
                            } else {
                                out.println("The console user with this username does not use SAML authentication");
                            }
                        } else {
                            out.println("The console user with this username is not enabled");
                        }
                    } else if (StringUtils.isNotBlank((CharSequence)engine.getParameterService().getString("console.auth.saml.role.group.map"))) {
                        String role = new UserAuthenticationSAML().getRole((ISymmetricEngine)engine, auth.getAttributes());
                        if (role != null) {
                            if (consoleUserService.findConsoleRole(role) != null) {
                                out.println("This username is mapped to the '" + role + "' role");
                            } else {
                                out.println("This username is mapped to the '" + role + "' role, but this role doesn't exist");
                            }
                        } else {
                            out.println("This username does not belong to a specified group");
                            out.println("SAML response attributes: " + String.valueOf(auth.getAttributes()));
                        }
                    } else {
                        out.println("Could not find a console user with this username");
                    }
                }
            }
            out.println("</body></html>");
        }
        catch (IOException e2) {
            this.log.error("Failed to write to servlet response", (Throwable)e2);
        }
        catch (Exception e3) {
            this.log.error("Failed to handle SAML response", (Throwable)e3);
        }
    }
}

