/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.authentication;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.ext.INodeRegistrationListener;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;

public class NodeRegistrationSecretListener
implements IBuiltInExtensionPoint,
INodeRegistrationListener,
ISymmetricEngineAware {
    protected ISymmetricEngine engine;

    public Map<String, String> getRequestProperties() {
        String secret = this.engine.getParameterService().getString("registration.secret");
        if (StringUtils.isNotBlank((CharSequence)secret)) {
            if (secret.startsWith("enc:")) {
                secret = this.engine.getSecurityService().decrypt(secret.substring("enc:".length()));
            } else if (secret.startsWith("obf:")) {
                secret = this.engine.getSecurityService().unobfuscate(secret.substring("obf:".length()));
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("regPassword", secret);
            return map;
        }
        return null;
    }

    public void registrationUrlUpdated(String url) {
    }

    public void registrationNextAttemptUpdated(int seconds) {
    }

    public void registrationStarting(Thread thread) {
    }

    public void registrationFailed(String message) {
    }

    public void registrationSyncTriggers() {
    }

    public void registrationSuccessful() {
    }

    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.engine = engine;
    }
}

