/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console;

import com.jumpmind.symmetric.console.impl.F;
import com.jumpmind.symmetric.console.impl.J;
import com.jumpmind.symmetric.console.impl.L;
import com.jumpmind.symmetric.console.impl.M;
import com.jumpmind.symmetric.console.impl.c;
import com.jumpmind.symmetric.console.model.ConsoleEvent;
import com.jumpmind.symmetric.console.model.ConsoleUser;
import com.jumpmind.symmetric.console.service.IConsoleEventService;
import com.jumpmind.symmetric.console.service.IConsoleUserService;
import com.jumpmind.symmetric.console.service.IProConsoleService;
import com.jumpmind.symmetric.console.ui.d;
import com.jumpmind.symmetric.statistic.IThroughputStatisticManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.jumpmind.properties.TypedProperties;
import org.jumpmind.security.ISecurityService;
import org.jumpmind.security.SecurityServiceFactory;
import org.jumpmind.symmetric.AbstractCommandLauncher;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.ITypedPropertiesFactory;
import org.jumpmind.symmetric.Message;
import org.jumpmind.symmetric.Version;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.TableReloadStatus;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.service.IClusterInstanceGenerator;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.impl.ClusterService;
import org.jumpmind.symmetric.transport.http.HttpConnection;
import org.jumpmind.symmetric.util.PropertiesUtil;
import org.jumpmind.util.AppUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SymmetricConsole
extends AbstractCommandLauncher {
    private static final String CMD_USER_ADD = "user-add";
    private static final String CMD_USER_MODIFY = "user-modify";
    private static final String CMD_USER_DELETE = "user-del";
    private static final String CMD_USER_PASSWORD = "user-passwd";
    private static final String CMD_USER_ENABLE = "user-enable";
    private static final String CMD_USER_DISABLE = "user-disable";
    private static final String CMD_KEYSTORE_PASSWORD = "ks-passwd";
    private static final String CMD_DATABASE_USER = "db-user";
    private static final String CMD_DATABASE_PASSWORD = "db-passwd";
    private static final String CMD_LICENSE_IMPORT = "license-import";
    private static final String CMD_LICENSE_EXPORT = "license-export";
    private static final String CMD_LICENSE_INFO = "license-info";
    private static final String CMD_LICENSE_USAGE = "license-usage";
    private static final String CMD_LOAD_LIST = "load-list";
    private static final String CMD_LOAD_CANCEL = "load-cancel";
    private static final String CMD_REST_API_KEY_GENERATE = "rest-key-gen";
    private static final String CMD_REST_API_KEY_DELETE = "rest-key-del";
    private static final String CMD_IMPORT_SSL_CERT = "import-ssl-cert";
    private static final String CMD_CLUSTER_TEST = "cluster-test";
    private static final String OPTION_ROLE = "role";
    private static final String OPTION_EMAIL = "email";
    private static final String OPTION_PASSWORD = "passwd";
    private static final String OPTION_ALIAS = "alias";
    private static final int WIDTH = 120;
    private static final int PAD = 3;
    private Logger log;

    public SymmetricConsole(ISymmetricEngine engine) {
        super("symconsole", "<subcommand> [options] [args]", "SymConsole.Option.");
        this.engine = engine;
        this.log = LoggerFactory.getLogger(SymmetricConsole.class);
    }

    public SymmetricConsole(String app, String argSyntax, String messageKeyPrefix) {
        super(app, argSyntax, messageKeyPrefix);
        Message.setBundleName((String)"symmetric-console-messages");
    }

    public static void main(String[] args) throws Exception {
        new SymmetricConsole("symconsole", "<subcommand> [options] [args]", "SymConsole.Option.").execute(args);
    }

    protected boolean printHelpIfNoOptionsAreProvided() {
        return true;
    }

    protected boolean requiresPropertiesFile(CommandLine line) {
        String[] args = line.getArgs();
        return args.length < 1 || !args[0].contains("rest-key-");
    }

    protected void printHelp(CommandLine line, Options options) {
        String[] args = line.getArgs();
        if (args.length > 1 && args[0].equals("help")) {
            this.printHelpCommand(line);
        } else {
            System.out.println(this.app + " version " + Version.version());
            System.out.println("Perform web console administration tasks with SymmetricDS Pro.\n");
            System.out.println("Usage: symconsole <subcommand> --engine [engine.name] [options] [args]");
            System.out.println("Usage: symconsole <subcommand> --properties [properties file] [options] [args]");
            System.out.println("\nType 'symconsole help <subcommand>' for help on a specific subcommand.\n");
            System.out.println("Available subcommands:");
            PrintWriter pw = new PrintWriter(System.out);
            this.printHelpLine(pw, CMD_USER_ADD);
            this.printHelpLine(pw, CMD_USER_MODIFY);
            this.printHelpLine(pw, CMD_USER_DELETE);
            this.printHelpLine(pw, CMD_USER_PASSWORD);
            this.printHelpLine(pw, CMD_USER_ENABLE);
            this.printHelpLine(pw, CMD_USER_DISABLE);
            this.printHelpLine(pw, CMD_KEYSTORE_PASSWORD);
            this.printHelpLine(pw, CMD_DATABASE_USER);
            this.printHelpLine(pw, CMD_DATABASE_PASSWORD);
            this.printHelpLine(pw, CMD_LICENSE_IMPORT);
            this.printHelpLine(pw, CMD_LICENSE_EXPORT);
            this.printHelpLine(pw, CMD_LICENSE_INFO);
            this.printHelpLine(pw, CMD_LICENSE_USAGE);
            this.printHelpLine(pw, CMD_LOAD_LIST);
            this.printHelpLine(pw, CMD_LOAD_CANCEL);
            this.printHelpLine(pw, CMD_REST_API_KEY_GENERATE);
            this.printHelpLine(pw, CMD_REST_API_KEY_DELETE);
            this.printHelpLine(pw, CMD_IMPORT_SSL_CERT);
            this.printHelpLine(pw, CMD_CLUSTER_TEST);
            pw.flush();
        }
    }

    private void printHelpLine(PrintWriter pw, String cmd) {
        String text = StringUtils.rightPad((String)("   " + cmd), (int)23, (String)" ") + Message.get((String)("SymConsole.Cmd." + cmd));
        new HelpFormatter().printWrapped(pw, 79, 25, text);
    }

    private void printHelpCommand(CommandLine line) {
        String[] args = line.getArgs();
        if (args.length > 1) {
            String cmd = args[1];
            HelpFormatter format = new HelpFormatter();
            PrintWriter writer = new PrintWriter(System.out);
            Options options = new Options();
            this.buildOptions(options);
            if (!Message.containsKey((String)("SymConsole.Usage." + cmd))) {
                System.err.println("ERROR: no help text for subcommand '" + cmd + "' was found.");
                System.err.println("For a list of subcommands, use " + this.app + " --help\n");
                return;
            }
            format.printWrapped(writer, 120, "Usage: " + this.app + " " + cmd + " " + Message.get((String)("SymConsole.Usage." + cmd)) + "\n");
            format.printWrapped(writer, 120, Message.get((String)("SymConsole.Help." + cmd)));
            if (options.getOptions().size() > 0) {
                format.printWrapped(writer, 120, "\nOptions:");
                format.printOptions(writer, 120, options, 3, 3);
            }
            writer.flush();
        }
    }

    protected void buildOptions(Options options) {
        super.buildOptions(options);
        this.addOption(options, "r", OPTION_ROLE, true);
        this.addOption(options, "E", OPTION_EMAIL, true);
        this.addOption(options, "P", OPTION_PASSWORD, true);
        this.addOption(options, null, OPTION_ALIAS, true);
    }

    protected boolean executeWithOptions(CommandLine line) throws Exception {
        String cmd;
        List args = line.getArgList();
        switch (cmd = (String)args.remove(0)) {
            case "user-add": {
                this.addUser(this.popArg(args, "Username", true), this.popArg(args, "First Name", true), this.popArg(args, "Last Name", true), line.getOptionValue(OPTION_ROLE), line.getOptionValue(OPTION_EMAIL), line.getOptionValue(OPTION_PASSWORD));
                return true;
            }
            case "user-modify": {
                this.modifyUser(this.getUser(args), line.getOptionValue(OPTION_ROLE), line.getOptionValue(OPTION_EMAIL));
                return true;
            }
            case "user-del": {
                this.deleteUser(this.getUser(args));
                return true;
            }
            case "user-passwd": {
                this.setUserPassword(this.getUser(args), line.getOptionValue(OPTION_PASSWORD));
                return true;
            }
            case "user-enable": {
                this.enableUser(this.getUser(args));
                return true;
            }
            case "user-disable": {
                this.disableUser(this.getUser(args));
                return true;
            }
            case "ks-passwd": {
                this.setKeystorePassword(line.getOptionValue(OPTION_PASSWORD));
                return true;
            }
            case "db-user": {
                this.setDatabaseUser(this.popArg(args, "Database Username", true));
                return true;
            }
            case "db-passwd": {
                this.setDatabasePassword(line.getOptionValue(OPTION_PASSWORD));
                return true;
            }
            case "license-import": {
                this.importLicense(this.popArg(args, "File", false));
                return true;
            }
            case "license-export": {
                this.exportLicense(this.popArg(args, "File", false));
                return true;
            }
            case "license-info": {
                this.printLicenseInfo();
                return true;
            }
            case "license-usage": {
                this.printLicenseUsage();
                return true;
            }
            case "load-list": {
                this.listLoads(line, args);
                return true;
            }
            case "load-cancel": {
                this.cancelLoad(line, args);
                return true;
            }
            case "rest-key-gen": {
                this.generateRestApiKey(args);
                return true;
            }
            case "rest-key-del": {
                this.deleteRestApiKey(this.popArg(args, "Key Name", true));
                return true;
            }
            case "import-ssl-cert": {
                this.importSslCert(line, args);
                return true;
            }
            case "cluster-test": {
                this.testCluster(this.popArg(args, "Node ID", true));
                return true;
            }
        }
        throw new ParseException("ERROR: no subcommand '" + cmd + "' was found.");
    }

    private IConsoleUserService getConsoleUserService() {
        return (IConsoleUserService)this.getSymmetricEngine().getExtensionService().getExtensionPoint(IConsoleUserService.class);
    }

    private IConsoleEventService getConsoleEventService() {
        return (IConsoleEventService)this.getSymmetricEngine().getExtensionService().getExtensionPoint(IConsoleEventService.class);
    }

    private String popArg(List<String> args, String argName, boolean required) {
        if (args.size() == 0) {
            if (required) {
                System.out.println("ERROR: Expected argument for: " + argName);
                System.exit(1);
            }
            return null;
        }
        return args.remove(0);
    }

    private void addEvent(String eventCode, String value) {
        String username = System.getProperty("user.name");
        String nodeId = this.getSymmetricEngine().getNodeId();
        this.getConsoleEventService().addEvent(new ConsoleEvent(username, eventCode, nodeId, nodeId, null, value));
    }

    public void addUser(String username, String firstName, String lastName, String role, String email, String password) {
        ConsoleUser user = new ConsoleUser();
        user.setUserId(username);
        user.setFirstName(firstName);
        user.setLastName(lastName);
        user.setRole(role);
        user.setEmail(email);
        if (StringUtils.isNotBlank((CharSequence)password)) {
            user.setPassword(password);
        } else {
            user.setPassword(new String(System.console().readPassword("Enter the new user's password: ", new Object[0])));
        }
        this.getConsoleUserService().updateUserEncryption(user);
        user.setLastPasswordTime(new Date());
        user.setCreateTime(new Date());
        this.getConsoleUserService().updateUserHistory(user);
        this.getConsoleUserService().save(user);
        this.addEvent("Console User Created", user.getUserId());
    }

    private ConsoleUser getUser(List<String> args) throws Exception {
        String username = this.popArg(args, "Username", true);
        ConsoleUser user = this.getConsoleUserService().findConsoleUser(username);
        if (user == null) {
            throw new ParseException("ERROR: no user named '" + username + "' was found.");
        }
        return user;
    }

    public void modifyUser(ConsoleUser user, String role, String email) {
        if (StringUtils.isNotBlank((CharSequence)role)) {
            user.setRole(role);
        }
        if (StringUtils.isNotBlank((CharSequence)email)) {
            user.setEmail(email);
        }
        this.getConsoleUserService().save(user);
        this.addEvent("Console User Modified", user.getUserId());
    }

    public void deleteUser(ConsoleUser user) {
        this.getConsoleUserService().delete(user);
        this.addEvent("Console User Deleted", user.getUserId());
    }

    public void setUserPassword(ConsoleUser user, String password) {
        if (StringUtils.isNotBlank((CharSequence)password)) {
            user.setPassword(password);
        } else {
            user.setPassword(new String(System.console().readPassword("Enter the user's new password: ", new Object[0])));
        }
        this.getConsoleUserService().updateUserEncryption(user);
        user.setLastPasswordTime(new Date());
        user.setFailedLoginAttempts(0);
        this.getConsoleUserService().updateUserHistory(user);
        this.getConsoleUserService().save(user);
        this.addEvent("Console Password Changed", user.getUserId());
    }

    public void enableUser(ConsoleUser user) {
        user.setEnabled(true);
        user.setFailedLoginAttempts(0);
        this.getConsoleUserService().save(user);
        this.addEvent("Console User Enabled", user.getUserId());
    }

    public void disableUser(ConsoleUser user) {
        user.setEnabled(false);
        this.getConsoleUserService().save(user);
        this.addEvent("Console User Disabled", user.getUserId());
    }

    private List<String> getKeytoolCommand(String keystorePath, String alias, String currentPassword, String newPassword) {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("keytool");
        cmd.add("-keystore");
        cmd.add(keystorePath);
        cmd.add("-new");
        cmd.add(newPassword);
        cmd.add("-storepass");
        if (alias != null) {
            cmd.add(newPassword);
            cmd.add("-keypass");
            cmd.add(currentPassword);
            cmd.add("-alias");
            cmd.add(alias);
            cmd.add("-keypasswd");
        } else {
            cmd.add(currentPassword);
            cmd.add("-storepasswd");
        }
        return cmd;
    }

    private void runCommand(List<String> command, File workingDirectory) throws Exception {
        ProcessBuilder pb = new ProcessBuilder(command);
        pb.directory(workingDirectory);
        pb.redirectErrorStream(true);
        Process process = pb.start();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String line = null;
        while ((line = reader.readLine()) != null) {
            if (!StringUtils.isNotBlank((CharSequence)line)) continue;
            if (this.log != null) {
                this.log.info(line);
                continue;
            }
            System.out.println(line);
        }
        int rc = process.waitFor();
        if (rc != 0) {
            throw new RuntimeException("Process builder returned " + rc);
        }
    }

    private void replaceLineInFile(String searchString, String newLine, File file) throws Exception {
        if (file.exists()) {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            StringBuilder fileContents = new StringBuilder(256);
            String line = reader.readLine();
            do {
                if (line == null) continue;
                if (Strings.CI.contains((CharSequence)line, (CharSequence)searchString)) {
                    fileContents.append(String.format("%s%n", newLine));
                    continue;
                }
                fileContents.append(String.format("%s%n", line));
            } while ((line = reader.readLine()) != null);
            reader.close();
            PrintWriter writer = new PrintWriter(file);
            writer.println(fileContents);
            writer.close();
        }
    }

    public void setKeystorePassword(String newPassword) throws Exception {
        File keystoreFile;
        String keystorePath = StringUtils.trimToNull((String)System.getProperty("sym.keystore.file"));
        if (StringUtils.isNotBlank((CharSequence)keystorePath) && (keystoreFile = new File(keystorePath)).exists()) {
            String currentPassword;
            if (StringUtils.isBlank((CharSequence)newPassword)) {
                newPassword = new String(System.console().readPassword("Enter the keystore's new password: ", new Object[0]));
            }
            if (StringUtils.isNotBlank((CharSequence)(currentPassword = System.getProperty("javax.net.ssl.keyStorePassword")))) {
                if (currentPassword.startsWith("obf:")) {
                    currentPassword = this.getSymmetricEngine().getSecurityService().unobfuscate(currentPassword.substring("obf:".length()));
                }
            } else {
                currentPassword = "changeit";
            }
            File symmetricDirectory = keystoreFile.getParentFile().getAbsoluteFile().getParentFile();
            FileInputStream in = new FileInputStream(keystoreFile);
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            keystore.load(in, currentPassword.toCharArray());
            Enumeration<String> aliasEnum = keystore.aliases();
            HashSet<String> aliases = new HashSet<String>();
            while (aliasEnum.hasMoreElements()) {
                aliases.add(aliasEnum.nextElement());
            }
            in.close();
            this.runCommand(this.getKeytoolCommand(keystorePath, null, currentPassword, newPassword), symmetricDirectory);
            for (String alias : aliases) {
                this.runCommand(this.getKeytoolCommand(keystorePath, alias, currentPassword, newPassword), symmetricDirectory);
            }
            String obfuscatedNewPassword = "obf:" + this.getSymmetricEngine().getSecurityService().obfuscate(newPassword);
            File setenv = new File(String.valueOf(symmetricDirectory) + "/bin/setenv");
            this.replaceLineInFile("-Djavax.net.ssl.keyStorePassword=", "-Djavax.net.ssl.keyStorePassword=" + obfuscatedNewPassword + " \\", setenv);
            File setenvBat = new File(String.valueOf(symmetricDirectory) + "/bin/setenv.bat");
            this.replaceLineInFile("-Djavax.net.ssl.keyStorePassword=", "-Djavax.net.ssl.keyStorePassword=" + obfuscatedNewPassword + " ^", setenvBat);
            File symServiceConf = new File(String.valueOf(symmetricDirectory) + "/conf/sym_service.conf");
            this.replaceLineInFile("wrapper.java.additional=-Djavax.net.ssl.keyStorePassword=", "wrapper.java.additional=-Djavax.net.ssl.keyStorePassword=" + obfuscatedNewPassword, symServiceConf);
            this.addEvent("Keystore Password Changed", null);
            return;
        }
        throw new RuntimeException("Could not find keystore");
    }

    private void checkForPropertiesFile() throws RuntimeException {
        if (this.propertiesFile == null && this.engine != null) {
            this.propertiesFile = PropertiesUtil.findPropertiesFileForEngineWithName((String)this.engine.getEngineName(), (Map)this.engine.getParameterService().getReplacementValues());
        }
        if (this.propertiesFile == null) {
            if (this.engine != null) {
                throw new RuntimeException("Could not find properties file for '" + this.engine.getEngineName() + "' engine");
            }
            throw new RuntimeException("Could not find properties file");
        }
    }

    public void setDatabaseUser(String username) throws Exception {
        this.checkForPropertiesFile();
        ITypedPropertiesFactory typedPropertiesFactory = PropertiesUtil.createTypedPropertiesFactory((File)this.propertiesFile, null);
        TypedProperties prop = typedPropertiesFactory.reload(this.propertiesFile);
        String key = "db.user";
        if (prop.is("load.only", false)) {
            key = "target.db.user";
        }
        prop.put((Object)key, (Object)username);
        typedPropertiesFactory.save((Properties)prop, this.propertiesFile, "Updated via symconsole");
        this.addEvent("Database User Changed", username);
    }

    public void setDatabasePassword(String password) throws Exception {
        this.checkForPropertiesFile();
        ITypedPropertiesFactory typedPropertiesFactory = PropertiesUtil.createTypedPropertiesFactory((File)this.propertiesFile, null);
        TypedProperties prop = typedPropertiesFactory.reload(this.propertiesFile);
        String key = "db.password";
        if (prop.is("load.only", false)) {
            key = "target.db.password";
        }
        if (StringUtils.isBlank((CharSequence)password)) {
            password = new String(System.console().readPassword("Enter the new password: ", new Object[0]));
        }
        password = "enc:" + this.getSymmetricEngine().getSecurityService().encrypt((String)password);
        prop.put((Object)key, password);
        typedPropertiesFactory.save((Properties)prop, this.propertiesFile, "Updated via symconsole");
        this.addEvent("Database Password Changed", null);
    }

    private void importLicense(String filePath) throws Exception {
        Object licenseKey = "";
        if (filePath != null) {
            File license = new File(filePath);
            try {
                licenseKey = FileUtils.readFileToString((File)license, (Charset)Charset.defaultCharset());
            }
            catch (IOException e2) {
                throw new RuntimeException("Failed to read file");
            }
        } else {
            String line;
            System.out.println("Paste the license key and press Enter: ");
            Scanner scanner = new Scanner(System.in);
            while (scanner.hasNextLine() && !StringUtils.isBlank((CharSequence)(line = scanner.nextLine()))) {
                licenseKey = (String)licenseKey + line + System.lineSeparator();
            }
            scanner.close();
        }
        M key = c.a((String)licenseKey, M.class);
        L licenseService = (L)this.getSymmetricEngine().getExtensionService().getExtensionPoint(L.class);
        String message = licenseService.a(key);
        if (message != null) {
            throw new RuntimeException("Failed to validate license key: " + message);
        }
        licenseService.a((String)licenseKey, System.getProperty("user.name"));
        this.addEvent("Install License key", null);
    }

    private void exportLicense(String filePath) throws Exception {
        String licenseKey = this.getSymmetricEngine().getParameterService().getString(F.a);
        if (filePath != null) {
            File license = new File(filePath);
            try {
                FileUtils.writeStringToFile((File)license, (String)licenseKey, (Charset)Charset.defaultCharset());
            }
            catch (IOException e2) {
                throw new RuntimeException("Failed to write to file");
            }
        } else {
            System.out.println(licenseKey);
        }
        this.addEvent("Export License key", null);
    }

    private void printLicenseInfo() {
        String licenseKeyString = this.getSymmetricEngine().getParameterService().getString(F.a);
        M licenseKey = c.a(licenseKeyString, M.class);
        System.out.println("     License Info: " + licenseKey.c());
        System.out.println("           Holder: " + licenseKey.d().toString().replaceAll("CN=", "").replaceAll("EMAILADDRESS=", ""));
        System.out.println("   Effective Date: " + this.formatDate(licenseKey.g()));
        if (licenseKey.i() > 0) {
            System.out.println("  Expiration Date: Never");
            System.out.println("  Max Maintenance: " + this.formatDate(licenseKey.j()));
        } else {
            String expirationString = this.formatDate(licenseKey.h());
            System.out.println("  Expiration Date: " + expirationString);
            System.out.println("  Max Maintenance: " + expirationString);
        }
        if (licenseKey.l() <= 0) {
            System.out.println("        Max Nodes: Unlimited");
        } else {
            System.out.println("        Max Nodes: " + licenseKey.l());
        }
        if (licenseKey.n() <= 0) {
            System.out.println("       Max Tables: Unlimited");
        } else {
            System.out.println("       Max Tables: " + licenseKey.n());
        }
        if (licenseKey.m() <= 0) {
            System.out.println("         Max Rows: Unlimited");
        } else {
            System.out.println("         Max Rows: " + licenseKey.m());
        }
        System.out.println("Mobile Multiplier: " + licenseKey.q());
        if (StringUtils.isNotBlank((CharSequence)licenseKey.k())) {
            System.out.println("      Instance ID: " + licenseKey.k());
        } else {
            System.out.println("      Instance ID: (" + ClusterService.initInstanceId((IClusterInstanceGenerator)new J()) + ")");
        }
    }

    private void printLicenseUsage() {
        L licenseService = (L)this.getSymmetricEngine().getExtensionService().getExtensionPoint(L.class);
        IThroughputStatisticManager statManager = (IThroughputStatisticManager)this.getSymmetricEngine().getStatisticManager();
        DecimalFormat percentFormat = new DecimalFormat("#.#%");
        int maxRows = licenseService.c();
        long usedRows = statManager.getCdcRowsIn() + statManager.getCdcRowsOut();
        if (maxRows > 0) {
            double rowsPercent = (double)usedRows / (double)maxRows;
            System.out.println("  Rows: " + usedRows + " of " + maxRows + " (" + percentFormat.format(rowsPercent) + ")");
        } else {
            System.out.println("  Rows: " + usedRows + " of unlimited");
        }
        int maxTables = licenseService.b();
        HashSet<String> tableNameList = new HashSet<String>();
        for (TriggerRouter triggerRouter : this.getSymmetricEngine().getTriggerRouterService().getTriggerRouters(false)) {
            Trigger trigger = triggerRouter.getTrigger();
            if (!trigger.isSyncOnInsert() && !trigger.isSyncOnUpdate() && !trigger.isSyncOnDelete()) continue;
            tableNameList.add(trigger.getSourceTableNameLowerCase());
        }
        int usedTables = tableNameList.size();
        if (maxTables > 0) {
            double tablesPercent = (double)usedTables / (double)maxTables;
            System.out.println("Tables: " + usedTables + " of " + maxTables + " (" + percentFormat.format(tablesPercent) + ")");
        } else {
            System.out.println("Tables: " + usedTables + " of unlimited");
        }
        int maxNodes = licenseService.a();
        long usedNodes = d.a(this.getSymmetricEngine().getNodeService().findAllNodes(), licenseService.e());
        if (maxNodes > 0) {
            double nodesPercent = (double)usedNodes / (double)maxNodes;
            System.out.println(" Nodes: " + usedNodes + " of " + maxNodes + " (" + percentFormat.format(nodesPercent) + ")");
        } else {
            System.out.println(" Nodes: " + usedNodes + " of unlimited");
        }
    }

    private void listLoads(CommandLine line, List<String> args) {
        List loads = this.getSymmetricEngine().getDataService().getTableReloadStatus();
        for (TableReloadStatus load : loads) {
            System.out.println("------------------------- Load " + load.getLoadId() + " -------------------------");
            System.out.println("                Load ID: " + load.getLoadId());
            System.out.println("         Source Node ID: " + load.getSourceNodeId());
            System.out.println("         Target Node ID: " + load.getTargetNodeId());
            System.out.println("             Start Time: " + this.formatDate(load.getStartTime()));
            System.out.println("               End Time: " + this.formatDate(load.getEndTime()));
            System.out.println("              Completed: " + load.isCompleted());
            System.out.println("              Cancelled: " + load.isCancelled());
            System.out.println("              Full Load: " + load.isFullLoad());
            System.out.println("    Start Data Batch ID: " + load.getStartDataBatchId());
            System.out.println("      End Data Batch ID: " + load.getEndDataBatchId());
            System.out.println("      Setup Batch Count: " + load.getSetupBatchCount());
            System.out.println("       Data Batch Count: " + String.valueOf(load.getDataBatchCount() < 0 ? "0" : Integer.valueOf(load.getDataBatchCount())));
            System.out.println("   Finalize Batch Count: " + load.getFinalizeBatchCount());
            System.out.println("   Setup Batches Loaded: " + load.getSetupBatchLoaded());
            System.out.println("    Data Batches Loaded: " + load.getDataBatchLoaded());
            System.out.println("Finalize Batches Loaded: " + load.getFinalizeBatchLoaded());
            System.out.println("            Table Count: " + load.getTableCount());
            System.out.println("            Rows Loaded: " + load.getRowsLoaded());
            System.out.println("              Row Count: " + load.getRowsCount());
            System.out.println("             Error Flag: " + load.isErrorFlag());
            System.out.println("              SQL State: " + load.getSqlState());
            System.out.println("               SQL Code: " + load.getSqlCode());
            System.out.println("            SQL Message: " + load.getSqlMessage());
            System.out.println("        Last Updated By: " + load.getLastUpdatedBy());
            System.out.println("       Last Update Time: " + this.formatDate(load.getLastUpdateTime()));
            System.out.println("  Batch Bulk Load Count: " + load.getNumBatchesBulkLoaded());
        }
    }

    private String formatDate(Date date) {
        return date != null ? new SimpleDateFormat("yyyy-MM-dd hh:mm:ss aaa").format(date) : "";
    }

    private void cancelLoad(CommandLine line, List<String> args) throws Exception {
        String loadId = this.popArg(args, "Load ID", true);
        String sourceNodeId = this.popArg(args, "Source Node ID", true);
        TableReloadStatus load = this.getSymmetricEngine().getDataService().getTableReloadStatusByLoadIdAndSourceNodeId(Long.parseLong(loadId), sourceNodeId);
        if (load == null) {
            throw new RuntimeException("Could not find a load with an ID of " + loadId);
        }
        ((IProConsoleService)this.getSymmetricEngine().getExtensionService().getExtensionPoint(IProConsoleService.class)).cancelLoad(load);
        this.addEvent("Cancel load", String.valueOf(load.getLoadId()));
    }

    private void generateRestApiKey(List<String> args) {
        String name = this.popArg(args, "Key Name", true);
        String description = this.popArg(args, "Key Description", true);
        String accessLevel = this.popArg(args, "Access Level", true);
        if (!"readwrite".equalsIgnoreCase(accessLevel) && !"readonly".equalsIgnoreCase(accessLevel)) {
            System.out.println("ERROR: Access level '" + accessLevel + "' is invalid. Valid access levels are 'readwrite' or 'readonly'.");
            System.exit(1);
            return;
        }
        String apiKey = SecurityServiceFactory.create().nextSecureHexString(30);
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e2) {
            throw new RuntimeException(e2);
        }
        String hashedApiKey = Base64.encodeBase64String((byte[])digest.digest(apiKey.getBytes(StandardCharsets.UTF_8)));
        Properties prop = this.loadProperties();
        prop.setProperty(hashedApiKey, accessLevel);
        prop.setProperty(hashedApiKey + ".name", name);
        prop.setProperty(hashedApiKey + ".description", description);
        this.saveProperties(prop);
        if (this.propertiesFile != null) {
            this.addEvent("REST API Key Created", name);
        }
        System.out.println(String.format("The REST API key is \"%s\".  This key is hashed and cannot be retrieved again.", apiKey));
    }

    private void saveProperties(Properties prop) {
        String symHome = AppUtils.getSymHome();
        try {
            prop.store(new FileOutputStream(new File(System.getProperty("sym.rest.properties.file", symHome + File.separator + "security/rest.properties"))), null);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    private Properties loadProperties() {
        String symHome = AppUtils.getSymHome();
        Properties prop = new Properties();
        try {
            prop.load(new FileInputStream(new File(System.getProperty("sym.rest.properties.file", symHome + File.separator + "security/rest.properties"))));
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
        return prop;
    }

    private void deleteRestApiKey(String name) throws ParseException {
        Properties prop = this.loadProperties();
        String keyToDelete = null;
        for (Object propKey : prop.keySet()) {
            String key = propKey.toString();
            if (!key.contains(".name") || !name.equals(prop.getProperty(key))) continue;
            keyToDelete = key.replace(".name", "");
            break;
        }
        if (keyToDelete == null) {
            throw new ParseException("ERROR: no REST API key named '" + name + "' was found.");
        }
        for (Object propKey : new ArrayList<Object>(prop.keySet())) {
            if (!propKey.toString().contains(keyToDelete)) continue;
            prop.remove(propKey);
        }
        this.saveProperties(prop);
        if (this.propertiesFile != null) {
            this.addEvent("REST API Key Deleted", name);
        }
    }

    private void importSslCert(CommandLine line, List<String> args) {
        String alias = line.getOptionValue(OPTION_ALIAS);
        String fileName = this.popArg(args, "filename", true);
        File file = new File(fileName);
        try (FileInputStream reader = new FileInputStream(file);){
            byte[] b2 = reader.readAllBytes();
            this.importSslCert(b2, alias, null, this.getFileType(fileName));
        }
        catch (FileNotFoundException e2) {
            throw new RuntimeException(e2);
        }
        catch (IOException e3) {
            throw new RuntimeException(e3);
        }
    }

    private void importSslCert(byte[] certData, String alias, String password, String fileType) {
        ISecurityService bouncyCastleSecurityService = SecurityServiceFactory.create((SecurityServiceFactory.SecurityServiceType)SecurityServiceFactory.SecurityServiceType.SERVER, (TypedProperties)new TypedProperties(System.getProperties()));
        KeyStore.PrivateKeyEntry entry = bouncyCastleSecurityService.createSslCert(certData, fileType, alias, password);
        if (entry instanceof KeyStore.PrivateKeyEntry) {
            KeyStore.PrivateKeyEntry privateKeyEntry = entry;
            bouncyCastleSecurityService.installSslCert(privateKeyEntry, alias);
        } else if (entry instanceof KeyStore.TrustedCertificateEntry) {
            KeyStore.TrustedCertificateEntry trustedEntry = (KeyStore.TrustedCertificateEntry)((Object)entry);
            bouncyCastleSecurityService.installTrustedCert(trustedEntry);
        }
    }

    protected String getFileType(String fileName) {
        String fileType = "pem";
        int extIndex = fileName.lastIndexOf(".");
        if (extIndex != -1) {
            fileType = fileName.substring(extIndex + 1);
        }
        return fileType;
    }

    private void testCluster(String nodeId) {
        URL infoUrl;
        ISymmetricEngine engine = this.getSymmetricEngine();
        Node node = engine.getNodeService().findNode(nodeId);
        if (node == null) {
            throw new RuntimeException("Could not find a node with an ID of " + nodeId);
        }
        String syncUrl = node.getSyncUrl();
        if (StringUtils.isBlank((CharSequence)syncUrl)) {
            throw new RuntimeException("Node " + nodeId + " doesn't have a sync URL");
        }
        try {
            infoUrl = new URL(syncUrl + (syncUrl.endsWith("/") ? "info" : "/info"));
        }
        catch (MalformedURLException e2) {
            throw new RuntimeException("Node " + nodeId + " has an invalid sync URL: " + syncUrl, e2);
        }
        IParameterService parameterService = engine.getParameterService();
        int connectTimeout = parameterService.getInt("http.connect.timeout.ms");
        int readTimeout = parameterService.getInt("http.timeout.ms");
        System.out.println("Checking for IP-based sticky sessions...");
        if (this.areSessionsSticky(infoUrl, nodeId, connectTimeout, readTimeout)) {
            System.out.println("The load balancer is configured to use IP-based sticky sessions");
        } else {
            System.out.println("IP-based sticky sessions were not detected");
            System.out.println("Checking for cookie-based sticky sessions...");
            CookieHandler.setDefault(new CookieManager(null, CookiePolicy.ACCEPT_ALL));
            if (this.areSessionsSticky(infoUrl, nodeId, connectTimeout, readTimeout)) {
                System.out.println("The load balancer is configured to use cookie-based sticky sessions");
            } else {
                System.out.println("The load balancer isn't configured to use sticky sessions");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean areSessionsSticky(URL infoUrl, String nodeId, int connectTimeout, int readTimeout) {
        String previousClusterServerId = null;
        int sleepMs = 0;
        int additionalDelayMs = 250;
        int i2 = 1;
        while (i2 <= 10) {
            try (HttpConnection connection = new HttpConnection(infoUrl);){
                connection.setRequestProperty("Accept-Charset", StandardCharsets.UTF_8.name());
                connection.setConnectTimeout(connectTimeout);
                connection.setReadTimeout(readTimeout);
                Properties properties = new Properties();
                long latencyMs = 0L;
                long startTs = System.currentTimeMillis();
                try (InputStream is = connection.getInputStream();){
                    latencyMs = System.currentTimeMillis() - startTs;
                    properties.load(is);
                }
                String message = "Attempt " + i2 + " took " + latencyMs + "ms";
                String clusterServerId = properties.getProperty("cluster.server.id");
                if (clusterServerId == null) {
                    System.out.println(message);
                    System.out.println("Clustering is not enabled for node " + nodeId);
                    boolean bl2 = false;
                    return bl2;
                }
                System.out.println(message + " and responded with a cluster.server.id of " + clusterServerId);
                if (i2 == 1) {
                    previousClusterServerId = clusterServerId;
                }
                if (!clusterServerId.equals(previousClusterServerId)) {
                    boolean bl3 = false;
                    return bl3;
                }
                if (i2 > 1 && i2 < 10) {
                    System.out.println("Waiting for " + (sleepMs += 250) + "ms before contacting " + String.valueOf(infoUrl));
                    Thread.sleep(sleepMs);
                }
            }
            catch (IOException | InterruptedException e2) {
                throw new RuntimeException(e2);
            }
            ++i2;
        }
        return true;
    }
}

