/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.common;

import com.jumpmind.symmetric.console.impl.F;
import com.jumpmind.symmetric.console.service.IMonitorService;
import com.jumpmind.symmetric.console.service.ITableGroupService;
import org.jumpmind.db.model.Table;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.common.ConfigurationChangedHelper;
import org.jumpmind.symmetric.common.TableConstants;
import org.jumpmind.symmetric.ext.IConfigurationChangedListener;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.util.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationChangedListener
implements IConfigurationChangedListener {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationChangedListener.class);
    private static final String SUFFIX = ConfigurationChangedListener.class.getSimpleName();
    private static final String CTX_KEY_FLUSH_TABLE_GROUPS = "FlushTableGroups." + SUFFIX;
    private static final String CTX_KEY_FLUSH_MONITORS = "FlushMonitors." + SUFFIX;
    private static final String CTX_KEY_FLUSH_NOTIFICATIONS = "FlushNotifications." + SUFFIX;
    private static final String CTX_KEY_CLUSTER_NEEDED = "ClusterEnable." + SUFFIX;
    private ISymmetricEngine engine;
    private String tablePrefix;

    public ConfigurationChangedListener(ISymmetricEngine engine) {
        this.engine = engine;
        this.tablePrefix = engine.getTablePrefix();
    }

    public void handleChange(Context context, Table table, CsvData data) {
        String paramKey;
        if (this.matchesTable(table, "table_group") || this.matchesTable(table, "table_group_hier") || this.matchesTable(table, "trigger") || this.matchesTable(table, "trigger_router")) {
            context.put(CTX_KEY_FLUSH_TABLE_GROUPS, (Object)true);
        }
        if (this.matchesTable(table, "monitor")) {
            context.put(CTX_KEY_FLUSH_MONITORS, (Object)true);
        }
        if (this.matchesTable(table, "notification")) {
            context.put(CTX_KEY_FLUSH_NOTIFICATIONS, (Object)true);
        }
        if (this.matchesTable(table, "parameter") && F.a.equals(paramKey = ConfigurationChangedHelper.getColumnValue((Table)table, (CsvData)data, (String)"param_key"))) {
            context.put(CTX_KEY_CLUSTER_NEEDED, (Object)true);
        }
    }

    public void contextCommitted(Context context) {
        if (context.remove(CTX_KEY_CLUSTER_NEEDED) != null) {
            this.engine.getClusterService().refreshLockEntries();
        }
    }

    public void contextComplete(Context context) {
        IMonitorService monitorService;
        if (context.remove(CTX_KEY_FLUSH_TABLE_GROUPS) != null) {
            log.info("Clearing cache for table groups");
            ITableGroupService tableGroupService = (ITableGroupService)this.engine.getExtensionService().getExtensionPoint(ITableGroupService.class);
            tableGroupService.clearCache();
        }
        if (context.remove(CTX_KEY_FLUSH_MONITORS) != null) {
            log.info("Clearing cache for monitors");
            monitorService = (IMonitorService)this.engine.getExtensionService().getExtensionPoint(IMonitorService.class);
            monitorService.flushMonitorCache();
        }
        if (context.remove(CTX_KEY_FLUSH_NOTIFICATIONS) != null) {
            log.info("Clearing cache for notifications");
            monitorService = (IMonitorService)this.engine.getExtensionService().getExtensionPoint(IMonitorService.class);
            monitorService.flushNotificationCache();
        }
    }

    private boolean matchesTable(Table table, String tableSuffix) {
        if (table != null && table.getName() != null) {
            return table.getName().equalsIgnoreCase(TableConstants.getTableName((String)this.tablePrefix, (String)tableSuffix));
        }
        return false;
    }
}

