/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.DefaultRequest;
import com.amazonaws.SignableRequest;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.Signer;
import com.amazonaws.http.HttpMethodName;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;

public class a
implements HttpRequestInterceptor {
    private final String a;
    private final Signer b;
    private final AWSCredentialsProvider c;

    public a(String service, Signer signer, AWSCredentialsProvider awsCredentialsProvider) {
        this.a = service;
        this.b = signer;
        this.c = awsCredentialsProvider;
    }

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        HttpEntityEnclosingRequest httpEntityEnclosingRequest;
        URIBuilder uriBuilder;
        try {
            uriBuilder = new URIBuilder(request.getRequestLine().getUri());
        }
        catch (URISyntaxException e2) {
            throw new IOException("Invalid URI", e2);
        }
        DefaultRequest signableRequest = new DefaultRequest(this.a);
        HttpHost host = (HttpHost)context.getAttribute("http.target_host");
        if (host != null) {
            signableRequest.setEndpoint(URI.create(host.toURI()));
        }
        HttpMethodName httpMethod = HttpMethodName.fromValue((String)request.getRequestLine().getMethod());
        signableRequest.setHttpMethod(httpMethod);
        try {
            signableRequest.setResourcePath(uriBuilder.build().getRawPath());
        }
        catch (URISyntaxException e3) {
            throw new IOException("Invalid URI", e3);
        }
        if (request instanceof HttpEntityEnclosingRequest) {
            httpEntityEnclosingRequest = (HttpEntityEnclosingRequest)request;
            if (httpEntityEnclosingRequest.getEntity() == null) {
                signableRequest.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
            } else {
                signableRequest.setContent(httpEntityEnclosingRequest.getEntity().getContent());
            }
        }
        signableRequest.setParameters(com.amazonaws.http.a.a(uriBuilder.getQueryParams()));
        signableRequest.setHeaders(com.amazonaws.http.a.a(request.getAllHeaders()));
        this.b.sign((SignableRequest)signableRequest, this.c.getCredentials());
        request.setHeaders(com.amazonaws.http.a.a(signableRequest.getHeaders()));
        if (request instanceof HttpEntityEnclosingRequest && (httpEntityEnclosingRequest = (HttpEntityEnclosingRequest)request).getEntity() != null) {
            BasicHttpEntity basicHttpEntity = new BasicHttpEntity();
            basicHttpEntity.setContent(signableRequest.getContent());
            httpEntityEnclosingRequest.setEntity((HttpEntity)basicHttpEntity);
        }
    }

    private static Map<String, List<String>> a(List<NameValuePair> params) {
        TreeMap<String, List<String>> parameterMap = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        for (NameValuePair nvp : params) {
            List argsList = parameterMap.computeIfAbsent(nvp.getName(), k2 -> new ArrayList());
            argsList.add(nvp.getValue());
        }
        return parameterMap;
    }

    private static Map<String, String> a(Header[] headers) {
        TreeMap<String, String> headersMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (Header header : headers) {
            if (com.amazonaws.http.a.a(header)) continue;
            headersMap.put(header.getName(), header.getValue());
        }
        return headersMap;
    }

    private static boolean a(Header header) {
        return "content-length".equalsIgnoreCase(header.getName()) && "0".equals(header.getValue()) || "host".equalsIgnoreCase(header.getName());
    }

    private static Header[] a(Map<String, String> mapHeaders) {
        Header[] headers = new Header[mapHeaders.size()];
        int i2 = 0;
        for (Map.Entry<String, String> headerEntry : mapHeaders.entrySet()) {
            headers[i2++] = new BasicHeader(headerEntry.getKey(), headerEntry.getValue());
        }
        return headers;
    }
}

