/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.sql;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.jumpmind.db.sql.ISqlStatementSource;
import org.jumpmind.exception.IoException;
import org.jumpmind.util.FormatUtils;

public class SqlScriptReader
extends LineNumberReader
implements ISqlStatementSource {
    public static final String QUERY_ENDS = ";";
    private String delimiter = ";";
    private Map<String, String> replacementTokens;
    private boolean usePrefixSuffixForReplacementTokens = false;
    private boolean stripOutComments = true;
    private boolean triggersContainJava = false;

    public SqlScriptReader(Reader in) {
        this(in, false);
    }

    public SqlScriptReader(Reader in, boolean triggersContainJava) {
        super(in);
        this.triggersContainJava = triggersContainJava;
    }

    public void setUsePrefixSuffixForReplacementTokens(boolean usePrefixSuffixForReplacementTokens) {
        this.usePrefixSuffixForReplacementTokens = usePrefixSuffixForReplacementTokens;
    }

    public void setStripOutComments(boolean stripOutComments) {
        this.stripOutComments = stripOutComments;
    }

    public boolean isStripOutComments() {
        return this.stripOutComments;
    }

    public boolean isUsePrefixSuffixForReplacementTokens() {
        return this.usePrefixSuffixForReplacementTokens;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setReplacementTokens(Map<String, String> replacementTokens) {
        this.replacementTokens = replacementTokens;
    }

    public Map<String, String> getReplacementTokens() {
        return this.replacementTokens;
    }

    @Override
    public String readSqlStatement() {
        try {
            String line = this.readLine();
            StringBuilder sql = null;
            int checkStatementEndsIndex = 0;
            CheckEndStatus endStatus = new CheckEndStatus();
            if (line != null) {
                String toExecute;
                boolean creatingJavaTrigger = false;
                do {
                    if (sql == null) {
                        sql = new StringBuilder();
                    }
                    sql.append("\n");
                    sql.append(line);
                    if (this.triggersContainJava) {
                        String trimmedLine = line.trim();
                        if (!creatingJavaTrigger && Strings.CI.startsWith((CharSequence)trimmedLine, (CharSequence)"CREATE TRIGGER")) {
                            creatingJavaTrigger = true;
                        } else if (creatingJavaTrigger && Strings.CI.startsWith((CharSequence)trimmedLine, (CharSequence)"END")) {
                            creatingJavaTrigger = false;
                        }
                    }
                    if (!creatingJavaTrigger && this.checkStatementEnds(endStatus, checkStatementEndsIndex, sql.toString())) {
                        toExecute = sql.substring(0, sql.lastIndexOf(this.delimiter));
                        if (StringUtils.isNotBlank((CharSequence)(toExecute = this.prepareForExecute(toExecute)))) {
                            return toExecute;
                        }
                        sql.setLength(0);
                        continue;
                    }
                    checkStatementEndsIndex = sql.length();
                } while ((line = this.readLine()) != null);
                toExecute = sql.toString();
                if (StringUtils.isNotBlank((CharSequence)toExecute)) {
                    return this.prepareForExecute(toExecute);
                }
                return null;
            }
            return null;
        }
        catch (IOException ex) {
            throw new IoException((Exception)ex);
        }
    }

    protected String prepareForExecute(String toExecute) {
        if (this.stripOutComments) {
            toExecute = this.removeComments(toExecute);
        }
        if (StringUtils.isNotBlank((CharSequence)(toExecute = FormatUtils.replaceTokens((String)toExecute, this.replacementTokens, (boolean)this.usePrefixSuffixForReplacementTokens)))) {
            return toExecute.trim();
        }
        return null;
    }

    private final String removeComments(String s) {
        char[] characters = s.toCharArray();
        LiteralInfo literalInfo = null;
        boolean inLineComment = false;
        boolean inBlockComment = false;
        int skipNextCount = 0;
        StringBuilder commentsRemoved = new StringBuilder();
        char prev = '\u0000';
        int index = 0;
        for (char cur : characters) {
            if (!inLineComment) {
                literalInfo = this.switchLiteral(literalInfo, index, characters);
            }
            if (literalInfo == null && !inLineComment && !inBlockComment) {
                inBlockComment = this.isBlockCommentStart(prev, cur);
                inLineComment = this.isLineCommentStart(prev, cur);
            }
            if (inLineComment && this.isLineCommentEnd(prev, cur)) {
                inLineComment = false;
            }
            if (inBlockComment && this.isBlockCommentEnd(prev, cur)) {
                inBlockComment = false;
                skipNextCount = 2;
            }
            if (!inBlockComment && !inLineComment && skipNextCount == 0) {
                commentsRemoved.append(prev);
            } else if (skipNextCount > 0) {
                --skipNextCount;
            }
            prev = cur;
            ++index;
        }
        if (!inBlockComment && !inLineComment && skipNextCount == 0) {
            commentsRemoved.append(prev);
        }
        return commentsRemoved.toString();
    }

    private final boolean isLineCommentStart(char prev, char cur) {
        return prev == '#' && cur == '#' || prev == '-' && cur == '-' || prev == '/' && cur == '/';
    }

    private final boolean isLineCommentEnd(char prev, char cur) {
        return prev == '\n';
    }

    private final boolean isBlockCommentStart(char prev, char cur) {
        return this.stripOutComments && prev == '/' && cur == '*';
    }

    private final boolean isBlockCommentEnd(char prev, char cur) {
        return prev == '*' && cur == '/';
    }

    private final LiteralInfo switchLiteral(LiteralInfo literalInfo, int currentIndex, char[] statement) {
        if (literalInfo == null && currentIndex > 0) {
            char prev = statement[currentIndex - 1];
            if (prev == '\'' || prev == '\"' || prev == '`') {
                literalInfo = new LiteralInfo(prev, currentIndex);
            }
        } else if (literalInfo != null) {
            char cur = statement[currentIndex];
            char prev = statement[currentIndex - 1];
            if (prev == literalInfo.type && cur != literalInfo.type) {
                char check;
                int count = 0;
                for (int i = currentIndex - 2; i >= literalInfo.startIndex && (check = statement[i]) == literalInfo.type; --i) {
                    ++count;
                }
                if (count % 2 == 0) {
                    literalInfo = null;
                }
            }
        }
        return literalInfo;
    }

    private final boolean checkStatementEnds(CheckEndStatus status, int start, String s) {
        char[] characters = s.toCharArray();
        char prev = '\u0000';
        for (int i = start; i < characters.length; ++i) {
            char cur = characters[i];
            if (!status.inLineComment) {
                status.literalInfo = this.switchLiteral(status.literalInfo, i, characters);
            }
            if (status.literalInfo == null && !status.inLineComment && !status.inBlockComment) {
                status.inBlockComment = this.isBlockCommentStart(prev, cur);
                status.inLineComment = this.isLineCommentStart(prev, cur);
            }
            if (status.inLineComment && this.isLineCommentEnd(prev, cur)) {
                status.inLineComment = false;
            }
            if (status.inBlockComment && this.isBlockCommentEnd(prev, cur)) {
                status.inBlockComment = false;
            }
            if (status.literalInfo == null && !status.inBlockComment && !status.inLineComment && s.substring(i, i + this.delimiter.length()).equals(this.delimiter)) {
                return true;
            }
            prev = cur;
        }
        return false;
    }

    static class CheckEndStatus {
        LiteralInfo literalInfo = null;
        boolean inLineComment = false;
        boolean inBlockComment = false;

        CheckEndStatus() {
        }
    }

    static class LiteralInfo {
        char type;
        int startIndex;

        public LiteralInfo(char type, int startIndex) {
            this.type = type;
            this.startIndex = startIndex;
        }
    }
}

