/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.sql;

import org.jumpmind.db.sql.ISqlResultsListener;
import org.jumpmind.db.sql.SqlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogSqlResultsListener
implements ISqlResultsListener {
    private static final Logger log = LoggerFactory.getLogger(LogSqlResultsListener.class);

    @Override
    public void sqlBefore(String sql, int lineNumber) {
        log.info("Executing DDL: {}", (Object)sql);
    }

    @Override
    public void sqlErrored(String sql, SqlException ex, int lineNumber, boolean dropStatement, boolean sequenceCreate) {
        if (dropStatement || sequenceCreate) {
            log.info("DDL failed: {}", (Object)sql);
        } else {
            log.warn("DDL failed: {}", (Object)sql);
        }
    }

    @Override
    public void sqlApplied(String sql, int rowsUpdated, int rowsRetrieved, int lineNumber) {
    }
}

