/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.sqlite;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.ForeignKey;
import org.jumpmind.db.model.IIndex;
import org.jumpmind.db.model.IndexColumn;
import org.jumpmind.db.model.NonUniqueIndex;
import org.jumpmind.db.model.PlatformTrigger;
import org.jumpmind.db.model.Reference;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.model.Trigger;
import org.jumpmind.db.model.UniqueIndex;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.IDdlReader;
import org.jumpmind.db.platform.sqlite.AbstractSqlRowMapper;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.sql.SqlConstants;
import org.jumpmind.db.sql.SqlException;
import org.jumpmind.db.sql.mapper.RowMapper;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.db.util.TableRow;

public class SqliteDdlReader
implements IDdlReader {
    static final ColumnMapper COLUMN_MAPPER = new ColumnMapper();
    static final IndexMapper INDEX_MAPPER = new IndexMapper();
    static final IndexColumnMapper INDEX_COLUMN_MAPPER = new IndexColumnMapper();
    protected IDatabasePlatform platform;

    public SqliteDdlReader(IDatabasePlatform platform) {
        this.platform = platform;
    }

    @Override
    public List<String> getTableNames(String catalog, String schema, String[] tableTypes) {
        return this.platform.getSqlTemplate().query("select tbl_name from sqlite_master where type='table'", SqlConstants.STRING_MAPPER, new Object[0]);
    }

    @Override
    public Database readTables(String catalog, String schema, String[] tableTypes) {
        List<String> tableNames = this.getTableNames(catalog, schema, tableTypes);
        Database database = new Database();
        for (String tableName : tableNames) {
            Table table = this.readTable(catalog, schema, tableName);
            if (table == null) continue;
            database.addTable(table);
        }
        return database;
    }

    protected void checkColumns(List<Column> columns, String tableName) {
        String ddl = this.platform.getSqlTemplate().queryForObject("select sql from sqlite_master where tbl_name=?", String.class, tableName);
        if (StringUtils.isNotBlank((CharSequence)ddl)) {
            String[] commaSplit;
            int closingParen;
            int openingParen = ddl.indexOf("(");
            if (openingParen != -1) {
                ddl = ddl.substring(openingParen + 1);
            }
            if ((closingParen = ddl.lastIndexOf(")")) != -1) {
                ddl = ddl.substring(0, closingParen);
            }
            for (String string : commaSplit = ddl.split(",")) {
                for (Column col : columns) {
                    int i;
                    if (!string.contains(col.getName())) continue;
                    if (string.toUpperCase().contains("AUTOINCREMENT")) {
                        col.setAutoIncrement(true);
                    }
                    if (!col.isGenerated()) continue;
                    String[] split = StringUtils.split((String)string);
                    for (i = 0; i < split.length && !split[i].equalsIgnoreCase("as"); ++i) {
                    }
                    if (i >= split.length - 1) continue;
                    col.setDefaultValue(String.join((CharSequence)" ", Arrays.copyOfRange(split, i + 1, split.length)));
                }
            }
        }
    }

    public Table readTable(String catalog, String schema, String tableName, String sql) {
        throw new NotImplementedException();
    }

    @Override
    public Table readTable(ISqlTransaction transaction, String catalog, String schema, String table) {
        return this.readTable(catalog, schema, table);
    }

    private String quote(String name) {
        String quote = this.platform.getDatabaseInfo().getDelimiterToken();
        return quote + name + quote;
    }

    @Override
    public Table readTable(String catalog, String schema, String tableName) {
        Table table = null;
        List<Column> columns = this.platform.getSqlTemplate().query("pragma table_xinfo(" + this.quote(tableName) + ")", COLUMN_MAPPER, new Object[0]);
        this.checkColumns(columns, tableName);
        if (columns != null && columns.size() > 0) {
            table = new Table(tableName);
            for (Column column : columns) {
                table.addColumn(column);
            }
            List<IIndex> indexes = this.platform.getSqlTemplate().query("pragma index_list(" + this.quote(tableName) + ")", INDEX_MAPPER, new Object[0]);
            for (IIndex index : indexes) {
                List<IndexColumn> indexColumns = this.platform.getSqlTemplate().query("pragma index_info(" + index.getName() + ")", INDEX_COLUMN_MAPPER, new Object[0]);
                for (IndexColumn indexColumn : indexColumns) {
                    if (indexColumn.getName().startsWith("sqlite_autoindex_")) continue;
                    index.addColumn(indexColumn);
                    indexColumn.setColumn(table.getColumnWithName(indexColumn.getName()));
                }
                if (index.isUnique() && index.getName().toLowerCase().contains("autoindex") && !index.hasAllPrimaryKeys()) {
                    for (IndexColumn indexColumn : indexColumns) {
                        table.getColumnWithName(indexColumn.getName()).setUnique(true);
                    }
                    continue;
                }
                if ((index.hasAllPrimaryKeys() || index.isUnique()) && index.getName().toLowerCase().contains("autoindex")) continue;
                table.addIndex(index);
            }
            HashMap<Integer, ForeignKey> hashMap = new HashMap<Integer, ForeignKey>();
            List<Row> rows = this.platform.getSqlTemplate().query("pragma foreign_key_list(" + this.quote(tableName) + ")", new RowMapper(), new Object[0]);
            for (Row row : rows) {
                Integer id = row.getInt("id");
                ForeignKey fk = (ForeignKey)hashMap.get(id);
                if (fk == null) {
                    fk = new ForeignKey();
                    fk.setForeignTable(new Table(row.getString("table")));
                    hashMap.put(id, fk);
                    table.addForeignKey(fk);
                }
                fk.addReference(new Reference(new Column(row.getString("from")), new Column(row.getString("to"))));
            }
        }
        return table;
    }

    @Override
    public List<String> getCatalogNames() {
        return new ArrayList<String>(0);
    }

    @Override
    public List<String> getSchemaNames(String catalog) {
        return new ArrayList<String>(0);
    }

    @Override
    public List<String> getTableTypes() {
        return new ArrayList<String>(0);
    }

    @Override
    public List<String> getColumnNames(String catalog, String schema, String tableName) {
        return new ArrayList<String>(0);
    }

    @Override
    public Trigger getTriggerFor(Table table, String triggerName) {
        Trigger trigger = null;
        List<Trigger> triggers = this.getTriggers(table.getCatalog(), table.getSchema(), table.getName());
        for (Trigger t : triggers) {
            if (!t.getName().equals(triggerName)) continue;
            trigger = t;
            break;
        }
        return trigger;
    }

    @Override
    public List<Trigger> getTriggers(String catalog, String schema, String tableName) throws SqlException {
        ArrayList<Trigger> triggers = new ArrayList();
        String sql = "SELECT name AS trigger_name, tbl_name AS table_name, rootpage, sql, type AS object_type FROM sqlite_master WHERE table_name=? AND object_type='trigger';";
        triggers = this.platform.getSqlTemplate().query(sql, new ISqlRowMapper<Trigger>(){

            @Override
            public Trigger mapRow(Row row) {
                Trigger trigger = new Trigger();
                trigger.setName(row.getString("trigger_name"));
                trigger.setTableName(row.getString("table_name"));
                trigger.setEnabled(true);
                trigger.setSource(row.getString("sql"));
                row.remove("sql");
                trigger.setMetaData((Map<String, Object>)((Object)row));
                return trigger;
            }
        }, tableName.toLowerCase());
        return triggers;
    }

    @Override
    public List<Trigger> getApplicationTriggersForModel(String catalog, String schema, String tableName, String triggerPrefix) {
        List<Trigger> triggers = this.platform.getDdlReader().getTriggers(catalog, schema, tableName).stream().filter(t -> !t.getName().toUpperCase().startsWith(triggerPrefix.toUpperCase() + "_")).collect(Collectors.toList());
        if (triggers != null && triggers.size() > 0) {
            for (Trigger trigger : triggers) {
                PlatformTrigger platformTrigger = new PlatformTrigger(this.platform.getName(), trigger.getSource());
                trigger.addPlatformTrigger(platformTrigger);
            }
        }
        return triggers;
    }

    @Override
    public Collection<ForeignKey> getExportedKeys(Table table) {
        return null;
    }

    @Override
    public Collection<ForeignKey> getForeignKeys(String catalog, String schema, String tableName) {
        return null;
    }

    @Override
    public List<TableRow> getExportedForeignTableRows(ISqlTransaction transaction, List<TableRow> tableRows, Set<TableRow> visited, BinaryEncoding encoding) {
        return null;
    }

    @Override
    public List<TableRow> getImportedForeignTableRows(List<TableRow> tableRows, Set<TableRow> visited, BinaryEncoding encoding) {
        return null;
    }

    @Override
    public PlatformTrigger getPlatformTrigger(IDatabasePlatform platform, Trigger trigger) {
        return new PlatformTrigger(platform.getName(), trigger.getSource());
    }

    static class ColumnMapper
    extends AbstractSqlRowMapper<Column> {
        ColumnMapper() {
        }

        @Override
        public Column mapRow(Row row) {
            Column col = new Column((String)row.get("name"), this.booleanValue(row.get("pk")));
            col.setMappedType(this.toJdbcType((String)row.get("type")));
            col.setRequired(this.booleanValue(row.get("notnull")));
            col.setDefaultValue(this.scrubDefaultValue((String)row.get("dflt_value")));
            col.setGenerated(this.intValue(row.get("hidden")) == 2);
            return col;
        }

        protected String scrubDefaultValue(String defaultValue) {
            if (defaultValue != null && defaultValue.startsWith("'") && defaultValue.endsWith("'")) {
                defaultValue = defaultValue.substring(1, defaultValue.length() - 1);
            }
            return defaultValue;
        }

        public String toJdbcType(String colType) {
            String string = colType = colType == null ? "TEXT" : colType.toUpperCase();
            colType = colType.startsWith("INT") ? "INTEGER" : (colType.startsWith("NUM") ? "NUMERIC" : (colType.startsWith("BLOB") ? "BLOB" : (colType.startsWith("CLOB") ? "CLOB" : (colType.startsWith("TEXT") || colType.contains("CHAR") ? "VARCHAR" : (colType.startsWith("FLOAT") ? "FLOAT" : (colType.startsWith("DOUBLE") ? "DOUBLE" : (colType.startsWith("REAL") ? "REAL" : (colType.startsWith("DECIMAL") ? "DECIMAL" : (colType.startsWith("DATE") ? "DATE" : (colType.startsWith("TIMESTAMP") ? "TIMESTAMP" : (colType.startsWith("TIME") ? "TIME" : "VARCHAR")))))))))));
            return colType;
        }
    }

    static class IndexMapper
    extends AbstractSqlRowMapper<IIndex> {
        IndexMapper() {
        }

        @Override
        public IIndex mapRow(Row row) {
            boolean unique = this.booleanValue(row.get("unique"));
            String name = (String)row.get("name");
            if (unique) {
                return new UniqueIndex(name);
            }
            return new NonUniqueIndex(name);
        }
    }

    static class IndexColumnMapper
    extends AbstractSqlRowMapper<IndexColumn> {
        IndexColumnMapper() {
        }

        @Override
        public IndexColumn mapRow(Row row) {
            IndexColumn column = new IndexColumn();
            column.setName((String)row.get("name"));
            column.setOrdinalPosition(this.intValue(row.get("seqno")));
            return column;
        }
    }
}

