/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.nuodb;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jumpmind.db.alter.AddColumnChange;
import org.jumpmind.db.alter.AddPrimaryKeyChange;
import org.jumpmind.db.alter.ColumnChange;
import org.jumpmind.db.alter.ColumnDataTypeChange;
import org.jumpmind.db.alter.CopyColumnValueChange;
import org.jumpmind.db.alter.RemoveColumnChange;
import org.jumpmind.db.alter.TableChange;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.ForeignKey;
import org.jumpmind.db.model.IIndex;
import org.jumpmind.db.model.PlatformColumn;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.AbstractDdlBuilder;

public class NuoDbDdlBuilder
extends AbstractDdlBuilder {
    public NuoDbDdlBuilder() {
        super("nuodb");
        this.databaseInfo.setSystemForeignKeyIndicesAlwaysNonUnique(true);
        this.databaseInfo.setMaxIdentifierLength(128);
        this.databaseInfo.setNullAsDefaultValueRequired(true);
        this.databaseInfo.setDefaultValuesForLongTypesSupported(false);
        this.databaseInfo.setNonPKIdentityColumnsSupported(true);
        this.databaseInfo.setSyntheticDefaultValueForRequiredReturned(true);
        this.databaseInfo.setAlterTableForDropUsed(true);
        this.databaseInfo.setCommentPrefix("//");
        this.databaseInfo.setDelimiterToken("`");
        this.databaseInfo.addNativeTypeMapping(-7, "BOOLEAN", 16);
        this.databaseInfo.addNativeTypeMapping(2004, "BLOB");
        this.databaseInfo.addNativeTypeMapping(2005, "TEXT");
        this.databaseInfo.addNativeTypeMapping(6, "DOUBLE");
        this.databaseInfo.addNativeTypeMapping(8, "DOUBLE");
        this.databaseInfo.addNativeTypeMapping(-1, "TEXT");
        this.databaseInfo.addNativeTypeMapping(-3, "VARBINARY");
        this.databaseInfo.addNativeTypeMapping(-4, "BLOB");
        this.databaseInfo.addNativeTypeMapping(2, "DECIMAL");
        this.databaseInfo.addNativeTypeMapping(1, "CHAR");
        this.databaseInfo.addNativeTypeMapping(12, "VARCHAR");
        this.databaseInfo.addNativeTypeMapping(93, "TIMESTAMP");
        this.databaseInfo.addNativeTypeMapping(-6, "SMALLINT", 5);
        this.databaseInfo.addNativeTypeMapping(5, "SMALLINT");
        this.databaseInfo.addNativeTypeMapping(4, "INTEGER");
        this.databaseInfo.addNativeTypeMapping(-5, "BIGINT");
        this.databaseInfo.addNativeTypeMapping(16, "BOOLEAN", 16);
        this.databaseInfo.addNativeTypeMapping(3, "DECIMAL");
        this.databaseInfo.addNativeTypeMapping(91, "DATE");
        this.databaseInfo.addNativeTypeMapping(92, "TIME");
        this.databaseInfo.addNativeTypeMapping(-15, "NATIONAL CHARACTER");
        this.databaseInfo.setHasSize(93, true);
        this.databaseInfo.setHasSize(-101, true);
        this.databaseInfo.setHasSize(-102, true);
        this.databaseInfo.setMaxSize("TIMESTAMP", 9);
        this.databaseInfo.setMaxSize("TIME", 9);
        this.databaseInfo.setDefaultSize(1, 254);
        this.databaseInfo.setDefaultSize(12, 254);
        this.databaseInfo.setDefaultSize(-2, 254);
        this.databaseInfo.setDefaultSize(-3, 254);
        this.databaseInfo.setNonBlankCharColumnSpacePadded(false);
        this.databaseInfo.setBlankCharColumnSpacePadded(false);
        this.databaseInfo.setCharColumnSpaceTrimmed(false);
        this.databaseInfo.setEmptyStringNulled(false);
        this.databaseInfo.setSyntheticDefaultValueForRequiredReturned(false);
        this.addEscapedCharSequence("\\", "\\\\");
        this.addEscapedCharSequence("\u0000", "\\0");
        this.addEscapedCharSequence("\"", "\\\"");
        this.addEscapedCharSequence("\b", "\\b");
        this.addEscapedCharSequence("\n", "\\n");
        this.addEscapedCharSequence("\r", "\\r");
        this.addEscapedCharSequence("\t", "\\t");
        this.addEscapedCharSequence("\u001a", "\\Z");
    }

    @Override
    protected String getFullyQualifiedTableNameShorten(Table table) {
        Object result = "";
        result = (String)result + this.getDelimitedIdentifier(this.getTableName(table.getName()));
        return result;
    }

    @Override
    public boolean areColumnSizesTheSame(Column sourceColumn, Column targetColumn) {
        if (sourceColumn.getMappedType().equals("DECIMAL") && targetColumn.getMappedType().equals("DECIMAL")) {
            int targetSize = targetColumn.getSizeAsInt();
            int sourceSize = sourceColumn.getSizeAsInt();
            return targetSize > 8 && sourceSize == 8 && targetColumn.getScale() == sourceColumn.getScale();
        }
        return super.areColumnSizesTheSame(sourceColumn, targetColumn);
    }

    @Override
    protected void dropTable(Table table, StringBuilder ddl, boolean temporary, boolean recreate) {
        ddl.append("DROP TABLE IF EXISTS ");
        ddl.append(this.getFullyQualifiedTableNameShorten(table));
        this.printEndOfStatement(ddl);
    }

    @Override
    protected void writeColumnAutoIncrementStmt(Table table, Column column, StringBuilder ddl) {
        ddl.append("GENERATED BY DEFAULT AS IDENTITY");
    }

    @Override
    public String getSelectLastIdentityValues(Table table) {
        return "SELECT LAST_INSERT_ID() FROM SYSTEM.DUAL";
    }

    @Override
    protected void processTableStructureChanges(Database currentModel, Database desiredModel, Table sourceTable, Table targetTable, List<TableChange> changes, StringBuilder ddl) {
        ArrayList<Column> changedColumns = new ArrayList<Column>();
        Iterator<TableChange> changeIt = changes.iterator();
        while (changeIt.hasNext()) {
            TableChange change = changeIt.next();
            if (change instanceof RemoveColumnChange) {
                this.processChange(currentModel, desiredModel, (RemoveColumnChange)change, ddl);
                changeIt.remove();
                continue;
            }
            if (change instanceof CopyColumnValueChange) {
                CopyColumnValueChange copyColumnChange = (CopyColumnValueChange)change;
                this.processChange(currentModel, desiredModel, copyColumnChange, ddl);
                changeIt.remove();
                continue;
            }
            if (change instanceof AddPrimaryKeyChange) {
                this.processChange(currentModel, desiredModel, (AddPrimaryKeyChange)change, ddl);
                changeIt.remove();
                continue;
            }
            if (change instanceof AddColumnChange) {
                this.processChange(currentModel, desiredModel, (AddColumnChange)change, ddl);
                changeIt.remove();
                continue;
            }
            if (!(change instanceof ColumnChange)) continue;
            Column column = ((ColumnChange)change).getChangedColumn();
            if (!changedColumns.contains(column)) {
                changedColumns.add(column);
            }
            changeIt.remove();
        }
        for (Column sourceColumn : changedColumns) {
            Column targetColumn = targetTable.findColumn(sourceColumn.getName(), this.delimitedIdentifierModeOn);
            this.processColumnChange(sourceTable, targetTable, sourceColumn, targetColumn, ddl);
        }
        super.processTableStructureChanges(currentModel, desiredModel, sourceTable, targetTable, changes, ddl);
    }

    @Override
    protected void writeExternalForeignKeyCreateStmt(Database database, Table table, ForeignKey key, StringBuilder ddl) {
        if (key.getForeignTableName() == null) {
            this.log.warn("Foreign key table is null for key " + String.valueOf(key));
        } else {
            this.writeTableAlterStmt(table, ddl);
            ddl.append("ADD CONSTRAINT ");
            this.printIdentifier(this.getForeignKeyName(table, key), ddl);
            ddl.append(" FOREIGN KEY (");
            this.writeLocalReferences(key, ddl);
            ddl.append(") REFERENCES ");
            this.printIdentifier(this.getTableName(key.getForeignTableName()), ddl);
            ddl.append(" (");
            this.writeForeignReferences(key, ddl);
            ddl.append(")");
            this.writeCascadeAttributesForForeignKey(key, ddl);
            this.printEndOfStatement(ddl);
        }
    }

    @Override
    protected void writeExternalForeignKeyDropStmt(Table table, ForeignKey foreignKey, StringBuilder ddl) {
        this.writeTableAlterStmt(table, ddl);
        ddl.append("DROP CONSTRAINT ");
        this.printIdentifier(this.getForeignKeyName(table, foreignKey), ddl);
        this.printEndOfStatement(ddl);
    }

    @Override
    public void writeExternalIndexDropStmt(Table table, IIndex index, StringBuilder ddl) {
        this.writeTableAlterStmt(table, ddl);
        ddl.append("DROP INDEX ");
        this.printIdentifier(this.getIndexName(index), ddl);
        ddl.append(" IF EXISTS ");
        this.printEndOfStatement(ddl);
    }

    protected void processChange(Database currentModel, Database desiredModel, AddColumnChange change, StringBuilder ddl) {
        ddl.append("ALTER TABLE ");
        ddl.append(this.getFullyQualifiedTableNameShorten(change.getChangedTable()));
        this.printIndent(ddl);
        ddl.append("ADD COLUMN ");
        this.writeColumn(change.getChangedTable(), change.getNewColumn(), ddl);
        this.printEndOfStatement(ddl);
        change.apply(currentModel, this.delimitedIdentifierModeOn);
    }

    protected void processChange(Database currentModel, Database desiredModel, RemoveColumnChange change, StringBuilder ddl) {
        ddl.append("ALTER TABLE ");
        ddl.append(this.getFullyQualifiedTableNameShorten(change.getChangedTable()));
        this.printIndent(ddl);
        ddl.append("DROP COLUMN ");
        this.printIdentifier(this.getColumnName(change.getColumn()), ddl);
        this.printEndOfStatement(ddl);
        change.apply(currentModel, this.delimitedIdentifierModeOn);
    }

    protected void processChange(Database currentModel, Database desiredModel, ColumnDataTypeChange change, StringBuilder ddl) {
        ddl.append("ALTER TABLE ");
        ddl.append(this.getFullyQualifiedTableNameShorten(change.getChangedTable()));
        this.printIndent(ddl);
        ddl.append("ALTER COLUMN ");
        this.printIdentifier(this.getColumnName(change.getChangedColumn()), ddl);
        ddl.append("TYPE ");
        ddl.append(change.getChangedColumn().getMappedType());
        this.printEndOfStatement(ddl);
        change.apply(currentModel, this.delimitedIdentifierModeOn);
    }

    protected void processColumnChange(Table sourceTable, Table targetTable, Column sourceColumn, Column targetColumn, StringBuilder ddl) {
        ddl.append("ALTER TABLE ");
        ddl.append(this.getFullyQualifiedTableNameShorten(sourceTable));
        this.printIndent(ddl);
        ddl.append("MODIFY COLUMN ");
        boolean autoInc = targetColumn.isAutoIncrement();
        if (autoInc) {
            targetColumn.setAutoIncrement(false);
        }
        this.writeColumn(targetTable, targetColumn, ddl);
        if (autoInc) {
            targetColumn.setAutoIncrement(true);
        }
        this.printEndOfStatement(ddl);
    }

    @Override
    protected void writeColumnNullableStmt(StringBuilder ddl) {
    }

    @Override
    protected void writeCascadeAttributesForForeignKey(ForeignKey key, StringBuilder ddl) {
    }

    @Override
    public String getSqlType(Column column) {
        String[] enumValues;
        PlatformColumn pc;
        String sqlType = super.getSqlType(column);
        if ("ENUM".equalsIgnoreCase(column.getJdbcTypeName()) && (pc = column.getPlatformColumns().get("nuodb")) != null && (enumValues = pc.getEnumValues()) != null && enumValues.length > 0) {
            StringBuilder tmpSqlType = new StringBuilder();
            tmpSqlType.append(column.getJdbcTypeName());
            tmpSqlType.append("(");
            boolean appendComma = false;
            for (String s : enumValues) {
                if (appendComma) {
                    tmpSqlType.append(",");
                }
                tmpSqlType.append("'").append(s).append("'");
                appendComma = true;
            }
            tmpSqlType.append(")");
            sqlType = tmpSqlType.toString();
        }
        return sqlType;
    }
}

