/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.sql.Array;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.io.DatabaseXmlUtil;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.ForeignKey;
import org.jumpmind.db.model.IIndex;
import org.jumpmind.db.model.IndexColumn;
import org.jumpmind.db.model.PlatformColumn;
import org.jumpmind.db.model.Reference;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.model.Transaction;
import org.jumpmind.db.model.Trigger;
import org.jumpmind.db.platform.DatabaseInfo;
import org.jumpmind.db.platform.DatabaseVersion;
import org.jumpmind.db.platform.DmlStatementFactory;
import org.jumpmind.db.platform.IAlterDatabaseInterceptor;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.IDdlBuilder;
import org.jumpmind.db.platform.IDdlReader;
import org.jumpmind.db.platform.PermissionResult;
import org.jumpmind.db.platform.PermissionType;
import org.jumpmind.db.sql.DmlStatement;
import org.jumpmind.db.sql.DmlStatementOptions;
import org.jumpmind.db.sql.ISqlTemplate;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.sql.SqlException;
import org.jumpmind.db.sql.SqlScript;
import org.jumpmind.db.sql.SqlScriptReader;
import org.jumpmind.db.sql.SqlTemplateSettings;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.exception.IoException;
import org.jumpmind.util.FormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDatabasePlatform
implements IDatabasePlatform {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String REQUIRED_FIELD_NULL_SUBSTITUTE = " ";
    public static final String ZERO_DATE_STRING = "0000-00-00 00:00:00";
    protected static final String MODEL_DEFAULT_NAME = "default";
    protected static final String PERMISSION_TEST_TABLE_NAME = "SYM_PERMISSION_TEST";
    protected IDdlReader ddlReader;
    protected IDdlBuilder ddlBuilder;
    protected Map<String, Table> tableCache = Collections.synchronizedMap(new HashMap());
    private long lastTimeCachedModelClearedInMs = System.currentTimeMillis();
    protected long clearCacheModelTimeoutInMs = 3600000L;
    protected String defaultSchema;
    protected String defaultCatalog;
    protected Boolean storesUpperCaseIdentifiers;
    protected Boolean storesLowerCaseIdentifiers;
    protected Boolean storesMixedCaseIdentifiers;
    protected boolean metadataIgnoreCase = true;
    protected boolean useMultiThreadSyncTriggers = true;
    protected SqlTemplateSettings settings;
    protected Boolean supportsTransactions;
    protected Boolean supportsMultiThreadedTransactions;
    protected boolean supportsTruncate = true;
    protected String sourceNodeId;
    protected DatabaseVersion databaseVersion;

    public AbstractDatabasePlatform(SqlTemplateSettings settings) {
        this.settings = settings;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public DatabaseInfo getDatabaseInfo() {
        return this.getDdlBuilder().getDatabaseInfo();
    }

    @Override
    public abstract ISqlTemplate getSqlTemplate();

    @Override
    public abstract ISqlTemplate getSqlTemplateDirty();

    @Override
    public DmlStatement createDmlStatement(DmlStatement.DmlType dmlType, Table table, String textColumnExpression) {
        return this.createDmlStatement(dmlType, table.getCatalog(), table.getSchema(), table.getName(), table.getPrimaryKeyColumns(), table.getColumns(), null, textColumnExpression);
    }

    @Override
    public DmlStatement createDmlStatement(DmlStatement.DmlType dmlType, String catalogName, String schemaName, String tableName, Column[] keys, Column[] columns, boolean[] nullKeyValues, String textColumnExpression) {
        return this.createDmlStatement(dmlType, catalogName, schemaName, tableName, keys, columns, nullKeyValues, textColumnExpression, false);
    }

    @Override
    public DmlStatement createDmlStatement(DmlStatement.DmlType dmlType, String catalogName, String schemaName, String tableName, Column[] keys, Column[] columns, boolean[] nullKeyValues, String textColumnExpression, boolean namedParameters) {
        DmlStatementOptions options = new DmlStatementOptions(dmlType, tableName).databaseInfo(this.getDatabaseInfo()).catalogName(catalogName).schemaName(schemaName).columns(columns).keys(keys).nullKeyValues(nullKeyValues).quotedIdentifiers(this.getDdlBuilder().isDelimitedIdentifierModeOn()).textColumnExpression(textColumnExpression).namedParameters(namedParameters);
        return this.createDmlStatement(options);
    }

    @Override
    public DmlStatement createDmlStatement(DmlStatementOptions options) {
        return DmlStatementFactory.getInstance().create(this.getName(), options);
    }

    @Override
    public IDdlReader getDdlReader() {
        return this.ddlReader;
    }

    @Override
    public IDdlBuilder getDdlBuilder() {
        return this.ddlBuilder;
    }

    @Override
    public void setClearCacheModelTimeoutInMs(long clearCacheModelTimeoutInMs) {
        this.clearCacheModelTimeoutInMs = clearCacheModelTimeoutInMs;
    }

    @Override
    public long getClearCacheModelTimeoutInMs() {
        return this.clearCacheModelTimeoutInMs;
    }

    @Override
    public void dropTables(boolean continueOnError, Table ... tables) {
        Database db = new Database();
        for (Table table : tables) {
            db.addTable(table);
        }
        this.dropDatabase(db, continueOnError);
    }

    @Override
    public void dropDatabase(Database database, boolean continueOnError) {
        String sql = this.ddlBuilder.dropTables(database);
        new SqlScript(sql, this.getSqlTemplate(), !continueOnError, null).execute(this.getDatabaseInfo().isRequiresAutoCommitForDdl());
    }

    @Override
    public void createTables(boolean dropTablesFirst, boolean continueOnError, Table ... tables) {
        Database database = new Database();
        database.addTables(tables);
        this.createDatabase(database, dropTablesFirst, continueOnError);
    }

    @Override
    public void createDatabase(Database targetDatabase, boolean dropTablesFirst, boolean continueOnError) {
        if (dropTablesFirst) {
            this.dropDatabase(targetDatabase, true);
        }
        String createSql = this.ddlBuilder.createTables(targetDatabase, false);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Generated create sql: \n{}", (Object)createSql);
        }
        String delimiter = this.getDdlBuilder().getDatabaseInfo().getSqlCommandDelimiter();
        new SqlScript(createSql, this.getSqlTemplate(), !continueOnError, false, false, this.getDatabaseInfo().isTriggersContainJava(), delimiter, null).execute(this.getDatabaseInfo().isRequiresAutoCommitForDdl());
    }

    @Override
    public void alterDatabase(Database desiredDatabase, String triggerPrefix, boolean continueOnError, IAlterDatabaseInterceptor[] interceptors) {
        this.alterTables(continueOnError, false, triggerPrefix, interceptors, desiredDatabase.getTables());
    }

    @Override
    public void alterDatabase(Database desiredDatabase, String triggerPrefix, boolean continueOnError) {
        this.alterDatabase(desiredDatabase, triggerPrefix, continueOnError, null);
    }

    @Override
    public void alterTables(boolean continueOnError, Table ... desiredTables) {
        this.alterTables(continueOnError, false, null, null, desiredTables);
    }

    @Override
    public void alterTables(boolean continueOnError, boolean createTableIncludeApplicationTriggers, String triggerPrefix, IAlterDatabaseInterceptor[] interceptors, Table ... desiredTables) {
        String alterSql;
        Database currentDatabase = new Database();
        currentDatabase.setName(this.getName());
        Database desiredDatabase = new Database();
        desiredDatabase.setName(this.getName());
        StringBuilder tablesProcessed = new StringBuilder();
        for (Table table : desiredTables) {
            List<Trigger> triggers;
            tablesProcessed.append(table.getFullyQualifiedTableName());
            tablesProcessed.append(", ");
            desiredDatabase.addTable(table);
            Table currentTable = this.ddlReader.readTable(table.getCatalog(), table.getSchema(), table.getName());
            if (currentTable == null) continue;
            if (createTableIncludeApplicationTriggers && (triggers = this.ddlReader.getApplicationTriggersForModel(table.getCatalog(), table.getSchema(), table.getName(), triggerPrefix)) != null && triggers.size() > 0) {
                currentTable.addTriggers(triggers);
            }
            currentDatabase.addTable(currentTable);
        }
        if (tablesProcessed.length() > 1) {
            tablesProcessed.replace(tablesProcessed.length() - 2, tablesProcessed.length(), "");
        }
        if (StringUtils.isNotBlank((CharSequence)(alterSql = this.ddlBuilder.alterDatabase(currentDatabase, desiredDatabase, interceptors)).trim())) {
            String delimiter = this.getDdlBuilder().getDatabaseInfo().getSqlCommandDelimiter();
            HashMap<String, String> replacementTokens = new HashMap<String, String>();
            replacementTokens.put(this.ddlBuilder.getTriggerDelimiterReplacementCharacters(), this.getDdlBuilder().getDatabaseInfo().getSqlCommandDelimiter());
            this.log.info("Running alter sql:\n{}", (Object)this.getAlterSql(alterSql, createTableIncludeApplicationTriggers, replacementTokens, delimiter));
            new SqlScript(alterSql, this.getSqlTemplate(), !continueOnError, false, false, delimiter, replacementTokens).execute(this.getDatabaseInfo().isRequiresAutoCommitForDdl());
        } else {
            this.log.info("Tables up to date.  No alters found for {}", (Object)tablesProcessed);
        }
    }

    private String getAlterSql(String alterSql, boolean replaceTokens, Map<String, String> replacementTokens, String delimiter) {
        if (replaceTokens) {
            StringBuilder ddl = new StringBuilder();
            SqlScriptReader reader = new SqlScriptReader(new StringReader(alterSql));
            reader.setDelimiter(this.getDdlBuilder().getDatabaseInfo().getSqlCommandDelimiter());
            reader.setReplacementTokens(replacementTokens);
            String statement = reader.readSqlStatement();
            while (statement != null) {
                ddl.append(statement).append(delimiter).append(System.lineSeparator());
                statement = reader.readSqlStatement();
            }
            return ddl.toString();
        }
        return alterSql;
    }

    @Override
    public Database readDatabase(String catalog, String schema, String[] tableTypes) {
        Database model = this.ddlReader.readTables(catalog, schema, tableTypes);
        if (model.getName() == null || model.getName().length() == 0) {
            model.setName(MODEL_DEFAULT_NAME);
        }
        return model;
    }

    @Override
    public Database readFromDatabase(Table ... tables) {
        Database fromDb = new Database();
        for (Table tableFromXml : tables) {
            Table tableFromDatabase = this.getTableFromCache(tableFromXml.getCatalog(), tableFromXml.getSchema(), tableFromXml.getName(), true);
            if (tableFromDatabase == null) continue;
            fromDb.addTable(tableFromDatabase);
        }
        fromDb.initialize();
        return fromDb;
    }

    @Override
    public Table readTableFromDatabase(String catalogName, String schemaName, String tableName) {
        try {
            return this.readTableFromDatabaseAllowException(catalogName, schemaName, tableName);
        }
        catch (Exception e) {
            if (this.getSqlTemplate().isDeadlock(e)) {
                this.log.warn("Deadlock occurred while reading {}, so retrying", (Object)tableName);
                return this.readTableFromDatabaseAllowException(catalogName, schemaName, tableName);
            }
            throw e;
        }
    }

    protected Table readTableFromDatabaseAllowException(String catalogName, String schemaName, String tableName) {
        String defaultedSchemaName;
        String originalFullyQualifiedName = Table.getFullyQualifiedTableName(catalogName, schemaName, tableName);
        String defaultedCatalogName = catalogName == null ? this.getDefaultCatalog() : catalogName;
        Table table = this.ddlReader.readTable(defaultedCatalogName, defaultedSchemaName = schemaName == null ? this.getDefaultSchema() : schemaName, tableName);
        if (table == null && this.metadataIgnoreCase) {
            List<String> tableNames;
            List<String> schemaNames;
            List<String> catalogNames;
            IDdlReader reader = this.getDdlReader();
            if (StringUtils.isNotBlank((CharSequence)catalogName) && (catalogNames = reader.getCatalogNames()) != null) {
                for (String name : catalogNames) {
                    if (name == null || !name.equalsIgnoreCase(catalogName)) continue;
                    defaultedCatalogName = name;
                    break;
                }
            }
            if (StringUtils.isNotBlank((CharSequence)schemaName) && (schemaNames = reader.getSchemaNames(catalogName)) != null) {
                for (String name : schemaNames) {
                    if (name == null || !name.equalsIgnoreCase(schemaName)) continue;
                    defaultedSchemaName = name;
                    break;
                }
            }
            if ((tableNames = reader.getTableNames(defaultedCatalogName, defaultedSchemaName, null)) != null) {
                for (String name : tableNames) {
                    if (name == null || !name.equalsIgnoreCase(tableName)) continue;
                    tableName = name;
                    break;
                }
            }
            if (!originalFullyQualifiedName.equals(Table.getFullyQualifiedTableName(defaultedCatalogName, defaultedSchemaName, tableName))) {
                table = this.ddlReader.readTable(defaultedCatalogName, defaultedSchemaName, tableName);
            }
        }
        if (table != null && this.log.isDebugEnabled()) {
            this.log.debug("Just read table: \n{}", (Object)table.toVerboseString());
        }
        return table;
    }

    @Override
    public Table readTableFromDatabase(ISqlTransaction transaction, String catalogName, String schemaName, String tableName) {
        String defaultedCatalogName = catalogName == null ? this.getDefaultCatalog() : catalogName;
        String defaultedSchemaName = schemaName == null ? this.getDefaultSchema() : schemaName;
        Table table = this.ddlReader.readTable(transaction, defaultedCatalogName, defaultedSchemaName, tableName);
        if (table == null && this.metadataIgnoreCase && (table = this.ddlReader.readTable(transaction, StringUtils.toRootUpperCase((String)defaultedCatalogName), StringUtils.toRootUpperCase((String)defaultedSchemaName), tableName.toUpperCase())) == null) {
            table = this.ddlReader.readTable(transaction, StringUtils.toRootLowerCase((String)defaultedCatalogName), StringUtils.toRootLowerCase((String)defaultedSchemaName), tableName.toUpperCase());
        }
        return table;
    }

    @Override
    public void resetCachedTableModel() {
        this.resetCachedTableModel(true);
    }

    protected void resetCachedTableModel(boolean clearTableNameCache) {
        this.tableCache = Collections.synchronizedMap(new HashMap());
        this.lastTimeCachedModelClearedInMs = System.currentTimeMillis();
    }

    @Override
    public Table getTableFromCache(String tableName, boolean forceReread) {
        return this.getTableFromCache(this.getDefaultCatalog(), this.getDefaultSchema(), tableName, forceReread);
    }

    @Override
    public Table getTableFromCache(String catalogName, String schemaName, String tableName, boolean forceReread) {
        Table retTable;
        if (System.currentTimeMillis() - this.lastTimeCachedModelClearedInMs > this.clearCacheModelTimeoutInMs) {
            this.resetCachedTableModel(false);
        }
        Map<String, Table> model = this.tableCache;
        String key = Table.getFullyQualifiedTableName(catalogName, schemaName, tableName);
        Table table = retTable = model != null ? model.get(key) : null;
        if (retTable == null || forceReread) {
            try {
                Table table2 = this.readTableFromDatabase(catalogName, schemaName, tableName);
                this.tableCache.put(key, table2);
                retTable = table2;
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return retTable;
    }

    @Override
    public Object[] getObjectValues(BinaryEncoding encoding, Table table, String[] columnNames, String[] values) {
        Column[] metaData = Table.orderColumns(columnNames, table, false);
        return this.getObjectValues(encoding, values, metaData);
    }

    @Override
    public Object[] getObjectValues(BinaryEncoding encoding, Table table, String[] columnNames, String[] values, boolean useVariableDates, boolean fitToColumn) {
        Column[] metaData = Table.orderColumns(columnNames, table, false);
        return this.getObjectValues(encoding, values, metaData, useVariableDates, fitToColumn);
    }

    @Override
    public Object[] getObjectValues(BinaryEncoding encoding, String[] values, Column[] orderedMetaData) {
        return this.getObjectValues(encoding, values, orderedMetaData, false, false);
    }

    @Override
    public Object[] getObjectValues(BinaryEncoding encoding, String[] values, Column[] orderedMetaData, boolean useVariableDates, boolean fitToColumn) {
        if (values != null) {
            ArrayList<Object> list = new ArrayList<Object>(values.length);
            for (int i = 0; i < values.length; ++i) {
                String value = values[i];
                Column column = orderedMetaData.length > i ? orderedMetaData[i] : null;
                try {
                    if (column == null) continue;
                    list.add(this.getObjectValue(value, column, encoding, useVariableDates, fitToColumn));
                    continue;
                }
                catch (Exception ex) {
                    String valueTrimmed = FormatUtils.abbreviateForLogging((String)value);
                    throw new RuntimeException("Could not convert a value of " + valueTrimmed + " for column " + column.getName() + " of mapped type " + column.getMappedType() + " jdbc type " + column.getJdbcTypeName() + " (" + column.getJdbcTypeCode() + ")", ex);
                }
            }
            return list.toArray();
        }
        return null;
    }

    protected Object getObjectValue(String value, Column column, BinaryEncoding encoding, boolean useVariableDates, boolean fitToColumn) throws DecoderException {
        Object objectValue = value;
        int type = column.getMappedTypeCode();
        if ((value == null || this.getDdlBuilder().getDatabaseInfo().isEmptyStringNulled() && value.equals("")) && column.isRequired() && column.isOfTextType()) {
            objectValue = REQUIRED_FIELD_NULL_SUBSTITUTE;
        }
        if (value != null) {
            if (type == 91 || type == 93 || type == 92) {
                objectValue = this.parseDate(type, value, useVariableDates);
            } else if (type == 1) {
                if (StringUtils.isBlank((CharSequence)value) && this.getDdlBuilder().getDatabaseInfo().isBlankCharColumnSpacePadded() || StringUtils.isNotBlank((CharSequence)value) && this.getDdlBuilder().getDatabaseInfo().isNonBlankCharColumnSpacePadded()) {
                    objectValue = column.getSizeAsInt() != column.getCharOctetLength() ? StringUtils.rightPad((String)value, (int)column.getSizeAsInt(), (char)' ') : value + StringUtils.repeat((String)REQUIRED_FIELD_NULL_SUBSTITUTE, (int)(column.getCharOctetLength() - value.getBytes(Charset.defaultCharset()).length));
                } else if (this.getDdlBuilder().getDatabaseInfo().isCharColumnSpaceTrimmed()) {
                    objectValue = StringUtils.stripEnd((String)value, (String)REQUIRED_FIELD_NULL_SUBSTITUTE);
                }
            } else if (type == -5) {
                objectValue = this.parseBigInteger(value);
            } else if (type == 4 || type == 5 || type == -7 || type == -6) {
                objectValue = this.parseInteger(value);
            } else if (type == 6) {
                objectValue = this.parseFloat(value);
            } else if (type == 2 || type == 3 || type == 8 || type == 7) {
                objectValue = this.parseBigDecimal(value);
            } else if (type == 16) {
                objectValue = this.parseBoolean(value);
            } else if (!(column.getJdbcTypeName() != null && FormatUtils.upper((String)column.getJdbcTypeName()).contains("GEOMETRY") || column.getJdbcTypeName() != null && FormatUtils.upper((String)column.getJdbcTypeName()).contains("GEOGRAPHY") || type != 2004 && type != -4 && type != -2 && type != -3 && type != -10)) {
                if (encoding == BinaryEncoding.NONE) {
                    objectValue = value.getBytes(Charset.defaultCharset());
                } else if (encoding == BinaryEncoding.BASE64) {
                    objectValue = Base64.decodeBase64((byte[])value.getBytes(Charset.defaultCharset()));
                } else if (encoding == BinaryEncoding.HEX) {
                    objectValue = Hex.decodeHex((char[])value.toCharArray());
                }
            } else if (type == 2003) {
                objectValue = this.createArray(column, value);
            } else if (type == -150) {
                objectValue = this.parseSqlVariant(value);
            }
        }
        if (objectValue instanceof String) {
            String stringValue = this.cleanTextForTextBasedColumns((String)objectValue);
            int size = column.getSizeAsInt();
            if (this.settings.isRightTrimCharValues()) {
                stringValue = StringUtils.stripEnd((String)stringValue, null);
            }
            if (fitToColumn && size > 0 && stringValue.length() > size) {
                stringValue = stringValue.substring(0, size);
            }
            objectValue = stringValue;
        }
        return objectValue;
    }

    protected Object parseFloat(String value) {
        return this.parseBigDecimal(value);
    }

    protected Object parseBigDecimal(String value) {
        if ((value = this.cleanNumber(value)) != null && value.equals("NaN")) {
            return value;
        }
        return new BigDecimal(value.replace(',', '.'));
    }

    protected Object parseBigInteger(String value) {
        try {
            value = this.cleanNumber(value);
            return Long.valueOf(value.trim());
        }
        catch (NumberFormatException ex) {
            return new BigDecimal(value.replace(',', '.')).toBigInteger();
        }
    }

    protected Object parseInteger(String value) {
        try {
            value = this.cleanNumber(value);
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            return new BigInteger(value);
        }
    }

    protected Object parseBoolean(String value) {
        return (value = this.cleanNumber(value)).equals("1") ? Boolean.TRUE : Boolean.FALSE;
    }

    protected Object parseSqlVariant(String value) throws DecoderException {
        Object ret = value;
        String[] fields = value.split("\\|");
        if (fields.length == 4) {
            String type = fields[1];
            String localValue = fields[0];
            if ("int".equalsIgnoreCase(type)) {
                ret = this.parseInteger(localValue);
            } else if ("real".equalsIgnoreCase(type)) {
                ret = this.parseFloat(localValue);
            } else if ("decimal".equalsIgnoreCase(type)) {
                ret = this.parseBigDecimal(localValue);
            } else if ("money".equalsIgnoreCase(type)) {
                ret = this.parseBigDecimal(localValue);
            } else if ("smallmoney".equalsIgnoreCase(type)) {
                ret = this.parseBigDecimal(localValue);
            } else if ("bigint".equalsIgnoreCase(type)) {
                ret = this.parseBigInteger(localValue);
            } else if ("smallint".equalsIgnoreCase(type)) {
                ret = this.parseInteger(localValue);
            } else if ("tinyint".equalsIgnoreCase(type)) {
                ret = this.parseInteger(localValue);
            } else if ("bit".equalsIgnoreCase(type)) {
                ret = this.parseInteger(localValue);
            } else if ("nvarchar".equalsIgnoreCase(type)) {
                ret = localValue;
            } else if ("varchar".equalsIgnoreCase(type)) {
                ret = localValue;
            } else if ("nchar".equalsIgnoreCase(type)) {
                ret = localValue;
            } else if ("char".equalsIgnoreCase(type)) {
                ret = localValue;
            } else if ("varbinary".equalsIgnoreCase(type)) {
                ret = localValue.getBytes(Charset.defaultCharset());
            } else if ("binary".equalsIgnoreCase(type)) {
                ret = localValue.getBytes(Charset.defaultCharset());
            } else if ("uniqueidentifier".equalsIgnoreCase(type)) {
                ret = localValue;
            } else if ("datetime2".equalsIgnoreCase(type)) {
                ret = this.parseDate(93, localValue, false);
            } else if ("datetimeoffset".equalsIgnoreCase(type)) {
                ret = this.parseDate(93, localValue, false);
            } else if ("datetime".equalsIgnoreCase(type)) {
                ret = this.parseDate(93, localValue, false);
            } else if ("smalldatetime".equalsIgnoreCase(type)) {
                ret = this.parseDate(93, localValue, false);
            } else if ("date".equalsIgnoreCase(type)) {
                ret = this.parseDate(91, localValue, false);
            } else if ("time".equalsIgnoreCase(type)) {
                ret = this.parseDate(92, localValue, false);
            } else if ("float".equalsIgnoreCase(type)) {
                ret = this.parseFloat(localValue);
            }
        }
        return ret;
    }

    protected String cleanNumber(String value) {
        if ((value = value.trim()).equalsIgnoreCase("true")) {
            return "1";
        }
        if (value.equalsIgnoreCase("false")) {
            return "0";
        }
        return value;
    }

    @Override
    public String[] getStringValues(BinaryEncoding encoding, Column[] metaData, Row row, boolean useVariableDates, boolean indexByPosition) {
        String[] values = new String[metaData.length];
        Set keys = row.keySet();
        int i = 0;
        for (String key : keys) {
            Column column = metaData[i];
            String name = indexByPosition ? key : column.getName();
            int type = column.getJdbcTypeCode();
            if (row.get(name) != null) {
                if (type == 16 || type == -7) {
                    values[i] = row.getBoolean(name) ? "1" : "0";
                } else if (column.isOfNumericType()) {
                    values[i] = row.getString(name);
                } else if (!(column.isTimestampWithTimezone() || type != 91 && type != 92)) {
                    values[i] = this.getDateTimeStringValue(name, type, row, useVariableDates);
                } else if (!column.isTimestampWithTimezone() && type == 93) {
                    values[i] = this.getTimestampStringValue(name, type, row, useVariableDates);
                } else if (column.isOfBinaryType()) {
                    byte[] bytes = row.getBytes(name);
                    if (encoding == BinaryEncoding.NONE) {
                        values[i] = row.getString(name);
                    } else if (encoding == BinaryEncoding.BASE64) {
                        values[i] = new String(Base64.encodeBase64((byte[])bytes), Charset.defaultCharset());
                    } else if (encoding == BinaryEncoding.HEX) {
                        values[i] = new String(Hex.encodeHex((byte[])bytes));
                    }
                } else {
                    values[i] = row.getString(name);
                }
            }
            ++i;
        }
        return values;
    }

    @Override
    public String getCsvStringValue(BinaryEncoding encoding, Column[] metaData, Row row, boolean[] isColumnPositionUsingTemplate) {
        StringBuilder concatenatedRow = new StringBuilder();
        Set names = row.keySet();
        int i = 0;
        for (String name : names) {
            Column column = metaData[i];
            int type = column.getJdbcTypeCode();
            if (i > 0) {
                concatenatedRow.append(",");
            }
            if (row.get(name) != null) {
                if (isColumnPositionUsingTemplate[i]) {
                    concatenatedRow.append(row.getString(name));
                } else if (type == 16 || type == -7) {
                    concatenatedRow.append(row.getBoolean(name) ? "1" : "0");
                } else if (column.isOfNumericType()) {
                    concatenatedRow.append(row.getString(name));
                } else if (column.isTimestampWithTimezone()) {
                    this.appendString(concatenatedRow, this.getTimestampTzStringValue(name, type, row, false));
                } else if (type == 91 || type == 92) {
                    this.appendString(concatenatedRow, this.getDateTimeStringValue(name, type, row, false));
                } else if (type == 93) {
                    this.appendString(concatenatedRow, this.getTimestampStringValue(name, type, row, false));
                } else if (column.isOfBinaryType()) {
                    byte[] bytes = row.getBytes(name);
                    if (bytes.length == 0) {
                        concatenatedRow.append("\"\"");
                    } else if (encoding == BinaryEncoding.NONE) {
                        concatenatedRow.append(row.getString(name));
                    } else if (encoding == BinaryEncoding.BASE64) {
                        concatenatedRow.append(new String(Base64.encodeBase64((byte[])bytes), Charset.defaultCharset()));
                    } else if (encoding == BinaryEncoding.HEX) {
                        concatenatedRow.append(new String(Hex.encodeHex((byte[])bytes)));
                    }
                } else {
                    concatenatedRow.append("\"").append(row.getString(name).replace("\\", "\\\\").replace("\"", "\\\"")).append("\"");
                }
            }
            ++i;
        }
        return concatenatedRow.toString();
    }

    protected void appendString(StringBuilder sb, String value) {
        if (value != null) {
            sb.append("\"").append(value).append("\"");
        }
    }

    protected String getDateTimeStringValue(String name, int type, Row row, boolean useVariableDates) {
        Object dateObj = row.get(name);
        if (dateObj instanceof String) {
            return (String)dateObj;
        }
        Date date = row.getDateTime(name);
        if (useVariableDates) {
            long diff = date.getTime() - System.currentTimeMillis();
            return "${curdate" + diff + "}";
        }
        return FormatUtils.TIMESTAMP_FORMATTER.format(date);
    }

    protected String getTimestampStringValue(String name, int type, Row row, boolean useVariableDates) {
        Object tsObj = row.get(name);
        if (tsObj instanceof String) {
            return (String)tsObj;
        }
        Timestamp ts = row.getTimestamp(name);
        if (useVariableDates) {
            long diff = ts.getTime() - System.currentTimeMillis();
            return "${ts" + diff + "}";
        }
        Object formattedDate = StringUtils.stripEnd((String)String.format("%tF %tT.%09d", ts, ts, ts.getNanos()), (String)"0");
        if (((String)formattedDate).endsWith(".")) {
            formattedDate = (String)formattedDate + "0";
        }
        return formattedDate;
    }

    protected String getTimestampTzStringValue(String name, int type, Row row, boolean useVariableDates) {
        return row.getString(name);
    }

    @Override
    public Map<String, String> getSqlScriptReplacementTokens() {
        return null;
    }

    @Override
    public String scrubSql(String sql) {
        Map<String, String> replacementTokens = this.getSqlScriptReplacementTokens();
        if (replacementTokens != null) {
            return FormatUtils.replaceTokens((String)sql, replacementTokens, (boolean)false);
        }
        return sql;
    }

    protected Array createArray(Column column, String value) {
        return null;
    }

    protected String cleanTextForTextBasedColumns(String text) {
        return text;
    }

    @Override
    public Date parseDate(int type, String value, boolean useVariableDates) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            try {
                boolean useTimestamp;
                boolean bl = useTimestamp = type == 93 || type == 91 && this.getDdlBuilder().getDatabaseInfo().isDateOverridesToTimestamp();
                if (useVariableDates && value.startsWith("${curdate")) {
                    long time = Long.parseLong(value.substring(10, value.length() - 1));
                    if (value.substring(9, 10).equals("-")) {
                        time *= -1L;
                    }
                    time += System.currentTimeMillis();
                    if (useTimestamp) {
                        return new Timestamp(time);
                    }
                    return new Date(time);
                }
                if (useTimestamp) {
                    return this.parseTimestamp(type, value);
                }
                if (type == 92) {
                    if (value.indexOf(".") == 8 || value.length() <= 8) {
                        return Timestamp.valueOf("1970-01-01 " + value);
                    }
                    return Timestamp.valueOf(value);
                }
                return FormatUtils.parseDate((String)value, (String[])FormatUtils.TIMESTAMP_PATTERNS);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Override
    public Map<String, String> parseQualifiedTableName(String tableName) {
        LinkedHashMap<String, String> tableNameParts = new LinkedHashMap<String, String>();
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            return tableNameParts;
        }
        String[] initialSplit = tableName.split(Pattern.quote(this.getDatabaseInfo().getCatalogSeparator()));
        if (initialSplit.length == 0) {
            initialSplit = new String[]{tableName};
        }
        ArrayList<String> nameComponents = new ArrayList<String>();
        for (String part : initialSplit) {
            String[] subParts = part.split(Pattern.quote(this.getDatabaseInfo().getSchemaSeparator()));
            if (subParts.length == 0) {
                subParts = new String[]{part};
            }
            for (String subPart : subParts) {
                if (StringUtils.isEmpty((CharSequence)subPart)) continue;
                nameComponents.add(subPart);
            }
        }
        if (nameComponents.size() >= 3) {
            tableNameParts.put("catalog", (String)nameComponents.get(0));
            tableNameParts.put("schema", (String)nameComponents.get(1));
            tableNameParts.put("table", (String)nameComponents.get(2));
        } else if (nameComponents.size() == 2) {
            tableNameParts.put("schema", (String)nameComponents.get(0));
            tableNameParts.put("table", (String)nameComponents.get(1));
        } else {
            tableNameParts.put("table", (String)nameComponents.get(0));
        }
        return tableNameParts;
    }

    @Override
    public Table makeAllColumnsPrimaryKeys(Table table) {
        Table result = table.copy();
        IIndex[] indices = result.getUniqueIndices();
        if (indices != null && indices.length > 0) {
            for (IndexColumn indexColumn : indices[0].getColumns()) {
                Column column = result.getColumnWithName(indexColumn.getName());
                if (column == null) continue;
                boolean required = column.isRequired();
                column.setPrimaryKey(true);
                column.setRequired(required);
            }
        } else {
            for (Column column : result.getColumns()) {
                if (this.isLob(column) || !this.canColumnBeUsedInWhereClause(column)) continue;
                column.setPrimaryKey(true);
            }
            result.setMadeAllColumnsPrimaryKey(true);
        }
        return result;
    }

    @Override
    public boolean isLob(Column column) {
        return this.isClob(column) || this.isBlob(column);
    }

    @Override
    public boolean isClob(Column column) {
        int type = column.getMappedTypeCode();
        return type == 2005 || type == 2011 || type == -1 || type == -16;
    }

    @Override
    public boolean isBlob(Column column) {
        int type = column.getMappedTypeCode();
        if (this.settings.isTreatBinaryAsLob()) {
            return type == 2004 || type == -2 || type == -3 || type == -4 || type == -10;
        }
        return type == 2004 || type == -4 || type == -10;
    }

    @Override
    public List<Column> getLobColumns(Table table) {
        Column[] allColumns;
        ArrayList<Column> lobColumns = new ArrayList<Column>(1);
        for (Column column : allColumns = table.getColumns()) {
            if (!this.isLob(column)) continue;
            lobColumns.add(column);
        }
        return lobColumns;
    }

    @Override
    public void setMetadataIgnoreCase(boolean metadataIgnoreCase) {
        this.metadataIgnoreCase = metadataIgnoreCase;
    }

    @Override
    public boolean isMetadataIgnoreCase() {
        return this.metadataIgnoreCase;
    }

    @Override
    public boolean isStoresLowerCaseIdentifiers() {
        if (this.storesLowerCaseIdentifiers == null) {
            this.storesLowerCaseIdentifiers = this.getSqlTemplate().isStoresLowerCaseIdentifiers();
        }
        return this.storesLowerCaseIdentifiers;
    }

    @Override
    public boolean isStoresMixedCaseQuotedIdentifiers() {
        if (this.storesMixedCaseIdentifiers == null) {
            this.storesMixedCaseIdentifiers = this.getSqlTemplate().isStoresMixedCaseQuotedIdentifiers();
        }
        return this.storesMixedCaseIdentifiers;
    }

    @Override
    public boolean isStoresUpperCaseIdentifiers() {
        if (this.storesUpperCaseIdentifiers == null) {
            this.storesUpperCaseIdentifiers = this.getSqlTemplate().isStoresUpperCaseIdentifiers();
        }
        return this.storesUpperCaseIdentifiers;
    }

    @Override
    public Database readDatabaseFromXml(String filePath, boolean alterCaseToMatchDatabaseDefaultCase) {
        InputStream is = null;
        try {
            File file = new File(filePath);
            if (file.exists()) {
                try {
                    is = new FileInputStream(file);
                }
                catch (FileNotFoundException e) {
                    throw new IoException((Exception)e);
                }
            } else {
                is = AbstractDatabasePlatform.class.getResourceAsStream(filePath);
            }
            if (is != null) {
                Database database = this.readDatabaseFromXml(is, alterCaseToMatchDatabaseDefaultCase);
                return database;
            }
            throw new IoException("Could not find the file: %s", new Object[]{filePath});
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void prefixDatabase(String prefix, Database targetTables) {
        try {
            if (StringUtils.isNotBlank((CharSequence)prefix) && !((String)prefix).endsWith("_")) {
                prefix = (String)prefix + "_";
            }
            Table[] tables = targetTables.getTables();
            boolean storesUpperCaseIdentifiers = this.isStoresUpperCaseIdentifiers();
            for (Table table : tables) {
                String name = String.format("%s%s", prefix, table.getName());
                table.setName(storesUpperCaseIdentifiers ? FormatUtils.upper((String)name) : FormatUtils.lower((String)name));
                this.prefixForeignKeys(table, (String)prefix, storesUpperCaseIdentifiers);
                this.prefixIndexes(table, (String)prefix, storesUpperCaseIdentifiers);
                this.prefixColumnNames(table, storesUpperCaseIdentifiers);
            }
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    protected void prefixColumnNames(Table table, boolean storesUpperCaseIdentifiers) {
        Column[] columns;
        for (Column column : columns = table.getColumns()) {
            column.setName(storesUpperCaseIdentifiers ? FormatUtils.upper((String)column.getName()) : FormatUtils.lower((String)column.getName()));
        }
    }

    protected void prefixForeignKeys(Table table, String tablePrefix, boolean storesUpperCaseIdentifiers) throws CloneNotSupportedException {
        ForeignKey[] keys;
        for (ForeignKey key : keys = table.getForeignKeys()) {
            Reference[] refs;
            Object prefixedName = tablePrefix + key.getForeignTableName();
            prefixedName = storesUpperCaseIdentifiers ? FormatUtils.upper((String)prefixedName) : FormatUtils.lower((String)prefixedName);
            key.setForeignTableName((String)prefixedName);
            Object keyName = tablePrefix + key.getName();
            keyName = storesUpperCaseIdentifiers ? FormatUtils.upper((String)keyName) : FormatUtils.lower((String)keyName);
            key.setName((String)keyName);
            for (Reference reference : refs = key.getReferences()) {
                reference.setForeignColumnName(storesUpperCaseIdentifiers ? FormatUtils.upper((String)reference.getForeignColumnName()) : FormatUtils.lower((String)reference.getForeignColumnName()));
                reference.setLocalColumnName(storesUpperCaseIdentifiers ? FormatUtils.upper((String)reference.getLocalColumnName()) : FormatUtils.lower((String)reference.getLocalColumnName()));
            }
        }
    }

    protected void prefixIndexes(Table table, String tablePrefix, boolean storesUpperCaseIdentifiers) throws CloneNotSupportedException {
        IIndex[] indexes = table.getIndices();
        if (indexes != null) {
            for (IIndex index : indexes) {
                Object prefixedName = tablePrefix + index.getName();
                prefixedName = storesUpperCaseIdentifiers ? FormatUtils.upper((String)prefixedName) : FormatUtils.lower((String)prefixedName);
                index.setName((String)prefixedName);
            }
        }
    }

    @Override
    public void alterCaseToMatchDatabaseDefaultCase(Database database) {
        Table[] tables;
        for (Table table : tables = database.getTables()) {
            this.alterCaseToMatchDatabaseDefaultCase(table);
        }
    }

    @Override
    public String[] alterCaseToMatchDatabaseDefaultCase(String[] values) {
        String[] newValues = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            newValues[i] = this.alterCaseToMatchDatabaseDefaultCase(values[i]);
        }
        return newValues;
    }

    @Override
    public String alterCaseToMatchDatabaseDefaultCase(String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            boolean storesUpperCase = this.isStoresUpperCaseIdentifiers();
            if (!FormatUtils.isMixedCase((String)value)) {
                value = storesUpperCase ? FormatUtils.upper((String)value) : FormatUtils.lower((String)value);
            }
        }
        return value;
    }

    @Override
    public void alterCaseToMatchDatabaseDefaultCase(Table ... tables) {
        for (Table table : tables) {
            this.alterCaseToMatchDatabaseDefaultCase(table);
        }
    }

    @Override
    public void alterCaseToMatchDatabaseDefaultCase(Table table) {
        ForeignKey[] fks;
        IIndex[] indexes;
        Column[] columns;
        table.setName(this.alterCaseToMatchDatabaseDefaultCase(table.getName()));
        for (Column column : columns = table.getColumns()) {
            column.setName(this.alterCaseToMatchDatabaseDefaultCase(column.getName()));
        }
        for (IIndex index : indexes = table.getIndices()) {
            IndexColumn[] indexColumns;
            index.setName(this.alterCaseToMatchDatabaseDefaultCase(index.getName()));
            for (IndexColumn indexColumn : indexColumns = index.getColumns()) {
                indexColumn.setName(this.alterCaseToMatchDatabaseDefaultCase(indexColumn.getName()));
            }
        }
        for (ForeignKey foreignKey : fks = table.getForeignKeys()) {
            Reference[] references;
            foreignKey.setName(this.alterCaseToMatchDatabaseDefaultCase(foreignKey.getName()));
            foreignKey.setForeignTableName(this.alterCaseToMatchDatabaseDefaultCase(foreignKey.getForeignTableName()));
            for (Reference reference : references = foreignKey.getReferences()) {
                reference.setForeignColumnName(this.alterCaseToMatchDatabaseDefaultCase(reference.getForeignColumnName()));
                reference.setLocalColumnName(this.alterCaseToMatchDatabaseDefaultCase(reference.getLocalColumnName()));
            }
        }
    }

    @Override
    public Database readDatabaseFromXml(InputStream is, boolean alterCaseToMatchDatabaseDefaultCase) {
        InputStreamReader reader = new InputStreamReader(is);
        Database database = DatabaseXmlUtil.read(reader);
        if (alterCaseToMatchDatabaseDefaultCase) {
            this.alterCaseToMatchDatabaseDefaultCase(database);
        }
        return database;
    }

    @Override
    public boolean canColumnBeUsedInWhereClause(Column column) {
        return column.getJdbcTypeCode() != 6 && column.getJdbcTypeCode() != 8 && column.getJdbcTypeCode() != 7;
    }

    public Date parseTimestamp(int type, String value) {
        try {
            if (((String)value).indexOf(".") == 8 || ((String)value).length() <= 8) {
                value = "1970-01-01 " + (String)value;
            }
            return Timestamp.valueOf((String)value);
        }
        catch (IllegalArgumentException ex) {
            if (!this.getDatabaseInfo().isZeroDateAllowed() && value != null && ((String)value).startsWith(ZERO_DATE_STRING)) {
                return null;
            }
            try {
                return new Timestamp(FormatUtils.parseDate((String)value, (String[])FormatUtils.TIMESTAMP_PATTERNS).getTime());
            }
            catch (Exception e) {
                int split = ((String)value).lastIndexOf(REQUIRED_FIELD_NULL_SUBSTITUTE);
                String datetime = ((String)value).substring(0, split).trim();
                String timezone = ((String)value).substring(split).trim();
                try {
                    return Timestamp.valueOf(datetime);
                }
                catch (IllegalArgumentException ex2) {
                    return new Timestamp(FormatUtils.parseDate((String)datetime, (String[])FormatUtils.TIMESTAMP_PATTERNS, (TimeZone)this.getTimeZone(timezone)).getTime());
                }
            }
        }
    }

    public TimeZone getTimeZone(String value) {
        TimeZone tz = TimeZone.getTimeZone("GMT" + value);
        if (tz.getRawOffset() == 0) {
            tz = TimeZone.getTimeZone(value);
        }
        return tz;
    }

    @Override
    public void makePlatformSpecific(Database database) {
        Table[] tables;
        for (Table table : tables = database.getTables()) {
            for (Column autoIncrementColumn : table.getAutoIncrementColumns()) {
                if (autoIncrementColumn.isPrimaryKey() || this.getDatabaseInfo().isNonPKIdentityColumnsSupported()) continue;
                this.log.info("Removing auto increment from table " + table.getName() + " for column " + autoIncrementColumn.getName() + " since it was not part of primary key and not supported on this database based on nonPKIdentityColumnsSupported.");
                autoIncrementColumn.setAutoIncrement(false);
            }
            if (table.getCatalog() == null) {
                table.setCatalog(this.getDefaultCatalog());
            }
            if (table.getSchema() == null) {
                table.setSchema(this.getDefaultSchema());
            }
            for (Column column : table.getColumns()) {
                PlatformColumn platformColumn = column.findPlatformColumn(this.getName());
                if (platformColumn != null) continue;
                platformColumn = new PlatformColumn(this.getName(), this.ddlBuilder.getSqlType(column), column.getDefaultValue());
                column.addPlatformColumn(platformColumn);
            }
            if (this.getDatabaseInfo().isFunctionalIndicesSupported()) continue;
            ArrayList<IIndex> indicesToRemove = new ArrayList<IIndex>();
            for (IIndex index : table.getIndices()) {
                if (!this.isFunctionalIndex(index)) continue;
                indicesToRemove.add(index);
            }
            for (IIndex indexToRemove : indicesToRemove) {
                this.log.info("Removing index " + indexToRemove.getName() + " from table " + table.getName() + " because functional indexes are not supported on this platform.");
                table.removeIndex(indexToRemove);
            }
        }
    }

    private boolean isFunctionalIndex(IIndex index) {
        boolean ret = false;
        for (IndexColumn indexColumn : index.getColumns()) {
            if (!indexColumn.getName().contains("(") && !indexColumn.getName().contains(")")) continue;
            ret = true;
            break;
        }
        return ret;
    }

    @Override
    public boolean hasMatchingPlatform(Database db) {
        boolean matches = true;
        Table[] tableArray = db.getTables();
        int n = tableArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = 0;
            Table table = tableArray[i];
            Column[] columnArray = table.getColumns();
            int n3 = columnArray.length;
            if (n2 >= n3) continue;
            Column column = columnArray[n2];
            matches &= column.getPlatformColumns() != null && column.getPlatformColumns().get(this.getName()) != null;
        }
        return matches;
    }

    @Override
    public List<PermissionResult> checkSymTablePermissions(PermissionType ... permissionTypes) {
        ArrayList<PermissionResult> results = new ArrayList<PermissionResult>();
        Database database = new Database();
        PermissionResult createResult = null;
        PermissionResult createTriggerResult = null;
        PermissionResult dropTriggerResult = null;
        boolean drop = false;
        if (ArrayUtils.contains((Object[])permissionTypes, (Object)((Object)PermissionType.CREATE_TABLE))) {
            createResult = this.getCreateSymTablePermission(database);
        }
        if (ArrayUtils.contains((Object[])permissionTypes, (Object)((Object)PermissionType.CREATE_TRIGGER))) {
            createTriggerResult = this.getCreateSymTriggerPermission();
            dropTriggerResult = this.getDropSymTriggerPermission();
        }
        block11: for (PermissionType permissionType : permissionTypes) {
            switch (permissionType) {
                case CREATE_TABLE: {
                    results.add(createResult);
                    continue block11;
                }
                case ALTER_TABLE: {
                    results.add(this.getAlterSymTablePermission(database));
                    continue block11;
                }
                case CREATE_TRIGGER: {
                    results.add(createTriggerResult);
                    continue block11;
                }
                case DROP_TRIGGER: {
                    results.add(dropTriggerResult);
                    continue block11;
                }
                case EXECUTE: {
                    results.add(this.getExecuteSymPermission());
                    continue block11;
                }
                case DROP_TABLE: {
                    drop = true;
                    continue block11;
                }
                case CREATE_FUNCTION: {
                    results.add(this.getCreateSymFunctionPermission());
                    continue block11;
                }
                case CREATE_ROUTINE: {
                    results.add(this.getCreateSymRoutinePermission());
                    continue block11;
                }
                case LOG_MINE: {
                    results.add(this.getLogMinePermission());
                    continue block11;
                }
            }
        }
        if (drop) {
            results.add(this.getDropSymTablePermission());
        }
        this.logFailedResults(results);
        return results;
    }

    protected void logFailedResults(List<PermissionResult> results) {
        for (PermissionResult result : results) {
            if (PermissionResult.Status.FAIL != result.getStatus()) continue;
            this.log.info(String.format("Database permission check failed. Category: %s Permission Type: %s Details:\r\n%s", new Object[]{result.getCategory(), result.getPermissionType(), result.getTestDetails()}), (Throwable)result.getException());
        }
    }

    protected Table getPermissionTableDefinition() {
        Column idColumn = new Column("TEST_ID");
        idColumn.setMappedType("INTEGER");
        idColumn.setRequired(true);
        idColumn.setPrimaryKey(true);
        Column valueColumn = new Column("TEST_VALUE");
        valueColumn.setMappedType("INTEGER");
        return new Table(PERMISSION_TEST_TABLE_NAME, idColumn, valueColumn);
    }

    protected PermissionResult getCreateSymTablePermission(Database database) {
        Table table = this.getPermissionTableDefinition();
        String createSql = this.ddlBuilder.createTables(database, false);
        PermissionResult result = new PermissionResult(PermissionType.CREATE_TABLE, createSql);
        this.getDropSymTablePermission();
        try {
            database.addTable(table);
            this.createDatabase(database, false, false);
            result.setStatus(PermissionResult.Status.PASS);
        }
        catch (SqlException e) {
            result.setException(e);
            result.setSolution("Grant CREATE permission");
        }
        return result;
    }

    protected PermissionResult getDropSymTablePermission() {
        Table table = this.getPermissionTableDefinition();
        PermissionResult result = new PermissionResult(PermissionType.DROP_TABLE, "dropping table " + table.getName() + "...");
        try {
            if (this.getTableFromCache(table.getName(), true) != null) {
                this.dropTables(false, table);
                result.setStatus(PermissionResult.Status.PASS);
            } else {
                result.setStatus(PermissionResult.Status.NOT_APPLICABLE);
            }
        }
        catch (SqlException e) {
            result.setException(e);
            result.setSolution("Grant DROP permission");
        }
        return result;
    }

    protected PermissionResult getAlterSymTablePermission(Database database) {
        String delimiter = this.getDatabaseInfo().getDelimiterToken();
        delimiter = delimiter != null ? delimiter : "";
        Column idColumn = new Column("TEST_ID");
        idColumn.setMappedType("INTEGER");
        Column valueColumn = new Column("TEST_VALUE");
        valueColumn.setMappedType("INTEGER");
        Column alterColumn = new Column("TEST_ALTER");
        alterColumn.setMappedType("INTEGER");
        Table table = new Table(PERMISSION_TEST_TABLE_NAME, idColumn, valueColumn);
        Table alterTable = new Table(PERMISSION_TEST_TABLE_NAME, idColumn, valueColumn, alterColumn);
        PermissionResult result = new PermissionResult(PermissionType.ALTER_TABLE, "altering table SYM_PERMISSION_TEST...");
        try {
            database.removeAllTablesExcept(new String[0]);
            database.addTable(alterTable);
            this.alterDatabase(database, "sym", false);
            database.removeAllTablesExcept(new String[0]);
            database.addTable(table);
            this.alterDatabase(database, "sym", false);
            result.setStatus(PermissionResult.Status.PASS);
        }
        catch (SqlException e) {
            result.setException(e);
            result.setSolution("Grant ALTER permission");
        }
        return result;
    }

    protected PermissionResult getDropSymTriggerPermission() {
        String dropTriggerSql = "DROP TRIGGER TEST_TRIGGER";
        PermissionResult result = new PermissionResult(PermissionType.DROP_TRIGGER, dropTriggerSql);
        try {
            this.getSqlTemplate().update(dropTriggerSql, new Object[0]);
            result.setStatus(PermissionResult.Status.PASS);
        }
        catch (SqlException e) {
            result.setException(e);
            result.setSolution("Grant DROP TRIGGER permission or TRIGGER permission");
        }
        return result;
    }

    protected PermissionResult getCreateSymTriggerPermission() {
        PermissionResult result = new PermissionResult(PermissionType.CREATE_TRIGGER, "UNIMPLEMENTED");
        result.setStatus(PermissionResult.Status.UNIMPLEMENTED);
        return result;
    }

    protected PermissionResult getExecuteSymPermission() {
        PermissionResult result = new PermissionResult(PermissionType.EXECUTE, "NOT_APPLICABLE");
        result.setStatus(PermissionResult.Status.NOT_APPLICABLE);
        return result;
    }

    protected PermissionResult getCreateSymRoutinePermission() {
        PermissionResult result = new PermissionResult(PermissionType.CREATE_ROUTINE, "NOT_APPLICABLE");
        result.setStatus(PermissionResult.Status.NOT_APPLICABLE);
        return result;
    }

    protected PermissionResult getCreateSymFunctionPermission() {
        PermissionResult result = new PermissionResult(PermissionType.CREATE_FUNCTION, "NOT_APPLICABLE");
        result.setStatus(PermissionResult.Status.NOT_APPLICABLE);
        return result;
    }

    @Override
    public PermissionResult getLogMinePermission() {
        PermissionResult result = new PermissionResult(PermissionType.LOG_MINE, "UNIMPLEMENTED");
        result.setStatus(PermissionResult.Status.UNIMPLEMENTED);
        return result;
    }

    @Override
    public boolean isUseMultiThreadSyncTriggers() {
        return this.useMultiThreadSyncTriggers;
    }

    @Override
    public boolean supportsTransactions() {
        if (this.supportsTransactions == null) {
            if (this.getDataSource() instanceof DataSource) {
                try {
                    this.supportsTransactions = ((DataSource)this.getDataSource()).getConnection().getMetaData().supportsTransactions();
                }
                catch (Exception e) {
                    this.log.warn("Unable to determine if transactions are supported from connection meta data ", (Throwable)e);
                }
            } else {
                this.supportsTransactions = true;
            }
        }
        return this.supportsTransactions;
    }

    @Override
    public boolean supportsMultiThreadedTransactions() {
        return true;
    }

    @Override
    public long getEstimatedRowCount(Table table) {
        DatabaseInfo dbInfo = this.getDatabaseInfo();
        String quote = dbInfo.getDelimiterToken();
        String catalogSeparator = dbInfo.getCatalogSeparator();
        String schemaSeparator = dbInfo.getSchemaSeparator();
        String sql = String.format("select count(*) from %s", table.getQualifiedTableName(quote, catalogSeparator, schemaSeparator));
        return this.getSqlTemplateDirty().queryForLong(sql, new Object[0]);
    }

    @Override
    public String getTruncateSql(Table table) {
        Object sql = null;
        if (this.supportsTruncate) {
            sql = "truncate table ";
            String quote = this.getDdlBuilder().isDelimitedIdentifierModeOn() ? this.getDatabaseInfo().getDelimiterToken() : "";
            sql = (String)sql + table.getQualifiedTableName(quote, this.getDatabaseInfo().getCatalogSeparator(), this.getDatabaseInfo().getSchemaSeparator());
        } else {
            this.log.info("Truncate is not supported on " + this.getName() + ". Changing to equivalent delete statement");
            sql = this.getDeleteSql(table);
        }
        return sql;
    }

    @Override
    public String getDeleteSql(Table table) {
        Object sql = "delete from ";
        String quote = this.getDdlBuilder().isDelimitedIdentifierModeOn() ? this.getDatabaseInfo().getDelimiterToken() : "";
        sql = (String)sql + table.getQualifiedTableName(quote, this.getDatabaseInfo().getCatalogSeparator(), this.getDatabaseInfo().getSchemaSeparator());
        return sql;
    }

    @Override
    public List<Transaction> getTransactions() {
        return new ArrayList<Transaction>();
    }

    @Override
    public boolean supportsLimitOffset() {
        return false;
    }

    @Override
    public String massageForLimitOffset(String sql, int limit, int offset) {
        return sql;
    }

    @Override
    public String massageForObjectAlreadyExists(String sql) {
        return sql;
    }

    @Override
    public String massageForObjectDoesNotExist(String sql) {
        return sql;
    }

    @Override
    public boolean supportsSliceTables() {
        return false;
    }

    @Override
    public String getSliceTableSql(String columnName, int sliceNum, int totalSlices) {
        return "";
    }

    @Override
    public String getCharSetName() {
        return "";
    }

    @Override
    public boolean supportsParametersInSelect() {
        return true;
    }

    @Override
    public boolean allowsUniqueIndexDuplicatesWithNulls() {
        return true;
    }

    @Override
    public DatabaseVersion getDatabaseVersion() {
        return this.databaseVersion;
    }

    @Override
    public void setDatabaseVersion(DatabaseVersion databaseVersion) {
        this.databaseVersion = databaseVersion;
    }
}

