/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.model;

import java.io.Serializable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.jumpmind.db.model.Column;

public class IndexColumn
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private int ordinalPosition;
    private Column column;
    protected String name;
    protected String size;
    protected boolean primaryKey;

    public IndexColumn() {
    }

    public IndexColumn(Column column) {
        this.column = column;
        this.name = column.getName();
        this.primaryKey = column.isPrimaryKey();
    }

    public IndexColumn(String columnName) {
        this.name = columnName;
    }

    public int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    public void setOrdinalPosition(int position) {
        this.ordinalPosition = position;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Column getColumn() {
        return this.column;
    }

    public void setColumn(Column column) {
        this.column = column;
        this.name = column == null ? this.name : column.getName();
        this.primaryKey = column == null ? this.primaryKey : column.isPrimaryKey();
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public void setPrimaryKey(boolean primaryKey) {
        this.primaryKey = primaryKey;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public Object clone() throws CloneNotSupportedException {
        IndexColumn result = (IndexColumn)super.clone();
        result.name = this.name;
        result.size = this.size;
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IndexColumn) {
            IndexColumn other = (IndexColumn)obj;
            return new EqualsBuilder().append((Object)this.name, (Object)other.name).append((Object)this.size, (Object)other.size).isEquals();
        }
        return false;
    }

    public boolean equalsIgnoreCase(IndexColumn other) {
        return new EqualsBuilder().append((Object)this.name.toUpperCase(), (Object)other.name.toUpperCase()).append((Object)this.size, (Object)other.size).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.name).append((Object)this.size).toHashCode();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Index column [name=");
        result.append(this.getName());
        result.append("; size=");
        result.append(this.getSize());
        result.append("]");
        return result.toString();
    }
}

