/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.io;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jumpmind.db.io.DatabaseXmlUtil;
import org.jumpmind.db.io.Issue;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.ForeignKey;
import org.jumpmind.db.model.IIndex;
import org.jumpmind.db.model.IndexColumn;
import org.jumpmind.db.model.Reference;
import org.jumpmind.db.model.Table;
import org.jumpmind.properties.DefaultParameterParser;

public class ReleaseNotesGenerator {
    private static int features = 0;
    private static int osFeatures = 0;
    private static int improvements = 0;
    private static int osImprovements = 0;
    private static int fixes = 0;
    private static int osFixes = 0;
    private static final String[] sections = new String[]{"fixes.ad", "whats-new.ad", "issues.ad", "tables.ad", "parameters.ad"};
    private static final String[] writtenSections = new String[]{"whats-new.ad"};
    private static final String[] categories = new String[]{"new feature", "improvement", "bug"};
    private static final String[] tags = new String[]{"security", "performance"};

    public static void main(String[] args) throws Exception {
        String directory = args[4].substring(0, args[4].lastIndexOf(47)) + "/";
        String finalNotesFile = args[4];
        String fixesFile = directory + "fixes.ad";
        String issuesFile = directory + "issues.ad";
        String tablesFile = directory + "tables.ad";
        String parametersFile = directory + "parameters.ad";
        if (args.length < 6) {
            System.err.println("wrong usage");
            System.exit(-1);
        }
        List<Issue> issues = ReleaseNotesGenerator.buildIssuesFromRestAPI(args[5]);
        String properties = args[0];
        String schema = args[1];
        String proProperties = args[2];
        String proSchema = args[3];
        PrintWriter notes = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(finalNotesFile)), StandardCharsets.UTF_8));
        PrintWriter fixesSec = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(fixesFile)), StandardCharsets.UTF_8));
        PrintWriter issuesSec = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(issuesFile)), StandardCharsets.UTF_8));
        PrintWriter tablesSec = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(tablesFile)), StandardCharsets.UTF_8));
        PrintWriter parametersSec = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(parametersFile)), StandardCharsets.UTF_8));
        ReleaseNotesGenerator.writeParametersSection(parametersSec, properties, proProperties);
        ReleaseNotesGenerator.writeTablesSection(tablesSec, schema, proSchema);
        ReleaseNotesGenerator.writeIssuesSection(issuesSec, issues);
        ReleaseNotesGenerator.writeFixesSection(fixesSec, issues);
        ReleaseNotesGenerator.writeFinalNotes(notes, sections);
        notes.close();
        fixesSec.close();
        issuesSec.close();
        tablesSec.close();
        parametersSec.close();
    }

    protected static List<Issue> buildIssuesFromRestAPI(String url) throws Exception {
        String output;
        URL apiURL = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)apiURL.openConnection();
        if (conn.getResponseCode() != 200) {
            throw new RuntimeException("Failed : HTTP Error code : " + conn.getResponseCode());
        }
        InputStreamReader in = new InputStreamReader(conn.getInputStream());
        BufferedReader br = new BufferedReader(in);
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        while ((output = br.readLine()) != null) {
            buffer.append(output);
        }
        buffer.append("]");
        String json = buffer.toString();
        json = json.replaceAll("\\}\\{", "},{");
        conn.disconnect();
        ArrayList<Issue> issues = new ArrayList<Issue>();
        List root = (List)new Gson().fromJson(json, List.class);
        for (Map map : root) {
            Issue issue = new Issue();
            issue.setId((String)map.get("id"));
            issue.setCategory((String)map.get("category"));
            issue.setProject((String)map.get("project"));
            issue.setPriority((String)map.get("priority"));
            issue.setSummary((String)map.get("summary"));
            issue.setTag((String)map.get("tag"));
            issue.setVersion((String)map.get("version"));
            issues.add(issue);
        }
        return issues;
    }

    protected static void writeFinalNotes(PrintWriter writer, String[] sections) {
        writer.println("= Release Notes");
        writer.println();
        writer.println("== Overview");
        writer.println();
        writer.println("ifdef::pro[]");
        writer.println(String.format("SymmetricDS Pro @appMajorVersion@ release includes %d features, %d improvements, and %d bug fixes.", features, improvements, fixes));
        writer.println("endif::pro[]");
        writer.println("ifndef::pro[]");
        writer.println(String.format("SymmetricDS @appMajorVersion@ release includes %d features, %d improvements, and %d bug fixes.", osFeatures, osImprovements, osFixes));
        writer.println("endif::pro[]");
        writer.println();
        for (String section : sections) {
            if (Arrays.asList(writtenSections).contains(section)) {
                writer.println(String.format("include::%s/release-notes/%s[]", "{includedir}", section));
                continue;
            }
            writer.println(String.format("include::%s/%s[]", "{includedir}/generated", section));
        }
    }

    protected static void writeParametersSection(PrintWriter writer, String propertiesLoc, String proPropertiesLoc) throws Exception {
        DefaultParameterParser.ParameterMetaData metaData;
        ArrayList<String> parameters;
        DefaultParameterParser parser = new DefaultParameterParser((InputStream)new FileInputStream(propertiesLoc));
        Map previousParamMap = parser.parse();
        parser = new DefaultParameterParser((InputStream)new FileInputStream("../symmetric-core/src/main/resources/symmetric-default.properties"));
        Map currentParamMap = parser.parse();
        parser = new DefaultParameterParser((InputStream)new FileInputStream(proPropertiesLoc));
        Map previousProParamMap = parser.parse();
        Map currentProParamMap = new HashMap();
        try {
            parser = new DefaultParameterParser((InputStream)new FileInputStream("../../symmetric-pro/symmetric-pro/src/main/resources/symmetric-console-default.properties"));
            currentProParamMap = parser.parse();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        Set previousParams = previousParamMap.keySet();
        Set currentParams = currentParamMap.keySet();
        Set previousProParams = previousProParamMap.keySet();
        Set currentProParams = currentProParamMap.keySet();
        HashSet<String> inCurrentNotPrevious = new HashSet<String>();
        HashSet<String> inPreviousNotCurrent = new HashSet<String>();
        HashSet<String> modifiedSincePrevious = new HashSet<String>();
        for (String param : currentParams) {
            if (!previousParams.contains(param)) {
                inCurrentNotPrevious.add(param);
                continue;
            }
            if (((DefaultParameterParser.ParameterMetaData)currentParamMap.get(param)).getDefaultValue().equalsIgnoreCase(((DefaultParameterParser.ParameterMetaData)previousParamMap.get(param)).getDefaultValue())) continue;
            modifiedSincePrevious.add(param);
        }
        for (String param : currentProParams) {
            if (!previousProParams.contains(param)) {
                inCurrentNotPrevious.add(param);
                continue;
            }
            if (((DefaultParameterParser.ParameterMetaData)currentProParamMap.get(param)).getDefaultValue().equalsIgnoreCase(((DefaultParameterParser.ParameterMetaData)previousProParamMap.get(param)).getDefaultValue())) continue;
            modifiedSincePrevious.add(param);
        }
        for (String param : previousParams) {
            if (currentParams.contains(param)) continue;
            System.out.println("Could not find param " + param + " in current params");
            inPreviousNotCurrent.add(param);
        }
        for (String param : previousProParams) {
            if (currentProParams.contains(param)) continue;
            System.out.println("Could not find param " + param + " in current pro params");
            inPreviousNotCurrent.add(param);
        }
        if (inCurrentNotPrevious.size() > 0 || modifiedSincePrevious.size() > 0 || inPreviousNotCurrent.size() > 0) {
            if (currentProParams.containsAll(inCurrentNotPrevious) && currentProParams.containsAll(modifiedSincePrevious) && previousProParams.containsAll(inPreviousNotCurrent)) {
                writer.println("ifdef::pro[]");
            }
            writer.println("== Parameters");
            writer.println("The following changes were made to add new parameters, modify their default value, modify their description, or remove them from use.");
            writer.println();
            if (currentProParams.containsAll(inCurrentNotPrevious) && currentProParams.containsAll(modifiedSincePrevious) && previousProParams.containsAll(inPreviousNotCurrent)) {
                writer.println("endif::pro[]");
            }
        }
        if (inCurrentNotPrevious.size() > 0) {
            if (currentProParams.containsAll(inCurrentNotPrevious)) {
                writer.println("ifdef::pro[]");
            }
            writer.println("=== New Parameters");
            writer.println();
            if (currentProParams.containsAll(inCurrentNotPrevious)) {
                writer.println("endif::pro[]");
            }
            parameters = new ArrayList<String>(inCurrentNotPrevious);
            parameters.sort(new StringComparator());
            for (String parameter : parameters) {
                metaData = (DefaultParameterParser.ParameterMetaData)currentProParamMap.get(parameter);
                if (metaData != null) {
                    writer.println("ifdef::pro[]");
                    writer.println(String.format(".*%s* (Pro)", parameter));
                    writer.println();
                    writer.println(metaData.getDescription() != null ? String.format("%s (Default: %s)", metaData.getDescription().trim(), metaData.getDefaultValue()) : "");
                    writer.println("endif::pro[]");
                } else {
                    metaData = (DefaultParameterParser.ParameterMetaData)currentParamMap.get(parameter);
                    writer.println(String.format(".*%s*", parameter));
                    writer.println();
                    writer.println(metaData.getDescription() != null ? String.format("%s (Default: %s)", metaData.getDescription().trim(), metaData.getDefaultValue()) : "");
                }
                writer.println();
            }
        }
        if (modifiedSincePrevious.size() > 0 || inPreviousNotCurrent.size() > 0) {
            if (currentProParams.containsAll(modifiedSincePrevious) && previousProParams.containsAll(inPreviousNotCurrent)) {
                writer.println("ifdef::pro[]");
            }
            writer.println("=== Modified Parameters");
            writer.println();
            if (currentProParams.containsAll(modifiedSincePrevious) && previousProParams.containsAll(inPreviousNotCurrent)) {
                writer.println("endif::pro[]");
            }
            parameters = new ArrayList(modifiedSincePrevious);
            parameters.sort(new StringComparator());
            for (String parameter : parameters) {
                metaData = (DefaultParameterParser.ParameterMetaData)currentProParamMap.get(parameter);
                if (metaData != null) {
                    writer.println("ifdef::pro[]");
                    writer.println(String.format(".*%s* (Pro)", parameter));
                    writer.println();
                    writer.println(metaData.getDescription() != null ? String.format("%s (Old Default: %s) (New Default: %s)", metaData.getDescription().trim(), ((DefaultParameterParser.ParameterMetaData)previousProParamMap.get(parameter)).getDefaultValue(), metaData.getDefaultValue()) : "");
                    writer.println("endif::pro[]");
                } else {
                    metaData = (DefaultParameterParser.ParameterMetaData)currentParamMap.get(parameter);
                    writer.println(String.format(".*%s*", parameter));
                    writer.println();
                    writer.println(metaData.getDescription() != null ? String.format("%s (Old Default: %s) (New Default: %s)", metaData.getDescription().trim(), ((DefaultParameterParser.ParameterMetaData)previousParamMap.get(parameter)).getDefaultValue(), metaData.getDefaultValue()) : "");
                }
                writer.println();
            }
            parameters = new ArrayList(inPreviousNotCurrent);
            parameters.sort(new StringComparator());
            for (String parameter : inPreviousNotCurrent) {
                if (previousProParamMap.containsKey(parameter)) {
                    writer.println("ifdef::pro[]");
                    writer.println(String.format(".*%s* (Pro)", parameter));
                    writer.println();
                    writer.println("{REMOVED}");
                    writer.println("endif::pro[]");
                } else {
                    writer.println(String.format(".*%s*", parameter));
                    writer.println();
                    writer.println("{REMOVED}");
                }
                writer.println();
            }
        }
    }

    public static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(keyExtractor.apply(t));
    }

    protected static void writeTablesSection(PrintWriter writer, String schemaLoc, String proSchemaLoc) {
        Database dbOld = DatabaseXmlUtil.read(new File(schemaLoc));
        Database dbCurrent = DatabaseXmlUtil.read(new File("../symmetric-core/src/main/resources/symmetric-schema.xml"));
        Database dbProOld = new Database();
        File proSchemaFile = new File(proSchemaLoc);
        if (proSchemaFile.canRead()) {
            dbProOld = DatabaseXmlUtil.read(proSchemaFile);
        }
        Database dbProCurrent = new Database();
        File dbProCurrentFile = new File("../../symmetric-pro/symmetric-pro/src/main/resources/console-schema.xml");
        if (dbProCurrentFile.canRead()) {
            dbProCurrent = DatabaseXmlUtil.read(dbProCurrentFile);
        }
        ArrayList<Table> tablesProOld = new ArrayList<Table>(Arrays.asList(dbProOld.getTables()));
        ArrayList<Table> tablesProCurrent = new ArrayList<Table>(Arrays.asList(dbProCurrent.getTables()));
        ArrayList<Table> tablesOld = new ArrayList<Table>(Arrays.asList(dbOld.getTables()));
        ArrayList<Table> tablesCurrent = new ArrayList<Table>(Arrays.asList(dbCurrent.getTables()));
        tablesOld.addAll(tablesProOld);
        tablesCurrent.addAll(tablesProCurrent);
        ArrayList<Table> newTables = new ArrayList<Table>();
        HashMap tableColMap = new HashMap();
        HashMap tableChangeMap = new HashMap();
        System.out.println(tablesOld.size() + " old tables compared to " + tablesCurrent.size() + " current tables.");
        for (Table table : tablesCurrent) {
            boolean isNewTable = true;
            for (Table oldTable : tablesOld) {
                if (!table.getName().equalsIgnoreCase(oldTable.getName())) continue;
                isNewTable = false;
                ArrayList<Object> changeList = new ArrayList<Object>();
                List<ForeignKey> foreignKeys = Arrays.asList(table.getForeignKeys());
                List<String> primaryKeys = Arrays.asList(table.getPrimaryKeyColumnNames());
                List<IIndex> indices = Arrays.asList(table.getIndices());
                List<ForeignKey> oldForeignKeys = Arrays.asList(oldTable.getForeignKeys());
                List<String> oldPrimaryKeys = Arrays.asList(oldTable.getPrimaryKeyColumnNames());
                List<IIndex> oldIndices = Arrays.asList(oldTable.getIndices());
                Set<Object> allIndices = new HashSet();
                allIndices.addAll(indices.stream().filter(ReleaseNotesGenerator.distinctByKey(IIndex::getName)).collect(Collectors.toList()));
                allIndices.addAll(oldIndices.stream().filter(ReleaseNotesGenerator.distinctByKey(IIndex::getName)).collect(Collectors.toList()));
                allIndices = allIndices.stream().filter(ReleaseNotesGenerator.distinctByKey(IIndex::getName)).collect(Collectors.toSet());
                Set<Object> allFKeys = new HashSet();
                allFKeys.addAll(foreignKeys.stream().filter(ReleaseNotesGenerator.distinctByKey(ForeignKey::getName)).collect(Collectors.toList()));
                allFKeys.addAll(oldForeignKeys.stream().filter(ReleaseNotesGenerator.distinctByKey(ForeignKey::getName)).collect(Collectors.toList()));
                allFKeys = allFKeys.stream().filter(ReleaseNotesGenerator.distinctByKey(ForeignKey::getName)).collect(Collectors.toSet());
                HashSet<String> allPKeys = new HashSet<String>();
                allPKeys.addAll(primaryKeys);
                allPKeys.addAll(oldPrimaryKeys);
                for (ForeignKey foreignKey : allFKeys) {
                    if (foreignKeys.contains(foreignKey) && !oldForeignKeys.contains(foreignKey)) {
                        changeList.add(String.format("Added foreign key `%s` (`%s`)", foreignKey.getName(), String.join((CharSequence)"`, `", Arrays.asList(foreignKey.getReferences()).stream().map(e -> e.getLocalColumnName()).collect(Collectors.toList()))));
                        continue;
                    }
                    if (!foreignKeys.contains(foreignKey) && oldForeignKeys.contains(foreignKey)) {
                        changeList.add(String.format("Removed foreign key `%s` (`%s`)", foreignKey.getName(), String.join((CharSequence)"`, `", Arrays.asList(foreignKey.getReferences()).stream().map(e -> e.getLocalColumnName()).collect(Collectors.toList()))));
                        continue;
                    }
                    ForeignKey oldFKey = (ForeignKey)oldForeignKeys.stream().filter(e -> e.getName().equalsIgnoreCase(foreignKey.getName())).collect(Collectors.toList()).get(0);
                    ForeignKey newFKey = (ForeignKey)foreignKeys.stream().filter(e -> e.getName().equalsIgnoreCase(foreignKey.getName())).collect(Collectors.toList()).get(0);
                    HashSet<Reference> oldReferencesSet = new HashSet<Reference>(Arrays.asList(oldFKey.getReferences()));
                    HashSet<Reference> hashSet = new HashSet<Reference>(Arrays.asList(newFKey.getReferences()));
                    if (oldFKey.isAutoIndexPresent() != newFKey.isAutoIndexPresent()) {
                        changeList.add(String.format("Foreign key `%s` %s changed from `%s` to `%s`", foreignKey.getName(), "auto index", oldFKey.isAutoIndexPresent(), newFKey.isAutoIndexPresent()));
                    }
                    if (oldReferencesSet.equals(hashSet)) continue;
                    changeList.add(String.format("Modified references on foreign key `%s`:\n** Old: (`%s`)\n** New: (`%s`)", foreignKey.getName(), String.join((CharSequence)"`, `", oldReferencesSet.stream().map(e -> e.getForeignColumnName()).collect(Collectors.toList())), String.join((CharSequence)"`, `", hashSet.stream().map(e -> e.getForeignColumnName()).collect(Collectors.toList()))));
                }
                StringBuilder added = new StringBuilder();
                StringBuilder stringBuilder = new StringBuilder();
                boolean addedAny = false;
                boolean removedAny = false;
                for (String string : allPKeys) {
                    if (primaryKeys.contains(string) && !oldPrimaryKeys.contains(string)) {
                        added.append(string + "`, `");
                        addedAny = true;
                        continue;
                    }
                    if (primaryKeys.contains(string) || !oldPrimaryKeys.contains(string)) continue;
                    stringBuilder.append(string + "`, `");
                    removedAny = true;
                }
                if (addedAny) {
                    added.delete(added.length() - "`, `".length(), added.length());
                    changeList.add(String.format("Added primary keys: `%s`", added.toString()));
                }
                if (removedAny) {
                    stringBuilder.delete(stringBuilder.length() - "`, `".length(), stringBuilder.length());
                    changeList.add(String.format("Removed primary keys: `%s`", stringBuilder.toString()));
                }
                for (IIndex iIndex : allIndices) {
                    if (indices.stream().anyMatch(e -> e.getName().equals(index.getName())) && !oldIndices.stream().anyMatch(e -> e.getName().equals(index.getName()))) {
                        changeList.add(String.format("Added index `%s` (`%s`)", iIndex.getName(), String.join((CharSequence)"`, `", Arrays.asList(iIndex.getColumns()).stream().map(e -> e.getName()).collect(Collectors.toList()))));
                        continue;
                    }
                    if (!indices.stream().anyMatch(e -> e.getName().equals(index.getName())) && oldIndices.stream().anyMatch(e -> e.getName().equals(index.getName()))) {
                        changeList.add(String.format("Removed index `%s` (`%s`)", iIndex.getName(), String.join((CharSequence)"`, `", Arrays.asList(iIndex.getColumns()).stream().map(e -> e.getName()).collect(Collectors.toList()))));
                        continue;
                    }
                    IIndex oldIndex = (IIndex)oldIndices.stream().filter(e -> e.getName().equalsIgnoreCase(index.getName())).collect(Collectors.toList()).get(0);
                    IIndex newIndex = (IIndex)indices.stream().filter(e -> e.getName().equalsIgnoreCase(index.getName())).collect(Collectors.toList()).get(0);
                    HashSet<IndexColumn> oldReferencesSet = new HashSet<IndexColumn>(Arrays.asList(oldIndex.getColumns()));
                    HashSet<IndexColumn> newReferencesSet = new HashSet<IndexColumn>(Arrays.asList(newIndex.getColumns()));
                    if (oldIndex.isUnique() != newIndex.isUnique()) {
                        changeList.add("Index " + String.format("`%s` %s changed from `%s` to `%s`", iIndex.getName(), "isUnique", oldIndex.isUnique(), newIndex.isUnique()));
                    }
                    if (oldReferencesSet.equals(newReferencesSet)) continue;
                    changeList.add(String.format("Modified columns on index `%s`:\n** Old: (`%s`)\n** New: (`%s`)", iIndex.getName(), String.join((CharSequence)"`, `", oldReferencesSet.stream().map(e -> e.getName()).collect(Collectors.toList())), String.join((CharSequence)"`, `", newReferencesSet.stream().map(e -> e.getName()).collect(Collectors.toList()))));
                }
                List<Column> ColsNew = table.getColumnsAsList();
                List<Column> list = oldTable.getColumnsAsList();
                if (!table.getColumnsAsList().stream().map(Column::getName).allMatch(oldTable.getColumnsAsList().stream().map(Column::getName).collect(Collectors.toSet())::contains)) {
                    ArrayList<Column> mapList = new ArrayList<Column>();
                    for (Column column : ColsNew) {
                        if (list.stream().map(Column::getName).filter(column.getName()::equals).findFirst().isPresent()) continue;
                        mapList.add(column);
                    }
                    if (mapList.size() > 0) {
                        tableColMap.put(table, mapList);
                    }
                }
                for (Column column : ColsNew) {
                    try {
                        Column oldColumn = list.stream().filter(o -> o.getName().equals(column.getName())).findFirst().get();
                        if (oldColumn.isTimestampWithTimezone() != column.isTimestampWithTimezone()) {
                            changeList.add(String.format("`%s` %s changed from `%s` to `%s`", column.getName(), "timestamp with timezone", oldColumn.isTimestampWithTimezone(), column.isTimestampWithTimezone()));
                        }
                        if (oldColumn.isDistributionKey() != column.isDistributionKey()) {
                            changeList.add(String.format("`%s` %s changed from `%s` to `%s`", column.getName(), "isDistributionKey", oldColumn.isDistributionKey(), column.isDistributionKey()));
                        }
                        if (oldColumn.isAutoIncrement() != column.isAutoIncrement()) {
                            changeList.add(String.format("`%s` %s changed from `%s` to `%s`", column.getName(), "isAutoIncrement", oldColumn.isAutoIncrement(), column.isAutoIncrement()));
                        }
                        if (oldColumn.isUnique() != column.isUnique()) {
                            changeList.add(String.format("`%s` %s changed from `%s` to `%s`", column.getName(), "isUnique", oldColumn.isUnique(), column.isUnique()));
                        }
                        if (oldColumn.getPrecisionRadix() != column.getPrecisionRadix()) {
                            changeList.add(String.format("`%s` %s changed from `%s` to `%s`", column.getName(), "precision radix", oldColumn.getPrecisionRadix(), column.getPrecisionRadix()));
                        }
                        if (ReleaseNotesGenerator.isChanged(oldColumn.getDefaultValue(), column.getDefaultValue())) {
                            Object[] objectArray = new Object[4];
                            objectArray[0] = column.getName();
                            objectArray[1] = "default value";
                            Object object = oldColumn.getDefaultValue() == null ? "null" : (objectArray[2] = ReleaseNotesGenerator.isVarcharOrChar(column.getMappedTypeCode()) ? "\"" + column.getDefaultValue() + "\"" : column.getDefaultValue());
                            objectArray[3] = column.getDefaultValue() == null ? "null" : (ReleaseNotesGenerator.isVarcharOrChar(column.getMappedTypeCode()) ? "\"" + column.getDefaultValue() + "\"" : column.getDefaultValue());
                            changeList.add(String.format("`%s` %s changed from `%s` to `%s`", objectArray));
                        }
                        if (ReleaseNotesGenerator.isChanged(oldColumn.getMappedType(), column.getMappedType())) {
                            changeList.add(String.format("`%s` %s changed from `%s` to `%s`", column.getName(), "type", oldColumn.getMappedType() == null ? "null" : oldColumn.getMappedType(), column.getMappedType() == null ? "null" : column.getMappedType()));
                        }
                        if (ReleaseNotesGenerator.isChanged(oldColumn.getSize(), column.getSize())) {
                            changeList.add(String.format("`%s` %s changed from `%s` to `%s`", column.getName(), "size", oldColumn.getSize() == null ? "null" : oldColumn.getSize(), column.getSize() == null ? "null" : column.getSize()));
                        }
                        if (oldColumn.isRequired() == column.isRequired()) continue;
                        changeList.add(String.format("`%s` %s changed from `%s` to `%s`", column.getName(), "isRequired", oldColumn.isRequired(), column.isRequired()));
                    }
                    catch (NoSuchElementException e2) {
                        System.out.println("No match found for column \"" + column.getName() + "\", assuming new");
                    }
                }
                if (changeList.size() <= 0) continue;
                tableChangeMap.put(table, changeList);
            }
            if (!isNewTable) continue;
            newTables.add(table);
        }
        if (newTables.size() > 0 || tableColMap.size() > 0 || tableChangeMap.size() > 0) {
            ArrayList tables;
            if (tablesProCurrent.containsAll(newTables) && tablesProCurrent.containsAll(tableColMap.keySet()) && tablesProCurrent.containsAll(tableChangeMap.keySet())) {
                writer.println("ifdef::pro[]");
            }
            writer.println("== Tables");
            writer.println("The following changes were made to the definition of configuration and runtime tables. Table changes are applied to the database automatically using data definition language (DDL) during startup.");
            writer.println();
            if (tablesProCurrent.containsAll(newTables) && tablesProCurrent.containsAll(tableColMap.keySet()) && tablesProCurrent.containsAll(tableChangeMap.keySet())) {
                writer.println("endif::pro[]");
            }
            if (newTables.size() > 0) {
                if (tablesProCurrent.containsAll(newTables)) {
                    writer.println("ifdef::pro[]");
                }
                writer.println("=== New Tables");
                writer.println();
                writer.println("[cols=\"4,6\"]\n|===\n|Table Name |Description");
                writer.println();
                for (Table table : newTables) {
                    String desc = table.getDescription();
                    String name = table.getNameLowerCase();
                    if (tablesProCurrent.contains(table)) {
                        writer.println("ifdef::pro[]");
                        writer.println(String.format("|`sym_%s` _(Pro)_\n|%s", name, desc));
                        writer.println("endif::pro[]");
                        writer.println();
                        continue;
                    }
                    writer.println(String.format("|`sym_%s`\n|%s", name, desc));
                    writer.println();
                }
                writer.println("|===");
                if (tablesProCurrent.containsAll(newTables)) {
                    writer.println("endif::pro[]");
                }
            }
            if (tableColMap.size() > 0) {
                writer.println("=== New Columns");
                writer.println();
                tables = new ArrayList(tableColMap.keySet());
                tables.sort(new TableComparator());
                for (Table table : tables) {
                    if (tablesProCurrent.contains(table)) {
                        writer.println("ifdef::pro[]");
                        writer.println(String.format(".*SYM_%s* (Pro)\n[caption=\"\",cols=\"4,6\"]\n|===\n|Column Name |Description", table.getName().toUpperCase()));
                        writer.println();
                    } else {
                        writer.println(String.format(".*SYM_%s*\n[caption=\"\",cols=\"4,6\"]\n|===\n|Column Name |Description", table.getName().toUpperCase()));
                        writer.println();
                    }
                    for (Column column : (List)tableColMap.get(table)) {
                        writer.println(String.format("|`%s`\n|%s", column.getName(), column.getDescription()));
                        writer.println();
                    }
                    writer.println("|===");
                    if (tablesProCurrent.contains(table)) {
                        writer.println("endif::pro[]");
                    }
                    writer.println();
                }
            }
            writer.println();
            if (tableChangeMap.size() > 0) {
                writer.println("=== Modified Tables");
                writer.println();
                tables = new ArrayList(tableChangeMap.keySet());
                tables.sort(new TableComparator());
                for (Table table : tables) {
                    if (tablesProCurrent.contains(table)) {
                        writer.println("ifdef::pro[]");
                        writer.println(String.format(".*SYM_%s* (Pro)", table.getName().toUpperCase()));
                    } else {
                        writer.println(String.format(".*SYM_%s*", table.getName().toUpperCase()));
                    }
                    for (String change : (List)tableChangeMap.get(table)) {
                        writer.println(String.format("* %s", change));
                    }
                    if (tablesProCurrent.contains(table)) {
                        writer.println("endif::pro[]");
                    }
                    writer.println();
                }
            }
        }
        writer.println();
    }

    private static boolean isVarcharOrChar(int jdbcTypeCode) {
        return jdbcTypeCode == -16 || jdbcTypeCode == -9 || jdbcTypeCode == 12 || jdbcTypeCode == -16 || jdbcTypeCode == 1;
    }

    private static boolean isChanged(String previous, String current) {
        if (previous == null && current != null) {
            return true;
        }
        if (previous != null && current == null) {
            return true;
        }
        if (previous == null && current == null) {
            return false;
        }
        if (previous != null && previous.equalsIgnoreCase(current)) {
            return false;
        }
        return previous != null && !previous.equalsIgnoreCase(current);
    }

    private static int writeMinorVersionIssues(PrintWriter writer, List<Issue> issues, String version, String category) {
        String idWithLink;
        int issuesWritten = 0;
        if (issues.stream().anyMatch(e -> e.getVersion().equalsIgnoreCase(version) && e.getProject().equalsIgnoreCase("symmetric-pro") && e.getCategory().equalsIgnoreCase(category))) {
            writer.println("ifdef::pro[]");
            writer.println("--");
            writer.println("[%hardbreaks]");
            writer.println(String.format("*%s (Pro)*", version));
            for (Issue issue : issues) {
                if (!issue.getProject().equalsIgnoreCase("symmetric-pro") || !issue.getVersion().equalsIgnoreCase(version) || !issue.getCategory().equalsIgnoreCase(category)) continue;
                idWithLink = String.format("https://www.symmetricds.org/issues/view.php?id=%s[%s]", issue.getId(), issue.getId());
                writer.println(String.format("%s - %s", idWithLink, issue.getSummary()));
                ++issuesWritten;
            }
            writer.println("--");
            writer.println("endif::pro[]");
        }
        if (issues.stream().anyMatch(e -> e.getVersion().equalsIgnoreCase(version) && !e.getProject().equalsIgnoreCase("symmetric-pro") && e.getCategory().equalsIgnoreCase(category))) {
            writer.println("--");
            writer.println("[%hardbreaks]");
            writer.println(String.format("*%s*", version));
            for (Issue issue : issues) {
                if (issue.getProject().equalsIgnoreCase("symmetric-pro") || !issue.getVersion().equalsIgnoreCase(version) || !issue.getCategory().equalsIgnoreCase(category)) continue;
                idWithLink = String.format("https://www.symmetricds.org/issues/view.php?id=%s[%s]", issue.getId(), issue.getId());
                writer.println(String.format("%s - %s", idWithLink, issue.getSummary()));
                ++issuesWritten;
            }
            writer.println("--");
        }
        return issuesWritten;
    }

    protected static void writeIssuesSection(PrintWriter writer, List<Issue> issues) {
        ArrayList<String> versions = new ArrayList<String>();
        HashMap<String, String> categoryHeaders = new HashMap<String, String>();
        HashMap<String, Integer> trackers = new HashMap<String, Integer>();
        HashMap<String, Integer> proTrackers = new HashMap<String, Integer>();
        categoryHeaders.put(categories[0], "=== New Features");
        categoryHeaders.put(categories[1], "=== Improvements");
        categoryHeaders.put(categories[2], "=== Bug Fixes");
        for (Issue issue : issues) {
            if (versions.contains(issue.getVersion().toLowerCase())) continue;
            versions.add(issue.getVersion().toLowerCase());
        }
        versions.sort(new VersionComparator());
        issues.sort(new IssueComparator());
        features = issues.stream().filter(e -> e.getCategory().equalsIgnoreCase(categories[0])).collect(Collectors.toList()).size();
        improvements = issues.stream().filter(e -> e.getCategory().equalsIgnoreCase(categories[1])).collect(Collectors.toList()).size();
        fixes = issues.stream().filter(e -> e.getCategory().equalsIgnoreCase(categories[2])).collect(Collectors.toList()).size();
        osFeatures = issues.stream().filter(e -> e.getCategory().equalsIgnoreCase(categories[0]) && !e.getProject().equalsIgnoreCase("symmetric-pro")).collect(Collectors.toList()).size();
        osImprovements = issues.stream().filter(e -> e.getCategory().equalsIgnoreCase(categories[1]) && !e.getProject().equalsIgnoreCase("symmetric-pro")).collect(Collectors.toList()).size();
        osFixes = issues.stream().filter(e -> e.getCategory().equalsIgnoreCase(categories[2]) && !e.getProject().equalsIgnoreCase("symmetric-pro")).collect(Collectors.toList()).size();
        trackers.put(categories[0], features);
        trackers.put(categories[1], improvements);
        trackers.put(categories[2], fixes);
        int proFeatures = issues.stream().filter(e -> e.getCategory().equalsIgnoreCase(categories[0]) && e.getProject().equalsIgnoreCase("symmetric-pro")).collect(Collectors.toList()).size();
        int proImprovements = issues.stream().filter(e -> e.getCategory().equalsIgnoreCase(categories[1]) && e.getProject().equalsIgnoreCase("symmetric-pro")).collect(Collectors.toList()).size();
        int proFixes = issues.stream().filter(e -> e.getCategory().equalsIgnoreCase(categories[2]) && e.getProject().equalsIgnoreCase("symmetric-pro")).collect(Collectors.toList()).size();
        proTrackers.put(categories[0], proFeatures);
        proTrackers.put(categories[1], proImprovements);
        proTrackers.put(categories[2], proFixes);
        boolean allSymProIssues = true;
        for (String category : categories) {
            if (((Integer)trackers.get(category)).equals(proTrackers.get(category))) continue;
            allSymProIssues = false;
        }
        if (features > 0 || improvements > 0 || fixes > 0) {
            if (allSymProIssues) {
                writer.println("ifdef::pro[]");
            }
            writer.println("== Issues");
            if (allSymProIssues) {
                writer.println("endif::pro[]");
            }
        }
        for (String category : categories) {
            if ((Integer)trackers.get(category) <= 0) continue;
            if (((Integer)trackers.get(category)).equals(proTrackers.get(category))) {
                writer.println("ifdef::pro[]");
            }
            writer.println((String)categoryHeaders.get(category));
            for (String version : versions) {
                ReleaseNotesGenerator.writeMinorVersionIssues(writer, issues, version, category);
            }
            if (!((Integer)trackers.get(category)).equals(proTrackers.get(category))) continue;
            writer.println("endif::pro[]");
        }
        writer.println();
    }

    protected static void writeFixesSection(PrintWriter writer, List<Issue> issues) {
        String idWithLink;
        int osSecurityFixes = issues.stream().filter(e -> e.getTag() != null && e.getTag().equalsIgnoreCase(tags[0]) && !e.getProject().equalsIgnoreCase("symmetric-pro")).collect(Collectors.toList()).size();
        int osPerformanceFixes = issues.stream().filter(e -> e.getTag() != null && e.getTag().equalsIgnoreCase(tags[1]) && !e.getProject().equalsIgnoreCase("symmetric-pro")).collect(Collectors.toList()).size();
        int allSecurityFixes = issues.stream().filter(e -> e.getTag() != null && e.getTag().equalsIgnoreCase(tags[0])).collect(Collectors.toList()).size();
        int allPerformanceFixes = issues.stream().filter(e -> e.getTag() != null && e.getTag().equalsIgnoreCase(tags[1])).collect(Collectors.toList()).size();
        if (allSecurityFixes > 0) {
            if (osSecurityFixes == 0) {
                writer.println("ifdef::pro[]");
            }
            writer.println("=== Security Fixes");
            writer.println();
            writer.println("[cols=\"1,7,2\"]\n|===\n|Issue |Summary |Severity");
            writer.println();
            issues.sort(new IssueComparator());
            for (Issue issue : issues) {
                if (issue.getTag() == null || !issue.getTag().equalsIgnoreCase(tags[0])) continue;
                idWithLink = String.format("https://www.symmetricds.org/issues/view.php?id=%s[%s]", issue.getId(), issue.getId());
                if (issue.getProject().equalsIgnoreCase("symmetric-pro")) {
                    writer.println("ifdef::pro[]");
                    writer.println(String.format("|%s\n|%s (Pro)\n|%s", idWithLink, issue.getSummary(), issue.getPriority().substring(0, 1).toUpperCase() + issue.getPriority().substring(1)));
                    writer.println("endif::pro[]");
                } else {
                    writer.println(String.format("|%s\n|%s\n|%s", idWithLink, issue.getSummary(), issue.getPriority().substring(0, 1).toUpperCase() + issue.getPriority().substring(1)));
                }
                writer.println();
            }
            writer.println("|===");
            if (osSecurityFixes == 0) {
                writer.println("endif::pro[]");
            }
        }
        writer.println();
        if (allPerformanceFixes > 0) {
            if (osPerformanceFixes == 0) {
                writer.println("ifdef::pro[]");
            }
            writer.println("=== Performance Fixes");
            writer.println();
            writer.println("[cols=\"1,7,2\"]\n|===\n|Issue |Summary |Severity");
            writer.println();
            for (Issue issue : issues) {
                if (issue.getTag() == null || !issue.getTag().equalsIgnoreCase(tags[1])) continue;
                idWithLink = String.format("https://www.symmetricds.org/issues/view.php?id=%s[%s]", issue.getId(), issue.getId());
                if (issue.getProject().equalsIgnoreCase("symmetric-pro")) {
                    writer.println("ifdef::pro[]");
                    writer.println(String.format("|%s\n|%s (Pro)\n|%s", idWithLink, issue.getSummary(), issue.getPriority().substring(0, 1).toUpperCase() + issue.getPriority().substring(1)));
                    writer.println("endif::pro[]");
                } else {
                    writer.println(String.format("|%s\n|%s\n|%s", idWithLink, issue.getSummary(), issue.getPriority().substring(0, 1).toUpperCase() + issue.getPriority().substring(1)));
                }
                writer.println();
            }
            writer.println("|===");
            if (osPerformanceFixes == 0) {
                writer.println("endif::pro[]");
            }
        }
    }

    static class StringComparator
    implements Comparator<String> {
        StringComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            return s1.compareTo(s2);
        }
    }

    static class TableComparator
    implements Comparator<Table> {
        TableComparator() {
        }

        @Override
        public int compare(Table t1, Table t2) {
            return t1.getNameLowerCase().compareTo(t2.getNameLowerCase());
        }
    }

    static class VersionComparator
    implements Comparator<String> {
        VersionComparator() {
        }

        @Override
        public int compare(String v1, String v2) {
            return this.compareTo(v1.split("\\."), v2.split("\\."), 0);
        }

        private int compareTo(String[] v1, String[] v2, int index) {
            int compareTo = 0;
            if (v1.length > index) {
                try {
                    compareTo = Integer.compare(Integer.parseInt(v1[index]), Integer.parseInt(v2[index]));
                    if (compareTo == 0) {
                        compareTo = this.compareTo(v1, v2, index + 1);
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (v1.length != v2.length) {
                compareTo = v1.length > v2.length ? 1 : -1;
            }
            return compareTo;
        }
    }

    static class IssueComparator
    implements Comparator<Issue> {
        IssueComparator() {
        }

        @Override
        public int compare(Issue i1, Issue i2) {
            return i1.getId().compareTo(i2.getId());
        }
    }
}

