/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeval.function;

import java.util.ArrayList;
import net.sourceforge.jeval.ArgumentTokenizer;
import net.sourceforge.jeval.function.FunctionException;

public class FunctionHelper {
    public static String trimAndRemoveQuoteChars(String arguments, char quoteCharacter) throws FunctionException {
        String trimmedArgument = arguments;
        if ((trimmedArgument = trimmedArgument.trim()).charAt(0) != quoteCharacter) {
            throw new FunctionException("Value does not start with a quote.");
        }
        trimmedArgument = trimmedArgument.substring(1, trimmedArgument.length());
        if (trimmedArgument.charAt(trimmedArgument.length() - 1) != quoteCharacter) {
            throw new FunctionException("Value does not end with a quote.");
        }
        trimmedArgument = trimmedArgument.substring(0, trimmedArgument.length() - 1);
        return trimmedArgument;
    }

    public static ArrayList getDoubles(String arguments, char delimiter) throws FunctionException {
        ArrayList<Double> returnValues = new ArrayList<Double>();
        try {
            ArgumentTokenizer tokenizer = new ArgumentTokenizer(arguments, delimiter);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken().trim();
                returnValues.add(new Double(token));
            }
        }
        catch (Exception e) {
            throw new FunctionException("Invalid values in string.", e);
        }
        return returnValues;
    }

    public static ArrayList getStrings(String arguments, char delimiter) throws FunctionException {
        ArrayList<String> returnValues = new ArrayList<String>();
        try {
            ArgumentTokenizer tokenizer = new ArgumentTokenizer(arguments, delimiter);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                returnValues.add(token);
            }
        }
        catch (Exception e) {
            throw new FunctionException("Invalid values in string.", e);
        }
        return returnValues;
    }

    public static ArrayList getOneStringAndOneInteger(String arguments, char delimiter) throws FunctionException {
        ArrayList<Object> returnValues = new ArrayList<Object>();
        try {
            ArgumentTokenizer tokenizer = new ArgumentTokenizer(arguments, delimiter);
            int tokenCtr = 0;
            while (tokenizer.hasMoreTokens()) {
                String token;
                if (tokenCtr == 0) {
                    token = tokenizer.nextToken();
                    returnValues.add(token);
                } else if (tokenCtr == 1) {
                    token = tokenizer.nextToken().trim();
                    returnValues.add(new Integer(new Double(token).intValue()));
                } else {
                    throw new FunctionException("Invalid values in string.");
                }
                ++tokenCtr;
            }
        }
        catch (Exception e) {
            throw new FunctionException("Invalid values in string.", e);
        }
        return returnValues;
    }

    public static ArrayList getTwoStringsAndOneInteger(String arguments, char delimiter) throws FunctionException {
        ArrayList<Object> returnValues = new ArrayList<Object>();
        try {
            ArgumentTokenizer tokenizer = new ArgumentTokenizer(arguments, delimiter);
            int tokenCtr = 0;
            while (tokenizer.hasMoreTokens()) {
                String token;
                if (tokenCtr == 0 || tokenCtr == 1) {
                    token = tokenizer.nextToken();
                    returnValues.add(token);
                } else if (tokenCtr == 2) {
                    token = tokenizer.nextToken().trim();
                    returnValues.add(new Integer(new Double(token).intValue()));
                } else {
                    throw new FunctionException("Invalid values in string.");
                }
                ++tokenCtr;
            }
        }
        catch (Exception e) {
            throw new FunctionException("Invalid values in string.", e);
        }
        return returnValues;
    }

    public static ArrayList getOneStringAndTwoIntegers(String arguments, char delimiter) throws FunctionException {
        ArrayList<Object> returnValues = new ArrayList<Object>();
        try {
            ArgumentTokenizer tokenizer = new ArgumentTokenizer(arguments, delimiter);
            int tokenCtr = 0;
            while (tokenizer.hasMoreTokens()) {
                String token;
                if (tokenCtr == 0) {
                    token = tokenizer.nextToken().trim();
                    returnValues.add(token);
                } else if (tokenCtr == 1 || tokenCtr == 2) {
                    token = tokenizer.nextToken().trim();
                    returnValues.add(new Integer(new Double(token).intValue()));
                } else {
                    throw new FunctionException("Invalid values in string.");
                }
                ++tokenCtr;
            }
        }
        catch (Exception e) {
            throw new FunctionException("Invalid values in string.", e);
        }
        return returnValues;
    }
}

