/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeval;

import java.util.Enumeration;

public class ArgumentTokenizer
implements Enumeration {
    public final char defaultDelimiter = (char)44;
    private String arguments = null;
    private char delimiter = (char)44;

    public ArgumentTokenizer(String arguments, char delimiter) {
        this.arguments = arguments;
        this.delimiter = delimiter;
    }

    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public boolean hasMoreTokens() {
        return this.arguments.length() > 0;
    }

    public Object nextElement() {
        return this.nextToken();
    }

    public String nextToken() {
        int size = this.arguments.length();
        int parenthesesCtr = 0;
        String returnArgument = null;
        for (int charCtr = 0; charCtr < size; ++charCtr) {
            if (this.arguments.charAt(charCtr) == '(') {
                ++parenthesesCtr;
                continue;
            }
            if (this.arguments.charAt(charCtr) == ')') {
                --parenthesesCtr;
                continue;
            }
            if (this.arguments.charAt(charCtr) != this.delimiter || parenthesesCtr != 0) continue;
            returnArgument = this.arguments.substring(0, charCtr);
            this.arguments = this.arguments.substring(charCtr + 1);
            break;
        }
        if (returnArgument == null) {
            returnArgument = this.arguments;
            this.arguments = "";
        }
        return returnArgument;
    }
}

