/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.vaadin.ui.sqlexplorer;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.menubar.MenuBar;
import com.vaadin.flow.component.menubar.MenuBarVariant;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.util.Map;
import org.jumpmind.db.model.Trigger;
import org.jumpmind.vaadin.ui.common.Label;
import org.jumpmind.vaadin.ui.common.ReadOnlyTextAreaDialog;
import org.jumpmind.vaadin.ui.sqlexplorer.Settings;
import org.jumpmind.vaadin.ui.sqlexplorer.TriggerInfoPanel;

public class TriggerTableLayout
extends VerticalLayout {
    private static final long serialVersionUID = 1L;
    private Trigger trigger;
    private Grid<String> grid;
    private TriggerInfoPanel.Refresher refresher;

    public TriggerTableLayout(Trigger trigger, Settings settings, TriggerInfoPanel.Refresher refresher) {
        this.trigger = trigger;
        this.refresher = refresher;
        this.createTabularLayout();
    }

    public void createTabularLayout() {
        this.setSizeFull();
        this.setSpacing(false);
        HorizontalLayout bar = new HorizontalLayout();
        bar.getStyle().set("margin", "0 16px");
        HorizontalLayout leftBar = new HorizontalLayout();
        leftBar.setSpacing(true);
        leftBar.add(new Component[]{new Label(this.trigger.getFullyQualifiedName())});
        bar.addAndExpand(new Component[]{leftBar});
        bar.setVerticalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{leftBar});
        MenuBar rightBar = new MenuBar();
        rightBar.addThemeVariants((ThemeVariant[])new MenuBarVariant[]{MenuBarVariant.LUMO_TERTIARY, MenuBarVariant.LUMO_SMALL});
        rightBar.addItem((Component)new Icon(VaadinIcon.REFRESH), (ComponentEventListener & Serializable)event -> this.refresher.refresh());
        bar.add(new Component[]{rightBar});
        bar.setVerticalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{rightBar});
        this.add(new Component[]{bar});
        this.grid = this.fillGrid();
        this.grid.setSizeFull();
        this.grid.addItemClickListener((ComponentEventListener & Serializable)event -> {
            if (event.getButton() == 0 && event.getColumn() != null) {
                if (event.getClickCount() == 2) {
                    String colKey = event.getColumn().getKey();
                    if (colKey.equals("property")) {
                        ReadOnlyTextAreaDialog.show("Property", (String)event.getItem(), false);
                    } else if (colKey.equals("value")) {
                        ReadOnlyTextAreaDialog.show("Value", (String)this.trigger.getMetaData().get(event.getItem()), false);
                    }
                } else {
                    this.grid.deselectAll();
                    this.grid.select((Object)((String)event.getItem()));
                }
            }
        });
        this.addAndExpand(new Component[]{this.grid});
    }

    private Grid<String> fillGrid() {
        Grid grid = new Grid();
        grid.setSelectionMode(Grid.SelectionMode.MULTI);
        grid.setColumnReorderingAllowed(false);
        Map metaData = this.trigger.getMetaData();
        grid.addColumn((ValueProvider & Serializable)property -> property).setKey("property").setHeader("Property").setWidth("250px");
        grid.addColumn((ValueProvider & Serializable)property -> String.valueOf(metaData.get(property))).setKey("value").setHeader("Value");
        for (Grid.Column column : grid.getColumns()) {
            column.setResizable(true);
        }
        grid.setItems(metaData.keySet());
        return grid;
    }
}

