/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.vaadin.ui.sqlexplorer;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.contextmenu.MenuItem;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.menubar.MenuBar;
import com.vaadin.flow.component.menubar.MenuBarVariant;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.progressbar.ProgressBar;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.tabs.Tabs;
import de.f0rce.ace.AceEditor;
import de.f0rce.ace.enums.AceMode;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import org.jumpmind.db.model.Trigger;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;
import org.jumpmind.vaadin.ui.common.TabSheet;
import org.jumpmind.vaadin.ui.sqlexplorer.IDb;
import org.jumpmind.vaadin.ui.sqlexplorer.IInfoPanel;
import org.jumpmind.vaadin.ui.sqlexplorer.Settings;
import org.jumpmind.vaadin.ui.sqlexplorer.TriggerTableLayout;

public class TriggerInfoPanel
extends VerticalLayout
implements IInfoPanel {
    private static final long serialVersionUID = 1L;
    TabSheet tabSheet;
    String selectedCaption;
    boolean wrapSourceText;

    public TriggerInfoPanel(Trigger trigger, IDb db, Settings settings, String selectedTabCaption) {
        this.setSizeFull();
        this.tabSheet = CommonUiUtils.createTabSheet();
        this.tabSheet.addSelectedTabChangeListener((ComponentEventListener<Tabs.SelectedChangeEvent>)(ComponentEventListener & Serializable)event -> {
            TabSheet.EnhancedTab tab = this.tabSheet.getSelectedTab();
            if (tab != null) {
                this.selectedCaption = tab.getName();
            }
        });
        this.add(new Component[]{this.tabSheet});
        this.refreshSource(trigger);
        this.refreshDetails(trigger, db, settings);
        Iterator<Component> i = this.tabSheet.iterator();
        while (i.hasNext()) {
            Component component = i.next();
            TabSheet.EnhancedTab tab = this.tabSheet.getTab(component);
            if (!tab.getName().equals(selectedTabCaption)) continue;
            this.tabSheet.setSelectedTab(component);
            break;
        }
    }

    @Override
    public String getSelectedTabCaption() {
        return this.selectedCaption;
    }

    protected void refreshSource(Trigger trigger) {
        VerticalLayout source = new VerticalLayout();
        source.setSizeFull();
        source.setSpacing(false);
        String sourceText = trigger.getSource();
        if (this.wrapSourceText) {
            sourceText = this.wrapSource(sourceText);
        }
        AceEditor editor = CommonUiUtils.createAceEditor();
        editor.setMode(AceMode.sql);
        editor.setValue(sourceText);
        editor.setSizeFull();
        source.addAndExpand(new Component[]{editor});
        HorizontalLayout bar = new HorizontalLayout();
        bar.setWidthFull();
        bar.getStyle().set("margin", "0 16px");
        MenuBar wrapSelect = new MenuBar();
        wrapSelect.addThemeVariants((ThemeVariant[])new MenuBarVariant[]{MenuBarVariant.LUMO_TERTIARY, MenuBarVariant.LUMO_SMALL});
        MenuItem wrapButton = wrapSelect.addItem("Wrap text", (ComponentEventListener & Serializable)event -> {
            this.wrapSourceText = !this.wrapSourceText;
            this.tabSheet.remove(this.tabSheet.getTab(1));
            this.refreshSource(trigger);
        });
        wrapButton.addComponentAsFirst((Component)new Icon(VaadinIcon.ALIGN_JUSTIFY));
        bar.add(new Component[]{wrapSelect});
        bar.setVerticalComponentAlignment(FlexComponent.Alignment.START, new Component[]{wrapSelect});
        bar.setHeight("2.5rem");
        source.add(new Component[]{bar});
        this.tabSheet.add((Component)source, "Source");
        this.tabSheet.setSelectedTab((Component)source);
    }

    private String wrapSource(String source) {
        String moreWrapped;
        Object wrappedText = source;
        wrappedText = " " + ((String)wrappedText).replace('\n', ' ').trim() + " ";
        while (!(moreWrapped = ((String)wrappedText).replace("  ", " ")).equals(wrappedText)) {
            wrappedText = moreWrapped;
        }
        int indentCount = 0;
        int lastNewLineIndex = 0;
        boolean singleQuote = false;
        boolean doubleQuote = false;
        String[] incIndentBeforeTerms = new String[]{};
        String[] incIndentAfterTerms = new String[]{"begin", "case when", "delete from", "drop", "else", "if", "select"};
        String[] decIndentBeforeTerms = new String[]{"end if", "end", "else"};
        String[] decIndentAfterTerms = new String[]{};
        String[] noIndentTerms = new String[]{"after", "before", "call", "create", "declare", "for each row", "instead of", "return", "start", "then", "when", "where"};
        String[] noNewLineAfterTerms = new String[]{"after", "before", "call", "create", "declare", "delete from", "drop", "if", "instead of", "select", "start"};
        String[] noNewLineBeforeTerms = new String[]{"then"};
        String[] allTerms = this.concatAll(incIndentBeforeTerms, incIndentAfterTerms, decIndentBeforeTerms, decIndentAfterTerms, noIndentTerms);
        block1: for (int i = 0; i < ((String)wrappedText).length() - 1; ++i) {
            boolean isInQuotes;
            if (((String)wrappedText).charAt(i) == '\"') {
                doubleQuote = !(singleQuote || doubleQuote && ((String)wrappedText).charAt(i - 1) != '\\');
            } else if (((String)wrappedText).charAt(i) == '\'') {
                singleQuote = !doubleQuote && (!singleQuote || ((String)wrappedText).charAt(i - 1) == '\\');
            }
            boolean bl = isInQuotes = singleQuote || doubleQuote;
            if (!isInQuotes && ((String)wrappedText).charAt(i) == ';') {
                wrappedText = this.insertNewLine((String)wrappedText, i, indentCount);
                lastNewLineIndex = i;
                i += 4 * indentCount;
            } else if (!isInQuotes && ((String)wrappedText).charAt(i) == '(') {
                indentCount += 2;
            } else if (!isInQuotes && ((String)wrappedText).charAt(i) == ')') {
                indentCount -= 2;
            }
            if (i - lastNewLineIndex > 100) {
                int lookBack;
                if (isInQuotes) {
                    int lookBack2;
                    for (lookBack2 = 0; lookBack2 < i && ((String)wrappedText).charAt(i - lookBack2) != '\"' && ((String)wrappedText).charAt(i - lookBack2) != '\''; ++lookBack2) {
                    }
                    if (i - lookBack2 <= lastNewLineIndex + 1) continue;
                    wrappedText = this.insertNewLine((String)wrappedText, i - lookBack2, indentCount);
                    lastNewLineIndex = i - lookBack2;
                    i += 4 * indentCount + 1;
                    continue;
                }
                for (lookBack = 0; lookBack < i && ((String)wrappedText).charAt(i - lookBack) != ',' && ((String)wrappedText).charAt(i - lookBack) != '.' && ((String)wrappedText).charAt(i - lookBack) != ' ' && ((String)wrappedText).charAt(i - lookBack) != '\"' && ((String)wrappedText).charAt(i - lookBack) != '\''; ++lookBack) {
                }
                if (i - lookBack <= lastNewLineIndex + 1) continue;
                wrappedText = this.insertNewLine((String)wrappedText, i - lookBack + 1, indentCount);
                lastNewLineIndex = i - lookBack + 1;
                i += 4 * indentCount + 1;
                continue;
            }
            for (String term : allTerms) {
                if (i + term.length() >= ((String)wrappedText).length() || isInQuotes || !this.termAppearsIn((String)wrappedText, term, i)) continue;
                if (Arrays.asList(incIndentBeforeTerms).contains(term)) {
                    ++indentCount;
                } else if (Arrays.asList(decIndentBeforeTerms).contains(term)) {
                    --indentCount;
                }
                if (!Arrays.asList(noNewLineBeforeTerms).contains(term)) {
                    wrappedText = this.insertNewLine((String)wrappedText, i, indentCount);
                    lastNewLineIndex = i;
                    i += 4 * indentCount;
                }
                i += term.length();
                if (Arrays.asList(incIndentAfterTerms).contains(term)) {
                    ++indentCount;
                } else if (Arrays.asList(decIndentAfterTerms).contains(term)) {
                    --indentCount;
                }
                if (!Arrays.asList(noNewLineAfterTerms).contains(term)) {
                    wrappedText = this.insertNewLine((String)wrappedText, i + 1, indentCount);
                    lastNewLineIndex = i;
                    i += 4 * indentCount;
                }
                --i;
                continue block1;
            }
        }
        return ((String)wrappedText).trim();
    }

    private String[] concatAll(String[] ... arrays) {
        int size = 0;
        int index = 0;
        for (String[] array : arrays) {
            size += array.length;
        }
        String[] all = new String[size];
        for (String[] array : arrays) {
            System.arraycopy(array, 0, all, index, array.length);
            index += array.length;
        }
        return all;
    }

    private boolean termAppearsIn(String str, String term, int index) {
        return str.regionMatches(true, index, term, 0, term.length()) && (index == 0 || !Character.isLetter(str.charAt(index - 1)) && str.charAt(index - 1) != '@' && str.charAt(index - 1) != '$' && str.charAt(index - 1) != '#' && str.charAt(index - 1) != '_') && (index + term.length() >= str.length() || !Character.isLetter(str.charAt(index + term.length())) && str.charAt(index + term.length()) != '@' && str.charAt(index + term.length()) != '$' && str.charAt(index + term.length()) != '#' && str.charAt(index + term.length()) != '_');
    }

    private String insertNewLine(String str, int index, int indentCount) {
        if (str.charAt(index) == ';') {
            ++index;
        }
        String text = str.substring(0, index) + "\n";
        for (int j = 0; j < indentCount; ++j) {
            text = text + "    ";
        }
        if (str.charAt(index) == ' ') {
            ++index;
        }
        text = text + str.substring(index);
        return text;
    }

    protected void refreshDetails(final Trigger trigger, final IDb db, final Settings settings) {
        HorizontalLayout executingLayout = new HorizontalLayout();
        executingLayout.setSizeFull();
        ProgressBar p = new ProgressBar();
        p.setIndeterminate(true);
        executingLayout.add(new Component[]{p});
        this.tabSheet.add((Component)executingLayout, "Details", new Icon(VaadinIcon.SPINNER), 0);
        this.tabSheet.setSelectedTab((Component)executingLayout);
        TriggerTableLayout triggerTable = new TriggerTableLayout(trigger, settings, new Refresher(){

            @Override
            public void refresh() {
                TriggerInfoPanel.this.tabSheet.remove(TriggerInfoPanel.this.tabSheet.getTab(0));
                TriggerInfoPanel.this.refreshDetails(trigger, db, settings);
            }
        });
        boolean select = executingLayout.equals(this.tabSheet.getSelectedTab().getComponent());
        this.tabSheet.remove("Details");
        VerticalLayout layout = new VerticalLayout();
        layout.setMargin(true);
        layout.setSizeFull();
        layout.add(new Component[]{triggerTable});
        this.tabSheet.add((Component)layout, "Details", null, 0);
        if (select) {
            this.tabSheet.setSelectedTab((Component)layout);
        }
    }

    @Override
    public void selected() {
    }

    @Override
    public void unselected() {
    }

    public class Refresher {
        public void refresh() {
        }
    }
}

