/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.vaadin.ui.sqlexplorer;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.Shortcuts;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.contextmenu.ContextMenu;
import com.vaadin.flow.component.contextmenu.MenuItem;
import com.vaadin.flow.component.contextmenu.SubMenu;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.editor.Editor;
import com.vaadin.flow.component.grid.editor.EditorOpenListener;
import com.vaadin.flow.component.grid.editor.EditorSaveListener;
import com.vaadin.flow.component.html.Anchor;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.menubar.MenuBar;
import com.vaadin.flow.component.menubar.MenuBarVariant;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.notification.NotificationVariant;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.Setter;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.server.Command;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.ForeignKey;
import org.jumpmind.db.model.Reference;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.DatabaseInfo;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.IDdlReader;
import org.jumpmind.db.sql.SqlException;
import org.jumpmind.properties.TypedProperties;
import org.jumpmind.util.FormatUtils;
import org.jumpmind.vaadin.ui.common.ColumnVisibilityToggler;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;
import org.jumpmind.vaadin.ui.common.CsvExport;
import org.jumpmind.vaadin.ui.common.GridDataProvider;
import org.jumpmind.vaadin.ui.common.IDataProvider;
import org.jumpmind.vaadin.ui.common.Label;
import org.jumpmind.vaadin.ui.common.NotifyDialog;
import org.jumpmind.vaadin.ui.sqlexplorer.IDb;
import org.jumpmind.vaadin.ui.sqlexplorer.QueryPanel;
import org.jumpmind.vaadin.ui.sqlexplorer.Settings;
import org.jumpmind.vaadin.ui.sqlexplorer.SqlExplorer;
import org.jumpmind.vaadin.ui.sqlexplorer.SqlRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabularResultLayout
extends VerticalLayout {
    private static final long serialVersionUID = 1L;
    final String ACTION_SELECT = "Select From";
    final String ACTION_INSERT = "Insert";
    final String ACTION_UPDATE = "Update";
    final String ACTION_DELETE = "Delete";
    final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    SqlExplorer explorer;
    QueryPanel queryPanel;
    String tableName;
    String catalogName;
    String schemaName;
    Grid<List<Object>> grid;
    Map<Integer, String> columnNameMap;
    Map<Grid.Column<List<Object>>, ValueProvider<List<Object>, Object>> valueProviderMap;
    Table resultTable;
    String sql;
    ResultSet rs;
    ResultSetMetaData meta;
    IDb db;
    SqlRunner.ISqlRunnerListener listener;
    String user;
    Settings settings;
    boolean showSql = true;
    boolean isInQueryGeneralResults;
    boolean generateNewExport = true;
    MenuItem followToMenu;
    MenuItem toggleKeepResultsButton;
    ColumnVisibilityToggler columnVisibilityToggler;
    Label resultLabel;

    public TabularResultLayout(IDb db, String sql, ResultSet rs, SqlRunner.ISqlRunnerListener listener, Settings settings, boolean showSql) throws SQLException {
        this(null, db, sql, rs, listener, null, settings, null, showSql, false);
    }

    public TabularResultLayout(SqlExplorer explorer, IDb db, String sql, ResultSet rs, SqlRunner.ISqlRunnerListener listener, String user, Settings settings, QueryPanel queryPanel, boolean showSql, boolean isInQueryGeneralResults) throws SQLException {
        this.explorer = explorer;
        this.sql = sql;
        this.showSql = showSql;
        this.db = db;
        this.rs = rs;
        this.meta = rs.getMetaData();
        this.listener = listener;
        this.user = user;
        this.settings = settings;
        this.queryPanel = queryPanel;
        this.isInQueryGeneralResults = isInQueryGeneralResults;
        this.createTabularResultLayout();
    }

    public String getSql() {
        return this.sql;
    }

    public void setShowSql(boolean showSql) {
        this.showSql = showSql;
    }

    protected void createTabularResultLayout() {
        this.setSizeFull();
        this.setSpacing(false);
        this.setMargin(false);
        this.getStyle().set("padding-bottom", "0");
        this.createMenuBar();
        try {
            this.columnNameMap = new HashMap<Integer, String>();
            for (int i = 0; i < this.meta.getColumnCount(); ++i) {
                String realColumnName = this.meta.getColumnName(i + 1);
                Object columnName = realColumnName;
                int j = 1;
                while (this.columnNameMap.containsValue(columnName)) {
                    columnName = realColumnName + "_" + j++;
                }
                this.columnNameMap.put(i, (String)columnName);
            }
            this.grid = this.putResultsInGrid(this.settings.getProperties().getInt("sql.explorer.max.results"));
            this.grid.setSizeFull();
            ContextMenu menu = new ContextMenu(this.grid);
            menu.addItem("Select From", (ComponentEventListener & Serializable)event -> this.handleAction("Select From"));
            menu.addItem("Insert", (ComponentEventListener & Serializable)event -> this.handleAction("Insert"));
            menu.addItem("Update", (ComponentEventListener & Serializable)event -> this.handleAction("Update"));
            menu.addItem("Delete", (ComponentEventListener & Serializable)event -> this.handleAction("Delete"));
            if (this.resultTable != null && this.resultTable.getForeignKeyCount() > 0) {
                this.followToMenu = menu.addItem("Follow to", null);
                this.buildFollowToMenu();
            }
            Editor editor = this.grid.getEditor();
            Binder binder = new Binder();
            int i = 0;
            for (Grid.Column col : this.grid.getColumns()) {
                String colId = col.getKey();
                if (colId != null && colId.equals("#")) continue;
                Integer index = i;
                TextField field = new TextField();
                binder.bind((HasValue)field, (ValueProvider & Serializable)list -> list.get(index).toString(), (Setter & Serializable)(list, value) -> list.set(index, value));
                col.setEditorComponent((Component)field);
                ++i;
            }
            editor.setBinder(binder);
            if (this.resultTable != null) {
                List[] unchangedValue = new List[1];
                Object[] pkParams = new Object[this.resultTable.getPrimaryKeyColumnCount()];
                int[] pkTypes = new int[pkParams.length];
                editor.addOpenListener((EditorOpenListener & Serializable)event -> {
                    unchangedValue[0] = new ArrayList((Collection)event.getItem());
                    int paramCount = 0;
                    for (int j = 0; j < unchangedValue[0].size(); ++j) {
                        if (this.resultTable.getPrimaryKeyColumnIndex(this.columnNameMap.get(j)) < 0) continue;
                        pkParams[paramCount] = unchangedValue[0].get(j);
                        pkTypes[paramCount] = this.resultTable.getColumnWithName(this.columnNameMap.get(j)).getMappedTypeCode();
                        ++paramCount;
                    }
                });
                editor.addSaveListener((EditorSaveListener & Serializable)event -> {
                    int[] allTypes;
                    Object[] allParams;
                    this.grid.setItems(this.grid.getDataProvider());
                    List row = (List)event.getItem();
                    ArrayList<String> colNames = new ArrayList<String>();
                    ArrayList params = new ArrayList();
                    ArrayList<Integer> types = new ArrayList<Integer>();
                    for (int j = 0; j < row.size(); ++j) {
                        String colName = this.columnNameMap.get(j);
                        Object param = row.get(j);
                        String originalValue = unchangedValue[0].get(j).toString();
                        if (param == null && originalValue == null || param != null && param.equals(originalValue)) continue;
                        colNames.add(colName);
                        params.add(param);
                        types.add(this.resultTable.getColumnWithName(colName).getMappedTypeCode());
                    }
                    String sql = this.buildUpdate(this.resultTable, colNames, unchangedValue[0], this.resultTable.getPrimaryKeyColumnNames());
                    this.log.warn(sql);
                    if (pkParams.length > 0) {
                        allParams = ArrayUtils.addAll((Object[])params.toArray(), (Object[])pkParams);
                        allTypes = ArrayUtils.addAll((int[])types.stream().mapToInt(val -> val).toArray(), (int[])pkTypes);
                        for (int k = 0; k < allTypes.length; ++k) {
                            if (allTypes[k] != 91 || !this.db.getPlatform().getDdlBuilder().getDatabaseInfo().isDateOverridesToTimestamp()) continue;
                            allTypes[k] = 93;
                        }
                    } else {
                        ArrayList requiredColParams = new ArrayList();
                        ArrayList<Integer> requiredColTypes = new ArrayList<Integer>();
                        for (int k = 0; k < unchangedValue[0].size(); ++k) {
                            Object val2 = unchangedValue[0].get(k);
                            Column col = this.resultTable.getColumn(k);
                            if (!this.db.getPlatform().canColumnBeUsedInWhereClause(col) || val2.equals("<null>")) continue;
                            requiredColParams.add(val2);
                            requiredColTypes.add(col.getMappedTypeCode());
                        }
                        allParams = ArrayUtils.addAll((Object[])params.toArray(), (Object[])requiredColParams.toArray());
                        allTypes = ArrayUtils.addAll((int[])types.stream().mapToInt(val -> val).toArray(), (int[])requiredColTypes.stream().mapToInt(l -> l).toArray());
                    }
                    try {
                        this.db.getPlatform().getSqlTemplate().update(sql, allParams, allTypes);
                    }
                    catch (SqlException e) {
                        NotifyDialog.show("Error", "<b>The table could not be updated.</b><br>Cause: the sql update statement failed to execute.<br><br>To view the <b>Stack Trace</b>, click <b>\"Details\"</b>.", e, NotificationVariant.LUMO_ERROR);
                    }
                });
                if (this.settings.isAllowDml()) {
                    CommonUiUtils.configureEditor(this.grid);
                }
            }
            Shortcuts.addShortcutListener(this.grid, (Command & Serializable)() -> {
                Component parent = this.grid.getParent().orElse(null);
                if (parent != null && parent instanceof TabularResultLayout) {
                    TabularResultLayout layout = (TabularResultLayout)parent;
                    this.queryPanel.reExecute(layout.getSql());
                }
            }, (Key)Key.ENTER, (KeyModifier[])new KeyModifier[]{KeyModifier.CONTROL}).listenOn(new Component[]{this.grid});
            Shortcuts.addShortcutListener(this.grid, (Command & Serializable)() -> {
                TabularResultLayout layout = this.grid.getParent().orElse(null);
                if (layout != null) {
                    this.queryPanel.reExecute(layout.getSql());
                }
            }, (Key)Key.ENTER, (KeyModifier[])new KeyModifier[]{KeyModifier.CONTROL, KeyModifier.SHIFT}).listenOn(new Component[]{this.grid});
            this.addAndExpand(new Component[]{this.grid});
            long count = this.grid.getDataProvider().fetch(new Query()).count();
            int maxResultsSize = this.settings.getProperties().getInt("sql.explorer.max.results");
            if (count >= (long)maxResultsSize) {
                this.resultLabel.setText("Limited to <span style='color: red'>" + maxResultsSize + "</span> rows;");
            } else {
                this.resultLabel.setText(count + " rows returned;");
            }
        }
        catch (SQLException ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            CommonUiUtils.notifyError();
        }
    }

    private void createMenuBar() {
        HorizontalLayout resultBar = new HorizontalLayout();
        resultBar.getStyle().set("margin", "0 16px");
        HorizontalLayout leftBar = new HorizontalLayout();
        leftBar.setSpacing(true);
        this.resultLabel = new Label("");
        leftBar.add(new Component[]{this.resultLabel});
        Span sqlSpan = new Span("");
        sqlSpan.setWidth("800px");
        leftBar.add(new Component[]{sqlSpan});
        resultBar.addAndExpand(new Component[]{leftBar});
        resultBar.setVerticalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{leftBar});
        MenuBar rightBar = new MenuBar();
        rightBar.addThemeVariants((ThemeVariant[])new MenuBarVariant[]{MenuBarVariant.LUMO_TERTIARY, MenuBarVariant.LUMO_SMALL});
        MenuItem refreshButton = rightBar.addItem((Component)new Icon(VaadinIcon.REFRESH), (ComponentEventListener & Serializable)event -> this.listener.reExecute(this.sql));
        refreshButton.getElement().setAttribute("title", "Refresh");
        Anchor downloadAnchor = new Anchor();
        downloadAnchor.setTarget("_blank");
        downloadAnchor.getElement().setAttribute("download", true);
        Icon downloadIcon = new Icon(VaadinIcon.UPLOAD);
        downloadIcon.setSize("16px");
        downloadIcon.addClickListener((ComponentEventListener & Serializable)event -> {
            if (this.generateNewExport) {
                GridDataProvider<List<Object>> target = new GridDataProvider<List<Object>>(this.grid, this.valueProviderMap);
                CsvExport<List<Object>> csvExport = null;
                if (target instanceof IDataProvider) {
                    csvExport = new CsvExport<List<Object>>(target);
                    csvExport.setFileName(this.db.getName() + "-export.csv");
                    csvExport.setTitle(this.sql);
                    downloadAnchor.setHref(csvExport.getDownloadHandler());
                }
                this.generateNewExport = false;
                UI.getCurrent().getPage().executeJs("$0.click();", new Serializable[]{downloadAnchor.getElement()});
            } else {
                downloadAnchor.removeHref();
                this.generateNewExport = true;
            }
        });
        downloadAnchor.add(new Component[]{downloadIcon});
        MenuItem exportButton = rightBar.addItem((Component)downloadAnchor);
        exportButton.getElement().setAttribute("title", "Export Results");
        if (this.isInQueryGeneralResults) {
            MenuItem keepResultsButton = rightBar.addItem((Component)new Icon(VaadinIcon.COPY), (ComponentEventListener & Serializable)event -> {
                this.queryPanel.addResultsTab((Component)this.refreshWithoutSaveButton(), StringUtils.abbreviate((String)this.sql, (int)20), this.queryPanel.getGeneralResultsTab().getIcon());
                this.queryPanel.resetGeneralResultsTab();
            });
            keepResultsButton.getElement().setAttribute("title", "Save these results to a new tab");
        }
        if (this.showSql) {
            sqlSpan.setText(StringUtils.abbreviate((String)this.sql, (int)200));
        }
        resultBar.add(new Component[]{rightBar});
        resultBar.setVerticalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{rightBar});
        this.columnVisibilityToggler = new ColumnVisibilityToggler();
        resultBar.add(new Component[]{this.columnVisibilityToggler});
        resultBar.setVerticalComponentAlignment(FlexComponent.Alignment.END, new Component[]{this.columnVisibilityToggler});
        this.addComponentAsFirst((Component)resultBar);
    }

    protected TabularResultLayout refreshWithoutSaveButton() {
        this.isInQueryGeneralResults = false;
        this.remove(new Component[]{this.getComponentAt(0)});
        this.createMenuBar();
        return this;
    }

    protected void handleAction(String action) {
        try {
            DatabaseInfo dbInfo = this.db.getPlatform().getDatabaseInfo();
            String quote = this.db.getPlatform().getDdlBuilder().isDelimitedIdentifierModeOn() ? dbInfo.getDelimiterToken() : "";
            String catalogSeparator = dbInfo.getCatalogSeparator();
            String schemaSeparator = dbInfo.getSchemaSeparator();
            String[] columnHeaders = (String[])ArrayUtils.removeElement((Object[])CommonUiUtils.getHeaderCaptions(this.grid), null);
            Set selectedRowsSet = this.grid.getSelectedItems();
            Iterator setIterator = selectedRowsSet.iterator();
            while (setIterator.hasNext()) {
                Column col;
                int i;
                ArrayList typeValueList = new ArrayList();
                List item = (List)setIterator.next();
                for (int i2 = 1; i2 < columnHeaders.length; ++i2) {
                    Object typeValue = item.get(i2 - 1);
                    if (typeValue instanceof String) {
                        typeValue = "<null>".equals(typeValue) || "".equals(typeValue) ? "null" : "'" + String.valueOf(typeValue) + "'";
                    } else if (typeValue instanceof Date) {
                        typeValue = "{ts '" + FormatUtils.TIMESTAMP_FORMATTER.format(typeValue) + "'}";
                    }
                    typeValueList.add(typeValue);
                }
                if (action.equals("Select From")) {
                    StringBuilder sql = new StringBuilder("SELECT ");
                    for (int i3 = 1; i3 < columnHeaders.length; ++i3) {
                        if (i3 == 1) {
                            sql.append(quote).append(columnHeaders[i3]).append(quote);
                            continue;
                        }
                        sql.append(", ").append(quote).append(columnHeaders[i3]).append(quote);
                    }
                    sql.append(" FROM " + Table.getFullyQualifiedTableName((String)this.catalogName, (String)this.schemaName, (String)this.tableName, (String)quote, (String)catalogSeparator, (String)schemaSeparator));
                    sql.append(" WHERE ");
                    int track = 0;
                    for (i = 0; i < this.resultTable.getColumnCount(); ++i) {
                        col = this.resultTable.getColumn(i);
                        if (!col.isPrimaryKey()) continue;
                        if (track == 0) {
                            sql.append(col.getName() + "=" + String.valueOf(typeValueList.get(i)));
                        } else {
                            sql.append(" and ").append(quote).append(col.getName()).append(quote).append("=").append(typeValueList.get(i));
                        }
                        ++track;
                    }
                    sql.append(";");
                    this.listener.writeSql(sql.toString());
                    continue;
                }
                if (action.equals("Insert")) {
                    StringBuilder sql = new StringBuilder();
                    sql.append("INSERT INTO ").append(Table.getFullyQualifiedTableName((String)this.catalogName, (String)this.schemaName, (String)this.tableName, (String)quote, (String)catalogSeparator, (String)schemaSeparator)).append(" (");
                    for (int i4 = 1; i4 < columnHeaders.length; ++i4) {
                        if (i4 == 1) {
                            sql.append(quote + columnHeaders[i4] + quote);
                            continue;
                        }
                        sql.append(", " + quote + columnHeaders[i4] + quote);
                    }
                    sql.append(") VALUES (");
                    boolean first = true;
                    for (i = 1; i < columnHeaders.length; ++i) {
                        if (first) {
                            first = false;
                        } else {
                            sql.append(", ");
                        }
                        sql.append(typeValueList.get(i - 1));
                    }
                    sql.append(");");
                    this.listener.writeSql(sql.toString());
                    continue;
                }
                if (action.equals("Update")) {
                    StringBuilder sql = new StringBuilder("UPDATE ");
                    sql.append(Table.getFullyQualifiedTableName((String)this.catalogName, (String)this.schemaName, (String)this.tableName, (String)quote, (String)catalogSeparator, (String)schemaSeparator) + " SET ");
                    for (int i5 = 1; i5 < columnHeaders.length; ++i5) {
                        if (i5 == 1) {
                            sql.append(quote).append(columnHeaders[i5]).append(quote).append("=");
                        } else {
                            sql.append(", ").append(quote).append(columnHeaders[i5]).append(quote).append("=");
                        }
                        sql.append(typeValueList.get(i5 - 1));
                    }
                    sql.append(" WHERE ");
                    int track = 0;
                    for (i = 0; i < this.resultTable.getColumnCount(); ++i) {
                        col = this.resultTable.getColumn(i);
                        if (!col.isPrimaryKey()) continue;
                        if (track == 0) {
                            sql.append(quote).append(col.getName()).append(quote).append("=").append(typeValueList.get(i));
                        } else {
                            sql.append(" and ").append(quote).append(col.getName()).append(quote).append("=").append(typeValueList.get(i));
                        }
                        ++track;
                    }
                    sql.append(";");
                    this.listener.writeSql(sql.toString());
                    continue;
                }
                if (!action.equals("Delete")) continue;
                StringBuilder sql = new StringBuilder("DELETE FROM ");
                sql.append(Table.getFullyQualifiedTableName((String)this.catalogName, (String)this.schemaName, (String)this.tableName, (String)quote, (String)catalogSeparator, (String)schemaSeparator)).append(" WHERE ");
                int track = 0;
                for (i = 0; i < this.resultTable.getColumnCount(); ++i) {
                    col = this.resultTable.getColumn(i);
                    if (!col.isPrimaryKey()) continue;
                    if (track == 0) {
                        sql.append(quote).append(col.getName()).append(quote).append("=").append(typeValueList.get(i));
                    } else {
                        sql.append(" and ").append(quote).append(col.getName()).append(quote).append("=").append(typeValueList.get(i));
                    }
                    ++track;
                }
                sql.append(";");
                this.listener.writeSql(sql.toString());
            }
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            Notification.show((String)"There are an error while attempting to perform the action.  Please check the log file for further details.");
        }
    }

    protected static String getTypeValue(String type) {
        String value = null;
        value = type.equalsIgnoreCase("CHAR") ? "''" : (type.equalsIgnoreCase("VARCHAR") ? "''" : (type.equalsIgnoreCase("LONGVARCHAR") ? "''" : (type.equalsIgnoreCase("DATE") ? "''" : (type.equalsIgnoreCase("TIME") ? "''" : (type.equalsIgnoreCase("TIMESTAMP") ? "{ts ''}" : (type.equalsIgnoreCase("CLOB") ? "''" : (type.equalsIgnoreCase("BLOB") ? "''" : (type.equalsIgnoreCase("ARRAY") ? "[]" : ""))))))));
        return value;
    }

    protected void buildFollowToMenu() {
        ForeignKey[] foreignKeys;
        for (ForeignKey foreignKey : foreignKeys = this.resultTable.getForeignKeys()) {
            String optionTitle = foreignKey.getForeignTableName() + " (";
            for (Reference ref : foreignKey.getReferences()) {
                optionTitle = optionTitle + ref.getLocalColumnName() + ", ";
            }
            optionTitle = optionTitle.substring(0, optionTitle.length() - 2) + ")";
            ((SubMenu)this.followToMenu.getSubMenu()).addItem(optionTitle, (ComponentEventListener & Serializable)event -> this.followTo(foreignKey));
        }
    }

    protected void followTo(ForeignKey foreignKey) {
        Set selectedRows = this.grid.getSelectedItems();
        if (selectedRows.size() > 0) {
            Reference[] references;
            Table foreignTable;
            this.log.info("Following foreign key to " + foreignKey.getForeignTableName());
            if (this.queryPanel == null) {
                if (this.explorer != null) {
                    this.queryPanel = this.explorer.openQueryWindow(this.db);
                } else {
                    this.log.error("Failed to find current or create new query tab");
                }
            }
            if ((foreignTable = foreignKey.getForeignTable()) == null) {
                foreignTable = this.db.getPlatform().getTableFromCache(foreignKey.getForeignTableName(), false);
            }
            for (Reference ref : references = foreignKey.getReferences()) {
                if (ref.getForeignColumn() != null) continue;
                ref.setForeignColumn(foreignTable.getColumnWithName(ref.getForeignColumnName()));
            }
            String sql = this.createFollowSql(foreignTable, references, selectedRows.size());
            try {
                PreparedStatement ps = ((DataSource)this.db.getPlatform().getDataSource()).getConnection().prepareStatement(sql);
                int i = 1;
                for (List row : selectedRows) {
                    for (Reference ref : references) {
                        Grid.Column col;
                        int colNum = 0;
                        Iterator iterator = this.grid.getColumns().iterator();
                        while (iterator.hasNext() && !(col = (Grid.Column)iterator.next()).getKey().equals(ref.getLocalColumnName())) {
                        }
                        int targetType = ref.getForeignColumn().getMappedTypeCode();
                        ps.setObject(i, row.get(colNum - 1), targetType);
                        ++i;
                    }
                }
                sql = ps.toString().substring(ps.toString().indexOf("select "));
                this.queryPanel.executeSql(sql, false);
            }
            catch (SQLException e) {
                this.log.error("Failed to follow foreign key", (Throwable)e);
            }
        }
    }

    protected String createFollowSql(Table foreignTable, Reference[] references, int selectedRowCount) {
        DatabaseInfo dbInfo = this.db.getPlatform().getDatabaseInfo();
        String quote = this.db.getPlatform().getDdlBuilder().isDelimitedIdentifierModeOn() ? dbInfo.getDelimiterToken() : "";
        StringBuilder sql = new StringBuilder("select ");
        for (Column col : foreignTable.getColumns()) {
            sql.append(quote);
            sql.append(col.getName());
            sql.append(quote);
            sql.append(", ");
        }
        sql.delete(sql.length() - 2, sql.length());
        sql.append(" from ");
        sql.append(foreignTable.getQualifiedTableName(quote, dbInfo.getCatalogSeparator(), dbInfo.getSchemaSeparator()));
        sql.append(" where ");
        StringBuilder whereClause = new StringBuilder("(");
        for (Reference ref : references) {
            whereClause.append(ref.getForeignColumnName());
            whereClause.append("=? and ");
        }
        whereClause.delete(whereClause.length() - 5, whereClause.length());
        whereClause.append(") or ");
        for (int i = 0; i < selectedRowCount; ++i) {
            sql.append(whereClause.toString());
        }
        sql.delete(sql.length() - 4, sql.length());
        return sql.toString();
    }

    protected Grid<List<Object>> putResultsInGrid(int maxResultSize) throws SQLException {
        String separator;
        String parsedSql = this.sql;
        String first = "";
        String second = "";
        String third = "";
        parsedSql = parsedSql.substring(parsedSql.toUpperCase().indexOf("FROM ") + 5, parsedSql.length());
        if ((parsedSql = parsedSql.trim()).contains(separator = ".")) {
            first = parsedSql.substring(0, parsedSql.indexOf(separator) + separator.length() - 1);
            if ((parsedSql = parsedSql.substring(parsedSql.indexOf(separator) + separator.length(), parsedSql.length())).contains(separator)) {
                second = parsedSql.substring(0, parsedSql.indexOf(separator) + separator.length() - 1);
                if ((parsedSql = parsedSql.substring(parsedSql.indexOf(separator) + separator.length(), parsedSql.length())).contains(separator)) {
                    third = parsedSql.substring(0, parsedSql.indexOf(separator) + separator.length() - 1);
                    parsedSql = parsedSql.substring(parsedSql.indexOf(separator) + separator.length(), parsedSql.length());
                } else {
                    third = parsedSql;
                }
            } else {
                second = parsedSql;
            }
        } else {
            first = parsedSql;
        }
        if (!third.equals("")) {
            this.tableName = third;
            this.schemaName = second;
            this.catalogName = first;
        } else if (!second.equals("")) {
            if (this.db.getPlatform().getDefaultCatalog() != null) {
                IDdlReader reader = this.db.getPlatform().getDdlReader();
                List catalogs = reader.getCatalogNames();
                if (catalogs.contains(first)) {
                    this.catalogName = first;
                } else if (this.db.getPlatform().getDefaultSchema() != null) {
                    Iterator iterator = catalogs.iterator();
                    while (iterator.hasNext()) {
                        List schemas = reader.getSchemaNames((String)iterator.next());
                        if (!schemas.contains(first)) continue;
                        this.schemaName = first;
                    }
                }
            } else if (this.db.getPlatform().getDefaultSchema() != null) {
                this.schemaName = first;
            }
            this.tableName = second;
        } else if (!first.equals("")) {
            this.tableName = parsedSql;
        }
        if (StringUtils.isNotBlank((CharSequence)this.tableName)) {
            if (this.tableName.contains(" ")) {
                this.tableName = this.tableName.substring(0, this.tableName.indexOf(" "));
            }
            if (StringUtils.isBlank((CharSequence)this.schemaName)) {
                this.schemaName = null;
            }
            if (StringUtils.isBlank((CharSequence)this.catalogName)) {
                this.catalogName = null;
            }
            String quote = "\"";
            if (this.catalogName != null && this.catalogName.contains(quote)) {
                this.catalogName = this.catalogName.replaceAll(quote, "");
                this.catalogName = this.catalogName.trim();
            }
            if (this.schemaName != null && this.schemaName.contains(quote)) {
                this.schemaName = this.schemaName.replaceAll(quote, "");
                this.schemaName = this.schemaName.trim();
            }
            if (this.tableName != null && this.tableName.contains(quote)) {
                this.tableName = this.tableName.replaceAll(quote, "");
                this.tableName = this.tableName.trim();
            }
            try {
                this.resultTable = this.db.getPlatform().getTableFromCache(this.catalogName, this.schemaName, this.tableName, false);
                if (this.resultTable != null) {
                    this.tableName = this.resultTable.getName();
                    if (StringUtils.isNotBlank((CharSequence)this.catalogName) && StringUtils.isNotBlank((CharSequence)this.resultTable.getCatalog())) {
                        this.catalogName = this.resultTable.getCatalog();
                    }
                    if (StringUtils.isNotBlank((CharSequence)this.schemaName) && StringUtils.isNotBlank((CharSequence)this.resultTable.getSchema())) {
                        this.schemaName = this.resultTable.getSchema();
                    }
                }
            }
            catch (Exception e2) {
                this.log.debug("Failed to lookup table: " + this.tableName, (Throwable)e2);
            }
        }
        TypedProperties properties = this.settings.getProperties();
        boolean showRowNumbers = properties.is("sql.explorer.show.row.numbers");
        String[] excludeValues = this.getColumnsToExclude();
        Grid grid = new Grid();
        grid.setSelectionMode(Grid.SelectionMode.MULTI);
        grid.setColumnReorderingAllowed(true);
        grid.addItemClickListener((ComponentEventListener & Serializable)event -> {
            if (event.getColumn() != null) {
                grid.deselectAll();
                grid.select((Object)((List)event.getItem()));
            }
        });
        ArrayList outerList = new ArrayList();
        if (this.rs != null) {
            ((Grid.Column)((Grid.Column)grid.addColumn((ValueProvider & Serializable)row -> outerList.indexOf(row) + 1).setHeader("#").setKey("#").setFrozen(true)).setFlexGrow(0).setResizable(true)).setVisible(showRowNumbers);
            grid.addAttachListener((ComponentEventListener & Serializable)e -> grid.getElement().executeJs("this.querySelector('vaadin-grid-flow-selection-column').frozen = true", new Serializable[0]));
            if (this.valueProviderMap == null) {
                this.valueProviderMap = new HashMap<Grid.Column<List<Object>>, ValueProvider<List<Object>, Object>>();
            }
            this.valueProviderMap.put((Grid.Column<List<Object>>)grid.getColumnByKey("#"), (ValueProvider<List<Object>, Object>)(ValueProvider & Serializable)row -> outerList.indexOf(row) + 1);
            ResultSetMetaData meta = this.rs.getMetaData();
            int totalColumns = meta.getColumnCount();
            HashSet<Integer> skipColumnIndexes = new HashSet<Integer>();
            HashSet<String> columnNames = new HashSet<String>();
            int[] types = new int[totalColumns];
            int[] columnCounter = new int[]{1};
            while (columnCounter[0] <= totalColumns) {
                String realColumnName = meta.getColumnName(columnCounter[0]);
                Object columnName = realColumnName;
                if (!Arrays.asList(excludeValues).contains(columnName)) {
                    int index = 1;
                    while (columnNames.contains(columnName)) {
                        columnName = realColumnName + "_" + index++;
                    }
                    columnNames.add((String)columnName);
                    Integer colNum = columnCounter[0] - 1 - skipColumnIndexes.size();
                    this.columnVisibilityToggler.addColumn(((Grid.Column)grid.addColumn((ValueProvider & Serializable)row -> row.get(colNum)).setKey((String)columnName).setHeader((String)columnName).setPartNameGenerator((SerializableFunction & Serializable)row -> {
                        if (row.get(colNum) == null) {
                            return "italics";
                        }
                        return null;
                    }).setResizable(true)).setAutoWidth(true), (String)columnName);
                    this.valueProviderMap.put((Grid.Column<List<Object>>)grid.getColumnByKey((String)columnName), (ValueProvider<List<Object>, Object>)(ValueProvider & Serializable)row -> row.get(colNum));
                    types[columnCounter[0] - 1] = meta.getColumnType(columnCounter[0]);
                } else {
                    skipColumnIndexes.add(columnCounter[0] - 1);
                }
                columnCounter[0] = columnCounter[0] + 1;
            }
            for (int rowNumber = 1; this.rs.next() && rowNumber <= maxResultSize; ++rowNumber) {
                ArrayList<Object> innerList = new ArrayList<Object>();
                for (int i = 0; i < totalColumns; ++i) {
                    if (skipColumnIndexes.contains(i)) continue;
                    Object o = CommonUiUtils.getObject(this.rs, i + 1);
                    int type = types[i];
                    switch (type) {
                        case 2: 
                        case 3: 
                        case 6: 
                        case 7: 
                        case 8: {
                            if (o == null || o instanceof BigDecimal) break;
                            o = new BigDecimal(CommonUiUtils.castToNumber(o.toString()));
                            break;
                        }
                        case -6: 
                        case -5: 
                        case 4: 
                        case 5: {
                            if (o == null || o instanceof Long || o instanceof BigInteger) break;
                            o = Long.parseLong(CommonUiUtils.castToNumber(o.toString()));
                            break;
                        }
                    }
                    innerList.add(o == null ? "<null>" : o);
                }
                outerList.add(innerList);
                if (rowNumber < 100) {
                    grid.getColumnByKey("#").setWidth("75px");
                    continue;
                }
                if (rowNumber < 1000) {
                    grid.getColumnByKey("#").setWidth("95px");
                    continue;
                }
                grid.getColumnByKey("#").setWidth("115px");
            }
        } else {
            grid.addColumn((ValueProvider & Serializable)row -> row.get(0)).setHeader("Status").setKey("Status").setResizable(true);
            this.valueProviderMap.put((Grid.Column<List<Object>>)grid.getColumnByKey("Status"), (ValueProvider<List<Object>, Object>)(ValueProvider & Serializable)row -> row.get(0));
            ArrayList<String> innerList = new ArrayList<String>();
            innerList.add("Metadata unavailable");
            outerList.add(innerList);
        }
        grid.setItems(outerList);
        return grid;
    }

    protected String[] getColumnsToExclude() {
        return new String[0];
    }

    protected String buildUpdate(Table table, List<String> columnNames, List<Object> originalValues, String[] pkColumnNames) {
        StringBuilder sql = new StringBuilder("update ");
        IDatabasePlatform platform = this.db.getPlatform();
        DatabaseInfo dbInfo = platform.getDatabaseInfo();
        String quote = platform.getDdlBuilder().isDelimitedIdentifierModeOn() ? dbInfo.getDelimiterToken() : "";
        sql.append(table.getQualifiedTableName(quote, dbInfo.getCatalogSeparator(), dbInfo.getSchemaSeparator()));
        sql.append(" set ");
        for (String col : columnNames) {
            sql.append(quote);
            sql.append(col);
            sql.append(quote);
            sql.append("=?, ");
        }
        sql.delete(sql.length() - 2, sql.length());
        sql.append(" where ");
        if (pkColumnNames.length > 0) {
            for (String col : pkColumnNames) {
                sql.append(quote);
                sql.append(col);
                sql.append(quote);
                sql.append("=? and ");
            }
        } else {
            Column[] cols = table.getColumns();
            for (int i = 0; i < originalValues.size(); ++i) {
                Column col = cols[i];
                if (!platform.canColumnBeUsedInWhereClause(col)) continue;
                sql.append(quote);
                sql.append(col.getName());
                sql.append(quote);
                if (!originalValues.get(i).equals("<null>")) {
                    sql.append("=? and ");
                    continue;
                }
                sql.append(" is null and ");
            }
        }
        sql.delete(sql.length() - 5, sql.length());
        return sql.toString();
    }
}

